<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions" xmlns:xdt="http://www.w3.org/2005/xpath-datatypes" xmlns:ms="urn:schemas-microsoft-com:xslt">
	<xsl:output method="html" version="4.0" encoding="ISO-8859-2" indent="no"/>
	<xsl:variable name="nbsp">&#160;</xsl:variable>
	<xsl:key name="kluczRb27sDzial" match="Pozycje/Pozycja" use="concat(count(ancestor::Jednostka/preceding-sibling::Jednostka), count(ancestor::Rb-27s/preceding-sibling::Rb-27s), Dzial)"/>
	<xsl:key name="kluczRb27sRozdzial" match="Pozycje/Pozycja" use="concat(count(ancestor::Jednostka/preceding-sibling::Jednostka), count(ancestor::Rb-27s/preceding-sibling::Rb-27s), Rozdzial)"/>
	<xsl:key name="kluczRb28sDzial" match="Rb-28s/Pozycje/Pozycja" use="concat(count(ancestor::Jednostka/preceding-sibling::Jednostka), count(ancestor::Rb-28s/preceding-sibling::Rb-28s), Dzial)"/>
	<xsl:key name="kluczRb28sRozdzial" match="Rb-28s/Pozycje/Pozycja" use="concat(count(ancestor::Jednostka/preceding-sibling::Jednostka), count(ancestor::Rb-28s/preceding-sibling::Rb-28s), Rozdzial)"/>
	<xsl:key name="kluczRb27ZZDzial" match="Rb-27ZZ/Pozycje/Pozycja" use="concat(count(ancestor::Jednostka/preceding-sibling::Jednostka), count(ancestor::Rb-27ZZ/preceding-sibling::Rb-27ZZ), Dzial)"/>
	<xsl:key name="kluczRb27ZZRozdzial" match="Rb-27ZZ/Pozycje/Pozycja" use="concat(count(ancestor::Jednostka/preceding-sibling::Jednostka), count(ancestor::Rb-27ZZ/preceding-sibling::Rb-27ZZ), Rozdzial)"/>
	<xsl:key name="kluczRb50DDzial" match="Rb-50D/Pozycje/Pozycja" use="concat(count(ancestor::Jednostka/preceding-sibling::Jednostka), count(ancestor::Rb-50D/preceding-sibling::Rb-50D), Dzial)"/>
	<xsl:key name="kluczRb50DRozdzial" match="Rb-50D/Pozycje/Pozycja" use="concat(count(ancestor::Jednostka/preceding-sibling::Jednostka), count(ancestor::Rb-50D/preceding-sibling::Rb-50D), Rozdzial)"/>
	<xsl:key name="kluczRb50WDzial" match="Rb-50W/Pozycje/Pozycja" use="concat(count(ancestor::Jednostka/preceding-sibling::Jednostka), count(ancestor::Rb-50W/preceding-sibling::Rb-50W), Dzial)"/>
	<xsl:key name="kluczRb50WRozdzial" match="Rb-50W/Pozycje/Pozycja" use="concat(count(ancestor::Jednostka/preceding-sibling::Jednostka), count(ancestor::Rb-50W/preceding-sibling::Rb-50W), Rozdzial)"/>
	<xsl:key name="kluczRb50WwydADzial" match="Rb-50W/WydatkiA/Pozycja" use="concat(count(ancestor::Jednostka/preceding-sibling::Jednostka), count(ancestor::Rb-50W/preceding-sibling::Rb-50W), Dzial)"/>
	<xsl:key name="kluczRb50WwydARozdzial" match="Rb-50W/WydatkiA/Pozycja" use="concat(count(ancestor::Jednostka/preceding-sibling::Jednostka), count(ancestor::Rb-50W/preceding-sibling::Rb-50W), Rozdzial)"/>
	<xsl:key name="kluczRb50WwydBDzial" match="Rb-50W/WydatkiB/Pozycja" use="concat(count(ancestor::Jednostka/preceding-sibling::Jednostka), count(ancestor::Rb-50W/preceding-sibling::Rb-50W), Dzial)"/>
	<xsl:key name="kluczRb50WwydBRozdzial" match="Rb-50W/WydatkiB/Pozycja" use="concat(count(ancestor::Jednostka/preceding-sibling::Jednostka), count(ancestor::Rb-50W/preceding-sibling::Rb-50W), Rozdzial)"/>
	<xsl:key name="kluczRb28nwsDzial" match="Rb-28nws/Pozycje/Pozycja" use="concat(count(ancestor::Jednostka/preceding-sibling::Jednostka), count(ancestor::Rb-28nws/preceding-sibling::Rb-28nws), Dzial)"/>
	<xsl:key name="kluczRb28nwsRozdzial" match="Rb-28nws/Pozycje/Pozycja" use="concat(count(ancestor::Jednostka/preceding-sibling::Jednostka), count(ancestor::Rb-28nws/preceding-sibling::Rb-28nws), Rozdzial)"/>
	<xsl:key name="kluczSP1SymbolNadrzedny" match="SP-1/PodatekOdNieruchomosci/Pozycja" use="concat(count(ancestor::Jednostka/preceding-sibling::Jednostka), count(ancestor::SP-1/preceding-sibling::SP-1),SymbolNadrzedny)"/>
	<xsl:key name="kluczSP1Symbol" match="SP-1/PodatekRolny/Pozycja" use="concat(count(ancestor::Jednostka/preceding-sibling::Jednostka), count(ancestor::SP-1/preceding-sibling::SP-1),Symbol)"/>
	<xsl:decimal-format decimal-separator="," grouping-separator="&#160;"/>
	<xsl:template match="/PaczkaSprawozdan">
		<html>
			<head>
				<title/>
				<style type="text/css">
          html,body
          {
          height: 100%;
          font-family: Arial;
          font-style: normal;
          font-variant: normal;
          font-weight: normal;
          line-height: normal;
          font-size-adjust: none;
          font-stretch: normal;
          -x-system-font: none;
          }

          td
          {
          padding: 3px;
          }

          .all-bold { border: 4px solid black; border-collapse: collapse; }
          .notop-bold { border-style: solid; border-width: 0 4px 4px 4px; border-color: black; }
          .bottom-bold { border-style: solid; border-width: 0 0 4px 0; border-color: black; }
          .bottom-normal {	border-style: solid;	border-width: 0 0 1px 0;	border-color: black; }
          .bottom-right-mixed { border-style: solid; border-width: 0 1px 4px 0; border-color: black;}
          .right-bottom-mixed { border-style: solid; border-width: 0 4px 1px 0; border-color: black;}
          .all-normal { border: 1px solid black; border-collapse: collapse; }
          .right-normal {	border-style: solid;	border-width: 0 1px 0 0;	border-color: black; }
          .right-bold {	border-style: solid;	border-width: 0 4px 0 0;	border-color: black; }
          .bottom-right-bold { border-style: solid; border-width: 0 4px 4px 0; border-color: black;}
          .bottom-right-normal { border-style: solid; border-width: 0 1px 1px 0; border-color: black;}
        </style>
				<script type="text/javascript">

        </script>
			</head>
			<body>
				<div id="main" style="display:block; text-align: center; margin-bottom: 30px; font-family: Verdana; font-size: 13pt; font-weight: bold">
					<xsl:call-template name="NaglowekOkres"/>
				</div>
				<div style="display:block; margin-bottom: 25px; font-family: Verdana">
					<div style="font-size: 14pt; display: block; margin-bottom: 5px; font-weight: bold">Sprawozdania dla jednostek:</div>
					<ol type="1">
						<xsl:for-each select="Jednostki/Jednostka">
							<xsl:sort select="Nazwa"/>
							<li>
								<xsl:element name="a">
									<xsl:attribute name="href"><xsl:value-of select="concat('#Jed', count(preceding-sibling::Jednostka)+1)"/></xsl:attribute>
									<xsl:element name="style">
										<xsl:value-of select="'font-family: Verdana'"/>
									</xsl:element>
									<xsl:value-of select="concat(Nazwa, ' ')"/>
									<xsl:call-template name="JedNaglowekInfo"/>
								</xsl:element>
							</li>
						</xsl:for-each>
					</ol>
				</div>
				<xsl:for-each select="Jednostki/Jednostka">
					<xsl:sort select="Nazwa"/>
					<xsl:element name="div">
						<xsl:attribute name="style"><xsl:value-of select="'display:block; margin-bottom: 80px; margin-top: 20px; font-family: Verdana'"/></xsl:attribute>
						<xsl:attribute name="Id"><xsl:value-of select="concat('Jed', count(preceding-sibling::Jednostka)+1)"/></xsl:attribute>
						<div style="font-size: 13pt; display: block; font-weight: bold">
							<xsl:value-of select="concat('Jednostka ', Nazwa, ' ')"/>
							<xsl:call-template name="JedNaglowekInfo"/>
						</div>
						<div style="display: block; margin-bottom: 5px; font-weight: bold">
							<xsl:value-of select="'Dostępne wersje sprawozdania: '"/>
						</div>
						<ol>
							<!-- FIXMEE w aktualnej wersji nałożona jest filtracja na sprawozdania, które nie zostały jeszcze zaimplementowane -->
							<xsl:for-each select="Sprawozdania/child::*[Naglowek/Wersja and name(.) != 'Rb-32' and name(.) != 'ds:Signature']">
								<xsl:sort select="name(.)"/>
								<xsl:sort select="Naglowek/Wersja"/>
								<li>
									<xsl:element name="a">
										<xsl:attribute name="href"><xsl:value-of select="concat('#Jed', count(../../preceding-sibling::Jednostka)+1, 'Wer', position())"/></xsl:attribute>
										<xsl:element name="style">
											<xsl:value-of select="'font-family: Verdana'"/>
										</xsl:element>
										<xsl:value-of select="'Sprawozdanie '"/>
										<xsl:value-of select="name(.)"/>
										<xsl:value-of select="', '"/>
										<xsl:choose>
											<xsl:when test="Naglowek/Wersja = 0">
												<xsl:value-of select="'wersja pierwotna '"/>
											</xsl:when>
											<xsl:otherwise>
												<xsl:value-of select="concat('korekta nr ', Naglowek/Wersja, ' ')"/>
											</xsl:otherwise>
										</xsl:choose>
										<xsl:call-template name="SprNaglowekInfo"/>
									</xsl:element>
								</li>
							</xsl:for-each>
							<div style="margin: 30px 0">
								<xsl:element name="a">
									<xsl:attribute name="href"><xsl:value-of select="'#main'"/></xsl:attribute>
									<xsl:element name="style">
										<xsl:value-of select="'font-family: Verdana'"/>
									</xsl:element>
									<xsl:value-of select="'Powrót do listy jednostek'"/>
								</xsl:element>
							</div>
						</ol>
						<!-- FIXME w aktualnej wersji nałożona jest filtracja na sprawozdania, które nie zostały jeszcze zaimplementowane -->
						<xsl:for-each select="Sprawozdania/child::*[Naglowek/Wersja and name(.) != 'Rb-32' and name(.) != 'ds:Signature']">
							<xsl:sort select="name(.)"/>
							<xsl:sort select="Naglowek/Wersja"/>
							<xsl:apply-templates select=".">
								<xsl:with-param name="jedIndex" select="count(../../preceding-sibling::Jednostka)+1"/>
								<xsl:with-param name="sprIndex" select="position()"/>
								<xsl:with-param name="polIndex" select="count(preceding-sibling::*)+1"/>
							</xsl:apply-templates>
						</xsl:for-each>
					</xsl:element>
				</xsl:for-each>
			</body>
		</html>
	</xsl:template>
	<!-- Rb-27s -->
	<xsl:template match="Rb-27s">
		<xsl:param name="jedIndex"/>
		<xsl:param name="sprIndex"/>
		<xsl:param name="polIndex"/>
		<xsl:element name="div">
			<xsl:attribute name="Id"><xsl:value-of select="concat('Jed', $jedIndex, 'Wer', $sprIndex)"/></xsl:attribute>
			<xsl:attribute name="style"><xsl:value-of select="'display: block; margin-bottom: 40px'"/></xsl:attribute>
			<div style="font-size: 12pt; font-weight: bold; margin-left: 5px; margin-bottom: 10px">
        Sprawozdanie Rb-27s:
        <xsl:choose>
					<xsl:when test="Naglowek/Wersja = 0">
						<xsl:value-of select="'wersja pierwotna'"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="concat('korekta nr ', Naglowek/Wersja)"/>
					</xsl:otherwise>
				</xsl:choose>
				<xsl:call-template name="SprNaglowekInfo"/>
			</div>
			<xsl:attribute name="Id"><xsl:value-of select="concat('Jed', $jedIndex, 'Wer', $sprIndex)"/></xsl:attribute>
			<xsl:attribute name="style"><xsl:value-of select="'display: block; margin-bottom: 40px'"/></xsl:attribute>
			<table cellpadding="0" cellspacing="0" class="all-bold" style="margin-bottom: 30px">
				<thead>
					<tr>
						<th style="width:333px"/>
						<th style="width: 56px"/>
						<th style="width: 365px"/>
						<th style="width: 37px"/>
						<th style="width: 265px"/>
					</tr>
				</thead>
				<tbody>
					<tr style="height: 18px">
						<td colspan="5" class="bottom-bold" style="font-size: 10pt;">MINISTERSTWO FINANSÓW, ul. Świętokrzyska 12, 00-916 Warszawa</td>
					</tr>
					<tr style="height: 127px">
						<td class="bottom-bold" style="width:333px">
							<table cellpadding="0" cellspacing="0" style="border-collapse: collapse; height" width="100%">
								<tbody>
									<tr style="height: 80px">
										<td style="text-align: left; font-size: 9pt; margin:1px 1px 0 0; padding:0" valign="top">
                      Nazwa i adres jednostki sprawozdawczej
                    </td>
									</tr>
									<tr>
										<td class="bottom-normal" style="text-align: center; font-size: 9pt" valign="bottom">
											<!-- popr. nr I.8 -->
											<div style="display: block;margin: 0 20px">
												<xsl:choose>
													<xsl:when test="Jednostka/Nazwa">
														<xsl:value-of select="Jednostka/Nazwa"/>
													</xsl:when>
													<xsl:otherwise>
														<xsl:value-of select="../../Nazwa"/>
													</xsl:otherwise>
												</xsl:choose>
												<!--<xsl:value-of select="../../Nazwa"/>-->
											</div>
											<!-- <div style="display: block;">ul. Ligonia 46</div>
											<div style="display: block;">40-037 Katowice</div> -->
										</td>
									</tr>
									<tr style="height: 23px">
										<td style="text-align: left; font-size: 9pt; margin:1px 1px 0 0; padding:0;" valign="top">
                      Numer identyfikacyjny REGON
                    </td>
									</tr>
									<tr>
										<td style="text-align: center; font-size: 9pt; font-weight: bold; margin:1px 1px 0 0; padding:0" valign="baseline">
											<xsl:choose>
												<xsl:when test="Jednostka/Regon">
													<xsl:value-of select="Jednostka/Regon"/>
												</xsl:when>
												<xsl:otherwise>
													<xsl:value-of select="../../Regon"/>
												</xsl:otherwise>
											</xsl:choose>
											<!--<xsl:value-of select="../../Regon"/>-->
										</td>
									</tr>
								</tbody>
							</table>
						</td>
						<td colspan="3" class="notop-bold" valign="top" style="width: 458px">
							<div style="font-weight: bold; text-align: center; font-size: 11pt; margin-bottom: 5px">
                Rb-27S MIESIĘCZNE / ROCZNE <sup>1)</sup> SPRAWOZDANIE Z WYKONANIA PLANU DOCHODÓW BUDŻETOWYCH JEDNOSTKI SAMORZĄDU TERYTORIALNEGO
              </div>
							<div style="font-weight: bold; text-align: center; font-size: 9pt; margin-bottom: 5px">
                samorządowej jednostki budżetowej / jednostki samorządu terytorialnego <sup>1)</sup>
							</div>
							<div style="vertical-align: bottom; text-align: center; font-size: 9pt; margin-top: 35px">
								<xsl:call-template name="NaglowekSprOkres"/>
							</div>
						</td>
						<td class="bottom-bold" style="text-align: left; font-size: 9pt; margin:1px 1px 0 0; padding:0; width: 265px" valign="top">
							<div style="margin-bottom:5px">Adresat:</div>
							<!-- popr. nr I.9 -->
							<div style="text-align:center; margin-bottom: 15px;">
								<!-- <xsl:value-of select="'Regionalna Izba Obrachunkowa w Katowicach'"/> -->
							</div>
							<div style="text-align:center;">
								<!-- <xsl:value-of select="'wersja robocza'"/> -->
							</div>
						</td>
					</tr>
					<tr>
						<td colspan="2" style="font-size: 9pt; border-style: solid; border-width: 1px 0 0 0; border-color:black">
							<!-- popr. nr I.10 -->
							<div style="margin-bottom: 1px">
								<xsl:value-of select="'Nazwa województwa'"/>
								<!-- <xsl:if test="../../Typ = 'W'">
									<span style="margin-left: 10px">
										<b>
											<xsl:value-of select="../../Nazwa"/>
										</b>
									</span>
								</xsl:if> -->
							</div>
							<div style="margin-bottom: 1px">
								<xsl:value-of select="'Nazwa powiatu / związku '"/>
								<sup>1)</sup>
								<!-- <xsl:if test="../../Typ = 'P'">
									<span style="margin-left: 10px">
										<b>
											<xsl:value-of select="../../Nazwa"/>
										</b>
									</span>
								</xsl:if> -->
							</div>
							<div>
								<xsl:value-of select="'Nazwa gminy / związku '"/>
								<sup>1)</sup>
								<!-- <xsl:if test="../../Typ = 'G'">
									<span style="margin-left: 10px">
										<b>
											<xsl:value-of select="../../Nazwa"/>
										</b>
									</span>
								</xsl:if> -->
							</div>
						</td>
						<td style="border-style: solid; border-width: 0 1px 0 1px; border-color: black; margin: 0; padding: 0">
							<table cellpadding="0" cellspacing="0" border="0" style="height:100%;width:100%">
								<tbody>
									<tr>
										<td colspan="6" style="font-size:10pt; text-align:center; border-style: solid; border-width: 0 0 1px 0; border-color: black">SYMBOLE</td>
									</tr>
									<tr>
										<td style="font-size:10pt; text-align:center; border-style: solid; border-width: 0 1px 1px 0; border-color: black">WOJ.</td>
										<td style="font-size:10pt; text-align:center; border-style: solid; border-width: 0 1px 1px 0; border-color: black">POWIAT</td>
										<td style="font-size:10pt; text-align:center; border-style: solid; border-width: 0 1px 1px 0; border-color: black">GMINA</td>
										<td style="font-size:10pt; text-align:center; border-style: solid; border-width: 0 1px 1px 0; border-color: black">TYP GM.</td>
										<td style="font-size:10pt; text-align:center; border-style: solid; border-width: 0 1px 1px 0; border-color: black">ZWIĄZEK JST</td>
										<td style="font-size:10pt; text-align:center; border-style: solid; border-width: 0 0 1px 0; border-color: black">TYP ZW.</td>
									</tr>
									<tr>
										<td style="font-size:10pt; text-align:center; border-style: solid; border-width: 0 1px 0 0; border-color: black">
											<xsl:choose>
												<xsl:when test="Jednostka/WK">
													<xsl:value-of select="Jednostka/WK"/>
												</xsl:when>
												<xsl:otherwise>
													<xsl:value-of select="../../WK"/>
												</xsl:otherwise>
											</xsl:choose>
											<!--<xsl:value-of select="../../WK"/>-->
										</td>
										<td style="font-size:10pt; text-align:center; border-style: solid; border-width: 0 1px 0 0; border-color: black">
											<xsl:choose>
												<xsl:when test="Jednostka/PK">
													<xsl:value-of select="Jednostka/PK"/>
												</xsl:when>
												<xsl:otherwise>
													<xsl:value-of select="../../PK"/>
												</xsl:otherwise>
											</xsl:choose>
											<!--<xsl:value-of select="../../PK"/>-->
										</td>
										<td style="font-size:10pt; text-align:center; border-style: solid; border-width: 0 1px 0 0; border-color: black">
											<xsl:choose>
												<xsl:when test="Jednostka/GK">
													<xsl:value-of select="Jednostka/GK"/>
												</xsl:when>
												<xsl:otherwise>
													<xsl:value-of select="../../GK"/>
												</xsl:otherwise>
											</xsl:choose>
											<!--<xsl:value-of select="../../GK"/>-->
										</td>
										<td style="font-size:10pt; text-align:center; border-style: solid; border-width: 0 1px 0 0; border-color: black">
											<xsl:choose>
												<xsl:when test="Jednostka/GT">
													<xsl:value-of select="Jednostka/GT"/>
												</xsl:when>
												<xsl:otherwise>
													<xsl:value-of select="../../GT"/>
												</xsl:otherwise>
											</xsl:choose>
											<!--<xsl:value-of select="../../GT"/>-->
										</td>
										<td style="font-size:10pt; text-align:center; border-style: solid; border-width: 0 1px 0 0; border-color: black">
											<xsl:choose>
												<xsl:when test="Jednostka/KodMSWiA">
													<xsl:value-of select="Jednostka/KodMSWiA"/>
												</xsl:when>
												<xsl:otherwise>
													<xsl:choose>
														<xsl:when test="../../KodMSWiA">
															<xsl:value-of select="../../KodMSWiA"/>
														</xsl:when>
														<xsl:otherwise>
															<xsl:value-of select="$nbsp"/>
														</xsl:otherwise>
													</xsl:choose>
												</xsl:otherwise>
											</xsl:choose>
										</td>
										<td style="font-size:10pt; text-align:center">
											<xsl:value-of select="$nbsp"/>
										</td>
									</tr>
								</tbody>
							</table>
						</td>
						<td colspan="2" style="font-size:9pt; text-align:right; border-style: solid; border-width: 1px 0 0 0; border-color:black">
							<div style="margin-right: 15px">Przed wypełnieniem przeczytać instrukcję</div>
						</td>
					</tr>
				</tbody>
			</table>
			<div style="display: block; margin-bottom: 40px">
				<table cellpadding="0" cellspacing="0" class="all-bold" style="margin-bottom: 60px">
					<tbody>
						<tr>
							<td colspan="3" style="font-size: 9pt; text-align: center" class="bottom-bold">Klasyfikacja budżetowa</td>
							<td rowspan="4" style="font-size: 9pt; width: 88px; text-align: center" class="notop-bold">Plan (po zmianach)</td>
							<td rowspan="4" style="font-size: 9pt; width: 88px; text-align: center" class="bottom-right-mixed">
								<div style="margin-bottom: 5px">
                  Należności <sup>2)</sup>
								</div>
								<div style="font-size: 7pt">(salda początkowe plus przypisy minus odpisy)</div>
							</td>
							<td rowspan="4" style="font-size: 9pt; width: 88px; text-align: center" class="bottom-right-mixed">
								<div style="margin-bottom: 5px; width: 88px">
                  Potrącenia <sup>2)</sup>
								</div>
								<div style="font-size: 7pt; width: 88px">(art. 65 i art. 66 §1 pkt 2 ustawy z dn. 29 sierpnia 1997r. - Ordynacja podatkowa)</div>
							</td>
							<td rowspan="4" style="font-size: 9pt; width: 88px; text-align: center" class="bottom-right-mixed">Dochody wykonane (wpływy minus zwroty)</td>
							<td colspan="3" style="font-size: 9pt; border-style: solid; border-width: 0 4px 1px 0; border-color: black; text-align: center">
                Saldo końcowe <sup>2)</sup>
							</td>
							<td rowspan="4" style="font-size: 7pt; text-align: center; width: 88px" class="bottom-right-mixed">Skutki obniżenia górnych stawek podatków obliczone za okres sprawozdawczy<sup>3)</sup>
							</td>
							<td rowspan="4" style="font-size: 7pt; text-align: center; width: 88px" class="bottom-right-mixed">Skutki udzielonych ulg i zwolnień obliczone za okres sprawozdawczy (bez ulg i zwolnień ustawowych)<sup>3)</sup>
							</td>
							<td colspan="3" style="font-size: 7pt; text-align: center" class="bottom-normal">
                Skutki decyzji wydanych przez organ podatkowy na podstawie ustawy - Ordynacja Podatkowa, obliczone za okres sprawozdawczy <sup>3)</sup>
							</td>
						</tr>
						<tr>
							<td rowspan="3" style="font-size:9pt; width: 84px" class="bottom-right-mixed">
								<div style="text-align:center; margin-left: 1px">
									<div style="display:block">
										<xsl:value-of select="'d'"/>
									</div>
								</div>
								<div style="text-align:center; margin-left: 1px">
									<div style="display:block">
										<xsl:value-of select="'z'"/>
									</div>
								</div>
								<div style="text-align:center; margin-left: 1px">
									<div style="display:block">
										<xsl:value-of select="'i'"/>
									</div>
								</div>
								<div style="text-align:center; margin-left: 1px">
									<div style="display:block">
										<xsl:value-of select="'a'"/>
									</div>
								</div>
								<div style="text-align:center; margin-left: 1px">
									<div style="display:block">
										<xsl:value-of select="'ł'"/>
									</div>
								</div>
							</td>
							<td rowspan="3" style="font-size:9pt; width: 84px" class="bottom-right-mixed">
								<div style="text-align:center; margin-left: 1px">
									<div style="display:block">
										<xsl:value-of select="'r'"/>
									</div>
								</div>
								<div style="text-align:center; margin-left: 1px">
									<div style="display:block">
										<xsl:value-of select="'o'"/>
									</div>
								</div>
								<div style="text-align:center; margin-left: 1px">
									<div style="display:block">
										<xsl:value-of select="'z'"/>
									</div>
								</div>
								<div style="text-align:center; margin-left: 1px">
									<div style="display:block">
										<xsl:value-of select="'d'"/>
									</div>
								</div>
								<div style="text-align:center; margin-left: 1px">
									<div style="display:block">
										<xsl:value-of select="'z'"/>
									</div>
								</div>
								<div style="text-align:center; margin-left: 1px">
									<div style="display:block">
										<xsl:value-of select="'i'"/>
									</div>
								</div>
								<div style="text-align:center; margin-left: 1px">
									<div style="display:block">
										<xsl:value-of select="'a'"/>
									</div>
								</div>
								<div style="text-align:center; margin-left: 1px">
									<div style="display:block">
										<xsl:value-of select="'ł'"/>
									</div>
								</div>
							</td>
							<td rowspan="3" style="font-size:9pt; width: 84px" class="bottom-right-bold">
								<div style="text-align:center; margin-left: 1px">
									<div style="display:block">
										<xsl:value-of select="'p'"/>
									</div>
								</div>
								<div style="text-align:center; margin-left: 1px">
									<div style="display:block">
										<xsl:value-of select="'a'"/>
									</div>
								</div>
								<div style="text-align:center; margin-left: 1px">
									<div style="display:block">
										<xsl:value-of select="'r'"/>
									</div>
								</div>
								<div style="text-align:center; margin-left: 1px">
									<div style="display:block">
										<xsl:value-of select="'a'"/>
									</div>
								</div>
								<div style="text-align:center; margin-left: 1px">
									<div style="display:block">
										<xsl:value-of select="'g'"/>
									</div>
								</div>
								<div style="text-align:center; margin-left: 1px">
									<div style="display:block">
										<xsl:value-of select="'r'"/>
									</div>
								</div>
								<div style="text-align:center; margin-left: 1px">
									<div style="display:block">
										<xsl:value-of select="'a'"/>
									</div>
								</div>
								<div style="text-align:center; margin-left: 1px">
									<div style="display:block">
										<xsl:value-of select="'f'"/>
									</div>
								</div>
							</td>
							<td colspan="2" style="font-size:9pt; text-align: center;width:140px" class="bottom-normal" valign="middle">należności pozostałe do zapłaty</td>
							<td rowspan="3" class="bottom-right-bold" style="font-size:9pt; text-align: center;border-width:0 4px 4px 1px">nadpłaty</td>
							<td rowspan="3" style="font-size:8pt; text-align: center" class="bottom-right-mixed">umorzenie zaległości podatkowych</td>
							<td rowspan="3" style="font-size:8pt; text-align: center" class="bottom-bold">rozłożenie na raty, odłożenie terminu płatności, zwolnienie z obowiązku pobrania, ograniczenie poboru</td>
						</tr>
						<tr>
							<td rowspan="2" style="font-size:8pt" class="bottom-bold">ogółem</td>
							<td style="font-size:9pt">w tym</td>
						</tr>
						<tr>
							<td style="font-size:8pt; text-align: center; border-width: 1px 1px 4px 1px" class="all-normal">zaległości</td>
						</tr>
						<tr>
							<td class="bottom-right-bold" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="1"/>
							</td>
							<td class="bottom-right-bold" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="2"/>
							</td>
							<td class="bottom-right-bold" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="3"/>
							</td>
							<td class="bottom-right-bold" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="4"/>
							</td>
							<td class="bottom-right-bold" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="5"/>
							</td>
							<td class="bottom-right-bold" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="6"/>
							</td>
							<td class="bottom-right-bold" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="7"/>
							</td>
							<td class="bottom-right-bold" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="8"/>
							</td>
							<td class="bottom-right-bold" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="9"/>
							</td>
							<td class="bottom-right-bold" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="10"/>
							</td>
							<td class="bottom-right-bold" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="11"/>
							</td>
							<td class="bottom-right-bold" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="12"/>
							</td>
							<td class="bottom-right-bold" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="13"/>
							</td>
							<td class="bottom-right-bold" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="14"/>
							</td>
						</tr>
						<xsl:call-template name="Rb-27s_Pozycje">
							<xsl:with-param name="jedIndex" select="$jedIndex"/>
							<xsl:with-param name="sprIndex" select="$sprIndex"/>
							<xsl:with-param name="polIndex" select="$polIndex"/>
						</xsl:call-template>
						<xsl:for-each select="Pozycje/Pozycja[generate-id(.) = generate-id(key('kluczRb27sDzial', concat(count(ancestor::Jednostka/preceding-sibling::Jednostka), count(ancestor::Rb-27s/preceding-sibling::Rb-27s), Dzial))[1])]">
							<xsl:sort select="Dzial" order="ascending"/>
							<xsl:variable name="obecDzial" select="Dzial"/>
							<xsl:variable name="WezlyDzial" select="/PaczkaSprawozdan/Jednostki/Jednostka[position()=$jedIndex]/Sprawozdania/child::*[position() = $polIndex]/Pozycje/Pozycja[child::Dzial = $obecDzial]"/>
							<tr>
								<td colspan="2" class="right-bottom-mixed" style="text-align:center; font-size: 8pt;border-width: 0 2px 1px 0">Razem dział</td>
								<td class="right-bottom-mixed" style="text-align:center;font-size:8pt;">
									<xsl:value-of select="Dzial"/>
								</td>
								<td class="bottom-right-normal" style="text-align:right;font-size:8pt;padding: 3px">
									<xsl:value-of select="format-number(sum($WezlyDzial[string(number(child::PL)) != 'NaN']/PL), '#&#160;##0,00')"/>
								</td>
								<td class="bottom-right-normal" style="text-align:right;font-size:8pt;padding: 3px">
									<xsl:value-of select="format-number(sum($WezlyDzial[string(number(child::NA)) != 'NaN']/NA), '#&#160;##0,00')"/>
								</td>
								<td class="bottom-right-normal" style="text-align:right;font-size:8pt;padding: 3px">
									<xsl:value-of select="format-number(sum($WezlyDzial[string(number(child::PO)) != 'NaN']/PO), '#&#160;##0,00')"/>
								</td>
								<td class="bottom-right-normal" style="text-align:right;font-size:8pt;padding: 3px">
									<xsl:value-of select="format-number(sum($WezlyDzial[string(number(child::DW)) != 'NaN']/DW), '#&#160;##0,00')"/>
								</td>
								<td class="bottom-right-normal" style="text-align:right;font-size:8pt;padding: 3px">
									<xsl:value-of select="format-number(sum($WezlyDzial[string(number(child::NO)) != 'NaN']/NO), '#&#160;##0,00')"/>
								</td>
								<td class="bottom-right-normal" style="text-align:right;font-size:8pt;padding: 3px">
									<xsl:value-of select="format-number(sum($WezlyDzial[string(number(child::NZ)) != 'NaN']/NZ), '#&#160;##0,00')"/>
								</td>
								<td class="right-bottom-mixed" style="text-align:right;font-size:8pt;padding: 3px">
									<xsl:value-of select="format-number(sum($WezlyDzial[string(number(child::NP)) != 'NaN']/NP), '#&#160;##0,00')"/>
								</td>
								<td class="bottom-right-normal" style="text-align:right;font-size:8pt;padding: 3px">
									<xsl:value-of select="format-number(sum($WezlyDzial[string(number(child::SO)) != 'NaN']/SO), '#&#160;##0,00')"/>
								</td>
								<td class="bottom-right-normal" style="text-align:right;font-size:8pt;padding: 3px">
									<xsl:value-of select="format-number(sum($WezlyDzial[string(number(child::SU)) != 'NaN']/SU), '#&#160;##0,00')"/>
								</td>
								<td class="bottom-right-normal" style="text-align:right;font-size:8pt;padding: 3px">
									<xsl:value-of select="format-number(sum($WezlyDzial[string(number(child::UZ)) != 'NaN']/UZ), '#&#160;##0,00')"/>
								</td>
								<td class="bottom-right-normal" style="text-align:right;font-size:8pt;padding: 3px">
									<xsl:value-of select="format-number(sum($WezlyDzial[string(number(child::OT)) != 'NaN']/OT), '#&#160;##0,00')"/>
								</td>
							</tr>
						</xsl:for-each>
						<tr>
							<td colspan="3" class="bottom-right-bold" style="text-align:center; font-size: 9pt">RAZEM</td>
							<td class="bottom-right-normal" style="text-align:right;font-size:8pt;padding: 3px">
								<xsl:value-of select="format-number(sum(Pozycje/Pozycja[string(number(child::PL)) != 'NaN']/PL), '#&#160;##0,00')"/>
							</td>
							<td class="bottom-right-normal" style="text-align:right;font-size:8pt;padding: 3px">
								<xsl:value-of select="format-number(sum(Pozycje/Pozycja[string(number(child::NA)) != 'NaN']/NA), '#&#160;##0,00')"/>
							</td>
							<td class="bottom-right-normal" style="text-align:right;font-size:8pt;padding: 3px">
								<xsl:value-of select="format-number(sum(Pozycje/Pozycja[string(number(child::PO)) != 'NaN']/PO), '#&#160;##0,00')"/>
							</td>
							<td class="bottom-right-normal" style="text-align:right;font-size:8pt;padding: 3px">
								<xsl:value-of select="format-number(sum(Pozycje/Pozycja[string(number(child::DW)) != 'NaN']/DW), '#&#160;##0,00')"/>
							</td>
							<td class="bottom-right-normal" style="text-align:right;font-size:8pt;padding: 3px">
								<xsl:value-of select="format-number(sum(Pozycje/Pozycja[string(number(child::NO)) != 'NaN']/NO), '#&#160;##0,00')"/>
							</td>
							<td class="bottom-right-normal" style="text-align:right;font-size:8pt;padding: 3px">
								<xsl:value-of select="format-number(sum(Pozycje/Pozycja[string(number(child::NZ)) != 'NaN']/NZ), '#&#160;##0,00')"/>
							</td>
							<td class="right-bottom-mixed" style="text-align:right;font-size:8pt;padding: 3px">
								<xsl:value-of select="format-number(sum(Pozycje/Pozycja[string(number(child::NP)) != 'NaN']/NP), '#&#160;##0,00')"/>
							</td>
							<td class="bottom-right-normal" style="text-align:right;font-size:8pt;padding: 3px">
								<xsl:value-of select="format-number(sum(Pozycje/Pozycja[string(number(child::SO)) != 'NaN']/SO), '#&#160;##0,00')"/>
							</td>
							<td class="bottom-right-normal" style="text-align:right;font-size:8pt;padding: 3px">
								<xsl:value-of select="format-number(sum(Pozycje/Pozycja[string(number(child::SU)) != 'NaN']/SU), '#&#160;##0,00')"/>
							</td>
							<td class="bottom-right-normal" style="text-align:right;font-size:8pt;padding: 3px">
								<xsl:value-of select="format-number(sum(Pozycje/Pozycja[string(number(child::UZ)) != 'NaN']/UZ), '#&#160;##0,00')"/>
							</td>
							<td class="bottom-right-normal" style="text-align:right;font-size:8pt;padding: 3px">
								<xsl:value-of select="format-number(sum(Pozycje/Pozycja[string(number(child::OT)) != 'NaN']/OT), '#&#160;##0,00')"/>
							</td>
						</tr>
					</tbody>
				</table>
				<table cellpadding="0" cellspacing="0" class="all-bold" style="margin-bottom: 20px; width: 100%">
					<tbody>
						<tr style="height: 30px" valign="top">
							<td class="bottom-bold" style="font-size: 9pt; font-weight: bold; text-align:left; padding: 3px 10px; margin-left: 5px; margin-bottom: 25px">Wyjaśnienia do sprawozdania Rb-27s</td>
						</tr>
						<tr style="min-height: 50px; height: 70px" valign="top">
							<td style="text-align: left; font-size: 8pt; padding: 3px 10px">
								<xsl:value-of select="Naglowek/Uwagi"/>
							</td>
						</tr>
					</tbody>
				</table>
				<xsl:if test="Pozycje/Pozycja[child::Uwagi]">
					<table cellpadding="0" cellspacing="0" class="all-bold" style="margin-bottom: 20px; width: 100%">
						<tbody>
							<tr>
								<td colspan="4" style="text-align: center; font-size: 9pt; font-weight: bold; padding: 3px 10px">
									<div>Uwagi do pozycji</div>
								</td>
							</tr>
							<tr>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 4px 4px 0; width: 100px">Dział</td>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 4px 4px 0; width: 100px">Rozdział</td>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 4px 4px 0; width: 100px">Paragraf</td>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 0 4px 0">Uwaga</td>
							</tr>
							<xsl:for-each select="Pozycje/Pozycja[child::Uwagi]">
								<xsl:sort select="Dzial"/>
								<xsl:sort select="Rozdział"/>
								<xsl:sort select="Paragraf"/>
								<tr>
									<xsl:choose>
										<xsl:when test="position() != last()">
											<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
												<xsl:value-of select="Dzial"/>
											</td>
											<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
												<xsl:value-of select="Rozdzial"/>
											</td>
											<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
												<xsl:value-of select="concat(Paragraf, P4)"/>
											</td>
											<td class="bottom-normal" style="text-align: left; font-size: 8pt; padding: 3px">
												<xsl:value-of select="Uwagi"/>
											</td>
										</xsl:when>
										<xsl:otherwise>
											<td class="right-normal" style="text-align: center; font-size: 8pt">
												<xsl:value-of select="Dzial"/>
											</td>
											<td class="right-normal" style="text-align: center; font-size: 8pt">
												<xsl:value-of select="Rozdzial"/>
											</td>
											<td class="right-normal" style="text-align: center; font-size: 8pt">
												<xsl:value-of select="concat(Paragraf, P4)"/>
											</td>
											<td style="text-align: left; font-size: 8pt; padding: 3px">
												<xsl:value-of select="Uwagi"/>
											</td>
										</xsl:otherwise>
									</xsl:choose>
								</tr>
							</xsl:for-each>
						</tbody>
					</table>
				</xsl:if>
				<div style="margin-bottom: 40px">
					<div style="display: block; font-size: 7pt;margin-bottom:0">
						<sup>1)</sup> niepotrzebne skreślić
          </div>
					<div style="display: block; font-size: 7pt;margin-bottom:0">
						<sup>2)</sup> wypełniać tylko za miesiące: marzec, czerwiec i wrzesień oraz za rok sprawozdawczy
          </div>
					<div style="display: block; font-size: 7pt">
						<sup>3)</sup> wypełniają tylko gminy i miasta naprawach powiatu
          </div>
				</div>
				<table cellpadding="0" cellspacing="0" style="margin-bottom: 50px; margin-top: 80px; width: 80%">
					<tbody>
						<tr>
							<td style="text-align:center; font-size: 8pt;" valign="bottom" width="25%">
								<hr style="width: 90%;text-align:center; "/>
								<div style="text-align:center;">Główny księgowy albo Skarbnik</div>
							</td>
							<td/>
							<td style="text-align:center; font-size: 8pt;" valign="bottom" width="25%">
								<hr style="width: 90%;text-align:center"/>
								<div style="text-align:center;">Kierownik jednostki albo Przewodniczący zarządu</div>
							</td>
						</tr>
						<tr>
							<td style="text-align:center; font-size: 8pt;">
								<div>
									<xsl:for-each select="../../Podpisy/*[name() = 'ds:Signature']">
										<xsl:if test="contains(@Id, 'Rb27s')">
											<xsl:if test="contains(translate(*[name() = 'ds:Object']/*[name() = 'xades:QualifyingProperties']/*[name() = 'xades:SignedProperties']/*[name() = 'xades:SignedSignatureProperties']/*[name() = 'xades:SignerRole']/*[name() = 'xades:ClaimedRoles']/*[name() = 'xades:ClaimedRole']/*[name() = 'Role'], 'S','s'),'skarbnik')">
												<xsl:value-of select="substring(*[name() = 'ds:Object']/*[name() = 'xades:QualifyingProperties']/*[name() = 'xades:SignedProperties']/*[name() = 'xades:SignedSignatureProperties']/*[name() = 'xades:SigningTime'], 1, 10)"/>
											</xsl:if>
										</xsl:if>
									</xsl:for-each>
								</div>
							</td>
							<td/>
							<td style="text-align:center; font-size: 8pt;">
								<div>
									<xsl:for-each select="../../Podpisy/*[name() = 'ds:Signature']">
										<xsl:if test="contains(@Id, 'Rb27s')">
											<xsl:if test="contains(translate(*[name() = 'ds:Object']/*[name() = 'xades:QualifyingProperties']/*[name() = 'xades:SignedProperties']/*[name() = 'xades:SignedSignatureProperties']/*[name() = 'xades:SignerRole']/*[name() = 'xades:ClaimedRoles']/*[name() = 'xades:ClaimedRole']/*[name() = 'Role'], 'K','k'),'kierownik')">
												<xsl:value-of select="substring(*[name() = 'ds:Object']/*[name() = 'xades:QualifyingProperties']/*[name() = 'xades:SignedProperties']/*[name() = 'xades:SignedSignatureProperties']/*[name() = 'xades:SigningTime'], 1,10)"/>
											</xsl:if>
										</xsl:if>
									</xsl:for-each>
								</div>
							</td>
						</tr>
					</tbody>
				</table>
			</div>
			<xsl:element name="a">
				<xsl:attribute name="href"><xsl:value-of select="concat('#Jed', $jedIndex)"/></xsl:attribute>
				<xsl:element name="style">
					<xsl:value-of select="'font-family: Verdana'"/>
				</xsl:element>
				<xsl:value-of select="'Powrót do listy sprawozdań jednostki'"/>
			</xsl:element>
		</xsl:element>
	</xsl:template>
	<!-- Rb-27s szablony pomocnicze -->
	<xsl:template name="Rb-27s_Pozycje">
		<xsl:param name="jedIndex"/>
		<xsl:param name="sprIndex"/>
		<xsl:param name="polIndex"/>
		<xsl:for-each select="Pozycje/Pozycja[generate-id(.) = generate-id(key('kluczRb27sDzial', concat(count(ancestor::Jednostka/preceding-sibling::Jednostka), count(ancestor::Rb-27s/preceding-sibling::Rb-27s), Dzial))[1])]">
			<xsl:sort select="Dzial" order="ascending"/>
			<xsl:variable name="obecDzial" select="Dzial"/>
			<xsl:variable name="WezlyDzial" select="/PaczkaSprawozdan/Jednostki/Jednostka[position()=$jedIndex]/Sprawozdania/child::*[position() = $polIndex]/Pozycje/Pozycja[child::Dzial = $obecDzial]"/>
			<xsl:for-each select="$WezlyDzial[generate-id(.) = generate-id(key('kluczRb27sRozdzial', concat(count(ancestor::Jednostka/preceding-sibling::Jednostka), count(ancestor::Rb-27s/preceding-sibling::Rb-27s), Rozdzial))[1])]">
				<xsl:sort select="Rozdzial" order="ascending"/>
				<xsl:variable name="obecRozdzial" select="Rozdzial"/>
				<xsl:variable name="WezlyRozdzial" select="/PaczkaSprawozdan/Jednostki/Jednostka[position()=$jedIndex]/Sprawozdania/child::*[position() = $polIndex]/Pozycje/Pozycja[child::Dzial = $obecDzial and child::Rozdzial = $obecRozdzial]"/>
				<xsl:variable name="Paragrafy" select="$WezlyRozdzial/Paragraf"/>
				<xsl:variable name="P4" select="$WezlyRozdzial/P4"/>
				<xsl:variable name="Licznosc" select="count($WezlyRozdzial)"/>
				<xsl:for-each select="$WezlyRozdzial">
					<tr>
						<td class="bottom-right-normal" style="text-align:center;font-size:8pt">
							<xsl:value-of select="Dzial"/>
						</td>
						<td class="bottom-right-normal" style="text-align:center;font-size:8pt">
							<xsl:value-of select="Rozdzial"/>
						</td>
						<td class="right-bottom-mixed" style="text-align:center;font-size:8pt;">
							<xsl:value-of select="concat(Paragraf, P4)"/>
						</td>
						<td class="bottom-right-normal" style="text-align:right;font-size:8pt;padding: 3px">
							<xsl:choose>
								<xsl:when test="PL">
									<xsl:value-of select="format-number(PL, '#&#160;##0,00')"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="'0,00'"/>
								</xsl:otherwise>
							</xsl:choose>
						</td>
						<td class="bottom-right-normal" style="text-align:right;font-size:8pt;padding: 3px">
							<xsl:choose>
								<xsl:when test="NA">
									<xsl:value-of select="format-number(NA, '#&#160;##0,00')"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="'0,00'"/>
								</xsl:otherwise>
							</xsl:choose>
						</td>
						<td class="bottom-right-normal" style="text-align:right;font-size:8pt;padding: 3px">
							<xsl:choose>
								<xsl:when test="PO">
									<xsl:value-of select="format-number(PO, '#&#160;##0,00')"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="'0,00'"/>
								</xsl:otherwise>
							</xsl:choose>
						</td>
						<td class="bottom-right-normal" style="text-align:right;font-size:8pt;padding: 3px">
							<xsl:choose>
								<xsl:when test="DW">
									<xsl:value-of select="format-number(DW, '#&#160;##0,00')"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="'0,00'"/>
								</xsl:otherwise>
							</xsl:choose>
						</td>
						<td class="bottom-right-normal" style="text-align:right;font-size:8pt;padding: 3px">
							<xsl:choose>
								<xsl:when test="NO">
									<xsl:value-of select="format-number(NO, '#&#160;##0,00')"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="'0,00'"/>
								</xsl:otherwise>
							</xsl:choose>
						</td>
						<td class="bottom-right-normal" style="text-align:right;font-size:8pt;padding: 3px">
							<xsl:choose>
								<xsl:when test="NZ">
									<xsl:value-of select="format-number(NZ, '#&#160;##0,00')"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="'0,00'"/>
								</xsl:otherwise>
							</xsl:choose>
						</td>
						<td class="right-bottom-mixed" style="text-align:right;font-size:8pt;padding: 3px">
							<xsl:choose>
								<xsl:when test="NP">
									<xsl:value-of select="format-number(NP, '#&#160;##0,00')"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="'0,00'"/>
								</xsl:otherwise>
							</xsl:choose>
						</td>
						<td class="bottom-right-normal" style="text-align:right;font-size:8pt;padding: 3px">
							<xsl:choose>
								<xsl:when test="SO">
									<xsl:value-of select="format-number(SO, '#&#160;##0,00')"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="'0,00'"/>
								</xsl:otherwise>
							</xsl:choose>
						</td>
						<td class="bottom-right-normal" style="text-align:right;font-size:8pt;padding: 3px">
							<xsl:choose>
								<xsl:when test="SU">
									<xsl:value-of select="format-number(SU, '#&#160;##0,00')"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="'0,00'"/>
								</xsl:otherwise>
							</xsl:choose>
						</td>
						<td class="bottom-right-normal" style="text-align:right;font-size:8pt;padding: 3px">
							<xsl:choose>
								<xsl:when test="UZ">
									<xsl:value-of select="format-number(UZ, '#&#160;##0,00')"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="'0,00'"/>
								</xsl:otherwise>
							</xsl:choose>
						</td>
						<td class="bottom-right-normal" style="text-align:right;font-size:8pt;padding: 3px">
							<xsl:choose>
								<xsl:when test="OT">
									<xsl:value-of select="format-number(OT, '#&#160;##0,00')"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="'0,00'"/>
								</xsl:otherwise>
							</xsl:choose>
						</td>
					</tr>
				</xsl:for-each>
				<tr>
					<td class="bottom-right-mixed" style="text-align:center;font-size:8pt;font-weight:bold;border-width:0 2px 4px 0">
						<xsl:value-of select="Dzial"/>
					</td>
					<td class="bottom-right-mixed" style="text-align:center;font-size:8pt;font-weight:bold">
						<xsl:value-of select="Rozdzial"/>
					</td>
					<td class="bottom-right-bold" style="text-align:center;font-size:8pt;">
						<xsl:call-template name="Rb-27s_SumaKontr">
							<xsl:with-param name="Paragrafy" select="$Paragrafy"/>
							<xsl:with-param name="P4" select="$P4"/>
							<xsl:with-param name="Licznosc" select="count($WezlyRozdzial)"/>
							<xsl:with-param name="Licznik" select="1"/>
							<xsl:with-param name="Wartosc" select="0"/>
						</xsl:call-template>
					</td>
					<td class="bottom-right-mixed" style="text-align:right;font-size:8pt;padding: 3px">
						<xsl:value-of select="format-number(sum($WezlyRozdzial[string(number(child::PL)) != 'NaN']/PL), '#&#160;##0,00')"/>
					</td>
					<td class="bottom-right-mixed" style="text-align:right;font-size:8pt;padding: 3px;border-width:0 2px 4px 0">
						<xsl:value-of select="format-number(sum($WezlyRozdzial[string(number(child::NA)) != 'NaN']/NA), '#&#160;##0,00')"/>
					</td>
					<td class="bottom-right-mixed" style="text-align:right;font-size:8pt;padding: 3px">
						<xsl:value-of select="format-number(sum($WezlyRozdzial[string(number(child::PO)) != 'NaN']/PO), '#&#160;##0,00')"/>
					</td>
					<td class="bottom-right-mixed" style="text-align:right;font-size:8pt;padding: 3px">
						<xsl:value-of select="format-number(sum($WezlyRozdzial[string(number(child::DW)) != 'NaN']/DW), '#&#160;##0,00')"/>
					</td>
					<td class="bottom-right-mixed" style="text-align:right;font-size:8pt;padding: 3px">
						<xsl:value-of select="format-number(sum($WezlyRozdzial[string(number(child::NO)) != 'NaN']/NO), '#&#160;##0,00')"/>
					</td>
					<td class="bottom-right-mixed" style="text-align:right;font-size:8pt;padding: 3px">
						<xsl:value-of select="format-number(sum($WezlyRozdzial[string(number(child::NZ)) != 'NaN']/NZ), '#&#160;##0,00')"/>
					</td>
					<td class="bottom-right-bold" style="text-align:right;font-size:8pt;padding: 3px">
						<xsl:value-of select="format-number(sum($WezlyRozdzial[string(number(child::NP)) != 'NaN']/NP), '#&#160;##0,00')"/>
					</td>
					<td class="bottom-right-mixed" style="text-align:right;font-size:8pt;padding: 3px">
						<xsl:value-of select="format-number(sum($WezlyRozdzial[string(number(child::SO)) != 'NaN']/SO), '#&#160;##0,00')"/>
					</td>
					<td class="bottom-right-mixed" style="text-align:right;font-size:8pt;padding: 3px">
						<xsl:value-of select="format-number(sum($WezlyRozdzial[string(number(child::SU)) != 'NaN']/SU), '#&#160;##0,00')"/>
					</td>
					<td class="bottom-right-mixed" style="text-align:right;font-size:8pt;padding: 3px">
						<xsl:value-of select="format-number(sum($WezlyRozdzial[string(number(child::UZ)) != 'NaN']/UZ), '#&#160;##0,00')"/>
					</td>
					<td class="bottom-right-mixed" style="text-align:right;font-size:8pt;padding: 3px">
						<xsl:value-of select="format-number(sum($WezlyRozdzial[string(number(child::OT)) != 'NaN']/OT), '#&#160;##0,00')"/>
					</td>
				</tr>
				<tr>
					<td colspan="15" class="bottom-bold" style="height:20px"/>
				</tr>
			</xsl:for-each>
		</xsl:for-each>
	</xsl:template>
	<xsl:template name="Rb-27s_SumaKontr">
		<xsl:param name="Paragrafy"/>
		<xsl:param name="P4"/>
		<xsl:param name="Licznosc"/>
		<xsl:param name="Licznik"/>
		<xsl:param name="Wartosc"/>
		<xsl:choose>
			<xsl:when test="$Licznosc = 0">
				<xsl:value-of select="$Wartosc + number(Dzial) + number(Rozdzial)"/>
			</xsl:when>
			<xsl:when test="$Licznosc = $Licznik">
				<xsl:value-of select="$Wartosc + number(concat($Paragrafy[$Licznik], $P4[$Licznik])) + number(Dzial) + number(Rozdzial)"/>
			</xsl:when>
			<xsl:when test="$Licznosc &gt; $Licznik">
				<xsl:call-template name="Rb-27s_SumaKontr">
					<xsl:with-param name="Paragrafy" select="$Paragrafy"/>
					<xsl:with-param name="P4" select="$P4"/>
					<xsl:with-param name="Licznosc" select="$Licznosc"/>
					<xsl:with-param name="Licznik" select="$Licznik + 1"/>
					<xsl:with-param name="Wartosc" select="$Wartosc + number(concat($Paragrafy[$Licznik], $P4[$Licznik]))"/>
				</xsl:call-template>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<!-- Rb-28s -->
	<xsl:template match="Rb-28s">
		<xsl:param name="jedIndex"/>
		<xsl:param name="sprIndex"/>
		<xsl:param name="polIndex"/>
		<xsl:element name="div">
			<xsl:attribute name="Id"><xsl:value-of select="concat('Jed', $jedIndex, 'Wer', $sprIndex)"/></xsl:attribute>
			<xsl:attribute name="style"><xsl:value-of select="'display: block; margin-bottom: 40px'"/></xsl:attribute>
			<div style="font-size: 12pt; font-weight: bold; margin-left: 5px; margin-bottom: 10px">
        Sprawozdanie Rb-28s:
        <xsl:choose>
					<xsl:when test="Naglowek/Wersja = 0">
						<xsl:value-of select="'wersja pierwotna'"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="concat('korekta nr ', Naglowek/Wersja)"/>
					</xsl:otherwise>
				</xsl:choose>
				<xsl:call-template name="SprNaglowekInfo"/>
			</div>
			<table cellpadding="0" cellspacing="0" class="all-bold" style="margin-bottom: 30px">
				<thead>
					<tr>
						<th style="width:333px"/>
						<th style="width: 56px"/>
						<th style="width: 365px"/>
						<th style="width: 37px"/>
						<th style="width: 265px"/>
					</tr>
				</thead>
				<tbody>
					<tr style="height: 18px">
						<td colspan="5" class="bottom-bold" style="font-size: 10pt;">MINISTERSTWO FINANSÓW, ul. Świętokrzyska 12, 00-916 Warszawa</td>
					</tr>
					<tr style="height: 127px">
						<td class="bottom-bold" style="width:333px">
							<table cellpadding="0" cellspacing="0" style="border-collapse: collapse; height" width="100%">
								<tbody>
									<tr style="height: 80px">
										<td style="text-align: left; font-size: 9pt; margin:1px 1px 0 0; padding:0" valign="top">
                      Nazwa i adres jednostki sprawozdawczej
                    </td>
									</tr>
									<tr>
										<td class="bottom-normal" style="text-align: center; font-size: 9pt" valign="bottom">
											<!-- popr. nr I.8 -->
											<div style="display: block;margin: 0 20px">
												<xsl:choose>
													<xsl:when test="Jednostka/Nazwa">
														<xsl:value-of select="Jednostka/Nazwa"/>
													</xsl:when>
													<xsl:otherwise>
														<xsl:value-of select="../../Nazwa"/>
													</xsl:otherwise>
												</xsl:choose>
												<!--<xsl:value-of select="Jednostka/Nazwa"/>-->
											</div>
										</td>
									</tr>
									<tr style="height: 23px">
										<td style="text-align: left; font-size: 9pt; margin:1px 1px 0 0; padding:0;" valign="top">
                      Numer identyfikacyjny REGON
                    </td>
									</tr>
									<tr>
										<td style="text-align: center; font-size: 9pt; font-weight: bold; margin:1px 1px 0 0; padding:0" valign="baseline">
											<xsl:choose>
												<xsl:when test="Jednostka/Regon">
													<xsl:value-of select="Jednostka/Regon"/>
												</xsl:when>
												<xsl:otherwise>
													<xsl:value-of select="../../Regon"/>
												</xsl:otherwise>
											</xsl:choose>
											<!--<xsl:value-of select="../../Regon"/>-->
										</td>
									</tr>
								</tbody>
							</table>
						</td>
						<td colspan="3" class="notop-bold" valign="top" style="width: 458px">
							<div style="font-weight: bold; text-align: center; font-size: 11pt; margin-bottom: 5px">
                Rb-28s MIESIĘCZNE / ROCZNE <sup>1)</sup> SPRAWOZDANIE Z WYKONANIA PLANU WYDATKÓW BUDŻETOWYCH JEDNOSTKI SAMORZĄDU TERYTORIALNEGO
              </div>
							<div style="font-weight: bold; text-align: center; font-size: 9pt; margin-bottom: 5px">
                samorządowej jednostki budżetowej / jednostki samorządu terytorialnego <sup>1)</sup>
							</div>
							<div style="font-weight: bold; text-align: center; font-size: 9pt; margin-bottom: 5px">okres sprawozdawczy:</div>
							<div style="vertical-align: bottom; text-align: center; font-size: 9pt; margin-top: 35px">
								<xsl:call-template name="NaglowekSprOkres"/>
							</div>
						</td>
						<td class="bottom-bold" style="text-align: left; font-size: 9pt; margin:1px 1px 0 0; padding:0; width: 265px" valign="top">
							<div style="margin-bottom:5px">Adresat:</div>
							<!-- popr. nr I.9 -->
							<div style="text-align:center; margin-bottom: 15px;">
								<!-- <xsl:value-of select="'Regionalna Izba Obrachunkowa w Katowicach'"/> -->
							</div>
							<div style="text-align:center;">
								<!-- <xsl:value-of select="'wersja robocza'"/> -->
							</div>
						</td>
					</tr>
					<tr style="height: 54px">
						<td colspan="2" style="font-size: 9pt; border-style: solid; border-width: 1px 0 0 0; border-color:black">
							<!-- popr. nr I.10 -->
							<div style="margin-bottom: 1px">
								<xsl:value-of select="'Nazwa województwa'"/>
								<!-- <xsl:if test="../../Typ = 'W'">
									<span style="margin-left: 10px">
										<b>
											<xsl:value-of select="../../Nazwa"/>
										</b>
									</span>
								</xsl:if> -->
							</div>
							<div style="margin-bottom: 1px">
								<xsl:value-of select="'Nazwa powiatu / związku '"/>
								<sup>1)</sup>
								<!-- <xsl:if test="../../Typ = 'P'">
									<span style="margin-left: 10px">
										<b>
											<xsl:value-of select="../../Nazwa"/>
										</b>
									</span>
								</xsl:if> -->
							</div>
							<div>
								<xsl:value-of select="'Nazwa gminy / związku '"/>
								<sup>1)</sup>
								<!-- <xsl:if test="../../Typ = 'G'">
									<span style="margin-left: 10px">
										<b>
											<xsl:value-of select="../../Nazwa"/>
										</b>
									</span>
								</xsl:if> -->
							</div>
						</td>
						<td style="border-style: solid; border-width: 0 1px 0 1px; border-color: black; margin: 0; padding: 0">
							<table cellpadding="0" cellspacing="0" border="0" style="height:100%;width:100%">
								<tbody>
									<tr>
										<td colspan="6" style="font-size:10pt; text-align:center; border-style: solid; border-width: 0 0 1px 0; border-color: black">SYMBOLE</td>
									</tr>
									<tr>
										<td style="font-size:10pt; text-align:center; border-style: solid; border-width: 0 1px 1px 0; border-color: black">WOJ.</td>
										<td style="font-size:10pt; text-align:center; border-style: solid; border-width: 0 1px 1px 0; border-color: black">POWIAT</td>
										<td style="font-size:10pt; text-align:center; border-style: solid; border-width: 0 1px 1px 0; border-color: black">GMINA</td>
										<td style="font-size:10pt; text-align:center; border-style: solid; border-width: 0 1px 1px 0; border-color: black">TYP GM.</td>
										<td style="font-size:10pt; text-align:center; border-style: solid; border-width: 0 1px 1px 0; border-color: black">ZWIĄZEK JST</td>
										<td style="font-size:10pt; text-align:center; border-style: solid; border-width: 0 0 1px 0; border-color: black">TYP ZW.</td>
									</tr>
									<tr>
										<td style="font-size:10pt; text-align:center; border-style: solid; border-width: 0 1px 0 0; border-color: black">
											<xsl:choose>
												<xsl:when test="Jednostka/WK">
													<xsl:value-of select="Jednostka/WK"/>
												</xsl:when>
												<xsl:otherwise>
													<xsl:value-of select="../../WK"/>
												</xsl:otherwise>
											</xsl:choose>
											<!--<xsl:value-of select="../../WK"/>-->
										</td>
										<td style="font-size:10pt; text-align:center; border-style: solid; border-width: 0 1px 0 0; border-color: black">
											<xsl:choose>
												<xsl:when test="Jednostka/PK">
													<xsl:value-of select="Jednostka/PK"/>
												</xsl:when>
												<xsl:otherwise>
													<xsl:value-of select="../../PK"/>
												</xsl:otherwise>
											</xsl:choose>
											<!--<xsl:value-of select="../../PK"/>-->
										</td>
										<td style="font-size:10pt; text-align:center; border-style: solid; border-width: 0 1px 0 0; border-color: black">
											<xsl:choose>
												<xsl:when test="Jednostka/GK">
													<xsl:value-of select="Jednostka/GK"/>
												</xsl:when>
												<xsl:otherwise>
													<xsl:value-of select="../../GK"/>
												</xsl:otherwise>
											</xsl:choose>
											<!--<xsl:value-of select="../../GK"/>-->
										</td>
										<td style="font-size:10pt; text-align:center; border-style: solid; border-width: 0 1px 0 0; border-color: black">
											<xsl:choose>
												<xsl:when test="Jednostka/GT">
													<xsl:value-of select="Jednostka/GT"/>
												</xsl:when>
												<xsl:otherwise>
													<xsl:value-of select="../../GT"/>
												</xsl:otherwise>
											</xsl:choose>
											<!--<xsl:value-of select="../../GT"/>-->
										</td>
										<td style="font-size:10pt; text-align:center; border-style: solid; border-width: 0 1px 0 0; border-color: black">
											<xsl:choose>
												<xsl:when test="Jednostka/KodMSWiA">
													<xsl:value-of select="Jednostka/KodMSWiA"/>
												</xsl:when>
												<xsl:otherwise>
													<xsl:choose>
														<xsl:when test="../../KodMSWiA">
															<xsl:value-of select="../../KodMSWiA"/>
														</xsl:when>
														<xsl:otherwise>
															<xsl:value-of select="$nbsp"/>
														</xsl:otherwise>
													</xsl:choose>
												</xsl:otherwise>
											</xsl:choose>
										</td>
										<td style="font-size:10pt; text-align:center">
											<xsl:value-of select="$nbsp"/>
										</td>
									</tr>
								</tbody>
							</table>
						</td>
						<td colspan="2" style="font-size:9pt; text-align:right; border-style: solid; border-width: 1px 0 0 0; border-color:black">
							<div style="margin-right: 15px">Przed wypełnieniem przeczytać instrukcję</div>
						</td>
					</tr>
				</tbody>
			</table>
			<div style="display: block; margin-bottom: 40px">
				<table cellpadding="0" cellspacing="0" class="all-bold" style="margin-bottom: 30px">
					<tbody>
						<tr>
							<td colspan="4" style="font-size: 9pt; text-align: center" class="bottom-right-bold">Klasyfikacja budżetowa</td>
							<td rowspan="3" style="font-size: 9pt; width: 128px; text-align: center" class="bottom-right-mixed">Plan (po zmianach)</td>
							<td rowspan="3" style="font-size: 9pt; width: 128px; text-align: center" class="bottom-right-mixed">Zaangażowanie</td>
							<td rowspan="3" style="font-size: 9pt; width: 118px; text-align: center" class="bottom-right-mixed">Wydatki wykonane</td>
							<td colspan="3" style="font-size: 9pt; border-style: solid; border-width: 0 1px 1px 1px; border-color: black; text-align: center">
                Zobowiązania wg stanu na koniec okr. spraw.
              </td>
							<td rowspan="3" style="font-size: 7pt; text-align: center; width: 143px" class="bottom-right-mixed">
                Wydatki, zrealizowane w ramach funduszu sołeckiego<sup>2)</sup>
							</td>
							<td rowspan="3" style="font-size: 7pt; text-align: center; width: 143px" class="bottom-right-mixed">
                Wydatki, które nie wygasły z upływem roku budżetowego <sup>2)</sup>
							</td>
						</tr>
						<tr>
							<td rowspan="2" style="font-size:9pt; width: 84px; text-align: center;" class="bottom-right-mixed">Dział
								<!--  <div style="text-align:center; margin-left: 1px">
									<div style="display:block">
										<xsl:value-of select="'d'"/>
									</div>
								</div>
								<div style="text-align:center; margin-left: 1px">
									<div style="display:block">
										<xsl:value-of select="'z'"/>
									</div>
								</div>
								<div style="text-align:center; margin-left: 1px">
									<div style="display:block">
										<xsl:value-of select="'i'"/>
									</div>
								</div>
								<div style="text-align:center; margin-left: 1px">
									<div style="display:block">
										<xsl:value-of select="'a'"/>
									</div>
								</div>
								<div style="text-align:center; margin-left: 1px">
									<div style="display:block">
										<xsl:value-of select="'ł'"/>
									</div>
								</div>    -->
							</td>
							<td rowspan="2" style="font-size:9pt; width: 84px; text-align: center;" class="bottom-right-mixed">  Rozdział
								<!-- <div style="text-align:center; margin-left: 1px">
									<div style="display:block">
										<xsl:value-of select="'r'"/>
									</div>
								</div>
								<div style="text-align:center; margin-left: 1px">
									<div style="display:block">
										<xsl:value-of select="'o'"/>
									</div>
								</div>
								<div style="text-align:center; margin-left: 1px">
									<div style="display:block">
										<xsl:value-of select="'z'"/>
									</div>
								</div>
								<div style="text-align:center; margin-left: 1px">
									<div style="display:block">
										<xsl:value-of select="'d'"/>
									</div>
								</div>
								<div style="text-align:center; margin-left: 1px">
									<div style="display:block">
										<xsl:value-of select="'z'"/>
									</div>
								</div>
								<div style="text-align:center; margin-left: 1px">
									<div style="display:block">
										<xsl:value-of select="'i'"/>
									</div>
								</div>
								<div style="text-align:center; margin-left: 1px">
									<div style="display:block">
										<xsl:value-of select="'a'"/>
									</div>
								</div>
								<div style="text-align:center; margin-left: 1px">
									<div style="display:block">
										<xsl:value-of select="'ł'"/>
									</div>
								</div>  -->
							</td>
							<td rowspan="2" style="font-size:9pt; width: 84px; text-align: center" class="bottom-right-mixed">  Grupa paragrafów <sup>3)</sup>
							</td>
							<td rowspan="2" style="font-size:9pt; width: 84px; text-align: center" class="bottom-right-bold">  Paragraf
								<!-- <div style="text-align:center; margin-left: 1px">
									<div style="display:block">
										<xsl:value-of select="'p'"/>
									</div>
								</div>
								<div style="text-align:center; margin-left: 1px">
									<div style="display:block">
										<xsl:value-of select="'a'"/>
									</div>
								</div>
								<div style="text-align:center; margin-left: 1px">
									<div style="display:block">
										<xsl:value-of select="'r'"/>
									</div>
								</div>
								<div style="text-align:center; margin-left: 1px">
									<div style="display:block">
										<xsl:value-of select="'a'"/>
									</div>
								</div>
								<div style="text-align:center; margin-left: 1px">
									<div style="display:block">
										<xsl:value-of select="'g'"/>
									</div>
								</div>
								<div style="text-align:center; margin-left: 1px">
									<div style="display:block">
										<xsl:value-of select="'r'"/>
									</div>
								</div>
								<div style="text-align:center; margin-left: 1px">
									<div style="display:block">
										<xsl:value-of select="'a'"/>
									</div>
								</div>
								<div style="text-align:center; margin-left: 1px">
									<div style="display:block">
										<xsl:value-of select="'f'"/>
									</div>
								</div>    -->
							</td>
							<td rowspan="2" class="bottom-bold" style="text-align: center; font-size:9pt; width: 113px">ogółem</td>
							<td colspan="2" style="font-size:8pt; text-align: center" class="bottom-right-normal">w tym wymagalne:</td>
						</tr>
						<tr>
							<td style="text-align:center;font-size:8pt;border-width: 1px 1px 4px 1px;width:103px" class="all-normal">powstałe w latach ubiegłych</td>
							<td style="text-align:center;font-size:8pt;border-width: 1px 1px 4px 1px;width:103px" class="all-normal">powstałe w roku bieżącym</td>
						</tr>
						<tr>
							<td class="bottom-right-bold" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="1"/>
							</td>
							<td class="bottom-right-bold" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="2"/>
							</td>
							<td class="bottom-right-bold" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="3"/>
							</td>
							<td class="bottom-right-bold" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="4"/>
							</td>
							<td class="bottom-right-bold" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="5"/>
							</td>
							<td class="bottom-right-bold" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="6"/>
							</td>
							<td class="bottom-right-bold" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="7"/>
							</td>
							<td class="bottom-right-bold" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="8"/>
							</td>
							<td class="bottom-right-bold" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="9"/>
							</td>
							<td class="bottom-bold" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="10"/>
							</td>
							<td class="bottom-bold" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="11"/>
							</td>
							<td class="bottom-bold" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="12"/>
							</td>
						</tr>
						<xsl:call-template name="Rb-28s_Pozycje">
							<xsl:with-param name="jedIndex" select="$jedIndex"/>
							<xsl:with-param name="sprIndex" select="$sprIndex"/>
							<xsl:with-param name="polIndex" select="$polIndex"/>
						</xsl:call-template>
						<xsl:for-each select="Pozycje/Pozycja[generate-id(.) = generate-id(key('kluczRb28sDzial', concat(count(ancestor::Jednostka/preceding-sibling::Jednostka), count(ancestor::Rb-28s/preceding-sibling::Rb-28s), Dzial))[1])]">
							<xsl:sort select="Dzial" order="ascending"/>
							<xsl:variable name="obecDzial" select="Dzial"/>
							<xsl:variable name="WezlyDzial" select="/PaczkaSprawozdan/Jednostki/Jednostka[position()=$jedIndex]/Sprawozdania/child::*[position() = $polIndex]/Pozycje/Pozycja[child::Dzial = $obecDzial]"/>
							<tr>
								<td colspan="3" class="bottom-right-normal" style="text-align:center; font-size: 8pt">Razem dział</td>
								<td class="right-bottom-mixed" style="text-align:center;font-size:8pt;">
									<xsl:value-of select="Dzial"/>
								</td>
								<td class="bottom-right-normal" style="text-align:right;font-size:8pt;margin-right:3px">
									<xsl:value-of select="format-number(sum($WezlyDzial[string(number(child::PL)) != 'NaN']/PL), '#&#160;##0,00')"/>
								</td>
								<td class="bottom-right-normal" style="text-align:right;font-size:8pt;margin-right:3px">
									<xsl:value-of select="format-number(sum($WezlyDzial[string(number(child::ZA)) != 'NaN']/ZA), '#&#160;##0,00')"/>
								</td>
								<td class="bottom-right-normal" style="text-align:right;font-size:8pt;margin-right:3px">
									<xsl:value-of select="format-number(sum($WezlyDzial[string(number(child::WW)) != 'NaN']/WW), '#&#160;##0,00')"/>
								</td>
								<td class="bottom-right-normal" style="text-align:right;font-size:8pt;margin-right:3px">
									<xsl:value-of select="format-number(sum($WezlyDzial[string(number(child::ZO)) != 'NaN']/ZO), '#&#160;##0,00')"/>
								</td>
								<td class="bottom-right-normal" style="text-align:right;font-size:8pt;margin-right:3px">
									<xsl:value-of select="format-number(sum($WezlyDzial[string(number(child::LU)) != 'NaN']/LU), '#&#160;##0,00')"/>
								</td>
								<td class="bottom-right-normal" style="text-align:right;font-size:8pt;margin-right:3px">
									<xsl:value-of select="format-number(sum($WezlyDzial[string(number(child::RB)) != 'NaN']/RB), '#&#160;##0,00')"/>
								</td>
								<td class="bottom-right-normal" style="text-align:right;font-size:8pt;margin-right:3px">
									<xsl:value-of select="format-number(sum($WezlyDzial[string(number(child::WFS)) != 'NaN']/WFS), '#&#160;##0,00')"/>
								</td>
								<td class="bottom-right-normal" style="text-align:right;font-size:8pt;margin-right:3px">
									<xsl:value-of select="format-number(sum($WezlyDzial[string(number(child::WN)) != 'NaN']/WN), '#&#160;##0,00')"/>
								</td>
							</tr>
						</xsl:for-each>
						<tr>
							<td colspan="4" class="bottom-right-bold" style="text-align:center; font-size: 9pt">RAZEM</td>
							<td class="bottom-right-normal" style="text-align:right;font-size:8pt;margin-right:3px">
								<xsl:value-of select="format-number(sum(Pozycje/Pozycja[string(number(child::PL)) != 'NaN']/PL), '#&#160;##0,00')"/>
							</td>
							<td class="bottom-right-normal" style="text-align:right;font-size:8pt;margin-right:3px">
								<xsl:value-of select="format-number(sum(Pozycje/Pozycja[string(number(child::ZA)) != 'NaN']/ZA), '#&#160;##0,00')"/>
							</td>
							<td class="bottom-right-normal" style="text-align:right;font-size:8pt;margin-right:3px">
								<xsl:value-of select="format-number(sum(Pozycje/Pozycja[string(number(child::WW)) != 'NaN']/WW), '#&#160;##0,00')"/>
							</td>
							<td class="bottom-right-normal" style="text-align:right;font-size:8pt;margin-right:3px">
								<xsl:value-of select="format-number(sum(Pozycje/Pozycja[string(number(child::ZO)) != 'NaN']/ZO), '#&#160;##0,00')"/>
							</td>
							<td class="bottom-right-normal" style="text-align:right;font-size:8pt;margin-right:3px">
								<xsl:value-of select="format-number(sum(Pozycje/Pozycja[string(number(child::LU)) != 'NaN']/LU), '#&#160;##0,00')"/>
							</td>
							<td class="bottom-right-normal" style="text-align:right;font-size:8pt;margin-right:3px">
								<xsl:value-of select="format-number(sum(Pozycje/Pozycja[string(number(child::RB)) != 'NaN']/RB), '#&#160;##0,00')"/>
							</td>
							<td class="bottom-right-normal" style="text-align:right;font-size:8pt;margin-right:3px">
								<xsl:value-of select="format-number(sum(Pozycje/Pozycja[string(number(child::WFS)) != 'NaN']/WFS), '#&#160;##0,00')"/>
							</td>
							<td class="bottom-right-normal" style="text-align:right;font-size:8pt;margin-right:3px">
								<xsl:value-of select="format-number(sum(Pozycje/Pozycja[string(number(child::WN)) != 'NaN']/WN), '#&#160;##0,00')"/>
							</td>
						</tr>
					</tbody>
				</table>
				<table cellpadding="0" cellspacing="0" class="all-bold" style="margin-bottom: 20px; width: 100%">
					<tbody>
						<tr style="height: 30px" valign="top">
							<td class="bottom-bold" style="font-size: 9pt; font-weight: bold; text-align:left; padding: 3px 10px; margin-left: 5px; margin-bottom: 25px">Wyjaśnienia do sprawozdania Rb-28s</td>
						</tr>
						<tr style="min-height: 50px; height: 70px" valign="top">
							<td style="text-align: left; font-size: 8pt; padding: 3px 10px">
								<xsl:value-of select="Naglowek/Uwagi"/>
							</td>
						</tr>
					</tbody>
				</table>
				<xsl:if test="Pozycje/Pozycja[child::Uwagi]">
					<table cellpadding="0" cellspacing="0" class="all-bold" style="margin-bottom: 20px; width: 100%">
						<tbody>
							<tr>
								<td colspan="4" style="text-align: center; font-size: 9pt; font-weight: bold; padding: 3px 10px">
									<div>Uwagi do pozycji</div>
								</td>
							</tr>
							<tr>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 4px 4px 0; width: 100px">Dział</td>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 4px 4px 0; width: 100px">Rozdział</td>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 4px 4px 0; width: 100px">Paragraf</td>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 0 4px 0">Uwaga</td>
							</tr>
							<xsl:for-each select="Pozycje/Pozycja[child::Uwagi]">
								<xsl:sort select="Dzial"/>
								<xsl:sort select="Rozdział"/>
								<xsl:sort select="Paragraf"/>
								<tr>
									<xsl:choose>
										<xsl:when test="position() != last()">
											<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
												<xsl:value-of select="Dzial"/>
											</td>
											<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
												<xsl:value-of select="Rozdzial"/>
											</td>
											<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
												<xsl:value-of select="concat(Paragraf, P4)"/>
											</td>
											<td class="bottom-normal" style="text-align: left; font-size: 8pt; padding: 3px">
												<xsl:value-of select="Uwagi"/>
											</td>
										</xsl:when>
										<xsl:otherwise>
											<td class="right-normal" style="text-align: center; font-size: 8pt">
												<xsl:value-of select="Dzial"/>
											</td>
											<td class="right-normal" style="text-align: center; font-size: 8pt">
												<xsl:value-of select="Rozdzial"/>
											</td>
											<td class="right-normal" style="text-align: center; font-size: 8pt">
												<xsl:value-of select="concat(Paragraf, P4)"/>
											</td>
											<td style="text-align: left; font-size: 8pt; padding: 3px">
												<xsl:value-of select="Uwagi"/>
											</td>
										</xsl:otherwise>
									</xsl:choose>
								</tr>
							</xsl:for-each>
						</tbody>
					</table>
				</xsl:if>
				<xsl:if test="DotacjeRozwojowe/Pozycja[child::Uwagi]">
					<table cellpadding="0" cellspacing="0" class="all-bold" style="margin-bottom: 20px; width: 100%">
						<tbody>
							<tr>
								<td colspan="2" style="text-align: center; font-size: 9pt; font-weight: bold; padding: 3px 10px">
									<div>Uwagi do części: "Dotacje rozwojowe"</div>
								</td>
							</tr>
							<tr>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 4px 4px 0; width: 30%">Wyszczególnienie</td>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 0 4px 0">Uwaga</td>
							</tr>
							<xsl:for-each select="DotacjeRozwojowe/Pozycja[child::Uwagi]">
								<xsl:sort select="Symbol"/>
								<tr>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:left">
										<xsl:choose>
											<xsl:when test="Symbol = 'D1'">
												<xsl:value-of select="'Dotacja rozwojowa (zgodnie z Rb-27S)'"/>
											</xsl:when>
											<xsl:when test="Symbol = 'D2'">
												<xsl:value-of select="'Dotacja rozwojowa udzielona przez samorząd województwa beneficjentom w tym:'"/>
											</xsl:when>
											<xsl:when test="Symbol = 'D21'">
												<xsl:value-of select="'Gminom'"/>
											</xsl:when>
											<xsl:when test="Symbol = 'D22'">
												<xsl:value-of select="'Powiatom'"/>
											</xsl:when>
											<xsl:when test="Symbol = 'D23'">
												<xsl:value-of select="'Związkom jednostek samorządu terytorialnego'"/>
											</xsl:when>
										</xsl:choose>
									</td>
									<td class="bottom-normal" style="text-align: left; font-size: 8pt; padding: 3px">
										<xsl:value-of select="Uwagi"/>
									</td>
								</tr>
							</xsl:for-each>
						</tbody>
					</table>
				</xsl:if>
				<div style="margin-bottom: 40px">
					<div style="display: block; font-size: 7pt;margin-bottom:0">
						<sup>1)</sup> niepotrzebne skreślić
          </div>
					<div style="display: block; font-size: 7pt;margin-bottom:0">
						<sup>2)</sup> wypełniać tylko za rok sprawozdawczy
          </div>
					<div style="display: block; font-size: 7pt">
						<sup>3)</sup> wypełniają te jednostki, które kwoty wydatków planują w grupach paragrafów
          </div>
				</div>
				<table cellpadding="0" cellspacing="0" style="margin-bottom: 50px; margin-top: 80px; width: 80%">
					<tbody>
						<tr>
							<td style="text-align:center; font-size: 8pt;" valign="bottom" width="25%">
								<hr style="width: 90%;text-align:center; "/>
								<div style="text-align:center;">Główny księgowy albo Skarbnik</div>
							</td>
							<td/>
							<td style="text-align:center; font-size: 8pt;" valign="bottom" width="25%">
								<hr style="width: 90%;text-align:center"/>
								<div style="text-align:center;">Kierownik jednostki albo Przewodniczący zarządu</div>
							</td>
						</tr>
						<tr>
							<td style="text-align:center; font-size: 8pt;">
								<div>
									<xsl:for-each select="../../Podpisy/*[name() = 'ds:Signature']">
										<xsl:if test="contains(@Id, 'Rb28s')">
											<xsl:if test="contains(translate(*[name() = 'ds:Object']/*[name() = 'xades:QualifyingProperties']/*[name() = 'xades:SignedProperties']/*[name() = 'xades:SignedSignatureProperties']/*[name() = 'xades:SignerRole']/*[name() = 'xades:ClaimedRoles']/*[name() = 'xades:ClaimedRole']/*[name() = 'Role'], 'S','s'),'skarbnik')">
												<xsl:value-of select="substring(*[name() = 'ds:Object']/*[name() = 'xades:QualifyingProperties']/*[name() = 'xades:SignedProperties']/*[name() = 'xades:SignedSignatureProperties']/*[name() = 'xades:SigningTime'], 1, 10)"/>
											</xsl:if>
										</xsl:if>
									</xsl:for-each>
								</div>
							</td>
							<td/>
							<td style="text-align:center; font-size: 8pt;">
								<div>
									<xsl:for-each select="../../Podpisy/*[name() = 'ds:Signature']">
										<xsl:if test="contains(@Id, 'Rb28s')">
											<xsl:if test="contains(translate(*[name() = 'ds:Object']/*[name() = 'xades:QualifyingProperties']/*[name() = 'xades:SignedProperties']/*[name() = 'xades:SignedSignatureProperties']/*[name() = 'xades:SignerRole']/*[name() = 'xades:ClaimedRoles']/*[name() = 'xades:ClaimedRole']/*[name() = 'Role'], 'K','k'),'kierownik')">
												<xsl:value-of select="substring(*[name() = 'ds:Object']/*[name() = 'xades:QualifyingProperties']/*[name() = 'xades:SignedProperties']/*[name() = 'xades:SignedSignatureProperties']/*[name() = 'xades:SigningTime'], 1,10)"/>
											</xsl:if>
										</xsl:if>
									</xsl:for-each>
								</div>
							</td>
						</tr>
					</tbody>
				</table>
			</div>
			<xsl:element name="a">
				<xsl:attribute name="href"><xsl:value-of select="concat('#Jed', $jedIndex)"/></xsl:attribute>
				<xsl:element name="style">
					<xsl:value-of select="'font-family: Verdana'"/>
				</xsl:element>
				<xsl:value-of select="'Powrót do listy sprawozdań jednostki'"/>
			</xsl:element>
		</xsl:element>
	</xsl:template>
	<!-- Rb-28s szablony pomocnicze -->
	<xsl:template name="Rb-28s_Pozycje">
		<xsl:param name="jedIndex"/>
		<xsl:param name="sprIndex"/>
		<xsl:param name="polIndex"/>
		<xsl:for-each select="Pozycje/Pozycja[generate-id(.) = generate-id(key('kluczRb28sDzial', concat(count(ancestor::Jednostka/preceding-sibling::Jednostka), count(ancestor::Rb-28s/preceding-sibling::Rb-28s), Dzial))[1])]">
			<xsl:sort select="Dzial" order="ascending"/>
			<xsl:variable name="obecDzial" select="Dzial"/>
			<xsl:variable name="WezlyDzial" select="/PaczkaSprawozdan/Jednostki/Jednostka[position()=$jedIndex]/Sprawozdania/child::*[position() = $polIndex]/Pozycje/Pozycja[child::Dzial = $obecDzial]"/>
			<xsl:for-each select="$WezlyDzial[generate-id(.) = generate-id(key('kluczRb28sRozdzial', concat(count(ancestor::Jednostka/preceding-sibling::Jednostka), count(ancestor::Rb-28s/preceding-sibling::Rb-28s), Rozdzial))[1])]">
				<xsl:sort select="Rozdzial" order="ascending"/>
				<xsl:variable name="obecRozdzial" select="Rozdzial"/>
				<xsl:variable name="WezlyRozdzial" select="/PaczkaSprawozdan/Jednostki/Jednostka[position()=$jedIndex]/Sprawozdania/child::*[position() = $polIndex]/Pozycje/Pozycja[child::Dzial = $obecDzial and child::Rozdzial = $obecRozdzial]"/>
				<xsl:variable name="Grupy" select="$WezlyRozdzial/Grupa"/>
				<xsl:variable name="Paragrafy" select="$WezlyRozdzial/Paragraf"/>
				<xsl:variable name="P4" select="$WezlyRozdzial/P4"/>
				<xsl:variable name="Licznosc" select="count($WezlyRozdzial)"/>
				<xsl:for-each select="$WezlyRozdzial">
					<tr>
						<td class="bottom-right-normal" style="text-align:center;font-size:8pt">
							<xsl:value-of select="Dzial"/>
						</td>
						<td class="bottom-right-normal" style="text-align:center;font-size:8pt">
							<xsl:value-of select="Rozdzial"/>
						</td>
						<td class="bottom-right-normal" style="text-align:center;font-size:8pt;">
							<xsl:choose>
								<xsl:when test="translate(string(../../Naglowek/DostepneGrupyParagrafow), 'TRUE', 'true' ) = 'true'">
									<xsl:value-of select="Grupa"/>
								</xsl:when>
							</xsl:choose>
						</td>
						<td class="right-bottom-mixed" style="text-align:center;font-size:8pt;">
							<xsl:value-of select="concat(Paragraf, P4)"/>
						</td>
						<td class="bottom-right-normal" style="text-align:right;font-size:8pt;margin-right:3px">
							<xsl:choose>
								<xsl:when test="PL">
									<xsl:value-of select="format-number(PL, '#&#160;##0,00')"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="'0,00'"/>
								</xsl:otherwise>
							</xsl:choose>
						</td>
						<td class="bottom-right-normal" style="text-align:right;font-size:8pt;margin-right:3px">
							<xsl:choose>
								<xsl:when test="ZA">
									<xsl:value-of select="format-number(ZA, '#&#160;##0,00')"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="'0,00'"/>
								</xsl:otherwise>
							</xsl:choose>
						</td>
						<td class="bottom-right-normal" style="text-align:right;font-size:8pt;margin-right:3px">
							<xsl:choose>
								<xsl:when test="WW">
									<xsl:value-of select="format-number(WW, '#&#160;##0,00')"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="'0,00'"/>
								</xsl:otherwise>
							</xsl:choose>
						</td>
						<td class="bottom-right-normal" style="text-align:right;font-size:8pt;margin-right:3px">
							<xsl:choose>
								<xsl:when test="ZO">
									<xsl:value-of select="format-number(ZO, '#&#160;##0,00')"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="'0,00'"/>
								</xsl:otherwise>
							</xsl:choose>
						</td>
						<td class="bottom-right-normal" style="text-align:right;font-size:8pt;margin-right:3px">
							<xsl:choose>
								<xsl:when test="LU">
									<xsl:value-of select="format-number(LU, '#&#160;##0,00')"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="'0,00'"/>
								</xsl:otherwise>
							</xsl:choose>
						</td>
						<td class="right-bottom-mixed" style="text-align:right;font-size:8pt;margin-right:3px">
							<xsl:choose>
								<xsl:when test="RB">
									<xsl:value-of select="format-number(RB, '#&#160;##0,00')"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="'0,00'"/>
								</xsl:otherwise>
							</xsl:choose>
						</td>
						<td class="bottom-right-normal" style="text-align:right;font-size:8pt;margin-right:3px">
							<xsl:choose>
								<xsl:when test="WFS">
									<xsl:value-of select="format-number(WFS, '#&#160;##0,00')"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="'0,00'"/>
								</xsl:otherwise>
							</xsl:choose>
						</td>
						<td class="bottom-right-normal" style="text-align:right;font-size:8pt;margin-right:3px">
							<xsl:choose>
								<xsl:when test="WN">
									<xsl:value-of select="format-number(WN, '#&#160;##0,00')"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="'0,00'"/>
								</xsl:otherwise>
							</xsl:choose>
						</td>
					</tr>
				</xsl:for-each>
				<tr>
					<td class="bottom-right-mixed" style="text-align:center;font-size:8pt;font-weight:bold">
						<xsl:value-of select="Dzial"/>
					</td>
					<td class="bottom-right-mixed" style="text-align:center;font-size:8pt;font-weight:bold">
						<xsl:value-of select="Rozdzial"/>
					</td>
					<td colspan="2" class="bottom-right-bold" style="text-align:center;font-size:8pt;"/>
					<td class="bottom-right-mixed" style="text-align:right;font-size:8pt;margin-right:3px">
						<xsl:value-of select="format-number(sum($WezlyRozdzial[string(number(child::PL)) != 'NaN']/PL), '#&#160;##0,00')"/>
					</td>
					<td class="bottom-right-mixed" style="text-align:right;font-size:8pt;margin-right:3px">
						<xsl:value-of select="format-number(sum($WezlyRozdzial[string(number(child::ZA)) != 'NaN']/ZA), '#&#160;##0,00')"/>
					</td>
					<td class="bottom-right-mixed" style="text-align:right;font-size:8pt;margin-right:3px">
						<xsl:value-of select="format-number(sum($WezlyRozdzial[string(number(child::WW)) != 'NaN']/WW), '#&#160;##0,00')"/>
					</td>
					<td class="bottom-right-mixed" style="text-align:right;font-size:8pt;margin-right:3px">
						<xsl:value-of select="format-number(sum($WezlyRozdzial[string(number(child::ZO)) != 'NaN']/ZO), '#&#160;##0,00')"/>
					</td>
					<td class="bottom-right-mixed" style="text-align:right;font-size:8pt;margin-right:3px">
						<xsl:value-of select="format-number(sum($WezlyRozdzial[string(number(child::LU)) != 'NaN']/LU), '#&#160;##0,00')"/>
					</td>
					<td class="bottom-right-bold" style="text-align:right;font-size:8pt;margin-right:3px">
						<xsl:value-of select="format-number(sum($WezlyRozdzial[string(number(child::RB)) != 'NaN']/RB), '#&#160;##0,00')"/>
					</td>
					<td class="bottom-right-mixed" style="text-align:right;font-size:8pt;margin-right:3px">
						<xsl:value-of select="format-number(sum($WezlyRozdzial[string(number(child::WFS)) != 'NaN']/WFS), '#&#160;##0,00')"/>
					</td>
					<td class="bottom-right-mixed" style="text-align:right;font-size:8pt;margin-right:3px">
						<xsl:value-of select="format-number(sum($WezlyRozdzial[string(number(child::WN)) != 'NaN']/WN), '#&#160;##0,00')"/>
					</td>
				</tr>
				<tr>
					<td colspan="15" class="bottom-bold" style="height:20px"/>
				</tr>
			</xsl:for-each>
		</xsl:for-each>
	</xsl:template>
	<!-- Rb-N -->
	<xsl:template match="Rb-N">
		<xsl:param name="jedIndex"/>
		<xsl:param name="sprIndex"/>
		<xsl:element name="div">
			<xsl:attribute name="Id"><xsl:value-of select="concat('Jed', $jedIndex, 'Wer', $sprIndex)"/></xsl:attribute>
			<xsl:attribute name="style"><xsl:value-of select="'display: block; margin-bottom: 40px'"/></xsl:attribute>
			<div style="font-size: 12pt; font-weight: bold; margin-left: 5px; margin-bottom: 10px">
        Sprawozdanie Rb-N:
        <xsl:choose>
					<xsl:when test="Naglowek/Wersja = 0">
						<xsl:value-of select="'wersja pierwotna'"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="concat('korekta nr ', Naglowek/Wersja)"/>
					</xsl:otherwise>
				</xsl:choose>
				<xsl:call-template name="SprNaglowekInfo"/>
			</div>
			<table cellpadding="0" cellspacing="0" class="all-bold" style="margin-bottom: 30px">
				<thead>
					<tr>
						<th style="width:333px"/>
						<th style="width: 56px"/>
						<th style="width: 365px"/>
						<th style="width: 37px"/>
						<th style="width: 265px"/>
					</tr>
				</thead>
				<tbody>
					<tr style="height: 18px">
						<td colspan="5" class="bottom-bold" style="font-size: 10pt;">MINISTERSTWO FINANSÓW, ul. Świętokrzyska 12, 00-916 Warszawa</td>
					</tr>
					<tr style="height: 127px">
						<td class="bottom-bold" style="width:333px">
							<table cellpadding="0" cellspacing="0" style="border-collapse: collapse; height" width="100%">
								<tbody>
									<tr style="height: 80px">
										<td style="text-align: left; font-size: 9pt; margin:1px 1px 0 0; padding:0" valign="top">
                      Nazwa i adres jednostki sprawozdawczej
                    </td>
									</tr>
									<tr>
										<td class="bottom-normal" style="text-align: center; font-size: 9pt" valign="bottom">
											<!-- popr. nr I.8 -->
											<div style="display: block;margin: 0 20px">
												<xsl:choose>
													<xsl:when test="Jednostka/Nazwa">
														<xsl:value-of select="Jednostka/Nazwa"/>
													</xsl:when>
													<xsl:otherwise>
														<xsl:value-of select="../../Nazwa"/>
													</xsl:otherwise>
												</xsl:choose>
												<!--<xsl:value-of select="../../Nazwa"/>-->
											</div>
										</td>
									</tr>
									<tr style="height: 23px">
										<td style="text-align: left; font-size: 9pt; margin:1px 1px 0 0; padding:0;" valign="top">
                      Numer identyfikacyjny REGON
                    </td>
									</tr>
									<tr>
										<td style="text-align: center; font-size: 9pt; font-weight: bold; margin:1px 1px 0 0; padding:0" valign="baseline">
											<xsl:choose>
												<xsl:when test="Jednostka/Regon">
													<xsl:value-of select="Jednostka/Regon"/>
												</xsl:when>
												<xsl:otherwise>
													<xsl:value-of select="../../Regon"/>
												</xsl:otherwise>
											</xsl:choose>
											<!--<xsl:value-of select="../../Regon"/>-->
										</td>
									</tr>
								</tbody>
							</table>
						</td>
						<td colspan="3" class="notop-bold" valign="top" style="width: 958px">
							<div style="font-weight: bold; text-align: center; font-size: 11pt; margin-bottom: 5px">Rb-N KWARTALNE SPRAWOZDANIE O STANIE NALEŻNOŚCI ORAZ WYBRANYCH AKTYWÓW FINANSOWYCH</div>
							<div style="font-weight: bold; text-align: center; font-size: 9pt; margin-bottom: 5px">
                jednostki budżetowej / zakładu budżetowego/ gospodarstwa pomocniczego / funduszu celowego nieposiadającego osobowości prawnej / jednostki samorządu terytorialnego / państwowego funduszu celowego posiadającego osobowość prawną / samorządowego funduszu celowego / uczelni publicznej / instytucji gospodarki budżetowej / państwowej instytucji kultury/ państwowej instytucji filmowej / samorządowej instytucji kultury / samodzielnego publicznego zakładu opieki zdrowotnej nadzorowanego przez ministra, centralny organ administracji rządowej, wojewodę, państwową uczelnię medyczną lub państwową uczelnię prowadzącą działalność dydaktyczną i badawczą w dziedzinie nauk medycznych / samodzielnego publicznego zakładu opieki zdrowotnej nadzorowanego przez jednostkę samorządu terytorialnego / ZUS oraz funduszy zarządzanych przez ZUS / KRUS oraz funduszy zarządzanych przez KRUS / Polskiej Akademii Nauk i tworzonych przez nią jednostek organizacyjnych / Narodowego Funduszu Zdrowia / agencji państwowej, w tym wykonawczej / państwowej osoby prawnej z wyłączeniem agencji państwowych, w tym wykonawczych / samorządowej osoby prawnej <sup>



1)</sup>
							</div>
							<div style=" text-align: center; font-size: 9pt; margin-bottom: 5px">
                a)sprawozdanie jednostkowe  b)sprawozdanie zbiorcze   c)sprawozdanie łączne <sup>1)</sup>
							</div>
							<div style="vertical-align: bottom; text-align: center; font-size: 9pt; margin-top: 25px">
								<xsl:call-template name="NaglowekSprOkres"/>
							</div>
						</td>
						<td class="bottom-bold" style="text-align: left; font-size: 9pt; margin:2px 2px 0 0; padding:0; width: 265px" valign="top">
							<div style="margin-bottom:5px">Adresat:</div>
							<!-- popr. nr I.9 -->
							<div style="text-align:center; margin-bottom: 15px;">
								<!-- <xsl:value-of select="'Regionalna Izba Obrachunkowa w Katowicach'"/> -->
							</div>
							<div style="text-align:center;">
								<!-- <xsl:value-of select="'wersja robocza'"/> -->
							</div>
						</td>
					</tr>
					<tr style="height: 54px">
						<td colspan="2" style="font-size: 9pt; border-style: solid; border-width: 2px 0 0 0; border-color:black">
							<!-- popr. nr I.10 -->
							<div style="margin-bottom: 1px">
								<xsl:value-of select="'Nazwa województwa'"/>
								<!-- <xsl:if test="../../Typ = 'W'">
									<span style="margin-left: 10px">
										<b>
											<xsl:value-of select="../../Nazwa"/>
										</b>
									</span>
								</xsl:if> -->
							</div>
							<div style="margin-bottom: 1px">
								<xsl:value-of select="'Nazwa powiatu / związku '"/>
								<sup>1)</sup>
								<!-- <xsl:if test="../../Typ = 'P'">
									<span style="margin-left: 10px">
										<b>
											<xsl:value-of select="../../Nazwa"/>
										</b>
									</span>
								</xsl:if> -->
							</div>
							<div>
								<xsl:value-of select="'Nazwa gminy / związku '"/>
								<sup>1)</sup>
								<!-- <xsl:if test="../../Typ = 'G'">
									<span style="margin-left: 10px">
										<b>
											<xsl:value-of select="../../Nazwa"/>
										</b>
									</span>
								</xsl:if> -->
							</div>
						</td>
						<td style="border-style: solid; border-width: 0 2px 0 2px; border-color: black; margin: 0; padding: 0">
							<table cellpadding="0" cellspacing="0" border="0" style="height:100%;width:100%">
								<tbody>
									<tr>
										<td colspan="8" style="font-size:10pt; text-align:center; border-style: solid; border-width: 0 0 2px 0; border-color: black">SYMBOLE</td>
									</tr>
									<tr>
										<td style="font-size:10pt; text-align:center; border-style: solid; border-width: 0 2px 2px 0; border-color: black">WOJ.</td>
										<td style="font-size:10pt; text-align:center; border-style: solid; border-width: 0 2px 2px 0; border-color: black">POWIAT</td>
										<td style="font-size:10pt; text-align:center; border-style: solid; border-width: 0 2px 2px 0; border-color: black">GMINA</td>
										<td style="font-size:10pt; text-align:center; border-style: solid; border-width: 0 2px 2px 0; border-color: black">TYP GM.</td>
										<td style="font-size:10pt; text-align:center; border-style: solid; border-width: 0 2px 2px 0; border-color: black">ZWIĄZEK JST</td>
										<td style="font-size:10pt; text-align:center; border-style: solid; border-width: 0 2px 2px 0; border-color: black">TYP ZW.</td>
										<td style="font-size:10pt; text-align:center; border-style: solid; border-width: 0 2px 2px 0; border-color: black">Grupa</td>
										<td style="font-size:10pt; text-align:center; border-style: solid; border-width: 0 0 2px 0; border-color: black">część budż.</td>
									</tr>
									<tr>
										<td style="font-size:10pt; text-align:center; border-style: solid; border-width: 0 2px 0 0; border-color: black">
											<xsl:choose>
												<xsl:when test="Jednostka/WK">
													<xsl:value-of select="Jednostka/WK"/>
												</xsl:when>
												<xsl:otherwise>
													<xsl:value-of select="../../WK"/>
												</xsl:otherwise>
											</xsl:choose>
											<!--<xsl:value-of select="../../WK"/>-->
										</td>
										<td style="font-size:10pt; text-align:center; border-style: solid; border-width: 0 2px 0 0; border-color: black">
											<xsl:choose>
												<xsl:when test="Jednostka/PK">
													<xsl:value-of select="Jednostka/PK"/>
												</xsl:when>
												<xsl:otherwise>
													<xsl:value-of select="../../PK"/>
												</xsl:otherwise>
											</xsl:choose>
											<!--<xsl:value-of select="../../PK"/>-->
										</td>
										<td style="font-size:10pt; text-align:center; border-style: solid; border-width: 0 2px 0 0; border-color: black">
											<xsl:choose>
												<xsl:when test="Jednostka/GK">
													<xsl:value-of select="Jednostka/GK"/>
												</xsl:when>
												<xsl:otherwise>
													<xsl:value-of select="../../GK"/>
												</xsl:otherwise>
											</xsl:choose>
											<!--<xsl:value-of select="../../GK"/>-->
										</td>
										<td style="font-size:10pt; text-align:center; border-style: solid; border-width: 0 2px 0 0; border-color: black">
											<xsl:choose>
												<xsl:when test="Jednostka/GT">
													<xsl:value-of select="Jednostka/GT"/>
												</xsl:when>
												<xsl:otherwise>
													<xsl:value-of select="../../GT"/>
												</xsl:otherwise>
											</xsl:choose>
											<!--<xsl:value-of select="../../GT"/>-->
										</td>
										<td style="font-size:10pt; text-align:center; border-style: solid; border-width: 0 2px 0 0; border-color: black">
											<xsl:choose>
												<xsl:when test="Jednostka/KodMSWiA">
													<xsl:value-of select="Jednostka/KodMSWiA"/>
												</xsl:when>
												<xsl:otherwise>
													<xsl:choose>
														<xsl:when test="../../KodMSWiA">
															<xsl:value-of select="../../KodMSWiA"/>
														</xsl:when>
														<xsl:otherwise>
															<xsl:value-of select="$nbsp"/>
														</xsl:otherwise>
													</xsl:choose>
												</xsl:otherwise>
											</xsl:choose>
										</td>
										<td style="font-size:10pt; text-align:center; border-style: solid; border-width: 0 2px 0 0; border-color: black">
											<xsl:value-of select="$nbsp"/>
										</td>
										<td style="font-size:10pt; text-align:center; border-style: solid; border-width: 0 2px 0 0; border-color: black">
											<xsl:value-of select="Naglowek/SymbolJOP"/>
										</td>
										<td style="font-size:10pt; text-align:center">
											<xsl:value-of select="$nbsp"/>
										</td>
									</tr>
								</tbody>
							</table>
						</td>
						<td colspan="2" style="font-size:9pt; text-align:right; border-style: solid; border-width: 2px 0 0 0; border-color:black">
							<div style="margin-right: 15px">Przed wypełnieniem przeczytać instrukcję</div>
						</td>
					</tr>
				</tbody>
			</table>
			<div style="display: block; margin-bottom: 40px">
				<div style="margin: 30px 0 10px 0; font-size: 12pt">A. Należności oraz wybrane aktywa finansowe</div>
				<table cellpadding="0" cellspacing="0" class="all-bold">
					<tbody>
						<tr>
							<td rowspan="2" style="font-size: 8pt; font-weight: bold; width: 250px; text-align: center" class="bottom-right-bold">Wyszczególnienie</td>
							<td rowspan="2" style="font-size: 8pt; font-weight: bold; width: 160px; text-align: center" class="bottom-right-bold">kwota należności ogółem (kol.3+15)</td>
							<td colspan="12" style="font-size: 8pt; font-weight: bold; text-align: center" class="bottom-right-bold">dłużnicy krajowi</td>
							<td colspan="3" style="font-size: 8pt; font-weight: bold; text-align: center" class="bottom-right-bold">dłużnicy zagraniczni</td>
						</tr>
						<tr>
							<td style="font-size: 7pt; font-weight: bold; width: 60px; text-align: center" class="bottom-right-mixed">ogółem (kol. 4+9+10+11 +12+13+14)</td>
							<td style="font-size: 7pt; font-weight: bold; width: 60px; text-align: center" class="bottom-right-mixed">sektor finansów publicznych ogółem (kol. 5+6+7+8)</td>
							<td style="font-size: 7pt; font-weight: bold; width: 60px; text-align: center" class="bottom-right-mixed">grupa I</td>
							<td style="font-size: 7pt; font-weight: bold; width: 60px; text-align: center" class="bottom-right-mixed">grupa II</td>
							<td style="font-size: 7pt; font-weight: bold; width: 60px; text-align: center" class="bottom-right-mixed">grupy III</td>
							<td style="font-size: 7pt; font-weight: bold; width: 60px; text-align: center" class="bottom-right-mixed">grupy IV</td>
							<td style="font-size: 7pt; font-weight: bold; width: 60px; text-align: center" class="bottom-right-mixed">bank centralny</td>
							<td style="font-size: 7pt; font-weight: bold; width: 60px; text-align: center" class="bottom-right-mixed">banki</td>
							<td style="font-size: 7pt; font-weight: bold; width: 60px; text-align: center" class="bottom-right-mixed">pozostałe krajowe instytucje finansowe</td>
							<td style="font-size: 7pt; font-weight: bold; width: 100px; text-align: center" class="bottom-right-mixed">przedsiębiorstwa niefinansowe</td>
							<td style="font-size: 7pt; font-weight: bold; width: 100px; text-align: center" class="bottom-right-mixed">gospodarstwa domowe</td>
							<td style="font-size: 7pt; font-weight: bold; width: 100px; text-align: center" class="bottom-right-bold">instytucje niekomercyjne działające na rzecz gospodarstw domowych</td>
							<td style="font-size: 7pt; font-weight: bold; width: 90px; text-align: center" class="bottom-right-mixed">ogółem (kol. 16+17)</td>
							<td style="font-size: 7pt; font-weight: bold; width: 90px; text-align: center" class="bottom-right-mixed">podmioty należące do strefy euro</td>
							<td style="font-size: 7pt; font-weight: bold; width: 100px; text-align: center" class="bottom-right-mixed">pozostałe podmioty zagraniczne</td>
						</tr>
						<tr>
							<td class="bottom-right-bold" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="1"/>
							</td>
							<td class="bottom-right-bold" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="2"/>
							</td>
							<td class="bottom-right-bold" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="3"/>
							</td>
							<td class="bottom-right-bold" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="4"/>
							</td>
							<td class="bottom-right-bold" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="5"/>
							</td>
							<td class="bottom-right-bold" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="6"/>
							</td>
							<td class="bottom-right-bold" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="7"/>
							</td>
							<td class="bottom-right-bold" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="8"/>
							</td>
							<td class="bottom-right-bold" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="9"/>
							</td>
							<td class="bottom-right-bold" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="10"/>
							</td>
							<td class="bottom-right-bold" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="11"/>
							</td>
							<td class="bottom-right-bold" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="12"/>
							</td>
							<td class="bottom-right-bold" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="13"/>
							</td>
							<td class="bottom-right-bold" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="14"/>
							</td>
							<td class="bottom-right-bold" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="15"/>
							</td>
							<td class="bottom-right-bold" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="16"/>
							</td>
							<td class="bottom-bold" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="17"/>
							</td>
						</tr>
						<tr>
							<td class="right-bottom-mixed" style="font-size: 8pt; text-align: left" valign="middle">
								<table cellpadding="0" cellspacing="0" border="0">
									<tbody>
										<tr>
											<td style="width: 10px; font-size: 8pt; text-align: center">N1</td>
											<td style="padding-left: 5px; font-size: 8pt; text-align: left">papiery wartościowe (N1.1+N1.2)</td>
										</tr>
									</tbody>
								</table>
							</td>
							<xsl:call-template name="Rb-N_daneTabelaA">
								<xsl:with-param name="symbol" select="'N1'"/>
								<xsl:with-param name="ostWiersz" select="false()"/>
							</xsl:call-template>
						</tr>
						<tr>
							<td class="right-bottom-mixed" style="font-size: 8pt; text-align: left" valign="middle">
								<table cellpadding="0" cellspacing="0" border="0">
									<tbody>
										<tr>
											<td style="padding-left: 10px; width: 10px; font-size: 8pt; text-align: center">N1.1</td>
											<td style="padding-left: 5px; font-size: 8pt; text-align: left">krótkoterminowe</td>
										</tr>
									</tbody>
								</table>
							</td>
							<xsl:call-template name="Rb-N_daneTabelaA">
								<xsl:with-param name="symbol" select="'N1.1'"/>
								<xsl:with-param name="ostWiersz" select="false()"/>
							</xsl:call-template>
						</tr>
						<tr>
							<td class="right-bottom-mixed" style="font-size: 8pt; text-align: left" valign="middle">
								<table cellpadding="0" cellspacing="0" border="0">
									<tbody>
										<tr>
											<td style="padding-left: 10px; width: 10px; font-size: 8pt; text-align: center">N1.2</td>
											<td style="padding-left: 5px; font-size: 8pt; text-align: left">długoterminowe</td>
										</tr>
									</tbody>
								</table>
							</td>
							<xsl:call-template name="Rb-N_daneTabelaA">
								<xsl:with-param name="symbol" select="'N1.2'"/>
								<xsl:with-param name="ostWiersz" select="false()"/>
							</xsl:call-template>
						</tr>
						<tr>
							<td class="right-bottom-mixed" style="font-size: 8pt; text-align: left" valign="middle">
								<table cellpadding="0" cellspacing="0" border="0">
									<tbody>
										<tr>
											<td style="width: 10px; font-size: 8pt; text-align: center">N2</td>
											<td style="padding-left: 5px; font-size: 8pt; text-align: left">pożyczki (N2.1+N2.2)</td>
										</tr>
									</tbody>
								</table>
							</td>
							<xsl:call-template name="Rb-N_daneTabelaA">
								<xsl:with-param name="symbol" select="'N2'"/>
								<xsl:with-param name="ostWiersz" select="false()"/>
							</xsl:call-template>
						</tr>
						<tr>
							<td class="right-bottom-mixed" style="font-size: 8pt; text-align: left" valign="middle">
								<table cellpadding="0" cellspacing="0" border="0">
									<tbody>
										<tr>
											<td style="padding-left: 10px; width: 10px; font-size: 8pt; text-align: center">N2.1</td>
											<td style="padding-left: 5px; font-size: 8pt; text-align: left">krótkoterminowe</td>
										</tr>
									</tbody>
								</table>
							</td>
							<xsl:call-template name="Rb-N_daneTabelaA">
								<xsl:with-param name="symbol" select="'N2.1'"/>
								<xsl:with-param name="ostWiersz" select="false()"/>
							</xsl:call-template>
						</tr>
						<tr>
							<td class="right-bottom-mixed" style="font-size: 8pt; text-align: left" valign="middle">
								<table cellpadding="0" cellspacing="0" border="0">
									<tbody>
										<tr>
											<td style="padding-left: 10px; width: 10px; font-size: 8pt; text-align: center">N2.2</td>
											<td style="padding-left: 5px; font-size: 8pt; text-align: left">długoterminowe</td>
										</tr>
									</tbody>
								</table>
							</td>
							<xsl:call-template name="Rb-N_daneTabelaA">
								<xsl:with-param name="symbol" select="'N2.2'"/>
								<xsl:with-param name="ostWiersz" select="false()"/>
							</xsl:call-template>
						</tr>
						<tr>
							<td class="right-bottom-mixed" style="font-size: 8pt; text-align: left" valign="middle">
								<table cellpadding="0" cellspacing="0" border="0">
									<tbody>
										<tr>
											<td style="width: 10px; font-size: 8pt; text-align: center">N3</td>
											<td style="padding-left: 5px; font-size: 8pt; text-align: left">gotówka i depozyty (N3.1+N3.2+N3.3)</td>
										</tr>
									</tbody>
								</table>
							</td>
							<xsl:call-template name="Rb-N_daneTabelaA">
								<xsl:with-param name="symbol" select="'N3'"/>
								<xsl:with-param name="ostWiersz" select="false()"/>
							</xsl:call-template>
						</tr>
						<tr>
							<td class="right-bottom-mixed" style="font-size: 8pt; text-align: left" valign="middle">
								<table cellpadding="0" cellspacing="0" border="0">
									<tbody>
										<tr>
											<td style="padding-left: 10px; width: 10px; font-size: 8pt; text-align: center">N3.1</td>
											<td style="padding-left: 5px; font-size: 8pt; text-align: left">gotówka</td>
										</tr>
									</tbody>
								</table>
							</td>
							<xsl:call-template name="Rb-N_daneTabelaA">
								<xsl:with-param name="symbol" select="'N3.1'"/>
								<xsl:with-param name="ostWiersz" select="false()"/>
							</xsl:call-template>
						</tr>
						<tr>
							<td class="right-bottom-mixed" style="font-size: 8pt; text-align: left" valign="middle">
								<table cellpadding="0" cellspacing="0" border="0">
									<tbody>
										<tr>
											<td style="padding-left: 10px; width: 10px; font-size: 8pt; text-align: center">N3.2</td>
											<td style="padding-left: 5px; font-size: 8pt; text-align: left">depozyty na żądanie</td>
										</tr>
									</tbody>
								</table>
							</td>
							<xsl:call-template name="Rb-N_daneTabelaA">
								<xsl:with-param name="symbol" select="'N3.2'"/>
								<xsl:with-param name="ostWiersz" select="false()"/>
							</xsl:call-template>
						</tr>
						<tr>
							<td class="right-bottom-mixed" style="font-size: 8pt; text-align: left" valign="middle">
								<table cellpadding="0" cellspacing="0" border="0">
									<tbody>
										<tr>
											<td style="padding-left: 10px; width: 10px; font-size: 8pt; text-align: center">N3.3</td>
											<td style="padding-left: 5px; font-size: 8pt; text-align: left">depozyty terminowe</td>
										</tr>
									</tbody>
								</table>
							</td>
							<xsl:call-template name="Rb-N_daneTabelaA">
								<xsl:with-param name="symbol" select="'N3.3'"/>
								<xsl:with-param name="ostWiersz" select="false()"/>
							</xsl:call-template>
						</tr>
						<tr>
							<td class="right-bottom-mixed" style="font-size: 8pt; text-align: left" valign="middle">
								<table cellpadding="0" cellspacing="0" border="0">
									<tbody>
										<tr>
											<td style="width: 10px; font-size: 8pt; text-align: center">N4</td>
											<td style="padding-left: 5px; font-size: 8pt; text-align: left">należności wymagalne (N4.1+N4.2)</td>
										</tr>
									</tbody>
								</table>
							</td>
							<xsl:call-template name="Rb-N_daneTabelaA">
								<xsl:with-param name="symbol" select="'N4'"/>
								<xsl:with-param name="ostWiersz" select="false()"/>
							</xsl:call-template>
						</tr>
						<tr>
							<td class="right-bottom-mixed" style="font-size: 8pt; text-align: left" valign="middle">
								<table cellpadding="0" cellspacing="0" border="0">
									<tbody>
										<tr>
											<td style="padding-left: 10px; width: 10px; font-size: 8pt; text-align: center">N4.1</td>
											<td style="padding-left: 5px; font-size: 8pt; text-align: left">z tytułu dostaw towarów i usług</td>
										</tr>
									</tbody>
								</table>
							</td>
							<xsl:call-template name="Rb-N_daneTabelaA">
								<xsl:with-param name="symbol" select="'N4.1'"/>
								<xsl:with-param name="ostWiersz" select="false()"/>
							</xsl:call-template>
						</tr>
						<tr>
							<td class="right-bottom-mixed" style="font-size: 8pt; text-align: left" valign="middle">
								<table cellpadding="0" cellspacing="0" border="0">
									<tbody>
										<tr>
											<td style="padding-left: 10px; width: 10px; font-size: 8pt; text-align: center">N4.2</td>
											<td style="padding-left: 5px; font-size: 8pt; text-align: left">pozostałe</td>
										</tr>
									</tbody>
								</table>
							</td>
							<xsl:call-template name="Rb-N_daneTabelaA">
								<xsl:with-param name="symbol" select="'N4.2'"/>
								<xsl:with-param name="ostWiersz" select="false()"/>
							</xsl:call-template>
						</tr>
						<tr>
							<td class="right-bottom-mixed" style="font-size: 8pt; text-align: left" valign="middle">
								<table cellpadding="0" cellspacing="0" border="0">
									<tbody>
										<tr>
											<td style="width: 10px; font-size: 8pt; text-align: center">N5</td>
											<td style="padding-left: 5px; font-size: 8pt; text-align: left">pozostałe należności (N5.1+N5.2+N5.3)</td>
										</tr>
									</tbody>
								</table>
							</td>
							<xsl:call-template name="Rb-N_daneTabelaA">
								<xsl:with-param name="symbol" select="'N5'"/>
								<xsl:with-param name="ostWiersz" select="false()"/>
							</xsl:call-template>
						</tr>
						<tr>
							<td class="right-bottom-mixed" style="font-size: 8pt; text-align: left" valign="middle">
								<table cellpadding="0" cellspacing="0" border="0">
									<tbody>
										<tr>
											<td style="padding-left: 10px; width: 10px; font-size: 8pt; text-align: center">N5.1</td>
											<td style="padding-left: 5px; font-size: 8pt; text-align: left">z tytułu dostaw towarów i usług</td>
										</tr>
									</tbody>
								</table>
							</td>
							<xsl:call-template name="Rb-N_daneTabelaA">
								<xsl:with-param name="symbol" select="'N5.1'"/>
								<xsl:with-param name="ostWiersz" select="false()"/>
							</xsl:call-template>
						</tr>
						<tr>
							<td class="right-bottom-mixed" style="font-size: 8pt; text-align: left" valign="middle">
								<table cellpadding="0" cellspacing="0" border="0">
									<tbody>
										<tr>
											<td style="padding-left: 10px; width: 10px; font-size: 8pt; text-align: center">N5.2</td>
											<td style="padding-left: 5px; font-size: 8pt; text-align: left">z tytułu podatków i składek na ubezpieczenia społ.</td>
										</tr>
									</tbody>
								</table>
							</td>
							<xsl:call-template name="Rb-N_daneTabelaA">
								<xsl:with-param name="symbol" select="'N5.2'"/>
								<xsl:with-param name="ostWiersz" select="false()"/>
							</xsl:call-template>
						</tr>
						<tr>
							<td class="bottom-right-bold" style="font-size: 8pt; text-align: left" valign="middle">
								<table cellpadding="0" cellspacing="0" border="0">
									<tbody>
										<tr>
											<td style="padding-left: 10px; width: 10px; font-size: 8pt; text-align: center">N5.3</td>
											<td style="padding-left: 5px; font-size: 8pt; text-align: left">z tytułu innych niż wymienione powyżej.</td>
										</tr>
									</tbody>
								</table>
							</td>
							<xsl:call-template name="Rb-N_daneTabelaA">
								<xsl:with-param name="symbol" select="'N5.3'"/>
								<xsl:with-param name="ostWiersz" select="true()"/>
							</xsl:call-template>
						</tr>
					</tbody>
				</table>
				<div style="margin: 10px 0; font-size: 12pt">B. Należności z tytułu udzielonych poręczeń i gwarancji</div>
				<table cellpadding="0" cellspacing="0" class="all-normal" style="margin-bottom: 60px">
					<tbody>
						<tr>
							<td rowspan="2" style="font-size: 8pt; font-weight: bold; text-align: center" class="bottom-right-normal">Wyszczególnienie</td>
							<td rowspan="2" style="font-size: 8pt; font-weight: bold; width: 10em; text-align: center" class="bottom-right-normal">kwota należności ogółem (kol.3+8)</td>
							<td colspan="6" style="font-size: 8pt; font-weight: bold; text-align: center" class="bottom-right-normal">dłużnicy</td>
						</tr>
						<tr>
							<td style="font-size: 7pt; font-weight: bold; width: 10em; text-align: center" class="bottom-right-normal">podmioty sektora finansów publicznych (kol.4+5+6+7)</td>
							<td style="font-size: 7pt; font-weight: bold; width: 10em; text-align: center" class="bottom-right-normal">grupa I</td>
							<td style="font-size: 7pt; font-weight: bold; width: 10em; text-align: center" class="bottom-right-normal">grupa II</td>
							<td style="font-size: 7pt; font-weight: bold; width: 10em; text-align: center" class="bottom-right-normal">grupa III</td>
							<td style="font-size: 7pt; font-weight: bold; width: 10em; text-align: center" class="bottom-right-normal">grupa IV</td>
							<td style="font-size: 7pt; font-weight: bold; width: 10em; text-align: center" class="bottom-right-normal">pozostałe podmioty</td>
						</tr>
						<tr>
							<td class="bottom-right-normal" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="1"/>
							</td>
							<td class="bottom-right-normal" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="2"/>
							</td>
							<td class="bottom-right-normal" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="3"/>
							</td>
							<td class="bottom-right-normal" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="4"/>
							</td>
							<td class="bottom-right-normal" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="5"/>
							</td>
							<td class="bottom-right-normal" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="6"/>
							</td>
							<td class="bottom-right-normal" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="7"/>
							</td>
							<td class="bottom-right-normal" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="8"/>
							</td>
						</tr>
						<tr>
							<td class="bottom-right-normal" style="font-size: 8pt; text-align: left" valign="middle">
								<table cellpadding="0" cellspacing="0" border="0">
									<tbody>
										<tr>
											<td style="width: 10px; font-size: 8pt; text-align: center">B1</td>
											<td style="padding-left: 5px; font-size: 8pt; text-align: left">należność główna z tytułu udzielonych gwarancji i poręczeń</td>
										</tr>
									</tbody>
								</table>
							</td>
							<xsl:call-template name="Rb-N_daneTabelaB">
								<xsl:with-param name="symbol" select="'B1'"/>
							</xsl:call-template>
						</tr>
						<tr>
							<td class="bottom-right-normal" style="font-size: 8pt; text-align: left" valign="middle">
								<table cellpadding="0" cellspacing="0" border="0">
									<tbody>
										<tr>
											<td style="width: 10px; font-size: 8pt; text-align: center">B2</td>
											<td style="padding-left: 5px; font-size: 8pt; text-align: left">odsetki ustawowe od należności głównej z tytułu udzielonych gwarancji i poręczeń</td>
										</tr>
									</tbody>
								</table>
							</td>
							<xsl:call-template name="Rb-N_daneTabelaB">
								<xsl:with-param name="symbol" select="'B2'"/>
							</xsl:call-template>
						</tr>
						<tr>
							<td class="bottom-right-normal" style="font-size: 8pt; text-align: left" valign="middle">
								<table cellpadding="0" cellspacing="0" border="0">
									<tbody>
										<tr>
											<td style="width: 10px; font-size: 8pt; text-align: center">B3</td>
											<td style="padding-left: 5px; font-size: 8pt; text-align: left">wartość spłat dokonanych w okresie sprawozdawczym za dłużników z tytułu udzielonych poręczeń i gwarancji (wydatki)</td>
										</tr>
									</tbody>
								</table>
							</td>
							<xsl:call-template name="Rb-N_daneTabelaB">
								<xsl:with-param name="symbol" select="'B3'"/>
							</xsl:call-template>
						</tr>
						<tr>
							<td class="bottom-right-normal" style="font-size: 8pt; text-align: left" valign="middle">
								<table cellpadding="0" cellspacing="0" border="0">
									<tbody>
										<tr>
											<td style="width: 10px; font-size: 8pt; text-align: center">B4</td>
											<td style="padding-left: 5px; font-size: 8pt; text-align: left">kwota odzyskanych wierzytelności w okresie sprawozdawczym od dłużników z tytułu poręczeń lub gwarancji (dochody)</td>
										</tr>
									</tbody>
								</table>
							</td>
							<xsl:call-template name="Rb-N_daneTabelaB">
								<xsl:with-param name="symbol" select="'B4'"/>
							</xsl:call-template>
						</tr>
					</tbody>
				</table>
				<table cellpadding="0" cellspacing="0" class="all-bold" style="margin-bottom: 20px; width: 100%">
					<tbody>
						<tr style="height: 30px" valign="top">
							<td class="bottom-bold" style="font-size: 9pt; font-weight: bold; text-align:left; padding: 3px 10px; margin-left: 5px; margin-bottom: 25px">Wyjaśnienia do sprawozdania Rb-N</td>
						</tr>
						<tr style="min-height: 50px; height: 70px" valign="top">
							<td style="text-align: left; font-size: 8pt; padding: 3px 10px">
								<xsl:value-of select="Naglowek/Uwagi"/>
							</td>
						</tr>
					</tbody>
				</table>
				<xsl:if test="Naleznosci/Pozycja[child::Uwagi]">
					<table cellpadding="0" cellspacing="0" class="all-bold" style="margin-bottom: 20px; width: 100%">
						<tbody>
							<tr>
								<td colspan="3" style="text-align: center; font-size: 9pt; font-weight: bold; padding: 3px 10px">
									<div>Uwagi do części: "Należności oraz wybrane aktywa finansowe"</div>
								</td>
							</tr>
							<tr>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 4px 4px 0; width: 6%">Symbol</td>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 4px 4px 0; width: 24%">Wyszczególnienie</td>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 0 4px 0">Uwaga</td>
							</tr>
							<xsl:for-each select="Naleznosci/Pozycja[child::Uwagi]">
								<xsl:sort select="Symbol"/>
								<tr>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="Symbol"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:choose>
											<xsl:when test="Symbol = 'N1'">papiery wartościowe (N1.1+N1.2)</xsl:when>
											<xsl:when test="Symbol = 'N1.1'">krótkoterminowe</xsl:when>
											<xsl:when test="Symbol = 'N1.2'">długoterminowe</xsl:when>
											<xsl:when test="Symbol = 'N2'">pożyczki (N2.1+N2.2)</xsl:when>
											<xsl:when test="Symbol = 'N2.1'">krótkoterminowe</xsl:when>
											<xsl:when test="Symbol = 'N2.2'">długoterminowe</xsl:when>
											<xsl:when test="Symbol = 'N3'">gotówka i depozyty (N3.1+N3.2+N3.3)</xsl:when>
											<xsl:when test="Symbol = 'N3.1'">gotówka</xsl:when>
											<xsl:when test="Symbol = 'N3.2'">depozyty na żądanie</xsl:when>
											<xsl:when test="Symbol = 'N3.3'">depozyty terminowe</xsl:when>
											<xsl:when test="Symbol = 'N4'">należności wymagalne (N4.1+N4.2)</xsl:when>
											<xsl:when test="Symbol = 'N4.1'">z tytułu dostaw towarów i usług</xsl:when>
											<xsl:when test="Symbol = 'N4.2'">pozostałe</xsl:when>
											<xsl:when test="Symbol = 'N5'">pozostałe należności (N5.1+N5.2+N5.3)</xsl:when>
											<xsl:when test="Symbol = 'N5.1'">z tytułu dostaw towarów i usług</xsl:when>
											<xsl:when test="Symbol = 'N5.2'">z tytułu podatków i składek na ubezpieczenia społ.</xsl:when>
											<xsl:when test="Symbol = 'N5.3'">z tytułu innych niż wymienione powyżej.</xsl:when>
										</xsl:choose>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:value-of select="Uwagi"/>
									</td>
								</tr>
							</xsl:for-each>
						</tbody>
					</table>
				</xsl:if>
				<xsl:if test="PoreczeniaGwarancje/Pozycja[child::Uwagi]">
					<table cellpadding="0" cellspacing="0" class="all-bold" style="margin-bottom: 20px; width: 100%">
						<tbody>
							<tr>
								<td colspan="3" style="text-align: center; font-size: 9pt; font-weight: bold; padding: 3px 10px">
									<div>Uwagi do części: "Poręczenia i gwarancje"</div>
								</td>
							</tr>
							<tr>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 4px 4px 0; width: 6%">Symbol</td>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 4px 4px 0; width: 24%">Wyszczególnienie</td>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 0 4px 0">Uwaga</td>
							</tr>
							<xsl:for-each select="PoreczeniaGwarancje/Pozycja[child::Uwagi]">
								<xsl:sort select="Symbol"/>
								<tr>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="Symbol"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:choose>
											<xsl:when test="Symbol = 'B1'">należność główna z tytułu udzielonych gwarancji i poręczeń</xsl:when>
											<xsl:when test="Symbol = 'B2'">odsetki ustawowe od należności głównej z tytułu udzielonych gwarancji i poręczeń</xsl:when>
											<xsl:when test="Symbol = 'B3'">wartość spłat dokonanych w okresie sprawozdawczym za dłużników z tytułu udzielonych poręczeń i gwarancji (wydatki)</xsl:when>
											<xsl:when test="Symbol = 'B4'">kwota odzyskanych wierzytelności w okresie sprawozdawczym od dłużników z tytułu poręczeń lub gwarancji (dochody)</xsl:when>
										</xsl:choose>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:value-of select="Uwagi"/>
									</td>
								</tr>
							</xsl:for-each>
						</tbody>
					</table>
				</xsl:if>
				<div style="margin-bottom: 40px">
					<div style="display: block; font-size: 7pt">
						<sup>1)</sup> Niepotrzebne skreślić.          </div>
					<div style="display: block; font-size: 7pt">
						<sup>2)</sup> Wypełnić, gdy dotyczy.          </div>
				</div>
				<table cellpadding="0" cellspacing="0" style="margin-bottom: 50px; margin-top: 80px; width: 80%;">
					<tbody>
						<tr>
							<td style="text-align:center; font-size: 8pt; " valign="bottom" width="25%">
								<hr style="width: 90%;text-align:center; "/>
								<div style="text-align:center;">główny księgowy <sup>*</sup>/skarbnik</div>
								<div style="display: block; font-size: 7pt">
									<sup>*</sup>Nie dotyczy sprawozdań zbiorczych sporządzanych przez RIO. W przypadku braku głównego księgowego podpisuje tylko kierownik jednostki.
          </div>
							</td>
							<td style="text-align:center; font-size: 8pt; " valign="baseline" width="25%">
								<hr style="width: 90%;text-align:center"/>
								<div style="text-align:center;">telefon</div>
							</td>
							<td style="text-align:center; font-size: 8pt;  " valign="baseline" width="25%">
								<hr style="width: 90%;text-align:center"/>
								<div style="text-align:center;">rok mc dzień</div>
							</td>
							<td style="text-align:center; font-size: 8pt;  " valign="baseline" width="25%">
								<hr style="width: 90%;text-align:center"/>
								<div style="text-align:center;">kierownik jednostki (jednostki obsługującej) / przewodniczący zarządu</div>
							</td>
						</tr>
						<tr>
							<td style="text-align:center; font-size: 8pt;">
								<div>
									<xsl:for-each select="../../Podpisy/*[name() = 'ds:Signature']">
										<xsl:if test="contains(@Id, 'RbN')">
											<xsl:if test="contains(translate(*[name() = 'ds:Object']/*[name() = 'xades:QualifyingProperties']/*[name() = 'xades:SignedProperties']/*[name() = 'xades:SignedSignatureProperties']/*[name() = 'xades:SignerRole']/*[name() = 'xades:ClaimedRoles']/*[name() = 'xades:ClaimedRole']/*[name() = 'Role'], 'S','s'),'skarbnik')">
												<xsl:value-of select="substring(*[name() = 'ds:Object']/*[name() = 'xades:QualifyingProperties']/*[name() = 'xades:SignedProperties']/*[name() = 'xades:SignedSignatureProperties']/*[name() = 'xades:SigningTime'], 1, 10)"/>
											</xsl:if>
										</xsl:if>
									</xsl:for-each>
								</div>
							</td>
							<td style="text-align:center; font-size: 8pt;">
								<div>
									<xsl:for-each select="../../Podpisy/*[name() = 'ds:Signature']">
										<xsl:if test="contains(@Id, 'RbN')">
											<xsl:if test="contains(translate(*[name() = 'ds:Object']/*[name() = 'xades:QualifyingProperties']/*[name() = 'xades:SignedProperties']/*[name() = 'xades:SignedSignatureProperties']/*[name() = 'xades:SignerRole']/*[name() = 'xades:ClaimedRoles']/*[name() = 'xades:ClaimedRole']/*[name() = 'Role'], 'K','k'),'kierownik')">
												<xsl:value-of select="substring(*[name() = 'ds:Object']/*[name() = 'xades:QualifyingProperties']/*[name() = 'xades:SignedProperties']/*[name() = 'xades:SignedSignatureProperties']/*[name() = 'xades:SigningTime'], 1,10)"/>
											</xsl:if>
										</xsl:if>
									</xsl:for-each>
								</div>
							</td>
						</tr>
					</tbody>
				</table>
			</div>
			<xsl:element name="a">
				<xsl:attribute name="href"><xsl:value-of select="concat('#Jed', $jedIndex)"/></xsl:attribute>
				<xsl:element name="style">
					<xsl:value-of select="'font-family: Verdana'"/>
				</xsl:element>
				<xsl:value-of select="'Powrót do listy sprawozdań jednostki'"/>
			</xsl:element>
		</xsl:element>
	</xsl:template>
	<!-- Rb-N szablony pomocnicze -->
	<xsl:template name="Rb-N_daneTabelaA">
		<xsl:param name="symbol"/>
		<xsl:param name="ostWiersz" select="false()"/>
		<xsl:choose>
			<xsl:when test="$ostWiersz = false()">
				<td class="right-bottom-mixed" style="text-align:right;font-size: 8pt; padding: 3px">
					<xsl:choose>
						<xsl:when test="Naleznosci/Pozycja[child::Symbol = $symbol][1]/N">
							<xsl:value-of select="format-number(Naleznosci/Pozycja[child::Symbol = $symbol][1]/N, '#&#160;##0,00')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'0,00'"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td class="bottom-right-normal" style="text-align:right;font-size: 8pt; padding: 3px">
					<xsl:choose>
						<xsl:when test="Naleznosci/Pozycja[child::Symbol = $symbol][1]/KO">
							<xsl:value-of select="format-number(Naleznosci/Pozycja[child::Symbol = $symbol][1]/KO, '#&#160;##0,00')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'0,00'"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td class="bottom-right-normal" style="text-align:right;font-size: 8pt; padding: 3px">
					<xsl:choose>
						<xsl:when test="Naleznosci/Pozycja[child::Symbol = $symbol][1]/KFP">
							<xsl:value-of select="format-number(Naleznosci/Pozycja[child::Symbol = $symbol][1]/KFP, '#&#160;##0,00')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'0,00'"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td class="bottom-right-normal" style="text-align:right;font-size: 8pt; padding: 3px">
					<xsl:choose>
						<xsl:when test="Naleznosci/Pozycja[child::Symbol = $symbol][1]/KG1">
							<xsl:value-of select="format-number(Naleznosci/Pozycja[child::Symbol = $symbol][1]/KG1, '#&#160;##0,00')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'0,00'"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td class="bottom-right-normal" style="text-align:right;font-size: 8pt; padding: 3px">
					<xsl:choose>
						<xsl:when test="Naleznosci/Pozycja[child::Symbol = $symbol][1]/KG2">
							<xsl:value-of select="format-number(Naleznosci/Pozycja[child::Symbol = $symbol][1]/KG2, '#&#160;##0,00')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'0,00'"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td class="bottom-right-normal" style="text-align:right;font-size: 8pt; padding: 3px">
					<xsl:choose>
						<xsl:when test="Naleznosci/Pozycja[child::Symbol = $symbol][1]/KG3">
							<xsl:value-of select="format-number(Naleznosci/Pozycja[child::Symbol = $symbol][1]/KG3, '#&#160;##0,00')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'0,00'"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td class="bottom-right-normal" style="text-align:right;font-size: 8pt; padding: 3px">
					<xsl:choose>
						<xsl:when test="Naleznosci/Pozycja[child::Symbol = $symbol][1]/KG4">
							<xsl:value-of select="format-number(Naleznosci/Pozycja[child::Symbol = $symbol][1]/KG4, '#&#160;##0,00')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'0,00'"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td class="bottom-right-normal" style="text-align:right;font-size: 8pt; padding: 3px">
					<xsl:choose>
						<xsl:when test="Naleznosci/Pozycja[child::Symbol = $symbol][1]/KBC">
							<xsl:value-of select="format-number(Naleznosci/Pozycja[child::Symbol = $symbol][1]/KBC, '#&#160;##0,00')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'0,00'"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td class="bottom-right-normal" style="text-align:right;font-size: 8pt; padding: 3px">
					<xsl:choose>
						<xsl:when test="Naleznosci/Pozycja[child::Symbol = $symbol][1]/KBK">
							<xsl:value-of select="format-number(Naleznosci/Pozycja[child::Symbol = $symbol][1]/KBK, '#&#160;##0,00')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'0,00'"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td class="bottom-right-normal" style="text-align:right;font-size: 8pt; padding: 3px">
					<xsl:choose>
						<xsl:when test="Naleznosci/Pozycja[child::Symbol = $symbol][1]/KIF">
							<xsl:value-of select="format-number(Naleznosci/Pozycja[child::Symbol = $symbol][1]/KIF, '#&#160;##0,00')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'0,00'"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td class="bottom-right-normal" style="text-align:right;font-size: 8pt; padding: 3px">
					<xsl:choose>
						<xsl:when test="Naleznosci/Pozycja[child::Symbol = $symbol][1]/KPN">
							<xsl:value-of select="format-number(Naleznosci/Pozycja[child::Symbol = $symbol][1]/KPN, '#&#160;##0,00')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'0,00'"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td class="bottom-right-normal" style="text-align:right;font-size: 8pt; padding: 3px">
					<xsl:choose>
						<xsl:when test="Naleznosci/Pozycja[child::Symbol = $symbol][1]/KGD">
							<xsl:value-of select="format-number(Naleznosci/Pozycja[child::Symbol = $symbol][1]/KGD, '#&#160;##0,00')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'0,00'"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td class="right-bottom-mixed" style="text-align:right;font-size: 8pt; padding: 3px">
					<xsl:choose>
						<xsl:when test="Naleznosci/Pozycja[child::Symbol = $symbol][1]/KIN">
							<xsl:value-of select="format-number(Naleznosci/Pozycja[child::Symbol = $symbol][1]/KIN, '#&#160;##0,00')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'0,00'"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td class="bottom-right-normal" style="text-align:right;font-size: 8pt; padding: 3px">
					<xsl:choose>
						<xsl:when test="Naleznosci/Pozycja[child::Symbol = $symbol][1]/ZO">
							<xsl:value-of select="format-number(Naleznosci/Pozycja[child::Symbol = $symbol][1]/ZO, '#&#160;##0,00')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'0,00'"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td class="bottom-right-normal" style="text-align:right;font-size: 8pt; padding: 3px">
					<xsl:choose>
						<xsl:when test="Naleznosci/Pozycja[child::Symbol = $symbol][1]/ZSE">
							<xsl:value-of select="format-number(Naleznosci/Pozycja[child::Symbol = $symbol][1]/ZSE, '#&#160;##0,00')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'0,00'"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td class="right-bottom-mixed" style="text-align:right;font-size: 8pt; padding: 3px">
					<xsl:choose>
						<xsl:when test="Naleznosci/Pozycja[child::Symbol = $symbol][1]/ZPZ">
							<xsl:value-of select="format-number(Naleznosci/Pozycja[child::Symbol = $symbol][1]/ZPZ, '#&#160;##0,00')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'0,00'"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
			</xsl:when>
			<xsl:otherwise>
				<td class="bottom-right-bold" style="text-align:right;font-size: 8pt; padding: 3px">
					<xsl:choose>
						<xsl:when test="Naleznosci/Pozycja[child::Symbol = $symbol][1]/N">
							<xsl:value-of select="format-number(Naleznosci/Pozycja[child::Symbol = $symbol][1]/N, '#&#160;##0,00')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'0,00'"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td class="bottom-right-mixed" style="text-align:right;font-size: 8pt; padding: 3px">
					<xsl:choose>
						<xsl:when test="Naleznosci/Pozycja[child::Symbol = $symbol][1]/KO">
							<xsl:value-of select="format-number(Naleznosci/Pozycja[child::Symbol = $symbol][1]/KO, '#&#160;##0,00')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'0,00'"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td class="bottom-right-mixed" style="text-align:right;font-size: 8pt; padding: 3px">
					<xsl:choose>
						<xsl:when test="Naleznosci/Pozycja[child::Symbol = $symbol][1]/KFP">
							<xsl:value-of select="format-number(Naleznosci/Pozycja[child::Symbol = $symbol][1]/KFP, '#&#160;##0,00')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'0,00'"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td class="bottom-right-mixed" style="text-align:right;font-size: 8pt; padding: 3px">
					<xsl:choose>
						<xsl:when test="Naleznosci/Pozycja[child::Symbol = $symbol][1]/KG1">
							<xsl:value-of select="format-number(Naleznosci/Pozycja[child::Symbol = $symbol][1]/KG1, '#&#160;##0,00')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'0,00'"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td class="bottom-right-mixed" style="text-align:right;font-size: 8pt; padding: 3px">
					<xsl:choose>
						<xsl:when test="Naleznosci/Pozycja[child::Symbol = $symbol][1]/KG2">
							<xsl:value-of select="format-number(Naleznosci/Pozycja[child::Symbol = $symbol][1]/KG2, '#&#160;##0,00')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'0,00'"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td class="bottom-right-mixed" style="text-align:right;font-size: 8pt; padding: 3px">
					<xsl:choose>
						<xsl:when test="Naleznosci/Pozycja[child::Symbol = $symbol][1]/KG3">
							<xsl:value-of select="format-number(Naleznosci/Pozycja[child::Symbol = $symbol][1]/KG3, '#&#160;##0,00')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'0,00'"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td class="bottom-right-mixed" style="text-align:right;font-size: 8pt; padding: 3px">
					<xsl:choose>
						<xsl:when test="Naleznosci/Pozycja[child::Symbol = $symbol][1]/KG4">
							<xsl:value-of select="format-number(Naleznosci/Pozycja[child::Symbol = $symbol][1]/KG4, '#&#160;##0,00')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'0,00'"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td class="bottom-right-mixed" style="text-align:right;font-size: 8pt; padding: 3px">
					<xsl:choose>
						<xsl:when test="Naleznosci/Pozycja[child::Symbol = $symbol][1]/KBC">
							<xsl:value-of select="format-number(Naleznosci/Pozycja[child::Symbol = $symbol][1]/KBC, '#&#160;##0,00')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'0,00'"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td class="bottom-right-mixed" style="text-align:right;font-size: 8pt; padding: 3px">
					<xsl:choose>
						<xsl:when test="Naleznosci/Pozycja[child::Symbol = $symbol][1]/KBK">
							<xsl:value-of select="format-number(Naleznosci/Pozycja[child::Symbol = $symbol][1]/KBK, '#&#160;##0,00')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'0,00'"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td class="bottom-right-mixed" style="text-align:right;font-size: 8pt; padding: 3px">
					<xsl:choose>
						<xsl:when test="Naleznosci/Pozycja[child::Symbol = $symbol][1]/KIF">
							<xsl:value-of select="format-number(Naleznosci/Pozycja[child::Symbol = $symbol][1]/KIF, '#&#160;##0,00')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'0,00'"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td class="bottom-right-mixed" style="text-align:right;font-size: 8pt; padding: 3px">
					<xsl:choose>
						<xsl:when test="Naleznosci/Pozycja[child::Symbol = $symbol][1]/KPN">
							<xsl:value-of select="format-number(Naleznosci/Pozycja[child::Symbol = $symbol][1]/KPN, '#&#160;##0,00')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'0,00'"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td class="bottom-right-mixed" style="text-align:right;font-size: 8pt; padding: 3px">
					<xsl:choose>
						<xsl:when test="Naleznosci/Pozycja[child::Symbol = $symbol][1]/KGD">
							<xsl:value-of select="format-number(Naleznosci/Pozycja[child::Symbol = $symbol][1]/KGD, '#&#160;##0,00')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'0,00'"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td class="bottom-right-bold" style="text-align:right;font-size: 8pt; padding: 3px">
					<xsl:choose>
						<xsl:when test="Naleznosci/Pozycja[child::Symbol = $symbol][1]/KIN">
							<xsl:value-of select="format-number(Naleznosci/Pozycja[child::Symbol = $symbol][1]/KIN, '#&#160;##0,00')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'0,00'"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td class="bottom-right-mixed" style="text-align:right;font-size: 8pt; padding: 3px">
					<xsl:choose>
						<xsl:when test="Naleznosci/Pozycja[child::Symbol = $symbol][1]/ZO">
							<xsl:value-of select="format-number(Naleznosci/Pozycja[child::Symbol = $symbol][1]/ZO, '#&#160;##0,00')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'0,00'"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td class="bottom-right-mixed" style="text-align:right;font-size: 8pt; padding: 3px">
					<xsl:choose>
						<xsl:when test="Naleznosci/Pozycja[child::Symbol = $symbol][1]/ZSE">
							<xsl:value-of select="format-number(Naleznosci/Pozycja[child::Symbol = $symbol][1]/ZSE, '#&#160;##0,00')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'0,00'"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td class="bottom-right-bold" style="text-align:right;font-size: 8pt; padding: 3px">
					<xsl:choose>
						<xsl:when test="Naleznosci/Pozycja[child::Symbol = $symbol][1]/ZPZ">
							<xsl:value-of select="format-number(Naleznosci/Pozycja[child::Symbol = $symbol][1]/ZPZ, '#&#160;##0,00')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'0,00'"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="Rb-N_daneTabelaB">
		<xsl:param name="symbol"/>
		<td class="bottom-right-normal" style="text-align:right;font-size: 8pt; padding: 3px">
			<xsl:choose>
				<xsl:when test="PoreczeniaGwarancje/Pozycja[child::Symbol = $symbol][1]/O">
					<xsl:value-of select="format-number(PoreczeniaGwarancje/Pozycja[child::Symbol = $symbol][1]/O, '#&#160;##0,00')"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="'0,00'"/>
				</xsl:otherwise>
			</xsl:choose>
		</td>
		<td class="bottom-right-normal" style="text-align:right;font-size: 8pt; padding: 3px">
			<xsl:choose>
				<xsl:when test="PoreczeniaGwarancje/Pozycja[child::Symbol = $symbol][1]/FP">
					<xsl:value-of select="format-number(PoreczeniaGwarancje/Pozycja[child::Symbol = $symbol][1]/FP, '#&#160;##0,00')"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="'0,00'"/>
				</xsl:otherwise>
			</xsl:choose>
		</td>
		<td class="bottom-right-normal" style="text-align:right;font-size: 8pt; padding: 3px">
			<xsl:choose>
				<xsl:when test="PoreczeniaGwarancje/Pozycja[child::Symbol = $symbol][1]/G1">
					<xsl:value-of select="format-number(PoreczeniaGwarancje/Pozycja[child::Symbol = $symbol][1]/G1, '#&#160;##0,00')"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="'0,00'"/>
				</xsl:otherwise>
			</xsl:choose>
		</td>
		<td class="bottom-right-normal" style="text-align:right;font-size: 8pt; padding: 3px">
			<xsl:choose>
				<xsl:when test="PoreczeniaGwarancje/Pozycja[child::Symbol = $symbol][1]/G2">
					<xsl:value-of select="format-number(PoreczeniaGwarancje/Pozycja[child::Symbol = $symbol][1]/G2, '#&#160;##0,00')"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="'0,00'"/>
				</xsl:otherwise>
			</xsl:choose>
		</td>
		<td class="bottom-right-normal" style="text-align:right;font-size: 8pt; padding: 3px">
			<xsl:choose>
				<xsl:when test="PoreczeniaGwarancje/Pozycja[child::Symbol = $symbol][1]/G3">
					<xsl:value-of select="format-number(PoreczeniaGwarancje/Pozycja[child::Symbol = $symbol][1]/G3, '#&#160;##0,00')"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="'0,00'"/>
				</xsl:otherwise>
			</xsl:choose>
		</td>
		<td class="bottom-right-normal" style="text-align:right;font-size: 8pt; padding: 3px">
			<xsl:choose>
				<xsl:when test="PoreczeniaGwarancje/Pozycja[child::Symbol = $symbol][1]/G4">
					<xsl:value-of select="format-number(PoreczeniaGwarancje/Pozycja[child::Symbol = $symbol][1]/G4, '#&#160;##0,00')"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="'0,00'"/>
				</xsl:otherwise>
			</xsl:choose>
		</td>
		<td class="bottom-right-normal" style="text-align:right;font-size: 8pt; padding: 3px">
			<xsl:choose>
				<xsl:when test="PoreczeniaGwarancje/Pozycja[child::Symbol = $symbol][1]/PP">
					<xsl:value-of select="format-number(PoreczeniaGwarancje/Pozycja[child::Symbol = $symbol][1]/PP, '#&#160;##0,00')"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="'0,00'"/>
				</xsl:otherwise>
			</xsl:choose>
		</td>
	</xsl:template>
	<!-- Rb-Z -->
	<xsl:template match="Rb-Z">
		<xsl:param name="jedIndex"/>
		<xsl:param name="sprIndex"/>
		<xsl:element name="div">
			<xsl:attribute name="Id"><xsl:value-of select="concat('Jed', $jedIndex, 'Wer', $sprIndex)"/></xsl:attribute>
			<xsl:attribute name="style"><xsl:value-of select="'display: block; margin-bottom: 40px'"/></xsl:attribute>
			<div style="font-size: 12pt; font-weight: bold; margin-left: 5px; margin-bottom: 10px">
        Sprawozdanie Rb-Z:
        <xsl:choose>
					<xsl:when test="Naglowek/Wersja = 0">
						<xsl:value-of select="'wersja pierwotna'"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="concat('korekta nr ', Naglowek/Wersja)"/>
					</xsl:otherwise>
				</xsl:choose>
				<xsl:call-template name="SprNaglowekInfo"/>
			</div>
			<table cellpadding="0" cellspacing="0" class="all-bold" style="margin-bottom: 30px">
				<thead>
					<tr>
						<th style="width:333px"/>
						<th style="width: 56px"/>
						<th style="width: 565px"/>
						<th style="width: 37px"/>
						<th style="width: 265px"/>
					</tr>
				</thead>
				<tbody>
					<tr style="height: 18px">
						<td colspan="5" class="bottom-bold" style="font-size: 10pt;">MINISTERSTWO FINANSÓW, ul. Świętokrzyska 12, 00-916 Warszawa</td>
					</tr>
					<tr style="height: 127px">
						<td class="bottom-bold" style="width:333px">
							<table cellpadding="0" cellspacing="0" style="border-collapse: collapse; height" width="100%">
								<tbody>
									<tr style="height: 80px">
										<td style="text-align: left; font-size: 9pt; margin:1px 1px 0 0; padding:0" valign="top">
                      Nazwa i adres jednostki sprawozdawczej
                    </td>
									</tr>
									<tr>
										<td class="bottom-normal" style="text-align: center; font-size: 9pt" valign="bottom">
											<!-- popr. nr I.8 -->
											<div style="display: block;margin: 0 20px">
												<xsl:choose>
													<xsl:when test="Jednostka/Nazwa">
														<xsl:value-of select="Jednostka/Nazwa"/>
													</xsl:when>
													<xsl:otherwise>
														<xsl:value-of select="../../Nazwa"/>
													</xsl:otherwise>
												</xsl:choose>
												<!--<xsl:value-of select="../../Nazwa"/>-->
											</div>
										</td>
									</tr>
									<tr style="height: 23px">
										<td style="text-align: left; font-size: 9pt; margin:1px 1px 0 0; padding:0;" valign="top">
                      Numer identyfikacyjny REGON
                    </td>
									</tr>
									<tr>
										<td style="text-align: center; font-size: 9pt; font-weight: bold; margin:1px 1px 0 0; padding:0" valign="baseline">
											<xsl:choose>
												<xsl:when test="Jednostka/Regon">
													<xsl:value-of select="Jednostka/Regon"/>
												</xsl:when>
												<xsl:otherwise>
													<xsl:value-of select="../../Regon"/>
												</xsl:otherwise>
											</xsl:choose>
											<!--<xsl:value-of select="../../Regon"/>-->
										</td>
									</tr>
								</tbody>
							</table>
						</td>
						<td colspan="3" class="notop-bold" valign="top" style="width: 858px">
							<div style="font-weight: bold; text-align: center; font-size: 11pt; margin-bottom: 5px">Rb-Z KWARTALNE SPRAWOZDANIE O STANIE ZOBOWIĄZAŃ WEDŁUG TYTUŁÓW DŁUŻNYCH ORAZ GWARANCJI I PORĘCZEŃ</div>
							<div style="font-weight: bold; text-align: center; font-size: 9pt; margin-bottom: 5px">
                jednostki budżetowej / zakładu budżetowego/ gospodarstwa pomocniczego / funduszu celowego nieposiadającego osobowości prawnej / jednostki samorządu terytorialnego / państwowego funduszu celowego posiadającego osobowość prawną / samorządowego funduszu celowego / uczelni publicznej / instytucji gospodarki budżetowej / państwowej instytucji kultury/ państwowej instytucji filmowej / samorządowej instytucji kultury / samodzielnego publicznego zakładu opieki zdrowotnej nadzorowanego przez ministra, centralny organ administracji rządowej, wojewodę, państwową uczelnię medyczną lub państwową uczelnię prowadzącą działalność dydaktyczną i badawczą w dziedzinie nauk medycznych / samodzielnego publicznego zakładu opieki zdrowotnej nadzorowanego przez jednostkę samorządu terytorialnego / ZUS oraz funduszy zarządzanych przez ZUS / KRUS oraz funduszy zarządzanych przez KRUS / Polskiej Akademii Nauk i tworzonych przez nią jednostek organizacyjnych / Narodowego Funduszu Zdrowia / agencji państwowej, w tym wykonawczej / państwowej osoby prawnej z wyłączeniem agencji państwowych, w tym wykonawczych / samorządowej osoby prawnej <sup>



1)</sup>
							</div>
							<div style=" text-align: center; font-size: 9pt; margin-bottom: 5px">
                a)sprawozdanie jednostkowe  b)sprawozdanie zbiorcze   c)sprawozdanie łączne <sup>1)</sup>
							</div>
							<div style="vertical-align: bottom; text-align: center; font-size: 8pt; margin-top: 15px">
								<xsl:call-template name="NaglowekSprOkres"/>
							</div>
						</td>
						<td class="bottom-bold" style="text-align: left; font-size: 9pt; margin:2px 2px 0 0; padding:0; width: 265px" valign="top">
							<div style="margin-bottom:5px">Adresat:</div>
							<!-- popr. nr I.9 -->
							<div style="text-align:center; margin-bottom: 15px;">
								<!-- <xsl:value-of select="'Regionalna Izba Obrachunkowa w Katowicach'"/> -->
							</div>
							<div style="text-align:center;">
								<!-- <xsl:value-of select="'wersja robocza'"/> -->
							</div>
						</td>
					</tr>
					<tr style="height: 54px">
						<td colspan="2" style="font-size: 9pt; border-style: solid; border-width: 2px 0 0 0; border-color:black">
							<!-- popr. nr I.10 -->
							<div style="margin-bottom: 1px">
								<xsl:value-of select="'Nazwa województwa'"/>
								<!-- <xsl:if test="../../Typ = 'W'">
									<span style="margin-left: 10px">
										<b>
											<xsl:value-of select="../../Nazwa"/>
										</b>
									</span>
								</xsl:if> -->
							</div>
							<div style="margin-bottom: 1px">
								<xsl:value-of select="'Nazwa powiatu / związku '"/>
								<sup>1)</sup>
								<!-- <xsl:if test="../../Typ = 'P'">
									<span style="margin-left: 10px">
										<b>
											<xsl:value-of select="../../Nazwa"/>
										</b>
									</span>
								</xsl:if> -->
							</div>
							<div>
								<xsl:value-of select="'Nazwa gminy / związku '"/>
								<sup>1)</sup>
								<!-- <xsl:if test="../../Typ = 'G'">
									<span style="margin-left: 10px">
										<b>
											<xsl:value-of select="../../Nazwa"/>
										</b>
									</span>
								</xsl:if> -->
							</div>
						</td>
						<td style="border-style: solid; border-width: 0 2px 0 2px; border-color: black; margin: 0; padding: 0">
							<table cellpadding="0" cellspacing="0" border="0" style="height:100%;width:100%">
								<tbody>
									<tr>
										<td colspan="8" style="font-size:10pt; text-align:center; border-style: solid; border-width: 0 0 2px 0; border-color: black">SYMBOLE</td>
									</tr>
									<tr>
										<td style="font-size:10pt; text-align:center; border-style: solid; border-width: 0 2px 2px 0; border-color: black">WOJ.</td>
										<td style="font-size:10pt; text-align:center; border-style: solid; border-width: 0 2px 2px 0; border-color: black">POWIAT</td>
										<td style="font-size:10pt; text-align:center; border-style: solid; border-width: 0 2px 2px 0; border-color: black">GMINA</td>
										<td style="font-size:10pt; text-align:center; border-style: solid; border-width: 0 2px 2px 0; border-color: black">TYP GM.</td>
										<td style="font-size:10pt; text-align:center; border-style: solid; border-width: 0 2px 2px 0; border-color: black">ZWIĄZEK JST</td>
										<td style="font-size:10pt; text-align:center; border-style: solid; border-width: 0 2px 2px 0; border-color: black">TYP ZW.</td>
										<td style="font-size:10pt; text-align:center; border-style: solid; border-width: 0 2px 2px 0; border-color: black">Grupa</td>
										<td style="font-size:10pt; text-align:center; border-style: solid; border-width: 0 0 2px 0; border-color: black">część budz.</td>
									</tr>
									<tr>
										<td style="font-size:10pt; text-align:center; border-style: solid; border-width: 0 2px 0 0; border-color: black">
											<xsl:choose>
												<xsl:when test="Jednostka/WK">
													<xsl:value-of select="Jednostka/WK"/>
												</xsl:when>
												<xsl:otherwise>
													<xsl:value-of select="../../WK"/>
												</xsl:otherwise>
											</xsl:choose>
											<!--<xsl:value-of select="../../WK"/>-->
										</td>
										<td style="font-size:10pt; text-align:center; border-style: solid; border-width: 0 2px 0 0; border-color: black">
											<xsl:choose>
												<xsl:when test="Jednostka/PK">
													<xsl:value-of select="Jednostka/PK"/>
												</xsl:when>
												<xsl:otherwise>
													<xsl:value-of select="../../PK"/>
												</xsl:otherwise>
											</xsl:choose>
											<!--<xsl:value-of select="../../PK"/>-->
										</td>
										<td style="font-size:10pt; text-align:center; border-style: solid; border-width: 0 2px 0 0; border-color: black">
											<xsl:choose>
												<xsl:when test="Jednostka/GK">
													<xsl:value-of select="Jednostka/GK"/>
												</xsl:when>
												<xsl:otherwise>
													<xsl:value-of select="../../GK"/>
												</xsl:otherwise>
											</xsl:choose>
											<!--<xsl:value-of select="../../GK"/>-->
										</td>
										<td style="font-size:10pt; text-align:center; border-style: solid; border-width: 0 2px 0 0; border-color: black">
											<xsl:choose>
												<xsl:when test="Jednostka/GT">
													<xsl:value-of select="Jednostka/GT"/>
												</xsl:when>
												<xsl:otherwise>
													<xsl:value-of select="../../GT"/>
												</xsl:otherwise>
											</xsl:choose>
											<!--<xsl:value-of select="../../GT"/>-->
										</td>
										<td style="font-size:10pt; text-align:center; border-style: solid; border-width: 0 2px 0 0; border-color: black">
											<xsl:choose>
												<xsl:when test="Jednostka/KodMSWiA">
													<xsl:value-of select="Jednostka/KodMSWiA"/>
												</xsl:when>
												<xsl:otherwise>
													<xsl:choose>
														<xsl:when test="../../KodMSWiA">
															<xsl:value-of select="../../KodMSWiA"/>
														</xsl:when>
														<xsl:otherwise>
															<xsl:value-of select="$nbsp"/>
														</xsl:otherwise>
													</xsl:choose>
												</xsl:otherwise>
											</xsl:choose>
										</td>
										<td style="font-size:10pt; text-align:center; border-style: solid; border-width: 0 2px 0px 0; border-color: black">
											<xsl:value-of select="$nbsp"/>
										</td>
										<td style="font-size:10pt; text-align:center; border-style: solid; border-width: 0 2px 0px 0; border-color: black">
											<xsl:value-of select="Naglowek/SymbolJOP"/>
										</td>
										<td style="font-size:10pt; text-align:center">
											<xsl:value-of select="$nbsp"/>
										</td>
									</tr>
								</tbody>
							</table>
						</td>
						<td colspan="2" style="font-size:9pt; text-align:right; border-style: solid; border-width: 2px 0 0 0; border-color:black">
							<div style="margin-right: 15px">Przed wypełnieniem przeczytać instrukcję</div>
						</td>
					</tr>
				</tbody>
			</table>
			<div style="display: block; margin-bottom: 40px">
				<div style="margin: 30px 0 10px 0; font-size: 12pt">A. Zobowiązania według tytułów dłużnych</div>
				<table cellpadding="0" cellspacing="0" class="all-bold">
					<tbody>
						<tr>
							<td rowspan="2" style="font-size: 8pt; font-weight: bold; width: 250px; text-align: center" class="bottom-right-bold">Wyszczególnienie</td>
							<td rowspan="2" style="font-size: 8pt; font-weight: bold; width: 160px; text-align: center" class="bottom-right-bold">kwota zadłużenia ogółem (kol.3+15)</td>
							<td colspan="12" style="font-size: 8pt; font-weight: bold; text-align: center" class="bottom-right-bold">wierzyciele krajowi</td>
							<td colspan="3" style="font-size: 8pt; font-weight: bold; text-align: center" class="bottom-right-bold">wierzyciele zagraniczni</td>
						</tr>
						<tr>
							<td style="font-size: 7pt; font-weight: bold; width: 60px; text-align: center" class="bottom-right-mixed">ogółem (kol. 4+9+10+11 +12+13+14)</td>
							<td style="font-size: 7pt; font-weight: bold; width: 60px; text-align: center" class="bottom-right-mixed">sektor finansów publicznych ogółem (kol. 5+6+7+8)</td>
							<td style="font-size: 7pt; font-weight: bold; width: 60px; text-align: center" class="bottom-right-mixed">grupa I</td>
							<td style="font-size: 7pt; font-weight: bold; width: 60px; text-align: center" class="bottom-right-mixed">grupa II</td>
							<td style="font-size: 7pt; font-weight: bold; width: 60px; text-align: center" class="bottom-right-mixed">grupa III</td>
							<td style="font-size: 7pt; font-weight: bold; width: 60px; text-align: center" class="bottom-right-mixed">grupa IV</td>
							<td style="font-size: 7pt; font-weight: bold; width: 60px; text-align: center" class="bottom-right-mixed">bank centralny</td>
							<td style="font-size: 7pt; font-weight: bold; width: 60px; text-align: center" class="bottom-right-mixed">banki</td>
							<td style="font-size: 7pt; font-weight: bold; width: 60px; text-align: center" class="bottom-right-mixed">pozostałe krajowe instytucje finansowe</td>
							<td style="font-size: 7pt; font-weight: bold; width: 100px; text-align: center" class="bottom-right-mixed">przedsiębiorstwa niefinansowe</td>
							<td style="font-size: 7pt; font-weight: bold; width: 100px; text-align: center" class="bottom-right-mixed">gospodarstwa domowe</td>
							<td style="font-size: 7pt; font-weight: bold; width: 100px; text-align: center" class="bottom-right-bold">instytucje niekomercyjne działające na rzecz gospodarstw domowych</td>
							<td style="font-size: 7pt; font-weight: bold; width: 100px; text-align: center" class="bottom-right-mixed">ogółem (kol. 16+17)</td>
							<td style="font-size: 7pt; font-weight: bold; width: 100px; text-align: center" class="bottom-right-mixed">podmioty należące do strefy euro</td>
							<td style="font-size: 7pt; font-weight: bold; width: 100px; text-align: center" class="bottom-right-mixed">pozostałe przedmioty zagraniczne</td>
						</tr>
						<tr>
							<td class="bottom-right-bold" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="1"/>
							</td>
							<td class="bottom-right-bold" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="2"/>
							</td>
							<td class="bottom-right-bold" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="3"/>
							</td>
							<td class="bottom-right-bold" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="4"/>
							</td>
							<td class="bottom-right-bold" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="5"/>
							</td>
							<td class="bottom-right-bold" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="6"/>
							</td>
							<td class="bottom-right-bold" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="7"/>
							</td>
							<td class="bottom-right-bold" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="8"/>
							</td>
							<td class="bottom-right-bold" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="9"/>
							</td>
							<td class="bottom-right-bold" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="10"/>
							</td>
							<td class="bottom-right-bold" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="11"/>
							</td>
							<td class="bottom-right-bold" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="12"/>
							</td>
							<td class="bottom-right-bold" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="13"/>
							</td>
							<td class="bottom-right-bold" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="14"/>
							</td>
							<td class="bottom-right-bold" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="15"/>
							</td>
							<td class="bottom-right-bold" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="16"/>
							</td>
							<td class="bottom-bold" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="17"/>
							</td>
						</tr>
						<tr>
							<td class="right-bottom-mixed" valign="middle">
								<table cellpadding="0" cellspacing="0" border="0">
									<tbody>
										<tr>
											<td style="width: 10px; font-weight: bold; font-size: 8pt; text-align: center">E</td>
											<td style="padding-left: 5px; font-weight: bold; font-size: 8pt; text-align: left">ZOBOWIĄZANIA WG TYTUŁÓW DŁUŻNYCH (E1+E2+E3+E4)</td>
										</tr>
									</tbody>
								</table>
							</td>
							<xsl:call-template name="Rb-Z_daneTabelaA">
								<xsl:with-param name="symbol" select="'E'"/>
								<xsl:with-param name="ostWiersz" select="false()"/>
							</xsl:call-template>
						</tr>
						<tr>
							<td class="right-bottom-mixed" style="font-size: 8pt; text-align: left" valign="middle">
								<table cellpadding="0" cellspacing="0" border="0">
									<tbody>
										<tr>
											<td style="width: 10px; font-size: 8pt; text-align: center">E1</td>
											<td style="padding-left: 5px; font-size: 8pt; text-align: left">papiery wartościowe (E1.1+E1.2)</td>
										</tr>
									</tbody>
								</table>
							</td>
							<xsl:call-template name="Rb-Z_daneTabelaA">
								<xsl:with-param name="symbol" select="'E1'"/>
								<xsl:with-param name="ostWiersz" select="false()"/>
							</xsl:call-template>
						</tr>
						<tr>
							<td class="right-bottom-mixed" style="font-size: 8pt; text-align: left" valign="middle">
								<table cellpadding="0" cellspacing="0" border="0">
									<tbody>
										<tr>
											<td style="padding-left: 10px; width: 10px; font-size: 8pt; text-align: center">E1.1</td>
											<td style="padding-left: 5px; font-size: 8pt; text-align: left">krótkoterminowe</td>
										</tr>
									</tbody>
								</table>
							</td>
							<xsl:call-template name="Rb-Z_daneTabelaA">
								<xsl:with-param name="symbol" select="'E1.1'"/>
								<xsl:with-param name="ostWiersz" select="false()"/>
							</xsl:call-template>
						</tr>
						<tr>
							<td class="right-bottom-mixed" style="font-size: 8pt; text-align: left" valign="middle">
								<table cellpadding="0" cellspacing="0" border="0">
									<tbody>
										<tr>
											<td style="padding-left: 10px; width: 10px; font-size: 8pt; text-align: center">E1.2</td>
											<td style="padding-left: 5px; font-size: 8pt; text-align: left">długoterminowe</td>
										</tr>
									</tbody>
								</table>
							</td>
							<xsl:call-template name="Rb-Z_daneTabelaA">
								<xsl:with-param name="symbol" select="'E1.2'"/>
								<xsl:with-param name="ostWiersz" select="false()"/>
							</xsl:call-template>
						</tr>
						<tr>
							<td class="right-bottom-mixed" style="font-size: 8pt; text-align: left" valign="middle">
								<table cellpadding="0" cellspacing="0" border="0">
									<tbody>
										<tr>
											<td style="width: 10px; font-size: 8pt; text-align: center">E2</td>
											<td style="padding-left: 5px; font-size: 8pt; text-align: left">kredyty i pożyczki (E2.1+E2.2)</td>
										</tr>
									</tbody>
								</table>
							</td>
							<xsl:call-template name="Rb-Z_daneTabelaA">
								<xsl:with-param name="symbol" select="'E2'"/>
								<xsl:with-param name="ostWiersz" select="false()"/>
							</xsl:call-template>
						</tr>
						<tr>
							<td class="right-bottom-mixed" style="font-size: 8pt; text-align: left" valign="middle">
								<table cellpadding="0" cellspacing="0" border="0">
									<tbody>
										<tr>
											<td style="padding-left: 10px; width: 10px; font-size: 8pt; text-align: center">E2.1</td>
											<td style="padding-left: 5px; font-size: 8pt; text-align: left">krótkoterminowe</td>
										</tr>
									</tbody>
								</table>
							</td>
							<xsl:call-template name="Rb-Z_daneTabelaA">
								<xsl:with-param name="symbol" select="'E2.1'"/>
								<xsl:with-param name="ostWiersz" select="false()"/>
							</xsl:call-template>
						</tr>
						<tr>
							<td class="right-bottom-mixed" style="font-size: 8pt; text-align: left" valign="middle">
								<table cellpadding="0" cellspacing="0" border="0">
									<tbody>
										<tr>
											<td style="padding-left: 10px; width: 10px; font-size: 8pt; text-align: center">E2.2</td>
											<td style="padding-left: 5px; font-size: 8pt; text-align: left">długoterminowe</td>
										</tr>
									</tbody>
								</table>
							</td>
							<xsl:call-template name="Rb-Z_daneTabelaA">
								<xsl:with-param name="symbol" select="'E2.2'"/>
								<xsl:with-param name="ostWiersz" select="false()"/>
							</xsl:call-template>
						</tr>
						<tr>
							<td class="right-bottom-mixed" style="font-size: 8pt; text-align: left" valign="middle">
								<table cellpadding="0" cellspacing="0" border="0">
									<tbody>
										<tr>
											<td style="width: 10px; font-size: 8pt; text-align: center">E3</td>
											<td style="padding-left: 5px; font-size: 8pt; text-align: left">przyjęte depozyty</td>
										</tr>
									</tbody>
								</table>
							</td>
							<xsl:call-template name="Rb-Z_daneTabelaA">
								<xsl:with-param name="symbol" select="'E3'"/>
								<xsl:with-param name="ostWiersz" select="false()"/>
							</xsl:call-template>
						</tr>
						<tr>
							<td class="right-bottom-mixed" style="font-size: 8pt; text-align: left" valign="middle">
								<table cellpadding="0" cellspacing="0" border="0">
									<tbody>
										<tr>
											<td style="width: 10px; font-size: 8pt; text-align: center">E4</td>
											<td style="padding-left: 5px; font-size: 8pt; text-align: left">wymagalne zobowiązania (E4.1+E4.2)</td>
										</tr>
									</tbody>
								</table>
							</td>
							<xsl:call-template name="Rb-Z_daneTabelaA">
								<xsl:with-param name="symbol" select="'E4'"/>
								<xsl:with-param name="ostWiersz" select="false()"/>
							</xsl:call-template>
						</tr>
						<tr>
							<td class="right-bottom-mixed" style="font-size: 8pt; text-align: left" valign="middle">
								<table cellpadding="0" cellspacing="0" border="0">
									<tbody>
										<tr>
											<td style="padding-left: 10px; width: 10px; font-size: 8pt; text-align: center">E4.1</td>
											<td style="padding-left: 5px; font-size: 8pt; text-align: left">z tytułu dostaw towarów i usług</td>
										</tr>
									</tbody>
								</table>
							</td>
							<xsl:call-template name="Rb-Z_daneTabelaA">
								<xsl:with-param name="symbol" select="'E4.1'"/>
								<xsl:with-param name="ostWiersz" select="false()"/>
							</xsl:call-template>
						</tr>
						<tr>
							<td class="right-bottom-mixed" style="font-size: 8pt; text-align: left" valign="middle">
								<table cellpadding="0" cellspacing="0" border="0">
									<tbody>
										<tr>
											<td style="padding-left: 10px; width: 10px; font-size: 8pt; text-align: center">E4.2</td>
											<td style="padding-left: 5px; font-size: 8pt; text-align: left">pozostałe</td>
										</tr>
									</tbody>
								</table>
							</td>
							<xsl:call-template name="Rb-Z_daneTabelaA">
								<xsl:with-param name="symbol" select="'E4.2'"/>
								<xsl:with-param name="ostWiersz" select="false()"/>
							</xsl:call-template>
						</tr>
					</tbody>
				</table>
				<div style="margin: 10px 0; font-size: 12pt">B. Poręczenia i gwarancje</div>
				<table cellpadding="0" cellspacing="0" class="all-normal">
					<tbody>
						<tr>
							<td rowspan="2" style="font-size: 8pt; font-weight: bold; text-align: center" class="bottom-right-normal">Wyszczególnienie</td>
							<td rowspan="2" style="font-size: 8pt; font-weight: bold; width: 10em; text-align: center" class="bottom-right-normal">kwota zadłużenia ogółem (kol.3+8)</td>
							<td colspan="6" style="font-size: 8pt; font-weight: bold; text-align: center" class="bottom-right-normal">wierzyciele</td>
						</tr>
						<tr>
							<td style="font-size: 7pt; font-weight: bold; width: 10em; text-align: center" class="bottom-right-normal">podmioty sektora finansów publicznych (kol.4+5+6+7)</td>
							<td style="font-size: 7pt; font-weight: bold; width: 10em; text-align: center" class="bottom-right-normal">grupa I</td>
							<td style="font-size: 7pt; font-weight: bold; width: 10em; text-align: center" class="bottom-right-normal">grupa II</td>
							<td style="font-size: 7pt; font-weight: bold; width: 10em; text-align: center" class="bottom-right-normal">grupa III</td>
							<td style="font-size: 7pt; font-weight: bold; width: 10em; text-align: center" class="bottom-right-normal">grupa IV</td>
							<td style="font-size: 7pt; font-weight: bold; width: 10em; text-align: center" class="bottom-right-normal">pozostałe podmioty</td>
						</tr>
						<tr>
							<td class="bottom-right-normal" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="1"/>
							</td>
							<td class="bottom-right-normal" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="2"/>
							</td>
							<td class="bottom-right-normal" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="3"/>
							</td>
							<td class="bottom-right-normal" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="4"/>
							</td>
							<td class="bottom-right-normal" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="5"/>
							</td>
							<td class="bottom-right-normal" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="6"/>
							</td>
							<td class="bottom-right-normal" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="7"/>
							</td>
							<td class="bottom-right-normal" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="8"/>
							</td>
						</tr>
						<tr>
							<td class="bottom-right-normal" style="font-size: 8pt; text-align: left" valign="middle">
								<table cellpadding="0" cellspacing="0" border="0">
									<tbody>
										<tr>
											<td style="width: 10px; font-size: 8pt; text-align: center">F1</td>
											<td style="padding-left: 5px; font-size: 8pt; text-align: left">wartość nominalna niewymagalnych zobowiązań z tytułu udzielonych poręczeń i gwarancji na koniec okresu sprawozdawczego</td>
										</tr>
									</tbody>
								</table>
							</td>
							<xsl:call-template name="Rb-Z_daneTabelaB">
								<xsl:with-param name="symbol" select="'F1'"/>
							</xsl:call-template>
						</tr>
						<tr>
							<td class="bottom-right-normal" style="font-size: 8pt; text-align: left" valign="middle">
								<table cellpadding="0" cellspacing="0" border="0">
									<tbody>
										<tr>
											<td style="width: 10px; font-size: 8pt; text-align: center">F2</td>
											<td style="padding-left: 5px; font-size: 8pt; text-align: left">wartość nominalna wymagalnych zobowiązań z tytułu udzielonych poręczeń i gwarancji na koniec okresu sprawozdawczego</td>
										</tr>
									</tbody>
								</table>
							</td>
							<xsl:call-template name="Rb-Z_daneTabelaB">
								<xsl:with-param name="symbol" select="'F2'"/>
							</xsl:call-template>
						</tr>
						<tr>
							<td class="bottom-right-normal" style="font-size: 8pt; text-align: left" valign="middle">
								<table cellpadding="0" cellspacing="0" border="0">
									<tbody>
										<tr>
											<td style="width: 10px; font-size: 8pt; text-align: center">F3</td>
											<td style="padding-left: 5px; font-size: 8pt; text-align: left">wartość poręczeń i gwarancji udzielonych w okresie sprawozdawczym</td>
										</tr>
									</tbody>
								</table>
							</td>
							<xsl:call-template name="Rb-Z_daneTabelaB">
								<xsl:with-param name="symbol" select="'F3'"/>
							</xsl:call-template>
						</tr>
					</tbody>
				</table>
				<div style="margin: 10px 0; font-size: 12pt">C. Uzupełniające dane o niektórych zobowiązaniach jednostki samorządu terytorialnego</div>
				<div style="margin: 10px 0; font-size: 12pt">C1. Kredyty i pożyczki oraz wyemitowane papiery wartościowe na realizację programów, projektów lub zadań finansowanych z udziałem środków, o których mowa w art. 5 ust. 1 pkt 2 ustawy</div>
				<table cellpadding="0" cellspacing="0" class="all-normal" style="width: 936px;">
					<tbody>
						<tr>
							<td rowspan="2" style="font-size: 8pt; font-weight: bold; width: 30px; text-align: center" class="bottom-right-normal">Lp.</td>
							<td rowspan="2" style="font-size: 8pt; font-weight: bold; text-align: center" class="bottom-right-normal">Wyszczególnienie</td>
							<td rowspan="2" style="font-size: 8pt; font-weight: bold; width: 160px; text-align: center" class="bottom-normal">z budżetu państwa ogółem</td>
							<td style="font-size: 8pt; font-weight: bold; width: 160px; text-align: left" class="right-normal">w tym:</td>
							<td rowspan="2" style="font-size: 8pt; font-weight: bold; width: 160px; text-align: center" class="bottom-normal">z innych źródeł ogółem</td>
							<td style="font-size: 8pt; font-weight: bold; width: 160px; text-align: left">w tym:</td>
						</tr>
						<tr>
							<td style="font-size: 8pt; font-weight: bold; text-align: center" class="all-normal">długoterminowe</td>
							<td style="font-size: 8pt; font-weight: bold; text-align: center" class="all-normal">długoterminowe</td>
						</tr>
						<tr>
							<td class="bottom-right-normal" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="1"/>
							</td>
							<td class="bottom-right-normal" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="2"/>
							</td>
							<td class="bottom-right-normal" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="3"/>
							</td>
							<td class="bottom-right-normal" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="4"/>
							</td>
							<td class="bottom-right-normal" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="5"/>
							</td>
							<td class="bottom-right-normal" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="6"/>
							</td>
						</tr>
						<xsl:call-template name="Rb-Z_daneTabelaC">
							<xsl:with-param name="symbol" select="'1'"/>
							<xsl:with-param name="wyszczeg" select="'Ogółem kredyty i pożyczki oraz wyemitowane papiery wartościowe '"/>
						</xsl:call-template>
						<xsl:call-template name="Rb-Z_daneTabelaC">
							<xsl:with-param name="symbol" select="'2'"/>
							<xsl:with-param name="wyszczeg" select="'na współfinansowanie (udział własny)'"/>
						</xsl:call-template>
					</tbody>
				</table>
				<div style="margin: 10px 0; font-size: 12pt">C2. Zobowiązania związku współtworzonego przez jednostkę samorządu terytorialnego</div>
				<table cellpadding="0" cellspacing="0" class="all-normal" style="width: 930px;">
					<tbody>
						<tr>
							<td style="font-size: 8pt; font-weight: bold; width: 530px; text-align: center" class="bottom-right-normal">Wyszczególnienie</td>
							<td style="font-size: 8pt; font-weight: bold; width: 200px; text-align: center" class="bottom-right-normal">Plan</td>
							<td style="font-size: 8pt; font-weight: bold; width: 200px; text-align: center" class="bottom-right-normal">Wykonanie</td>
						</tr>
						<tr>
							<td class="bottom-right-normal" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="1"/>
							</td>
							<td class="bottom-right-normal" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="2"/>
							</td>
							<td class="bottom-right-normal" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="3"/>
							</td>
						</tr>
						<xsl:call-template name="Rb-Z_daneTabelaC2">
							<xsl:with-param name="symbol" select="''"/>
							<xsl:with-param name="wyszczeg" select="'Zobowiązania związku współtworzonego przez jednostkę samorządu terytorialnego w okresie sprawozdawczym'"/>
						</xsl:call-template>
					</tbody>
				</table>
				<div style="margin: 10px 0; font-size: 12pt">C3. Zobowiązania zaliczane do tytułu dłużnego -kredyty i pożyczki</div>
				<table cellpadding="0" cellspacing="0" class="all-normal">
					<tbody>
						<tr>
							<td rowspan="3" style="font-size: 8pt; font-weight: bold; text-align: center" class="bottom-right-normal">Rodzaje zobowiązań zaliczanych do kredytów i pożyczek (E2. -część A)</td>
							<td rowspan="3" style="font-size: 8pt; font-weight: bold; width: 10em; text-align: center" class="bottom-right-normal">ogółem (kol.3+4+6+7+8)</td>
							<td colspan="5" style="font-size: 8pt; font-weight: bold; text-align: center" class="bottom-right-normal">wierzyciele krajowi</td>
							<td rowspan="3" style="font-size: 7pt; font-weight: bold; width: 10em; text-align: center" class="bottom-right-normal">wierzyciele zagraniczni</td>
						</tr>
						<tr>
							<td rowspan="2" style="font-size: 7pt; font-weight: bold; width: 10em; text-align: center" class="bottom-right-normal">banki</td>
							<td rowspan="2" style="font-size: 7pt; font-weight: bold; width: 10em; text-align: center" class="bottom-normal">pozostałe krajowe instytucje finansowe ogółem</td>
							<td style="font-size: 7pt; font-weight: bold; width: 10em; text-align: center" class="bottom-right-normal">w tym</td>
							<td rowspan="2" style="font-size: 7pt; font-weight: bold; width: 10em; text-align: center" class="bottom-right-normal">przedsiębiorstwa niefinansowe</td>
							<td rowspan="2" style="font-size: 7pt; font-weight: bold; width: 10em; text-align: center" class="bottom-right-normal">pozostali wierzyciele</td>
						</tr>
						<tr>
							<td style="font-size: 7pt; font-weight: bold; width: 10em; text-align: center" class="all-normal">instytucje parabankowe</td>
						</tr>
						<tr>
							<td class="bottom-right-normal" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="1"/>
							</td>
							<td class="bottom-right-normal" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="2"/>
							</td>
							<td class="bottom-right-normal" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="3"/>
							</td>
							<td class="bottom-right-normal" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="4"/>
							</td>
							<td class="bottom-right-normal" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="5"/>
							</td>
							<td class="bottom-right-normal" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="6"/>
							</td>
							<td class="bottom-right-normal" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="7"/>
							</td>
							<td class="bottom-right-normal" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="8"/>
							</td>
						</tr>
						<tr>
							<td class="bottom-right-normal" style="font-size: 8pt; text-align: left" valign="middle">
								<table cellpadding="0" cellspacing="0" border="0">
									<tbody>
										<tr>
											<td style="width: 10px; font-size: 8pt; text-align: center">1.</td>
											<td style="padding-left: 5px; font-size: 8pt; text-align: left">umowy kredytu i pożyczki</td>
										</tr>
									</tbody>
								</table>
							</td>
							<xsl:call-template name="Rb-Z_daneTabelaC3">
								<xsl:with-param name="symbol" select="'1'"/>
							</xsl:call-template>
						</tr>
						<tr>
							<td class="bottom-right-normal" style="font-size: 8pt; text-align: left" valign="middle">
								<table cellpadding="0" cellspacing="0" border="0">
									<tbody>
										<tr>
											<td style="width: 10px; font-size: 8pt; text-align: center">2.</td>
											<td style="padding-left: 5px; font-size: 8pt; text-align: left">umowy partnerstwa publiczno-prywatnego</td>
										</tr>
									</tbody>
								</table>
							</td>
							<xsl:call-template name="Rb-Z_daneTabelaC3">
								<xsl:with-param name="symbol" select="'2'"/>
							</xsl:call-template>
						</tr>
						<tr>
							<td class="bottom-right-normal" style="font-size: 8pt; text-align: left" valign="middle">
								<table cellpadding="0" cellspacing="0" border="0">
									<tbody>
										<tr>
											<td style="width: 10px; font-size: 8pt; text-align: center">3.</td>
											<td style="padding-left: 5px; font-size: 8pt; text-align: left">papiery wartościowe, których zbywalność jest ograniczona</td>
										</tr>
									</tbody>
								</table>
							</td>
							<xsl:call-template name="Rb-Z_daneTabelaC3">
								<xsl:with-param name="symbol" select="'3'"/>
							</xsl:call-template>
						</tr>
						<tr>
							<td class="bottom-right-normal" style="font-size: 8pt; text-align: left" valign="middle">
								<table cellpadding="0" cellspacing="0" border="0">
									<tbody>
										<tr>
											<td style="width: 10px; font-size: 8pt; text-align: center">4.</td>
											<td style="padding-left: 5px; font-size: 8pt; text-align: left">sprzedaż na raty</td>
										</tr>
									</tbody>
								</table>
							</td>
							<xsl:call-template name="Rb-Z_daneTabelaC3">
								<xsl:with-param name="symbol" select="'4'"/>
							</xsl:call-template>
						</tr>
						<tr>
							<td class="bottom-right-normal" style="font-size: 8pt; text-align: left" valign="middle">
								<table cellpadding="0" cellspacing="0" border="0">
									<tbody>
										<tr>
											<td style="width: 10px; font-size: 8pt; text-align: center">5.</td>
											<td style="padding-left: 5px; font-size: 8pt; text-align: left">leasing finansowy</td>
										</tr>
									</tbody>
								</table>
							</td>
							<xsl:call-template name="Rb-Z_daneTabelaC3">
								<xsl:with-param name="symbol" select="'5'"/>
							</xsl:call-template>
						</tr>
						<tr>
							<td class="bottom-right-normal" style="font-size: 8pt; text-align: left" valign="middle">
								<table cellpadding="0" cellspacing="0" border="0">
									<tbody>
										<tr>
											<td style="width: 10px; font-size: 8pt; text-align: center">6.</td>
											<td style="padding-left: 5px; font-size: 8pt; text-align: left">umowy nienazwane o charakterze kredytu lub pożyczki</td>
										</tr>
									</tbody>
								</table>
							</td>
							<xsl:call-template name="Rb-Z_daneTabelaC3">
								<xsl:with-param name="symbol" select="'6'"/>
							</xsl:call-template>
						</tr>
						<tr>
							<td class="bottom-right-normal" style="font-size: 8pt; text-align: left" valign="middle">
								<table cellpadding="0" cellspacing="0" border="0">
									<tbody>
										<tr>
											<td style="width: 10px; font-size: 8pt; text-align: center"/>
											<td style="padding-left: 5px; font-size: 8pt; text-align: left">Ogółem</td>
										</tr>
									</tbody>
								</table>
							</td>
							<xsl:call-template name="Rb-Z_daneTabelaC3">
								<xsl:with-param name="symbol" select="''"/>
							</xsl:call-template>
						</tr>
					</tbody>
				</table>
				<div style="margin: 10px 0; font-size: 12pt">D. Dane o krótkoterminowych zobowiązaniach wynikających z umów nienazwanych związanych z finansowaniem usług, dostaw, robót budowlanych</div>
				<table cellpadding="0" cellspacing="0" class="all-normal" style="width: 736px;">
					<tbody>
						<tr>
							<td style="font-size: 8pt; font-weight: bold; width: 536px; text-align: center" class="bottom-right-normal">Wyszczególnienie</td>
							<td style="font-size: 8pt; font-weight: bold; width: 200px; text-align: center" class="bottom-right-normal">Kwota zobowiązań ogółem</td>
						</tr>
						<tr>
							<td class="bottom-right-normal" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="1"/>
							</td>
							<td class="bottom-right-normal" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="2"/>
							</td>
						</tr>
						<xsl:call-template name="Rb-Z_daneTabelaD">
							<xsl:with-param name="symbol" select="'A'"/>
							<xsl:with-param name="wyszczeg" select="'krótkoterminowe zobowiązania przejęte przez instytucje finansowe'"/>
						</xsl:call-template>
						<xsl:call-template name="Rb-Z_daneTabelaD">
							<xsl:with-param name="symbol" select="'B'"/>
							<xsl:with-param name="wyszczeg" select="'krótkoterminowe zobowiązania zrestrukturyzowane'"/>
						</xsl:call-template>
					</tbody>
				</table>
				<div style="margin: 10px 0; font-size: 12pt">E. Zobowiązania z tytułu odsetek jednostek posiadających osobowość prawną z wyłączeniem jednostek samorządu terytorialnego</div>
				<table cellpadding="0" cellspacing="0" class="all-normal" style="width: 436px;">
					<tbody>
						<tr>
							<td rowspan="1" style="font-size: 8pt; font-weight: bold; text-align: center" class="bottom-right-normal">Wyszczególnienie</td>
							<td rowspan="1" style="font-size: 8pt; font-weight: bold; width: 160px; text-align: center" class="bottom-right-normal">kwota zobowiązań ogółem (kol.3+4)</td>
							<td rowspan="1" style="font-size: 8pt; font-weight: bold; width: 160px; text-align: center" class="bottom-right-normal">odsetki naliczone od zobowiązań niewymagalnych</td>
							<td style="font-size: 8pt; font-weight: bold; width: 160px; text-align: left" class="bottom-right-normal">odsetki naliczone od zobowiązań wymagalnych</td>
						</tr>
						<tr>
							<td class="bottom-right-normal" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="1"/>
							</td>
							<td class="bottom-right-normal" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="2"/>
							</td>
							<td class="bottom-right-normal" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="3"/>
							</td>
							<td class="bottom-right-normal" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="4"/>
							</td>
						</tr>
						<xsl:for-each select="Odsetki/Pozycja">
							<tr>
								<td class="bottom-right-normal" style="text-align:center;font-size: 8pt; padding: 3px">Wartość odsetek</td>
								<td class="bottom-right-normal" style="text-align:right;font-size: 8pt; padding: 3px">
									<xsl:choose>
										<xsl:when test="ZO">
											<xsl:value-of select="format-number(ZO, '#&#160;##0,00')"/>
										</xsl:when>
										<xsl:otherwise>
											<xsl:value-of select="'0,00'"/>
										</xsl:otherwise>
									</xsl:choose>
								</td>
								<td class="bottom-right-normal" style="text-align:right;font-size: 8pt; padding: 3px">
									<xsl:choose>
										<xsl:when test="ZN">
											<xsl:value-of select="format-number(ZN, '#&#160;##0,00')"/>
										</xsl:when>
										<xsl:otherwise>
											<xsl:value-of select="'0,00'"/>
										</xsl:otherwise>
									</xsl:choose>
								</td>
								<td class="bottom-right-normal" style="text-align:right;font-size: 8pt; padding: 3px">
									<xsl:choose>
										<xsl:when test="ZW">
											<xsl:value-of select="format-number(ZW, '#&#160;##0,00')"/>
										</xsl:when>
										<xsl:otherwise>
											<xsl:value-of select="'0,00'"/>
										</xsl:otherwise>
									</xsl:choose>
								</td>
							</tr>
						</xsl:for-each>
					</tbody>
				</table>
				<div style="margin: 10px 0; font-size: 12pt">F. Lista jednostek sporządzających sprawozdania</div>
				<table cellpadding="0" cellspacing="0" class="all-normal" style="margin-bottom: 60px; width: 436px;">
					<tbody>
						<tr>
							<td style="font-size: 8pt; font-weight: bold; width: 136px; text-align: center" class="bottom-right-normal">Lp.</td>
							<td style="font-size: 8pt; font-weight: bold; width: 300px; text-align: center" class="bottom-right-normal">REGON</td>
						</tr>
						<xsl:for-each select="Jednostki/Pozycja">
							<tr>
								<td class="bottom-right-normal" style="text-align:left;font-size: 8pt; padding: 3px">
									<xsl:value-of select="LP"/>
								</td>
								<td class="bottom-right-normal" style="text-align:left;font-size: 8pt; padding: 3px">
									<xsl:value-of select="REGON"/>
								</td>
							</tr>
						</xsl:for-each>
					</tbody>
				</table>
				<table cellpadding="0" cellspacing="0" class="all-bold" style="margin-bottom: 20px; width: 100%">
					<tbody>
						<tr style="height: 30px" valign="top">
							<td class="bottom-bold" style="font-size: 9pt; font-weight: bold; text-align:left; padding: 3px 10px; margin-left: 5px; margin-bottom: 25px">Wyjaśnienia do sprawozdania Rb-Z</td>
						</tr>
						<tr style="min-height: 50px; height: 70px" valign="top">
							<td style="text-align: left; font-size: 8pt; padding: 3px 10px">
								<xsl:value-of select="Naglowek/Uwagi"/>
							</td>
						</tr>
					</tbody>
				</table>
				<!-- ewentualne uwagi z pozycji -->
				<xsl:if test="TytulyDluzne/Pozycja[child::Uwagi]">
					<table cellpadding="0" cellspacing="0" class="all-bold" style="margin-bottom: 20px; width: 100%">
						<tbody>
							<tr>
								<td colspan="3" style="text-align: left; font-size: 9pt; font-weight: bold; padding: 3px 10px">
									<div>Uwagi do części: "A: Zobowiązania według tytułów dłużnych"</div>
								</td>
							</tr>
							<tr>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 4px 4px 0; width: 6%">Symbol</td>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 4px 4px 0; width: 24%">Wyszczególnienie</td>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 0 4px 0">Uwaga</td>
							</tr>
							<xsl:for-each select="TytulyDluzne/Pozycja[child::Uwagi]">
								<xsl:sort select="Symbol"/>
								<tr>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="Symbol"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:choose>
											<xsl:when test="Symbol = 'E'">ZOBOWIĄZANIA WG TYTUŁÓW DŁUŻNYCH (E1+E2+E3+E4)</xsl:when>
											<xsl:when test="Symbol = 'E1'">papiery wartościowe (E1.1+E1.2)</xsl:when>
											<xsl:when test="Symbol = 'E1.1'">krótkoterminowe</xsl:when>
											<xsl:when test="Symbol = 'E1.2'">długoterminowe</xsl:when>
											<xsl:when test="Symbol = 'E2'">kredyty i pożyczki (E2.1+E2.2)</xsl:when>
											<xsl:when test="Symbol = 'E2.1'">krótkoterminowe</xsl:when>
											<xsl:when test="Symbol = 'E2.2'">długoterminowe</xsl:when>
											<xsl:when test="Symbol = 'E3'">przyjęte depozyty</xsl:when>
											<xsl:when test="Symbol = 'E4'">wymagalne zobowiązania (E4.1+E4.2)</xsl:when>
											<xsl:when test="Symbol = 'E4.1'">z tytułu dostaw towarów i usług</xsl:when>
											<xsl:when test="Symbol = 'E4.2'">pozostałe</xsl:when>
										</xsl:choose>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:value-of select="Uwagi"/>
									</td>
								</tr>
							</xsl:for-each>
						</tbody>
					</table>
				</xsl:if>
				<xsl:if test="PoreczeniaGwarancje/Pozycja[child::Uwagi]">
					<table cellpadding="0" cellspacing="0" class="all-bold" style="margin-bottom: 20px; width: 100%">
						<tbody>
							<tr>
								<td colspan="3" style="text-left: center; font-size: 9pt; font-weight: bold; padding: 3px 10px">
									<div>Uwagi do części: "B: Poręczenia i gwarancje"</div>
								</td>
							</tr>
							<tr>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 4px 4px 0; width: 6%">Symbol</td>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 4px 4px 0; width: 24%">Wyszczególnienie</td>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 0 4px 0">Uwaga</td>
							</tr>
							<xsl:for-each select="PoreczeniaGwarancje/Pozycja[child::Uwagi]">
								<xsl:sort select="Symbol"/>
								<tr>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="Symbol"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:choose>
											<xsl:when test="Symbol = 'F1'">wartość nominalna niewymagalnych zobowiązań z tytułu udzielonych poręczeń i gwarancji na koniec okresu sprawozdawczego</xsl:when>
											<xsl:when test="Symbol = 'F2'">wartość nominalna wymagalnych zobowiązań z tytułu udzielonych poręczeń i gwarancji na koniec okresu sprawozdawczego</xsl:when>
											<xsl:when test="Symbol = 'F3'">wartość poręczeń i gwarancji udzielonych w okresie sprawozdawczym</xsl:when>
										</xsl:choose>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:value-of select="Uwagi"/>
									</td>
								</tr>
							</xsl:for-each>
						</tbody>
					</table>
				</xsl:if>
				<xsl:if test="KredytyPozyczki/Pozycja[child::Uwagi]">
					<table cellpadding="0" cellspacing="0" class="all-bold" style="margin-bottom: 20px; width: 100%">
						<tbody>
							<tr>
								<td colspan="3" style="text-align: left; font-size: 9pt; font-weight: bold; padding: 3px 10px">
									<div>Uwagi do części: "C1. Kredyty i pożyczki oraz wyemitowane papiery wartościowe na realizację programów, projektów lub zadań finansowanych z udziałem środków, o których mowa w art. 5 ust. 1 pkt 2 ustawy"</div>
								</td>
							</tr>
							<tr>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 4px 4px 0; width: 6%">Lp</td>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 4px 4px 0; width: 24%">Wyszczególnienie</td>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 0 4px 0">Uwaga</td>
							</tr>
							<xsl:for-each select="KredytyPozyczki/Pozycja[child::Uwagi]">
								<xsl:sort select="Symbol"/>
								<tr>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="Symbol"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:choose>
											<xsl:when test="Symbol = '1'">Ogółem kredyty i pożyczki oraz wyemitowane papiery wartościowe w tym:</xsl:when>
											<xsl:when test="Symbol = '2'">na współfinansowanie (udział własny)</xsl:when>
										</xsl:choose>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:value-of select="Uwagi"/>
									</td>
								</tr>
							</xsl:for-each>
						</tbody>
					</table>
				</xsl:if>
				<xsl:if test="DaneUzupelniajace/Pozycja[child::Uwagi]">
					<table cellpadding="0" cellspacing="0" class="all-bold" style="margin-bottom: 20px; width: 100%">
						<tbody>
							<tr>
								<td colspan="3" style="text-align: left; font-size: 9pt; font-weight: bold; padding: 3px 10px">
									<div>Uwagi do części: "C2. Zobowiązania związku współtworzonego przez jednostkę samorządu terytorialnego"</div>
								</td>
							</tr>
							<tr>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 4px 4px 0; width: 6%">Symbol</td>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 4px 4px 0; width: 24%">Wyszczególnienie</td>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 0 4px 0">Uwaga</td>
							</tr>
							<xsl:for-each select="DaneUzupelniajace/Pozycja[child::Uwagi]">
								<xsl:sort select="Symbol"/>
								<tr>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="Symbol"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">Zobowiązania związku współtworzonego przez jednostkę samorząduterytorialnego w okresie sprawozdawczym</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:value-of select="Uwagi"/>
									</td>
								</tr>
							</xsl:for-each>
						</tbody>
					</table>
				</xsl:if>
				<xsl:if test="TytulyDluzneKredytyPozyczki/Pozycja[child::Uwagi]">
					<table cellpadding="0" cellspacing="0" class="all-bold" style="margin-bottom: 20px; width: 100%">
						<tbody>
							<tr>
								<td colspan="3" style="text-align: left; font-size: 9pt; font-weight: bold; padding: 3px 10px">
									<div>Uwagi do części: "C3. Zobowiązania zaliczane do tytułu dłużnego -kredyty i pożyczki"</div>
								</td>
							</tr>
							<tr>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 4px 4px 0; width: 6%">Symbol</td>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 4px 4px 0; width: 24%">Wyszczególnienie</td>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 0 4px 0">Uwaga</td>
							</tr>
							<xsl:for-each select="TytulyDluzneKredytyPozyczki/Pozycja[child::Uwagi]">
								<xsl:sort select="Symbol"/>
								<tr>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="Symbol"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:choose>
											<xsl:when test="Symbol = '1'">umowy kredytu i pożyczki</xsl:when>
											<xsl:when test="Symbol = '2'">umowy partnerstwa publiczno-prywatnego</xsl:when>
											<xsl:when test="Symbol = '3'">papiery wartościowe, których zbywalność jest ograniczona</xsl:when>
											<xsl:when test="Symbol = '4'">sprzedaż na raty</xsl:when>
											<xsl:when test="Symbol = '5'">leasing finansowy</xsl:when>
											<xsl:when test="Symbol = '6'">umowy nienazwane o charakterze kredytu lub pożyczki</xsl:when>
											<xsl:when test="Symbol = ''">Ogółem</xsl:when>
										</xsl:choose>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:value-of select="Uwagi"/>
									</td>
								</tr>
							</xsl:for-each>
						</tbody>
					</table>
				</xsl:if>
				<xsl:if test="ZobowiazaniaKrotkoterminowe/Pozycja[child::Uwagi]">
					<table cellpadding="0" cellspacing="0" class="all-bold" style="margin-bottom: 20px; width: 100%">
						<tbody>
							<tr>
								<td colspan="3" style="text-align: left; font-size: 9pt; font-weight: bold; padding: 3px 10px">
									<div>Uwagi do części: "D. Dane o krótkoterminowych zobowiązaniach wynikających z umów nienazwanych związanych z finansowaniem usług, dostaw, robót budowlanych"</div>
								</td>
							</tr>
							<tr>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 4px 4px 0; width: 6%">Symbol</td>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 4px 4px 0; width: 24%">Wyszczególnienie</td>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 0 4px 0">Uwaga</td>
							</tr>
							<xsl:for-each select="ZobowiazaniaKrotkoterminowe/Pozycja[child::Uwagi]">
								<xsl:sort select="Symbol"/>
								<tr>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="Symbol"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:choose>
											<xsl:when test="Symbol = 'A'">krótkoterminowe zobowiązania przejęte przez instytucje finansowe</xsl:when>
											<xsl:when test="Symbol = 'B'">krótkoterminowe zobowiązania zrestrukturyzowane</xsl:when>
										</xsl:choose>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:value-of select="Uwagi"/>
									</td>
								</tr>
							</xsl:for-each>
						</tbody>
					</table>
				</xsl:if>
				<xsl:if test="Odsetki/Pozycja[child::Uwagi]">
					<table cellpadding="0" cellspacing="0" class="all-bold" style="margin-bottom: 20px; width: 100%">
						<tbody>
							<tr>
								<td colspan="2" style="text-align: left; font-size: 9pt; font-weight: bold; padding: 3px 10px">
									<div>Uwagi do części: "E. Zobowiązania z tytułu odsetek jednostek posiadających osobowość prawną z wyłączeniem jednostek samorządu terytorialnego"</div>
								</td>
							</tr>
							<tr>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 4px 4px 0; width: 24%">Wyszczególnienie</td>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 0 4px 0">Uwaga</td>
							</tr>
							<xsl:for-each select="Odsetki/Pozycja[child::Uwagi]">
								<tr>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">Wartość odsetek</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:value-of select="Uwagi"/>
									</td>
								</tr>
							</xsl:for-each>
						</tbody>
					</table>
				</xsl:if>
				<div style="margin-bottom: 40px">
					<div style="display: block; font-size: 7pt">
						<sup>1)</sup> niepotrzebne skreślić
          </div>
				</div>
				<table cellpadding="0" cellspacing="0" style="margin-bottom: 50px; margin-top: 80px; width: 80%">
					<tbody>
						<tr>
							<td style="text-align:center; font-size: 8pt; " valign="bottom" width="25%">
								<hr style="width: 90%;text-align:center; "/>
								<div style="text-align:center;">główny księgowy <sup>*</sup>/skarbnik</div>
								<div style="display: block; font-size: 7pt">
									<sup>*</sup>Nie dotyczy sprawozdań zbiorczych sporządzanych przez RIO. W przypadku braku głównego księgowego podpisuje tylko kierownik jednostki.
          </div>
							</td>
							<td style="text-align:center; font-size: 8pt; " valign="baseline" width="25%">
								<hr style="width: 90%;text-align:center"/>
								<div style="text-align:center;">telefon</div>
							</td>
							<td style="text-align:center; font-size: 8pt;  " valign="baseline" width="25%">
								<hr style="width: 90%;text-align:center"/>
								<div style="text-align:center;">rok mc dzień</div>
							</td>
							<td style="text-align:center; font-size: 8pt;  " valign="baseline" width="25%">
								<hr style="width: 90%;text-align:center"/>
								<div style="text-align:center;">kierownik jednostki (jednostki obsługującej) / przewodniczący zarządu</div>
							</td>
						</tr>
						<tr>
							<td style="text-align:center; font-size: 8pt;">
								<div>
									<xsl:for-each select="../../Podpisy/*[name() = 'ds:Signature']">
										<xsl:if test="contains(@Id, 'RbZ')">
											<xsl:if test="contains(translate(*[name() = 'ds:Object']/*[name() = 'xades:QualifyingProperties']/*[name() = 'xades:SignedProperties']/*[name() = 'xades:SignedSignatureProperties']/*[name() = 'xades:SignerRole']/*[name() = 'xades:ClaimedRoles']/*[name() = 'xades:ClaimedRole']/*[name() = 'Role'], 'S','s'),'skarbnik')">
												<xsl:value-of select="substring(*[name() = 'ds:Object']/*[name() = 'xades:QualifyingProperties']/*[name() = 'xades:SignedProperties']/*[name() = 'xades:SignedSignatureProperties']/*[name() = 'xades:SigningTime'], 1, 10)"/>
											</xsl:if>
										</xsl:if>
									</xsl:for-each>
								</div>
							</td>
							<td/>
							<td style="text-align:center; font-size: 8pt;">
								<div>
									<xsl:for-each select="../../Podpisy/*[name() = 'ds:Signature']">
										<xsl:if test="contains(@Id, 'RbZ')">
											<xsl:if test="contains(translate(*[name() = 'ds:Object']/*[name() = 'xades:QualifyingProperties']/*[name() = 'xades:SignedProperties']/*[name() = 'xades:SignedSignatureProperties']/*[name() = 'xades:SignerRole']/*[name() = 'xades:ClaimedRoles']/*[name() = 'xades:ClaimedRole']/*[name() = 'Role'], 'K','k'),'kierownik')">
												<xsl:value-of select="substring(*[name() = 'ds:Object']/*[name() = 'xades:QualifyingProperties']/*[name() = 'xades:SignedProperties']/*[name() = 'xades:SignedSignatureProperties']/*[name() = 'xades:SigningTime'], 1,10)"/>
											</xsl:if>
										</xsl:if>
									</xsl:for-each>
								</div>
							</td>
						</tr>
					</tbody>
				</table>
			</div>
			<xsl:element name="a">
				<xsl:attribute name="href"><xsl:value-of select="concat('#Jed', $jedIndex)"/></xsl:attribute>
				<xsl:element name="style">
					<xsl:value-of select="'font-family: Verdana'"/>
				</xsl:element>
				<xsl:value-of select="'Powrót do listy sprawozdań jednostki'"/>
			</xsl:element>
		</xsl:element>
	</xsl:template>
	<!-- Rb-Z szablony pomocnicze -->
	<xsl:template name="Rb-Z_daneTabelaA">
		<xsl:param name="symbol"/>
		<xsl:param name="ostWiersz" select="false()"/>
		<xsl:choose>
			<xsl:when test="$ostWiersz = false()">
				<td class="right-bottom-mixed" style="text-align:right;font-size: 8pt; padding: 3px">
					<xsl:choose>
						<xsl:when test="TytulyDluzne/Pozycja[child::Symbol = $symbol][1]/Z">
							<xsl:value-of select="format-number(TytulyDluzne/Pozycja[child::Symbol = $symbol][1]/Z, '#&#160;##0,00')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'0,00'"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td class="bottom-right-normal" style="text-align:right;font-size: 8pt; padding: 3px">
					<xsl:choose>
						<xsl:when test="TytulyDluzne/Pozycja[child::Symbol = $symbol][1]/KO">
							<xsl:value-of select="format-number(TytulyDluzne/Pozycja[child::Symbol = $symbol][1]/KO, '#&#160;##0,00')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'0,00'"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td class="bottom-right-normal" style="text-align:right;font-size: 8pt; padding: 3px">
					<xsl:choose>
						<xsl:when test="TytulyDluzne/Pozycja[child::Symbol = $symbol][1]/KFP">
							<xsl:value-of select="format-number(TytulyDluzne/Pozycja[child::Symbol = $symbol][1]/KFP, '#&#160;##0,00')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'0,00'"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td class="bottom-right-normal" style="text-align:right;font-size: 8pt; padding: 3px">
					<xsl:choose>
						<xsl:when test="TytulyDluzne/Pozycja[child::Symbol = $symbol][1]/KG1">
							<xsl:value-of select="format-number(TytulyDluzne/Pozycja[child::Symbol = $symbol][1]/KG1, '#&#160;##0,00')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'0,00'"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td class="bottom-right-normal" style="text-align:right;font-size: 8pt; padding: 3px">
					<xsl:choose>
						<xsl:when test="TytulyDluzne/Pozycja[child::Symbol = $symbol][1]/KG2">
							<xsl:value-of select="format-number(TytulyDluzne/Pozycja[child::Symbol = $symbol][1]/KG2, '#&#160;##0,00')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'0,00'"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td class="bottom-right-normal" style="text-align:right;font-size: 8pt; padding: 3px">
					<xsl:choose>
						<xsl:when test="TytulyDluzne/Pozycja[child::Symbol = $symbol][1]/KG3">
							<xsl:value-of select="format-number(TytulyDluzne/Pozycja[child::Symbol = $symbol][1]/KG3, '#&#160;##0,00')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'0,00'"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td class="bottom-right-normal" style="text-align:right;font-size: 8pt; padding: 3px">
					<xsl:choose>
						<xsl:when test="TytulyDluzne/Pozycja[child::Symbol = $symbol][1]/KG4">
							<xsl:value-of select="format-number(TytulyDluzne/Pozycja[child::Symbol = $symbol][1]/KG4, '#&#160;##0,00')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'0,00'"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td class="bottom-right-normal" style="text-align:right;font-size: 8pt; padding: 3px">
					<xsl:choose>
						<xsl:when test="TytulyDluzne/Pozycja[child::Symbol = $symbol][1]/KBC">
							<xsl:value-of select="format-number(TytulyDluzne/Pozycja[child::Symbol = $symbol][1]/KBC, '#&#160;##0,00')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'0,00'"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td class="bottom-right-normal" style="text-align:right;font-size: 8pt; padding: 3px">
					<xsl:choose>
						<xsl:when test="TytulyDluzne/Pozycja[child::Symbol = $symbol][1]/KBK">
							<xsl:value-of select="format-number(TytulyDluzne/Pozycja[child::Symbol = $symbol][1]/KBK, '#&#160;##0,00')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'0,00'"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td class="bottom-right-normal" style="text-align:right;font-size: 8pt; padding: 3px">
					<xsl:choose>
						<xsl:when test="TytulyDluzne/Pozycja[child::Symbol = $symbol][1]/KIF">
							<xsl:value-of select="format-number(TytulyDluzne/Pozycja[child::Symbol = $symbol][1]/KIF, '#&#160;##0,00')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'0,00'"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td class="bottom-right-normal" style="text-align:right;font-size: 8pt; padding: 3px">
					<xsl:choose>
						<xsl:when test="TytulyDluzne/Pozycja[child::Symbol = $symbol][1]/KPN">
							<xsl:value-of select="format-number(TytulyDluzne/Pozycja[child::Symbol = $symbol][1]/KPN, '#&#160;##0,00')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'0,00'"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td class="bottom-right-normal" style="text-align:right;font-size: 8pt; padding: 3px">
					<xsl:choose>
						<xsl:when test="TytulyDluzne/Pozycja[child::Symbol = $symbol][1]/KGD">
							<xsl:value-of select="format-number(TytulyDluzne/Pozycja[child::Symbol = $symbol][1]/KGD, '#&#160;##0,00')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'0,00'"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td class="right-bottom-mixed" style="text-align:right;font-size: 8pt; padding: 3px">
					<xsl:choose>
						<xsl:when test="TytulyDluzne/Pozycja[child::Symbol = $symbol][1]/KIN">
							<xsl:value-of select="format-number(TytulyDluzne/Pozycja[child::Symbol = $symbol][1]/KIN, '#&#160;##0,00')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'0,00'"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td class="bottom-right-normal" style="text-align:right;font-size: 8pt; padding: 3px">
					<xsl:choose>
						<xsl:when test="TytulyDluzne/Pozycja[child::Symbol = $symbol][1]/ZO">
							<xsl:value-of select="format-number(TytulyDluzne/Pozycja[child::Symbol = $symbol][1]/ZO, '#&#160;##0,00')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'0,00'"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td class="bottom-right-normal" style="text-align:right;font-size: 8pt; padding: 3px">
					<xsl:choose>
						<xsl:when test="TytulyDluzne/Pozycja[child::Symbol = $symbol][1]/ZSE">
							<xsl:value-of select="format-number(TytulyDluzne/Pozycja[child::Symbol = $symbol][1]/ZSE, '#&#160;##0,00')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'0,00'"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td class="right-bottom-mixed" style="text-align:right;font-size: 8pt; padding: 3px">
					<xsl:choose>
						<xsl:when test="TytulyDluzne/Pozycja[child::Symbol = $symbol][1]/ZPZ">
							<xsl:value-of select="format-number(TytulyDluzne/Pozycja[child::Symbol = $symbol][1]/ZPZ, '#&#160;##0,00')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'0,00'"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
			</xsl:when>
			<xsl:otherwise>
				<td class="bottom-right-bold" style="text-align:right;font-size: 8pt; padding: 3px">
					<xsl:choose>
						<xsl:when test="TytulyDluzne/Pozycja[child::Symbol = $symbol][1]/Z">
							<xsl:value-of select="format-number(TytulyDluzne/Pozycja[child::Symbol = $symbol][1]/Z, '#&#160;##0,00')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'0,00'"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td class="bottom-right-mixed" style="text-align:right;font-size: 8pt; padding: 3px">
					<xsl:choose>
						<xsl:when test="TytulyDluzne/Pozycja[child::Symbol = $symbol][1]/KO">
							<xsl:value-of select="format-number(TytulyDluzne/Pozycja[child::Symbol = $symbol][1]/KO, '#&#160;##0,00')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'0,00'"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td class="bottom-right-mixed" style="text-align:right;font-size: 8pt; padding: 3px">
					<xsl:choose>
						<xsl:when test="TytulyDluzne/Pozycja[child::Symbol = $symbol][1]/KFP">
							<xsl:value-of select="format-number(TytulyDluzne/Pozycja[child::Symbol = $symbol][1]/KFP, '#&#160;##0,00')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'0,00'"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td class="bottom-right-mixed" style="text-align:right;font-size: 8pt; padding: 3px">
					<xsl:choose>
						<xsl:when test="TytulyDluzne/Pozycja[child::Symbol = $symbol][1]/KG1">
							<xsl:value-of select="format-number(TytulyDluzne/Pozycja[child::Symbol = $symbol][1]/KG1, '#&#160;##0,00')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'0,00'"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td class="bottom-right-mixed" style="text-align:right;font-size: 8pt; padding: 3px">
					<xsl:choose>
						<xsl:when test="TytulyDluzne/Pozycja[child::Symbol = $symbol][1]/KG2">
							<xsl:value-of select="format-number(TytulyDluzne/Pozycja[child::Symbol = $symbol][1]/KG2, '#&#160;##0,00')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'0,00'"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td class="bottom-right-mixed" style="text-align:right;font-size: 8pt; padding: 3px">
					<xsl:choose>
						<xsl:when test="TytulyDluzne/Pozycja[child::Symbol = $symbol][1]/KG3">
							<xsl:value-of select="format-number(TytulyDluzne/Pozycja[child::Symbol = $symbol][1]/KG3, '#&#160;##0,00')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'0,00'"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td class="bottom-right-mixed" style="text-align:right;font-size: 8pt; padding: 3px">
					<xsl:choose>
						<xsl:when test="TytulyDluzne/Pozycja[child::Symbol = $symbol][1]/KG4">
							<xsl:value-of select="format-number(TytulyDluzne/Pozycja[child::Symbol = $symbol][1]/KG4, '#&#160;##0,00')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'0,00'"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td class="bottom-right-mixed" style="text-align:right;font-size: 8pt; padding: 3px">
					<xsl:choose>
						<xsl:when test="TytulyDluzne/Pozycja[child::Symbol = $symbol][1]/KBC">
							<xsl:value-of select="format-number(TytulyDluzne/Pozycja[child::Symbol = $symbol][1]/KBC, '#&#160;##0,00')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'0,00'"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td class="bottom-right-mixed" style="text-align:right;font-size: 8pt; padding: 3px">
					<xsl:choose>
						<xsl:when test="TytulyDluzne/Pozycja[child::Symbol = $symbol][1]/KBK">
							<xsl:value-of select="format-number(TytulyDluzne/Pozycja[child::Symbol = $symbol][1]/KBK, '#&#160;##0,00')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'0,00'"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td class="bottom-right-mixed" style="text-align:right;font-size: 8pt; padding: 3px">
					<xsl:choose>
						<xsl:when test="TytulyDluzne/Pozycja[child::Symbol = $symbol][1]/KIF">
							<xsl:value-of select="format-number(TytulyDluzne/Pozycja[child::Symbol = $symbol][1]/KIF, '#&#160;##0,00')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'0,00'"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td class="bottom-right-mixed" style="text-align:right;font-size: 8pt; padding: 3px">
					<xsl:choose>
						<xsl:when test="TytulyDluzne/Pozycja[child::Symbol = $symbol][1]/KPN">
							<xsl:value-of select="format-number(TytulyDluzne/Pozycja[child::Symbol = $symbol][1]/KPN, '#&#160;##0,00')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'0,00'"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td class="bottom-right-mixed" style="text-align:right;font-size: 8pt; padding: 3px">
					<xsl:choose>
						<xsl:when test="TytulyDluzne/Pozycja[child::Symbol = $symbol][1]/KGD">
							<xsl:value-of select="format-number(TytulyDluzne/Pozycja[child::Symbol = $symbol][1]/KGD, '#&#160;##0,00')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'0,00'"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td class="bottom-right-bold" style="text-align:right;font-size: 8pt; padding: 3px">
					<xsl:choose>
						<xsl:when test="TytulyDluzne/Pozycja[child::Symbol = $symbol][1]/KIN">
							<xsl:value-of select="format-number(TytulyDluzne/Pozycja[child::Symbol = $symbol][1]/KIN, '#&#160;##0,00')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'0,00'"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td class="bottom-right-mixed" style="text-align:right;font-size: 8pt; padding: 3px">
					<xsl:choose>
						<xsl:when test="TytulyDluzne/Pozycja[child::Symbol = $symbol][1]/ZO">
							<xsl:value-of select="format-number(TytulyDluzne/Pozycja[child::Symbol = $symbol][1]/ZO, '#&#160;##0,00')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'0,00'"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td class="bottom-right-mixed" style="text-align:right;font-size: 8pt; padding: 3px">
					<xsl:choose>
						<xsl:when test="TytulyDluzne/Pozycja[child::Symbol = $symbol][1]/ZSE">
							<xsl:value-of select="format-number(TytulyDluzne/Pozycja[child::Symbol = $symbol][1]/ZSE, '#&#160;##0,00')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'0,00'"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td class="bottom-right-bold" style="text-align:right;font-size: 8pt; padding: 3px">
					<xsl:choose>
						<xsl:when test="TytulyDluzne/Pozycja[child::Symbol = $symbol][1]/ZPZ">
							<xsl:value-of select="format-number(TytulyDluzne/Pozycja[child::Symbol = $symbol][1]/ZPZ, '#&#160;##0,00')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'0,00'"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="Rb-Z_daneTabelaB">
		<xsl:param name="symbol"/>
		<td class="bottom-right-normal" style="text-align:right;font-size: 8pt; padding: 3px">
			<xsl:choose>
				<xsl:when test="PoreczeniaGwarancje/Pozycja[child::Symbol = $symbol][1]/O">
					<xsl:value-of select="format-number(PoreczeniaGwarancje/Pozycja[child::Symbol = $symbol][1]/O, '#&#160;##0,00')"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="'0,00'"/>
				</xsl:otherwise>
			</xsl:choose>
		</td>
		<td class="bottom-right-normal" style="text-align:right;font-size: 8pt; padding: 3px">
			<xsl:choose>
				<xsl:when test="PoreczeniaGwarancje/Pozycja[child::Symbol = $symbol][1]/FP">
					<xsl:value-of select="format-number(PoreczeniaGwarancje/Pozycja[child::Symbol = $symbol][1]/FP, '#&#160;##0,00')"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="'0,00'"/>
				</xsl:otherwise>
			</xsl:choose>
		</td>
		<td class="bottom-right-normal" style="text-align:right;font-size: 8pt; padding: 3px">
			<xsl:choose>
				<xsl:when test="PoreczeniaGwarancje/Pozycja[child::Symbol = $symbol][1]/G1">
					<xsl:value-of select="format-number(PoreczeniaGwarancje/Pozycja[child::Symbol = $symbol][1]/G1, '#&#160;##0,00')"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="'0,00'"/>
				</xsl:otherwise>
			</xsl:choose>
		</td>
		<td class="bottom-right-normal" style="text-align:right;font-size: 8pt; padding: 3px">
			<xsl:choose>
				<xsl:when test="PoreczeniaGwarancje/Pozycja[child::Symbol = $symbol][1]/G2">
					<xsl:value-of select="format-number(PoreczeniaGwarancje/Pozycja[child::Symbol = $symbol][1]/G2, '#&#160;##0,00')"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="'0,00'"/>
				</xsl:otherwise>
			</xsl:choose>
		</td>
		<td class="bottom-right-normal" style="text-align:right;font-size: 8pt; padding: 3px">
			<xsl:choose>
				<xsl:when test="PoreczeniaGwarancje/Pozycja[child::Symbol = $symbol][1]/G3">
					<xsl:value-of select="format-number(PoreczeniaGwarancje/Pozycja[child::Symbol = $symbol][1]/G3, '#&#160;##0,00')"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="'0,00'"/>
				</xsl:otherwise>
			</xsl:choose>
		</td>
		<td class="bottom-right-normal" style="text-align:right;font-size: 8pt; padding: 3px">
			<xsl:choose>
				<xsl:when test="PoreczeniaGwarancje/Pozycja[child::Symbol = $symbol][1]/G4">
					<xsl:value-of select="format-number(PoreczeniaGwarancje/Pozycja[child::Symbol = $symbol][1]/G4, '#&#160;##0,00')"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="'0,00'"/>
				</xsl:otherwise>
			</xsl:choose>
		</td>
		<td class="bottom-right-normal" style="text-align:right;font-size: 8pt; padding: 3px">
			<xsl:choose>
				<xsl:when test="PoreczeniaGwarancje/Pozycja[child::Symbol = $symbol][1]/PP">
					<xsl:value-of select="format-number(PoreczeniaGwarancje/Pozycja[child::Symbol = $symbol][1]/PP, '#&#160;##0,00')"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="'0,00'"/>
				</xsl:otherwise>
			</xsl:choose>
		</td>
	</xsl:template>
	<xsl:template name="Rb-Z_daneTabelaC">
		<xsl:param name="symbol"/>
		<xsl:param name="wyszczeg"/>
		<tr>
			<td class="bottom-right-normal" style="text-align:center;font-size: 8pt; padding: 3px">
				<xsl:value-of select="KredytyPozyczki/Pozycja[child::Symbol = $symbol][1]/Symbol"/>
			</td>
			<td class="bottom-right-normal" style="text-align:left;font-size: 8pt; padding: 3px">
				<xsl:value-of select="$wyszczeg"/>
			</td>
			<td class="bottom-right-normal" style="text-align:right;font-size: 8pt; padding: 3px">
				<xsl:choose>
					<xsl:when test="KredytyPozyczki/Pozycja[child::Symbol = $symbol][1]/BPO">
						<xsl:value-of select="format-number(KredytyPozyczki/Pozycja[child::Symbol = $symbol][1]/BPO, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:choose>
							<xsl:when test="$symbol = 2">
								<xsl:value-of select="'X'"/>
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="'0,00'"/>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:otherwise>
				</xsl:choose>
			</td>
			<td class="bottom-right-normal" style="text-align:right;font-size: 8pt; padding: 3px">
				<xsl:choose>
					<xsl:when test="KredytyPozyczki/Pozycja[child::Symbol = $symbol][1]/BPD">
						<xsl:value-of select="format-number(KredytyPozyczki/Pozycja[child::Symbol = $symbol][1]/BPD, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:choose>
							<xsl:when test="$symbol = 2">
								<xsl:value-of select="'X'"/>
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="'0,00'"/>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:otherwise>
				</xsl:choose>
			</td>
			<td class="bottom-right-normal" style="text-align:right;font-size: 8pt; padding: 3px">
				<xsl:choose>
					<xsl:when test="KredytyPozyczki/Pozycja[child::Symbol = $symbol][1]/IZO">
						<xsl:value-of select="format-number(KredytyPozyczki/Pozycja[child::Symbol = $symbol][1]/IZO, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
			<td class="bottom-right-normal" style="text-align:right;font-size: 8pt; padding: 3px">
				<xsl:choose>
					<xsl:when test="KredytyPozyczki/Pozycja[child::Symbol = $symbol][1]/IZD">
						<xsl:value-of select="format-number(KredytyPozyczki/Pozycja[child::Symbol = $symbol][1]/IZD, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
		</tr>
	</xsl:template>
	<xsl:template name="Rb-Z_daneTabelaC2">
		<xsl:param name="symbol"/>
		<xsl:param name="wyszczeg"/>
		<tr>
			<td class="bottom-right-normal" style="text-align:left;font-size: 8pt; padding: 3px">
				<xsl:value-of select="$wyszczeg"/>
			</td>
			<td class="bottom-right-normal" style="text-align:right;font-size: 8pt; padding: 3px">
				<xsl:choose>
					<xsl:when test="DaneUzupelniajace/Pozycja[1]/P">
						<xsl:value-of select="format-number(DaneUzupelniajace/Pozycja[1]/P, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
			<td class="bottom-right-normal" style="text-align:right;font-size: 8pt; padding: 3px">
				<xsl:choose>
					<xsl:when test="DaneUzupelniajace/Pozycja[child::Symbol = $symbol][1]/W">
						<xsl:value-of select="format-number(DaneUzupelniajace/Pozycja[1]/W, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
		</tr>
	</xsl:template>
	<xsl:template name="Rb-Z_daneTabelaC3">
		<xsl:param name="symbol"/>
		<td class="bottom-right-normal" style="text-align:right;font-size: 8pt; padding: 3px">
			<xsl:choose>
				<xsl:when test="TytulyDluzneKredytyPozyczki/Pozycja[child::Symbol = $symbol][1]/O">
					<xsl:value-of select="format-number(TytulyDluzneKredytyPozyczki/Pozycja[child::Symbol = $symbol][1]/O, '#&#160;##0,00')"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="'0,00'"/>
				</xsl:otherwise>
			</xsl:choose>
		</td>
		<td class="bottom-right-normal" style="text-align:right;font-size: 8pt; padding: 3px">
			<xsl:choose>
				<xsl:when test="TytulyDluzneKredytyPozyczki/Pozycja[child::Symbol = $symbol][1]/BK">
					<xsl:value-of select="format-number(TytulyDluzneKredytyPozyczki/Pozycja[child::Symbol = $symbol][1]/BK, '#&#160;##0,00')"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="'0,00'"/>
				</xsl:otherwise>
			</xsl:choose>
		</td>
		<td class="bottom-right-normal" style="text-align:right;font-size: 8pt; padding: 3px">
			<xsl:choose>
				<xsl:when test="TytulyDluzneKredytyPozyczki/Pozycja[child::Symbol = $symbol][1]/INF">
					<xsl:value-of select="format-number(TytulyDluzneKredytyPozyczki/Pozycja[child::Symbol = $symbol][1]/INF, '#&#160;##0,00')"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="'0,00'"/>
				</xsl:otherwise>
			</xsl:choose>
		</td>
		<td class="bottom-right-normal" style="text-align:right;font-size: 8pt; padding: 3px">
			<xsl:choose>
				<xsl:when test="TytulyDluzneKredytyPozyczki/Pozycja[child::Symbol = $symbol][1]/IP">
					<xsl:value-of select="format-number(TytulyDluzneKredytyPozyczki/Pozycja[child::Symbol = $symbol][1]/IP, '#&#160;##0,00')"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="'0,00'"/>
				</xsl:otherwise>
			</xsl:choose>
		</td>
		<td class="bottom-right-normal" style="text-align:right;font-size: 8pt; padding: 3px">
			<xsl:choose>
				<xsl:when test="TytulyDluzneKredytyPozyczki/Pozycja[child::Symbol = $symbol][1]/PN">
					<xsl:value-of select="format-number(TytulyDluzneKredytyPozyczki/Pozycja[child::Symbol = $symbol][1]/PN, '#&#160;##0,00')"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="'0,00'"/>
				</xsl:otherwise>
			</xsl:choose>
		</td>
		<td class="bottom-right-normal" style="text-align:right;font-size: 8pt; padding: 3px">
			<xsl:choose>
				<xsl:when test="TytulyDluzneKredytyPozyczki/Pozycja[child::Symbol = $symbol][1]/PW">
					<xsl:value-of select="format-number(TytulyDluzneKredytyPozyczki/Pozycja[child::Symbol = $symbol][1]/PW, '#&#160;##0,00')"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="'0,00'"/>
				</xsl:otherwise>
			</xsl:choose>
		</td>
		<td class="bottom-right-normal" style="text-align:right;font-size: 8pt; padding: 3px">
			<xsl:choose>
				<xsl:when test="TytulyDluzneKredytyPozyczki/Pozycja[child::Symbol = $symbol][1]/WZ">
					<xsl:value-of select="format-number(TytulyDluzneKredytyPozyczki/Pozycja[child::Symbol = $symbol][1]/WZ, '#&#160;##0,00')"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="'0,00'"/>
				</xsl:otherwise>
			</xsl:choose>
		</td>
	</xsl:template>
	<xsl:template name="Rb-Z_daneTabelaD">
		<xsl:param name="symbol"/>
		<xsl:param name="wyszczeg"/>
		<tr>
			<td class="bottom-right-normal" style="text-align:left;font-size: 8pt; padding: 3px">
				<xsl:value-of select="$symbol"/>. <xsl:value-of select="$wyszczeg"/>
			</td>
			<td class="bottom-right-normal" style="text-align:right;font-size: 8pt; padding: 3px">
				<xsl:choose>
					<xsl:when test="ZobowiazaniaKrotkoterminowe/Pozycja[child::Symbol = $symbol][1]/O">
						<xsl:value-of select="format-number(ZobowiazaniaKrotkoterminowe/Pozycja[child::Symbol = $symbol][1]/O, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
		</tr>
	</xsl:template>
	<!-- Rb-ZN -->
	<xsl:template match="Rb-ZN">
		<xsl:param name="jedIndex"/>
		<xsl:param name="sprIndex"/>
		<xsl:element name="div">
			<xsl:attribute name="Id"><xsl:value-of select="concat('Jed', $jedIndex, 'Wer', $sprIndex)"/></xsl:attribute>
			<xsl:attribute name="style"><xsl:value-of select="'display: block; margin-bottom: 40px'"/></xsl:attribute>
			<div style="font-size: 12pt; font-weight: bold; margin-left: 5px; margin-bottom: 10px">
        Sprawozdanie Rb-ZN:
        <xsl:choose>
					<xsl:when test="Naglowek/Wersja = 0">
						<xsl:value-of select="'wersja pierwotna'"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="concat('korekta nr ', Naglowek/Wersja)"/>
					</xsl:otherwise>
				</xsl:choose>
				<xsl:call-template name="SprNaglowekInfo"/>
			</div>
			<table cellpadding="0" cellspacing="0" class="all-bold" style="margin-bottom: 30px">
				<thead>
					<tr>
						<th style="width:333px"/>
						<th style="width: 56px"/>
						<th style="width: 365px"/>
						<th style="width: 37px"/>
						<th style="width: 265px"/>
					</tr>
				</thead>
				<tbody>
					<tr style="height: 18px">
						<td colspan="5" class="bottom-bold" style="font-size: 10pt;">MINISTERSTWO FINANSÓW, ul. Świętokrzyska 12, 00-916 Warszawa</td>
					</tr>
					<tr style="height: 127px">
						<td class="bottom-bold" style="width:333px">
							<table cellpadding="0" cellspacing="0" style="border-collapse: collapse; height" width="100%">
								<tbody>
									<tr style="height: 80px">
										<td style="text-align: left; font-size: 9pt; margin:1px 1px 0 0; padding:0" valign="top">
                      Nazwa i adres jednostki sprawozdawczej
                    </td>
									</tr>
									<tr>
										<td class="bottom-normal" style="text-align: center; font-size: 9pt" valign="bottom">
											<!-- popr. nr I.8 -->
											<div style="display: block;margin: 0 20px">
												<xsl:choose>
													<xsl:when test="Jednostka/Nazwa">
														<xsl:value-of select="Jednostka/Nazwa"/>
													</xsl:when>
													<xsl:otherwise>
														<xsl:value-of select="../../Nazwa"/>
													</xsl:otherwise>
												</xsl:choose>
												<!--<xsl:value-of select="../../Nazwa"/>-->
											</div>
										</td>
									</tr>
									<tr style="height: 23px">
										<td style="text-align: left; font-size: 9pt; margin:1px 1px 0 0; padding:0;" valign="top">
                      Numer identyfikacyjny REGON
                    </td>
									</tr>
									<tr>
										<td style="text-align: center; font-size: 9pt; font-weight: bold; margin:1px 1px 0 0; padding:0" valign="baseline">
											<xsl:choose>
												<xsl:when test="Jednostka/Regon">
													<xsl:value-of select="Jednostka/Regon"/>
												</xsl:when>
												<xsl:otherwise>
													<xsl:value-of select="../../Regon"/>
												</xsl:otherwise>
											</xsl:choose>
											<!--<xsl:value-of select="../../Regon"/>-->
										</td>
									</tr>
								</tbody>
							</table>
						</td>
						<td colspan="3" class="notop-bold" valign="top" style="width: 658px">
							<div style="font-weight: bold; text-align: center; font-size: 11pt; margin-bottom: 5px">Rb-ZN KWARTALNE SPRAWOZDANIE O STANIE ZOBOWIĄZAŃ ORAZ NALEŻNOŚCI SKARBU PAŃSTWA Z TYTUŁU WYKONYWANIA PRZEZ JEDNOSTKI SAMORZĄDU TERYTORIALNEGO ZADAŃ ZLECONYCH</div>
							<div style="font-weight: bold; text-align: center; font-size: 9pt; margin-bottom: 5px">jednostki bezpośrednio realizujące zadania</div>
							<div style=" text-align: center; font-size: 9pt; margin-bottom: 5px">
                a)sprawozdanie jednostkowe  b)sprawozdanie zbiorcze   c)sprawozdanie łączne <sup>1)</sup>
							</div>
							<div style="vertical-align: bottom; text-align: center; font-size: 9pt; margin-top: 15px">
								<xsl:call-template name="NaglowekSprOkres"/>
							</div>
						</td>
						<td class="bottom-bold" style="text-align: left; font-size: 9pt; margin:2px 2px 0 0; padding:0; width: 265px" valign="top">
							<div style="margin-bottom:5px">Adresat:</div>
							<!-- popr. nr I.9 -->
							<div style="text-align:center; margin-bottom: 15px;">
								<!-- <xsl:value-of select="'Regionalna Izba Obrachunkowa w Katowicach'"/> -->
							</div>
							<div style="text-align:center;">
								<!-- <xsl:value-of select="'wersja robocza'"/> -->
							</div>
						</td>
					</tr>
					<tr style="height: 54px">
						<td colspan="2" style="font-size: 9pt; border-style: solid; border-width: 2px 0 0 0; border-color:black">
							<!-- popr. nr I.10 -->
							<div style="margin-bottom: 1px">
								<xsl:value-of select="'Nazwa województwa'"/>
								<!-- <xsl:if test="../../Typ = 'W'">
									<span style="margin-left: 10px">
										<b>
											<xsl:value-of select="../../Nazwa"/>
										</b>
									</span>
								</xsl:if> -->
							</div>
							<div style="margin-bottom: 1px">
								<xsl:value-of select="'Nazwa powiatu / związku '"/>
								<sup>1)</sup>
								<!-- <xsl:if test="../../Typ = 'P'">
									<span style="margin-left: 10px">
										<b>
											<xsl:value-of select="../../Nazwa"/>
										</b>
									</span>
								</xsl:if> -->
							</div>
							<div>
								<xsl:value-of select="'Nazwa gminy / związku '"/>
								<sup>1)</sup>
								<!-- <xsl:if test="../../Typ = 'G'">
									<span style="margin-left: 10px">
										<b>
											<xsl:value-of select="../../Nazwa"/>
										</b>
									</span>
								</xsl:if> -->
							</div>
						</td>
						<td style="border-style: solid; border-width: 0 2px 0 2px; border-color: black; margin: 0; padding: 0">
							<table cellpadding="0" cellspacing="0" border="0" style="height:100%;width:100%">
								<tbody>
									<tr>
										<td colspan="8" style="font-size:10pt; text-align:center; border-style: solid; border-width: 0 0 2px 0; border-color: black">SYMBOLE</td>
									</tr>
									<tr>
										<td style="font-size:10pt; text-align:center; border-style: solid; border-width: 0 2px 2px 0; border-color: black">WOJ.</td>
										<td style="font-size:10pt; text-align:center; border-style: solid; border-width: 0 2px 2px 0; border-color: black">POWIAT</td>
										<td style="font-size:10pt; text-align:center; border-style: solid; border-width: 0 2px 2px 0; border-color: black">GMINA</td>
										<td style="font-size:10pt; text-align:center; border-style: solid; border-width: 0 2px 2px 0; border-color: black">TYP GM.</td>
										<td style="font-size:10pt; text-align:center; border-style: solid; border-width: 0 2px 2px 0; border-color: black">ZWIĄZEK JST</td>
										<td style="font-size:10pt; text-align:center; border-style: solid; border-width: 0 2px 2px 0; border-color: black">TYP ZW.</td>
										<td style="font-size:10pt; text-align:center; border-style: solid; border-width: 0 2px 2px 0; border-color: black">Grupa</td>
										<td style="font-size:10pt; text-align:center; border-style: solid; border-width: 0 0 2px 0; border-color: black">Część budz.</td>
									</tr>
									<tr>
										<td style="font-size:10pt; text-align:center; border-style: solid; border-width: 0 2px 0 0; border-color: black">
											<xsl:choose>
												<xsl:when test="Jednostka/WK">
													<xsl:value-of select="Jednostka/WK"/>
												</xsl:when>
												<xsl:otherwise>
													<xsl:value-of select="../../WK"/>
												</xsl:otherwise>
											</xsl:choose>
											<!--<xsl:value-of select="../../WK"/>-->
										</td>
										<td style="font-size:10pt; text-align:center; border-style: solid; border-width: 0 2px 0 0; border-color: black">
											<xsl:choose>
												<xsl:when test="Jednostka/PK">
													<xsl:value-of select="Jednostka/PK"/>
												</xsl:when>
												<xsl:otherwise>
													<xsl:value-of select="../../PK"/>
												</xsl:otherwise>
											</xsl:choose>
											<!--<xsl:value-of select="../../PK"/>-->
										</td>
										<td style="font-size:10pt; text-align:center; border-style: solid; border-width: 0 2px 0 0; border-color: black">
											<xsl:choose>
												<xsl:when test="Jednostka/GK">
													<xsl:value-of select="Jednostka/GK"/>
												</xsl:when>
												<xsl:otherwise>
													<xsl:value-of select="../../GK"/>
												</xsl:otherwise>
											</xsl:choose>
											<!--<xsl:value-of select="../../GK"/>-->
										</td>
										<td style="font-size:10pt; text-align:center; border-style: solid; border-width: 0 2px 0 0; border-color: black">
											<xsl:choose>
												<xsl:when test="Jednostka/GT">
													<xsl:value-of select="Jednostka/GT"/>
												</xsl:when>
												<xsl:otherwise>
													<xsl:value-of select="../../GT"/>
												</xsl:otherwise>
											</xsl:choose>
											<!--<xsl:value-of select="../../GT"/>-->
										</td>
										<td style="font-size:10pt; text-align:center; border-style: solid; border-width: 0 2px 0 0; border-color: black">
											<xsl:choose>
												<xsl:when test="Jednostka/KodMSWiA">
													<xsl:value-of select="Jednostka/KodMSWiA"/>
												</xsl:when>
												<xsl:otherwise>
													<xsl:choose>
														<xsl:when test="../../KodMSWiA">
															<xsl:value-of select="../../KodMSWiA"/>
														</xsl:when>
														<xsl:otherwise>
															<xsl:value-of select="$nbsp"/>
														</xsl:otherwise>
													</xsl:choose>
												</xsl:otherwise>
											</xsl:choose>
										</td>
										<td style="font-size:10pt; text-align:center; border-style: solid; border-width: 0 2px 0 0; border-color: black">
											<xsl:value-of select="$nbsp"/>
										</td>
										<td style="font-size:10pt; text-align:center; border-style: solid; border-width: 0 2px 0 0; border-color: black">
											<xsl:value-of select="$nbsp"/>
										</td>
										<td style="font-size:10pt; text-align:center; border-style: solid; border-width: 0 2px 0 0; border-color: black">
											<xsl:value-of select="$nbsp"/>
										</td>
									</tr>
								</tbody>
							</table>
						</td>
						<td colspan="2" style="font-size:9pt; text-align:right; border-style: solid; border-width: 2px 0 0 0; border-color:black">
							<div style="margin-right: 15px">Przed wypełnieniem przeczytać instrukcję</div>
						</td>
					</tr>
				</tbody>
			</table>
			<div style="display: block; margin-bottom: 40px">
				<div style="margin: 30px 0 10px 0; font-size: 12pt">A. Zobowiązania według tytułów dłużnych</div>
				<table cellpadding="0" cellspacing="0" class="all-bold">
					<tbody>
						<tr>
							<td rowspan="2" style="font-size: 8pt; font-weight: bold; width: 250px; text-align: center" class="bottom-right-bold">Wyszczególnienie</td>
							<td rowspan="2" style="font-size: 8pt; font-weight: bold; width: 160px; text-align: center" class="bottom-right-bold">kwota zadłużenia ogółem (kol.3+15)</td>
							<td colspan="12" style="font-size: 8pt; font-weight: bold; text-align: center" class="bottom-right-bold">wierzyciele krajowi</td>
							<td colspan="3" style="font-size: 8pt; font-weight: bold; text-align: center" class="bottom-right-bold">wierzyciele zagraniczni</td>
						</tr>
						<tr>
							<td style="font-size: 7pt; font-weight: bold; width: 60px; text-align: center" class="bottom-right-mixed">ogółem (kol. 4+9+10+11 +12+13+14)</td>
							<td style="font-size: 7pt; font-weight: bold; width: 60px; text-align: center" class="bottom-right-mixed">sektor finansów publicznych ogółem (kol. 5+6+7+8)</td>
							<td style="font-size: 7pt; font-weight: bold; width: 60px; text-align: center" class="bottom-right-mixed">grupa I</td>
							<td style="font-size: 7pt; font-weight: bold; width: 60px; text-align: center" class="bottom-right-mixed">grupa II</td>
							<td style="font-size: 7pt; font-weight: bold; width: 60px; text-align: center" class="bottom-right-mixed">grupa III</td>
							<td style="font-size: 7pt; font-weight: bold; width: 60px; text-align: center" class="bottom-right-mixed">grupa IV</td>
							<td style="font-size: 7pt; font-weight: bold; width: 60px; text-align: center" class="bottom-right-mixed">bank centralny</td>
							<td style="font-size: 7pt; font-weight: bold; width: 60px; text-align: center" class="bottom-right-mixed">banki</td>
							<td style="font-size: 7pt; font-weight: bold; width: 60px; text-align: center" class="bottom-right-mixed">pozostałe krajowe instytucje finansowe</td>
							<td style="font-size: 7pt; font-weight: bold; width: 100px; text-align: center" class="bottom-right-mixed">przedsiębiorstwa niefinansowe</td>
							<td style="font-size: 7pt; font-weight: bold; width: 100px; text-align: center" class="bottom-right-mixed">gospodarstwa domowe</td>
							<td style="font-size: 7pt; font-weight: bold; width: 100px; text-align: center" class="bottom-right-bold">instytucje niekomercyjne działające na rzecz gospodarstw domowych</td>
							<td style="font-size: 7pt; font-weight: bold; width: 100px; text-align: center" class="bottom-right-mixed">ogółem (kol. 16+17)</td>
							<td style="font-size: 7pt; font-weight: bold; width: 100px; text-align: center" class="bottom-right-mixed">podmioty należące do strefy euro</td>
							<td style="font-size: 7pt; font-weight: bold; width: 100px; text-align: center" class="bottom-right-mixed">pozostałe przedmioty zagraniczne</td>
						</tr>
						<tr>
							<td class="bottom-right-bold" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="1"/>
							</td>
							<td class="bottom-right-bold" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="2"/>
							</td>
							<td class="bottom-right-bold" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="3"/>
							</td>
							<td class="bottom-right-bold" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="4"/>
							</td>
							<td class="bottom-right-bold" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="5"/>
							</td>
							<td class="bottom-right-bold" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="6"/>
							</td>
							<td class="bottom-right-bold" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="7"/>
							</td>
							<td class="bottom-right-bold" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="8"/>
							</td>
							<td class="bottom-right-bold" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="9"/>
							</td>
							<td class="bottom-right-bold" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="10"/>
							</td>
							<td class="bottom-right-bold" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="11"/>
							</td>
							<td class="bottom-right-bold" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="12"/>
							</td>
							<td class="bottom-right-bold" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="13"/>
							</td>
							<td class="bottom-right-bold" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="14"/>
							</td>
							<td class="bottom-right-bold" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="15"/>
							</td>
							<td class="bottom-right-bold" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="16"/>
							</td>
							<td class="bottom-bold" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="17"/>
							</td>
						</tr>
						<tr>
							<td class="right-bottom-mixed" style="font-size: 8pt; text-align: left" valign="middle">
								<table cellpadding="0" cellspacing="0" border="0">
									<tbody>
										<tr>
											<td style="width: 10px; font-size: 8pt; text-align: center">E2</td>
											<td style="padding-left: 5px; font-size: 8pt; text-align: left">kredyty i pożyczki (E2.1+E2.2)</td>
										</tr>
									</tbody>
								</table>
							</td>
							<xsl:call-template name="Rb-ZN_daneTabelaA">
								<xsl:with-param name="symbol" select="'E2'"/>
								<xsl:with-param name="ostWiersz" select="false()"/>
							</xsl:call-template>
						</tr>
						<tr>
							<td class="right-bottom-mixed" style="font-size: 8pt; text-align: left" valign="middle">
								<table cellpadding="0" cellspacing="0" border="0">
									<tbody>
										<tr>
											<td style="padding-left: 10px; width: 10px; font-size: 8pt; text-align: center">E2.1</td>
											<td style="padding-left: 5px; font-size: 8pt; text-align: left">krótkoterminowe</td>
										</tr>
									</tbody>
								</table>
							</td>
							<xsl:call-template name="Rb-ZN_daneTabelaA">
								<xsl:with-param name="symbol" select="'E2.1'"/>
								<xsl:with-param name="ostWiersz" select="false()"/>
							</xsl:call-template>
						</tr>
						<tr>
							<td class="right-bottom-mixed" style="font-size: 8pt; text-align: left" valign="middle">
								<table cellpadding="0" cellspacing="0" border="0">
									<tbody>
										<tr>
											<td style="padding-left: 10px; width: 10px; font-size: 8pt; text-align: center">E2.2</td>
											<td style="padding-left: 5px; font-size: 8pt; text-align: left">długoterminowe</td>
										</tr>
									</tbody>
								</table>
							</td>
							<xsl:call-template name="Rb-ZN_daneTabelaA">
								<xsl:with-param name="symbol" select="'E2.2'"/>
								<xsl:with-param name="ostWiersz" select="false()"/>
							</xsl:call-template>
						</tr>
						<tr>
							<td class="right-bottom-mixed" style="font-size: 8pt; text-align: left" valign="middle">
								<table cellpadding="0" cellspacing="0" border="0">
									<tbody>
										<tr>
											<td style="width: 10px; font-size: 8pt; text-align: center">E4</td>
											<td style="padding-left: 5px; font-size: 8pt; text-align: left">wymagalne zobowiązania (E4.1+E4.2)</td>
										</tr>
									</tbody>
								</table>
							</td>
							<xsl:call-template name="Rb-ZN_daneTabelaA">
								<xsl:with-param name="symbol" select="'E4'"/>
								<xsl:with-param name="ostWiersz" select="false()"/>
							</xsl:call-template>
						</tr>
						<tr>
							<td class="right-bottom-mixed" style="font-size: 8pt; text-align: left" valign="middle">
								<table cellpadding="0" cellspacing="0" border="0">
									<tbody>
										<tr>
											<td style="padding-left: 10px; width: 10px; font-size: 8pt; text-align: center">E4.1</td>
											<td style="padding-left: 5px; font-size: 8pt; text-align: left">z tytułu dostaw towarów i usług</td>
										</tr>
									</tbody>
								</table>
							</td>
							<xsl:call-template name="Rb-ZN_daneTabelaA">
								<xsl:with-param name="symbol" select="'E4.1'"/>
								<xsl:with-param name="ostWiersz" select="false()"/>
							</xsl:call-template>
						</tr>
						<tr>
							<td class="right-bottom-mixed" style="font-size: 8pt; text-align: left" valign="middle">
								<table cellpadding="0" cellspacing="0" border="0">
									<tbody>
										<tr>
											<td style="padding-left: 10px; width: 10px; font-size: 8pt; text-align: center">E4.2</td>
											<td style="padding-left: 5px; font-size: 8pt; text-align: left">pozostałe</td>
										</tr>
									</tbody>
								</table>
							</td>
							<xsl:call-template name="Rb-ZN_daneTabelaA">
								<xsl:with-param name="symbol" select="'E4.2'"/>
								<xsl:with-param name="ostWiersz" select="false()"/>
							</xsl:call-template>
						</tr>
					</tbody>
				</table>
				<div style="margin: 30px 0 10px 0; font-size: 12pt">B. Należności oraz wybrane aktywa finansowe</div>
				<table cellpadding="0" cellspacing="0" class="all-bold">
					<tbody>
						<tr>
							<td rowspan="2" style="font-size: 8pt; font-weight: bold; width: 250px; text-align: center" class="bottom-right-bold">Wyszczególnienie</td>
							<td rowspan="2" style="font-size: 8pt; font-weight: bold; width: 160px; text-align: center" class="bottom-right-bold">kwota należności ogółem (kol.3+15)</td>
							<td colspan="12" style="font-size: 8pt; font-weight: bold; text-align: center" class="bottom-right-bold">dłużnicy krajowi</td>
							<td colspan="3" style="font-size: 8pt; font-weight: bold; text-align: center" class="bottom-right-bold">dłużnicy zagraniczni</td>
						</tr>
						<tr>
							<td style="font-size: 7pt; font-weight: bold; width: 60px; text-align: center" class="bottom-right-mixed">ogółem (kol. 4+9+10+11 +12+13+14)</td>
							<td style="font-size: 7pt; font-weight: bold; width: 60px; text-align: center" class="bottom-right-mixed">sektor finansów publicznych ogółem (kol. 5+6+7+8)</td>
							<td style="font-size: 7pt; font-weight: bold; width: 60px; text-align: center" class="bottom-right-mixed">grupa I</td>
							<td style="font-size: 7pt; font-weight: bold; width: 60px; text-align: center" class="bottom-right-mixed">grupa II</td>
							<td style="font-size: 7pt; font-weight: bold; width: 60px; text-align: center" class="bottom-right-mixed">grupy III</td>
							<td style="font-size: 7pt; font-weight: bold; width: 60px; text-align: center" class="bottom-right-mixed">grupy IV</td>
							<td style="font-size: 7pt; font-weight: bold; width: 60px; text-align: center" class="bottom-right-mixed">bank centralny</td>
							<td style="font-size: 7pt; font-weight: bold; width: 60px; text-align: center" class="bottom-right-mixed">banki</td>
							<td style="font-size: 7pt; font-weight: bold; width: 60px; text-align: center" class="bottom-right-mixed">pozostałe krajowe instytucje finansowe</td>
							<td style="font-size: 7pt; font-weight: bold; width: 100px; text-align: center" class="bottom-right-mixed">przedsiębiorstwa niefinansowe</td>
							<td style="font-size: 7pt; font-weight: bold; width: 100px; text-align: center" class="bottom-right-mixed">gospodarstwa domowe</td>
							<td style="font-size: 7pt; font-weight: bold; width: 100px; text-align: center" class="bottom-right-bold">instytucje niekomercyjne działające na rzecz gospodarstw domowych</td>
							<td style="font-size: 7pt; font-weight: bold; width: 90px; text-align: center" class="bottom-right-mixed">ogółem (kol. 16+17)</td>
							<td style="font-size: 7pt; font-weight: bold; width: 90px; text-align: center" class="bottom-right-mixed">podmioty należące do strefy euro</td>
							<td style="font-size: 7pt; font-weight: bold; width: 100px; text-align: center" class="bottom-right-mixed">pozostałe podmioty zagraniczne</td>
						</tr>
						<tr>
							<td class="bottom-right-bold" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="1"/>
							</td>
							<td class="bottom-right-bold" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="2"/>
							</td>
							<td class="bottom-right-bold" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="3"/>
							</td>
							<td class="bottom-right-bold" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="4"/>
							</td>
							<td class="bottom-right-bold" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="5"/>
							</td>
							<td class="bottom-right-bold" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="6"/>
							</td>
							<td class="bottom-right-bold" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="7"/>
							</td>
							<td class="bottom-right-bold" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="8"/>
							</td>
							<td class="bottom-right-bold" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="9"/>
							</td>
							<td class="bottom-right-bold" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="10"/>
							</td>
							<td class="bottom-right-bold" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="11"/>
							</td>
							<td class="bottom-right-bold" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="12"/>
							</td>
							<td class="bottom-right-bold" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="13"/>
							</td>
							<td class="bottom-right-bold" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="14"/>
							</td>
							<td class="bottom-right-bold" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="15"/>
							</td>
							<td class="bottom-right-bold" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="16"/>
							</td>
							<td class="bottom-bold" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="17"/>
							</td>
						</tr>
						<tr>
							<td class="right-bottom-mixed" style="font-size: 8pt; text-align: left" valign="middle">
								<table cellpadding="0" cellspacing="0" border="0">
									<tbody>
										<tr>
											<td style="width: 10px; font-size: 8pt; text-align: center">N3</td>
											<td style="padding-left: 5px; font-size: 8pt; text-align: left">gotówka i depozyty (N3.1+N3.2+N3.3)</td>
										</tr>
									</tbody>
								</table>
							</td>
							<xsl:call-template name="Rb-ZN_daneTabelaB">
								<xsl:with-param name="symbol" select="'N3'"/>
								<xsl:with-param name="ostWiersz" select="false()"/>
							</xsl:call-template>
						</tr>
						<tr>
							<td class="right-bottom-mixed" style="font-size: 8pt; text-align: left" valign="middle">
								<table cellpadding="0" cellspacing="0" border="0">
									<tbody>
										<tr>
											<td style="padding-left: 10px; width: 10px; font-size: 8pt; text-align: center">N3.1</td>
											<td style="padding-left: 5px; font-size: 8pt; text-align: left">gotówka</td>
										</tr>
									</tbody>
								</table>
							</td>
							<xsl:call-template name="Rb-ZN_daneTabelaB">
								<xsl:with-param name="symbol" select="'N3.1'"/>
								<xsl:with-param name="ostWiersz" select="false()"/>
							</xsl:call-template>
						</tr>
						<tr>
							<td class="right-bottom-mixed" style="font-size: 8pt; text-align: left" valign="middle">
								<table cellpadding="0" cellspacing="0" border="0">
									<tbody>
										<tr>
											<td style="padding-left: 10px; width: 10px; font-size: 8pt; text-align: center">N3.2</td>
											<td style="padding-left: 5px; font-size: 8pt; text-align: left">depozyty na żądanie</td>
										</tr>
									</tbody>
								</table>
							</td>
							<xsl:call-template name="Rb-ZN_daneTabelaB">
								<xsl:with-param name="symbol" select="'N3.2'"/>
								<xsl:with-param name="ostWiersz" select="false()"/>
							</xsl:call-template>
						</tr>
						<tr>
							<td class="right-bottom-mixed" style="font-size: 8pt; text-align: left" valign="middle">
								<table cellpadding="0" cellspacing="0" border="0">
									<tbody>
										<tr>
											<td style="padding-left: 10px; width: 10px; font-size: 8pt; text-align: center">N3.3</td>
											<td style="padding-left: 5px; font-size: 8pt; text-align: left">depozyty terminowe</td>
										</tr>
									</tbody>
								</table>
							</td>
							<xsl:call-template name="Rb-ZN_daneTabelaB">
								<xsl:with-param name="symbol" select="'N3.3'"/>
								<xsl:with-param name="ostWiersz" select="false()"/>
							</xsl:call-template>
						</tr>
						<tr>
							<td class="right-bottom-mixed" style="font-size: 8pt; text-align: left" valign="middle">
								<table cellpadding="0" cellspacing="0" border="0">
									<tbody>
										<tr>
											<td style="width: 10px; font-size: 8pt; text-align: center">N4</td>
											<td style="padding-left: 5px; font-size: 8pt; text-align: left">należności wymagalne (N4.1+N4.2)</td>
										</tr>
									</tbody>
								</table>
							</td>
							<xsl:call-template name="Rb-ZN_daneTabelaB">
								<xsl:with-param name="symbol" select="'N4'"/>
								<xsl:with-param name="ostWiersz" select="false()"/>
							</xsl:call-template>
						</tr>
						<tr>
							<td class="right-bottom-mixed" style="font-size: 8pt; text-align: left" valign="middle">
								<table cellpadding="0" cellspacing="0" border="0">
									<tbody>
										<tr>
											<td style="padding-left: 10px; width: 10px; font-size: 8pt; text-align: center">N4.1</td>
											<td style="padding-left: 5px; font-size: 8pt; text-align: left">z tytułu dostaw towarów i usług</td>
										</tr>
									</tbody>
								</table>
							</td>
							<xsl:call-template name="Rb-ZN_daneTabelaB">
								<xsl:with-param name="symbol" select="'N4.1'"/>
								<xsl:with-param name="ostWiersz" select="false()"/>
							</xsl:call-template>
						</tr>
						<tr>
							<td class="right-bottom-mixed" style="font-size: 8pt; text-align: left" valign="middle">
								<table cellpadding="0" cellspacing="0" border="0">
									<tbody>
										<tr>
											<td style="padding-left: 10px; width: 10px; font-size: 8pt; text-align: center">N4.2</td>
											<td style="padding-left: 5px; font-size: 8pt; text-align: left">pozostałe</td>
										</tr>
									</tbody>
								</table>
							</td>
							<xsl:call-template name="Rb-ZN_daneTabelaB">
								<xsl:with-param name="symbol" select="'N4.2'"/>
								<xsl:with-param name="ostWiersz" select="false()"/>
							</xsl:call-template>
						</tr>
						<tr>
							<td class="right-bottom-mixed" style="font-size: 8pt; text-align: left" valign="middle">
								<table cellpadding="0" cellspacing="0" border="0">
									<tbody>
										<tr>
											<td style="width: 10px; font-size: 8pt; text-align: center">N5</td>
											<td style="padding-left: 5px; font-size: 8pt; text-align: left">pozostałe należności (N5.1+N5.2+N5.3)</td>
										</tr>
									</tbody>
								</table>
							</td>
							<xsl:call-template name="Rb-ZN_daneTabelaB">
								<xsl:with-param name="symbol" select="'N5'"/>
								<xsl:with-param name="ostWiersz" select="false()"/>
							</xsl:call-template>
						</tr>
						<tr>
							<td class="right-bottom-mixed" style="font-size: 8pt; text-align: left" valign="middle">
								<table cellpadding="0" cellspacing="0" border="0">
									<tbody>
										<tr>
											<td style="padding-left: 10px; width: 10px; font-size: 8pt; text-align: center">N5.1</td>
											<td style="padding-left: 5px; font-size: 8pt; text-align: left">z tytułu dostaw towarów i usług</td>
										</tr>
									</tbody>
								</table>
							</td>
							<xsl:call-template name="Rb-ZN_daneTabelaB">
								<xsl:with-param name="symbol" select="'N5.1'"/>
								<xsl:with-param name="ostWiersz" select="false()"/>
							</xsl:call-template>
						</tr>
						<tr>
							<td class="right-bottom-mixed" style="font-size: 8pt; text-align: left" valign="middle">
								<table cellpadding="0" cellspacing="0" border="0">
									<tbody>
										<tr>
											<td style="padding-left: 10px; width: 10px; font-size: 8pt; text-align: center">N5.2</td>
											<td style="padding-left: 5px; font-size: 8pt; text-align: left">z tytułu podatków i składek na ubezpieczenia społ.</td>
										</tr>
									</tbody>
								</table>
							</td>
							<xsl:call-template name="Rb-ZN_daneTabelaB">
								<xsl:with-param name="symbol" select="'N5.2'"/>
								<xsl:with-param name="ostWiersz" select="false()"/>
							</xsl:call-template>
						</tr>
						<tr>
							<td class="bottom-right-bold" style="font-size: 8pt; text-align: left" valign="middle">
								<table cellpadding="0" cellspacing="0" border="0">
									<tbody>
										<tr>
											<td style="padding-left: 10px; width: 10px; font-size: 8pt; text-align: center">N5.3</td>
											<td style="padding-left: 5px; font-size: 8pt; text-align: left">z tytułu innych niż wymienione powyżej.</td>
										</tr>
									</tbody>
								</table>
							</td>
							<xsl:call-template name="Rb-ZN_daneTabelaB">
								<xsl:with-param name="symbol" select="'N5.3'"/>
								<xsl:with-param name="ostWiersz" select="true()"/>
							</xsl:call-template>
						</tr>
					</tbody>
				</table>
				<!-- ewentualne uwagi z pozycji -->
				<xsl:if test="TytulyDluzne/Pozycja[child::Uwagi]">
					<table cellpadding="0" cellspacing="0" class="all-bold" style="margin-bottom: 20px; width: 100%">
						<tbody>
							<tr>
								<td colspan="3" style="text-align: center; font-size: 9pt; font-weight: bold; padding: 3px 10px">
									<div>Uwagi do części: "Zobowiązania według tytułów dłużnych"</div>
								</td>
							</tr>
							<tr>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 4px 4px 0; width: 6%">Symbol</td>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 4px 4px 0; width: 24%">Wyszczególnienie</td>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 0 4px 0">Uwaga</td>
							</tr>
							<xsl:for-each select="TytulyDluzne/Pozycja[child::Uwagi]">
								<xsl:sort select="Symbol"/>
								<tr>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="Symbol"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:choose>
											<xsl:when test="Symbol = 'E2'">kredyty i pożyczki (E2.1+E2.2)</xsl:when>
											<xsl:when test="Symbol = 'E2.1'">krótkoterminowe</xsl:when>
											<xsl:when test="Symbol = 'E2.2'">długoterminowe</xsl:when>
											<xsl:when test="Symbol = 'E4'">wymagalne zobowiązania (E4.1+E4.2)</xsl:when>
											<xsl:when test="Symbol = 'E4.1'">z tytułu dostaw towarów i usług</xsl:when>
											<xsl:when test="Symbol = 'E4.2'">pozostałe</xsl:when>
										</xsl:choose>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:value-of select="Uwagi"/>
									</td>
								</tr>
							</xsl:for-each>
						</tbody>
					</table>
				</xsl:if>
				<xsl:if test="Naleznosci/Pozycja[child::Uwagi]">
					<table cellpadding="0" cellspacing="0" class="all-bold" style="margin-bottom: 20px; width: 100%">
						<tbody>
							<tr>
								<td colspan="3" style="text-align: center; font-size: 9pt; font-weight: bold; padding: 3px 10px">
									<div>Uwagi do części: "Należności oraz wybrane aktywa finansowe"</div>
								</td>
							</tr>
							<tr>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 4px 4px 0; width: 6%">Symbol</td>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 4px 4px 0; width: 24%">Wyszczególnienie</td>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 0 4px 0">Uwaga</td>
							</tr>
							<xsl:for-each select="Naleznosci/Pozycja[child::Uwagi]">
								<xsl:sort select="Symbol"/>
								<tr>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="Symbol"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:choose>
											<xsl:when test="Symbol = 'N3'">gotówka i depozyty (N3.1+N3.2+N3.3)</xsl:when>
											<xsl:when test="Symbol = 'N3.1'">gotówka</xsl:when>
											<xsl:when test="Symbol = 'N3.2'">depozyty na żądanie</xsl:when>
											<xsl:when test="Symbol = 'N3.3'">depozyty terminowe</xsl:when>
											<xsl:when test="Symbol = 'N4'">należności wymagalne (N4.1+N4.2)</xsl:when>
											<xsl:when test="Symbol = 'N4.1'">z tytułu dostaw towarów i usług</xsl:when>
											<xsl:when test="Symbol = 'N4.2'">pozostałe</xsl:when>
											<xsl:when test="Symbol = 'N5'">pozostałe należności (N5.1+N5.2+N5.3)</xsl:when>
											<xsl:when test="Symbol = 'N5.1'">z tytułu dostaw towarów i usług</xsl:when>
											<xsl:when test="Symbol = 'N5.2'">z tytułu podatków i składek na ubezpieczenia społ.</xsl:when>
											<xsl:when test="Symbol = 'N5.3'">z tytułu innych niż wymienione powyżej.</xsl:when>
										</xsl:choose>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:value-of select="Uwagi"/>
									</td>
								</tr>
							</xsl:for-each>
						</tbody>
					</table>
				</xsl:if>
				<div style="margin-bottom: 40px">
					<div style="display: block; font-size: 7pt">
						<sup>1)</sup> niepotrzebne skreślić
          </div>
				</div>
				<table cellpadding="0" cellspacing="0" style="margin-bottom: 50px; margin-top: 80px; width: 80%">
					<tbody>
						<tr>
							<td style="text-align:center; font-size: 8pt;" valign="baseline" width="25%">
								<hr style="width: 90%;text-align:center; "/>
								<div style="text-align:center;">główny księgowy <sup>*</sup>/skarbnik</div>
								<div style="text-align:center;">
									<sup>*</sup>W przypadku braku głównego księgowego podpisuje tylko kierownik jednostki.</div>
							</td>
							<td style="text-align:center; font-size: 8pt;" valign="baseline" width="25%">
								<hr style="width: 90%;text-align:center"/>
								<div style="text-align:center;">telefon</div>
								<div>
									<xsl:value-of select="$nbsp"/>
								</div>
							</td>
							<td style="text-align:center; font-size: 8pt;" valign="baseline" width="25%">
								<hr style="width: 90%;text-align:center"/>
								<div style="text-align:center;">rok mc dzień</div>
								<div>
									<xsl:value-of select="$nbsp"/>
								</div>
							</td>
							<td style="text-align:center; font-size: 8pt;" valign="baseline" width="25%">
								<hr style="width: 90%;text-align:center"/>
								<div style="text-align:center;">kierownik jednostki (jednostki obsługującej)/ przewodniczący zarządu</div>
								<div>
									<xsl:value-of select="$nbsp"/>
								</div>
							</td>
						</tr>
						<tr>
							<td style="text-align:center; font-size: 8pt;">
								<div>
									<xsl:for-each select="../../Podpisy/*[name() = 'ds:Signature']">
										<xsl:if test="contains(@Id, 'RbZN')">
											<xsl:if test="contains(translate(*[name() = 'ds:Object']/*[name() = 'xades:QualifyingProperties']/*[name() = 'xades:SignedProperties']/*[name() = 'xades:SignedSignatureProperties']/*[name() = 'xades:SignerRole']/*[name() = 'xades:ClaimedRoles']/*[name() = 'xades:ClaimedRole']/*[name() = 'Role'], 'S','s'),'skarbnik')">
												<xsl:value-of select="substring(*[name() = 'ds:Object']/*[name() = 'xades:QualifyingProperties']/*[name() = 'xades:SignedProperties']/*[name() = 'xades:SignedSignatureProperties']/*[name() = 'xades:SigningTime'], 1, 10)"/>
											</xsl:if>
										</xsl:if>
									</xsl:for-each>
								</div>
							</td>
							<td/>
							<td style="text-align:center; font-size: 8pt;">
								<div>
									<xsl:for-each select="../../Podpisy/*[name() = 'ds:Signature']">
										<xsl:if test="contains(@Id, 'RbZN')">
											<xsl:if test="contains(translate(*[name() = 'ds:Object']/*[name() = 'xades:QualifyingProperties']/*[name() = 'xades:SignedProperties']/*[name() = 'xades:SignedSignatureProperties']/*[name() = 'xades:SignerRole']/*[name() = 'xades:ClaimedRoles']/*[name() = 'xades:ClaimedRole']/*[name() = 'Role'], 'K','k'),'kierownik')">
												<xsl:value-of select="substring(*[name() = 'ds:Object']/*[name() = 'xades:QualifyingProperties']/*[name() = 'xades:SignedProperties']/*[name() = 'xades:SignedSignatureProperties']/*[name() = 'xades:SigningTime'], 1,10)"/>
											</xsl:if>
										</xsl:if>
									</xsl:for-each>
								</div>
							</td>
						</tr>
					</tbody>
				</table>
			</div>
			<xsl:element name="a">
				<xsl:attribute name="href"><xsl:value-of select="concat('#Jed', $jedIndex)"/></xsl:attribute>
				<xsl:element name="style">
					<xsl:value-of select="'font-family: Verdana'"/>
				</xsl:element>
				<xsl:value-of select="'Powrót do listy sprawozdań jednostki'"/>
			</xsl:element>
		</xsl:element>
	</xsl:template>
	<!-- Rb-ZN szablony pomocnicze -->
	<xsl:template name="Rb-ZN_daneTabelaA">
		<xsl:param name="symbol"/>
		<xsl:param name="ostWiersz" select="false()"/>
		<xsl:choose>
			<xsl:when test="$ostWiersz = false()">
				<td class="right-bottom-mixed" style="text-align:right;font-size: 8pt; padding: 3px">
					<xsl:choose>
						<xsl:when test="TytulyDluzne/Pozycja[child::Symbol = $symbol][1]/Z">
							<xsl:value-of select="format-number(TytulyDluzne/Pozycja[child::Symbol = $symbol][1]/Z, '#&#160;##0,00')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'0,00'"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td class="bottom-right-normal" style="text-align:right;font-size: 8pt; padding: 3px">
					<xsl:choose>
						<xsl:when test="TytulyDluzne/Pozycja[child::Symbol = $symbol][1]/KO">
							<xsl:value-of select="format-number(TytulyDluzne/Pozycja[child::Symbol = $symbol][1]/KO, '#&#160;##0,00')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'0,00'"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td class="bottom-right-normal" style="text-align:right;font-size: 8pt; padding: 3px">
					<xsl:choose>
						<xsl:when test="TytulyDluzne/Pozycja[child::Symbol = $symbol][1]/KFP">
							<xsl:value-of select="format-number(TytulyDluzne/Pozycja[child::Symbol = $symbol][1]/KFP, '#&#160;##0,00')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'0,00'"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td class="bottom-right-normal" style="text-align:right;font-size: 8pt; padding: 3px">
					<xsl:choose>
						<xsl:when test="TytulyDluzne/Pozycja[child::Symbol = $symbol][1]/KG1">
							<xsl:value-of select="format-number(TytulyDluzne/Pozycja[child::Symbol = $symbol][1]/KG1, '#&#160;##0,00')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'0,00'"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td class="bottom-right-normal" style="text-align:right;font-size: 8pt; padding: 3px">
					<xsl:choose>
						<xsl:when test="TytulyDluzne/Pozycja[child::Symbol = $symbol][1]/KG2">
							<xsl:value-of select="format-number(TytulyDluzne/Pozycja[child::Symbol = $symbol][1]/KG2, '#&#160;##0,00')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'0,00'"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td class="bottom-right-normal" style="text-align:right;font-size: 8pt; padding: 3px">
					<xsl:choose>
						<xsl:when test="TytulyDluzne/Pozycja[child::Symbol = $symbol][1]/KG3">
							<xsl:value-of select="format-number(TytulyDluzne/Pozycja[child::Symbol = $symbol][1]/KG3, '#&#160;##0,00')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'0,00'"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td class="bottom-right-normal" style="text-align:right;font-size: 8pt; padding: 3px">
					<xsl:choose>
						<xsl:when test="TytulyDluzne/Pozycja[child::Symbol = $symbol][1]/KG4">
							<xsl:value-of select="format-number(TytulyDluzne/Pozycja[child::Symbol = $symbol][1]/KG4, '#&#160;##0,00')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'0,00'"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td class="bottom-right-normal" style="text-align:right;font-size: 8pt; padding: 3px">
					<xsl:choose>
						<xsl:when test="TytulyDluzne/Pozycja[child::Symbol = $symbol][1]/KBC">
							<xsl:value-of select="format-number(TytulyDluzne/Pozycja[child::Symbol = $symbol][1]/KBC, '#&#160;##0,00')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'0,00'"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td class="bottom-right-normal" style="text-align:right;font-size: 8pt; padding: 3px">
					<xsl:choose>
						<xsl:when test="TytulyDluzne/Pozycja[child::Symbol = $symbol][1]/KBK">
							<xsl:value-of select="format-number(TytulyDluzne/Pozycja[child::Symbol = $symbol][1]/KBK, '#&#160;##0,00')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'0,00'"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td class="bottom-right-normal" style="text-align:right;font-size: 8pt; padding: 3px">
					<xsl:choose>
						<xsl:when test="TytulyDluzne/Pozycja[child::Symbol = $symbol][1]/KIF">
							<xsl:value-of select="format-number(TytulyDluzne/Pozycja[child::Symbol = $symbol][1]/KIF, '#&#160;##0,00')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'0,00'"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td class="bottom-right-normal" style="text-align:right;font-size: 8pt; padding: 3px">
					<xsl:choose>
						<xsl:when test="TytulyDluzne/Pozycja[child::Symbol = $symbol][1]/KPN">
							<xsl:value-of select="format-number(TytulyDluzne/Pozycja[child::Symbol = $symbol][1]/KPN, '#&#160;##0,00')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'0,00'"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td class="bottom-right-normal" style="text-align:right;font-size: 8pt; padding: 3px">
					<xsl:choose>
						<xsl:when test="TytulyDluzne/Pozycja[child::Symbol = $symbol][1]/KGD">
							<xsl:value-of select="format-number(TytulyDluzne/Pozycja[child::Symbol = $symbol][1]/KGD, '#&#160;##0,00')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'0,00'"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td class="right-bottom-mixed" style="text-align:right;font-size: 8pt; padding: 3px">
					<xsl:choose>
						<xsl:when test="TytulyDluzne/Pozycja[child::Symbol = $symbol][1]/KIN">
							<xsl:value-of select="format-number(TytulyDluzne/Pozycja[child::Symbol = $symbol][1]/KIN, '#&#160;##0,00')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'0,00'"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td class="bottom-right-normal" style="text-align:right;font-size: 8pt; padding: 3px">
					<xsl:choose>
						<xsl:when test="TytulyDluzne/Pozycja[child::Symbol = $symbol][1]/ZO">
							<xsl:value-of select="format-number(TytulyDluzne/Pozycja[child::Symbol = $symbol][1]/ZO, '#&#160;##0,00')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'0,00'"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td class="bottom-right-normal" style="text-align:right;font-size: 8pt; padding: 3px">
					<xsl:choose>
						<xsl:when test="TytulyDluzne/Pozycja[child::Symbol = $symbol][1]/ZSE">
							<xsl:value-of select="format-number(TytulyDluzne/Pozycja[child::Symbol = $symbol][1]/ZSE, '#&#160;##0,00')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'0,00'"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td class="right-bottom-mixed" style="text-align:right;font-size: 8pt; padding: 3px">
					<xsl:choose>
						<xsl:when test="TytulyDluzne/Pozycja[child::Symbol = $symbol][1]/ZPZ">
							<xsl:value-of select="format-number(TytulyDluzne/Pozycja[child::Symbol = $symbol][1]/ZPZ, '#&#160;##0,00')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'0,00'"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
			</xsl:when>
			<xsl:otherwise>
				<td class="bottom-right-bold" style="text-align:right;font-size: 8pt; padding: 3px">
					<xsl:choose>
						<xsl:when test="TytulyDluzne/Pozycja[child::Symbol = $symbol][1]/Z">
							<xsl:value-of select="format-number(TytulyDluzne/Pozycja[child::Symbol = $symbol][1]/Z, '#&#160;##0,00')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'0,00'"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td class="bottom-right-mixed" style="text-align:right;font-size: 8pt; padding: 3px">
					<xsl:choose>
						<xsl:when test="TytulyDluzne/Pozycja[child::Symbol = $symbol][1]/KO">
							<xsl:value-of select="format-number(TytulyDluzne/Pozycja[child::Symbol = $symbol][1]/KO, '#&#160;##0,00')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'0,00'"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td class="bottom-right-mixed" style="text-align:right;font-size: 8pt; padding: 3px">
					<xsl:choose>
						<xsl:when test="TytulyDluzne/Pozycja[child::Symbol = $symbol][1]/KFP">
							<xsl:value-of select="format-number(TytulyDluzne/Pozycja[child::Symbol = $symbol][1]/KFP, '#&#160;##0,00')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'0,00'"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td class="bottom-right-mixed" style="text-align:right;font-size: 8pt; padding: 3px">
					<xsl:choose>
						<xsl:when test="TytulyDluzne/Pozycja[child::Symbol = $symbol][1]/KG1">
							<xsl:value-of select="format-number(TytulyDluzne/Pozycja[child::Symbol = $symbol][1]/KG1, '#&#160;##0,00')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'0,00'"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td class="bottom-right-mixed" style="text-align:right;font-size: 8pt; padding: 3px">
					<xsl:choose>
						<xsl:when test="TytulyDluzne/Pozycja[child::Symbol = $symbol][1]/KG2">
							<xsl:value-of select="format-number(TytulyDluzne/Pozycja[child::Symbol = $symbol][1]/KG2, '#&#160;##0,00')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'0,00'"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td class="bottom-right-mixed" style="text-align:right;font-size: 8pt; padding: 3px">
					<xsl:choose>
						<xsl:when test="TytulyDluzne/Pozycja[child::Symbol = $symbol][1]/KG3">
							<xsl:value-of select="format-number(TytulyDluzne/Pozycja[child::Symbol = $symbol][1]/KG3, '#&#160;##0,00')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'0,00'"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td class="bottom-right-mixed" style="text-align:right;font-size: 8pt; padding: 3px">
					<xsl:choose>
						<xsl:when test="TytulyDluzne/Pozycja[child::Symbol = $symbol][1]/KG4">
							<xsl:value-of select="format-number(TytulyDluzne/Pozycja[child::Symbol = $symbol][1]/KG4, '#&#160;##0,00')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'0,00'"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td class="bottom-right-mixed" style="text-align:right;font-size: 8pt; padding: 3px">
					<xsl:choose>
						<xsl:when test="TytulyDluzne/Pozycja[child::Symbol = $symbol][1]/KBC">
							<xsl:value-of select="format-number(TytulyDluzne/Pozycja[child::Symbol = $symbol][1]/KBC, '#&#160;##0,00')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'0,00'"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td class="bottom-right-mixed" style="text-align:right;font-size: 8pt; padding: 3px">
					<xsl:choose>
						<xsl:when test="TytulyDluzne/Pozycja[child::Symbol = $symbol][1]/KBK">
							<xsl:value-of select="format-number(TytulyDluzne/Pozycja[child::Symbol = $symbol][1]/KBK, '#&#160;##0,00')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'0,00'"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td class="bottom-right-mixed" style="text-align:right;font-size: 8pt; padding: 3px">
					<xsl:choose>
						<xsl:when test="TytulyDluzne/Pozycja[child::Symbol = $symbol][1]/KIF">
							<xsl:value-of select="format-number(TytulyDluzne/Pozycja[child::Symbol = $symbol][1]/KIF, '#&#160;##0,00')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'0,00'"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td class="bottom-right-mixed" style="text-align:right;font-size: 8pt; padding: 3px">
					<xsl:choose>
						<xsl:when test="TytulyDluzne/Pozycja[child::Symbol = $symbol][1]/KPN">
							<xsl:value-of select="format-number(TytulyDluzne/Pozycja[child::Symbol = $symbol][1]/KPN, '#&#160;##0,00')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'0,00'"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td class="bottom-right-mixed" style="text-align:right;font-size: 8pt; padding: 3px">
					<xsl:choose>
						<xsl:when test="TytulyDluzne/Pozycja[child::Symbol = $symbol][1]/KGD">
							<xsl:value-of select="format-number(TytulyDluzne/Pozycja[child::Symbol = $symbol][1]/KGD, '#&#160;##0,00')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'0,00'"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td class="bottom-right-bold" style="text-align:right;font-size: 8pt; padding: 3px">
					<xsl:choose>
						<xsl:when test="TytulyDluzne/Pozycja[child::Symbol = $symbol][1]/KIN">
							<xsl:value-of select="format-number(TytulyDluzne/Pozycja[child::Symbol = $symbol][1]/KIN, '#&#160;##0,00')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'0,00'"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td class="bottom-right-mixed" style="text-align:right;font-size: 8pt; padding: 3px">
					<xsl:choose>
						<xsl:when test="TytulyDluzne/Pozycja[child::Symbol = $symbol][1]/ZO">
							<xsl:value-of select="format-number(TytulyDluzne/Pozycja[child::Symbol = $symbol][1]/ZO, '#&#160;##0,00')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'0,00'"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td class="bottom-right-mixed" style="text-align:right;font-size: 8pt; padding: 3px">
					<xsl:choose>
						<xsl:when test="TytulyDluzne/Pozycja[child::Symbol = $symbol][1]/ZSE">
							<xsl:value-of select="format-number(TytulyDluzne/Pozycja[child::Symbol = $symbol][1]/ZSE, '#&#160;##0,00')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'0,00'"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td class="bottom-right-bold" style="text-align:right;font-size: 8pt; padding: 3px">
					<xsl:choose>
						<xsl:when test="TytulyDluzne/Pozycja[child::Symbol = $symbol][1]/ZPZ">
							<xsl:value-of select="format-number(TytulyDluzne/Pozycja[child::Symbol = $symbol][1]/ZPZ, '#&#160;##0,00')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'0,00'"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!-- B-Jed -->
	<xsl:template match="B-Jed">
		<xsl:param name="jedIndex"/>
		<xsl:param name="sprIndex"/>
		<!-- <xsl:variable name="okrMies">
			<xsl:call-template name="okrMies">
				<xsl:with-param name="nrOkr" select="../../../../Okres/Okres"/>
				<xsl:with-param name="typOkr" select="../../../../Okres/TypOkresu"/>
			</xsl:call-template>
		</xsl:variable> -->
		<xsl:element name="div">
			<xsl:attribute name="Id"><xsl:value-of select="concat('Jed', $jedIndex, 'Wer', $sprIndex)"/></xsl:attribute>
			<xsl:attribute name="style"><xsl:value-of select="'display: block; margin-bottom: 40px'"/></xsl:attribute>
			<div style="font-size: 12pt; font-weight: bold; margin-left: 5px; margin-bottom: 10px">
        Sprawozdanie B-Jed:
        <xsl:choose>
					<xsl:when test="Naglowek/Wersja = 0">
						<xsl:value-of select="'wersja pierwotna'"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="concat('korekta nr ', Naglowek/Wersja)"/>
					</xsl:otherwise>
				</xsl:choose>
				<xsl:call-template name="SprNaglowekInfo"/>
			</div>
			<table cellpadding="0" cellspacing="0" class="all-bold" style="margin-bottom: 30px">
				<thead>
					<tr>
						<th style="width:333px"/>
						<th style="width: 56px"/>
						<th style="width: 365px"/>
						<th style="width: 37px"/>
						<th style="width: 265px"/>
					</tr>
				</thead>
				<tbody>
					<tr style="height: 127px">
						<td class="bottom-bold" style="width:333px">
							<table cellpadding="0" cellspacing="0" style="border-collapse: collapse; height" width="100%">
								<tbody>
									<tr style="height: 80px">
										<td style="text-align: left; font-size: 9pt; margin:1px 1px 0 0; padding:0" valign="top">
                      Nazwa i adres jednostki sprawozdawczej
                    </td>
									</tr>
									<tr>
										<td class="bottom-normal" style="text-align: center; font-size: 9pt" valign="bottom">
											<!-- popr. nr I.8 -->
											<div style="display: block;margin: 0 20px">
												<xsl:choose>
													<xsl:when test="Jednostka/Nazwa">
														<xsl:value-of select="Jednostka/Nazwa"/>
													</xsl:when>
													<xsl:otherwise>
														<xsl:value-of select="../../Nazwa"/>
													</xsl:otherwise>
												</xsl:choose>
												<!--<xsl:value-of select="../../Nazwa"/>-->
											</div>
										</td>
									</tr>
									<tr style="height: 23px">
										<td style="text-align: left; font-size: 9pt; margin:1px 1px 0 0; padding:0;" valign="top">
                      Numer identyfikacyjny REGON
                    </td>
									</tr>
									<tr>
										<td style="text-align: center; font-size: 9pt; font-weight: bold; margin:1px 1px 0 0; padding:0" valign="baseline">
											<xsl:choose>
												<xsl:when test="Jednostka/Regon">
													<xsl:value-of select="Jednostka/Regon"/>
												</xsl:when>
												<xsl:otherwise>
													<xsl:value-of select="../../Regon"/>
												</xsl:otherwise>
											</xsl:choose>
											<!--<xsl:value-of select="../../Regon"/>-->
										</td>
									</tr>
								</tbody>
							</table>
						</td>
						<td colspan="3" class="notop-bold" valign="top" style="width: 458px">
							<div style="font-weight: bold; text-align: center; font-size: 11pt">BILANS JEDNOSTKOWY</div>
							<div style="font-weight: bold; text-align: center; font-size: 11pt; margin-bottom: 5px">
								<xsl:choose>
									<xsl:when test="Naglowek/BilansLacznyDla = 'JB'">
										<xsl:value-of select="'jednostki budżetowej'"/>
									</xsl:when>
									<xsl:when test="Naglowek/BilansLacznyDla = 'ZB'">
										<xsl:value-of select="'zakładu budżetowego'"/>
									</xsl:when>
									<xsl:when test="Naglowek/BilansLacznyDla = 'GP'">
										<xsl:value-of select="'gospodarstwa pomocniczego'"/>
									</xsl:when>
									<xsl:otherwise>
                  </xsl:otherwise>
								</xsl:choose>
							</div>
							<div style="vertical-align: bottom; text-align: center; font-weight: bold; font-size: 9pt; margin-top: 65px">
								<xsl:value-of select="'sporządzony na dzień'"/>
							</div>
							<div style="vertical-align: bottom; text-align: center; font-weight: bold; font-size: 9pt; margin-top: 5px">
								<xsl:value-of select="concat('31-12-', ../../../../Okres/Rok)"/>
								<!-- <xsl:call-template name="ostDzienMies">
									<xsl:with-param name="month" select="$okrMies"/>
									<xsl:with-param name="year" select="../../../../Okres/Rok"/>
								</xsl:call-template>
								<xsl:value-of select="'-'"/>
								<xsl:value-of select="$okrMies"/>
								<xsl:value-of select="'-'"/>
								<xsl:value-of select="../../../../Okres/Rok"/> -->
							</div>
						</td>
						<td class="bottom-bold" style="text-align: left; font-size: 9pt; margin:2px 2px 0 0; padding:0; width: 265px" valign="top">
							<table cellpadding="0" cellspacing="0" style="border-collapse: collapse; height" width="100%">
								<tbody>
									<tr style="height: 80px">
										<td class="bottom-normal" style="text-align: left; font-size: 9pt; margin:2px 2px 0 0; padding:0" valign="top">
											<div style="margin-bottom:5px">Adresat:</div>
											<!-- popr. nr I.9 -->
											<div style="text-align:center; margin-bottom: 15px;">
												<!-- <xsl:value-of select="'Regionalna Izba Obrachunkowa w Katowicach'"/> -->
											</div>
										</td>
									</tr>
									<tr style="height: 23px">
										<td style="text-align: left; font-size: 9pt; margin:2px 2px 0 0; padding:0;" valign="top">
											<div style="margin-bottom:5px">Wysłać bez pisma przewodniego</div>
											<div style="text-align:center;">
												<!-- <xsl:value-of select="'wersja robocza'"/> -->
											</div>
										</td>
									</tr>
								</tbody>
							</table>
						</td>
					</tr>
					<tr style="height: 20px">
						<td class="bottom-right-bold"/>
						<td colspan="3" class="bottom-right-bold"/>
						<td class="bottom-right-bold"/>
					</tr>
				</tbody>
			</table>
			<div style="display: block; margin-bottom: 40px">
				<table cellpadding="0" cellspacing="0" class="all-bold" style="margin-bottom: 20px">
					<tbody>
						<tr>
							<td style="font-size: 8pt; font-weight: bold; width: 170px; text-align: center" class="bottom-right-mixed">AKTYWA</td>
							<td style="font-size: 8pt; font-weight: bold; width: 170px; text-align: center" class="bottom-right-mixed">Stan na początek roku</td>
							<td style="font-size: 8pt; font-weight: bold; width: 170px; text-align: center" class="bottom-right-bold">Stan na koniec roku</td>
							<td style="font-size: 8pt; font-weight: bold; width: 170px; text-align: center" class="bottom-right-mixed">PASYWA</td>
							<td style="font-size: 8pt; font-weight: bold; width: 170px; text-align: center" class="bottom-right-mixed">Stan na początek roku</td>
							<td style="font-size: 8pt; font-weight: bold; width: 170px; text-align: center" class="bottom-bold">Stan na koniec roku</td>
						</tr>
						<xsl:call-template name="B-Jed_daneAktywaPasywa">
							<xsl:with-param name="symbolAkt" select="'A'"/>
							<xsl:with-param name="wyszczegAkt" select="'Aktywa trwałe'"/>
							<xsl:with-param name="symbolPas" select="'A'"/>
							<xsl:with-param name="wyszczegPas" select="'Fundusz'"/>
						</xsl:call-template>
						<xsl:call-template name="B-Jed_daneAktywaPasywa">
							<xsl:with-param name="symbolAkt" select="'A.I'"/>
							<xsl:with-param name="wyszczegAkt" select="'Wartości niematerialne i prawne'"/>
							<xsl:with-param name="symbolPas" select="'A.I'"/>
							<xsl:with-param name="wyszczegPas" select="'Fundusz jednostki'"/>
						</xsl:call-template>
						<xsl:call-template name="B-Jed_daneAktywaPasywa">
							<xsl:with-param name="symbolAkt" select="'A.II'"/>
							<xsl:with-param name="wyszczegAkt" select="'Rzeczowe aktywa trwałe'"/>
							<xsl:with-param name="symbolPas" select="'A.II'"/>
							<xsl:with-param name="wyszczegPas" select="'Wynik finansowy netto (+,-)'"/>
						</xsl:call-template>
						<xsl:call-template name="B-Jed_daneAktywaPasywa">
							<xsl:with-param name="symbolAkt" select="'A.II.1'"/>
							<xsl:with-param name="wyszczegAkt" select="'Środki trwałe'"/>
							<xsl:with-param name="symbolPas" select="'A.II.1'"/>
							<xsl:with-param name="wyszczegPas" select="'Zysk netto (+)'"/>
						</xsl:call-template>
						<xsl:call-template name="B-Jed_daneAktywaPasywa">
							<xsl:with-param name="symbolAkt" select="'A.II.1.1'"/>
							<xsl:with-param name="wyszczegAkt" select="'Grunty'"/>
							<xsl:with-param name="symbolPas" select="'A.II.2'"/>
							<xsl:with-param name="wyszczegPas" select="'Strata netto (-)'"/>
						</xsl:call-template>
						<xsl:call-template name="B-Jed_daneAktywaPasywa">
							<xsl:with-param name="symbolAkt" select="'A.II.1.1.1'"/>
							<xsl:with-param name="wyszczegAkt" select="'Grunty stanowiące własność jednostki samorządu terytorialnego, przekazane w użytkowanie wieczyste innym podmiotom'"/>
							<xsl:with-param name="symbolPas" select="'A.III'"/>
							<xsl:with-param name="wyszczegPas" select="'Odpisy z wyniku finansowego (nadwyżka środków obrotowych) (-)'"/>
						</xsl:call-template>
						<xsl:call-template name="B-Jed_daneAktywaPasywa">
							<xsl:with-param name="symbolAkt" select="'A.II.1.2'"/>
							<xsl:with-param name="wyszczegAkt" select="'Budynki, lokale i obiekty inżynierii lądowej i wodnej'"/>
							<xsl:with-param name="symbolPas" select="'A.IV'"/>
							<xsl:with-param name="wyszczegPas" select="'Fundusz mienia zlikwidowanych jednostek'"/>
						</xsl:call-template>
						<xsl:call-template name="B-Jed_daneAktywaPasywa">
							<xsl:with-param name="symbolAkt" select="'A.II.1.3'"/>
							<xsl:with-param name="wyszczegAkt" select="'Urządzenia techniczne i maszyny'"/>
							<xsl:with-param name="symbolPas" select="'B'"/>
							<xsl:with-param name="wyszczegPas" select="'Fundusze placówek'"/>
						</xsl:call-template>
						<xsl:call-template name="B-Jed_daneAktywaPasywa">
							<xsl:with-param name="symbolAkt" select="'A.II.1.4'"/>
							<xsl:with-param name="wyszczegAkt" select="'Środki transportu'"/>
							<xsl:with-param name="symbolPas" select="'C'"/>
							<xsl:with-param name="wyszczegPas" select="'Państwowe fundusze celowe'"/>
						</xsl:call-template>
						<xsl:call-template name="B-Jed_daneAktywaPasywa">
							<xsl:with-param name="symbolAkt" select="'A.II.1.5'"/>
							<xsl:with-param name="wyszczegAkt" select="'Inne środki trwałe'"/>
							<xsl:with-param name="symbolPas" select="'D'"/>
							<xsl:with-param name="wyszczegPas" select="'Zobowiązania i rezerwy na zobowiązania'"/>
						</xsl:call-template>
						<xsl:call-template name="B-Jed_daneAktywaPasywa">
							<xsl:with-param name="symbolAkt" select="'A.II.2'"/>
							<xsl:with-param name="wyszczegAkt" select="'Środki trwałe w budowie (inwestycje)'"/>
							<xsl:with-param name="symbolPas" select="'D.I'"/>
							<xsl:with-param name="wyszczegPas" select="'Zobowiązania długoterminowe'"/>
						</xsl:call-template>
						<xsl:call-template name="B-Jed_daneAktywaPasywa">
							<xsl:with-param name="symbolAkt" select="'A.II.3'"/>
							<xsl:with-param name="wyszczegAkt" select="'Zaliczka na środki trwałe w budowie (inwestycje)'"/>
							<xsl:with-param name="symbolPas" select="'D.II'"/>
							<xsl:with-param name="wyszczegPas" select="'Zobowiązania krótkoterminowe'"/>
						</xsl:call-template>
						<xsl:call-template name="B-Jed_daneAktywaPasywa">
							<xsl:with-param name="symbolAkt" select="'A.III'"/>
							<xsl:with-param name="wyszczegAkt" select="'Należności długoterminowe'"/>
							<xsl:with-param name="symbolPas" select="'D.II.1'"/>
							<xsl:with-param name="wyszczegPas" select="'Zobowiązania z tytułu dostaw i usług'"/>
						</xsl:call-template>
						<xsl:call-template name="B-Jed_daneAktywaPasywa">
							<xsl:with-param name="symbolAkt" select="'A.IV'"/>
							<xsl:with-param name="wyszczegAkt" select="'Długoterminowe aktywa finansowe'"/>
							<xsl:with-param name="symbolPas" select="'D.II.2'"/>
							<xsl:with-param name="wyszczegPas" select="'Zobowiązania wobec budżetów'"/>
						</xsl:call-template>
						<xsl:call-template name="B-Jed_daneAktywaPasywa">
							<xsl:with-param name="symbolAkt" select="'A.IV.1'"/>
							<xsl:with-param name="wyszczegAkt" select="'Akcje i udziały'"/>
							<xsl:with-param name="symbolPas" select="'D.II.3'"/>
							<xsl:with-param name="wyszczegPas" select="'Zobowiązania z tytułu ubezpieczeń i innych świadczeń'"/>
						</xsl:call-template>
						<xsl:call-template name="B-Jed_daneAktywaPasywa">
							<xsl:with-param name="symbolAkt" select="'A.IV.2'"/>
							<xsl:with-param name="wyszczegAkt" select="'Inne papiery wartościowe'"/>
							<xsl:with-param name="symbolPas" select="'D.II.4'"/>
							<xsl:with-param name="wyszczegPas" select="'Zobowiązania z tytułu wynagrodzeń'"/>
						</xsl:call-template>
						<xsl:call-template name="B-Jed_daneAktywaPasywa">
							<xsl:with-param name="symbolAkt" select="'A.IV.3'"/>
							<xsl:with-param name="wyszczegAkt" select="'Inne długoterminowe aktywa finansowe'"/>
							<xsl:with-param name="symbolPas" select="'D.II.5'"/>
							<xsl:with-param name="wyszczegPas" select="'Pozostałe zobowiązania'"/>
						</xsl:call-template>
						<xsl:call-template name="B-Jed_daneAktywaPasywa">
							<xsl:with-param name="symbolAkt" select="'A.V'"/>
							<xsl:with-param name="wyszczegAkt" select="'Wartość mienia zlikwidowanych jednostek'"/>
							<xsl:with-param name="symbolPas" select="'D.II.6'"/>
							<xsl:with-param name="wyszczegPas" select="'Sumy obce (depozytowe, zabezpieczenie wykonania umów)'"/>
						</xsl:call-template>
						<xsl:call-template name="B-Jed_daneAktywaPasywa">
							<xsl:with-param name="symbolAkt" select="'B'"/>
							<xsl:with-param name="wyszczegAkt" select="'Aktywa obrotowe'"/>
							<xsl:with-param name="symbolPas" select="'D.II.7'"/>
							<xsl:with-param name="wyszczegPas" select="'Rozliczenia z tytułu środków na wydatki budżetowe i z tytułu dochodów budżetowych'"/>
						</xsl:call-template>
						<xsl:call-template name="B-Jed_daneAktywaPasywa">
							<xsl:with-param name="symbolAkt" select="'B.I'"/>
							<xsl:with-param name="wyszczegAkt" select="'Zapasy'"/>
							<xsl:with-param name="symbolPas" select="'D.II.8'"/>
							<xsl:with-param name="wyszczegPas" select="'Fundusze specjalne'"/>
						</xsl:call-template>
						<xsl:call-template name="B-Jed_daneAktywaPasywa">
							<xsl:with-param name="symbolAkt" select="'B.I.1'"/>
							<xsl:with-param name="wyszczegAkt" select="'Materiały'"/>
							<xsl:with-param name="symbolPas" select="'D.II.8.1'"/>
							<xsl:with-param name="wyszczegPas" select="'Zakładowy Fundusz Świadczeń Socjalnych'"/>
						</xsl:call-template>
						<xsl:call-template name="B-Jed_daneAktywaPasywa">
							<xsl:with-param name="symbolAkt" select="'B.I.2'"/>
							<xsl:with-param name="wyszczegAkt" select="'Półprodukty i produkty w toku'"/>
							<xsl:with-param name="symbolPas" select="'D.II.8.2'"/>
							<xsl:with-param name="wyszczegPas" select="'Inne fundusze'"/>
						</xsl:call-template>
						<xsl:call-template name="B-Jed_daneAktywaPasywa">
							<xsl:with-param name="symbolAkt" select="'B.I.3'"/>
							<xsl:with-param name="wyszczegAkt" select="'Produkty gotowe'"/>
							<xsl:with-param name="symbolPas" select="'D.III'"/>
							<xsl:with-param name="wyszczegPas" select="'Rezerwy na zobowiązaniu'"/>
						</xsl:call-template>
						<xsl:call-template name="B-Jed_daneAktywaPasywa">
							<xsl:with-param name="symbolAkt" select="'B.I.4'"/>
							<xsl:with-param name="wyszczegAkt" select="'Towary'"/>
							<xsl:with-param name="symbolPas" select="'D.IV'"/>
							<xsl:with-param name="wyszczegPas" select="'Rozliczenia międzyokresowe'"/>
						</xsl:call-template>
						<xsl:call-template name="B-Jed_daneAktywaPasywa">
							<xsl:with-param name="symbolAkt" select="'B.II'"/>
							<xsl:with-param name="wyszczegAkt" select="'Należności krótkoterminowe'"/>
						</xsl:call-template>
						<xsl:call-template name="B-Jed_daneAktywaPasywa">
							<xsl:with-param name="symbolAkt" select="'B.II.1'"/>
							<xsl:with-param name="wyszczegAkt" select="'Należności z tytułu dostaw i usług'"/>
						</xsl:call-template>
						<xsl:call-template name="B-Jed_daneAktywaPasywa">
							<xsl:with-param name="symbolAkt" select="'B.II.2'"/>
							<xsl:with-param name="wyszczegAkt" select="'Należności od budżetów'"/>
						</xsl:call-template>
						<xsl:call-template name="B-Jed_daneAktywaPasywa">
							<xsl:with-param name="symbolAkt" select="'B.II.3'"/>
							<xsl:with-param name="wyszczegAkt" select="'Należności z tytułu ubezpieczeń i innych świadczeń'"/>
						</xsl:call-template>
						<xsl:call-template name="B-Jed_daneAktywaPasywa">
							<xsl:with-param name="symbolAkt" select="'B.II.4'"/>
							<xsl:with-param name="wyszczegAkt" select="'Pozostałe należności'"/>
						</xsl:call-template>
						<xsl:call-template name="B-Jed_daneAktywaPasywa">
							<xsl:with-param name="symbolAkt" select="'B.II.5'"/>
							<xsl:with-param name="wyszczegAkt" select="'Rozliczenia z tytułu środków na wydatki budżetowe i z tytułu dochodów budżetowych'"/>
						</xsl:call-template>
						<xsl:call-template name="B-Jed_daneAktywaPasywa">
							<xsl:with-param name="symbolAkt" select="'B.III'"/>
							<xsl:with-param name="wyszczegAkt" select="'Krótkoterminowe aktywa finansowe'"/>
						</xsl:call-template>
						<xsl:call-template name="B-Jed_daneAktywaPasywa">
							<xsl:with-param name="symbolAkt" select="'B.III.1'"/>
							<xsl:with-param name="wyszczegAkt" select="'Środki pieniężne w kasie'"/>
						</xsl:call-template>
						<xsl:call-template name="B-Jed_daneAktywaPasywa">
							<xsl:with-param name="symbolAkt" select="'B.III.2'"/>
							<xsl:with-param name="wyszczegAkt" select="'Środki pieniężne na rachunkach bankowych'"/>
						</xsl:call-template>
						<xsl:call-template name="B-Jed_daneAktywaPasywa">
							<xsl:with-param name="symbolAkt" select="'B.III.3'"/>
							<xsl:with-param name="wyszczegAkt" select="'Środki pieniężne państwowego funduszu celowego'"/>
						</xsl:call-template>
						<xsl:call-template name="B-Jed_daneAktywaPasywa">
							<xsl:with-param name="symbolAkt" select="'B.III.4'"/>
							<xsl:with-param name="wyszczegAkt" select="'Inne środki pieniężne'"/>
						</xsl:call-template>
						<xsl:call-template name="B-Jed_daneAktywaPasywa">
							<xsl:with-param name="symbolAkt" select="'B.III.5'"/>
							<xsl:with-param name="wyszczegAkt" select="'Akcje lub udziały'"/>
						</xsl:call-template>
						<xsl:call-template name="B-Jed_daneAktywaPasywa">
							<xsl:with-param name="symbolAkt" select="'B.III.6'"/>
							<xsl:with-param name="wyszczegAkt" select="'Inne papiery wartościowe'"/>
						</xsl:call-template>
						<xsl:call-template name="B-Jed_daneAktywaPasywa">
							<xsl:with-param name="symbolAkt" select="'B.III.7'"/>
							<xsl:with-param name="wyszczegAkt" select="'Inne krótkoterminowe aktywa finansowe'"/>
						</xsl:call-template>
						<xsl:call-template name="B-Jed_daneAktywaPasywa">
							<xsl:with-param name="symbolAkt" select="'B.IV'"/>
							<xsl:with-param name="wyszczegAkt" select="'Rozliczenia międzyokresowe'"/>
						</xsl:call-template>
						<tr>
							<td class="bottom-right-mixed"/>
							<td class="bottom-right-mixed"/>
							<td class="bottom-right-bold"/>
							<td class="bottom-right-mixed"/>
							<td class="bottom-right-mixed"/>
							<td class="bottom-bold"/>
						</tr>
						<tr>
							<td class="right-normal" style="text-align: left; padding: 5px; font-size: 10pt; font-weight: bold">Suma aktywów</td>
							<td class="right-normal" style="text-align: right; padding: 5px; font-size: 9pt; font-weight: bold">
								<xsl:value-of select="format-number(sum(Aktywa/Pozycja[string-length(child::Symbol) = 1 and child::Symbol != ' ' and string(number(child::P)) != 'NaN']/P), '#&#160;##0,00')"/>
							</td>
							<td class="right-bold" style="text-align: right; padding: 5px; font-size: 9pt; font-weight: bold">
								<xsl:value-of select="format-number(sum(Aktywa/Pozycja[string-length(child::Symbol) = 1 and child::Symbol != ' ' and string(number(child::K)) != 'NaN']/K), '#&#160;##0,00')"/>
							</td>
							<td class="right-normal" style="text-align: left; padding: 5px; font-size: 10pt; font-weight: bold">Suma pasywów</td>
							<td class="right-normal" style="text-align: right; padding: 5px; font-size: 9pt; font-weight: bold">
								<xsl:value-of select="format-number(sum(Pasywa/Pozycja[string-length(child::Symbol) = 1 and child::Symbol != ' ' and string(number(child::P)) != 'NaN']/P), '#&#160;##0,00')"/>
							</td>
							<td style="text-align: right; padding: 5px; font-size: 9pt; font-weight: bold">
								<xsl:value-of select="format-number(sum(Pasywa/Pozycja[string-length(child::Symbol) = 1 and child::Symbol != ' ' and string(number(child::K)) != 'NaN']/K), '#&#160;##0,00')"/>
							</td>
						</tr>
					</tbody>
				</table>
				<div style="font-weight: bold; font-size: 10pt;margin-bottom: 5px">A. Objaśnienie - ukazane w bilansie wartości aktywów trwałych i obrotowych są pomniejszone odpowiednio o umorzenie i odpisy aktualizujące.</div>
				<!-- Usunięcie zgodnie ze zleceniem 45 -->
				<!-- <div style="font-weight: bold; font-size: 10pt; margin-bottom: 5px">B. Informacje uzupełniające istotne dla rzetelności i przejrzystości sytuacji finansowej i majątkowej:</div> -->
				<!-- <table cellpadding="0" cellspacing="0" class="all-bold" style="margin-bottom: 60px"> -->
				<!-- <tbody> -->
				<!-- <tr> -->
				<!-- <td style="font-size: 8pt; font-weight: bold; width: 80px; text-align: center" class="bottom-right-bold">Symbol</td> -->
				<!-- <td style="font-size: 8pt; font-weight: bold; width: 800px; text-align: center" class="bottom-right-bold">Opis</td> -->
				<!-- <td style="font-size: 8pt; font-weight: bold; width: 160px; text-align: center" class="bottom-bold">Wartość</td> -->
				<!-- </tr> -->
				<!-- <xsl:call-template name="B-Jed_UzupelnienieStale"> -->
				<!-- <xsl:with-param name="symbol" select="'1'"/> -->
				<!-- <xsl:with-param name="opis" select="'Umorzenie wartości niematerialnych i prawnych'"/> -->
				<!-- </xsl:call-template> -->
				<!-- <xsl:call-template name="B-Jed_UzupelnienieStale"> -->
				<!-- <xsl:with-param name="symbol" select="'2'"/> -->
				<!-- <xsl:with-param name="opis" select="'Umorzenie środków trwałych'"/> -->
				<!-- </xsl:call-template> -->
				<!-- <xsl:call-template name="B-Jed_UzupelnienieStale"> -->
				<!-- <xsl:with-param name="symbol" select="'3'"/> -->
				<!-- <xsl:with-param name="opis" select="'Umorzenie pozostałych środków trwałych'"/> -->
				<!-- </xsl:call-template> -->
				<!-- <xsl:call-template name="B-Jed_UzupelnienieStale"> -->
				<!-- <xsl:with-param name="symbol" select="'4'"/> -->
				<!-- <xsl:with-param name="opis" select="'Odpisy aktualizujące środki trwałe'"/> -->
				<!-- </xsl:call-template> -->
				<!-- <xsl:call-template name="B-Jed_UzupelnienieStale"> -->
				<!-- <xsl:with-param name="symbol" select="'5'"/> -->
				<!-- <xsl:with-param name="opis" select="'Odpisy aktualizujące środki trwałe w budowie'"/> -->
				<!-- </xsl:call-template> -->
				<!-- <xsl:call-template name="B-Jed_UzupelnienieStale"> -->
				<!-- <xsl:with-param name="symbol" select="'6'"/> -->
				<!-- <xsl:with-param name="opis" select="'Odpisy aktualizujące wartości niematerialne i prawne'"/> -->
				<!-- </xsl:call-template> -->
				<!-- <xsl:call-template name="B-Jed_UzupelnienieStale"> -->
				<!-- <xsl:with-param name="symbol" select="'7'"/> -->
				<!-- <xsl:with-param name="opis" select="'Odpisy aktualizujące należności'"/> -->
				<!-- </xsl:call-template> -->
				<!-- <xsl:for-each select="Uzupelnienie/Pozycja"> -->
				<!-- <xsl:sort select="Symbol"/> -->
				<!-- <xsl:choose> -->
				<!-- <xsl:when test="position() != last()"> -->
				<!-- <tr> -->
				<!-- <td class="bottom-right-normal" style="text-align: left; font-size: 8pt; padding: 3px"> -->
				<!-- <xsl:value-of select="Symbol"/> -->
				<!-- </td> -->
				<!-- <td class="bottom-right-normal" style="text-align: left; font-size: 8pt; padding: 3px"> -->
				<!-- <xsl:value-of select="Opis"/> -->
				<!-- </td> -->
				<!-- <td class="bottom-normal" style="text-align: right; font-size: 8pt; padding: 3px"> -->
				<!-- <xsl:choose> -->
				<!-- <xsl:when test="Wartosc"> -->
				<!-- <xsl:value-of select="format-number(Wartosc, '#&#160;##0,00')"/> -->
				<!-- </xsl:when> -->
				<!-- <xsl:otherwise> -->
				<!-- <xsl:value-of select="'0,00'"/> -->
				<!-- </xsl:otherwise> -->
				<!-- </xsl:choose> -->
				<!-- </td> -->
				<!-- </tr> -->
				<!-- </xsl:when> -->
				<!-- <xsl:otherwise> -->
				<!-- <tr> -->
				<!-- <td class="right-normal" style="text-align: left; font-size: 8pt; padding: 3px"> -->
				<!-- <xsl:value-of select="Symbol"/> -->
				<!-- </td> -->
				<!-- <td class="right-normal" style="text-align: left; font-size: 8pt; padding: 3px"> -->
				<!-- <xsl:value-of select="Opis"/> -->
				<!-- </td> -->
				<!-- <td class="right-normal" style="text-align: right; font-size: 8pt; padding: 3px"> -->
				<!-- <xsl:choose> -->
				<!-- <xsl:when test="Wartosc"> -->
				<!-- <xsl:value-of select="format-number(Wartosc, '#&#160;##0,00')"/> -->
				<!-- </xsl:when> -->
				<!-- <xsl:otherwise> -->
				<!-- <xsl:value-of select="'0,00'"/> -->
				<!-- </xsl:otherwise> -->
				<!-- </xsl:choose> -->
				<!-- </td> -->
				<!-- </tr> -->
				<!-- </xsl:otherwise> -->
				<!-- </xsl:choose> -->
				<!-- </xsl:for-each> -->
				<!-- </tbody> -->
				<!-- </table> -->
				<table cellpadding="0" cellspacing="0" class="all-bold" style="margin-bottom: 20px; width: 100%">
					<tbody>
						<tr style="height: 30px" valign="top">
							<td colspan="4" class="bottom-bold" style="font-size: 9pt; font-weight: bold; text-align:left; padding: 3px 10px; margin-left: 5px; margin-bottom: 25px">Wyjaśnienia do sprawozdania B-Jed</td>
						</tr>
						<tr style="min-height: 50px; height: 70px" valign="top">
							<td colspan="4" style="text-align: left; font-size: 8pt; padding: 3px 10px">
								<xsl:value-of select="Naglowek/Uwagi"/>
							</td>
						</tr>
					</tbody>
				</table>
				<!-- ewentualne uwagi z pozycji -->
				<xsl:if test="Aktywa/Pozycja[Uwagi]">
					<table cellpadding="0" cellspacing="0" class="all-bold" style="margin-bottom: 20px; width: 100%">
						<tbody>
							<tr>
								<td colspan="3" class="bottom-right-bold" style="font-size: 9pt; font-weight: bold; text-align: center">Uwagi do pozycji "Aktywa"</td>
							</tr>
							<tr>
								<td style="font-size: 8pt; font-weight: bold; width: 50px; text-align: center" class="bottom-right-bold">Symbol</td>
								<td style="font-size: 8pt; font-weight: bold; width: 220px; text-align: center" class="bottom-right-bold">Wyszczególnienie</td>
								<td style="font-size: 8pt; font-weight: bold; width: 800px; text-align: center" class="bottom-bold">Uwaga</td>
							</tr>
							<xsl:for-each select="Aktywa/Pozycja[Uwagi]">
								<xsl:sort select="Symbol"/>
								<tr>
									<xsl:choose>
										<xsl:when test="position() != last()">
											<td class="bottom-right-normal" style="text-align: center; font-size: 8pt; padding: 3px">
												<xsl:value-of select="Symbol"/>
											</td>
											<td class="bottom-right-normal" style="text-align: left; font-size: 8pt; padding: 3px">
												<xsl:call-template name="okrSymbolAkt">
													<xsl:with-param name="symbol" select="Symbol"/>
												</xsl:call-template>
											</td>
											<td class="bottom-normal" style="text-align: left; font-size: 8pt; padding: 3px">
												<xsl:value-of select="Uwagi"/>
											</td>
										</xsl:when>
										<xsl:otherwise>
											<td class="right-normal" style="text-align: center; font-size: 8pt; padding: 3px">
												<xsl:value-of select="Symbol"/>
											</td>
											<td class="right-normal" style="text-align: left; font-size: 8pt; padding: 3px">
												<xsl:call-template name="okrSymbolAkt">
													<xsl:with-param name="symbol" select="Symbol"/>
												</xsl:call-template>
											</td>
											<td class="right-normal" style="text-align: left; font-size: 8pt; padding: 3px">
												<xsl:value-of select="Uwagi"/>
											</td>
										</xsl:otherwise>
									</xsl:choose>
								</tr>
							</xsl:for-each>
						</tbody>
					</table>
				</xsl:if>
				<xsl:if test="Pasywa/Pozycja[Uwagi]">
					<table cellpadding="0" cellspacing="0" class="all-bold" style="margin-bottom: 30px; width: 100%">
						<tbody>
							<tr>
								<td colspan="3" class="bottom-right-bold" style="font-size: 9pt; font-weight: bold; text-align: center">Uwagi do pozycji "Pasywa"</td>
							</tr>
							<tr>
								<td style="font-size: 8pt; font-weight: bold; width: 50px; text-align: center" class="bottom-right-bold">Symbol</td>
								<td style="font-size: 8pt; font-weight: bold; width: 220px; text-align: center" class="bottom-right-bold">Wyszczególnienie</td>
								<td style="font-size: 8pt; font-weight: bold; width: 800px; text-align: center" class="bottom-bold">Uwaga</td>
							</tr>
							<xsl:for-each select="Pasywa/Pozycja[Uwagi]">
								<xsl:sort select="Symbol"/>
								<tr>
									<xsl:choose>
										<xsl:when test="position() != last()">
											<td class="bottom-right-normal" style="text-align: center; font-size: 8pt; padding: 3px">
												<xsl:value-of select="Symbol"/>
											</td>
											<td class="bottom-right-normal" style="text-align: left; font-size: 8pt; padding: 3px">
												<xsl:call-template name="okrSymbolPas">
													<xsl:with-param name="symbol" select="Symbol"/>
												</xsl:call-template>
											</td>
											<td class="bottom-normal" style="text-align: left; font-size: 8pt; padding: 3px">
												<xsl:value-of select="Uwagi"/>
											</td>
										</xsl:when>
										<xsl:otherwise>
											<td class="right-normal" style="text-align: center; font-size: 8pt; padding: 3px">
												<xsl:value-of select="Symbol"/>
											</td>
											<td class="right-normal" style="text-align: left; font-size: 8pt; padding: 3px">
												<xsl:call-template name="okrSymbolPas">
													<xsl:with-param name="symbol" select="Symbol"/>
												</xsl:call-template>
											</td>
											<td class="right-normal" style="text-align: left; font-size: 8pt; padding: 3px">
												<xsl:value-of select="Uwagi"/>
											</td>
										</xsl:otherwise>
									</xsl:choose>
								</tr>
							</xsl:for-each>
						</tbody>
					</table>
				</xsl:if>
				<xsl:if test="Uzupelnienie/Pozycja[child::Uwagi]">
					<table cellpadding="0" cellspacing="0" class="all-bold" style="margin-bottom: 20px; width: 100%">
						<tbody>
							<tr>
								<td colspan="4" style="text-align: center; font-size: 9pt; font-weight: bold; padding: 3px 10px">
									<div>Uwagi do części: "Informacje uzupełniające"</div>
								</td>
							</tr>
							<tr>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 4px 4px 0">Symbol</td>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 4px 4px 0">Opis</td>
								<td colspan="2" style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 0 4px 0">Uwaga</td>
							</tr>
							<xsl:for-each select="Uzupelnienie/Pozycja[child::Uwagi]">
								<xsl:sort select="Symbol"/>
								<tr>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="Symbol"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="Opis"/>
									</td>
									<td colspan="3" class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:value-of select="Uwagi"/>
									</td>
								</tr>
							</xsl:for-each>
						</tbody>
					</table>
				</xsl:if>
				<table cellpadding="0" cellspacing="0" style="margin-bottom: 0px; margin-top: 80px; width: 100%">
					<tbody>
						<tr>
							<td style="text-align:center; font-size: 8pt;" valign="bottom">
								<hr style="width: 80%"/>
								<div>główny księgowy</div>
							</td>
							<td style="text-align:center; font-size: 8pt;" valign="bottom">
								<div>
									<xsl:value-of select="Naglowek/DataSprawozdania"/>
								</div>
								<hr style="width: 80%"/>
								<div>(rok m-c dzień)</div>
							</td>
							<td style="text-align:center; font-size: 8pt;" valign="bottom">
								<hr style="width: 80%"/>
								<div>kierownik jednostki</div>
							</td>
						</tr>
					</tbody>
				</table>
			</div>
			<xsl:element name="a">
				<xsl:attribute name="href"><xsl:value-of select="concat('#Jed', $jedIndex)"/></xsl:attribute>
				<xsl:element name="style">
					<xsl:value-of select="'font-family: Verdana'"/>
				</xsl:element>
				<xsl:value-of select="'Powrót do listy sprawozdań jednostki'"/>
			</xsl:element>
		</xsl:element>
	</xsl:template>
	<!-- B-Jed szablony pomocnicze -->
	<xsl:template name="B-Jed_daneAktywaPasywa">
		<xsl:param name="symbolAkt"/>
		<xsl:param name="wyszczegAkt"/>
		<xsl:param name="symbolPas"/>
		<xsl:param name="wyszczegPas"/>
		<tr>
			<td class="bottom-right-normal" style="text-align: left; font-size: 8pt; padding: 3px">
				<div>
					<span>
						<xsl:value-of select="$symbolAkt"/>
					</span>
					<span style="margin-left: 2px">
						<xsl:value-of select="$wyszczegAkt"/>
					</span>
				</div>
			</td>
			<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; padding: 3px">
				<xsl:choose>
					<xsl:when test="Aktywa/Pozycja[child::Symbol = $symbolAkt]/P">
						<xsl:value-of select="format-number(Aktywa/Pozycja[child::Symbol = $symbolAkt]/P, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
			<td class="right-bottom-mixed" style="text-align: right; font-size: 8pt; padding: 3px">
				<xsl:choose>
					<xsl:when test="Aktywa/Pozycja[child::Symbol = $symbolAkt]/K">
						<xsl:value-of select="format-number(Aktywa/Pozycja[child::Symbol = $symbolAkt]/K, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
			<td class="bottom-right-normal" style="text-align: left; font-size: 8pt; padding: 3px">
				<div>
					<span>
						<xsl:value-of select="$symbolPas"/>
					</span>
					<span style="margin-left: 2px">
						<xsl:value-of select="$wyszczegPas"/>
					</span>
				</div>
			</td>
			<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; padding: 3px">
				<xsl:choose>
					<xsl:when test="Pasywa/Pozycja[child::Symbol = $symbolPas]/P">
						<xsl:value-of select="format-number(Pasywa/Pozycja[child::Symbol = $symbolPas]/P, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
			<td class="right-bottom-mixed" style="text-align: right; font-size: 8pt; padding: 3px">
				<xsl:choose>
					<xsl:when test="Pasywa/Pozycja[child::Symbol = $symbolPas]/K">
						<xsl:value-of select="format-number(Pasywa/Pozycja[child::Symbol = $symbolPas]/K, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
		</tr>
		<xsl:call-template name="B-Jed_daneAktywaPasywaUszczeg">
			<xsl:with-param name="symbolNadrzednyAkt" select="$symbolAkt"/>
			<xsl:with-param name="symbolNadrzednyPas" select="$symbolPas"/>
		</xsl:call-template>
	</xsl:template>
	<xsl:template name="B-Jed_daneAktywaPasywaUszczeg">
		<xsl:param name="symbolNadrzednyAkt"/>
		<xsl:param name="symbolNadrzednyPas"/>
		<xsl:for-each select="Aktywa/Pozycja[child::SymbolNadrzedny = $symbolNadrzednyAkt]">
			<xsl:sort select="Symbol"/>
			<tr>
				<td class="bottom-right-normal" style="text-align: left; font-size: 8pt; padding: 3px">
					<div>
						<span>
							<xsl:value-of select="Symbol"/>
						</span>
						<span style="margin-left: 2px">
							<xsl:value-of select="Opis"/>
						</span>
					</div>
				</td>
				<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; padding: 3px">
					<xsl:choose>
						<xsl:when test="P">
							<xsl:value-of select="format-number(P, '#&#160;##0,00')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'0,00'"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td class="right-bottom-mixed" style="text-align: right; font-size: 8pt; padding: 3px">
					<xsl:choose>
						<xsl:when test="K">
							<xsl:value-of select="format-number(K, '#&#160;##0,00')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'0,00'"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td class="bottom-right-normal" style="text-align: left; font-size: 8pt; padding: 3px">
					<div>
						<span>
            </span>
						<span style="margin-left: 2px">
            </span>
					</div>
				</td>
				<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; padding: 3px">
        </td>
				<td class="right-bottom-mixed" style="text-align: right; font-size: 8pt; padding: 3px">
        </td>
			</tr>
		</xsl:for-each>
		<xsl:for-each select="Pasywa/Pozycja[child::SymbolNadrzedny = $symbolNadrzednyPas]">
			<xsl:sort select="Symbol"/>
			<tr>
				<td class="bottom-right-normal" style="text-align: left; font-size: 8pt; padding: 3px">
					<div>
						<span>
            </span>
						<span style="margin-left: 2px">
            </span>
					</div>
				</td>
				<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; padding: 3px">
        </td>
				<td class="right-bottom-mixed" style="text-align: right; font-size: 8pt; padding: 3px">
        </td>
				<td class="bottom-right-normal" style="text-align: left; font-size: 8pt; padding: 3px">
					<div>
						<span>
							<xsl:value-of select="Symbol"/>
						</span>
						<span style="margin-left: 2px">
							<xsl:value-of select="Opis"/>
						</span>
					</div>
				</td>
				<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; padding: 3px">
					<xsl:choose>
						<xsl:when test="P">
							<xsl:value-of select="format-number(P, '#&#160;##0,00')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'0,00'"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td class="right-bottom-mixed" style="text-align: right; font-size: 8pt; padding: 3px">
					<xsl:choose>
						<xsl:when test="K">
							<xsl:value-of select="format-number(K, '#&#160;##0,00')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'0,00'"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
			</tr>
		</xsl:for-each>
	</xsl:template>
	<xsl:template name="B-Jed_UzupelnienieStale">
		<xsl:param name="symbol"/>
		<xsl:param name="opis"/>
		<tr>
			<td class="bottom-right-normal" style="text-align: left; font-size: 8pt; padding: 3px">
				<div>
					<xsl:value-of select="$symbol"/>
				</div>
			</td>
			<td class="bottom-right-normal" style="text-align: left; font-size: 8pt; padding: 3px">
				<div>
					<xsl:value-of select="$opis"/>
				</div>
			</td>
			<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; padding: 3px">
				<xsl:choose>
					<xsl:when test="UzupelnienieStale/Pozycja[child::Symbol = $symbol]/Wartosc">
						<xsl:value-of select="format-number(UzupelnienieStale/Pozycja[child::Symbol = $symbol]/Wartosc, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
		</tr>
	</xsl:template>
	<xsl:template name="okrSymbolAkt">
		<xsl:param name="symbol"/>
		<xsl:choose>
			<xsl:when test="$symbol = 'A'">
				<xsl:value-of select="'Aktywa trwałe'"/>
			</xsl:when>
			<xsl:when test="$symbol = 'A.I'">
				<xsl:value-of select="'Wartości niematerialne i prawne'"/>
			</xsl:when>
			<xsl:when test="$symbol = 'A.II'">
				<xsl:value-of select="'Rzeczowe aktywa trwałe'"/>
			</xsl:when>
			<xsl:when test="$symbol = 'A.II.1'">
				<xsl:value-of select="'Środki trwałe'"/>
			</xsl:when>
			<xsl:when test="$symbol = 'A.II.1.1'">
				<xsl:value-of select="'Grunty'"/>
			</xsl:when>
			<xsl:when test="$symbol = 'A.II.1.2'">
				<xsl:value-of select="'Budynki, lokale i obiekty inżynierii lądowej i wodnej'"/>
			</xsl:when>
			<xsl:when test="$symbol = 'A.II.1.3'">
				<xsl:value-of select="'Urządzenia techniczne i maszyny'"/>
			</xsl:when>
			<xsl:when test="$symbol = 'A.II.1.4'">
				<xsl:value-of select="'Środki transportu'"/>
			</xsl:when>
			<xsl:when test="$symbol = 'A.II.1.5'">
				<xsl:value-of select="'Inne środki trwałe'"/>
			</xsl:when>
			<xsl:when test="$symbol = 'A.II.2'">
				<xsl:value-of select="'Inwestycje rozpoczęte (środki trwałe w budowie)'"/>
			</xsl:when>
			<xsl:when test="$symbol = 'A.II.3'">
				<xsl:value-of select="'Środki przekazane na poczet inwestycji'"/>
			</xsl:when>
			<xsl:when test="$symbol = 'A.III'">
				<xsl:value-of select="'Należności długoterminowe'"/>
			</xsl:when>
			<xsl:when test="$symbol = 'A.IV'">
				<xsl:value-of select="'Długoterminowe aktywa finansowe'"/>
			</xsl:when>
			<xsl:when test="$symbol = 'A.IV.1.1'">
				<xsl:value-of select="'Akcje i udziały'"/>
			</xsl:when>
			<xsl:when test="$symbol = 'A.IV.1.2'">
				<xsl:value-of select="'Papiery wartościowe długoterminowe'"/>
			</xsl:when>
			<xsl:when test="$symbol = 'A.IV.1.3'">
				<xsl:value-of select="'Inne długoterminowe aktywa finansowe'"/>
			</xsl:when>
			<xsl:when test="$symbol = 'A.V'">
				<xsl:value-of select="'Wartość mienia zlikwidowanych jednostek'"/>
			</xsl:when>
			<xsl:when test="$symbol = 'B'">
				<xsl:value-of select="'Aktywa obrotowe'"/>
			</xsl:when>
			<xsl:when test="$symbol = 'B.I'">
				<xsl:value-of select="'Zapasy'"/>
			</xsl:when>
			<xsl:when test="$symbol = 'B.I.1.1'">
				<xsl:value-of select="'Materiały'"/>
			</xsl:when>
			<xsl:when test="$symbol = 'B.I.1.2'">
				<xsl:value-of select="'Półprodukty i produkty w toku'"/>
			</xsl:when>
			<xsl:when test="$symbol = 'B.I.1.3'">
				<xsl:value-of select="'Produkty gotowe'"/>
			</xsl:when>
			<xsl:when test="$symbol = 'B.I.1.4'">
				<xsl:value-of select="'Towary'"/>
			</xsl:when>
			<xsl:when test="$symbol = 'B.II'">
				<xsl:value-of select="'Należności krótkoterminowe'"/>
			</xsl:when>
			<xsl:when test="$symbol = 'B.II.1.1'">
				<xsl:value-of select="'Należności z tytułu dostaw i usług'"/>
			</xsl:when>
			<xsl:when test="$symbol = 'B.II.1.2'">
				<xsl:value-of select="'Należności od budżetów'"/>
			</xsl:when>
			<xsl:when test="$symbol = 'B.II.1.3'">
				<xsl:value-of select="'Należności z tytułu ubezpieczeń społecznych'"/>
			</xsl:when>
			<xsl:when test="$symbol = 'B.II.1.4'">
				<xsl:value-of select="'Pozostałe należności'"/>
			</xsl:when>
			<xsl:when test="$symbol = 'B.II.1.5'">
				<xsl:value-of select="'Rozliczenia z tytułu środków na wydatki budżetowe i z tytułu dochodów budżetowych'"/>
			</xsl:when>
			<xsl:when test="$symbol = 'B.III'">
				<xsl:value-of select="'Środki pieniężne'"/>
			</xsl:when>
			<xsl:when test="$symbol = 'B.III.1.1'">
				<xsl:value-of select="'Środki pieniężne w kasie'"/>
			</xsl:when>
			<xsl:when test="$symbol = 'B.III.1.2'">
				<xsl:value-of select="'Środki pieniężne na rachunkach bankowych'"/>
			</xsl:when>
			<xsl:when test="$symbol = 'B.III.1.3'">
				<xsl:value-of select="'Inne środki pieniężne'"/>
			</xsl:when>
			<xsl:when test="$symbol = 'B.IV'">
				<xsl:value-of select="'Krótkoterminowe papiery wartościowe'"/>
			</xsl:when>
			<xsl:when test="$symbol = 'B.V'">
				<xsl:value-of select="'Rozliczenia międzyokresowe'"/>
			</xsl:when>
			<xsl:when test="$symbol = 'C'">
				<xsl:value-of select="'Inne aktywa'"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="''"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="okrSymbolPas">
		<xsl:param name="symbol"/>
		<xsl:choose>
			<xsl:when test="$symbol = 'A'">
				<xsl:value-of select="'Fundusz'"/>
			</xsl:when>
			<xsl:when test="$symbol = 'A.I'">
				<xsl:value-of select="'Fundusz jednostki'"/>
			</xsl:when>
			<xsl:when test="$symbol = 'A.II'">
				<xsl:value-of select="'Wynik finansowy netto'"/>
			</xsl:when>
			<xsl:when test="$symbol = 'A.II.1.1'">
				<xsl:value-of select="'Zysk netto (+)'"/>
			</xsl:when>
			<xsl:when test="$symbol = 'A.II.1.2'">
				<xsl:value-of select="'Strata netto (-)'"/>
			</xsl:when>
			<xsl:when test="$symbol = 'A.III'">
				<xsl:value-of select="'Nadwyżka środków obrotowych (-)'"/>
			</xsl:when>
			<xsl:when test="$symbol = 'A.IV'">
				<xsl:value-of select="'Odpisy z wyniku finansowego (-)'"/>
			</xsl:when>
			<xsl:when test="$symbol = 'A.V'">
				<xsl:value-of select="'Fundusz mienia zlikwidowanych jednostek'"/>
			</xsl:when>
			<xsl:when test="$symbol = 'A.VI'">
				<xsl:value-of select="'Inne'"/>
			</xsl:when>
			<xsl:when test="$symbol = 'B'">
				<xsl:value-of select="'Fundusze celowe'"/>
			</xsl:when>
			<xsl:when test="$symbol = 'B.1.1'">
				<xsl:value-of select="'Terenowy Fundusz Ochrony Gruntów Rolnych'"/>
			</xsl:when>
			<xsl:when test="$symbol = 'B.1.2'">
				<xsl:value-of select="'Wojewódzki Fundusz Gospodarki Zasobem Geodezyjnym i Kartograficznym'"/>
			</xsl:when>
			<xsl:when test="$symbol = 'B.1.3'">
				<xsl:value-of select="'Fundusz Socjalny Wsi'"/>
			</xsl:when>
			<xsl:when test="$symbol = 'B.1.4'">
				<xsl:value-of select="'Powiatowy Fundusz Gospodarki Zasobem Geodezyjnym i Kartograficznym'"/>
			</xsl:when>
			<xsl:when test="$symbol = 'B.1.5'">
				<xsl:value-of select="'Gminny Fundusz Gospodarki Zasobem Geodezyjnym i Kartograficznym'"/>
			</xsl:when>
			<xsl:when test="$symbol = 'B.1.6'">
				<xsl:value-of select="'Powiatowy Fundusz Ochrony Środowiska i Gospodarki Wodnej'"/>
			</xsl:when>
			<xsl:when test="$symbol = 'B.1.7'">
				<xsl:value-of select="'Gminny Fundusz Ochrony Środowiska i Gospodarki Wodnej'"/>
			</xsl:when>
			<xsl:when test="$symbol = 'C'">
				<xsl:value-of select="'Zobowiązania długoterminowe'"/>
			</xsl:when>
			<xsl:when test="$symbol = 'D'">
				<xsl:value-of select="'Zobowiązania krótkoterminowe i fundusze specjalne'"/>
			</xsl:when>
			<xsl:when test="$symbol = 'D.I'">
				<xsl:value-of select="'Zobowiązania krótkoterminowe'"/>
			</xsl:when>
			<xsl:when test="$symbol = 'D.I.1.1'">
				<xsl:value-of select="'Zobowiązania z tytułu dostaw i usług'"/>
			</xsl:when>
			<xsl:when test="$symbol = 'D.I.1.2'">
				<xsl:value-of select="'Zobowiązania według budżetów'"/>
			</xsl:when>
			<xsl:when test="$symbol = 'D.I.1.3'">
				<xsl:value-of select="'Zobowiązania z tytułu ubezpieczeń społecznych'"/>
			</xsl:when>
			<xsl:when test="$symbol = 'D.I.1.4'">
				<xsl:value-of select="'Zobowiązania z tytułu wynagrodzeń'"/>
			</xsl:when>
			<xsl:when test="$symbol = 'D.I.1.5'">
				<xsl:value-of select="'Pozostałe zobowiązania'"/>
			</xsl:when>
			<xsl:when test="$symbol = 'D.I.1.6'">
				<xsl:value-of select="'Sumy obce (depozytowe, zabezpieczenie wykonania umów)'"/>
			</xsl:when>
			<xsl:when test="$symbol = 'D.I.1.7'">
				<xsl:value-of select="'Rozliczenia z tytułu środków na wydatki budżetowe i z tytułu dochodów budżetowych'"/>
			</xsl:when>
			<xsl:when test="$symbol = 'D.I.1.8'">
				<xsl:value-of select="'Rezerwy na zobowiązania'"/>
			</xsl:when>
			<xsl:when test="$symbol = 'D.II'">
				<xsl:value-of select="'Fundusze specjalne'"/>
			</xsl:when>
			<xsl:when test="$symbol = 'D.II.1.1'">
				<xsl:value-of select="'Zakładowy fundusz świadczeń socjalnych'"/>
			</xsl:when>
			<xsl:when test="$symbol = 'D.II.1.2'">
				<xsl:value-of select="'Inne fundusze'"/>
			</xsl:when>
			<xsl:when test="$symbol = 'E'">
				<xsl:value-of select="'Rozliczenia międzyokresowe'"/>
			</xsl:when>
			<xsl:when test="$symbol = 'E.I'">
				<xsl:value-of select="'Rozliczenia międzyokresowe przychodów'"/>
			</xsl:when>
			<xsl:when test="$symbol = 'E.II'">
				<xsl:value-of select="'Inne rozliczenia międzyokresowe'"/>
			</xsl:when>
			<xsl:when test="$symbol = 'F'">
				<xsl:value-of select="'Inne pasywa'"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="''"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="Rb-ZN_daneTabelaB">
		<xsl:param name="symbol"/>
		<xsl:param name="ostWiersz" select="false()"/>
		<xsl:choose>
			<xsl:when test="$ostWiersz = false()">
				<td class="right-bottom-mixed" style="text-align:right;font-size: 8pt; padding: 3px">
					<xsl:choose>
						<xsl:when test="Naleznosci/Pozycja[child::Symbol = $symbol][1]/N">
							<xsl:value-of select="format-number(Naleznosci/Pozycja[child::Symbol = $symbol][1]/N, '#&#160;##0,00')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'0,00'"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td class="bottom-right-normal" style="text-align:right;font-size: 8pt; padding: 3px">
					<xsl:choose>
						<xsl:when test="Naleznosci/Pozycja[child::Symbol = $symbol][1]/KO">
							<xsl:value-of select="format-number(Naleznosci/Pozycja[child::Symbol = $symbol][1]/KO, '#&#160;##0,00')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'0,00'"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td class="bottom-right-normal" style="text-align:right;font-size: 8pt; padding: 3px">
					<xsl:choose>
						<xsl:when test="Naleznosci/Pozycja[child::Symbol = $symbol][1]/KFP">
							<xsl:value-of select="format-number(Naleznosci/Pozycja[child::Symbol = $symbol][1]/KFP, '#&#160;##0,00')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'0,00'"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td class="bottom-right-normal" style="text-align:right;font-size: 8pt; padding: 3px">
					<xsl:choose>
						<xsl:when test="Naleznosci/Pozycja[child::Symbol = $symbol][1]/KG1">
							<xsl:value-of select="format-number(Naleznosci/Pozycja[child::Symbol = $symbol][1]/KG1, '#&#160;##0,00')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'0,00'"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td class="bottom-right-normal" style="text-align:right;font-size: 8pt; padding: 3px">
					<xsl:choose>
						<xsl:when test="Naleznosci/Pozycja[child::Symbol = $symbol][1]/KG2">
							<xsl:value-of select="format-number(Naleznosci/Pozycja[child::Symbol = $symbol][1]/KG2, '#&#160;##0,00')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'0,00'"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td class="bottom-right-normal" style="text-align:right;font-size: 8pt; padding: 3px">
					<xsl:choose>
						<xsl:when test="Naleznosci/Pozycja[child::Symbol = $symbol][1]/KG3">
							<xsl:value-of select="format-number(Naleznosci/Pozycja[child::Symbol = $symbol][1]/KG3, '#&#160;##0,00')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'0,00'"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td class="bottom-right-normal" style="text-align:right;font-size: 8pt; padding: 3px">
					<xsl:choose>
						<xsl:when test="Naleznosci/Pozycja[child::Symbol = $symbol][1]/KG4">
							<xsl:value-of select="format-number(Naleznosci/Pozycja[child::Symbol = $symbol][1]/KG4, '#&#160;##0,00')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'0,00'"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td class="bottom-right-normal" style="text-align:right;font-size: 8pt; padding: 3px">
					<xsl:choose>
						<xsl:when test="Naleznosci/Pozycja[child::Symbol = $symbol][1]/KBC">
							<xsl:value-of select="format-number(Naleznosci/Pozycja[child::Symbol = $symbol][1]/KBC, '#&#160;##0,00')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'0,00'"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td class="bottom-right-normal" style="text-align:right;font-size: 8pt; padding: 3px">
					<xsl:choose>
						<xsl:when test="Naleznosci/Pozycja[child::Symbol = $symbol][1]/KBK">
							<xsl:value-of select="format-number(Naleznosci/Pozycja[child::Symbol = $symbol][1]/KBK, '#&#160;##0,00')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'0,00'"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td class="bottom-right-normal" style="text-align:right;font-size: 8pt; padding: 3px">
					<xsl:choose>
						<xsl:when test="Naleznosci/Pozycja[child::Symbol = $symbol][1]/KIF">
							<xsl:value-of select="format-number(Naleznosci/Pozycja[child::Symbol = $symbol][1]/KIF, '#&#160;##0,00')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'0,00'"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td class="bottom-right-normal" style="text-align:right;font-size: 8pt; padding: 3px">
					<xsl:choose>
						<xsl:when test="Naleznosci/Pozycja[child::Symbol = $symbol][1]/KPN">
							<xsl:value-of select="format-number(Naleznosci/Pozycja[child::Symbol = $symbol][1]/KPN, '#&#160;##0,00')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'0,00'"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td class="bottom-right-normal" style="text-align:right;font-size: 8pt; padding: 3px">
					<xsl:choose>
						<xsl:when test="Naleznosci/Pozycja[child::Symbol = $symbol][1]/KGD">
							<xsl:value-of select="format-number(Naleznosci/Pozycja[child::Symbol = $symbol][1]/KGD, '#&#160;##0,00')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'0,00'"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td class="right-bottom-mixed" style="text-align:right;font-size: 8pt; padding: 3px">
					<xsl:choose>
						<xsl:when test="Naleznosci/Pozycja[child::Symbol = $symbol][1]/KIN">
							<xsl:value-of select="format-number(Naleznosci/Pozycja[child::Symbol = $symbol][1]/KIN, '#&#160;##0,00')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'0,00'"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td class="bottom-right-normal" style="text-align:right;font-size: 8pt; padding: 3px">
					<xsl:choose>
						<xsl:when test="Naleznosci/Pozycja[child::Symbol = $symbol][1]/ZO">
							<xsl:value-of select="format-number(Naleznosci/Pozycja[child::Symbol = $symbol][1]/ZO, '#&#160;##0,00')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'0,00'"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td class="bottom-right-normal" style="text-align:right;font-size: 8pt; padding: 3px">
					<xsl:choose>
						<xsl:when test="Naleznosci/Pozycja[child::Symbol = $symbol][1]/ZSE">
							<xsl:value-of select="format-number(Naleznosci/Pozycja[child::Symbol = $symbol][1]/ZSE, '#&#160;##0,00')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'0,00'"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td class="right-bottom-mixed" style="text-align:right;font-size: 8pt; padding: 3px">
					<xsl:choose>
						<xsl:when test="Naleznosci/Pozycja[child::Symbol = $symbol][1]/ZPZ">
							<xsl:value-of select="format-number(Naleznosci/Pozycja[child::Symbol = $symbol][1]/ZPZ, '#&#160;##0,00')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'0,00'"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
			</xsl:when>
			<xsl:otherwise>
				<td class="bottom-right-bold" style="text-align:right;font-size: 8pt; padding: 3px">
					<xsl:choose>
						<xsl:when test="Naleznosci/Pozycja[child::Symbol = $symbol][1]/N">
							<xsl:value-of select="format-number(Naleznosci/Pozycja[child::Symbol = $symbol][1]/N, '#&#160;##0,00')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'0,00'"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td class="bottom-right-mixed" style="text-align:right;font-size: 8pt; padding: 3px">
					<xsl:choose>
						<xsl:when test="Naleznosci/Pozycja[child::Symbol = $symbol][1]/KO">
							<xsl:value-of select="format-number(Naleznosci/Pozycja[child::Symbol = $symbol][1]/KO, '#&#160;##0,00')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'0,00'"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td class="bottom-right-mixed" style="text-align:right;font-size: 8pt; padding: 3px">
					<xsl:choose>
						<xsl:when test="Naleznosci/Pozycja[child::Symbol = $symbol][1]/KFP">
							<xsl:value-of select="format-number(Naleznosci/Pozycja[child::Symbol = $symbol][1]/KFP, '#&#160;##0,00')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'0,00'"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td class="bottom-right-mixed" style="text-align:right;font-size: 8pt; padding: 3px">
					<xsl:choose>
						<xsl:when test="Naleznosci/Pozycja[child::Symbol = $symbol][1]/KG1">
							<xsl:value-of select="format-number(Naleznosci/Pozycja[child::Symbol = $symbol][1]/KG1, '#&#160;##0,00')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'0,00'"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td class="bottom-right-mixed" style="text-align:right;font-size: 8pt; padding: 3px">
					<xsl:choose>
						<xsl:when test="Naleznosci/Pozycja[child::Symbol = $symbol][1]/KG2">
							<xsl:value-of select="format-number(Naleznosci/Pozycja[child::Symbol = $symbol][1]/KG2, '#&#160;##0,00')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'0,00'"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td class="bottom-right-mixed" style="text-align:right;font-size: 8pt; padding: 3px">
					<xsl:choose>
						<xsl:when test="Naleznosci/Pozycja[child::Symbol = $symbol][1]/KG3">
							<xsl:value-of select="format-number(Naleznosci/Pozycja[child::Symbol = $symbol][1]/KG3, '#&#160;##0,00')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'0,00'"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td class="bottom-right-mixed" style="text-align:right;font-size: 8pt; padding: 3px">
					<xsl:choose>
						<xsl:when test="Naleznosci/Pozycja[child::Symbol = $symbol][1]/KG4">
							<xsl:value-of select="format-number(Naleznosci/Pozycja[child::Symbol = $symbol][1]/KG4, '#&#160;##0,00')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'0,00'"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td class="bottom-right-mixed" style="text-align:right;font-size: 8pt; padding: 3px">
					<xsl:choose>
						<xsl:when test="Naleznosci/Pozycja[child::Symbol = $symbol][1]/KBC">
							<xsl:value-of select="format-number(Naleznosci/Pozycja[child::Symbol = $symbol][1]/KBC, '#&#160;##0,00')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'0,00'"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td class="bottom-right-mixed" style="text-align:right;font-size: 8pt; padding: 3px">
					<xsl:choose>
						<xsl:when test="Naleznosci/Pozycja[child::Symbol = $symbol][1]/KBK">
							<xsl:value-of select="format-number(Naleznosci/Pozycja[child::Symbol = $symbol][1]/KBK, '#&#160;##0,00')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'0,00'"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td class="bottom-right-mixed" style="text-align:right;font-size: 8pt; padding: 3px">
					<xsl:choose>
						<xsl:when test="Naleznosci/Pozycja[child::Symbol = $symbol][1]/KIF">
							<xsl:value-of select="format-number(Naleznosci/Pozycja[child::Symbol = $symbol][1]/KIF, '#&#160;##0,00')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'0,00'"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td class="bottom-right-mixed" style="text-align:right;font-size: 8pt; padding: 3px">
					<xsl:choose>
						<xsl:when test="Naleznosci/Pozycja[child::Symbol = $symbol][1]/KPN">
							<xsl:value-of select="format-number(Naleznosci/Pozycja[child::Symbol = $symbol][1]/KPN, '#&#160;##0,00')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'0,00'"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td class="bottom-right-mixed" style="text-align:right;font-size: 8pt; padding: 3px">
					<xsl:choose>
						<xsl:when test="Naleznosci/Pozycja[child::Symbol = $symbol][1]/KGD">
							<xsl:value-of select="format-number(Naleznosci/Pozycja[child::Symbol = $symbol][1]/KGD, '#&#160;##0,00')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'0,00'"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td class="bottom-right-bold" style="text-align:right;font-size: 8pt; padding: 3px">
					<xsl:choose>
						<xsl:when test="Naleznosci/Pozycja[child::Symbol = $symbol][1]/KIN">
							<xsl:value-of select="format-number(Naleznosci/Pozycja[child::Symbol = $symbol][1]/KIN, '#&#160;##0,00')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'0,00'"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td class="bottom-right-mixed" style="text-align:right;font-size: 8pt; padding: 3px">
					<xsl:choose>
						<xsl:when test="Naleznosci/Pozycja[child::Symbol = $symbol][1]/ZO">
							<xsl:value-of select="format-number(Naleznosci/Pozycja[child::Symbol = $symbol][1]/ZO, '#&#160;##0,00')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'0,00'"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td class="bottom-right-mixed" style="text-align:right;font-size: 8pt; padding: 3px">
					<xsl:choose>
						<xsl:when test="Naleznosci/Pozycja[child::Symbol = $symbol][1]/ZSE">
							<xsl:value-of select="format-number(Naleznosci/Pozycja[child::Symbol = $symbol][1]/ZSE, '#&#160;##0,00')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'0,00'"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td class="bottom-right-bold" style="text-align:right;font-size: 8pt; padding: 3px">
					<xsl:choose>
						<xsl:when test="Naleznosci/Pozycja[child::Symbol = $symbol][1]/ZPZ">
							<xsl:value-of select="format-number(Naleznosci/Pozycja[child::Symbol = $symbol][1]/ZPZ, '#&#160;##0,00')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'0,00'"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!-- <xsl:template name="ostDzienMies">
		<xsl:param name="month"/>
		<xsl:param name="year"/>
		<xsl:value-of select="substring(string(date(concat($year, '-', $month, '-01')) + xdt:yearMonthDuration('P1M') - xdt:dayTimeDuration('P1D')), 9, 2)"/>
	</xsl:template>
	<xsl:template name="okrMies">
		<xsl:param name="nrOkr"/>
		<xsl:param name="typOkr"/>
		<xsl:choose>
			<xsl:when test="$typOkr = 'Miesiac'">
				<xsl:value-of select="$nrOkr"/>
			</xsl:when>
			<xsl:when test="$typOkr = 'Kwartal'">
				<xsl:value-of select="$nrOkr*3"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="12"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template> -->
	<!-- F-Rzs -->
	<xsl:template match="F-Rzs">
		<xsl:param name="jedIndex"/>
		<xsl:param name="sprIndex"/>
		<!-- <xsl:variable name="okrMies">
			<xsl:call-template name="okrMies">
				<xsl:with-param name="nrOkr" select="../../../../Okres/Okres"/>
				<xsl:with-param name="typOkr" select="../../../../Okres/TypOkresu"/>
			</xsl:call-template>
		</xsl:variable> -->
		<xsl:element name="div">
			<xsl:attribute name="Id"><xsl:value-of select="concat('Jed', $jedIndex, 'Wer', $sprIndex)"/></xsl:attribute>
			<xsl:attribute name="style"><xsl:value-of select="'display: block; margin-bottom: 40px'"/></xsl:attribute>
			<div style="font-size: 12pt; font-weight: bold; margin-left: 5px; margin-bottom: 10px">
        Sprawozdanie F-Rzs:
        <xsl:choose>
					<xsl:when test="Naglowek/Wersja = 0">
						<xsl:value-of select="'wersja pierwotna'"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="concat('korekta nr ', Naglowek/Wersja)"/>
					</xsl:otherwise>
				</xsl:choose>
				<xsl:call-template name="SprNaglowekInfo"/>
			</div>
			<table cellpadding="0" cellspacing="0" class="all-bold" style="margin-bottom: 20px">
				<thead>
					<tr>
						<th style="width:333px"/>
						<th style="width: 56px"/>
						<th style="width: 365px"/>
						<th style="width: 37px"/>
						<th style="width: 265px"/>
					</tr>
				</thead>
				<tbody>
					<tr style="height: 127px">
						<td class="bottom-bold" style="width:333px">
							<table cellpadding="0" cellspacing="0" style="border-collapse: collapse; height" width="100%">
								<tbody>
									<tr style="height: 80px">
										<td style="text-align: left; font-size: 9pt; margin:1px 1px 0 0; padding:0" valign="top">
                      Nazwa i adres jednostki sprawozdawczej
                    </td>
									</tr>
									<tr>
										<td class="bottom-normal" style="text-align: center; font-size: 9pt" valign="bottom">
											<!-- popr. nr I.8 -->
											<div style="display: block;margin: 0 20px">
												<xsl:choose>
													<xsl:when test="Jednostka/Nazwa">
														<xsl:value-of select="Jednostka/Nazwa"/>
													</xsl:when>
													<xsl:otherwise>
														<xsl:value-of select="../../Nazwa"/>
													</xsl:otherwise>
												</xsl:choose>
												<!--<xsl:value-of select="../../Nazwa"/>-->
											</div>
										</td>
									</tr>
									<tr style="height: 23px">
										<td style="text-align: left; font-size: 9pt; margin:1px 1px 0 0; padding:0;" valign="top">
                      Numer identyfikacyjny REGON
                    </td>
									</tr>
									<tr>
										<td style="text-align: center; font-size: 9pt; font-weight: bold; margin:1px 1px 0 0; padding:0" valign="baseline">
											<xsl:choose>
												<xsl:when test="Jednostka/Regon">
													<xsl:value-of select="Jednostka/Regon"/>
												</xsl:when>
												<xsl:otherwise>
													<xsl:value-of select="../../Regon"/>
												</xsl:otherwise>
											</xsl:choose>
											<!--<xsl:value-of select="../../Regon"/>-->
										</td>
									</tr>
								</tbody>
							</table>
						</td>
						<td colspan="3" class="notop-bold" valign="top" style="width: 458px">
							<div style="font-weight: bold; text-align: center; font-size: 11pt">Rachunek zysków i strat</div>
							<div style="font-weight: bold; text-align: center; font-size: 11pt; margin-bottom: 5px">(wariant porównawczy)</div>
							<!-- <div style="font-weight: bold; text-align: center; font-size: 11pt">Sprawozdanie łączne</div> -->
							<div style="font-weight: bold; text-align: center; font-size: 11pt; margin-bottom: 5px">
								<xsl:choose>
									<xsl:when test="Naglowek/BilansLacznyDla = 'JB'">
										<xsl:value-of select="'jednostki budżetowej'"/>
									</xsl:when>
									<xsl:when test="Naglowek/BilansLacznyDla = 'ZB'">
										<xsl:value-of select="'zakładu budżetowego'"/>
									</xsl:when>
									<xsl:when test="Naglowek/BilansLacznyDla = 'GP'">
										<xsl:value-of select="'gospodarstwa pomocniczego'"/>
									</xsl:when>
									<xsl:otherwise>
                  </xsl:otherwise>
								</xsl:choose>
							</div>
							<div style="vertical-align: bottom; text-align: center; font-size: 9pt; font-weight: bold; margin-top: 60px">
								<xsl:value-of select="'sporządzony na dzień'"/>
							</div>
							<div style="vertical-align: bottom; text-align: center; font-weight: bold; font-size: 9pt; margin-top: 5px">
								<xsl:value-of select="concat('31-12-', ../../../../Okres/Rok)"/>
								<!-- <xsl:call-template name="ostDzienMies">
									<xsl:with-param name="month" select="$okrMies"/>
									<xsl:with-param name="year" select="../../../../Okres/Rok"/>
								</xsl:call-template>
								<xsl:value-of select="'-'"/>
								<xsl:value-of select="$okrMies"/>
								<xsl:value-of select="'-'"/>
								<xsl:value-of select="../../../../Okres/Rok"/> -->
							</div>
						</td>
						<td class="bottom-bold" style="text-align: left; font-size: 9pt; margin:2px 2px 0 0; padding:0; width: 265px" valign="top">
							<table cellpadding="0" cellspacing="0" style="border-collapse: collapse; height" width="100%">
								<tbody>
									<tr style="height: 80px">
										<td class="bottom-normal" style="text-align: left; font-size: 9pt; margin:2px 2px 0 0; padding:0" valign="top">
											<div style="margin-bottom:5px">Adresat:</div>
											<!-- popr. nr I.9 -->
											<div style="text-align:center; margin-bottom: 15px;">
												<!-- <xsl:value-of select="'Regionalna Izba Obrachunkowa w Katowicach'"/> -->
											</div>
										</td>
									</tr>
									<tr style="height: 23px">
										<td style="text-align: left; font-size: 9pt; margin:2px 2px 0 0; padding:0;" valign="top">
											<div style="margin-bottom:5px">Wysłać bez pisma przewodniego</div>
											<div style="text-align:center;">
												<!-- <xsl:value-of select="'wersja robocza'"/> -->
											</div>
										</td>
									</tr>
								</tbody>
							</table>
						</td>
					</tr>
					<tr style="height: 20px">
						<td class="bottom-right-bold"/>
						<td colspan="3" class="bottom-right-bold"/>
						<td class="bottom-right-bold"/>
					</tr>
				</tbody>
			</table>
			<div style="display: block; margin-bottom: 60px">
				<table cellpadding="0" cellspacing="0" class="all-bold" style="margin-bottom: 60px">
					<tbody>
						<tr>
							<td style="font-size: 8pt; font-weight: bold; width: 700px; text-align: center" class="bottom-right-mixed"/>
							<td style="font-size: 8pt; font-weight: bold; width: 160px; text-align: center" class="bottom-right-mixed">Stan na koniec roku poprzedniego</td>
							<td style="font-size: 8pt; font-weight: bold; width: 160px; text-align: center" class="bottom-bold">Stan na koniec roku bieżącego</td>
						</tr>
						<xsl:call-template name="F-Rzs_danePozycje">
							<xsl:with-param name="symbol" select="'A'"/>
							<xsl:with-param name="wyszczeg" select="'Przychody netto z podstawowej działalności operacyjnej'"/>
						</xsl:call-template>
						<xsl:call-template name="F-Rzs_danePozycje">
							<xsl:with-param name="symbol" select="'A.I'"/>
							<xsl:with-param name="wyszczeg" select="'Przychody netto ze sprzedaży produktów'"/>
						</xsl:call-template>
						<xsl:call-template name="F-Rzs_danePozycje">
							<xsl:with-param name="symbol" select="'A.II'"/>
							<xsl:with-param name="wyszczeg" select="'Zmiana stanu produktów (zwiększenie - wartość dodatnia, zmniejszenie - wartość ujemna)'"/>
						</xsl:call-template>
						<xsl:call-template name="F-Rzs_danePozycje">
							<xsl:with-param name="symbol" select="'A.III'"/>
							<xsl:with-param name="wyszczeg" select="'Koszt wytworzenia produktów na własne potrzeby jednostki'"/>
						</xsl:call-template>
						<xsl:call-template name="F-Rzs_danePozycje">
							<xsl:with-param name="symbol" select="'A.IV'"/>
							<xsl:with-param name="wyszczeg" select="'Przychody netto ze sprzedaży towarów i materiałów'"/>
						</xsl:call-template>
						<xsl:call-template name="F-Rzs_danePozycje">
							<xsl:with-param name="symbol" select="'A.V'"/>
							<xsl:with-param name="wyszczeg" select="'Dotacje na finansowanie działalności podstawowej'"/>
						</xsl:call-template>
						<xsl:call-template name="F-Rzs_danePozycje">
							<xsl:with-param name="symbol" select="'A.VI'"/>
							<xsl:with-param name="wyszczeg" select="'Przychody z tytułu dochodów budżetowych'"/>
						</xsl:call-template>
						<xsl:call-template name="F-Rzs_danePozycje">
							<xsl:with-param name="symbol" select="'B'"/>
							<xsl:with-param name="wyszczeg" select="'Koszty działalności operacyjnej'"/>
						</xsl:call-template>
						<xsl:call-template name="F-Rzs_danePozycje">
							<xsl:with-param name="symbol" select="'B.I'"/>
							<xsl:with-param name="wyszczeg" select="'Amortyzacja'"/>
						</xsl:call-template>
						<xsl:call-template name="F-Rzs_danePozycje">
							<xsl:with-param name="symbol" select="'B.II'"/>
							<xsl:with-param name="wyszczeg" select="'Zużycie materiałów i energii'"/>
						</xsl:call-template>
						<xsl:call-template name="F-Rzs_danePozycje">
							<xsl:with-param name="symbol" select="'B.III'"/>
							<xsl:with-param name="wyszczeg" select="'Usługi obce'"/>
						</xsl:call-template>
						<xsl:call-template name="F-Rzs_danePozycje">
							<xsl:with-param name="symbol" select="'B.IV'"/>
							<xsl:with-param name="wyszczeg" select="'Podatki i opłaty'"/>
						</xsl:call-template>
						<xsl:call-template name="F-Rzs_danePozycje">
							<xsl:with-param name="symbol" select="'B.V'"/>
							<xsl:with-param name="wyszczeg" select="'Wynagrodzenia'"/>
						</xsl:call-template>
						<xsl:call-template name="F-Rzs_danePozycje">
							<xsl:with-param name="symbol" select="'B.VI'"/>
							<xsl:with-param name="wyszczeg" select="'Ubezpieczenia społeczne i inne świadczenia dla pracowników'"/>
						</xsl:call-template>
						<xsl:call-template name="F-Rzs_danePozycje">
							<xsl:with-param name="symbol" select="'B.VII'"/>
							<xsl:with-param name="wyszczeg" select="'Pozostałe koszty rodzajowe'"/>
						</xsl:call-template>
						<xsl:call-template name="F-Rzs_danePozycje">
							<xsl:with-param name="symbol" select="'B.VIII'"/>
							<xsl:with-param name="wyszczeg" select="'Wartość sprzedanych towarów i materiałów'"/>
						</xsl:call-template>
						<xsl:call-template name="F-Rzs_danePozycje">
							<xsl:with-param name="symbol" select="'B.IX'"/>
							<xsl:with-param name="wyszczeg" select="'Inne świadczenia finansowane z budżetu'"/>
						</xsl:call-template>
						<xsl:call-template name="F-Rzs_danePozycje">
							<xsl:with-param name="symbol" select="'B.X'"/>
							<xsl:with-param name="wyszczeg" select="'Pozostałe obciążenia'"/>
						</xsl:call-template>
						<xsl:call-template name="F-Rzs_danePozycje">
							<xsl:with-param name="symbol" select="'C'"/>
							<xsl:with-param name="wyszczeg" select="'Zysk (strata) z działalności podstawowej (A - B)'"/>
						</xsl:call-template>
						<xsl:call-template name="F-Rzs_danePozycje">
							<xsl:with-param name="symbol" select="'D'"/>
							<xsl:with-param name="wyszczeg" select="'Pozostałe przychody operacyjne'"/>
						</xsl:call-template>
						<xsl:call-template name="F-Rzs_danePozycje">
							<xsl:with-param name="symbol" select="'D.I'"/>
							<xsl:with-param name="wyszczeg" select="'Zysk ze zbycia niefinansowanych aktywów trwałych'"/>
						</xsl:call-template>
						<xsl:call-template name="F-Rzs_danePozycje">
							<xsl:with-param name="symbol" select="'D.II'"/>
							<xsl:with-param name="wyszczeg" select="'Dotacje'"/>
						</xsl:call-template>
						<xsl:call-template name="F-Rzs_danePozycje">
							<xsl:with-param name="symbol" select="'D.III'"/>
							<xsl:with-param name="wyszczeg" select="'Inne przychody operacyjne'"/>
						</xsl:call-template>
						<xsl:call-template name="F-Rzs_danePozycje">
							<xsl:with-param name="symbol" select="'E'"/>
							<xsl:with-param name="wyszczeg" select="'Pozostałe koszty operacyjne'"/>
						</xsl:call-template>
						<xsl:call-template name="F-Rzs_danePozycje">
							<xsl:with-param name="symbol" select="'E.I'"/>
							<xsl:with-param name="wyszczeg" select="'Koszty inwestycji finansowanych ze środków własnych samorządowych zakładów budżetowych i dochodów jednostek budżetowych gromadzonych na wydzielonym rachunku'"/>
						</xsl:call-template>
						<xsl:call-template name="F-Rzs_danePozycje">
							<xsl:with-param name="symbol" select="'E.II'"/>
							<xsl:with-param name="wyszczeg" select="'Pozostałe koszty operacyjne'"/>
						</xsl:call-template>
						<xsl:call-template name="F-Rzs_danePozycje">
							<xsl:with-param name="symbol" select="'F'"/>
							<xsl:with-param name="wyszczeg" select="'Zysk (strata) z działalności operacyjnej (C + D - E)'"/>
						</xsl:call-template>
						<xsl:call-template name="F-Rzs_danePozycje">
							<xsl:with-param name="symbol" select="'G'"/>
							<xsl:with-param name="wyszczeg" select="'Przychody finansowe'"/>
						</xsl:call-template>
						<xsl:call-template name="F-Rzs_danePozycje">
							<xsl:with-param name="symbol" select="'G.I'"/>
							<xsl:with-param name="wyszczeg" select="'Dywidendy i udziały w zyskach'"/>
						</xsl:call-template>
						<xsl:call-template name="F-Rzs_danePozycje">
							<xsl:with-param name="symbol" select="'G.II'"/>
							<xsl:with-param name="wyszczeg" select="'Odsetki'"/>
						</xsl:call-template>
						<xsl:call-template name="F-Rzs_danePozycje">
							<xsl:with-param name="symbol" select="'G.III'"/>
							<xsl:with-param name="wyszczeg" select="'Inne'"/>
						</xsl:call-template>
						<xsl:call-template name="F-Rzs_danePozycje">
							<xsl:with-param name="symbol" select="'H'"/>
							<xsl:with-param name="wyszczeg" select="'Koszty finansowe'"/>
						</xsl:call-template>
						<xsl:call-template name="F-Rzs_danePozycje">
							<xsl:with-param name="symbol" select="'H.I'"/>
							<xsl:with-param name="wyszczeg" select="'Odsetki'"/>
						</xsl:call-template>
						<xsl:call-template name="F-Rzs_danePozycje">
							<xsl:with-param name="symbol" select="'H.II'"/>
							<xsl:with-param name="wyszczeg" select="'Inne'"/>
						</xsl:call-template>
						<xsl:call-template name="F-Rzs_danePozycje">
							<xsl:with-param name="symbol" select="'I'"/>
							<xsl:with-param name="wyszczeg" select="'Zysk (strata) brutto (F+G-H)'"/>
						</xsl:call-template>
						<xsl:call-template name="F-Rzs_danePozycje">
							<xsl:with-param name="symbol" select="'J'"/>
							<xsl:with-param name="wyszczeg" select="'Podatek dochodowy'"/>
						</xsl:call-template>
						<xsl:call-template name="F-Rzs_danePozycje">
							<xsl:with-param name="symbol" select="'K'"/>
							<xsl:with-param name="wyszczeg" select="'Pozostałe obowiązkowe zmniejszenia zysku (zwiększenia straty)'"/>
						</xsl:call-template>
						<xsl:call-template name="F-Rzs_danePozycje">
							<xsl:with-param name="symbol" select="'L'"/>
							<xsl:with-param name="wyszczeg" select="'Zysk (strata) netto (I - J - K)'"/>
						</xsl:call-template>
						<tr style="height: 20px">
							<td/>
							<td/>
							<td/>
						</tr>
					</tbody>
				</table>
				<!-- informacje uzupełniające-->
				<!-- <xsl:call-template name="F-Rzs_daneUzupelnienieTabela"/> -->
				<!--wyjaśnienia do sprawozdania-->
				<table cellpadding="0" cellspacing="0" class="all-bold" style="margin-bottom: 20px; width: 100%">
					<tbody>
						<tr style="height: 30px" valign="top">
							<td class="bottom-bold" style="font-size: 9pt; font-weight: bold; text-align:left; padding: 3px 10px; margin-left: 5px; margin-bottom: 25px">Wyjaśnienia do sprawozdania F-Rzs</td>
						</tr>
						<tr style="min-height: 50px; height: 70px" valign="top">
							<td style="text-align: left; font-size: 8pt; padding: 3px 10px">
								<xsl:value-of select="Naglowek/Uwagi"/>
							</td>
						</tr>
					</tbody>
				</table>
				<!-- ewentualne uwagi z pozycji -->
				<table cellpadding="0" cellspacing="0" class="all-bold" style="margin-bottom: 20px; width: 100%">
					<tbody>
						<xsl:if test="Pozycje/Pozycja[child::Uwagi]">
							<tr>
								<td colspan="3" style="text-align: center; font-size: 9pt; font-weight: bold; padding: 3px 10px">
									<div>Uwagi do pozycji</div>
								</td>
							</tr>
							<tr>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 4px 4px 0; width: 6%">Symbol</td>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 4px 4px 0; width: 24%">Wyszczególnienie</td>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 0 4px 0">Uwaga</td>
							</tr>
							<xsl:for-each select="Pozycje/Pozycja[child::Uwagi]">
								<xsl:sort select="Symbol"/>
								<tr>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="Symbol"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:choose>
											<xsl:when test="Symbol = 'A'">Przychody netto ze sprzedaży i zrównane z nimi, w tym:</xsl:when>
											<xsl:when test="Symbol = 'A.I'">Przychody netto ze sprzedaży produktów</xsl:when>
											<xsl:when test="Symbol = 'A.I.1'">w tym: dotacje zaliczane do przychodów (podmiotowe, przedmiotowe, na pierwsze wyposażenie w środki obrotowe)</xsl:when>
											<xsl:when test="Symbol = 'A.II'">Zmiana stanu produktów (zwiększenie - wartość dodatnia, zmniejszenie - wartość ujemna)</xsl:when>
											<xsl:when test="Symbol = 'A.III'">Koszt wytworzenia produktów na własne potrzeby jednostki</xsl:when>
											<xsl:when test="Symbol = 'A.IV'">Przychody netto ze sprzedaży towarów i materiałów</xsl:when>
											<xsl:when test="Symbol = 'A.V'">Pozostałe dochody budżetowe</xsl:when>
											<xsl:when test="Symbol = 'B'">Koszty działalności operacyjnej</xsl:when>
											<xsl:when test="Symbol = 'B.I'">Amortyzacja</xsl:when>
											<xsl:when test="Symbol = 'B.II'">Zużycie materiałów i energii</xsl:when>
											<xsl:when test="Symbol = 'B.III'">Usługi obce</xsl:when>
											<xsl:when test="Symbol = 'B.IV'">Podatki i opłaty</xsl:when>
											<xsl:when test="Symbol = 'B.V'">Wynagrodzenia</xsl:when>
											<xsl:when test="Symbol = 'B.VI'">Ubezpieczenia społeczne i inne świadczenia dla pracowników</xsl:when>
											<xsl:when test="Symbol = 'B.VII'">Pozostałe koszty rodzajowe</xsl:when>
											<xsl:when test="Symbol = 'B.VIII'">Wartość sprzedanych towarów i materiałów</xsl:when>
											<xsl:when test="Symbol = 'B.IX'">Udzielone dotacje</xsl:when>
											<xsl:when test="Symbol = 'B.X'">Inne świadczenia finansowane z budżetu</xsl:when>
											<xsl:when test="Symbol = 'B.XI'">Pozostałe obciążenia</xsl:when>
											<xsl:when test="Symbol = 'C'">Zysk (strata) ze sprzedaży (A - B)</xsl:when>
											<xsl:when test="Symbol = 'D'">Pozostałe przychody operacyjne</xsl:when>
											<xsl:when test="Symbol = 'D.I'">Zysk ze zbicia niefinansowanych aktywów trwałych</xsl:when>
											<xsl:when test="Symbol = 'D.II'">Dotacje</xsl:when>
											<xsl:when test="Symbol = 'D.III'">Pokrycie amortyzacji</xsl:when>
											<xsl:when test="Symbol = 'D.IV'">Inne przychody operacyjne</xsl:when>
											<xsl:when test="Symbol = 'E'">Pozostałe koszty operacyjne</xsl:when>
											<xsl:when test="Symbol = 'E.I'">Koszty inwestycji finansowanych ze środków własnych zakładów budżetowych i dochodów własnych jednostek budżetowych</xsl:when>
											<xsl:when test="Symbol = 'E.II'">Pozostałe koszty operacyjne</xsl:when>
											<xsl:when test="Symbol = 'F'">Zysk (strata) z działalności operacyjnej (C + D - E)</xsl:when>
											<xsl:when test="Symbol = 'G'">Przychody finansowe</xsl:when>
											<xsl:when test="Symbol = 'G.I'">Dywidendy i udziały w zyskach</xsl:when>
											<xsl:when test="Symbol = 'G.II'">Odsetki</xsl:when>
											<xsl:when test="Symbol = 'G.III'">Inne</xsl:when>
											<xsl:when test="Symbol = 'H'">Koszty finansowe</xsl:when>
											<xsl:when test="Symbol = 'H.I'">Odsetki</xsl:when>
											<xsl:when test="Symbol = 'H.II'">Inne</xsl:when>
											<xsl:when test="Symbol = 'I'">Zysk (strata) z działalności gospodarczej (F + G - H)</xsl:when>
											<xsl:when test="Symbol = 'J'">Wynik zdarzeń nadzwyczajnych (J.I. - J.II.)</xsl:when>
											<xsl:when test="Symbol = 'J.I'">Zyski nadzwyczajne</xsl:when>
											<xsl:when test="Symbol = 'J.II'">Straty nadzwyczajne</xsl:when>
											<xsl:when test="Symbol = 'K'">Zysk (strata) brutto (I +- J)</xsl:when>
											<xsl:when test="Symbol = 'L'">Podatek dochodowy</xsl:when>
											<xsl:when test="Symbol = 'M'">Pozostałe obowiązkowe zmniejszenia zysku (zwiększenia straty) oraz nadwyżki środków obrotowych</xsl:when>
											<xsl:when test="Symbol = 'N'">Zysk (strata) netto (K - L - M)</xsl:when>
										</xsl:choose>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:value-of select="Uwagi"/>
									</td>
								</tr>
							</xsl:for-each>
						</xsl:if>
					</tbody>
				</table>
				<table cellpadding="0" cellspacing="0" style="margin-bottom: 0px; margin-top: 80px; width: 100%">
					<tbody>
						<tr>
							<td style="text-align:center; font-size: 8pt;" valign="bottom">
								<hr style="width: 80%"/>
								<div>główny księgowy</div>
							</td>
							<td style="text-align:center; font-size: 8pt;" valign="bottom">
								<div>
									<xsl:value-of select="Naglowek/DataSprawozdania"/>
								</div>
								<hr style="width: 80%"/>
								<div>(rok m-c dzień)</div>
							</td>
							<td style="text-align:center; font-size: 8pt;" valign="bottom">
								<hr style="width: 80%"/>
								<div>kierownik jednostki</div>
							</td>
						</tr>
					</tbody>
				</table>
			</div>
			<xsl:element name="a">
				<xsl:attribute name="href"><xsl:value-of select="concat('#Jed', $jedIndex)"/></xsl:attribute>
				<xsl:element name="style">
					<xsl:value-of select="'font-family: Verdana'"/>
				</xsl:element>
				<xsl:value-of select="'Powrót do listy sprawozdań jednostki'"/>
			</xsl:element>
		</xsl:element>
	</xsl:template>
	<!-- F-Rzs szablony pomocnicze -->
	<xsl:template name="F-Rzs_danePozycje">
		<xsl:param name="symbol"/>
		<xsl:param name="wyszczeg"/>
		<tr>
			<td class="bottom-right-normal" style="text-align: left; padding: 3px">
				<table cellpadding="0" cellspacing="0" border="0">
					<tbody>
						<tr>
							<xsl:choose>
								<xsl:when test="string-length($symbol) = 1">
									<td style="font-weight: bold; font-size: 8pt; width: 50px" valign="top">
										<xsl:value-of select="concat($symbol, '.')"/>
									</td>
									<td style="font-weight: bold; font-size: 8pt; display: inline" valign="top">
										<xsl:value-of select="$wyszczeg"/>
									</td>
								</xsl:when>
								<xsl:otherwise>
									<td style="font-size: 8pt; width: 50px" valign="top">
										<xsl:value-of select="concat($symbol, '.')"/>
									</td>
									<td style="font-size: 8pt" valign="top">
										<xsl:value-of select="$wyszczeg"/>
									</td>
								</xsl:otherwise>
							</xsl:choose>
						</tr>
					</tbody>
				</table>
			</td>
			<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; padding: 3px">
				<xsl:choose>
					<xsl:when test="Pozycje/Pozycja[child::Symbol = $symbol]/P">
						<xsl:value-of select="format-number(Pozycje/Pozycja[child::Symbol = $symbol]/P, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
			<td class="right-bottom-mixed" style="text-align: right; font-size: 8pt; padding: 3px">
				<xsl:choose>
					<xsl:when test="Pozycje/Pozycja[child::Symbol = $symbol]/B">
						<xsl:value-of select="format-number(Pozycje/Pozycja[child::Symbol = $symbol]/B, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
		</tr>
		<xsl:call-template name="F-Rzs_danePozycjeUszczeg">
			<xsl:with-param name="symbolNadrzedny" select="$symbol"/>
		</xsl:call-template>
	</xsl:template>
	<xsl:template name="F-Rzs_danePozycjeUszczeg">
		<xsl:param name="symbolNadrzedny"/>
		<xsl:for-each select="Pozycje/Pozycja[child::SymbolNadrzedny = $symbolNadrzedny]">
			<tr>
				<td class="bottom-right-normal" style="text-align: left; padding: 3px">
					<table cellpadding="0" cellspacing="0" border="0">
						<tbody>
							<tr>
								<td style="font-size: 8pt; width: 50px" valign="top">
									<xsl:value-of select="concat(Symbol, '.')"/>
								</td>
								<td style="font-size: 8pt" valign="top">
									<xsl:value-of select="Opis"/>
								</td>
							</tr>
						</tbody>
					</table>
				</td>
				<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; padding: 3px">
					<xsl:choose>
						<xsl:when test="P">
							<xsl:value-of select="format-number(P, '#&#160;##0,00')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'0,00'"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td class="right-bottom-mixed" style="text-align: right; font-size: 8pt; padding: 3px">
					<xsl:choose>
						<xsl:when test="B">
							<xsl:value-of select="format-number(B, '#&#160;##0,00')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'0,00'"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
			</tr>
		</xsl:for-each>
	</xsl:template>
	<xsl:template name="F-Rzs_daneUzupelnienieStale">
		<xsl:param name="symbolUzupelnieniaStalego"/>
		<xsl:param name="opisUzupelnieniaStalego"/>
		<tr>
			<td class="bottom-right-normal" style="text-align: left; font-size: 8pt; padding: 3px">
				<xsl:value-of select="$symbolUzupelnieniaStalego"/>
			</td>
			<td class="bottom-right-normal" style="text-align: left; font-size: 8pt; padding: 3px">
				<xsl:value-of select="$opisUzupelnieniaStalego"/>
			</td>
			<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; padding: 3px">
				<xsl:choose>
					<xsl:when test="UzupelnienieStale/Pozycja[child::Symbol = $symbolUzupelnieniaStalego]/Wartosc">
						<xsl:value-of select="format-number(UzupelnienieStale/Pozycja[child::Symbol = $symbolUzupelnieniaStalego]/Wartosc,  '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
		</tr>
	</xsl:template>
	<xsl:template name="F-Rzs_daneUzupelnienieTabela">
		<div style="margin-bottom: 5px; font-weight: bold; font-size: 12px">Informacje uzupełniające istotne dla oceny rzetelności i przejrzystości sytuacji finansowej:</div>
		<table cellpadding="0" cellspacing="0" class="all-bold" style="margin-bottom: 60px">
			<thead>
				<tr>
					<td style="font-size: 8pt; font-weight: bold; width: 80px; text-align: center" class="bottom-right-bold">Symbol</td>
					<td style="font-size: 8pt; font-weight: bold; width: 800px; text-align: center" class="bottom-right-bold">Opis</td>
					<td style="font-size: 8pt; font-weight: bold; width: 160px; text-align: center" class="bottom-bold">Wartość</td>
				</tr>
			</thead>
			<tbody>
				<xsl:call-template name="B-Wyk_daneUzupelnienieStale">
					<xsl:with-param name="symbolUzupelnieniaStalego" select="'1'"/>
					<xsl:with-param name="opisUzupelnieniaStalego" select="'Informacje o kwocie i charakterze poszczególnych pozycji przychodów lub kosztów o nadzwyczajnej wartości lub które wystąpiły incydentalnie'"/>
				</xsl:call-template>
				<xsl:for-each select="Uzupelnienie/Pozycja">
					<tr>
						<td class="bottom-right-normal" style="text-align: left; font-size: 8pt; padding: 3px">
							<div>
								<xsl:value-of select="Symbol"/>
							</div>
						</td>
						<td class="bottom-right-normal" style="text-align: left; font-size: 8pt; padding: 3px">
							<div>
								<xsl:value-of select="Opis"/>
							</div>
						</td>
						<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; padding: 3px">
							<div>
								<xsl:choose>
									<xsl:when test="Wartosc">
										<xsl:value-of select="format-number(Wartosc, '#&#160;##0,00')"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="'0,00'"/>
									</xsl:otherwise>
								</xsl:choose>
							</div>
						</td>
					</tr>
				</xsl:for-each>
			</tbody>
		</table>
	</xsl:template>
	<!-- F-Zzf -->
	<xsl:template match="F-Zzf">
		<xsl:param name="jedIndex"/>
		<xsl:param name="sprIndex"/>
		<xsl:element name="div">
			<xsl:attribute name="Id"><xsl:value-of select="concat('Jed', $jedIndex, 'Wer', $sprIndex)"/></xsl:attribute>
			<xsl:attribute name="style"><xsl:value-of select="'display: block; margin-bottom: 40px'"/></xsl:attribute>
			<div style="font-size: 12pt; font-weight: bold; margin-left: 5px; margin-bottom: 10px">
        Sprawozdanie F-Zzf:
        <xsl:choose>
					<xsl:when test="Naglowek/Wersja = 0">
						<xsl:value-of select="'wersja pierwotna'"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="concat('korekta nr ', Naglowek/Wersja)"/>
					</xsl:otherwise>
				</xsl:choose>
				<xsl:call-template name="SprNaglowekInfo"/>
			</div>
			<table cellpadding="0" cellspacing="0" class="all-bold" style="margin-bottom: 20px">
				<thead>
					<tr>
						<th style="width:333px"/>
						<th style="width: 56px"/>
						<th style="width: 365px"/>
						<th style="width: 37px"/>
						<th style="width: 265px"/>
					</tr>
				</thead>
				<tbody>
					<tr style="height: 127px">
						<td class="bottom-bold" style="width:333px">
							<table cellpadding="0" cellspacing="0" style="border-collapse: collapse; height" width="100%">
								<tbody>
									<tr style="height: 80px">
										<td style="text-align: left; font-size: 9pt; margin:1px 1px 0 0; padding:0" valign="top">
                      Nazwa i adres jednostki sprawozdawczej
                    </td>
									</tr>
									<tr>
										<td class="bottom-normal" style="text-align: center; font-size: 9pt" valign="bottom">
											<!-- popr. nr I.8 -->
											<div style="display: block;margin: 0 20px">
												<xsl:choose>
													<xsl:when test="Jednostka/Nazwa">
														<xsl:value-of select="Jednostka/Nazwa"/>
													</xsl:when>
													<xsl:otherwise>
														<xsl:value-of select="../../Nazwa"/>
													</xsl:otherwise>
												</xsl:choose>
												<!--<xsl:value-of select="../../Nazwa"/>-->
											</div>
										</td>
									</tr>
									<tr style="height: 23px">
										<td style="text-align: left; font-size: 9pt; margin:1px 1px 0 0; padding:0;" valign="top">
                      Numer identyfikacyjny REGON
                    </td>
									</tr>
									<tr>
										<td style="text-align: center; font-size: 9pt; font-weight: bold; margin:1px 1px 0 0; padding:0" valign="baseline">
											<xsl:choose>
												<xsl:when test="Jednostka/Regon">
													<xsl:value-of select="Jednostka/Regon"/>
												</xsl:when>
												<xsl:otherwise>
													<xsl:value-of select="../../Regon"/>
												</xsl:otherwise>
											</xsl:choose>
											<!--<xsl:value-of select="../../Regon"/>-->
										</td>
									</tr>
								</tbody>
							</table>
						</td>
						<td colspan="3" class="notop-bold" valign="top" style="width: 458px">
							<div style="font-weight: bold; text-align: center; font-size: 11pt; margin-bottom: 5px">Zestawienie zmian w funduszu</div>
							<!-- <div style="font-weight: bold; text-align: center; font-size: 11pt">Sprawozdanie łączne</div> -->
							<div style="font-weight: bold; text-align: center; font-size: 11pt; margin-bottom: 5px">
								<xsl:choose>
									<xsl:when test="Naglowek/BilansLacznyDla = 'JB'">
										<xsl:value-of select="'jednostki budżetowej'"/>
									</xsl:when>
									<xsl:when test="Naglowek/BilansLacznyDla = 'ZB'">
										<xsl:value-of select="'zakładu budżetowego'"/>
									</xsl:when>
									<xsl:when test="Naglowek/BilansLacznyDla = 'GP'">
										<xsl:value-of select="'gospodarstwa pomocniczego'"/>
									</xsl:when>
									<xsl:otherwise>
                  </xsl:otherwise>
								</xsl:choose>
							</div>
							<div style="vertical-align: bottom; text-align: center; font-size: 9pt; font-weight: bold; margin-top: 60px">
								<xsl:value-of select="'sporządzony na dzień'"/>
							</div>
							<div style="vertical-align: bottom; text-align: center; font-weight: bold; font-size: 9pt; margin-top: 5px">
								<xsl:value-of select="concat('31-12-', ../../../../Okres/Rok)"/>
								<!-- <xsl:value-of select="concat(test:ostDzienMies(test:okrMies(../../../../Okres/Okres, ../../../../Okres/TypOkresu), ../../../../Okres/Rok), '-', test:okrMies(../../../../Okres/Okres, ../../../../Okres/TypOkresu), '-', ../../../../Okres/Rok)"/> -->
							</div>
						</td>
						<td class="bottom-bold" style="text-align: left; font-size: 9pt; margin:2px 2px 0 0; padding:0; width: 265px" valign="top">
							<table cellpadding="0" cellspacing="0" style="border-collapse: collapse; height" width="100%">
								<tbody>
									<tr style="height: 80px">
										<td class="bottom-normal" style="text-align: left; font-size: 9pt; margin:2px 2px 0 0; padding:0" valign="top">
											<div style="margin-bottom:5px">Adresat:</div>
											<!-- popr. nr I.9 -->
											<div style="text-align:center; margin-bottom: 15px;">
												<!-- <xsl:value-of select="'Regionalna Izba Obrachunkowa w Katowicach'"/> -->
											</div>
										</td>
									</tr>
									<tr style="height: 23px">
										<td style="text-align: left; font-size: 9pt; margin:2px 2px 0 0; padding:0;" valign="top">
											<div style="margin-bottom:5px">Wysłać bez pisma przewodniego</div>
											<div style="text-align:center;">
												<!-- <xsl:value-of select="'wersja robocza'"/> -->
											</div>
										</td>
									</tr>
								</tbody>
							</table>
						</td>
					</tr>
					<tr style="height: 20px">
						<td class="bottom-right-bold"/>
						<td colspan="3" class="bottom-right-bold"/>
						<td class="bottom-right-bold"/>
					</tr>
				</tbody>
			</table>
			<div style="display: block; margin-bottom: 60px">
				<table cellpadding="0" cellspacing="0" class="all-bold" style="margin-bottom: 60px">
					<tbody>
						<tr>
							<td style="font-size: 8pt; font-weight: bold; width: 700px; text-align: center" class="bottom-right-mixed"/>
							<td style="font-size: 8pt; font-weight: bold; width: 160px; text-align: center" class="bottom-right-mixed">Stan na koniec roku poprzedniego</td>
							<td style="font-size: 8pt; font-weight: bold; width: 160px; text-align: center" class="bottom-bold">Stan na koniec roku bieżącego</td>
						</tr>
						<xsl:call-template name="F-Zzf_danePozycje">
							<xsl:with-param name="symbol" select="'I'"/>
							<xsl:with-param name="wyszczeg" select="'Fundusz jednostki na początku okresu (BO)'"/>
							<xsl:with-param name="dzial" select="true()"/>
						</xsl:call-template>
						<xsl:call-template name="F-Zzf_danePozycje">
							<xsl:with-param name="symbol" select="'I.1'"/>
							<xsl:with-param name="wyszczeg" select="'Zwiększenie funduszu (z tytułu)'"/>
						</xsl:call-template>
						<xsl:call-template name="F-Zzf_danePozycje">
							<xsl:with-param name="symbol" select="'I.1.1'"/>
							<xsl:with-param name="wyszczeg" select="'Zysk bilansowy za rok ubiegły'"/>
						</xsl:call-template>
						<xsl:call-template name="F-Zzf_danePozycje">
							<xsl:with-param name="symbol" select="'I.1.2'"/>
							<xsl:with-param name="wyszczeg" select="'Zrealizowane wydatki budżetowe'"/>
						</xsl:call-template>
						<xsl:call-template name="F-Zzf_danePozycje">
							<xsl:with-param name="symbol" select="'I.1.3'"/>
							<xsl:with-param name="wyszczeg" select="'Zrealizowane płatności ze środków europejskich'"/>
						</xsl:call-template>
						<xsl:call-template name="F-Zzf_danePozycje">
							<xsl:with-param name="symbol" select="'I.1.4'"/>
							<xsl:with-param name="wyszczeg" select="'Środki na inwestycje'"/>
						</xsl:call-template>
						<xsl:call-template name="F-Zzf_danePozycje">
							<xsl:with-param name="symbol" select="'I.1.5'"/>
							<xsl:with-param name="wyszczeg" select="'Aktualizacja wyceny środków trwałych'"/>
						</xsl:call-template>
						<xsl:call-template name="F-Zzf_danePozycje">
							<xsl:with-param name="symbol" select="'I.1.6'"/>
							<xsl:with-param name="wyszczeg" select="'Nieodpłatnie otrzymane środki trwałe i środki trwałe w budowie oraz wartości niematerialne i prawne'"/>
						</xsl:call-template>
						<xsl:call-template name="F-Zzf_danePozycje">
							<xsl:with-param name="symbol" select="'I.1.7'"/>
							<xsl:with-param name="wyszczeg" select="'Aktywa przejęte od zlikwidowanych lub połączonych jednostek'"/>
						</xsl:call-template>
						<xsl:call-template name="F-Zzf_danePozycje">
							<xsl:with-param name="symbol" select="'I.1.8'"/>
							<xsl:with-param name="wyszczeg" select="'Aktywa otrzymane w ramach centralnego zaopatrzenia'"/>
						</xsl:call-template>
						<xsl:call-template name="F-Zzf_danePozycje">
							<xsl:with-param name="symbol" select="'I.1.9'"/>
							<xsl:with-param name="wyszczeg" select="'Pozostałe odpisy z wyniku finansowego za rok bieżący'"/>
						</xsl:call-template>
						<xsl:call-template name="F-Zzf_danePozycje">
							<xsl:with-param name="symbol" select="'I.1.10'"/>
							<xsl:with-param name="wyszczeg" select="'Inne zwiększenia'"/>
						</xsl:call-template>
						<xsl:call-template name="F-Zzf_danePozycje">
							<xsl:with-param name="symbol" select="'I.2'"/>
							<xsl:with-param name="wyszczeg" select="'Zmniejszenia funduszu jednostki (z tytułu)'"/>
						</xsl:call-template>
						<xsl:call-template name="F-Zzf_danePozycje">
							<xsl:with-param name="symbol" select="'I.2.1'"/>
							<xsl:with-param name="wyszczeg" select="'Strata za rok ubiegły'"/>
						</xsl:call-template>
						<xsl:call-template name="F-Zzf_danePozycje">
							<xsl:with-param name="symbol" select="'I.2.2'"/>
							<xsl:with-param name="wyszczeg" select="'Zrealizowane dochody budżetowe'"/>
						</xsl:call-template>
						<xsl:call-template name="F-Zzf_danePozycje">
							<xsl:with-param name="symbol" select="'I.2.3'"/>
							<xsl:with-param name="wyszczeg" select="'Rozliczenia wyniku finansowego i środków obrotowych za rok ubiegły'"/>
						</xsl:call-template>
						<xsl:call-template name="F-Zzf_danePozycje">
							<xsl:with-param name="symbol" select="'I.2.4'"/>
							<xsl:with-param name="wyszczeg" select="'Dotacje i środki na inwestycje'"/>
						</xsl:call-template>
						<xsl:call-template name="F-Zzf_danePozycje">
							<xsl:with-param name="symbol" select="'I.2.5'"/>
							<xsl:with-param name="wyszczeg" select="'Aktualizacja wyceny środków trwałych'"/>
						</xsl:call-template>
						<xsl:call-template name="F-Zzf_danePozycje">
							<xsl:with-param name="symbol" select="'I.2.6'"/>
							<xsl:with-param name="wyszczeg" select="'Wartość sprzedanych i nieodpłatnie przekazanych środków trwałych i środków trwałych w budowie oraz wartości niematerialnych i prawnych'"/>
						</xsl:call-template>
						<xsl:call-template name="F-Zzf_danePozycje">
							<xsl:with-param name="symbol" select="'I.2.7'"/>
							<xsl:with-param name="wyszczeg" select="'Pasywa przejęte od zlikwidowanych lub połączonych jednostek'"/>
						</xsl:call-template>
						<xsl:call-template name="F-Zzf_danePozycje">
							<xsl:with-param name="symbol" select="'I.2.8'"/>
							<xsl:with-param name="wyszczeg" select="'Aktywa przekazane w ramach centralnego zaopatrzenia'"/>
						</xsl:call-template>
						<xsl:call-template name="F-Zzf_danePozycje">
							<xsl:with-param name="symbol" select="'I.2.9'"/>
							<xsl:with-param name="wyszczeg" select="'Inne zmniejszenia'"/>
						</xsl:call-template>
						<xsl:call-template name="F-Zzf_danePozycje">
							<xsl:with-param name="symbol" select="'II'"/>
							<xsl:with-param name="wyszczeg" select="'Fundusz jednostki na koniec okresu (BZ)'"/>
							<xsl:with-param name="dzial" select="true()"/>
						</xsl:call-template>
						<xsl:call-template name="F-Zzf_danePozycje">
							<xsl:with-param name="symbol" select="'III'"/>
							<xsl:with-param name="wyszczeg" select="'Wynik finansowy netto za rok bieżący (+,-)'"/>
							<xsl:with-param name="dzial" select="true()"/>
						</xsl:call-template>
						<xsl:call-template name="F-Zzf_danePozycje">
							<xsl:with-param name="symbol" select="'III.1'"/>
							<xsl:with-param name="wyszczeg" select="'zysk netto (+)'"/>
						</xsl:call-template>
						<xsl:call-template name="F-Zzf_danePozycje">
							<xsl:with-param name="symbol" select="'III.2'"/>
							<xsl:with-param name="wyszczeg" select="'strata netto (-)'"/>
						</xsl:call-template>
						<xsl:call-template name="F-Zzf_danePozycje">
							<xsl:with-param name="symbol" select="'III.3'"/>
							<xsl:with-param name="wyszczeg" select="'nadwyżka środków obrotowych'"/>
						</xsl:call-template>
						<xsl:call-template name="F-Zzf_danePozycje">
							<xsl:with-param name="symbol" select="'IV'"/>
							<xsl:with-param name="wyszczeg" select="'Fundusz(II+, -III)'"/>
							<xsl:with-param name="dzial" select="true()"/>
						</xsl:call-template>
						<tr style="height: 20px">
							<td/>
							<td/>
							<td/>
						</tr>
					</tbody>
				</table>
				<!-- informacje uzupełniające-->
				<!-- <div style="font-weight: bold; font-size: 10pt; margin-bottom: 5px">Informacje uzupełniające istotne dla oceny rzetelności i przejrzystości sytuacji finansowej : </div> -->
				<!-- <table cellpadding="0" cellspacing="0" class="all-bold" style="margin-bottom: 60px"> -->
				<!-- <tbody> -->
				<!-- <tr> -->
				<!-- <td style="font-size: 8pt; font-weight: bold; width: 80px; text-align: center" class="bottom-right-bold">Symbol</td> -->
				<!-- <td style="font-size: 8pt; font-weight: bold; width: 800px; text-align: center" class="bottom-right-bold">Opis</td> -->
				<!-- <td style="font-size: 8pt; font-weight: bold; width: 160px; text-align: center" class="bottom-bold">Wartość</td> -->
				<!-- </tr> -->
				<!-- <xsl:for-each select="Uzupelnienie/Pozycja"> -->
				<!-- <xsl:sort select="Symbol"/> -->
				<!-- <xsl:choose> -->
				<!-- <xsl:when test="position() != last()"> -->
				<!-- <tr> -->
				<!-- <td class="bottom-right-normal" style="text-align: left; font-size: 8pt; padding: 3px"> -->
				<!-- <xsl:value-of select="Symbol"/> -->
				<!-- </td> -->
				<!-- <td class="bottom-right-normal" style="text-align: left; font-size: 8pt; padding: 3px"> -->
				<!-- <xsl:value-of select="Opis"/> -->
				<!-- </td> -->
				<!-- <td class="bottom-normal" style="text-align: right; font-size: 8pt; padding: 3px"> -->
				<!-- <xsl:choose> -->
				<!-- <xsl:when test="Wartosc"> -->
				<!-- <xsl:value-of select="format-number(Wartosc, '#&#160;##0,00')"/> -->
				<!-- </xsl:when> -->
				<!-- <xsl:otherwise> -->
				<!-- <xsl:value-of select="'0,00'"/> -->
				<!-- </xsl:otherwise> -->
				<!-- </xsl:choose> -->
				<!-- </td> -->
				<!-- </tr> -->
				<!-- </xsl:when> -->
				<!-- <xsl:otherwise> -->
				<!-- <tr> -->
				<!-- <td class="right-normal" style="text-align: left; font-size: 8pt; padding: 3px"> -->
				<!-- <xsl:value-of select="Symbol"/> -->
				<!-- </td> -->
				<!-- <td class="right-normal" style="text-align: left; font-size: 8pt; padding: 3px"> -->
				<!-- <xsl:value-of select="Opis"/> -->
				<!-- </td> -->
				<!-- <td class="right-normal" style="text-align: right; font-size: 8pt; padding: 3px"> -->
				<!-- <xsl:choose> -->
				<!-- <xsl:when test="Wartosc"> -->
				<!-- <xsl:value-of select="format-number(Wartosc, '#&#160;##0,00')"/> -->
				<!-- </xsl:when> -->
				<!-- <xsl:otherwise> -->
				<!-- <xsl:value-of select="'0,00'"/> -->
				<!-- </xsl:otherwise> -->
				<!-- </xsl:choose> -->
				<!-- </td> -->
				<!-- </tr> -->
				<!-- </xsl:otherwise> -->
				<!-- </xsl:choose> -->
				<!-- </xsl:for-each> -->
				<!-- </tbody> -->
				<!-- </table> -->
				<!--wyjaśnienia do sprawozdania-->
				<table cellpadding="0" cellspacing="0" class="all-bold" style="margin-bottom: 20px; width: 100%">
					<tbody>
						<tr style="height: 30px" valign="top">
							<td colspan="4" class="bottom-bold" style="font-size: 9pt; font-weight: bold; text-align:left; padding: 3px 10px; margin-left: 5px; margin-bottom: 25px">Wyjaśnienia do sprawozdania F-Zzf</td>
						</tr>
						<tr style="min-height: 50px; height: 70px" valign="top">
							<td colspan="4" style="text-align: left; font-size: 8pt; padding: 3px 10px">
								<xsl:value-of select="Naglowek/Uwagi"/>
							</td>
						</tr>
					</tbody>
				</table>
				<!-- ewentualne uwagi z pozycji -->
				<xsl:if test="Pozycje/Pozycja[child::Uwagi]">
					<table cellpadding="0" cellspacing="0" class="all-bold" style="margin-bottom: 20px; width: 100%">
						<tbody>
							<tr>
								<td colspan="4" style="text-align: center; font-size: 9pt; font-weight: bold; padding: 3px 10px">
									<div>Uwagi do pozycji</div>
								</td>
							</tr>
							<tr>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 4px 4px 0; width: 6%">Symbol</td>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 4px 4px 0; width: 24%">Wyszczególnienie</td>
								<td colspan="2" style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 0 4px 0">Uwaga</td>
							</tr>
							<xsl:for-each select="Pozycje/Pozycja[child::Uwagi]">
								<xsl:sort select="Symbol"/>
								<tr>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="Symbol"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:choose>
											<xsl:when test="Symbol = 'I'">Fundusz jednostki na początku okresu (BO)</xsl:when>
											<xsl:when test="Symbol = 'II'">Zwiększenie funduszu (z tytułu)</xsl:when>
											<xsl:when test="Symbol = 'II.1'">Zysk bilansowy za rok ubiegły</xsl:when>
											<xsl:when test="Symbol = 'II.2'">Zrealizowane wydatki budżetowe</xsl:when>
											<xsl:when test="Symbol = 'II.3'">Dotacje, środki na inwestycje, odpisy z wyniku finansowego na inwestycje</xsl:when>
											<xsl:when test="Symbol = 'II.4'">Aktualizacja środków trwałych</xsl:when>
											<xsl:when test="Symbol = 'II.5'">Nieodpłatnie otrzymane środki trwałe i inwestycje</xsl:when>
											<xsl:when test="Symbol = 'II.6'">Aktywa przejęte od zlikwidowanych (połączonych) jednostek</xsl:when>
											<xsl:when test="Symbol = 'II.7'">Środki obrotowe otrzymane w ramach centralnego zaopatrzenia</xsl:when>
											<xsl:when test="Symbol = 'II.8'">Pozostałe odpisy z wyniku finansowego za rok bieżący</xsl:when>
											<xsl:when test="Symbol = 'II.9'">Inne zwiększenia</xsl:when>
											<xsl:when test="Symbol = 'III'">Zmniejszenia funduszu jednostki (z tytułu)</xsl:when>
											<xsl:when test="Symbol = 'III.1'">Strata za rok ubiegły</xsl:when>
											<xsl:when test="Symbol = 'III.2'">Zrealizowane dochody budżetowe</xsl:when>
											<xsl:when test="Symbol = 'III.3'">Rozliczenie wyniku finansowego i środków obrotowych za rok ubiegły</xsl:when>
											<xsl:when test="Symbol = 'III.4'">Dotacje i środki na inwestycje</xsl:when>
											<xsl:when test="Symbol = 'III.5'">Pokrycje amortyzacji</xsl:when>
											<xsl:when test="Symbol = 'III.6'">Aktualizacja środków trwałych</xsl:when>
											<xsl:when test="Symbol = 'III.7'">Wartość sprzedanych i nieodpłatnie przekazanych środków trwałych i inwestycji</xsl:when>
											<xsl:when test="Symbol = 'III.8'">Pasywa przejęte od zlikwidowanych (połączonych) jednostek</xsl:when>
											<xsl:when test="Symbol = 'III.9'">Środki obrotowe przekazane w ramach centralnego zaopatrzenia</xsl:when>
											<xsl:when test="Symbol = 'III.10'">Inne zmniejszenia</xsl:when>
											<xsl:when test="Symbol = 'IV'">Fundusz jednostki na koniec okresu (BZ) (poz. I+II-III)</xsl:when>
											<xsl:when test="Symbol = 'V'">Wynik finansowy netto za rok bieżący (+,-)</xsl:when>
											<xsl:when test="Symbol = 'V.1'">zysk netto</xsl:when>
											<xsl:when test="Symbol = 'V.2'">strata netto (-)</xsl:when>
											<xsl:when test="Symbol = 'VI'">Nadwyżka dochodów własnych jednostek budżetowych, nadwyżka środków obrotowych zakładków budżetowych, odpisy z wyniku finansowego gospodarstw pomocnicznych jednostek budżetowych</xsl:when>
											<xsl:when test="Symbol = 'VII'">Fundusz (poz. IV+,-V-VI)</xsl:when>
										</xsl:choose>
									</td>
									<td colspan="3" class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:value-of select="Uwagi"/>
									</td>
								</tr>
							</xsl:for-each>
						</tbody>
					</table>
				</xsl:if>
				<table cellpadding="0" cellspacing="0" style="margin-bottom: 0px; margin-top: 80px; width: 100%">
					<tbody>
						<tr>
							<td style="text-align:center; font-size: 8pt;" valign="bottom">
								<hr style="width: 80%"/>
								<div>główny księgowy</div>
							</td>
							<td style="text-align:center; font-size: 8pt;" valign="bottom">
								<div>
									<xsl:value-of select="Naglowek/DataSprawozdania"/>
								</div>
								<hr style="width: 80%"/>
								<div>(rok m-c dzień)</div>
							</td>
							<td style="text-align:center; font-size: 8pt;" valign="bottom">
								<hr style="width: 80%"/>
								<div>kierownik jednostki</div>
							</td>
						</tr>
					</tbody>
				</table>
			</div>
			<xsl:element name="a">
				<xsl:attribute name="href"><xsl:value-of select="concat('#Jed', $jedIndex)"/></xsl:attribute>
				<xsl:element name="style">
					<xsl:value-of select="'font-family: Verdana'"/>
				</xsl:element>
				<xsl:value-of select="'Powrót do listy sprawozdań jednostki'"/>
			</xsl:element>
		</xsl:element>
	</xsl:template>
	<!-- F-Zzf szablony pomocnicze -->
	<xsl:template name="F-Zzf_danePozycje">
		<xsl:param name="symbol"/>
		<xsl:param name="wyszczeg"/>
		<xsl:param name="dzial" select="false()"/>
		<tr>
			<td class="bottom-right-normal" style="text-align: left; padding: 3px">
				<table cellpadding="0" cellspacing="0" border="0">
					<tbody>
						<tr>
							<xsl:choose>
								<xsl:when test="$dzial = true()">
									<td style="font-weight: bold; font-size: 8pt; width: 50px" valign="top">
										<xsl:value-of select="concat($symbol, '.')"/>
									</td>
									<td style="font-weight: bold; font-size: 8pt; display: inline" valign="top">
										<xsl:value-of select="$wyszczeg"/>
									</td>
								</xsl:when>
								<xsl:otherwise>
									<td style="font-size: 8pt; width: 50px" valign="top">
										<xsl:value-of select="concat($symbol, '.')"/>
									</td>
									<td style="font-size: 8pt" valign="top">
										<xsl:value-of select="$wyszczeg"/>
									</td>
								</xsl:otherwise>
							</xsl:choose>
						</tr>
					</tbody>
				</table>
			</td>
			<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; padding: 3px">
				<xsl:choose>
					<xsl:when test="Pozycje/Pozycja[child::Symbol = $symbol]/P">
						<xsl:value-of select="format-number(Pozycje/Pozycja[child::Symbol = $symbol]/P, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
			<td class="right-bottom-mixed" style="text-align: right; font-size: 8pt; padding: 3px">
				<xsl:choose>
					<xsl:when test="Pozycje/Pozycja[child::Symbol = $symbol]/B">
						<xsl:value-of select="format-number(Pozycje/Pozycja[child::Symbol = $symbol]/B, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
		</tr>
		<xsl:call-template name="F-Zzf_danePozycjeUszczeg">
			<xsl:with-param name="symbolNadrzedny" select="$symbol"/>
		</xsl:call-template>
	</xsl:template>
	<xsl:template name="F-Zzf_danePozycjeUszczeg">
		<xsl:param name="symbolNadrzedny"/>
		<xsl:for-each select="Pozycje/Pozycja[child::SymbolNadrzedny = $symbolNadrzedny]">
			<tr>
				<td class="bottom-right-normal" style="text-align: left; padding: 3px">
					<table cellpadding="0" cellspacing="0" border="0">
						<tbody>
							<tr>
								<td style="font-size: 8pt; width: 50px" valign="top">
									<xsl:value-of select="concat(Symbol, '.')"/>
								</td>
								<td style="font-size: 8pt" valign="top">
									<xsl:value-of select="Opis"/>
								</td>
							</tr>
						</tbody>
					</table>
				</td>
				<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; padding: 3px">
					<xsl:choose>
						<xsl:when test="P">
							<xsl:value-of select="format-number(P, '#&#160;##0,00')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'0,00'"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td class="right-bottom-mixed" style="text-align: right; font-size: 8pt; padding: 3px">
					<xsl:choose>
						<xsl:when test="B">
							<xsl:value-of select="format-number(B, '#&#160;##0,00')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'0,00'"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
			</tr>
		</xsl:for-each>
	</xsl:template>
	<!-- Rb-30 -->
	<xsl:template match="Rb-30">
		<xsl:param name="jedIndex"/>
		<xsl:param name="sprIndex"/>
		<xsl:element name="div">
			<xsl:attribute name="Id"><xsl:value-of select="concat('Jed', $jedIndex, 'Wer', $sprIndex)"/></xsl:attribute>
			<xsl:attribute name="style"><xsl:value-of select="'display: block; margin-bottom: 40px'"/></xsl:attribute>
			<div style="font-size: 12pt; font-weight: bold; margin-left: 5px; margin-bottom: 10px">
        Sprawozdanie Rb-30:
        <xsl:choose>
					<xsl:when test="Naglowek/Wersja = 0">
						<xsl:value-of select="'wersja pierwotna'"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="concat('korekta nr ', Naglowek/Wersja)"/>
					</xsl:otherwise>
				</xsl:choose>
				<xsl:call-template name="SprNaglowekInfo"/>
			</div>
			<table cellpadding="0" cellspacing="0" class="all-bold" style="margin-bottom: 30px">
				<tbody>
					<tr style="height: 18px">
						<td colspan="10" class="bottom-bold" style="font-size: 10pt;">MINISTERSTWO FINANSÓW, ul. Świętokrzyska 12, 00-916 Warszawa</td>
					</tr>
					<tr style="height: 127px">
						<td colspan="4" class="bottom-bold" style="width:300px">
							<table cellpadding="0" cellspacing="0" style="border-collapse: collapse; height" width="100%">
								<tbody>
									<tr style="height: 80px">
										<td style="text-align: left; font-size: 9pt; margin:1px 1px 0 0; padding:0" valign="top">
                      Nazwa i adres jednostki sprawozdawczej
                    </td>
									</tr>
									<tr>
										<td class="bottom-normal" style="text-align: center; font-size: 9pt" valign="bottom">
											<!-- popr. nr I.8 -->
											<div style="display: block;margin: 0 20px">
												<xsl:choose>
													<xsl:when test="Jednostka/Nazwa">
														<xsl:value-of select="Jednostka/Nazwa"/>
													</xsl:when>
													<xsl:otherwise>
														<xsl:value-of select="../../Nazwa"/>
													</xsl:otherwise>
												</xsl:choose>
												<!--<xsl:value-of select="../../Nazwa"/>-->
											</div>
										</td>
									</tr>
									<tr style="height: 23px">
										<td style="text-align: left; font-size: 9pt; margin:1px 1px 0 0; padding:0;" valign="top">
                      Numer identyfikacyjny REGON
                    </td>
									</tr>
									<tr>
										<td style="text-align: center; font-size: 9pt; font-weight: bold; margin:1px 1px 0 0; padding:0" valign="baseline">
											<xsl:choose>
												<xsl:when test="Jednostka/Regon">
													<xsl:value-of select="Jednostka/Regon"/>
												</xsl:when>
												<xsl:otherwise>
													<xsl:value-of select="../../Regon"/>
												</xsl:otherwise>
											</xsl:choose>
											<!--<xsl:value-of select="../../Regon"/>-->
										</td>
									</tr>
								</tbody>
							</table>
						</td>
						<td colspan="3" class="notop-bold" valign="top" style="width: 400px">
							<div style="font-weight: bold; text-align: center; font-size: 11pt; margin-bottom: 5px">Rb-30 półroczne / roczne sprawozdanie z wykonania planów finansowych zakładów budżetowych</div>
							<div style="vertical-align: bottom; text-align: center; font-size: 9pt; margin-top: 90px">
								<xsl:call-template name="NaglowekSprOkres"/>
							</div>
						</td>
						<td colspan="3" class="bottom-bold" style="text-align: left; font-size: 9pt; margin:1px 1px 0 0; padding:0; width: 300px" valign="top">
							<div style="margin-bottom:5px">Adresat:</div>
							<!-- popr. nr I.9 -->
							<div style="text-align:center; margin-bottom: 15px;">
								<!-- <xsl:value-of select="'Regionalna Izba Obrachunkowa w Katowicach'"/> -->
							</div>
							<div style="text-align:center;">
								<!-- <xsl:value-of select="'wersja robocza'"/> -->
							</div>
						</td>
					</tr>
					<tr style="height: 54px">
						<td rowspan="2" colspan="7" class="bottom-right-bold" style="font-size: 9pt">
							<!-- popr. nr I.10 -->
							<div style="margin-bottom: 1px">
								<xsl:value-of select="'Nazwa województwa '"/>
								<sup>1) 2)</sup>
								<!-- <xsl:if test="../../Typ = 'W'">
									<span style="margin-left: 10px">
										<b>
											<xsl:value-of select="../../Nazwa"/>
										</b>
									</span>
								</xsl:if> -->
							</div>
							<div style="margin-bottom: 1px">
								<xsl:value-of select="'Nazwa powiatu / związku '"/>
								<sup>1) 2)</sup>
								<!-- <xsl:if test="../../Typ = 'P'">
									<span style="margin-left: 10px">
										<b>
											<xsl:value-of select="../../Nazwa"/>
										</b>
									</span>
								</xsl:if> -->
							</div>
							<div>
								<xsl:value-of select="'Nazwa gminy / związku '"/>
								<sup>1) 2)</sup>
								<!-- <xsl:if test="../../Typ = 'G'">
									<span style="margin-left: 10px">
										<b>
											<xsl:value-of select="../../Nazwa"/>
										</b>
									</span>
								</xsl:if> -->
							</div>
						</td>
						<td colspan="3" class="bottom-bold" style="font-size:9pt; text-align:center">Przed wypełnieniem przeczytać instrukcję</td>
					</tr>
					<tr>
						<td colspan="3" class="bottom-bold" style="font-size:9pt; text-align:center">Wysyłać bez pisma przewodniego</td>
					</tr>
					<tr>
						<td colspan="7" class="right-bottom-mixed" style="font-size:10pt; text-align:center">Symbole</td>
						<td colspan="3" class="bottom-normal" style="font-size:10pt; text-align:center">Klasyfikacja budżetowa</td>
					</tr>
					<tr>
						<td class="bottom-right-normal" style="font-size:9pt; text-align:center">woj.</td>
						<td class="bottom-right-normal" style="font-size:9pt; text-align:center">powiat</td>
						<td class="bottom-right-normal" style="font-size:9pt; text-align:center">gmina</td>
						<td class="bottom-right-normal" style="font-size:9pt; text-align:center">typ gm.</td>
						<td class="bottom-right-normal" style="font-size:9pt; text-align:center">związek jst</td>
						<td class="bottom-right-normal" style="font-size:9pt; text-align:center">typ zw.</td>
						<td class="right-bottom-mixed" style="font-size:9pt; text-align:center">zakładu budżetowego</td>
						<td class="bottom-right-normal" style="font-size:9pt; text-align:center">
              część <sup>3)</sup>
						</td>
						<td class="bottom-right-normal" style="font-size:9pt; text-align:center">dział</td>
						<td class="bottom-normal" style="font-size:9pt; text-align:center">rozdział</td>
					</tr>
					<tr>
						<td class="bottom-right-normal" style="text-align:center; font-size: 8pt">
							<xsl:value-of select="1"/>
						</td>
						<td class="bottom-right-normal" style="text-align:center; font-size: 8pt">
							<xsl:value-of select="2"/>
						</td>
						<td class="bottom-right-normal" style="text-align:center; font-size: 8pt">
							<xsl:value-of select="3"/>
						</td>
						<td class="bottom-right-normal" style="text-align:center; font-size: 8pt">
							<xsl:value-of select="4"/>
						</td>
						<td class="bottom-right-normal" style="text-align:center; font-size: 8pt">
							<xsl:value-of select="5"/>
						</td>
						<td class="bottom-right-normal" style="text-align:center; font-size: 8pt">
							<xsl:value-of select="6"/>
						</td>
						<td class="right-bottom-mixed" style="text-align:center; font-size: 8pt">
							<xsl:value-of select="7"/>
						</td>
						<td class="bottom-right-normal" style="text-align:center; font-size: 8pt">
							<xsl:value-of select="8"/>
						</td>
						<td class="bottom-right-normal" style="text-align:center; font-size: 8pt">
							<xsl:value-of select="9"/>
						</td>
						<td class="bottom-normal" style="text-align:center; font-size: 8pt">
							<xsl:value-of select="10"/>
						</td>
					</tr>
					<tr>
						<td class="right-normal" style="font-size:10pt; text-align:center">
							<xsl:choose>
								<xsl:when test="Jednostka/WK">
									<xsl:value-of select="Jednostka/WK"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="../../WK"/>
								</xsl:otherwise>
							</xsl:choose>
							<!--<xsl:value-of select="../../WK"/>-->
						</td>
						<td class="right-normal" style="font-size:10pt; text-align:center">
							<xsl:choose>
								<xsl:when test="Jednostka/PK">
									<xsl:value-of select="Jednostka/PK"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="../../PK"/>
								</xsl:otherwise>
							</xsl:choose>
							<!--<xsl:value-of select="../../PK"/>-->
						</td>
						<td class="right-normal" style="font-size:10pt; text-align:center">
							<xsl:choose>
								<xsl:when test="Jednostka/GK">
									<xsl:value-of select="Jednostka/GK"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="../../GK"/>
								</xsl:otherwise>
							</xsl:choose>
							<!--<xsl:value-of select="../../GK"/>-->
						</td>
						<td class="right-normal" style="font-size:10pt; text-align:center">
							<xsl:choose>
								<xsl:when test="Jednostka/GT">
									<xsl:value-of select="Jednostka/GT"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="../../GT"/>
								</xsl:otherwise>
							</xsl:choose>
							<!--<xsl:value-of select="../../GT"/>-->
						</td>
						<td style="font-size:10pt; text-align:center; border-right: 1px solid black">
							<xsl:choose>
								<xsl:when test="Jednostka/KodMSWiA">
									<xsl:value-of select="Jednostka/KodMSWiA"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:choose>
										<xsl:when test="../../KodMSWiA">
											<xsl:value-of select="../../KodMSWiA"/>
										</xsl:when>
										<xsl:otherwise>
											<xsl:value-of select="$nbsp"/>
										</xsl:otherwise>
									</xsl:choose>
								</xsl:otherwise>
							</xsl:choose>
						</td>
						<td style="font-size:10pt; text-align:center; border-right: 1px solid black">
							<xsl:value-of select="$nbsp"/>
						</td>
						<td style="font-size:10pt; text-align:center; border-right: 4px solid black">
							<xsl:choose>
								<xsl:when test="Naglowek/SymbolPozabudzetowy">
									<xsl:value-of select="Naglowek/SymbolPozabudzetowy"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="$nbsp"/>
								</xsl:otherwise>
							</xsl:choose>
						</td>
						<td style="font-size:10pt; text-align:center; border-right: 1px solid black">
							<xsl:value-of select="$nbsp"/>
						</td>
						<td style="font-size:10pt; text-align:center; border-right: 1px solid black">
							<xsl:value-of select="Naglowek/Dzial"/>
						</td>
						<td style="font-size:10pt; text-align:center">
							<xsl:value-of select="Naglowek/Rozdzial"/>
						</td>
					</tr>
				</tbody>
			</table>
			<div style="display: block; margin-bottom: 40px">
				<table cellpadding="0" cellspacing="0">
					<tbody>
						<tr>
							<td style="width: 450px">
								<div style="font-size: 10pt; font-weight: bold; margin-left: 5px">A.</div>
							</td>
							<td style="width: 120px">
								<!-- <div style="font-size: 9pt">strona 1</div> -->
							</td>
							<td style="width: 350px">
								<!-- <div style="font-size: 9pt">sprawozdania Rb-30, Dział <xsl:value-of select="Naglowek/Dzial"/>, Rozdział <xsl:value-of select="Naglowek/Rozdzial"/>, <xsl:value-of select="../../Nazwa"/>
								</div> -->
							</td>
						</tr>
					</tbody>
				</table>
				<table cellpadding="0" cellspacing="0" class="all-bold" style="margin-bottom: 10px">
					<tbody>
						<tr>
							<td rowspan="2" class="bottom-right-mixed" style="font-size: 10pt; text-align: center; width: 80px">Kod pozycji</td>
							<td rowspan="2" class="bottom-right-mixed" style="font-size: 10pt; text-align: center; width: 250px">Paragraf</td>
							<td colspan="2" class="bottom-normal" style="font-size: 10pt; text-align: center">Przychody</td>
						</tr>
						<tr>
							<td class="bottom-right-mixed" style="font-size: 10pt; text-align: center; width: 350px">plan</td>
							<td class="bottom-bold" style="font-size: 10pt; text-align: center; width: 350px">wykonanie</td>
						</tr>
						<tr>
							<td class="bottom-right-mixed" style="text-align:center; font-size: 8pt">
								<xsl:value-of select="11"/>
							</td>
							<td class="bottom-right-mixed" style="text-align:center; font-size: 8pt">
								<xsl:value-of select="12"/>
							</td>
							<td class="bottom-right-mixed" style="text-align:center; font-size: 8pt">
								<xsl:value-of select="13"/>
							</td>
							<td class="bottom-bold" style="text-align:center; font-size: 8pt">
								<xsl:value-of select="14"/>
							</td>
						</tr>
						<xsl:for-each select="PrzychodyPozycje/Pozycja">
							<tr>
								<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
									<xsl:value-of select="'G'"/>
								</td>
								<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
									<xsl:value-of select="concat(Paragraf, P4)"/>
								</td>
								<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; padding: 3px">
									<xsl:choose>
										<xsl:when test="P">
											<xsl:value-of select="format-number(P, '#&#160;##0,00')"/>
										</xsl:when>
										<xsl:otherwise>
											<xsl:value-of select="'0,00'"/>
										</xsl:otherwise>
									</xsl:choose>
								</td>
								<td class="bottom-normal" style="text-align: right; font-size: 8pt; padding: 3px">
									<xsl:choose>
										<xsl:when test="W">
											<xsl:value-of select="format-number(W, '#&#160;##0,00')"/>
										</xsl:when>
										<xsl:otherwise>
											<xsl:value-of select="'0,00'"/>
										</xsl:otherwise>
									</xsl:choose>
								</td>
							</tr>
						</xsl:for-each>
						<xsl:apply-templates select="PrzychodyPodsumowanie">
							<xsl:with-param name="SymPoz" select="Naglowek/SymbolPozabudzetowy"/>
							<xsl:with-param name="Dzial" select="Naglowek/Dzial"/>
							<xsl:with-param name="Rozdzial" select="Naglowek/Rozdzial"/>
						</xsl:apply-templates>
					</tbody>
				</table>
				<div style="margin-bottom: 20px">
					<div style="display: block; font-size: 7pt;margin-bottom:0">
						<sup>1)</sup> niepotrzebne skreślić
          </div>
					<div style="display: block; font-size: 7pt;margin-bottom:0">
						<sup>2)</sup> dotyczy jednostek samorządu terytorialnego i ich związków
          </div>
					<div style="display: block; font-size: 7pt">
						<sup>3)</sup> dotyczy państwowych zakładów budżetowych
          </div>
				</div>
				<table cellpadding="0" cellspacing="0">
					<tbody>
						<tr>
							<td style="width: 450px">
								<div style="font-size: 10pt; font-weight: bold; margin-left: 5px">B.</div>
							</td>
							<td style="width: 120px">
								<!-- <div style="font-size: 9pt">strona 2</div> -->
							</td>
							<td style="width: 350px">
								<!-- <div style="font-size: 9pt">sprawozdania Rb-30, Dział <xsl:value-of select="Naglowek/Dzial"/>, Rozdział <xsl:value-of select="Naglowek/Rozdzial"/>, <xsl:value-of select="../../Nazwa"/>
								</div> -->
							</td>
						</tr>
					</tbody>
				</table>
				<table cellpadding="0" cellspacing="0" class="all-bold" style="margin-bottom: 30px">
					<tbody>
						<tr>
							<td rowspan="2" class="bottom-right-mixed" style="font-size: 10pt; text-align: center; width: 80px">Kod pozycji</td>
							<td rowspan="2" class="bottom-right-mixed" style="font-size: 10pt; text-align: center; width: 250px">Paragraf</td>
							<td colspan="2" class="bottom-normal" style="font-size: 10pt; text-align: center">Koszty i inne obciążenia</td>
						</tr>
						<tr>
							<td class="bottom-right-mixed" style="font-size: 10pt; text-align: center; width: 350px">plan</td>
							<td class="bottom-bold" style="font-size: 10pt; text-align: center; width: 350px">wykonanie</td>
						</tr>
						<tr>
							<td class="bottom-right-mixed" style="text-align:center; font-size: 8pt">
								<xsl:value-of select="11"/>
							</td>
							<td class="bottom-right-mixed" style="text-align:center; font-size: 8pt">
								<xsl:value-of select="12"/>
							</td>
							<td class="bottom-right-mixed" style="text-align:center; font-size: 8pt">
								<xsl:value-of select="13"/>
							</td>
							<td class="bottom-bold" style="text-align:center; font-size: 8pt">
								<xsl:value-of select="14"/>
							</td>
						</tr>
						<xsl:for-each select="KosztyPozycje/Pozycja">
							<tr>
								<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
									<xsl:value-of select="'M'"/>
								</td>
								<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
									<xsl:value-of select="concat(Paragraf, P4)"/>
								</td>
								<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; padding: 3px">
									<xsl:choose>
										<xsl:when test="P">
											<xsl:value-of select="format-number(P, '#&#160;##0,00')"/>
										</xsl:when>
										<xsl:otherwise>
											<xsl:value-of select="'0,00'"/>
										</xsl:otherwise>
									</xsl:choose>
								</td>
								<td class="bottom-normal" style="text-align: right; font-size: 8pt; padding: 3px">
									<xsl:choose>
										<xsl:when test="W">
											<xsl:value-of select="format-number(W, '#&#160;##0,00')"/>
										</xsl:when>
										<xsl:otherwise>
											<xsl:value-of select="'0,00'"/>
										</xsl:otherwise>
									</xsl:choose>
								</td>
							</tr>
						</xsl:for-each>
						<xsl:apply-templates select="KosztyPodsumowanie">
							<xsl:with-param name="SymPoz" select="Naglowek/SymbolPozabudzetowy"/>
							<xsl:with-param name="Dzial" select="Naglowek/Dzial"/>
							<xsl:with-param name="Rozdzial" select="Naglowek/Rozdzial"/>
						</xsl:apply-templates>
					</tbody>
				</table>
				<table cellpadding="0" cellspacing="0">
					<tbody>
						<tr>
							<td style="width: 450px">
								<div style="font-size: 10pt; font-weight: bold; margin-left: 5px">C.</div>
							</td>
							<td style="width: 120px">
								<!-- <div style="font-size: 9pt">strona 3</div> -->
							</td>
							<td style="width: 350px">
								<!-- <div style="font-size: 9pt">sprawozdania Rb-30, Dział <xsl:value-of select="Naglowek/Dzial"/>, Rozdział <xsl:value-of select="Naglowek/Rozdzial"/>, <xsl:value-of select="../../Nazwa"/>
								</div> -->
							</td>
						</tr>
					</tbody>
				</table>
				<table cellpadding="0" cellspacing="0" class="all-bold" style="margin-bottom: 10px">
					<tbody>
						<tr>
							<td class="bottom-right-mixed" style="font-size: 10pt; text-align: center; width: 80px">Kod pozycji</td>
							<td class="bottom-right-mixed" style="font-size: 10pt; text-align: center; width: 90px">Symbol</td>
							<td class="bottom-right-mixed" style="font-size: 10pt; text-align: center; width: 360px; min-width: 320px">Wyszczególnienie</td>
							<td class="bottom-right-mixed" style="font-size: 10pt; text-align: center; width: 260px; min-width: 220px">Stan na początek okresu sprawozdawczego</td>
							<td class="bottom-bold" style="font-size: 10pt; text-align: center; width: 260px; min-width: 220px">Stan na koniec okresu sprawozdawczego</td>
						</tr>
						<tr>
							<td class="bottom-right-mixed" style="text-align:center; font-size: 8pt">
								<xsl:value-of select="11"/>
							</td>
							<td class="bottom-right-mixed" style="text-align:center; font-size: 8pt">
								<xsl:value-of select="12"/>
							</td>
							<td class="bottom-right-mixed" style="text-align: center; font-size: 8pt">
								<xsl:value-of select="$nbsp"/>
							</td>
							<td class="bottom-right-mixed" style="text-align:center; font-size: 8pt">
								<xsl:value-of select="13"/>
							</td>
							<td class="bottom-bold" style="text-align:center; font-size: 8pt">
								<xsl:value-of select="14"/>
							</td>
						</tr>
						<xsl:call-template name="Rb-30_danePozycjeC">
							<xsl:with-param name="kod" select="'W'"/>
							<xsl:with-param name="symbol" select="'010'"/>
							<xsl:with-param name="wyszczeg" select="'Środki pieniężne (w tym środki w kasie)'"/>
						</xsl:call-template>
						<xsl:call-template name="Rb-30_danePozycjeC">
							<xsl:with-param name="kod" select="'W'"/>
							<xsl:with-param name="symbol" select="'020'"/>
							<xsl:with-param name="wyszczeg" select="'Należności netto 1)'"/>
						</xsl:call-template>
						<xsl:call-template name="Rb-30_danePozycjeC">
							<xsl:with-param name="kod" select="'W'"/>
							<xsl:with-param name="symbol" select="'021'"/>
							<xsl:with-param name="wyszczeg" select="'Kwota odpisu aktualizującego należności'"/>
						</xsl:call-template>
						<xsl:call-template name="Rb-30_danePozycjeC">
							<xsl:with-param name="kod" select="'W'"/>
							<xsl:with-param name="symbol" select="'022'"/>
							<xsl:with-param name="wyszczeg" select="'Kwota odsetek od należnosci niezapłaconych w terminie'"/>
						</xsl:call-template>
						<xsl:call-template name="Rb-30_danePozycjeC">
							<xsl:with-param name="kod" select="'W'"/>
							<xsl:with-param name="symbol" select="'030'"/>
							<xsl:with-param name="wyszczeg" select="'Pozostałe środki obrotowe'"/>
						</xsl:call-template>
						<xsl:call-template name="Rb-30_danePozycjeC">
							<xsl:with-param name="kod" select="'W'"/>
							<xsl:with-param name="symbol" select="'040'"/>
							<xsl:with-param name="wyszczeg" select="'Zobowiązania i inne rozliczenia'"/>
						</xsl:call-template>
						<tr>
							<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
								<xsl:value-of select="'W'"/>
							</td>
							<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
								<xsl:value-of select="'041'"/>
							</td>
							<td class="bottom-right-normal" style="text-align: left; font-size: 8pt; padding: 3px">
								<div style="margin: 0">w tym</div>
								<div style="margin: 0">wobec inwestycji finansowanych z:</div>
								<div style="margin: 0 0 0 15px">środków własnych</div>
							</td>
							<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; padding: 3px">
								<xsl:choose>
									<xsl:when test="Stan/Pozycja[child::Kod = 'W' and child::Symbol = '041']/P">
										<xsl:value-of select="format-number(Stan/Pozycja[child::Kod = 'W' and child::Symbol = '041']/P, '#&#160;##0,00')"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="'0,00'"/>
									</xsl:otherwise>
								</xsl:choose>
							</td>
							<td class="bottom-normal" style="text-align: right; font-size: 8pt; padding: 3px">
								<xsl:choose>
									<xsl:when test="Stan/Pozycja[child::Kod = 'W' and child::Symbol = '041']/K">
										<xsl:value-of select="format-number(Stan/Pozycja[child::Kod = 'W' and child::Symbol = '041']/K, '#&#160;##0,00')"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="'0,00'"/>
									</xsl:otherwise>
								</xsl:choose>
							</td>
						</tr>
						<tr>
							<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
								<xsl:value-of select="'W'"/>
							</td>
							<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
								<xsl:value-of select="'042'"/>
							</td>
							<td class="bottom-right-normal" style="text-align: left; font-size: 8pt; padding: 3px">
								<div style="margin: 0 0 0 15px">dotacji</div>
							</td>
							<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; padding: 3px">
								<xsl:choose>
									<xsl:when test="Stan/Pozycja[child::Kod = 'W' and child::Symbol = '042']/P">
										<xsl:value-of select="format-number(Stan/Pozycja[child::Kod = 'W' and child::Symbol = '042']/P, '#&#160;##0,00')"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="'0,00'"/>
									</xsl:otherwise>
								</xsl:choose>
							</td>
							<td class="bottom-normal" style="text-align: right; font-size: 8pt; padding: 3px">
								<xsl:choose>
									<xsl:when test="Stan/Pozycja[child::Kod = 'W' and child::Symbol = '042']/K">
										<xsl:value-of select="format-number(Stan/Pozycja[child::Kod = 'W' and child::Symbol = '042']/K, '#&#160;##0,00')"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="'0,00'"/>
									</xsl:otherwise>
								</xsl:choose>
							</td>
						</tr>
						<tr>
							<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
								<xsl:value-of select="'W'"/>
							</td>
							<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
								<xsl:value-of select="'043'"/>
							</td>
							<td class="bottom-right-normal" style="text-align: left; font-size: 8pt; padding: 3px">
								<div style="margin: 0 0 0 15px">środków z innych źródeł</div>
							</td>
							<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; padding: 3px">
								<xsl:choose>
									<xsl:when test="Stan/Pozycja[child::Kod = 'W' and child::Symbol = '043']/P">
										<xsl:value-of select="format-number(Stan/Pozycja[child::Kod = 'W' and child::Symbol = '043']/P, '#&#160;##0,00')"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="'0,00'"/>
									</xsl:otherwise>
								</xsl:choose>
							</td>
							<td class="bottom-normal" style="text-align: right; font-size: 8pt; padding: 3px">
								<xsl:choose>
									<xsl:when test="Stan/Pozycja[child::Kod = 'W' and child::Symbol = '043']/K">
										<xsl:value-of select="format-number(Stan/Pozycja[child::Kod = 'W' and child::Symbol = '043']/K, '#&#160;##0,00')"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="'0,00'"/>
									</xsl:otherwise>
								</xsl:choose>
							</td>
						</tr>
						<xsl:call-template name="Rb-30_danePozycjeC">
							<xsl:with-param name="kod" select="'W'"/>
							<xsl:with-param name="symbol" select="'070'"/>
							<xsl:with-param name="wyszczeg" select="'Stan środków obrotowych netto (W010+W020+W030-W040)'"/>
							<xsl:with-param name="pogrWyszczeg" select="true()"/>
						</xsl:call-template>
						<tr>
							<td class="bottom-right-normal"/>
							<td class="bottom-right-normal"/>
							<td class="bottom-right-normal" style="text-align: left; font-size: 8pt; font-weight: bold; padding: 3px">Dane uzupełniające dot. należności i zobowiązań</td>
							<td class="bottom-right-normal" style="text-align: center; font-size: 9pt">X</td>
							<td class="bottom-right-normal" style="text-align: center; font-size: 9pt">X</td>
						</tr>
						<xsl:call-template name="Rb-30_danePozycjeC">
							<xsl:with-param name="kod" select="'W'"/>
							<xsl:with-param name="symbol" select="'080'"/>
							<xsl:with-param name="wyszczeg" select="'Należności od pracowników'"/>
						</xsl:call-template>
						<xsl:call-template name="Rb-30_danePozycjeC">
							<xsl:with-param name="kod" select="'W'"/>
							<xsl:with-param name="symbol" select="'081'"/>
							<xsl:with-param name="wyszczeg" select="'Należności z tytułu sprzedaży dóbr i usług'"/>
						</xsl:call-template>
						<xsl:call-template name="Rb-30_danePozycjeC">
							<xsl:with-param name="kod" select="'W'"/>
							<xsl:with-param name="symbol" select="'090'"/>
							<xsl:with-param name="wyszczeg" select="'Zobowiązania z tytułu wynagrodzeń'"/>
						</xsl:call-template>
						<xsl:call-template name="Rb-30_danePozycjeC">
							<xsl:with-param name="kod" select="'W'"/>
							<xsl:with-param name="symbol" select="'091'"/>
							<xsl:with-param name="wyszczeg" select="'Zobowiązania z tytułu składek na ubezpieczenia społeczne'"/>
						</xsl:call-template>
						<tr>
							<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
								<xsl:value-of select="'W'"/>
							</td>
							<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
								<xsl:value-of select="'092'"/>
							</td>
							<td class="bottom-right-normal" style="text-align: left; font-size: 8pt; padding: 3px">
								<div style="margin: 0">w tym z tytułu:</div>
								<div style="margin: 0 0 0 15px">składek na FUS</div>
							</td>
							<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; padding: 3px">
								<xsl:choose>
									<xsl:when test="Stan/Pozycja[child::Kod = 'W' and child::Symbol = '092']/P">
										<xsl:value-of select="format-number(Stan/Pozycja[child::Kod = 'W' and child::Symbol = '092']/P, '#&#160;##0,00')"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="'0,00'"/>
									</xsl:otherwise>
								</xsl:choose>
							</td>
							<td class="bottom-normal" style="text-align: right; font-size: 8pt; padding: 3px">
								<xsl:choose>
									<xsl:when test="Stan/Pozycja[child::Kod = 'W' and child::Symbol = '092']/K">
										<xsl:value-of select="format-number(Stan/Pozycja[child::Kod = 'W' and child::Symbol = '092']/K, '#&#160;##0,00')"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="'0,00'"/>
									</xsl:otherwise>
								</xsl:choose>
							</td>
						</tr>
						<tr>
							<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
								<xsl:value-of select="'W'"/>
							</td>
							<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
								<xsl:value-of select="'093'"/>
							</td>
							<td class="bottom-right-normal" style="text-align: left; font-size: 8pt; padding: 3px">
								<div style="margin: 0 0 0 15px">składek na Fundusz Pracy</div>
							</td>
							<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; padding: 3px">
								<xsl:choose>
									<xsl:when test="Stan/Pozycja[child::Kod = 'W' and child::Symbol = '093']/P">
										<xsl:value-of select="format-number(Stan/Pozycja[child::Kod = 'W' and child::Symbol = '093']/P, '#&#160;##0,00')"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="'0,00'"/>
									</xsl:otherwise>
								</xsl:choose>
							</td>
							<td class="bottom-normal" style="text-align: right; font-size: 8pt; padding: 3px">
								<xsl:choose>
									<xsl:when test="Stan/Pozycja[child::Kod = 'W' and child::Symbol = '093']/K">
										<xsl:value-of select="format-number(Stan/Pozycja[child::Kod = 'W' and child::Symbol = '093']/K, '#&#160;##0,00')"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="'0,00'"/>
									</xsl:otherwise>
								</xsl:choose>
							</td>
						</tr>
						<xsl:call-template name="Rb-30_danePozycjeC">
							<xsl:with-param name="kod" select="'W'"/>
							<xsl:with-param name="symbol" select="'094'"/>
							<xsl:with-param name="wyszczeg" select="'Zobowiązania z tytułu zakupu dóbr i usług'"/>
							<xsl:with-param name="ostWiersz" select="true()"/>
						</xsl:call-template>
					</tbody>
				</table>
				<div style="margin-bottom: 20px">
					<div style="display: block; font-size: 7pt">
						<sup>1)</sup> Kwota należności pomniejszona o odpis aktualizujący należności oraz odsetki od należności niezapłaconych w terminie
          </div>
				</div>
				<table cellpadding="0" cellspacing="0">
					<tbody>
						<tr>
							<td style="width: 450px">
								<div style="font-size: 10pt; font-weight: bold; margin-left: 5px; margin-bottom: 10px">D. DANE UZUPEŁNIAJĄCE</div>
							</td>
							<td style="width: 120px">
								<!-- <div style="font-size: 9pt">strona 4</div> -->
							</td>
							<td style="width: 350px">
								<!-- <div style="font-size: 9pt">sprawozdania Rb-30, Dział <xsl:value-of select="Naglowek/Dzial"/>, Rozdział <xsl:value-of select="Naglowek/Rozdzial"/>, <xsl:value-of select="../../Nazwa"/>
								</div> -->
							</td>
						</tr>
						<tr>
							<td colspan="3">
								<div style="font-size: 9pt; font-weight: bold; margin-left: 5px">1. Informacja o finansowaniu inwestycji zakładu budżetowego</div>
							</td>
						</tr>
					</tbody>
				</table>
				<table cellpadding="0" cellspacing="0" class="all-bold" style="margin-bottom: 20px">
					<tbody>
						<tr>
							<td class="bottom-right-mixed" style="font-size: 10pt; text-align: center; width: 80px">Kod pozycji</td>
							<td class="bottom-right-mixed" style="font-size: 10pt; text-align: center; width: 90px">Symbol</td>
							<td class="bottom-right-mixed" style="font-size: 10pt; text-align: center; width: 360px; min-width: 320px">Wyszczególnienie</td>
							<td class="bottom-right-mixed" style="font-size: 10pt; text-align: center; width: 260px; min-width: 220px">Plan</td>
							<td class="bottom-bold" style="font-size: 10pt; text-align: center; width: 260px; min-width: 220px">Wykonanie na koniec okresu sprawozdawczego</td>
						</tr>
						<tr>
							<td class="bottom-right-mixed" style="text-align:center; font-size: 8pt">
								<xsl:value-of select="11"/>
							</td>
							<td class="bottom-right-mixed" style="text-align:center; font-size: 8pt">
								<xsl:value-of select="12"/>
							</td>
							<td class="bottom-right-mixed" style="text-align: center; font-size: 8pt">
								<xsl:value-of select="$nbsp"/>
							</td>
							<td class="bottom-right-mixed" style="text-align:center; font-size: 8pt">
								<xsl:value-of select="13"/>
							</td>
							<td class="bottom-bold" style="text-align:center; font-size: 8pt">
								<xsl:value-of select="14"/>
							</td>
						</tr>
						<tr>
							<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
								<xsl:value-of select="'U'"/>
							</td>
							<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
								<xsl:value-of select="'100'"/>
							</td>
							<td class="bottom-right-normal" style="text-align: left; font-size: 8pt; padding: 3px">
								<xsl:value-of select="'Wydatki inwestycyjne'"/>
							</td>
							<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; padding: 3px">
								<xsl:choose>
									<xsl:when test="Finansowanie/Pozycja[child::Kod = 'U' and child::Symbol = '100']/P">
										<xsl:value-of select="format-number(Finansowanie/Pozycja[child::Kod = 'U' and child::Symbol = '100']/P, '#&#160;##0,00')"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="'0,00'"/>
									</xsl:otherwise>
								</xsl:choose>
							</td>
							<td class="bottom-normal" style="text-align: right; font-size: 8pt; padding: 3px">
								<xsl:choose>
									<xsl:when test="Finansowanie/Pozycja[child::Kod = 'U' and child::Symbol = '100']/W">
										<xsl:value-of select="format-number(Finansowanie/Pozycja[child::Kod = 'U' and child::Symbol = '100']/W, '#&#160;##0,00')"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="'0,00'"/>
									</xsl:otherwise>
								</xsl:choose>
							</td>
						</tr>
						<tr>
							<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
								<xsl:value-of select="'U'"/>
							</td>
							<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
								<xsl:value-of select="'200'"/>
							</td>
							<td class="bottom-right-normal" style="text-align: left; font-size: 8pt; padding: 3px">
								<xsl:value-of select="'Źródła finansowania wydatków inwestycyjnych:'"/>
							</td>
							<td class="bottom-right-normal" style="text-align: center; font-size: 9pt">X</td>
							<td class="bottom-right-normal" style="text-align: center; font-size: 9pt">X</td>
						</tr>
						<tr>
							<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
								<xsl:value-of select="'U'"/>
							</td>
							<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
								<xsl:value-of select="'201'"/>
							</td>
							<td class="bottom-right-normal" style="text-align: left; font-size: 8pt; padding: 3px">
								<div style="margin: 0 0 0 15px">- środki z lat ubiegłych</div>
							</td>
							<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; padding: 3px">
								<xsl:choose>
									<xsl:when test="Finansowanie/Pozycja[child::Kod = 'U' and child::Symbol = '201']/P">
										<xsl:value-of select="format-number(Finansowanie/Pozycja[child::Kod = 'U' and child::Symbol = '201']/P, '#&#160;##0,00')"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="'0,00'"/>
									</xsl:otherwise>
								</xsl:choose>
							</td>
							<td class="bottom-normal" style="text-align: right; font-size: 8pt; padding: 3px">
								<xsl:choose>
									<xsl:when test="Finansowanie/Pozycja[child::Kod = 'U' and child::Symbol = '201']/W">
										<xsl:value-of select="format-number(Finansowanie/Pozycja[child::Kod = 'U' and child::Symbol = '201']/W, '#&#160;##0,00')"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="'0,00'"/>
									</xsl:otherwise>
								</xsl:choose>
							</td>
						</tr>
						<tr>
							<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
								<xsl:value-of select="'U'"/>
							</td>
							<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
								<xsl:value-of select="'202'"/>
							</td>
							<td class="bottom-right-normal" style="text-align: left; font-size: 8pt; padding: 3px">
								<div style="margin: 0 0 0 15px">- dotacje celowe</div>
							</td>
							<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; padding: 3px">
								<xsl:choose>
									<xsl:when test="Finansowanie/Pozycja[child::Kod = 'U' and child::Symbol = '202']/P">
										<xsl:value-of select="format-number(Finansowanie/Pozycja[child::Kod = 'U' and child::Symbol = '202']/P, '#&#160;##0,00')"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="'0,00'"/>
									</xsl:otherwise>
								</xsl:choose>
							</td>
							<td class="bottom-normal" style="text-align: right; font-size: 8pt; padding: 3px">
								<xsl:choose>
									<xsl:when test="Finansowanie/Pozycja[child::Kod = 'U' and child::Symbol = '202']/W">
										<xsl:value-of select="format-number(Finansowanie/Pozycja[child::Kod = 'U' and child::Symbol = '202']/W, '#&#160;##0,00')"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="'0,00'"/>
									</xsl:otherwise>
								</xsl:choose>
							</td>
						</tr>
						<tr>
							<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
								<xsl:value-of select="'U'"/>
							</td>
							<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
								<xsl:value-of select="'203'"/>
							</td>
							<td class="bottom-right-normal" style="text-align: left; font-size: 8pt; padding: 3px">
								<div style="margin: 0 0 0 15px">- środki własne</div>
							</td>
							<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; padding: 3px">
								<xsl:choose>
									<xsl:when test="Finansowanie/Pozycja[child::Kod = 'U' and child::Symbol = '203']/P">
										<xsl:value-of select="format-number(Finansowanie/Pozycja[child::Kod = 'U' and child::Symbol = '203']/P, '#&#160;##0,00')"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="'0,00'"/>
									</xsl:otherwise>
								</xsl:choose>
							</td>
							<td class="bottom-normal" style="text-align: right; font-size: 8pt; padding: 3px">
								<xsl:choose>
									<xsl:when test="Finansowanie/Pozycja[child::Kod = 'U' and child::Symbol = '203']/W">
										<xsl:value-of select="format-number(Finansowanie/Pozycja[child::Kod = 'U' and child::Symbol = '203']/W, '#&#160;##0,00')"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="'0,00'"/>
									</xsl:otherwise>
								</xsl:choose>
							</td>
						</tr>
						<tr>
							<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
								<xsl:value-of select="'U'"/>
							</td>
							<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
								<xsl:value-of select="'204'"/>
							</td>
							<td class="bottom-right-normal" style="text-align: left; font-size: 8pt; padding: 3px">
								<div style="margin: 0 0 0 15px">- inne środki</div>
							</td>
							<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; padding: 3px">
								<xsl:choose>
									<xsl:when test="Finansowanie/Pozycja[child::Kod = 'U' and child::Symbol = '204']/P">
										<xsl:value-of select="format-number(Finansowanie/Pozycja[child::Kod = 'U' and child::Symbol = '204']/P, '#&#160;##0,00')"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="'0,00'"/>
									</xsl:otherwise>
								</xsl:choose>
							</td>
							<td class="bottom-normal" style="text-align: right; font-size: 8pt; padding: 3px">
								<xsl:choose>
									<xsl:when test="Finansowanie/Pozycja[child::Kod = 'U' and child::Symbol = '204']/W">
										<xsl:value-of select="format-number(Finansowanie/Pozycja[child::Kod = 'U' and child::Symbol = '204']/W, '#&#160;##0,00')"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="'0,00'"/>
									</xsl:otherwise>
								</xsl:choose>
							</td>
						</tr>
						<tr>
							<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
								<xsl:value-of select="'U'"/>
							</td>
							<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
								<xsl:value-of select="'300'"/>
							</td>
							<td class="bottom-right-normal" style="text-align: left; font-size: 8pt; padding: 3px">
								<xsl:value-of select="'Zobowiązania dotyczące inwestycji:'"/>
							</td>
							<td class="bottom-right-normal" style="text-align: center; font-size: 9pt">X</td>
							<td class="bottom-right-normal" style="text-align: center; font-size: 9pt">X</td>
						</tr>
						<tr>
							<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
								<xsl:value-of select="'U'"/>
							</td>
							<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
								<xsl:value-of select="'301'"/>
							</td>
							<td class="bottom-right-normal" style="text-align: left; font-size: 8pt; padding: 3px">
								<div style="margin: 0 0 0 15px">- na początek okresu sprawozdawczego</div>
							</td>
							<td class="bottom-right-normal" style="text-align: center; font-size: 9pt">X</td>
							<td class="bottom-normal" style="text-align: right; font-size: 8pt; padding: 3px">
								<xsl:choose>
									<xsl:when test="Finansowanie/Pozycja[child::Kod = 'U' and child::Symbol = '301']/W">
										<xsl:value-of select="format-number(Finansowanie/Pozycja[child::Kod = 'U' and child::Symbol = '301']/W, '#&#160;##0,00')"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="'0,00'"/>
									</xsl:otherwise>
								</xsl:choose>
							</td>
						</tr>
						<tr>
							<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
								<xsl:value-of select="'U'"/>
							</td>
							<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
								<xsl:value-of select="'302'"/>
							</td>
							<td class="bottom-right-normal" style="text-align: left; font-size: 8pt; padding: 3px">
								<div style="margin: 0 0 0 15px">- na koniec okresu sprawozdawczego</div>
							</td>
							<td class="bottom-right-normal" style="text-align: center; font-size: 9pt">X</td>
							<td class="bottom-normal" style="text-align: right; font-size: 8pt; padding: 3px">
								<xsl:choose>
									<xsl:when test="Finansowanie/Pozycja[child::Kod = 'U' and child::Symbol = '302']/W">
										<xsl:value-of select="format-number(Finansowanie/Pozycja[child::Kod = 'U' and child::Symbol = '302']/W, '#&#160;##0,00')"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="'0,00'"/>
									</xsl:otherwise>
								</xsl:choose>
							</td>
						</tr>
						<tr>
							<td class="right-normal" style="text-align: center; font-size: 8pt">
								<xsl:value-of select="'U'"/>
							</td>
							<td class="right-normal" style="text-align: center; font-size: 8pt">
								<xsl:value-of select="'303'"/>
							</td>
							<td class="right-normal" style="text-align: left; font-size: 8pt; padding: 3px">Zobowiązania wobec budżetu z tytułu zwrotu dotacji na inwestycje</td>
							<td class="right-normal" style="text-align: center; font-size: 9pt">X</td>
							<td class="bottom-normal" style="text-align: right; font-size: 8pt; padding: 3px">
								<xsl:choose>
									<xsl:when test="Finansowanie/Pozycja[child::Kod = 'U' and child::Symbol = '303']/W">
										<xsl:value-of select="format-number(Finansowanie/Pozycja[child::Kod = 'U' and child::Symbol = '303']/W, '#&#160;##0,00')"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="'0,00'"/>
									</xsl:otherwise>
								</xsl:choose>
							</td>
						</tr>
					</tbody>
				</table>
				<table cellpadding="0" cellspacing="0">
					<tbody>
						<tr>
							<td colspan="3">
								<div style="font-size: 9pt; font-weight: bold; margin-left: 5px">2. Informacja o rozliczeniu kasowym z budżetem - w okresie od dnia 1 stycznia do końca okresu sprawozdawczego</div>
							</td>
						</tr>
					</tbody>
				</table>
				<table cellpadding="0" cellspacing="0" class="all-bold" style="margin-bottom: 60px">
					<tbody>
						<tr>
							<td class="bottom-right-mixed" style="font-size: 10pt; text-align: center; width: 80px">Kod pozycji</td>
							<td class="bottom-right-mixed" style="font-size: 10pt; text-align: center; width: 90px">Symbol</td>
							<td class="bottom-right-mixed" style="font-size: 10pt; text-align: center; width: 360px; min-width: 320px">Wyszczególnienie</td>
							<td class="bottom-right-mixed" style="font-size: 10pt; text-align: center; width: 260px; min-width: 220px">Za poprzedni rok budżetowy</td>
							<td class="bottom-bold" style="font-size: 10pt; text-align: center; width: 260px; min-width: 220px">Za okres sprawozdawczy</td>
						</tr>
						<tr>
							<td class="bottom-right-mixed" style="text-align:center; font-size: 8pt">
								<xsl:value-of select="11"/>
							</td>
							<td class="bottom-right-mixed" style="text-align:center; font-size: 8pt">
								<xsl:value-of select="12"/>
							</td>
							<td class="bottom-right-mixed" style="text-align: center; font-size: 8pt">
								<xsl:value-of select="$nbsp"/>
							</td>
							<td class="bottom-right-mixed" style="text-align:center; font-size: 8pt">
								<xsl:value-of select="13"/>
							</td>
							<td class="bottom-bold" style="text-align:center; font-size: 8pt">
								<xsl:value-of select="14"/>
							</td>
						</tr>
						<xsl:call-template name="Rb-30_danePozycjeE">
							<xsl:with-param name="kod" select="'Z'"/>
							<xsl:with-param name="symbol" select="'100'"/>
							<xsl:with-param name="wyszczeg" select="'Podatek dochodowy od osób prawnych'"/>
						</xsl:call-template>
						<xsl:call-template name="Rb-30_danePozycjeE">
							<xsl:with-param name="kod" select="'Z'"/>
							<xsl:with-param name="symbol" select="'101'"/>
							<xsl:with-param name="wyszczeg" select="'Wpłata nadwyżki środków obrotowych'"/>
						</xsl:call-template>
						<xsl:call-template name="Rb-30_danePozycjeE">
							<xsl:with-param name="kod" select="'Z'"/>
							<xsl:with-param name="symbol" select="'102'"/>
							<xsl:with-param name="wyszczeg" select="'Podatek VAT od otrzymanych dotacji przedmiotowych'"/>
							<xsl:with-param name="ostWiersz" select="true()"/>
						</xsl:call-template>
					</tbody>
				</table>
				<table cellpadding="0" cellspacing="0" class="all-bold" style="margin-bottom: 20px; width: 100%">
					<tbody>
						<tr style="height: 30px" valign="top">
							<td style="font-size: 9pt; font-weight: bold; text-align:left; padding: 3px 10px; margin-left: 5px; margin-bottom: 25px">Wyjaśnienia do sprawozdania Rb-30</td>
						</tr>
						<tr style="min-height: 50px; height: 70px" valign="top">
							<td style="text-align: left; font-size: 8pt; padding: 3px 10px; border-width: 4px 0 0 0; border-style: solid; border-color: black">
								<xsl:value-of select="Naglowek/Uwagi"/>
							</td>
						</tr>
					</tbody>
				</table>
				<!-- ewentualne uwagi z pozycji -->
				<xsl:if test="PrzychodyPozycje/Pozycja[child::Uwagi] or PrzychodyPodsumowanie/Pozycja[child::Uwagi]">
					<table cellpadding="0" cellspacing="0" class="all-bold" style="margin-bottom: 20px; width: 100%">
						<tbody>
							<tr>
								<td colspan="4" style="text-align: center; font-size: 9pt; font-weight: bold; padding: 3px 10px">
									<div>Uwagi do części: "Przychody"</div>
								</td>
							</tr>
							<tr>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 4px 4px 0; width: 6%">Kod pozycji</td>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 4px 4px 0; width: 30%">Paragraf</td>
								<td colspan="2" style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 0 4px 0">Uwaga</td>
							</tr>
							<xsl:for-each select="PrzychodyPozycje/Pozycja[child::Uwagi]">
								<xsl:sort select="Paragraf"/>
								<tr>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="'G'"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="concat(Paragraf, P4)"/>
									</td>
									<td colspan="2" class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:value-of select="Uwagi"/>
									</td>
								</tr>
							</xsl:for-each>
							<xsl:if test="PrzychodyPodsumowanie/Pozycja[child::Kod = 'I' and child::Symbol = '110' and child::Uwagi]">
								<tr>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="PrzychodyPodsumowanie/Pozycja[child::Kod = 'I' and child::Symbol = '110']/Kod"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="'110 (Pokrycie amortyzacji)'"/>
									</td>
									<td colspan="2" class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:value-of select="PrzychodyPodsumowanie/Pozycja[child::Kod = 'I' and child::Symbol = '110']/Uwagi"/>
									</td>
								</tr>
							</xsl:if>
							<xsl:if test="PrzychodyPodsumowanie/Pozycja[child::Kod = 'K' and child::Symbol = '100' and child::Uwagi]">
								<tr>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="PrzychodyPodsumowanie/Pozycja[child::Kod = 'K' and child::Symbol = '100']/Kod"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="'100 (Inne zwiększenia)'"/>
									</td>
									<td colspan="2" class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:value-of select="PrzychodyPodsumowanie/Pozycja[child::Kod = 'K' and child::Symbol = '100']/Uwagi"/>
									</td>
								</tr>
							</xsl:if>
							<xsl:if test="PrzychodyPodsumowanie/Pozycja[child::Kod = 'H' and child::Uwagi]">
								<tr>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="PrzychodyPodsumowanie/Pozycja[child::Kod = 'H']/Kod"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="'Razem'"/>
									</td>
									<td colspan="2" class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:value-of select="PrzychodyPodsumowanie/Pozycja[child::Kod = 'H']/Uwagi"/>
									</td>
								</tr>
							</xsl:if>
							<xsl:if test="PrzychodyPodsumowanie/Pozycja[child::Kod = 'K' and child::Symbol = '110' and child::Uwagi]">
								<tr>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="PrzychodyPodsumowanie/Pozycja[child::Kod = 'K' and child::Symbol = '110']/Kod"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="'110 (Stan środków obrotowych netto na początku okresu sprawozdawczego)'"/>
									</td>
									<td colspan="2" class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:value-of select="PrzychodyPodsumowanie/Pozycja[child::Kod = 'K' and child::Symbol = '110']/Uwagi"/>
									</td>
								</tr>
							</xsl:if>
							<xsl:if test="PrzychodyPodsumowanie/Pozycja[child::Kod = 'L' and child::Symbol = '190' and child::Uwagi]">
								<tr>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="PrzychodyPodsumowanie/Pozycja[child::Kod = 'L' and child::Symbol = '190']/Kod"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="'190 Ogółem (H+K110)'"/>
									</td>
									<td colspan="2" class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:value-of select="PrzychodyPodsumowanie/Pozycja[child::Kod = 'L' and child::Symbol = '190']/Uwagi"/>
									</td>
								</tr>
							</xsl:if>
						</tbody>
					</table>
				</xsl:if>
				<xsl:if test="KosztyPozycje/Pozycja[child::Uwagi] or KosztyPodsumowanie/Pozycja[child::Uwagi]">
					<table cellpadding="0" cellspacing="0" class="all-bold" style="margin-bottom: 20px; width: 100%">
						<tbody>
							<tr>
								<td colspan="4" style="text-align: center; font-size: 9pt; font-weight: bold; padding: 3px 10px">
									<div>Uwagi do części: "Koszty"</div>
								</td>
							</tr>
							<tr>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 4px 4px 0; width: 6%">Kod pozycji</td>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 4px 4px 0; width: 30%">Paragraf</td>
								<td colspan="2" style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 0 4px 0">Uwaga</td>
							</tr>
							<xsl:for-each select="KosztyPozycje/Pozycja[child::Uwagi]">
								<xsl:sort select="Paragraf"/>
								<tr>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="'M'"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="concat(Paragraf, P4)"/>
									</td>
									<td colspan="2" class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:value-of select="Uwagi"/>
									</td>
								</tr>
							</xsl:for-each>
							<xsl:if test="KosztyPodsumowanie/Pozycja[child::Kod = 'J' and child::Symbol = '100' and child::Uwagi]">
								<tr>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="KosztyPodsumowanie/Pozycja[child::Kod = 'J' and child::Symbol = '100']/Kod"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="'100 (Środki własne zarezerwowane na inwestycje)'"/>
									</td>
									<td colspan="2" class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:value-of select="KosztyPodsumowanie/Pozycja[child::Kod = 'J' and child::Symbol = '100']/Uwagi"/>
									</td>
								</tr>
							</xsl:if>
							<xsl:if test="KosztyPodsumowanie/Pozycja[child::Kod = 'I' and child::Symbol = '100' and child::Uwagi]">
								<tr>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="KosztyPodsumowanie/Pozycja[child::Kod = 'I' and child::Symbol = '100']/Kod"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="'100 (Odpisy amortyzacji)'"/>
									</td>
									<td colspan="2" class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:value-of select="KosztyPodsumowanie/Pozycja[child::Kod = 'I' and child::Symbol = '100']/Uwagi"/>
									</td>
								</tr>
							</xsl:if>
							<xsl:if test="KosztyPodsumowanie/Pozycja[child::Kod = 'P' and child::Symbol = '100' and child::Uwagi]">
								<tr>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="KosztyPodsumowanie/Pozycja[child::Kod = 'P' and child::Symbol = '100']/Kod"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="'100 (Inne zmniejszenia)'"/>
									</td>
									<td colspan="2" class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:value-of select="KosztyPodsumowanie/Pozycja[child::Kod = 'P' and child::Symbol = '100']/Uwagi"/>
									</td>
								</tr>
							</xsl:if>
							<xsl:if test="KosztyPodsumowanie/Pozycja[child::Kod = 'N' and child::Uwagi]">
								<tr>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="KosztyPodsumowanie/Pozycja[child::Kod = 'N']/Kod"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="'Razem'"/>
									</td>
									<td colspan="2" class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:value-of select="KosztyPodsumowanie/Pozycja[child::Kod = 'N']/Uwagi"/>
									</td>
								</tr>
							</xsl:if>
							<xsl:if test="KosztyPodsumowanie/Pozycja[child::Kod = 'P' and child::Symbol = '110' and child::Uwagi]">
								<tr>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="KosztyPodsumowanie/Pozycja[child::Kod = 'P' and child::Symbol = '110']/Kod"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="'110 (Podatek dochodowy od osób prawnych)'"/>
									</td>
									<td colspan="2" class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:value-of select="KosztyPodsumowanie/Pozycja[child::Kod = 'P' and child::Symbol = '110']/Uwagi"/>
									</td>
								</tr>
							</xsl:if>
							<xsl:if test="KosztyPodsumowanie/Pozycja[child::Kod = 'P' and child::Symbol = '120' and child::Uwagi]">
								<tr>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="KosztyPodsumowanie/Pozycja[child::Kod = 'P' and child::Symbol = '120']/Kod"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="'120 (Wpłata do budżetu nadwyżki środków obrotowych)'"/>
									</td>
									<td colspan="2" class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:value-of select="KosztyPodsumowanie/Pozycja[child::Kod = 'P' and child::Symbol = '120']/Uwagi"/>
									</td>
								</tr>
							</xsl:if>
							<xsl:if test="KosztyPodsumowanie/Pozycja[child::Kod = 'P' and child::Symbol = '130' and child::Uwagi]">
								<tr>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="KosztyPodsumowanie/Pozycja[child::Kod = 'P' and child::Symbol = '130']/Kod"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="'130 (Stan środków obrotowych netto na koniec okresu sprawozdawczego)'"/>
									</td>
									<td colspan="2" class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:value-of select="KosztyPodsumowanie/Pozycja[child::Kod = 'P' and child::Symbol = '130']/Uwagi"/>
									</td>
								</tr>
							</xsl:if>
							<xsl:if test="KosztyPodsumowanie/Pozycja[child::Kod = 'S' and child::Symbol = '190' and child::Uwagi]">
								<tr>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="KosztyPodsumowanie/Pozycja[child::Kod = 'S' and child::Symbol = '190']/Kod"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="'190 Ogółem (N+P110+P120+P130)'"/>
									</td>
									<td colspan="2" class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:value-of select="KosztyPodsumowanie/Pozycja[child::Kod = 'S' and child::Symbol = '190']/Uwagi"/>
									</td>
								</tr>
							</xsl:if>
						</tbody>
					</table>
				</xsl:if>
				<xsl:if test="Stan/Pozycja[child::Uwagi]">
					<table cellpadding="0" cellspacing="0" class="all-bold" style="margin-bottom: 20px; width: 100%">
						<tbody>
							<tr>
								<td colspan="4" style="text-align: center; font-size: 9pt; font-weight: bold; padding: 3px 10px">
									<div>Uwagi do części: "Stan"</div>
								</td>
							</tr>
							<tr>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 4px 4px 0; width: 4%">Kod</td>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 4px 4px 0; width: 6%">Symbol</td>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 4px 4px 0; width: 30%">Wyszczególnienie</td>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 0 4px 0">Uwaga</td>
							</tr>
							<xsl:for-each select="Stan/Pozycja[child::Uwagi]">
								<xsl:sort select="Symbol"/>
								<tr>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="Kod"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="Symbol"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:choose>
											<xsl:when test="Symbol = '010'">Środki pieniężne (w tym środki w kasie)</xsl:when>
											<xsl:when test="Symbol = '020'">Należności netto</xsl:when>
											<xsl:when test="Symbol = '021'">Kwota odpisu aktualizującego należności</xsl:when>
											<xsl:when test="Symbol = '022'">Kwota odsetek od należności niezapłaconych w terminie</xsl:when>
											<xsl:when test="Symbol = '030'">Pozostałe środki obrotowe</xsl:when>
											<xsl:when test="Symbol = '040'">Zobowiązania i inne rozliczenia</xsl:when>
											<xsl:when test="Symbol = '041'">w tym wobec inwestycji finansowanych ze środków własnych</xsl:when>
											<xsl:when test="Symbol = '042'">dotacji</xsl:when>
											<xsl:when test="Symbol = '043'">środków z innych źródeł</xsl:when>
											<xsl:when test="Symbol = '070'">Stan środków obrotowych netto (W010+W020+W030-W040)</xsl:when>
											<xsl:when test="Symbol = '080'">Należności od pracowników</xsl:when>
											<xsl:when test="Symbol = '081'">Należności z tytułu sprzedaży dóbr i usług</xsl:when>
											<xsl:when test="Symbol = '090'">Zobowiązania z tytułu wynagrodzeń</xsl:when>
											<xsl:when test="Symbol = '091'">Zobowiązania z tytułu składek na ubezpieczenia społeczne</xsl:when>
											<xsl:when test="Symbol = '092'">w tym z tytułu składek na FUS</xsl:when>
											<xsl:when test="Symbol = '093'">składek na Fundusz Pracy</xsl:when>
											<xsl:when test="Symbol = '094'">Zobowiązania z tytułu zakupu dóbr i usług</xsl:when>
										</xsl:choose>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:value-of select="Uwagi"/>
									</td>
								</tr>
							</xsl:for-each>
						</tbody>
					</table>
				</xsl:if>
				<xsl:if test="Finansowanie/Pozycja[child::Uwagi]">
					<table cellpadding="0" cellspacing="0" class="all-bold" style="margin-bottom: 20px; width: 100%">
						<tbody>
							<tr>
								<td colspan="4" style="text-align: center; font-size: 9pt; font-weight: bold; padding: 3px 10px">
									<div>Uwagi do części: "Finansowanie"</div>
								</td>
							</tr>
							<tr>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 4px 4px 0; width: 4%">Kod</td>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 4px 4px 0; width: 6%">Symbol</td>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 4px 4px 0; width: 30%">Wyszczególnienie</td>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 0 4px 0">Uwaga</td>
							</tr>
							<xsl:for-each select="Finansowanie/Pozycja[child::Uwagi]">
								<xsl:sort select="Symbol"/>
								<tr>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="Kod"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="Symbol"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:choose>
											<xsl:when test="Symbol = '100'">Wydatki inwestycyjne</xsl:when>
											<xsl:when test="Symbol = '200'">Źródła finansowania wydatków inwestycyjnych</xsl:when>
											<xsl:when test="Symbol = '201'">- środki z lat ubiegłych</xsl:when>
											<xsl:when test="Symbol = '202'">- dotacje celowe</xsl:when>
											<xsl:when test="Symbol = '203'">- środki własne</xsl:when>
											<xsl:when test="Symbol = '204'">- inne środki</xsl:when>
											<xsl:when test="Symbol = '300'">Zobowiązania dotyczące inwestycji</xsl:when>
											<xsl:when test="Symbol = '301'">na początek okresu sprawozdawczego</xsl:when>
											<xsl:when test="Symbol = '302'">na koniec okresu sprawozdawczego</xsl:when>
											<xsl:when test="Symbol = '303'">Zobowiązania wobec budżetu z tytułu zwrotu dotacji na inwestycje</xsl:when>
										</xsl:choose>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:value-of select="Uwagi"/>
									</td>
								</tr>
							</xsl:for-each>
						</tbody>
					</table>
				</xsl:if>
				<xsl:if test="RozliczenieKasowe/Pozycja[child::Uwagi]">
					<table cellpadding="0" cellspacing="0" class="all-bold" style="margin-bottom: 20px; width: 100%">
						<tbody>
							<tr>
								<td colspan="4" style="text-align: center; font-size: 9pt; font-weight: bold; padding: 3px 10px">
									<div>Uwagi do części: "Rozliczenie"</div>
								</td>
							</tr>
							<tr>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 4px 4px 0; width: 4%">Kod</td>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 4px 4px 0; width: 6%">Symbol</td>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 4px 4px 0; width: 30%">Wyszczególnienie</td>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 0 4px 0">Uwaga</td>
							</tr>
							<xsl:for-each select="RozliczenieKasowe/Pozycja[child::Uwagi]">
								<xsl:sort select="Symbol"/>
								<tr>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="Kod"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="Symbol"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:choose>
											<xsl:when test="Symbol = '100'">Podatek osobowy od osób prawnych</xsl:when>
											<xsl:when test="Symbol = '101'">Wpłata nadwyżki środków obrotowych</xsl:when>
											<xsl:when test="Symbol = '102'">Podatek VAT od otrzymanych dotacji przedmiotowych</xsl:when>
										</xsl:choose>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:value-of select="Uwagi"/>
									</td>
								</tr>
							</xsl:for-each>
						</tbody>
					</table>
				</xsl:if>
				<table cellpadding="0" cellspacing="0" style="margin-bottom: 0px; margin-top: 80px; width: 100%">
					<tbody>
						<tr>
							<td style="text-align:center; font-size: 8pt;" valign="bottom">
								<hr style="width: 80%"/>
								<div>Główny księgowy / Skarbnik</div>
							</td>
							<td style="text-align:center; font-size: 8pt;" valign="bottom">
								<hr style="width: 80%"/>
								<div>telefon</div>
							</td>
							<td style="text-align:center; font-size: 8pt;" valign="bottom">
								<div>
									<xsl:value-of select="Naglowek/DataSprawozdania"/>
								</div>
								<hr style="width: 80%"/>
								<div>rok m-c dzień</div>
							</td>
							<td style="text-align:center; font-size: 8pt;" valign="bottom">
								<hr style="width: 80%"/>
								<div>Kierownik jednostki / Przewodniczący Zarządu</div>
							</td>
						</tr>
					</tbody>
				</table>
			</div>
			<xsl:element name="a">
				<xsl:attribute name="href"><xsl:value-of select="concat('#Jed', $jedIndex)"/></xsl:attribute>
				<xsl:element name="style">
					<xsl:value-of select="'font-family: Verdana'"/>
				</xsl:element>
				<xsl:value-of select="'Powrót do listy sprawozdań jednostki'"/>
			</xsl:element>
		</xsl:element>
	</xsl:template>
	<!-- Rb-30 szablony pomocnicze -->
	<xsl:template match="Rb-30/PrzychodyPodsumowanie">
		<xsl:param name="SymPoz"/>
		<xsl:param name="Dzial"/>
		<xsl:param name="Rozdzial"/>
		<xsl:variable name="Paragrafy" select="parent::*/PrzychodyPozycje/Pozycja/Paragraf"/>
		<xsl:variable name="P4" select="parent::*/PrzychodyPozycje/Pozycja/P4"/>
		<tr>
			<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
				<xsl:value-of select="'I'"/>
			</td>
			<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
				<xsl:value-of select="'110 (Pokrycie amortyzacji)'"/>
			</td>
			<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; padding: 3px">
				<xsl:choose>
					<xsl:when test="Pozycja[child::Kod = 'I' and child::Symbol = '110']/P">
						<xsl:value-of select="format-number(Pozycja[child::Kod = 'I' and child::Symbol = '110']/P, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
			<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; padding: 3px">
				<xsl:choose>
					<xsl:when test="Pozycja[child::Kod = 'I' and child::Symbol = '110']/W">
						<xsl:value-of select="format-number(Pozycja[child::Kod = 'I' and child::Symbol = '110']/W, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
		</tr>
		<tr>
			<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
				<xsl:value-of select="'K'"/>
			</td>
			<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
				<xsl:value-of select="'100 (Inne zwiększenia)'"/>
			</td>
			<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; padding: 3px">
				<xsl:choose>
					<xsl:when test="Pozycja[child::Kod = 'K' and child::Symbol='100']/P">
						<xsl:value-of select="format-number(Pozycja[child::Kod = 'K' and child::Symbol='100']/P, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
			<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; padding: 3px">
				<xsl:choose>
					<xsl:when test="Pozycja[child::Kod = 'K' and child::Symbol='100']/W">
						<xsl:value-of select="format-number(Pozycja[child::Kod = 'K' and child::Symbol='100']/W, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
		</tr>
		<tr>
			<td class="bottom-right-normal" style="text-align: center; font-size: 8pt; font-weight: bold">
				<xsl:value-of select="'H'"/>
			</td>
			<td class="bottom-right-normal" style="text-align: center; font-size: 9pt; font-weight: bold">
				<xsl:value-of select="'RAZEM '"/>
				<xsl:call-template name="Rb-3x_SumaKontr">
					<xsl:with-param name="Paragrafy" select="$Paragrafy"/>
					<xsl:with-param name="P4" select="$P4"/>
					<xsl:with-param name="Licznosc" select="count(parent::*/PrzychodyPozycje/Pozycja)"/>
					<xsl:with-param name="Licznik" select="1"/>
					<xsl:with-param name="Wartosc" select="0"/>
					<xsl:with-param name="SymPoz" select="$SymPoz"/>
					<xsl:with-param name="Dzial" select="$Dzial"/>
					<xsl:with-param name="Rozdzial" select="$Rozdzial"/>
				</xsl:call-template>
			</td>
			<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; font-weight: bold; padding: 3px">
				<xsl:choose>
					<xsl:when test="Pozycja[child::Kod = 'H']/P">
						<xsl:value-of select="format-number(Pozycja[child::Kod = 'H']/P, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
			<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; font-weight: bold; padding: 3px">
				<xsl:choose>
					<xsl:when test="Pozycja[child::Kod = 'H']/W">
						<xsl:value-of select="format-number(Pozycja[child::Kod = 'H']/W, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
		</tr>
		<tr>
			<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
				<xsl:value-of select="'K'"/>
			</td>
			<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
				<xsl:value-of select="'110 (Stan środków obrotowych netto na początku okresu sprawozdawczego)'"/>
			</td>
			<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; padding: 3px">
				<xsl:choose>
					<xsl:when test="Pozycja[child::Kod = 'K' and child::Symbol='110']/P">
						<xsl:value-of select="format-number(Pozycja[child::Kod = 'K' and child::Symbol='110']/P, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
			<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; padding: 3px">
				<xsl:choose>
					<xsl:when test="Pozycja[child::Kod = 'K' and child::Symbol='110']/W">
						<xsl:value-of select="format-number(Pozycja[child::Kod = 'K' and child::Symbol='110']/W, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
		</tr>
		<tr>
			<td class="right-normal" style="text-align: center; font-size: 8pt; font-weight: bold">
				<xsl:value-of select="'L'"/>
			</td>
			<td class="right-normal" style="text-align: center; font-size: 8pt; font-weight: bold">
				<xsl:value-of select="'190 Ogółem (H+K110)'"/>
			</td>
			<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; font-weight: bold; padding: 3px">
				<xsl:choose>
					<xsl:when test="Pozycja[child::Kod = 'L' and child::Symbol='190']/P">
						<xsl:value-of select="format-number(Pozycja[child::Kod = 'L' and child::Symbol='190']/P, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
			<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; font-weight: bold; padding: 3px">
				<xsl:choose>
					<xsl:when test="Pozycja[child::Kod = 'L' and child::Symbol='190']/W">
						<xsl:value-of select="format-number(Pozycja[child::Kod = 'L' and child::Symbol='190']/W, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
		</tr>
	</xsl:template>
	<xsl:template match="Rb-30/KosztyPodsumowanie">
		<xsl:param name="SymPoz"/>
		<xsl:param name="Dzial"/>
		<xsl:param name="Rozdzial"/>
		<xsl:variable name="Paragrafy" select="parent::*/KosztyPozycje/Pozycja/Paragraf"/>
		<xsl:variable name="P4" select="parent::*/KosztyPozycje/Pozycja/P4"/>
		<tr>
			<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
				<xsl:value-of select="'J'"/>
			</td>
			<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
				<xsl:value-of select="'100 (Środki własne zarezerwowane na inwestycje)'"/>
			</td>
			<td class="bottom-right-normal" style="text-align: center; font-size: 9pt">X</td>
			<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; padding: 3px">
				<xsl:choose>
					<xsl:when test="Pozycja[child::Kod = 'J' and child::Symbol='100']/W">
						<xsl:value-of select="format-number(Pozycja[child::Kod = 'J' and child::Symbol='100']/W, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
		</tr>
		<tr>
			<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
				<xsl:value-of select="'I'"/>
			</td>
			<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
				<xsl:value-of select="'100 (Odpisy amortyzacji)'"/>
			</td>
			<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; padding: 3px">
				<xsl:choose>
					<xsl:when test="Pozycja[child::Kod = 'I' and child::Symbol='100']/P">
						<xsl:value-of select="format-number(Pozycja[child::Kod = 'I' and child::Symbol='100']/P, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
			<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; padding: 3px">
				<xsl:choose>
					<xsl:when test="Pozycja[child::Kod = 'I' and child::Symbol='100']/W">
						<xsl:value-of select="format-number(Pozycja[child::Kod = 'I' and child::Symbol='100']/W, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
		</tr>
		<tr>
			<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
				<xsl:value-of select="'P'"/>
			</td>
			<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
				<xsl:value-of select="'100 (Inne zmniejszenia)'"/>
			</td>
			<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; padding: 3px">
				<xsl:choose>
					<xsl:when test="Pozycja[child::Kod = 'P' and child::Symbol='100']/P">
						<xsl:value-of select="format-number(Pozycja[child::Kod = 'P' and child::Symbol='100']/P, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
			<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; padding: 3px">
				<xsl:choose>
					<xsl:when test="Pozycja[child::Kod = 'P' and child::Symbol='100']/W">
						<xsl:value-of select="format-number(Pozycja[child::Kod = 'P' and child::Symbol='100']/W, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
		</tr>
		<tr>
			<td class="bottom-right-normal" style="text-align: center; font-size: 8pt; font-weight: bold">
				<xsl:value-of select="'N'"/>
			</td>
			<td class="bottom-right-normal" style="text-align: center; font-size: 9pt; font-weight: bold">
				<xsl:value-of select="'RAZEM '"/>
				<xsl:call-template name="Rb-3x_SumaKontr">
					<xsl:with-param name="Paragrafy" select="$Paragrafy"/>
					<xsl:with-param name="P4" select="$P4"/>
					<xsl:with-param name="Licznosc" select="count(parent::*/KosztyPozycje/Pozycja)"/>
					<xsl:with-param name="Licznik" select="1"/>
					<xsl:with-param name="Wartosc" select="0"/>
					<xsl:with-param name="SymPoz" select="$SymPoz"/>
					<xsl:with-param name="Dzial" select="$Dzial"/>
					<xsl:with-param name="Rozdzial" select="$Rozdzial"/>
				</xsl:call-template>
			</td>
			<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; font-weight: bold; padding: 3px">
				<xsl:choose>
					<xsl:when test="Pozycja[child::Kod = 'N']/P">
						<xsl:value-of select="format-number(Pozycja[child::Kod = 'N']/P, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
			<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; font-weight: bold; padding: 3px">
				<xsl:choose>
					<xsl:when test="Pozycja[child::Kod = 'N']/W">
						<xsl:value-of select="format-number(Pozycja[child::Kod = 'N']/W, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
		</tr>
		<tr>
			<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
				<xsl:value-of select="'P'"/>
			</td>
			<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
				<xsl:value-of select="'110 (Podatek dochodowy od osób prawnych)'"/>
			</td>
			<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; padding: 3px">
				<xsl:choose>
					<xsl:when test="Pozycja[child::Kod = 'P' and child::Symbol='110']/P">
						<xsl:value-of select="format-number(Pozycja[child::Kod = 'P' and child::Symbol='110']/P, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
			<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; padding: 3px">
				<xsl:choose>
					<xsl:when test="Pozycja[child::Kod = 'P' and child::Symbol='110']/W">
						<xsl:value-of select="format-number(Pozycja[child::Kod = 'P' and child::Symbol='110']/W, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
		</tr>
		<tr>
			<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
				<xsl:value-of select="'P'"/>
			</td>
			<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
				<xsl:value-of select="'120 (Wpłata do budżetu nadwyżki środków obrotowych)'"/>
			</td>
			<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; padding: 3px">
				<xsl:choose>
					<xsl:when test="Pozycja[child::Kod = 'P' and child::Symbol='120']/P">
						<xsl:value-of select="format-number(Pozycja[child::Kod = 'P' and child::Symbol='120']/P, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
			<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; padding: 3px">
				<xsl:choose>
					<xsl:when test="Pozycja[child::Kod = 'P' and child::Symbol='120']/W">
						<xsl:value-of select="format-number(Pozycja[child::Kod = 'P' and child::Symbol='120']/W, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
		</tr>
		<tr>
			<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
				<xsl:value-of select="'P'"/>
			</td>
			<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
				<xsl:value-of select="'130 (Stan środków obrotowych netto na koniec okresu sprawozdawczego)'"/>
			</td>
			<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; padding: 3px">
				<xsl:choose>
					<xsl:when test="Pozycja[child::Kod = 'P' and child::Symbol='130']/P">
						<xsl:value-of select="format-number(Pozycja[child::Kod = 'P' and child::Symbol='130']/P, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
			<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; padding: 3px">
				<xsl:choose>
					<xsl:when test="Pozycja[child::Kod = 'P' and child::Symbol='130']/W">
						<xsl:value-of select="format-number(Pozycja[child::Kod = 'P' and child::Symbol='130']/W, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
		</tr>
		<tr>
			<td class="right-normal" style="text-align: center; font-size: 8pt; font-weight: bold">
				<xsl:value-of select="'S'"/>
			</td>
			<td class="right-normal" style="text-align: center; font-size: 8pt; font-weight: bold">
				<xsl:value-of select="'190 Ogółem (N+P110+P120+P130)'"/>
			</td>
			<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; font-weight: bold; padding: 3px">
				<xsl:choose>
					<xsl:when test="Pozycja[child::Kod = 'S' and child::Symbol='190']/P">
						<xsl:value-of select="format-number(Pozycja[child::Kod = 'S' and child::Symbol='190']/P, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
			<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; font-weight: bold; padding: 3px">
				<xsl:choose>
					<xsl:when test="Pozycja[child::Kod = 'S' and child::Symbol='190']/W">
						<xsl:value-of select="format-number(Pozycja[child::Kod = 'S' and child::Symbol='190']/W, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
		</tr>
	</xsl:template>
	<xsl:template name="Rb-3x_SumaKontr">
		<xsl:param name="Paragrafy"/>
		<xsl:param name="P4"/>
		<xsl:param name="Licznosc"/>
		<xsl:param name="Licznik"/>
		<xsl:param name="Wartosc"/>
		<xsl:param name="SymPoz"/>
		<xsl:param name="Dzial"/>
		<xsl:param name="Rozdzial"/>
		<xsl:choose>
			<xsl:when test="$Licznosc = 0">
				<xsl:value-of select="$Wartosc + number($SymPoz) + number($Dzial) + number($Rozdzial)"/>
			</xsl:when>
			<xsl:when test="$Licznosc = $Licznik">
				<xsl:value-of select="$Wartosc + number(concat($Paragrafy[$Licznik], $P4[$Licznik])) + number($SymPoz) + number($Dzial) + number($Rozdzial)"/>
			</xsl:when>
			<xsl:when test="$Licznosc &gt; $Licznik">
				<xsl:call-template name="Rb-3x_SumaKontr">
					<xsl:with-param name="Paragrafy" select="$Paragrafy"/>
					<xsl:with-param name="P4" select="$P4"/>
					<xsl:with-param name="Licznosc" select="$Licznosc"/>
					<xsl:with-param name="Licznik" select="$Licznik + 1"/>
					<xsl:with-param name="Wartosc" select="$Wartosc + number(concat($Paragrafy[$Licznik], $P4[$Licznik]))"/>
					<xsl:with-param name="Dzial" select="$Dzial"/>
					<xsl:with-param name="Rozdzial" select="$Rozdzial"/>
					<xsl:with-param name="SymPoz" select="$SymPoz"/>
				</xsl:call-template>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="Rb-30_danePozycjeC">
		<xsl:param name="kod"/>
		<xsl:param name="symbol"/>
		<xsl:param name="wyszczeg"/>
		<xsl:param name="ostWiersz" select="false()"/>
		<xsl:param name="pogrWyszczeg" select="false()"/>
		<tr>
			<xsl:element name="td">
				<xsl:attribute name="style"><xsl:value-of select="'text-align: center; font-size: 8pt'"/></xsl:attribute>
				<xsl:attribute name="class"><xsl:choose><xsl:when test="$ostWiersz = false()"><xsl:value-of select="'bottom-right-normal'"/></xsl:when><xsl:otherwise><xsl:value-of select="'right-normal'"/></xsl:otherwise></xsl:choose></xsl:attribute>
				<xsl:value-of select="$kod"/>
			</xsl:element>
			<xsl:element name="td">
				<xsl:attribute name="style"><xsl:value-of select="'text-align: center; font-size: 8pt'"/></xsl:attribute>
				<xsl:attribute name="class"><xsl:choose><xsl:when test="$ostWiersz = false()"><xsl:value-of select="'bottom-right-normal'"/></xsl:when><xsl:otherwise><xsl:value-of select="'right-normal'"/></xsl:otherwise></xsl:choose></xsl:attribute>
				<xsl:value-of select="$symbol"/>
			</xsl:element>
			<xsl:element name="td">
				<xsl:attribute name="style"><xsl:choose><xsl:when test="$pogrWyszczeg = false()"><xsl:value-of select="'text-align: left; font-size: 8pt; padding: 3px'"/></xsl:when><xsl:otherwise><xsl:value-of select="'text-align: left; font-size: 8pt; font-weight: bold; padding: 3px'"/></xsl:otherwise></xsl:choose></xsl:attribute>
				<xsl:attribute name="class"><xsl:choose><xsl:when test="$ostWiersz = false()"><xsl:value-of select="'bottom-right-normal'"/></xsl:when><xsl:otherwise><xsl:value-of select="'right-normal'"/></xsl:otherwise></xsl:choose></xsl:attribute>
				<xsl:value-of select="$wyszczeg"/>
			</xsl:element>
			<xsl:element name="td">
				<xsl:attribute name="style"><xsl:value-of select="'text-align: right; font-size: 8pt; padding: 3px'"/></xsl:attribute>
				<xsl:attribute name="class"><xsl:choose><xsl:when test="$ostWiersz = false()"><xsl:value-of select="'bottom-right-normal'"/></xsl:when><xsl:otherwise><xsl:value-of select="'right-normal'"/></xsl:otherwise></xsl:choose></xsl:attribute>
				<xsl:choose>
					<xsl:when test="Stan/Pozycja[child::Kod = $kod and child::Symbol = $symbol]/P">
						<xsl:value-of select="format-number(Stan/Pozycja[child::Kod = $kod and child::Symbol = $symbol]/P, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:element>
			<xsl:element name="td">
				<xsl:attribute name="style"><xsl:value-of select="'text-align: right; font-size: 8pt; padding: 3px'"/></xsl:attribute>
				<xsl:if test="$ostWiersz = false()">
					<xsl:attribute name="class"><xsl:value-of select="'bottom-normal'"/></xsl:attribute>
				</xsl:if>
				<xsl:choose>
					<xsl:when test="Stan/Pozycja[child::Kod = $kod and child::Symbol = $symbol]/K">
						<xsl:value-of select="format-number(Stan/Pozycja[child::Kod = $kod and child::Symbol = $symbol]/K, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:element>
		</tr>
	</xsl:template>
	<xsl:template name="Rb-30_danePozycjeE">
		<xsl:param name="kod"/>
		<xsl:param name="symbol"/>
		<xsl:param name="wyszczeg"/>
		<xsl:param name="ostWiersz" select="false()"/>
		<tr>
			<xsl:element name="td">
				<xsl:attribute name="style"><xsl:value-of select="'text-align: center; font-size: 8pt'"/></xsl:attribute>
				<xsl:attribute name="class"><xsl:choose><xsl:when test="$ostWiersz = false()"><xsl:value-of select="'bottom-right-normal'"/></xsl:when><xsl:otherwise><xsl:value-of select="'right-normal'"/></xsl:otherwise></xsl:choose></xsl:attribute>
				<xsl:value-of select="$kod"/>
			</xsl:element>
			<xsl:element name="td">
				<xsl:attribute name="style"><xsl:value-of select="'text-align: center; font-size: 8pt'"/></xsl:attribute>
				<xsl:attribute name="class"><xsl:choose><xsl:when test="$ostWiersz = false()"><xsl:value-of select="'bottom-right-normal'"/></xsl:when><xsl:otherwise><xsl:value-of select="'right-normal'"/></xsl:otherwise></xsl:choose></xsl:attribute>
				<xsl:value-of select="$symbol"/>
			</xsl:element>
			<xsl:element name="td">
				<xsl:attribute name="style"><xsl:value-of select="'text-align: left; font-size: 8pt; padding: 3px'"/></xsl:attribute>
				<xsl:attribute name="class"><xsl:choose><xsl:when test="$ostWiersz = false()"><xsl:value-of select="'bottom-right-normal'"/></xsl:when><xsl:otherwise><xsl:value-of select="'right-normal'"/></xsl:otherwise></xsl:choose></xsl:attribute>
				<xsl:value-of select="$wyszczeg"/>
			</xsl:element>
			<xsl:element name="td">
				<xsl:attribute name="style"><xsl:value-of select="'text-align: right; font-size: 8pt; padding: 3px'"/></xsl:attribute>
				<xsl:attribute name="class"><xsl:choose><xsl:when test="$ostWiersz = false()"><xsl:value-of select="'bottom-right-normal'"/></xsl:when><xsl:otherwise><xsl:value-of select="'right-normal'"/></xsl:otherwise></xsl:choose></xsl:attribute>
				<xsl:choose>
					<xsl:when test="RozliczenieKasowe/Pozycja[child::Kod = $kod and child::Symbol = $symbol]/P">
						<xsl:value-of select="format-number(RozliczenieKasowe/Pozycja[child::Kod = $kod and child::Symbol = $symbol]/P, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:element>
			<xsl:element name="td">
				<xsl:attribute name="style"><xsl:value-of select="'text-align: right; font-size: 8pt; padding: 3px'"/></xsl:attribute>
				<xsl:if test="$ostWiersz = false()">
					<xsl:attribute name="class"><xsl:value-of select="'bottom-normal'"/></xsl:attribute>
				</xsl:if>
				<xsl:choose>
					<xsl:when test="RozliczenieKasowe/Pozycja[child::Kod = $kod and child::Symbol = $symbol]/O">
						<xsl:value-of select="format-number(RozliczenieKasowe/Pozycja[child::Kod = $kod and child::Symbol = $symbol]/O, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:element>
		</tr>
	</xsl:template>
	<!-- Rb-30s -->
	<xsl:template match="Rb-30s">
		<xsl:param name="jedIndex"/>
		<xsl:param name="sprIndex"/>
		<xsl:element name="div">
			<xsl:attribute name="Id"><xsl:value-of select="concat('Jed', $jedIndex, 'Wer', $sprIndex)"/></xsl:attribute>
			<xsl:attribute name="style"><xsl:value-of select="'display: block; margin-bottom: 40px'"/></xsl:attribute>
			<div style="font-size: 12pt; font-weight: bold; margin-left: 5px; margin-bottom: 10px">
        Sprawozdanie Rb-30s:
        <xsl:choose>
					<xsl:when test="Naglowek/Wersja = 0">
						<xsl:value-of select="'wersja pierwotna'"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="concat('korekta nr ', Naglowek/Wersja)"/>
					</xsl:otherwise>
				</xsl:choose>
				<xsl:call-template name="SprNaglowekInfo"/>
				<table cellpadding="0" cellspacing="0" class="all-bold" style="margin-bottom: 30px">
					<tbody>
						<tr style="height: 18px">
							<td colspan="10" class="bottom-bold" style="font-size: 10pt;">MINISTERSTWO FINANSÓW, ul. Świętokrzyska 12, 00-916 Warszawa</td>
						</tr>
						<tr style="height: 127px">
							<td colspan="4" class="bottom-bold" style="width:300px">
								<table cellpadding="0" cellspacing="0" style="border-collapse: collapse; height" width="100%">
									<tbody>
										<tr style="height: 80px">
											<td style="text-align: left; font-size: 9pt; margin:1px 1px 0 0; padding:0" valign="top">
                      Nazwa i adres jednostki sprawozdawczej
                    </td>
										</tr>
										<tr>
											<td class="bottom-normal" style="text-align: center; font-size: 9pt" valign="bottom">
												<!-- popr. nr I.8 -->
												<div style="display: block;margin: 0 20px">
													<xsl:choose>
														<xsl:when test="Jednostka/Nazwa">
															<xsl:value-of select="Jednostka/Nazwa"/>
														</xsl:when>
														<xsl:otherwise>
															<xsl:value-of select="../../Nazwa"/>
														</xsl:otherwise>
													</xsl:choose>
													<!--<xsl:value-of select="../../Nazwa"/>-->
												</div>
											</td>
										</tr>
										<tr style="height: 23px">
											<td style="text-align: left; font-size: 9pt; margin:1px 1px 0 0; padding:0;" valign="top">
                      Numer identyfikacyjny REGON
                    </td>
										</tr>
										<tr>
											<td style="text-align: center; font-size: 9pt; font-weight: bold; margin:1px 1px 0 0; padding:0" valign="baseline">
												<xsl:choose>
													<xsl:when test="Jednostka/Regon">
														<xsl:value-of select="Jednostka/Regon"/>
													</xsl:when>
													<xsl:otherwise>
														<xsl:value-of select="../../Regon"/>
													</xsl:otherwise>
												</xsl:choose>
												<!--<xsl:value-of select="../../Regon"/>-->
											</td>
										</tr>
									</tbody>
								</table>
							</td>
							<td colspan="3" class="notop-bold" valign="top" style="width: 400px">
								<div style="font-weight: bold; text-align: center; font-size: 11pt; margin-bottom: 5px">Rb-30s</div>
								<div style="font-weight: bold; text-align: center; font-size: 11pt; margin-bottom: 5px">sprawozdanie z wykonania planów finansowych samorządowych zakładów budżetowych</div>
								<div style="vertical-align: bottom; text-align: center; font-size: 9pt; margin-top: 30px"> okres sprawozdawczy:</div>
								<div style="vertical-align: bottom; text-align: center; font-size: 9pt; margin-top: 30px">
									<xsl:call-template name="NaglowekSprOkresRb30s"/>
								</div>
							</td>
							<td colspan="3" class="bottom-bold" style="text-align: left; font-size: 9pt; margin:1px 1px 0 0; padding:0; width: 300px" valign="top">
								<div style="margin-bottom:5px">Adresat:</div>
								<!-- popr. nr I.9 -->
								<div style="text-align:center; margin-bottom: 15px;">
									<!-- <xsl:value-of select="'Regionalna Izba Obrachunkowa w Katowicach'"/> -->
								</div>
								<div style="text-align:center;">
									<!-- <xsl:value-of select="'wersja robocza'"/> -->
								</div>
							</td>
						</tr>
						<tr style="height: 54px">
							<td rowspan="2" colspan="7" class="bottom-right-bold" style="font-size: 9pt">
								<!-- popr. nr I.10 -->
								<div style="margin-bottom: 1px">
									<xsl:value-of select="'Nazwa województwa '"/>
									<!-- <xsl:if test="../../Typ = 'W'">
									<span style="margin-left: 10px">
										<b>
											<xsl:value-of select="../../Nazwa"/>
										</b>
									</span>
								</xsl:if> -->
								</div>
								<div style="margin-bottom: 1px">
									<xsl:value-of select="'Nazwa powiatu / związku '"/>
									<sup>1)</sup>
									<!-- <xsl:if test="../../Typ = 'P'">
									<span style="margin-left: 10px">
										<b>
											<xsl:value-of select="../../Nazwa"/>
										</b>
									</span>
								</xsl:if> -->
								</div>
								<div>
									<xsl:value-of select="'Nazwa gminy / związku '"/>
									<sup>1)</sup>
									<!-- <xsl:if test="../../Typ = 'G'">
									<span style="margin-left: 10px">
										<b>
											<xsl:value-of select="../../Nazwa"/>
										</b>
									</span>
								</xsl:if> -->
								</div>
							</td>
							<td colspan="3" class="bottom-bold" style="font-size:9pt; text-align:center">Przed wypełnieniem przeczytać instrukcję</td>
						</tr>
						<tr>

          </tr>
						<tr>
							<td colspan="9" class="right-bottom-mixed" style="font-size:10pt; text-align:center">Symbole</td>
						</tr>
						<tr>
							<td class="bottom-right-normal" style="font-size:9pt; text-align:center">woj.</td>
							<td colspan="2" class="bottom-right-normal" style="font-size:9pt; text-align:center">powiat</td>
							<td colspan="2" class="bottom-right-normal" style="font-size:9pt; text-align:center">gmina</td>
							<td class="bottom-right-normal" style="font-size:9pt; text-align:center">typ gminy</td>
							<td class="bottom-right-normal" style="font-size:9pt; text-align:center">związek jst</td>
							<td class="bottom-right-normal" style="font-size:9pt; text-align:center;border-width: 1px 0px 1px 0;">typ związku</td>
							<td class="right-bottom-mixed" style="font-size:9pt; text-align:center;"/>
						</tr>
						<tr>

          </tr>
						<tr>
							<td class="right-normal" style="font-size:10pt; text-align:center">
								<xsl:choose>
									<xsl:when test="Jednostka/WK">
										<xsl:value-of select="Jednostka/WK"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="../../WK"/>
									</xsl:otherwise>
								</xsl:choose>
							</td>
							<td colspan="2" class="right-normal" style="font-size:10pt; text-align:center">
								<xsl:choose>
									<xsl:when test="Jednostka/PK">
										<xsl:value-of select="Jednostka/PK"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="../../PK"/>
									</xsl:otherwise>
								</xsl:choose>
							</td>
							<td colspan="2" class="right-normal" style="font-size:10pt; text-align:center">
								<xsl:choose>
									<xsl:when test="Jednostka/GK">
										<xsl:value-of select="Jednostka/GK"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="../../GK"/>
									</xsl:otherwise>
								</xsl:choose>
							</td>
							<td class="right-normal" style="font-size:10pt; text-align:center">
								<xsl:choose>
									<xsl:when test="Jednostka/GT">
										<xsl:value-of select="Jednostka/GT"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="../../GT"/>
									</xsl:otherwise>
								</xsl:choose>
							</td>
							<td style="font-size:10pt; text-align:center; border-right: 1px solid black">
								<xsl:choose>
									<xsl:when test="Jednostka/KodMSWiA">
										<xsl:value-of select="Jednostka/KodMSWiA"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:choose>
											<xsl:when test="../../KodMSWiA">
												<xsl:value-of select="../../KodMSWiA"/>
											</xsl:when>
											<xsl:otherwise>
												<xsl:value-of select="$nbsp"/>
											</xsl:otherwise>
										</xsl:choose>
									</xsl:otherwise>
								</xsl:choose>
							</td>
							<td colspan="2" style="font-size:10pt; text-align:center; border-right: 1px solid black" select="$nbsp"/>
						</tr>
					</tbody>
				</table>
			</div>
			<div style="display: block; margin-bottom: 40px">
				<table cellpadding="0" cellspacing="0">
					<tbody>
						<tr>
							<td style="width: 450px">
								<div style="font-size: 10pt; font-weight: bold; margin-left: 5px">A.</div>
							</td>
							<td style="width: 120px">
								<!-- <div style="font-size: 9pt">strona 1</div> -->
							</td>
							<td style="width: 350px">
								<!-- <div style="font-size: 9pt">sprawozdania Rb-30s, Dział <xsl:value-of select="Naglowek/Dzial"/>, Rozdział <xsl:value-of select="Naglowek/Rozdzial"/>, <xsl:value-of select="../../Nazwa"/>
								</div> -->
							</td>
						</tr>
					</tbody>
				</table>
				<table cellpadding="0" cellspacing="0" class="all-bold" style="margin-bottom: 10px">
					<tbody>
						<tr>
							<td rowspan="2" class="bottom-right-mixed" style="font-size: 10pt; text-align: center; width: 80px">kod pozycji</td>
							<td rowspan="2" class="bottom-right-mixed" style="font-size: 10pt; text-align: center; width: 150px">Dział</td>
							<td rowspan="2" class="bottom-right-mixed" style="font-size: 10pt; text-align: center; width: 150px">Rozdział</td>
							<td rowspan="2" class="bottom-right-mixed" style="font-size: 10pt; text-align: center; width: 150px">Paragraf</td>
							<td colspan="2" class="bottom-normal" style="font-size: 10pt; text-align: center">Przychody</td>
						</tr>
						<tr>
							<td class="bottom-right-mixed" style="font-size: 10pt; text-align: center; width: 350px">plan</td>
							<td class="bottom-bold" style="font-size: 10pt; text-align: center; width: 350px">wykonanie</td>
						</tr>
						<tr>
							<td class="bottom-right-mixed" style="text-align:center; font-size: 8pt">
								<xsl:value-of select="1"/>
							</td>
							<td class="bottom-right-mixed" style="text-align:center; font-size: 8pt">
								<xsl:value-of select="2"/>
							</td>
							<td class="bottom-right-mixed" style="text-align:center; font-size: 8pt">
								<xsl:value-of select="3"/>
							</td>
							<td class="bottom-right-mixed" style="text-align:center; font-size: 8pt">
								<xsl:value-of select="4"/>
							</td>
							<td class="bottom-right-mixed" style="text-align:center; font-size: 8pt">
								<xsl:value-of select="5"/>
							</td>
							<td class="bottom-bold" style="text-align:center; font-size: 8pt">
								<xsl:value-of select="6"/>
							</td>
						</tr>
						<xsl:for-each select="PrzychodyPozycje/Pozycja">
							<tr>
								<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
									<xsl:value-of select="'G'"/>
								</td>
								<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
									<xsl:value-of select="Dzial"/>
								</td>
								<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
									<xsl:value-of select="Rozdzial"/>
								</td>
								<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
									<xsl:value-of select="concat(Paragraf, P4)"/>
								</td>
								<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; padding: 3px">
									<xsl:choose>
										<xsl:when test="P">
											<xsl:value-of select="format-number(P, '#&#160;##0,00')"/>
										</xsl:when>
										<xsl:otherwise>
											<xsl:value-of select="'0,00'"/>
										</xsl:otherwise>
									</xsl:choose>
								</td>
								<td class="bottom-normal" style="text-align: right; font-size: 8pt; padding: 3px">
									<xsl:choose>
										<xsl:when test="W">
											<xsl:value-of select="format-number(W, '#&#160;##0,00')"/>
										</xsl:when>
										<xsl:otherwise>
											<xsl:value-of select="'0,00'"/>
										</xsl:otherwise>
									</xsl:choose>
								</td>
							</tr>
						</xsl:for-each>
						<xsl:apply-templates select="PrzychodyPodsumowanie">
							<xsl:with-param name="SymPoz" select="Naglowek/SymbolPozabudzetowy"/>
							<xsl:with-param name="Dzial" select="Naglowek/Dzial"/>
							<xsl:with-param name="Rozdzial" select="Naglowek/Rozdzial"/>
						</xsl:apply-templates>
					</tbody>
				</table>
				<table cellpadding="0" cellspacing="0">
					<tbody>
						<tr>
							<td style="width: 450px">
								<div style="font-size: 10pt; font-weight: bold; margin-left: 5px">B.</div>
							</td>
							<td style="width: 120px">
								<!-- <div style="font-size: 9pt">strona 2</div> -->
							</td>
							<td style="width: 350px">
								<!-- <div style="font-size: 9pt">sprawozdania Rb-30s, Dział <xsl:value-of select="Naglowek/Dzial"/>, Rozdział <xsl:value-of select="Naglowek/Rozdzial"/>, <xsl:value-of select="../../Nazwa"/>
								</div> -->
							</td>
						</tr>
					</tbody>
				</table>
				<table cellpadding="0" cellspacing="0" class="all-bold" style="margin-bottom: 30px">
					<tbody>
						<tr>
							<td rowspan="2" class="bottom-right-mixed" style="font-size: 10pt; text-align: center; width: 80px">kod pozycji</td>
							<td rowspan="2" class="bottom-right-mixed" style="font-size: 10pt; text-align: center; width: 150px">Dział</td>
							<td rowspan="2" class="bottom-right-mixed" style="font-size: 10pt; text-align: center; width: 150px">Rozdział</td>
							<td rowspan="2" class="bottom-right-mixed" style="font-size: 10pt; text-align: center; width: 150px">Paragraf</td>
							<td colspan="2" class="bottom-normal" style="font-size: 10pt; text-align: center">Koszty i inne obciążenia</td>
						</tr>
						<tr>
							<td class="bottom-right-mixed" style="font-size: 10pt; text-align: center; width: 350px">plan</td>
							<td class="bottom-bold" style="font-size: 10pt; text-align: center; width: 350px">wykonanie</td>
						</tr>
						<tr>
							<td class="bottom-right-mixed" style="text-align:center; font-size: 8pt">
								<xsl:value-of select="1"/>
							</td>
							<td class="bottom-right-mixed" style="text-align:center; font-size: 8pt">
								<xsl:value-of select="2"/>
							</td>
							<td class="bottom-right-mixed" style="text-align:center; font-size: 8pt">
								<xsl:value-of select="3"/>
							</td>
							<td class="bottom-right-mixed" style="text-align:center; font-size: 8pt">
								<xsl:value-of select="4"/>
							</td>
							<td class="bottom-right-mixed" style="text-align:center; font-size: 8pt">
								<xsl:value-of select="5"/>
							</td>
							<td class="bottom-bold" style="text-align:center; font-size: 8pt">
								<xsl:value-of select="6"/>
							</td>
						</tr>
						<xsl:for-each select="KosztyPozycje/Pozycja">
							<tr>
								<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
									<xsl:value-of select="'M'"/>
								</td>
								<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
									<xsl:value-of select="Dzial"/>
								</td>
								<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
									<xsl:value-of select="Rozdzial"/>
								</td>
								<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
									<xsl:value-of select="concat(Paragraf, P4)"/>
								</td>
								<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; padding: 3px">
									<xsl:choose>
										<xsl:when test="P">
											<xsl:value-of select="format-number(P, '#&#160;##0,00')"/>
										</xsl:when>
										<xsl:otherwise>
											<xsl:value-of select="'0,00'"/>
										</xsl:otherwise>
									</xsl:choose>
								</td>
								<td class="bottom-normal" style="text-align: right; font-size: 8pt; padding: 3px">
									<xsl:choose>
										<xsl:when test="W">
											<xsl:value-of select="format-number(W, '#&#160;##0,00')"/>
										</xsl:when>
										<xsl:otherwise>
											<xsl:value-of select="'0,00'"/>
										</xsl:otherwise>
									</xsl:choose>
								</td>
							</tr>
						</xsl:for-each>
						<xsl:apply-templates select="KosztyPodsumowanie">
							<xsl:with-param name="SymPoz" select="Naglowek/SymbolPozabudzetowy"/>
							<xsl:with-param name="Dzial" select="Naglowek/Dzial"/>
							<xsl:with-param name="Rozdzial" select="Naglowek/Rozdzial"/>
						</xsl:apply-templates>
					</tbody>
				</table>
				<div style="margin-bottom: 20px">
					<div style="display: block; font-size: 7pt;margin-bottom:0">
						<sup>1)</sup> niepotrzebne skreślić
          </div>
				</div>
				<table cellpadding="0" cellspacing="0">
					<tbody>
						<tr>
							<td style="width: 450px">
								<div style="font-size: 10pt; font-weight: bold; margin-left: 5px">C.</div>
							</td>
							<td style="width: 120px">
								<!-- <div style="font-size: 9pt">strona 3</div> -->
							</td>
							<td style="width: 350px">
								<!-- <div style="font-size: 9pt">sprawozdania Rb-30s, Dział <xsl:value-of select="Naglowek/Dzial"/>, Rozdział <xsl:value-of select="Naglowek/Rozdzial"/>, <xsl:value-of select="../../Nazwa"/>
								</div> -->
							</td>
						</tr>
					</tbody>
				</table>
				<table cellpadding="0" cellspacing="0" class="all-bold" style="margin-bottom: 10px">
					<tbody>
						<tr>
							<td class="bottom-right-mixed" style="font-size: 10pt; text-align: center; width: 80px">Kod pozycji</td>
							<td class="bottom-right-mixed" style="font-size: 10pt; text-align: center; width: 90px">Symbol</td>
							<td class="bottom-right-mixed" style="font-size: 10pt; text-align: center; width: 360px; min-width: 320px">Wyszczególnienie</td>
							<td class="bottom-right-mixed" style="font-size: 10pt; text-align: center; width: 260px; min-width: 220px">Stan na początek okresu sprawozdawczego</td>
							<td class="bottom-bold" style="font-size: 10pt; text-align: center; width: 260px; min-width: 220px">Stan na koniec okresu sprawozdawczego</td>
						</tr>
						<tr>
							<td class="bottom-right-mixed" style="text-align:center; font-size: 8pt">
								<xsl:value-of select="1"/>
							</td>
							<td class="bottom-right-mixed" style="text-align:center; font-size: 8pt">
								<xsl:value-of select="2"/>
							</td>
							<td class="bottom-right-mixed" style="text-align: center; font-size: 8pt">
								<xsl:value-of select="$nbsp"/>
							</td>
							<td class="bottom-right-mixed" style="text-align:center; font-size: 8pt">
								<xsl:value-of select="3"/>
							</td>
							<td class="bottom-bold" style="text-align:center; font-size: 8pt">
								<xsl:value-of select="4"/>
							</td>
						</tr>
						<xsl:call-template name="Rb-30s_danePozycjeC">
							<xsl:with-param name="kod" select="'W'"/>
							<xsl:with-param name="symbol" select="'010'"/>
							<xsl:with-param name="wyszczeg" select="'Środki pieniężne (w tym środki w kasie)'"/>
						</xsl:call-template>
						<xsl:call-template name="Rb-30s_danePozycjeC">
							<xsl:with-param name="kod" select="'W'"/>
							<xsl:with-param name="symbol" select="'020'"/>
							<xsl:with-param name="wyszczeg" select="'Należności netto'"/>
							<xsl:with-param name="annotation" select="'1'"/>
						</xsl:call-template>
						<xsl:call-template name="Rb-30s_danePozycjeC">
							<xsl:with-param name="kod" select="'W'"/>
							<xsl:with-param name="symbol" select="'021'"/>
							<xsl:with-param name="wyszczeg" select="'Kwota odpisu aktualizującego należności'"/>
						</xsl:call-template>
						<xsl:call-template name="Rb-30s_danePozycjeC">
							<xsl:with-param name="kod" select="'W'"/>
							<xsl:with-param name="symbol" select="'022'"/>
							<xsl:with-param name="wyszczeg" select="'Odsetki od należności niezapłaconych w terminie (niebojęte odpisem aktualizacyjnym)'"/>
						</xsl:call-template>
						<xsl:call-template name="Rb-30s_danePozycjeC">
							<xsl:with-param name="kod" select="'W'"/>
							<xsl:with-param name="symbol" select="'023'"/>
							<xsl:with-param name="wyszczeg" select="'Należności netto wymagalne'"/>
						</xsl:call-template>
						<xsl:call-template name="Rb-30s_danePozycjeC">
							<xsl:with-param name="kod" select="'W'"/>
							<xsl:with-param name="symbol" select="'030'"/>
							<xsl:with-param name="wyszczeg" select="'Pozostałe środki obrotowe'"/>
						</xsl:call-template>
						<xsl:call-template name="Rb-30s_danePozycjeC">
							<xsl:with-param name="kod" select="'W'"/>
							<xsl:with-param name="symbol" select="'040'"/>
							<xsl:with-param name="wyszczeg" select="'Zobowiązania i inne rozliczenia'"/>
						</xsl:call-template>
						<tr>
							<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
								<xsl:value-of select="'W'"/>
							</td>
							<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
								<xsl:value-of select="'041'"/>
							</td>
							<td class="bottom-right-normal" style="text-align: left; font-size: 8pt; padding: 3px">
								<div style="margin: 0">w tym</div>
								<div style="margin: 0">wobec inwestycji finansowanych z:</div>
								<div style="margin: 0 0 0 15px">środków własnych</div>
							</td>
							<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; padding: 3px">
								<xsl:choose>
									<xsl:when test="Stan/Pozycja[child::Kod = 'W' and child::Symbol = '041']/P">
										<xsl:value-of select="format-number(Stan/Pozycja[child::Kod = 'W' and child::Symbol = '041']/P, '#&#160;##0,00')"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="'0,00'"/>
									</xsl:otherwise>
								</xsl:choose>
							</td>
							<td class="bottom-normal" style="text-align: right; font-size: 8pt; padding: 3px">
								<xsl:choose>
									<xsl:when test="Stan/Pozycja[child::Kod = 'W' and child::Symbol = '041']/K">
										<xsl:value-of select="format-number(Stan/Pozycja[child::Kod = 'W' and child::Symbol = '041']/K, '#&#160;##0,00')"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="'0,00'"/>
									</xsl:otherwise>
								</xsl:choose>
							</td>
						</tr>
						<tr>
							<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
								<xsl:value-of select="'W'"/>
							</td>
							<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
								<xsl:value-of select="'042'"/>
							</td>
							<td class="bottom-right-normal" style="text-align: left; font-size: 8pt; padding: 3px">
								<div style="margin: 0 0 0 15px">dotacji</div>
							</td>
							<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; padding: 3px">
								<xsl:choose>
									<xsl:when test="Stan/Pozycja[child::Kod = 'W' and child::Symbol = '042']/P">
										<xsl:value-of select="format-number(Stan/Pozycja[child::Kod = 'W' and child::Symbol = '042']/P, '#&#160;##0,00')"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="'0,00'"/>
									</xsl:otherwise>
								</xsl:choose>
							</td>
							<td class="bottom-normal" style="text-align: right; font-size: 8pt; padding: 3px">
								<xsl:choose>
									<xsl:when test="Stan/Pozycja[child::Kod = 'W' and child::Symbol = '042']/K">
										<xsl:value-of select="format-number(Stan/Pozycja[child::Kod = 'W' and child::Symbol = '042']/K, '#&#160;##0,00')"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="'0,00'"/>
									</xsl:otherwise>
								</xsl:choose>
							</td>
						</tr>
						<tr>
							<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
								<xsl:value-of select="'W'"/>
							</td>
							<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
								<xsl:value-of select="'043'"/>
							</td>
							<td class="bottom-right-normal" style="text-align: left; font-size: 8pt; padding: 3px">
								<div style="margin: 0 0 0 15px">środków z innych źródeł</div>
							</td>
							<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; padding: 3px">
								<xsl:choose>
									<xsl:when test="Stan/Pozycja[child::Kod = 'W' and child::Symbol = '043']/P">
										<xsl:value-of select="format-number(Stan/Pozycja[child::Kod = 'W' and child::Symbol = '043']/P, '#&#160;##0,00')"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="'0,00'"/>
									</xsl:otherwise>
								</xsl:choose>
							</td>
							<td class="bottom-normal" style="text-align: right; font-size: 8pt; padding: 3px">
								<xsl:choose>
									<xsl:when test="Stan/Pozycja[child::Kod = 'W' and child::Symbol = '043']/K">
										<xsl:value-of select="format-number(Stan/Pozycja[child::Kod = 'W' and child::Symbol = '043']/K, '#&#160;##0,00')"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="'0,00'"/>
									</xsl:otherwise>
								</xsl:choose>
							</td>
						</tr>
						<xsl:call-template name="Rb-30s_danePozycjeC">
							<xsl:with-param name="kod" select="'W'"/>
							<xsl:with-param name="symbol" select="'044'"/>
							<xsl:with-param name="wyszczeg" select="'Zobowiązania wymagalne'"/>
						</xsl:call-template>
						<xsl:call-template name="Rb-30s_danePozycjeC">
							<xsl:with-param name="kod" select="'W'"/>
							<xsl:with-param name="symbol" select="'070'"/>
							<xsl:with-param name="wyszczeg" select="'Stan środków obrotowych netto (W010+W020+W030-W040)'"/>
							<xsl:with-param name="pogrWyszczeg" select="true()"/>
						</xsl:call-template>
						<tr>
							<td class="bottom-right-normal"/>
							<td class="bottom-right-normal"/>
							<td class="bottom-right-normal" style="text-align: left; font-size: 8pt; font-weight: bold; padding: 3px">Dane uzupełniające dot. należności i zobowiązań</td>
							<td class="bottom-right-normal" style="text-align: center; font-size: 9pt">X</td>
							<td class="bottom-right-normal" style="text-align: center; font-size: 9pt">X</td>
						</tr>
						<xsl:call-template name="Rb-30s_danePozycjeC">
							<xsl:with-param name="kod" select="'W'"/>
							<xsl:with-param name="symbol" select="'080'"/>
							<xsl:with-param name="wyszczeg" select="'Należności od pracowników'"/>
						</xsl:call-template>
						<xsl:call-template name="Rb-30s_danePozycjeC">
							<xsl:with-param name="kod" select="'W'"/>
							<xsl:with-param name="symbol" select="'081'"/>
							<xsl:with-param name="wyszczeg" select="'Należności z tytułu sprzedaży dóbr i usług'"/>
						</xsl:call-template>
						<xsl:call-template name="Rb-30s_danePozycjeC">
							<xsl:with-param name="kod" select="'W'"/>
							<xsl:with-param name="symbol" select="'090'"/>
							<xsl:with-param name="wyszczeg" select="'Zobowiązania z tytułu wynagrodzeń'"/>
						</xsl:call-template>
						<xsl:call-template name="Rb-30s_danePozycjeC">
							<xsl:with-param name="kod" select="'W'"/>
							<xsl:with-param name="symbol" select="'091'"/>
							<xsl:with-param name="wyszczeg" select="'Zobowiązania z tytułu składek na ubezpieczenia społeczne'"/>
						</xsl:call-template>
						<tr>
							<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
								<xsl:value-of select="'W'"/>
							</td>
							<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
								<xsl:value-of select="'092'"/>
							</td>
							<td class="bottom-right-normal" style="text-align: left; font-size: 8pt; padding: 3px">
								<div style="margin: 0">w tym z tytułu:</div>
								<div style="margin: 0 0 0 15px">składek na FUS</div>
							</td>
							<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; padding: 3px">
								<xsl:choose>
									<xsl:when test="Stan/Pozycja[child::Kod = 'W' and child::Symbol = '092']/P">
										<xsl:value-of select="format-number(Stan/Pozycja[child::Kod = 'W' and child::Symbol = '092']/P, '#&#160;##0,00')"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="'0,00'"/>
									</xsl:otherwise>
								</xsl:choose>
							</td>
							<td class="bottom-normal" style="text-align: right; font-size: 8pt; padding: 3px">
								<xsl:choose>
									<xsl:when test="Stan/Pozycja[child::Kod = 'W' and child::Symbol = '092']/K">
										<xsl:value-of select="format-number(Stan/Pozycja[child::Kod = 'W' and child::Symbol = '092']/K, '#&#160;##0,00')"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="'0,00'"/>
									</xsl:otherwise>
								</xsl:choose>
							</td>
						</tr>
						<tr>
							<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
								<xsl:value-of select="'W'"/>
							</td>
							<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
								<xsl:value-of select="'093'"/>
							</td>
							<td class="bottom-right-normal" style="text-align: left; font-size: 8pt; padding: 3px">
								<div style="margin: 0 0 0 15px">składek na Fundusz Pracy</div>
							</td>
							<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; padding: 3px">
								<xsl:choose>
									<xsl:when test="Stan/Pozycja[child::Kod = 'W' and child::Symbol = '093']/P">
										<xsl:value-of select="format-number(Stan/Pozycja[child::Kod = 'W' and child::Symbol = '093']/P, '#&#160;##0,00')"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="'0,00'"/>
									</xsl:otherwise>
								</xsl:choose>
							</td>
							<td class="bottom-normal" style="text-align: right; font-size: 8pt; padding: 3px">
								<xsl:choose>
									<xsl:when test="Stan/Pozycja[child::Kod = 'W' and child::Symbol = '093']/K">
										<xsl:value-of select="format-number(Stan/Pozycja[child::Kod = 'W' and child::Symbol = '093']/K, '#&#160;##0,00')"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="'0,00'"/>
									</xsl:otherwise>
								</xsl:choose>
							</td>
						</tr>
						<xsl:call-template name="Rb-30s_danePozycjeC">
							<xsl:with-param name="kod" select="'W'"/>
							<xsl:with-param name="symbol" select="'094'"/>
							<xsl:with-param name="wyszczeg" select="'Zobowiązania z tytułu zakupu dóbr i usług'"/>
							<xsl:with-param name="ostWiersz" select="true()"/>
						</xsl:call-template>
					</tbody>
				</table>
				<div style="margin-bottom: 20px">
					<div style="display: block; font-size: 7pt">
						<sup>1)</sup> kwota należności pomniejszona o odpis aktualizujący należności
          </div>
				</div>
				<table cellpadding="0" cellspacing="0">
					<tbody>
						<tr>
							<td style="width: 450px">
								<div style="font-size: 10pt; font-weight: bold; margin-left: 5px; margin-bottom: 10px">D. DANE UZUPEŁNIAJĄCE</div>
							</td>
							<td style="width: 120px">
								<!-- <div style="font-size: 9pt">strona 4</div> -->
							</td>
							<td style="width: 350px">
								<!-- <div style="font-size: 9pt">sprawozdania Rb-30s, Dział <xsl:value-of select="Naglowek/Dzial"/>, Rozdział <xsl:value-of select="Naglowek/Rozdzial"/>, <xsl:value-of select="../../Nazwa"/>
								</div> -->
							</td>
						</tr>
						<tr>
							<td colspan="3">
								<div style="font-size: 9pt; font-weight: bold; margin-left: 5px">1. Informacja o finansowaniu inwestycji samorządowego zakładu budżetowego</div>
							</td>
						</tr>
					</tbody>
				</table>
				<table cellpadding="0" cellspacing="0" class="all-bold" style="margin-bottom: 20px">
					<tbody>
						<tr>
							<td class="bottom-right-mixed" style="font-size: 10pt; text-align: center; width: 80px">Kod poz.</td>
							<td class="bottom-right-mixed" style="font-size: 10pt; text-align: center; width: 90px">Symbol</td>
							<td class="bottom-right-mixed" style="font-size: 10pt; text-align: center; width: 360px; min-width: 320px">Wyszczególnienie</td>
							<td class="bottom-right-mixed" style="font-size: 10pt; text-align: center; width: 260px; min-width: 220px">Plan</td>
							<td class="bottom-bold" style="font-size: 10pt; text-align: center; width: 260px; min-width: 220px">Wykonanie na koniec okresu sprawozdawczego</td>
						</tr>
						<tr>
							<td class="bottom-right-mixed" style="text-align:center; font-size: 8pt">
								<xsl:value-of select="1"/>
							</td>
							<td class="bottom-right-mixed" style="text-align:center; font-size: 8pt">
								<xsl:value-of select="2"/>
							</td>
							<td class="bottom-right-mixed" style="text-align: center; font-size: 8pt">
								<xsl:value-of select="$nbsp"/>
							</td>
							<td class="bottom-right-mixed" style="text-align:center; font-size: 8pt">
								<xsl:value-of select="3"/>
							</td>
							<td class="bottom-bold" style="text-align:center; font-size: 8pt">
								<xsl:value-of select="4"/>
							</td>
						</tr>
						<tr>
							<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
								<xsl:value-of select="'U'"/>
							</td>
							<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
								<xsl:value-of select="'100'"/>
							</td>
							<td class="bottom-right-normal" style="text-align: left; font-size: 8pt; padding: 3px">
								<xsl:value-of select="'Wydatki inwestycyjne'"/>
							</td>
							<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; padding: 3px">
								<xsl:choose>
									<xsl:when test="Finansowanie/Pozycja[child::Kod = 'U' and child::Symbol = '100']/P">
										<xsl:value-of select="format-number(Finansowanie/Pozycja[child::Kod = 'U' and child::Symbol = '100']/P, '#&#160;##0,00')"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="'0,00'"/>
									</xsl:otherwise>
								</xsl:choose>
							</td>
							<td class="bottom-normal" style="text-align: right; font-size: 8pt; padding: 3px">
								<xsl:choose>
									<xsl:when test="Finansowanie/Pozycja[child::Kod = 'U' and child::Symbol = '100']/W">
										<xsl:value-of select="format-number(Finansowanie/Pozycja[child::Kod = 'U' and child::Symbol = '100']/W, '#&#160;##0,00')"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="'0,00'"/>
									</xsl:otherwise>
								</xsl:choose>
							</td>
						</tr>
						<tr>
							<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
								<xsl:value-of select="'U'"/>
							</td>
							<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
								<xsl:value-of select="'200'"/>
							</td>
							<td class="bottom-right-normal" style="text-align: left; font-size: 8pt; padding: 3px">
								<xsl:value-of select="'Źródła finansowania wydatków inwestycyjnych:'"/>
							</td>
							<td class="bottom-right-normal" style="text-align: center; font-size: 9pt">X</td>
							<td class="bottom-right-normal" style="text-align: center; font-size: 9pt">X</td>
						</tr>
						<tr>
							<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
								<xsl:value-of select="'U'"/>
							</td>
							<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
								<xsl:value-of select="'201'"/>
							</td>
							<td class="bottom-right-normal" style="text-align: left; font-size: 8pt; padding: 3px">
								<div style="margin: 0 0 0 15px">- środki z lat ubiegłych</div>
							</td>
							<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; padding: 3px">
								<xsl:choose>
									<xsl:when test="Finansowanie/Pozycja[child::Kod = 'U' and child::Symbol = '201']/P">
										<xsl:value-of select="format-number(Finansowanie/Pozycja[child::Kod = 'U' and child::Symbol = '201']/P, '#&#160;##0,00')"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="'0,00'"/>
									</xsl:otherwise>
								</xsl:choose>
							</td>
							<td class="bottom-normal" style="text-align: right; font-size: 8pt; padding: 3px">
								<xsl:choose>
									<xsl:when test="Finansowanie/Pozycja[child::Kod = 'U' and child::Symbol = '201']/W">
										<xsl:value-of select="format-number(Finansowanie/Pozycja[child::Kod = 'U' and child::Symbol = '201']/W, '#&#160;##0,00')"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="'0,00'"/>
									</xsl:otherwise>
								</xsl:choose>
							</td>
						</tr>
						<tr>
							<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
								<xsl:value-of select="'U'"/>
							</td>
							<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
								<xsl:value-of select="'202'"/>
							</td>
							<td class="bottom-right-normal" style="text-align: left; font-size: 8pt; padding: 3px">
								<div style="margin: 0 0 0 15px">- dotacje celowe</div>
							</td>
							<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; padding: 3px">
								<xsl:choose>
									<xsl:when test="Finansowanie/Pozycja[child::Kod = 'U' and child::Symbol = '202']/P">
										<xsl:value-of select="format-number(Finansowanie/Pozycja[child::Kod = 'U' and child::Symbol = '202']/P, '#&#160;##0,00')"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="'0,00'"/>
									</xsl:otherwise>
								</xsl:choose>
							</td>
							<td class="bottom-normal" style="text-align: right; font-size: 8pt; padding: 3px">
								<xsl:choose>
									<xsl:when test="Finansowanie/Pozycja[child::Kod = 'U' and child::Symbol = '202']/W">
										<xsl:value-of select="format-number(Finansowanie/Pozycja[child::Kod = 'U' and child::Symbol = '202']/W, '#&#160;##0,00')"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="'0,00'"/>
									</xsl:otherwise>
								</xsl:choose>
							</td>
						</tr>
						<tr>
							<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
								<xsl:value-of select="'U'"/>
							</td>
							<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
								<xsl:value-of select="'203'"/>
							</td>
							<td class="bottom-right-normal" style="text-align: left; font-size: 8pt; padding: 3px">
								<div style="margin: 0 0 0 15px">- środki własne</div>
							</td>
							<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; padding: 3px">
								<xsl:choose>
									<xsl:when test="Finansowanie/Pozycja[child::Kod = 'U' and child::Symbol = '203']/P">
										<xsl:value-of select="format-number(Finansowanie/Pozycja[child::Kod = 'U' and child::Symbol = '203']/P, '#&#160;##0,00')"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="'0,00'"/>
									</xsl:otherwise>
								</xsl:choose>
							</td>
							<td class="bottom-normal" style="text-align: right; font-size: 8pt; padding: 3px">
								<xsl:choose>
									<xsl:when test="Finansowanie/Pozycja[child::Kod = 'U' and child::Symbol = '203']/W">
										<xsl:value-of select="format-number(Finansowanie/Pozycja[child::Kod = 'U' and child::Symbol = '203']/W, '#&#160;##0,00')"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="'0,00'"/>
									</xsl:otherwise>
								</xsl:choose>
							</td>
						</tr>
						<tr>
							<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
								<xsl:value-of select="'U'"/>
							</td>
							<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
								<xsl:value-of select="'204'"/>
							</td>
							<td class="bottom-right-normal" style="text-align: left; font-size: 8pt; padding: 3px">
								<div style="margin: 0 0 0 15px">- inne środki</div>
							</td>
							<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; padding: 3px">
								<xsl:choose>
									<xsl:when test="Finansowanie/Pozycja[child::Kod = 'U' and child::Symbol = '204']/P">
										<xsl:value-of select="format-number(Finansowanie/Pozycja[child::Kod = 'U' and child::Symbol = '204']/P, '#&#160;##0,00')"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="'0,00'"/>
									</xsl:otherwise>
								</xsl:choose>
							</td>
							<td class="bottom-normal" style="text-align: right; font-size: 8pt; padding: 3px">
								<xsl:choose>
									<xsl:when test="Finansowanie/Pozycja[child::Kod = 'U' and child::Symbol = '204']/W">
										<xsl:value-of select="format-number(Finansowanie/Pozycja[child::Kod = 'U' and child::Symbol = '204']/W, '#&#160;##0,00')"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="'0,00'"/>
									</xsl:otherwise>
								</xsl:choose>
							</td>
						</tr>
						<tr>
							<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
								<xsl:value-of select="'U'"/>
							</td>
							<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
								<xsl:value-of select="'300'"/>
							</td>
							<td class="bottom-right-normal" style="text-align: left; font-size: 8pt; padding: 3px">
								<xsl:value-of select="'Zobowiązania dotyczące inwestycji:'"/>
							</td>
							<td class="bottom-right-normal" style="text-align: center; font-size: 9pt">X</td>
							<td class="bottom-right-normal" style="text-align: center; font-size: 9pt">X</td>
						</tr>
						<tr>
							<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
								<xsl:value-of select="'U'"/>
							</td>
							<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
								<xsl:value-of select="'301'"/>
							</td>
							<td class="bottom-right-normal" style="text-align: left; font-size: 8pt; padding: 3px">
								<div style="margin: 0 0 0 15px">- na początek okresu sprawozdawczego</div>
							</td>
							<td class="bottom-right-normal" style="text-align: center; font-size: 9pt">X</td>
							<td class="bottom-normal" style="text-align: right; font-size: 8pt; padding: 3px">
								<xsl:choose>
									<xsl:when test="Finansowanie/Pozycja[child::Kod = 'U' and child::Symbol = '301']/W">
										<xsl:value-of select="format-number(Finansowanie/Pozycja[child::Kod = 'U' and child::Symbol = '301']/W, '#&#160;##0,00')"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="'0,00'"/>
									</xsl:otherwise>
								</xsl:choose>
							</td>
						</tr>
						<tr>
							<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
								<xsl:value-of select="'U'"/>
							</td>
							<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
								<xsl:value-of select="'302'"/>
							</td>
							<td class="bottom-right-normal" style="text-align: left; font-size: 8pt; padding: 3px">
								<div style="margin: 0 0 0 15px">- na koniec okresu sprawozdawczego</div>
							</td>
							<td class="bottom-right-normal" style="text-align: center; font-size: 9pt">X</td>
							<td class="bottom-normal" style="text-align: right; font-size: 8pt; padding: 3px">
								<xsl:choose>
									<xsl:when test="Finansowanie/Pozycja[child::Kod = 'U' and child::Symbol = '302']/W">
										<xsl:value-of select="format-number(Finansowanie/Pozycja[child::Kod = 'U' and child::Symbol = '302']/W, '#&#160;##0,00')"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="'0,00'"/>
									</xsl:otherwise>
								</xsl:choose>
							</td>
						</tr>
						<tr>
							<td class="right-normal" style="text-align: center; font-size: 8pt">
								<xsl:value-of select="'U'"/>
							</td>
							<td class="right-normal" style="text-align: center; font-size: 8pt">
								<xsl:value-of select="'303'"/>
							</td>
							<td class="right-normal" style="text-align: left; font-size: 8pt; padding: 3px">Zobowiązania wobec budżetu z tytułu zwrotu dotacji na inwestycje</td>
							<td class="right-normal" style="text-align: center; font-size: 9pt">X</td>
							<td class="bottom-normal" style="text-align: right; font-size: 8pt; padding: 3px">
								<xsl:choose>
									<xsl:when test="Finansowanie/Pozycja[child::Kod = 'U' and child::Symbol = '303']/W">
										<xsl:value-of select="format-number(Finansowanie/Pozycja[child::Kod = 'U' and child::Symbol = '303']/W, '#&#160;##0,00')"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="'0,00'"/>
									</xsl:otherwise>
								</xsl:choose>
							</td>
						</tr>
					</tbody>
				</table>
				<table cellpadding="0" cellspacing="0">
					<tbody>
						<tr>
							<td colspan="3">
								<div style="font-size: 9pt; font-weight: bold; margin-left: 5px">2. Informacja o rozliczeniu kasowym z budżetem - w okresie od dnia 1 stycznia do końca okresu sprawozdawczego</div>
							</td>
						</tr>
					</tbody>
				</table>
				<table cellpadding="0" cellspacing="0" class="all-bold" style="margin-bottom: 60px">
					<tbody>
						<tr>
							<td class="bottom-right-mixed" style="font-size: 10pt; text-align: center; width: 80px">Kod poz.</td>
							<td class="bottom-right-mixed" style="font-size: 10pt; text-align: center; width: 90px">Symbol</td>
							<td class="bottom-right-mixed" style="font-size: 10pt; text-align: center; width: 360px; min-width: 320px">Wyszczególnienie</td>
							<td class="bottom-right-mixed" style="font-size: 10pt; text-align: center; width: 260px; min-width: 220px">Za poprzedni rok budżetowy</td>
							<td class="bottom-bold" style="font-size: 10pt; text-align: center; width: 260px; min-width: 220px">Za okres sprawozdawczy</td>
						</tr>
						<tr>
							<td class="bottom-right-mixed" style="text-align:center; font-size: 8pt">
								<xsl:value-of select="1"/>
							</td>
							<td class="bottom-right-mixed" style="text-align:center; font-size: 8pt">
								<xsl:value-of select="2"/>
							</td>
							<td class="bottom-right-mixed" style="text-align: center; font-size: 8pt">
								<xsl:value-of select="3"/>
							</td>
							<td class="bottom-right-mixed" style="text-align:center; font-size: 8pt">
								<xsl:value-of select="4"/>
							</td>
							<td class="bottom-bold" style="text-align:center; font-size: 8pt">
								<xsl:value-of select="5"/>
							</td>
						</tr>
						<xsl:call-template name="Rb-30s_danePozycjeE">
							<xsl:with-param name="kod" select="'Z'"/>
							<xsl:with-param name="symbol" select="'100'"/>
							<xsl:with-param name="wyszczeg" select="'Podatek dochodowy od osób prawnych'"/>
						</xsl:call-template>
						<xsl:call-template name="Rb-30s_danePozycjeE">
							<xsl:with-param name="kod" select="'Z'"/>
							<xsl:with-param name="symbol" select="'101'"/>
							<xsl:with-param name="wyszczeg" select="'Wpłata nadwyżki środków obrotowych'"/>
						</xsl:call-template>
					</tbody>
				</table>
				<table cellpadding="0" cellspacing="0" class="all-bold" style="margin-bottom: 20px; width: 58%">
					<tbody>
						<tr style="height: 30px" valign="top">
							<td style="font-size: 9pt; font-weight: bold; text-align:left; padding: 3px 10px; margin-left: 5px; margin-bottom: 25px">Wyjaśnienia do sprawozdania Rb-30s</td>
						</tr>
						<tr style="min-height: 50px; height: 70px" valign="top">
							<td style="text-align: left; font-size: 8pt; padding: 3px 10px; border-width: 4px 0 0 0; border-style: solid; border-color: black">
								<xsl:value-of select="Naglowek/Uwagi"/>
							</td>
						</tr>
					</tbody>
				</table>
				<!-- ewentualne uwagi z pozycji -->
				<xsl:if test="PrzychodyPozycje/Pozycja[child::Uwagi] or PrzychodyPodsumowanie/Pozycja[child::Uwagi]">
					<table cellpadding="0" cellspacing="0" class="all-bold" style="margin-bottom: 20px; width: 100%">
						<tbody>
							<tr>
								<td colspan="6" style="text-align: center; font-size: 9pt; font-weight: bold; padding: 3px 10px">
									<div>Uwagi do części: "Przychody"</div>
								</td>
							</tr>
							<tr>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 4px 4px 0; width: 6%">Kod pozycji</td>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 4px 4px 0; width: 10%">Dział</td>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 4px 4px 0; width: 10%">Rozdział</td>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 4px 4px 0; width: 10%">Paragraf</td>
								<td colspan="2" style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 0 4px 0">Uwaga</td>
							</tr>
							<xsl:for-each select="PrzychodyPozycje/Pozycja[child::Uwagi]">
								<xsl:sort select="Paragraf"/>
								<tr>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="'G'"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="Dzial"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="Rozdzial"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="concat(Paragraf, P4)"/>
									</td>
									<td colspan="2" class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:value-of select="Uwagi"/>
									</td>
								</tr>
							</xsl:for-each>
							<xsl:if test="PrzychodyPodsumowanie/Pozycja[child::Kod = 'I' and child::Symbol = '110' and child::Uwagi]">
								<tr>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="PrzychodyPodsumowanie/Pozycja[child::Kod = 'I' and child::Symbol = '110']/Kod"/>
									</td>
									<td colspan="3" class="bottom-right-normal" style="font-size:8pt;text-align: left; padding: 3px 10px">
										<xsl:value-of select="'110 (Pokrycie amortyzacji)'"/>
									</td>
									<td colspan="2" class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:value-of select="PrzychodyPodsumowanie/Pozycja[child::Kod = 'I' and child::Symbol = '110']/Uwagi"/>
									</td>
								</tr>
							</xsl:if>
							<xsl:if test="PrzychodyPodsumowanie/Pozycja[child::Kod = 'K' and child::Symbol = '100' and child::Uwagi]">
								<tr>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="PrzychodyPodsumowanie/Pozycja[child::Kod = 'K' and child::Symbol = '100']/Kod"/>
									</td>
									<td colspan="3" class="bottom-right-normal" style="font-size:8pt;text-align:left;padding: 3px 10px">
										<xsl:value-of select="'100 (Inne zwiększenia)'"/>
									</td>
									<td colspan="2" class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:value-of select="PrzychodyPodsumowanie/Pozycja[child::Kod = 'K' and child::Symbol = '100']/Uwagi"/>
									</td>
								</tr>
							</xsl:if>
							<xsl:if test="PrzychodyPodsumowanie/Pozycja[child::Kod = 'H' and child::Uwagi]">
								<tr>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="PrzychodyPodsumowanie/Pozycja[child::Kod = 'H']/Kod"/>
									</td>
									<td colspan="3" class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:value-of select="'Razem'"/>
									</td>
									<td colspan="2" class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:value-of select="PrzychodyPodsumowanie/Pozycja[child::Kod = 'H']/Uwagi"/>
									</td>
								</tr>
							</xsl:if>
							<xsl:if test="PrzychodyPodsumowanie/Pozycja[child::Kod = 'K' and child::Symbol = '110' and child::Uwagi]">
								<tr>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="PrzychodyPodsumowanie/Pozycja[child::Kod = 'K' and child::Symbol = '110']/Kod"/>
									</td>
									<td colspan="3" class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:value-of select="'110 (Stan środków obrotowych netto na początku okresu sprawozdawczego)'"/>
									</td>
									<td colspan="2" class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:value-of select="PrzychodyPodsumowanie/Pozycja[child::Kod = 'K' and child::Symbol = '110']/Uwagi"/>
									</td>
								</tr>
							</xsl:if>
							<xsl:if test="PrzychodyPodsumowanie/Pozycja[child::Kod = 'L' and child::Symbol = '190' and child::Uwagi]">
								<tr>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="PrzychodyPodsumowanie/Pozycja[child::Kod = 'L' and child::Symbol = '190']/Kod"/>
									</td>
									<td colspan="3" class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:value-of select="'190 Ogółem (H+K110)'"/>
									</td>
									<td colspan="2" class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:value-of select="PrzychodyPodsumowanie/Pozycja[child::Kod = 'L' and child::Symbol = '190']/Uwagi"/>
									</td>
								</tr>
							</xsl:if>
						</tbody>
					</table>
				</xsl:if>
				<xsl:if test="KosztyPozycje/Pozycja[child::Uwagi] or KosztyPodsumowanie/Pozycja[child::Uwagi]">
					<table cellpadding="0" cellspacing="0" class="all-bold" style="margin-bottom: 20px; width: 100%">
						<tbody>
							<tr>
								<td colspan="6" style="text-align: center; font-size: 9pt; font-weight: bold; padding: 3px 10px">
									<div>Uwagi do części: "Koszty"</div>
								</td>
							</tr>
							<tr>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 4px 4px 0; width: 6%">Kod pozycji</td>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 4px 4px 0; width: 10%">Dział</td>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 4px 4px 0; width: 10%">Rozdział</td>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 4px 4px 0; width: 10%">Paragraf</td>
								<td colspan="2" style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 0 4px 0">Uwaga</td>
							</tr>
							<xsl:for-each select="KosztyPozycje/Pozycja[child::Uwagi]">
								<xsl:sort select="Paragraf"/>
								<tr>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="'M'"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="Dzial"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="Rozdzial"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="concat(Paragraf, P4)"/>
									</td>
									<td colspan="2" class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:value-of select="Uwagi"/>
									</td>
								</tr>
							</xsl:for-each>
							<xsl:if test="KosztyPodsumowanie/Pozycja[child::Kod = 'J' and child::Symbol = '100' and child::Uwagi]">
								<tr>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="KosztyPodsumowanie/Pozycja[child::Kod = 'J' and child::Symbol = '100']/Kod"/>
									</td>
									<td colspan="3" class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:value-of select="'100 (Środki własne zarezerwowane na inwestycje)'"/>
									</td>
									<td colspan="2" class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:value-of select="KosztyPodsumowanie/Pozycja[child::Kod = 'J' and child::Symbol = '100']/Uwagi"/>
									</td>
								</tr>
							</xsl:if>
							<xsl:if test="KosztyPodsumowanie/Pozycja[child::Kod = 'I' and child::Symbol = '100' and child::Uwagi]">
								<tr>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="KosztyPodsumowanie/Pozycja[child::Kod = 'I' and child::Symbol = '100']/Kod"/>
									</td>
									<td colspan="3" class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:value-of select="'100 (Odpisy amortyzacji)'"/>
									</td>
									<td colspan="2" class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:value-of select="KosztyPodsumowanie/Pozycja[child::Kod = 'I' and child::Symbol = '100']/Uwagi"/>
									</td>
								</tr>
							</xsl:if>
							<xsl:if test="KosztyPodsumowanie/Pozycja[child::Kod = 'P' and child::Symbol = '100' and child::Uwagi]">
								<tr>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="KosztyPodsumowanie/Pozycja[child::Kod = 'P' and child::Symbol = '100']/Kod"/>
									</td>
									<td colspan="3" class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:value-of select="'100 (Inne zmniejszenia)'"/>
									</td>
									<td colspan="2" class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:value-of select="KosztyPodsumowanie/Pozycja[child::Kod = 'P' and child::Symbol = '100']/Uwagi"/>
									</td>
								</tr>
							</xsl:if>
							<xsl:if test="KosztyPodsumowanie/Pozycja[child::Kod = 'N' and child::Uwagi]">
								<tr>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="KosztyPodsumowanie/Pozycja[child::Kod = 'N']/Kod"/>
									</td>
									<td colspan="3" class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:value-of select="'Razem'"/>
									</td>
									<td colspan="2" class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:value-of select="KosztyPodsumowanie/Pozycja[child::Kod = 'N']/Uwagi"/>
									</td>
								</tr>
							</xsl:if>
							<xsl:if test="KosztyPodsumowanie/Pozycja[child::Kod = 'P' and child::Symbol = '110' and child::Uwagi]">
								<tr>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="KosztyPodsumowanie/Pozycja[child::Kod = 'P' and child::Symbol = '110']/Kod"/>
									</td>
									<td colspan="3" class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:value-of select="'110 (Podatek dochodowy od osób prawnych)'"/>
									</td>
									<td colspan="2" class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:value-of select="KosztyPodsumowanie/Pozycja[child::Kod = 'P' and child::Symbol = '110']/Uwagi"/>
									</td>
								</tr>
							</xsl:if>
							<xsl:if test="KosztyPodsumowanie/Pozycja[child::Kod = 'P' and child::Symbol = '120' and child::Uwagi]">
								<tr>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="KosztyPodsumowanie/Pozycja[child::Kod = 'P' and child::Symbol = '120']/Kod"/>
									</td>
									<td colspan="3" class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:value-of select="'120 (Wpłata do budżetu nadwyżki środków obrotowych)'"/>
									</td>
									<td colspan="2" class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:value-of select="KosztyPodsumowanie/Pozycja[child::Kod = 'P' and child::Symbol = '120']/Uwagi"/>
									</td>
								</tr>
							</xsl:if>
							<xsl:if test="KosztyPodsumowanie/Pozycja[child::Kod = 'P' and child::Symbol = '130' and child::Uwagi]">
								<tr>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="KosztyPodsumowanie/Pozycja[child::Kod = 'P' and child::Symbol = '130']/Kod"/>
									</td>
									<td colspan="3" class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:value-of select="'130 (Stan środków obrotowych netto na koniec okresu sprawozdawczego)'"/>
									</td>
									<td colspan="2" class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:value-of select="KosztyPodsumowanie/Pozycja[child::Kod = 'P' and child::Symbol = '130']/Uwagi"/>
									</td>
								</tr>
							</xsl:if>
							<xsl:if test="KosztyPodsumowanie/Pozycja[child::Kod = 'S' and child::Symbol = '190' and child::Uwagi]">
								<tr>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="KosztyPodsumowanie/Pozycja[child::Kod = 'S' and child::Symbol = '190']/Kod"/>
									</td>
									<td colspan="3" class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:value-of select="'190 Ogółem (N+P110+P120+P130)'"/>
									</td>
									<td colspan="2" class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:value-of select="KosztyPodsumowanie/Pozycja[child::Kod = 'S' and child::Symbol = '190']/Uwagi"/>
									</td>
								</tr>
							</xsl:if>
						</tbody>
					</table>
				</xsl:if>
				<xsl:if test="Stan/Pozycja[child::Uwagi]">
					<table cellpadding="0" cellspacing="0" class="all-bold" style="margin-bottom: 20px; width: 100%">
						<tbody>
							<tr>
								<td colspan="4" style="text-align: center; font-size: 9pt; font-weight: bold; padding: 3px 10px">
									<div>Uwagi do części: "Stan"</div>
								</td>
							</tr>
							<tr>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 4px 4px 0; width: 4%">Kod</td>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 4px 4px 0; width: 6%">Symbol</td>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 4px 4px 0; width: 30%">Wyszczególnienie</td>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 0 4px 0">Uwaga</td>
							</tr>
							<xsl:for-each select="Stan/Pozycja[child::Uwagi]">
								<xsl:sort select="Symbol"/>
								<tr>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="Kod"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="Symbol"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:choose>
											<xsl:when test="Symbol = '010'">Środki pieniężne (w tym środki w kasie)</xsl:when>
											<xsl:when test="Symbol = '020'">Należności netto</xsl:when>
											<xsl:when test="Symbol = '021'">Kwota odpisu aktualizującego należności</xsl:when>
											<xsl:when test="Symbol = '022'">Kwota odsetek od należności niezapłaconych w terminie</xsl:when>
											<xsl:when test="Symbol = '030'">Pozostałe środki obrotowe</xsl:when>
											<xsl:when test="Symbol = '040'">Zobowiązania i inne rozliczenia</xsl:when>
											<xsl:when test="Symbol = '041'">w tym wobec inwestycji finansowanych ze środków własnych</xsl:when>
											<xsl:when test="Symbol = '042'">dotacji</xsl:when>
											<xsl:when test="Symbol = '043'">środków z innych źródeł</xsl:when>
											<xsl:when test="Symbol = '070'">Stan środków obrotowych netto (W010+W020+W030-W040)</xsl:when>
											<xsl:when test="Symbol = '080'">Należności od pracowników</xsl:when>
											<xsl:when test="Symbol = '081'">Należności z tytułu sprzedaży dóbr i usług</xsl:when>
											<xsl:when test="Symbol = '090'">Zobowiązania z tytułu wynagrodzeń</xsl:when>
											<xsl:when test="Symbol = '091'">Zobowiązania z tytułu składek na ubezpieczenia społeczne</xsl:when>
											<xsl:when test="Symbol = '092'">w tym z tytułu składek na FUS</xsl:when>
											<xsl:when test="Symbol = '093'">składek na Fundusz Pracy</xsl:when>
											<xsl:when test="Symbol = '094'">Zobowiązania z tytułu zakupu dóbr i usług</xsl:when>
										</xsl:choose>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:value-of select="Uwagi"/>
									</td>
								</tr>
							</xsl:for-each>
						</tbody>
					</table>
				</xsl:if>
				<xsl:if test="Finansowanie/Pozycja[child::Uwagi]">
					<table cellpadding="0" cellspacing="0" class="all-bold" style="margin-bottom: 20px; width: 100%">
						<tbody>
							<tr>
								<td colspan="4" style="text-align: center; font-size: 9pt; font-weight: bold; padding: 3px 10px">
									<div>Uwagi do części: "Finansowanie"</div>
								</td>
							</tr>
							<tr>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 4px 4px 0; width: 4%">Kod</td>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 4px 4px 0; width: 6%">Symbol</td>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 4px 4px 0; width: 30%">Wyszczególnienie</td>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 0 4px 0">Uwaga</td>
							</tr>
							<xsl:for-each select="Finansowanie/Pozycja[child::Uwagi]">
								<xsl:sort select="Symbol"/>
								<tr>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="Kod"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="Symbol"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:choose>
											<xsl:when test="Symbol = '100'">Wydatki inwestycyjne</xsl:when>
											<xsl:when test="Symbol = '200'">Źródła finansowania wydatków inwestycyjnych</xsl:when>
											<xsl:when test="Symbol = '201'">- środki z lat ubiegłych</xsl:when>
											<xsl:when test="Symbol = '202'">- dotacje celowe</xsl:when>
											<xsl:when test="Symbol = '203'">- środki własne</xsl:when>
											<xsl:when test="Symbol = '204'">- inne środki</xsl:when>
											<xsl:when test="Symbol = '300'">Zobowiązania dotyczące inwestycji</xsl:when>
											<xsl:when test="Symbol = '301'">na początek okresu sprawozdawczego</xsl:when>
											<xsl:when test="Symbol = '302'">na koniec okresu sprawozdawczego</xsl:when>
											<xsl:when test="Symbol = '303'">Zobowiązania wobec budżetu z tytułu zwrotu dotacji na inwestycje</xsl:when>
										</xsl:choose>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:value-of select="Uwagi"/>
									</td>
								</tr>
							</xsl:for-each>
						</tbody>
					</table>
				</xsl:if>
				<xsl:if test="RozliczenieKasowe/Pozycja[child::Uwagi]">
					<table cellpadding="0" cellspacing="0" class="all-bold" style="margin-bottom: 20px; width: 100%">
						<tbody>
							<tr>
								<td colspan="4" style="text-align: center; font-size: 9pt; font-weight: bold; padding: 3px 10px">
									<div>Uwagi do części: "Rozliczenie"</div>
								</td>
							</tr>
							<tr>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 4px 4px 0; width: 4%">Kod</td>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 4px 4px 0; width: 6%">Symbol</td>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 4px 4px 0; width: 30%">Wyszczególnienie</td>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 0 4px 0">Uwaga</td>
							</tr>
							<xsl:for-each select="RozliczenieKasowe/Pozycja[child::Uwagi]">
								<xsl:sort select="Symbol"/>
								<tr>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="Kod"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="Symbol"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:choose>
											<xsl:when test="Symbol = '100'">Podatek osobowy od osób prawnych</xsl:when>
											<xsl:when test="Symbol = '101'">Wpłata nadwyżki środków obrotowych</xsl:when>
											<xsl:when test="Symbol = '102'">Podatek VAT od otrzymanych dotacji przedmiotowych</xsl:when>
										</xsl:choose>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:value-of select="Uwagi"/>
									</td>
								</tr>
							</xsl:for-each>
						</tbody>
					</table>
				</xsl:if>
				<table cellpadding="0" cellspacing="0" style="margin-bottom: 0px; margin-top: 80px; width: 70%">
					<tbody>
						<tr>
							<td style="text-align:left; font-size: 8pt;" valign="bottom">
								<hr style="width: 63%;text-align:left"/>
								<div>Główny księgowy albo Skarbnik</div>
								<div style="margin-left: 60px;margin-top: 20px">data</div>
							</td>
							<td style="text-align:right; font-size: 8pt;" valign="bottom">
								<hr style="width: 30%; margin-left:810px"/>
								<div>Kierownik jednostki lub Przewodniczący zarządu</div>
								<div style="margin-top: 20px;margin-right:100px">data</div>
							</td>
						</tr>
					</tbody>
				</table>
			</div>
			<xsl:element name="a">
				<xsl:attribute name="href"><xsl:value-of select="concat('#Jed', $jedIndex)"/></xsl:attribute>
				<xsl:element name="style">
					<xsl:value-of select="'font-family: Verdana'"/>
				</xsl:element>
				<xsl:value-of select="'Powrót do listy sprawozdań jednostki'"/>
			</xsl:element>
		</xsl:element>
	</xsl:template>
	<!-- Rb-30s szablony pomocnicze -->
	<xsl:template match="Rb-30s/PrzychodyPodsumowanie">
		<xsl:param name="SymPoz"/>
		<xsl:param name="Dzial"/>
		<xsl:param name="Rozdzial"/>
		<xsl:variable name="Paragrafy" select="parent::*/PrzychodyPozycje/Pozycja/Paragraf"/>
		<xsl:variable name="P4" select="parent::*/PrzychodyPozycje/Pozycja/P4"/>
		<tr>
			<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
				<xsl:value-of select="'I'"/>
			</td>
			<td colspan="3" class="bottom-right-normal" style="text-align: left; font-size: 8pt">
				<xsl:value-of select="'110 (równowartość odpisów amortyzacyjnych)'"/>
			</td>
			<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; padding: 3px">
				<xsl:choose>
					<xsl:when test="Pozycja[child::Kod = 'I' and child::Symbol = '110']/P">
						<xsl:value-of select="format-number(Pozycja[child::Kod = 'I' and child::Symbol = '110']/P, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
			<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; padding: 3px">
				<xsl:choose>
					<xsl:when test="Pozycja[child::Kod = 'I' and child::Symbol = '110']/W">
						<xsl:value-of select="format-number(Pozycja[child::Kod = 'I' and child::Symbol = '110']/W, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
		</tr>
		<tr>
			<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
				<xsl:value-of select="'K'"/>
			</td>
			<td colspan="3" class="bottom-right-normal" style="text-align: left; font-size: 8pt">
				<xsl:value-of select="'100 (Inne zwiększenia)'"/>
			</td>
			<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; padding: 3px">
				<xsl:choose>
					<xsl:when test="Pozycja[child::Kod = 'K' and child::Symbol='100']/P">
						<xsl:value-of select="format-number(Pozycja[child::Kod = 'K' and child::Symbol='100']/P, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
			<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; padding: 3px">
				<xsl:choose>
					<xsl:when test="Pozycja[child::Kod = 'K' and child::Symbol='100']/W">
						<xsl:value-of select="format-number(Pozycja[child::Kod = 'K' and child::Symbol='100']/W, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
		</tr>
		<tr>
			<td class="bottom-right-normal" style="text-align: center; font-size: 8pt; font-weight: bold">
				<xsl:value-of select="'H'"/>
			</td>
			<td colspan="3" class="bottom-right-normal" style="text-align: left; font-size: 9pt; font-weight: bold">
				<xsl:value-of select="'RAZEM '"/>
			</td>
			<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; font-weight: bold; padding: 3px">
				<xsl:choose>
					<xsl:when test="Pozycja[child::Kod = 'H']/P">
						<xsl:value-of select="format-number(Pozycja[child::Kod = 'H']/P, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
			<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; font-weight: bold; padding: 3px">
				<xsl:choose>
					<xsl:when test="Pozycja[child::Kod = 'H']/W">
						<xsl:value-of select="format-number(Pozycja[child::Kod = 'H']/W, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
		</tr>
		<tr>
			<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
				<xsl:value-of select="'K'"/>
			</td>
			<td colspan="3" class="bottom-right-normal" style="text-align: left; font-size: 8pt">
				<xsl:value-of select="'110 (Stan śr. obrot. netto na początku okresu sprawozdawczego)'"/>
			</td>
			<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; padding: 3px">
				<xsl:choose>
					<xsl:when test="Pozycja[child::Kod = 'K' and child::Symbol='110']/P">
						<xsl:value-of select="format-number(Pozycja[child::Kod = 'K' and child::Symbol='110']/P, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
			<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; padding: 3px">
				<xsl:choose>
					<xsl:when test="Pozycja[child::Kod = 'K' and child::Symbol='110']/W">
						<xsl:value-of select="format-number(Pozycja[child::Kod = 'K' and child::Symbol='110']/W, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
		</tr>
		<tr>
			<td class="right-normal" style="text-align: center; font-size: 8pt; font-weight: bold">
				<xsl:value-of select="'L'"/>
			</td>
			<td colspan="3" class="right-normal" style="text-align: left; font-size: 8pt; font-weight: bold">
				<xsl:value-of select="'190 Ogółem (H+K110)'"/>
			</td>
			<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; font-weight: bold; padding: 3px">
				<xsl:choose>
					<xsl:when test="Pozycja[child::Kod = 'L' and child::Symbol='190']/P">
						<xsl:value-of select="format-number(Pozycja[child::Kod = 'L' and child::Symbol='190']/P, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
			<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; font-weight: bold; padding: 3px">
				<xsl:choose>
					<xsl:when test="Pozycja[child::Kod = 'L' and child::Symbol='190']/W">
						<xsl:value-of select="format-number(Pozycja[child::Kod = 'L' and child::Symbol='190']/W, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
		</tr>
	</xsl:template>
	<xsl:template match="Rb-30s/KosztyPodsumowanie">
		<xsl:param name="SymPoz"/>
		<xsl:param name="Dzial"/>
		<xsl:param name="Rozdzial"/>
		<xsl:variable name="Paragrafy" select="parent::*/KosztyPozycje/Pozycja/Paragraf"/>
		<xsl:variable name="P4" select="parent::*/KosztyPozycje/Pozycja/P4"/>
		<tr>
			<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
				<xsl:value-of select="'J'"/>
			</td>
			<td colspan="3" class="bottom-right-normal" style="text-align: left; font-size: 8pt">
				<xsl:value-of select="'100 (środki własne zarezerwowane na inwestycje)'"/>
			</td>
			<td class="bottom-right-normal" style="text-align: center; font-size: 9pt">X</td>
			<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; padding: 3px">
				<xsl:choose>
					<xsl:when test="Pozycja[child::Kod = 'J' and child::Symbol='100']/W">
						<xsl:value-of select="format-number(Pozycja[child::Kod = 'J' and child::Symbol='100']/W, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
		</tr>
		<tr>
			<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
				<xsl:value-of select="'I'"/>
			</td>
			<td colspan="3" class="bottom-right-normal" style="text-align: left; font-size: 8pt">
				<xsl:value-of select="'100 (odpisy amortyzacyjne)'"/>
			</td>
			<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; padding: 3px">
				<xsl:choose>
					<xsl:when test="Pozycja[child::Kod = 'I' and child::Symbol='100']/P">
						<xsl:value-of select="format-number(Pozycja[child::Kod = 'I' and child::Symbol='100']/P, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
			<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; padding: 3px">
				<xsl:choose>
					<xsl:when test="Pozycja[child::Kod = 'I' and child::Symbol='100']/W">
						<xsl:value-of select="format-number(Pozycja[child::Kod = 'I' and child::Symbol='100']/W, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
		</tr>
		<tr>
			<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
				<xsl:value-of select="'P'"/>
			</td>
			<td colspan="3" class="bottom-right-normal" style="text-align: left; font-size: 8pt">
				<xsl:value-of select="'100 (Inne zmniejszenia)'"/>
			</td>
			<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; padding: 3px">
				<xsl:choose>
					<xsl:when test="Pozycja[child::Kod = 'P' and child::Symbol='100']/P">
						<xsl:value-of select="format-number(Pozycja[child::Kod = 'P' and child::Symbol='100']/P, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
			<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; padding: 3px">
				<xsl:choose>
					<xsl:when test="Pozycja[child::Kod = 'P' and child::Symbol='100']/W">
						<xsl:value-of select="format-number(Pozycja[child::Kod = 'P' and child::Symbol='100']/W, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
		</tr>
		<tr>
			<td class="bottom-right-normal" style="text-align: center; font-size: 8pt; font-weight: bold">
				<xsl:value-of select="'N'"/>
			</td>
			<td colspan="3" class="bottom-right-normal" style="text-align: left; font-size: 9pt; font-weight: bold">
				<xsl:value-of select="'RAZEM '"/>
			</td>
			<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; font-weight: bold; padding: 3px">
				<xsl:choose>
					<xsl:when test="Pozycja[child::Kod = 'N']/P">
						<xsl:value-of select="format-number(Pozycja[child::Kod = 'N']/P, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
			<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; font-weight: bold; padding: 3px">
				<xsl:choose>
					<xsl:when test="Pozycja[child::Kod = 'N']/W">
						<xsl:value-of select="format-number(Pozycja[child::Kod = 'N']/W, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
		</tr>
		<tr>
			<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
				<xsl:value-of select="'P'"/>
			</td>
			<td colspan="3" class="bottom-right-normal" style="text-align: left; font-size: 8pt">
				<xsl:value-of select="'110 (Podatek dochodowy od osób prawnych)'"/>
			</td>
			<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; padding: 3px">
				<xsl:choose>
					<xsl:when test="Pozycja[child::Kod = 'P' and child::Symbol='110']/P">
						<xsl:value-of select="format-number(Pozycja[child::Kod = 'P' and child::Symbol='110']/P, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
			<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; padding: 3px">
				<xsl:choose>
					<xsl:when test="Pozycja[child::Kod = 'P' and child::Symbol='110']/W">
						<xsl:value-of select="format-number(Pozycja[child::Kod = 'P' and child::Symbol='110']/W, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
		</tr>
		<tr>
			<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
				<xsl:value-of select="'P'"/>
			</td>
			<td colspan="3" class="bottom-right-normal" style="text-align: left; font-size: 8pt">
				<xsl:value-of select="'120 (Wpłata do budżetu nadwyżki środków obrotowych)'"/>
			</td>
			<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; padding: 3px">
				<xsl:choose>
					<xsl:when test="Pozycja[child::Kod = 'P' and child::Symbol='120']/P">
						<xsl:value-of select="format-number(Pozycja[child::Kod = 'P' and child::Symbol='120']/P, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
			<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; padding: 3px">
				<xsl:choose>
					<xsl:when test="Pozycja[child::Kod = 'P' and child::Symbol='120']/W">
						<xsl:value-of select="format-number(Pozycja[child::Kod = 'P' and child::Symbol='120']/W, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
		</tr>
		<tr>
			<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
				<xsl:value-of select="'P'"/>
			</td>
			<td colspan="3" class="bottom-right-normal" style="text-align: left; font-size: 8pt">
				<xsl:value-of select="'130 (Stan śr. obrot. netto na koniec okresu sprawozdawczego)'"/>
			</td>
			<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; padding: 3px">
				<xsl:choose>
					<xsl:when test="Pozycja[child::Kod = 'P' and child::Symbol='130']/P">
						<xsl:value-of select="format-number(Pozycja[child::Kod = 'P' and child::Symbol='130']/P, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
			<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; padding: 3px">
				<xsl:choose>
					<xsl:when test="Pozycja[child::Kod = 'P' and child::Symbol='130']/W">
						<xsl:value-of select="format-number(Pozycja[child::Kod = 'P' and child::Symbol='130']/W, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
		</tr>
		<tr>
			<td class="bottom-right-normal" style="text-align: center; font-size: 8pt; font-weight: bold">
				<xsl:value-of select="'S'"/>
			</td>
			<td colspan="3" class="bottom-right-normal" style="text-align: left; font-size: 8pt; font-weight: bold">
				<xsl:value-of select="'190 Ogółem (N+P110+P120+P130)'"/>
			</td>
			<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; font-weight: bold; padding: 3px">
				<xsl:choose>
					<xsl:when test="Pozycja[child::Kod = 'S' and child::Symbol='190']/P">
						<xsl:value-of select="format-number(Pozycja[child::Kod = 'S' and child::Symbol='190']/P, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
			<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; font-weight: bold; padding: 3px">
				<xsl:choose>
					<xsl:when test="Pozycja[child::Kod = 'S' and child::Symbol='190']/W">
						<xsl:value-of select="format-number(Pozycja[child::Kod = 'S' and child::Symbol='190']/W, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
		</tr>
		<tr>
			<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
				<xsl:value-of select="'T'"/>
			</td>
			<td colspan="3" class="bottom-right-normal" style="text-align: left; font-size: 8pt">
				<xsl:value-of select="'140 (odpisy amortyzacyjne)'"/>
			</td>
			<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; padding: 3px">
				<xsl:choose>
					<xsl:when test="Pozycja[child::Kod = 'T' and child::Symbol='140']/P">
						<xsl:value-of select="format-number(Pozycja[child::Kod = 'T' and child::Symbol='140']/P, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
			<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; padding: 3px">
				<xsl:choose>
					<xsl:when test="Pozycja[child::Kod = 'T' and child::Symbol='140']/W">
						<xsl:value-of select="format-number(Pozycja[child::Kod = 'T' and child::Symbol='140']/W, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
		</tr>
	</xsl:template>
	<xsl:template name="Rb-30s_danePozycjeC">
		<xsl:param name="kod"/>
		<xsl:param name="symbol"/>
		<xsl:param name="wyszczeg"/>
		<xsl:param name="ostWiersz" select="false()"/>
		<xsl:param name="pogrWyszczeg" select="false()"/>
		<xsl:param name="annotation"/>
		<tr>
			<xsl:element name="td">
				<xsl:attribute name="style"><xsl:value-of select="'text-align: center; font-size: 8pt'"/></xsl:attribute>
				<xsl:attribute name="class"><xsl:choose><xsl:when test="$ostWiersz = false()"><xsl:value-of select="'bottom-right-normal'"/></xsl:when><xsl:otherwise><xsl:value-of select="'right-normal'"/></xsl:otherwise></xsl:choose></xsl:attribute>
				<xsl:value-of select="$kod"/>
			</xsl:element>
			<xsl:element name="td">
				<xsl:attribute name="style"><xsl:value-of select="'text-align: center; font-size: 8pt'"/></xsl:attribute>
				<xsl:attribute name="class"><xsl:choose><xsl:when test="$ostWiersz = false()"><xsl:value-of select="'bottom-right-normal'"/></xsl:when><xsl:otherwise><xsl:value-of select="'right-normal'"/></xsl:otherwise></xsl:choose></xsl:attribute>
				<xsl:value-of select="$symbol"/>
			</xsl:element>
			<xsl:element name="td">
				<xsl:attribute name="style"><xsl:choose><xsl:when test="$pogrWyszczeg = false()"><xsl:value-of select="'text-align: left; font-size: 8pt; padding: 3px'"/></xsl:when><xsl:otherwise><xsl:value-of select="'text-align: left; font-size: 8pt; font-weight: bold; padding: 3px'"/></xsl:otherwise></xsl:choose></xsl:attribute>
				<xsl:attribute name="class"><xsl:choose><xsl:when test="$ostWiersz = false()"><xsl:value-of select="'bottom-right-normal'"/></xsl:when><xsl:otherwise><xsl:value-of select="'right-normal'"/></xsl:otherwise></xsl:choose></xsl:attribute>
				<xsl:value-of select="$wyszczeg"/>
				<xsl:if test="$annotation">
					<sup>
						<xsl:value-of select="$annotation"/>)</sup>
				</xsl:if>
			</xsl:element>
			<xsl:element name="td">
				<xsl:attribute name="style"><xsl:value-of select="'text-align: right; font-size: 8pt; padding: 3px'"/></xsl:attribute>
				<xsl:attribute name="class"><xsl:choose><xsl:when test="$ostWiersz = false()"><xsl:value-of select="'bottom-right-normal'"/></xsl:when><xsl:otherwise><xsl:value-of select="'right-normal'"/></xsl:otherwise></xsl:choose></xsl:attribute>
				<xsl:choose>
					<xsl:when test="Stan/Pozycja[child::Kod = $kod and child::Symbol = $symbol]/P">
						<xsl:value-of select="format-number(Stan/Pozycja[child::Kod = $kod and child::Symbol = $symbol]/P, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:element>
			<xsl:element name="td">
				<xsl:attribute name="style"><xsl:value-of select="'text-align: right; font-size: 8pt; padding: 3px'"/></xsl:attribute>
				<xsl:if test="$ostWiersz = false()">
					<xsl:attribute name="class"><xsl:value-of select="'bottom-normal'"/></xsl:attribute>
				</xsl:if>
				<xsl:choose>
					<xsl:when test="Stan/Pozycja[child::Kod = $kod and child::Symbol = $symbol]/K">
						<xsl:value-of select="format-number(Stan/Pozycja[child::Kod = $kod and child::Symbol = $symbol]/K, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:element>
		</tr>
	</xsl:template>
	<xsl:template name="Rb-30s_danePozycjeE">
		<xsl:param name="kod"/>
		<xsl:param name="symbol"/>
		<xsl:param name="wyszczeg"/>
		<xsl:param name="ostWiersz" select="false()"/>
		<tr>
			<xsl:element name="td">
				<xsl:attribute name="style"><xsl:value-of select="'text-align: center; font-size: 8pt'"/></xsl:attribute>
				<xsl:attribute name="class"><xsl:choose><xsl:when test="$ostWiersz = false()"><xsl:value-of select="'bottom-right-normal'"/></xsl:when><xsl:otherwise><xsl:value-of select="'right-normal'"/></xsl:otherwise></xsl:choose></xsl:attribute>
				<xsl:value-of select="$kod"/>
			</xsl:element>
			<xsl:element name="td">
				<xsl:attribute name="style"><xsl:value-of select="'text-align: center; font-size: 8pt'"/></xsl:attribute>
				<xsl:attribute name="class"><xsl:choose><xsl:when test="$ostWiersz = false()"><xsl:value-of select="'bottom-right-normal'"/></xsl:when><xsl:otherwise><xsl:value-of select="'right-normal'"/></xsl:otherwise></xsl:choose></xsl:attribute>
				<xsl:value-of select="$symbol"/>
			</xsl:element>
			<xsl:element name="td">
				<xsl:attribute name="style"><xsl:value-of select="'text-align: left; font-size: 8pt; padding: 3px'"/></xsl:attribute>
				<xsl:attribute name="class"><xsl:choose><xsl:when test="$ostWiersz = false()"><xsl:value-of select="'bottom-right-normal'"/></xsl:when><xsl:otherwise><xsl:value-of select="'right-normal'"/></xsl:otherwise></xsl:choose></xsl:attribute>
				<xsl:value-of select="$wyszczeg"/>
			</xsl:element>
			<xsl:element name="td">
				<xsl:attribute name="style"><xsl:value-of select="'text-align: right; font-size: 8pt; padding: 3px'"/></xsl:attribute>
				<xsl:attribute name="class"><xsl:choose><xsl:when test="$ostWiersz = false()"><xsl:value-of select="'bottom-right-normal'"/></xsl:when><xsl:otherwise><xsl:value-of select="'right-normal'"/></xsl:otherwise></xsl:choose></xsl:attribute>
				<xsl:choose>
					<xsl:when test="RozliczenieKasowe/Pozycja[child::Kod = $kod and child::Symbol = $symbol]/P">
						<xsl:value-of select="format-number(RozliczenieKasowe/Pozycja[child::Kod = $kod and child::Symbol = $symbol]/P, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:element>
			<xsl:element name="td">
				<xsl:attribute name="style"><xsl:value-of select="'text-align: right; font-size: 8pt; padding: 3px'"/></xsl:attribute>
				<xsl:if test="$ostWiersz = false()">
					<xsl:attribute name="class"><xsl:value-of select="'bottom-normal'"/></xsl:attribute>
				</xsl:if>
				<xsl:choose>
					<xsl:when test="RozliczenieKasowe/Pozycja[child::Kod = $kod and child::Symbol = $symbol]/O">
						<xsl:value-of select="format-number(RozliczenieKasowe/Pozycja[child::Kod = $kod and child::Symbol = $symbol]/O, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:element>
		</tr>
	</xsl:template>
	<!-- Rb-31 -->
	<xsl:template match="Rb-31">
		<xsl:param name="jedIndex"/>
		<xsl:param name="sprIndex"/>
		<xsl:element name="div">
			<xsl:attribute name="Id"><xsl:value-of select="concat('Jed', $jedIndex, 'Wer', $sprIndex)"/></xsl:attribute>
			<xsl:attribute name="style"><xsl:value-of select="'display: block; margin-bottom: 40px'"/></xsl:attribute>
			<div style="font-size: 12pt; font-weight: bold; margin-left: 5px; margin-bottom: 10px">
        Sprawozdanie Rb-31:
        <xsl:choose>
					<xsl:when test="Naglowek/Wersja = 0">
						<xsl:value-of select="'wersja pierwotna'"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="concat('korekta nr ', Naglowek/Wersja)"/>
					</xsl:otherwise>
				</xsl:choose>
				<xsl:call-template name="SprNaglowekInfo"/>
			</div>
			<table cellpadding="0" cellspacing="0" class="all-bold" style="margin-bottom: 30px">
				<tbody>
					<tr style="height: 18px">
						<td colspan="10" class="bottom-bold" style="font-size: 10pt;">MINISTERSTWO FINANSÓW, ul. Świętokrzyska 12, 00-916 Warszawa</td>
					</tr>
					<tr style="height: 127px">
						<td colspan="4" class="bottom-bold" style="width:300px">
							<table cellpadding="0" cellspacing="0" style="border-collapse: collapse; height" width="100%">
								<tbody>
									<tr style="height: 80px">
										<td style="text-align: left; font-size: 9pt; margin:1px 1px 0 0; padding:0" valign="top">
                      Nazwa i adres jednostki sprawozdawczej
                    </td>
									</tr>
									<tr>
										<td class="bottom-normal" style="text-align: center; font-size: 9pt" valign="bottom">
											<!-- popr. nr I.8 -->
											<div style="display: block;margin: 0 20px">
												<xsl:choose>
													<xsl:when test="Jednostka/Nazwa">
														<xsl:value-of select="Jednostka/Nazwa"/>
													</xsl:when>
													<xsl:otherwise>
														<xsl:value-of select="../../Nazwa"/>
													</xsl:otherwise>
												</xsl:choose>
											</div>
										</td>
									</tr>
									<tr style="height: 23px">
										<td style="text-align: left; font-size: 9pt; margin:1px 1px 0 0; padding:0;" valign="top">
                      Numer identyfikacyjny REGON
                    </td>
									</tr>
									<tr>
										<td style="text-align: center; font-size: 9pt; font-weight: bold; margin:1px 1px 0 0; padding:0" valign="baseline">
											<xsl:choose>
												<xsl:when test="Jednostka/Regon">
													<xsl:value-of select="Jednostka/Regon"/>
												</xsl:when>
												<xsl:otherwise>
													<xsl:value-of select="../../Regon"/>
												</xsl:otherwise>
											</xsl:choose>
										</td>
									</tr>
								</tbody>
							</table>
						</td>
						<td colspan="3" class="notop-bold" valign="top" style="width: 400px">
							<div style="font-weight: bold; text-align: center; font-size: 11pt; margin-bottom: 5px">Rb-31 półroczne / roczne sprawozdanie z wykonania planów finansowych gospodarstw pomocniczych</div>
							<div style="vertical-align: bottom; text-align: center; font-size: 9pt; margin-top: 50px">
								<xsl:call-template name="NaglowekSprOkres"/>
							</div>
						</td>
						<td colspan="3" class="bottom-bold" style="text-align: left; font-size: 9pt; margin:1px 1px 0 0; padding:0; width: 300px" valign="top">
							<div style="margin-bottom:5px">Adresat:</div>
							<!-- popr. nr I.9 -->
							<div style="text-align:center; margin-bottom: 15px;">
								<!-- <xsl:value-of select="'Regionalna Izba Obrachunkowa w Katowicach'"/> -->
							</div>
							<div style="text-align:center;">
								<!-- <xsl:value-of select="'wersja robocza'"/> -->
							</div>
						</td>
					</tr>
					<tr style="height: 54px">
						<td rowspan="2" colspan="7" class="bottom-right-bold" style="font-size: 9pt">
							<!-- popr. nr I.10 -->
							<div style="margin-bottom: 1px">
								<xsl:value-of select="'Nazwa województwa '"/>
								<sup>1) 2)</sup>
								<!-- <xsl:if test="../../Typ = 'W'">
									<span style="margin-left: 10px">
										<b>
											<xsl:value-of select="../../Nazwa"/>
										</b>
									</span>
								</xsl:if> -->
							</div>
							<div style="margin-bottom: 1px">
								<xsl:value-of select="'Nazwa powiatu / związku '"/>
								<sup>1) 2)</sup>
								<!-- <xsl:if test="../../Typ = 'P'">
									<span style="margin-left: 10px">
										<b>
											<xsl:value-of select="../../Nazwa"/>
										</b>
									</span>
								</xsl:if> -->
							</div>
							<div>
								<xsl:value-of select="'Nazwa gminy / związku '"/>
								<sup>1) 2)</sup>
								<!-- <xsl:if test="../../Typ = 'G'">
									<span style="margin-left: 10px">
										<b>
											<xsl:value-of select="../../Nazwa"/>
										</b>
									</span>
								</xsl:if> -->
							</div>
						</td>
						<td colspan="3" class="bottom-bold" style="font-size:9pt; text-align:center">Przed wypełnieniem przeczytać instrukcję</td>
					</tr>
					<tr>
						<td colspan="3" class="bottom-bold" style="font-size:9pt; text-align:center">Wysyłać bez pisma przewodniego</td>
					</tr>
					<tr>
						<td colspan="7" class="right-bottom-mixed" style="font-size:10pt; text-align:center">Symbole</td>
						<td colspan="3" class="bottom-normal" style="font-size:10pt; text-align:center">Klasyfikacja budżetowa</td>
					</tr>
					<tr>
						<td class="bottom-right-normal" style="font-size:9pt; text-align:center">woj.</td>
						<td class="bottom-right-normal" style="font-size:9pt; text-align:center">powiat</td>
						<td class="bottom-right-normal" style="font-size:9pt; text-align:center">gmina</td>
						<td class="bottom-right-normal" style="font-size:9pt; text-align:center">typ gm.</td>
						<td class="bottom-right-normal" style="font-size:9pt; text-align:center">związek jst</td>
						<td class="bottom-right-normal" style="font-size:9pt; text-align:center">typ zw.</td>
						<td class="right-bottom-mixed" style="font-size:9pt; text-align:center">gosp. pom. </td>
						<td class="bottom-right-normal" style="font-size:9pt; text-align:center">
              część <sup>3)</sup>
						</td>
						<td class="bottom-right-normal" style="font-size:9pt; text-align:center">dział</td>
						<td class="bottom-normal" style="font-size:9pt; text-align:center">rozdział</td>
					</tr>
					<tr>
						<td class="bottom-right-normal" style="text-align:center; font-size: 8pt">
							<xsl:value-of select="1"/>
						</td>
						<td class="bottom-right-normal" style="text-align:center; font-size: 8pt">
							<xsl:value-of select="2"/>
						</td>
						<td class="bottom-right-normal" style="text-align:center; font-size: 8pt">
							<xsl:value-of select="3"/>
						</td>
						<td class="bottom-right-normal" style="text-align:center; font-size: 8pt">
							<xsl:value-of select="4"/>
						</td>
						<td class="bottom-right-normal" style="text-align:center; font-size: 8pt">
							<xsl:value-of select="5"/>
						</td>
						<td class="bottom-right-normal" style="text-align:center; font-size: 8pt">
							<xsl:value-of select="6"/>
						</td>
						<td class="right-bottom-mixed" style="text-align:center; font-size: 8pt">
							<xsl:value-of select="7"/>
						</td>
						<td class="bottom-right-normal" style="text-align:center; font-size: 8pt">
							<xsl:value-of select="8"/>
						</td>
						<td class="bottom-right-normal" style="text-align:center; font-size: 8pt">
							<xsl:value-of select="9"/>
						</td>
						<td class="bottom-normal" style="text-align:center; font-size: 8pt">
							<xsl:value-of select="10"/>
						</td>
					</tr>
					<tr>
						<td class="right-normal" style="font-size:10pt; text-align:center">
							<xsl:choose>
								<xsl:when test="Jednostka/WK">
									<xsl:value-of select="Jednostka/WK"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="../../WK"/>
								</xsl:otherwise>
							</xsl:choose>
						</td>
						<td class="right-normal" style="font-size:10pt; text-align:center">
							<xsl:choose>
								<xsl:when test="Jednostka/PK">
									<xsl:value-of select="Jednostka/PK"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="../../PK"/>
								</xsl:otherwise>
							</xsl:choose>
						</td>
						<td class="right-normal" style="font-size:10pt; text-align:center">
							<xsl:choose>
								<xsl:when test="Jednostka/GK">
									<xsl:value-of select="Jednostka/GK"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="../../GK"/>
								</xsl:otherwise>
							</xsl:choose>
						</td>
						<td class="right-normal" style="font-size:10pt; text-align:center">
							<xsl:choose>
								<xsl:when test="Jednostka/GT">
									<xsl:value-of select="Jednostka/GT"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="../../GT"/>
								</xsl:otherwise>
							</xsl:choose>
						</td>
						<td style="font-size:10pt; text-align:center; border-right: 1px solid black">
							<xsl:choose>
								<xsl:when test="Jednostka/KodMSWiA">
									<xsl:value-of select="Jednostka/KodMSWiA"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:choose>
										<xsl:when test="../../KodMSWiA">
											<xsl:value-of select="../../KodMSWiA"/>
										</xsl:when>
										<xsl:otherwise>
											<xsl:value-of select="$nbsp"/>
										</xsl:otherwise>
									</xsl:choose>
								</xsl:otherwise>
							</xsl:choose>
						</td>
						<td style="font-size:10pt; text-align:center; border-right: 1px solid black">
							<xsl:value-of select="$nbsp"/>
						</td>
						<td style="font-size:10pt; text-align:center; border-right: 4px solid black">
							<xsl:choose>
								<xsl:when test="Naglowek/SymbolPozabudzetowy">
									<xsl:value-of select="Naglowek/SymbolPozabudzetowy"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="$nbsp"/>
								</xsl:otherwise>
							</xsl:choose>
						</td>
						<td style="font-size:10pt; text-align:center; border-right: 1px solid black">
							<xsl:value-of select="$nbsp"/>
						</td>
						<td style="font-size:10pt; text-align:center; border-right: 1px solid black">
							<xsl:value-of select="Naglowek/Dzial"/>
						</td>
						<td style="font-size:10pt; text-align:center">
							<xsl:value-of select="Naglowek/Rozdzial"/>
						</td>
					</tr>
				</tbody>
			</table>
			<div style="display: block; margin-bottom: 40px">
				<table cellpadding="0" cellspacing="0">
					<tbody>
						<tr>
							<td style="width: 450px">
								<div style="font-size: 10pt; font-weight: bold; margin-left: 5px">A.</div>
							</td>
							<td style="width: 120px">
								<!-- <div style="font-size: 9pt">strona 1</div> -->
							</td>
							<td style="width: 350px">
								<!-- <div style="font-size: 9pt">sprawozdania Rb-31, Dział <xsl:value-of select="Naglowek/Dzial"/>, Rozdział <xsl:value-of select="Naglowek/Rozdzial"/>, <xsl:value-of select="../../Nazwa"/>
								</div> -->
							</td>
						</tr>
					</tbody>
				</table>
				<table cellpadding="0" cellspacing="0" class="all-bold" style="margin-bottom: 10px">
					<tbody>
						<tr>
							<td rowspan="2" class="bottom-right-mixed" style="font-size: 10pt; text-align: center; width: 80px">Kod pozycji</td>
							<td rowspan="2" class="bottom-right-mixed" style="font-size: 10pt; text-align: center; width: 250px">Paragraf</td>
							<td colspan="2" class="bottom-normal" style="font-size: 10pt; text-align: center">Przychody</td>
						</tr>
						<tr>
							<td class="bottom-right-mixed" style="font-size: 10pt; text-align: center; width: 350px">plan</td>
							<td class="bottom-bold" style="font-size: 10pt; text-align: center; width: 350px">wykonanie</td>
						</tr>
						<tr>
							<td class="bottom-right-mixed" style="text-align:center; font-size: 8pt">
								<xsl:value-of select="11"/>
							</td>
							<td class="bottom-right-mixed" style="text-align:center; font-size: 8pt">
								<xsl:value-of select="12"/>
							</td>
							<td class="bottom-right-mixed" style="text-align:center; font-size: 8pt">
								<xsl:value-of select="13"/>
							</td>
							<td class="bottom-bold" style="text-align:center; font-size: 8pt">
								<xsl:value-of select="14"/>
							</td>
						</tr>
						<xsl:for-each select="PrzychodyPozycje/Pozycja">
							<tr>
								<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
									<xsl:value-of select="'G'"/>
								</td>
								<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
									<xsl:value-of select="concat(Paragraf, P4)"/>
								</td>
								<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; padding: 3px">
									<xsl:choose>
										<xsl:when test="P">
											<xsl:value-of select="format-number(P, '#&#160;##0,00')"/>
										</xsl:when>
										<xsl:otherwise>
											<xsl:value-of select="'0,00'"/>
										</xsl:otherwise>
									</xsl:choose>
								</td>
								<td class="bottom-normal" style="text-align: right; font-size: 8pt; padding: 3px">
									<xsl:choose>
										<xsl:when test="W">
											<xsl:value-of select="format-number(W, '#&#160;##0,00')"/>
										</xsl:when>
										<xsl:otherwise>
											<xsl:value-of select="'0,00'"/>
										</xsl:otherwise>
									</xsl:choose>
								</td>
							</tr>
						</xsl:for-each>
						<xsl:apply-templates select="PrzychodyPodsumowanie">
							<xsl:with-param name="SymPoz" select="Naglowek/SymbolPozabudzetowy"/>
							<xsl:with-param name="Dzial" select="Naglowek/Dzial"/>
							<xsl:with-param name="Rozdzial" select="Naglowek/Rozdzial"/>
						</xsl:apply-templates>
					</tbody>
				</table>
				<div style="margin-bottom: 20px">
					<div style="display: block; font-size: 7pt;margin-bottom:0">
						<sup>1)</sup> niepotrzebne skreślić
          </div>
					<div style="display: block; font-size: 7pt;margin-bottom:0">
						<sup>2)</sup> dotyczy jednostek samorządu terytorialnego i ich związków
          </div>
					<div style="display: block; font-size: 7pt">
						<sup>3)</sup> dotyczy gospodarstw pomocniczych państwowych jednostek budżetowych
          </div>
				</div>
				<table cellpadding="0" cellspacing="0">
					<tbody>
						<tr>
							<td style="width: 450px">
								<div style="font-size: 10pt; font-weight: bold; margin-left: 5px">B.</div>
							</td>
							<td style="width: 120px">
								<!-- <div style="font-size: 9pt">strona 2</div> -->
							</td>
							<td style="width: 350px">
								<!-- <div style="font-size: 9pt">sprawozdania Rb-31, Dział <xsl:value-of select="Naglowek/Dzial"/>, Rozdział <xsl:value-of select="Naglowek/Rozdzial"/>, <xsl:value-of select="../../Nazwa"/>
								</div> -->
							</td>
						</tr>
					</tbody>
				</table>
				<table cellpadding="0" cellspacing="0" class="all-bold" style="margin-bottom: 30px">
					<tbody>
						<tr>
							<td rowspan="2" class="bottom-right-mixed" style="font-size: 10pt; text-align: center; width: 80px">Kod pozycji</td>
							<td rowspan="2" class="bottom-right-mixed" style="font-size: 10pt; text-align: center; width: 250px">Paragraf</td>
							<td colspan="2" class="bottom-normal" style="font-size: 10pt; text-align: center">Koszty i inne obciążenia</td>
						</tr>
						<tr>
							<td class="bottom-right-mixed" style="font-size: 10pt; text-align: center; width: 350px">plan</td>
							<td class="bottom-bold" style="font-size: 10pt; text-align: center; width: 350px">wykonanie</td>
						</tr>
						<tr>
							<td class="bottom-right-mixed" style="text-align:center; font-size: 8pt">
								<xsl:value-of select="11"/>
							</td>
							<td class="bottom-right-mixed" style="text-align:center; font-size: 8pt">
								<xsl:value-of select="12"/>
							</td>
							<td class="bottom-right-mixed" style="text-align:center; font-size: 8pt">
								<xsl:value-of select="13"/>
							</td>
							<td class="bottom-bold" style="text-align:center; font-size: 8pt">
								<xsl:value-of select="14"/>
							</td>
						</tr>
						<xsl:for-each select="KosztyPozycje/Pozycja">
							<tr>
								<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
									<xsl:value-of select="'M'"/>
								</td>
								<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
									<xsl:value-of select="concat(Paragraf, P4)"/>
								</td>
								<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; padding: 3px">
									<xsl:choose>
										<xsl:when test="P">
											<xsl:value-of select="format-number(P, '#&#160;##0,00')"/>
										</xsl:when>
										<xsl:otherwise>
											<xsl:value-of select="'0,00'"/>
										</xsl:otherwise>
									</xsl:choose>
								</td>
								<td class="bottom-normal" style="text-align: right; font-size: 8pt; padding: 3px">
									<xsl:choose>
										<xsl:when test="W">
											<xsl:value-of select="format-number(W, '#&#160;##0,00')"/>
										</xsl:when>
										<xsl:otherwise>
											<xsl:value-of select="'0,00'"/>
										</xsl:otherwise>
									</xsl:choose>
								</td>
							</tr>
						</xsl:for-each>
						<xsl:apply-templates select="KosztyPodsumowanie">
							<xsl:with-param name="SymPoz" select="Naglowek/SymbolPozabudzetowy"/>
							<xsl:with-param name="Dzial" select="Naglowek/Dzial"/>
							<xsl:with-param name="Rozdzial" select="Naglowek/Rozdzial"/>
						</xsl:apply-templates>
					</tbody>
				</table>
				<table cellpadding="0" cellspacing="0">
					<tbody>
						<tr>
							<td style="width: 450px">
								<div style="font-size: 10pt; font-weight: bold; margin-left: 5px">C.</div>
							</td>
							<td style="width: 120px">
								<!-- <div style="font-size: 9pt">strona 3</div> -->
							</td>
							<td style="width: 350px">
								<!-- <div style="font-size: 9pt">sprawozdania Rb-31, Dział <xsl:value-of select="Naglowek/Dzial"/>, Rozdział <xsl:value-of select="Naglowek/Rozdzial"/>, <xsl:value-of select="../../Nazwa"/>
								</div> -->
							</td>
						</tr>
					</tbody>
				</table>
				<table cellpadding="0" cellspacing="0" class="all-bold" style="margin-bottom: 10px">
					<tbody>
						<tr>
							<td rowspan="2" class="bottom-right-mixed" style="font-size: 10pt; text-align: center; width: 80px">Kod pozycji</td>
							<td rowspan="2" class="bottom-right-mixed" style="font-size: 10pt; text-align: center; width: 90px">Symbol</td>
							<td rowspan="2" class="bottom-right-mixed" style="font-size: 10pt; text-align: center; width: 360px; min-width: 320px">Wyszczególnienie</td>
							<td colspan="2" class="bottom-normal" style="font-size: 10pt; text-align: center">Rozliczenie wyniku</td>
						</tr>
						<tr>
							<td class="bottom-right-mixed" style="font-size: 10pt; text-align: center; width: 260px; min-width: 220px">plan</td>
							<td class="bottom-bold" style="font-size: 10pt; text-align: center; width: 260px; min-width: 220px">wykonanie</td>
						</tr>
						<tr>
							<td class="bottom-right-mixed" style="text-align:center; font-size: 8pt">
								<xsl:value-of select="11"/>
							</td>
							<td class="bottom-right-mixed" style="text-align:center; font-size: 8pt">
								<xsl:value-of select="12"/>
							</td>
							<td class="bottom-right-mixed" style="text-align: center; font-size: 8pt">
								<xsl:value-of select="$nbsp"/>
							</td>
							<td class="bottom-right-mixed" style="text-align:center; font-size: 8pt">
								<xsl:value-of select="13"/>
							</td>
							<td class="bottom-bold" style="text-align:center; font-size: 8pt">
								<xsl:value-of select="14"/>
							</td>
						</tr>
						<xsl:call-template name="Rb-31_danePozycjeC">
							<xsl:with-param name="kod" select="'S'"/>
							<xsl:with-param name="symbol" select="'100'"/>
							<xsl:with-param name="wyszczeg" select="'Wynik finansowy brutto (H-N)'"/>
						</xsl:call-template>
						<tr>
							<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
								<xsl:value-of select="'Q'"/>
							</td>
							<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
								<xsl:value-of select="'110'"/>
							</td>
							<td class="bottom-right-normal" style="text-align: left; font-size: 8pt; padding: 3px">
								<div style="margin: 0">Podatek dochodowy od osób prawnych (ustalony)</div>
								<div style="margin: 0">w tym:</div>
							</td>
							<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; padding: 3px">
								<xsl:choose>
									<xsl:when test="RozliczenieWyniku/Pozycja[child::Kod = 'Q' and child::Symbol = '110']/P">
										<xsl:value-of select="format-number(RozliczenieWyniku/Pozycja[child::Kod = 'Q' and child::Symbol = '110']/P, '#&#160;##0,00')"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="'0,00'"/>
									</xsl:otherwise>
								</xsl:choose>
							</td>
							<td class="bottom-normal" style="text-align: right; font-size: 8pt; padding: 3px">
								<xsl:choose>
									<xsl:when test="RozliczenieWyniku/Pozycja[child::Kod = 'Q' and child::Symbol = '110']/W">
										<xsl:value-of select="format-number(RozliczenieWyniku/Pozycja[child::Kod = 'Q' and child::Symbol = '110']/W, '#&#160;##0,00')"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="'0,00'"/>
									</xsl:otherwise>
								</xsl:choose>
							</td>
						</tr>
						<tr>
							<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
								<xsl:value-of select="'Q'"/>
							</td>
							<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
								<xsl:value-of select="'111'"/>
							</td>
							<td class="bottom-right-normal" style="text-align: left; font-size: 8pt; padding: 3px">
								<div style="margin: 0 0 0 15px">kwota zwolnienia od podatku dochodowego 1)</div>
							</td>
							<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; padding: 3px">
								<xsl:choose>
									<xsl:when test="RozliczenieWyniku/Pozycja[child::Kod = 'Q' and child::Symbol = '111']/P">
										<xsl:value-of select="format-number(RozliczenieWyniku/Pozycja[child::Kod = 'Q' and child::Symbol = '111']/P, '#&#160;##0,00')"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="'0,00'"/>
									</xsl:otherwise>
								</xsl:choose>
							</td>
							<td class="bottom-normal" style="text-align: right; font-size: 8pt; padding: 3px">
								<xsl:choose>
									<xsl:when test="RozliczenieWyniku/Pozycja[child::Kod = 'Q' and child::Symbol = '111']/W">
										<xsl:value-of select="format-number(RozliczenieWyniku/Pozycja[child::Kod = 'Q' and child::Symbol = '111']/W, '#&#160;##0,00')"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="'0,00'"/>
									</xsl:otherwise>
								</xsl:choose>
							</td>
						</tr>
						<xsl:call-template name="Rb-31_danePozycjeC">
							<xsl:with-param name="kod" select="'Q'"/>
							<xsl:with-param name="symbol" select="'120'"/>
							<xsl:with-param name="wyszczeg" select="'Inne obciążenia wyniku finansowego'"/>
						</xsl:call-template>
						<tr>
							<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
								<xsl:value-of select="'R'"/>
							</td>
							<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
								<xsl:value-of select="'200'"/>
							</td>
							<td class="bottom-right-normal" style="text-align: left; font-size: 8pt; padding: 3px">
								<div style="margin: 0">Zysk do podziału (S100-Q110-Q120)</div>
								<div style="margin: 0">z tego:</div>
							</td>
							<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; padding: 3px">
								<xsl:choose>
									<xsl:when test="RozliczenieWyniku/Pozycja[child::Kod = 'R' and child::Symbol = '200']/P">
										<xsl:value-of select="format-number(RozliczenieWyniku/Pozycja[child::Kod = 'R' and child::Symbol = '200']/P, '#&#160;##0,00')"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="'0,00'"/>
									</xsl:otherwise>
								</xsl:choose>
							</td>
							<td class="bottom-normal" style="text-align: right; font-size: 8pt; padding: 3px">
								<xsl:choose>
									<xsl:when test="RozliczenieWyniku/Pozycja[child::Kod = 'R' and child::Symbol = '200']/W">
										<xsl:value-of select="format-number(RozliczenieWyniku/Pozycja[child::Kod = 'R' and child::Symbol = '200']/W, '#&#160;##0,00')"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="'0,00'"/>
									</xsl:otherwise>
								</xsl:choose>
							</td>
						</tr>
						<tr>
							<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
								<xsl:value-of select="'R'"/>
							</td>
							<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
								<xsl:value-of select="'210'"/>
							</td>
							<td class="bottom-right-normal" style="text-align: left; font-size: 8pt; padding: 3px">
								<div style="margin: 0 0 0 15px">wpłata do budżetu</div>
							</td>
							<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; padding: 3px">
								<xsl:choose>
									<xsl:when test="RozliczenieWyniku/Pozycja[child::Kod = 'R' and child::Symbol = '210']/P">
										<xsl:value-of select="format-number(RozliczenieWyniku/Pozycja[child::Kod = 'R' and child::Symbol = '210']/P, '#&#160;##0,00')"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="'0,00'"/>
									</xsl:otherwise>
								</xsl:choose>
							</td>
							<td class="bottom-normal" style="text-align: right; font-size: 8pt; padding: 3px">
								<xsl:choose>
									<xsl:when test="RozliczenieWyniku/Pozycja[child::Kod = 'R' and child::Symbol = '210']/W">
										<xsl:value-of select="format-number(RozliczenieWyniku/Pozycja[child::Kod = 'R' and child::Symbol = '210']/W, '#&#160;##0,00')"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="'0,00'"/>
									</xsl:otherwise>
								</xsl:choose>
							</td>
						</tr>
						<tr>
							<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
								<xsl:value-of select="'R'"/>
							</td>
							<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
								<xsl:value-of select="'100'"/>
							</td>
							<td class="bottom-right-normal" style="text-align: left; font-size: 8pt; padding: 3px">
								<div style="margin: 0 0 0 15px">zysk pozostający w gospodarstwie pomocniczym</div>
							</td>
							<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; padding: 3px">
								<xsl:choose>
									<xsl:when test="RozliczenieWyniku/Pozycja[child::Kod = 'R' and child::Symbol = '100']/P">
										<xsl:value-of select="format-number(RozliczenieWyniku/Pozycja[child::Kod = 'R' and child::Symbol = '100']/P, '#&#160;##0,00')"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="'0,00'"/>
									</xsl:otherwise>
								</xsl:choose>
							</td>
							<td class="bottom-normal" style="text-align: right; font-size: 8pt; padding: 3px">
								<xsl:choose>
									<xsl:when test="RozliczenieWyniku/Pozycja[child::Kod = 'R' and child::Symbol = '100']/W">
										<xsl:value-of select="format-number(RozliczenieWyniku/Pozycja[child::Kod = 'R' and child::Symbol = '100']/W, '#&#160;##0,00')"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="'0,00'"/>
									</xsl:otherwise>
								</xsl:choose>
							</td>
						</tr>
						<xsl:call-template name="Rb-31_danePozycjeC">
							<xsl:with-param name="kod" select="'R'"/>
							<xsl:with-param name="symbol" select="'110'"/>
							<xsl:with-param name="wyszczeg" select="'Strata - ze znakiem minus'"/>
							<xsl:with-param name="ostWiersz" select="true()"/>
						</xsl:call-template>
					</tbody>
				</table>
				<div style="margin-bottom: 20px">
					<div style="font-size: 7pt">
						<sup>1)</sup> dotyczy zwolnienia, o którym mowa w art.6 ust.2 ustawy o podatku docodowym od osób prawnych
          </div>
				</div>
				<table cellpadding="0" cellspacing="0">
					<tbody>
						<tr>
							<td style="width: 450px">
								<div style="font-size: 10pt; font-weight: bold; margin-left: 5px">D.</div>
							</td>
							<td style="width: 120px">
								<!-- <div style="font-size: 9pt">strona 4</div> -->
							</td>
							<td style="width: 350px">
								<!-- <div style="font-size: 9pt">sprawozdania Rb-31, Dział <xsl:value-of select="Naglowek/Dzial"/>, Rozdział <xsl:value-of select="Naglowek/Rozdzial"/>, <xsl:value-of select="../../Nazwa"/>
								</div> -->
							</td>
						</tr>
					</tbody>
				</table>
				<table cellpadding="0" cellspacing="0" class="all-bold" style="margin-bottom: 20px">
					<tbody>
						<tr>
							<td rowspan="2" class="bottom-right-mixed" style="font-size: 10pt; text-align: center; width: 80px">Kod pozycji</td>
							<td rowspan="2" class="bottom-right-mixed" style="font-size: 10pt; text-align: center; width: 90px">Symbol</td>
							<td rowspan="2" class="bottom-right-mixed" style="font-size: 10pt; text-align: center; width: 360px; min-width: 320px">Wyszczególnienie</td>
							<td colspan="2" class="bottom-normal" style="font-size: 10pt; text-align: center">Podział zysku pozostającego w gospodarstwie lub pokrycie straty</td>
						</tr>
						<tr>
							<td class="bottom-right-mixed" style="font-size: 10pt; text-align: center; width: 260px; min-width: 220px">plan</td>
							<td class="bottom-bold" style="font-size: 10pt; text-align: center; width: 260px; min-width: 220px">wykonanie</td>
						</tr>
						<tr>
							<td class="bottom-right-mixed" style="text-align:center; font-size: 8pt">
								<xsl:value-of select="11"/>
							</td>
							<td class="bottom-right-mixed" style="text-align:center; font-size: 8pt">
								<xsl:value-of select="12"/>
							</td>
							<td class="bottom-right-mixed" style="text-align: center; font-size: 8pt">
								<xsl:value-of select="$nbsp"/>
							</td>
							<td class="bottom-right-mixed" style="text-align:center; font-size: 8pt">
								<xsl:value-of select="13"/>
							</td>
							<td class="bottom-bold" style="text-align:center; font-size: 8pt">
								<xsl:value-of select="14"/>
							</td>
						</tr>
						<xsl:call-template name="Rb-31_danePozycjeD">
							<xsl:with-param name="kod" select="'T'"/>
							<xsl:with-param name="symbol" select="'100'"/>
							<xsl:with-param name="wyszczeg" select="'- Zysk'"/>
						</xsl:call-template>
						<xsl:call-template name="Rb-31_danePozycjeD">
							<xsl:with-param name="kod" select="'T'"/>
							<xsl:with-param name="symbol" select="'200'"/>
							<xsl:with-param name="wyszczeg" select="'- Strata (ze znakiem minus)'"/>
						</xsl:call-template>
						<xsl:call-template name="Rb-31_danePozycjeD">
							<xsl:with-param name="kod" select="'T'"/>
							<xsl:with-param name="symbol" select="'120'"/>
							<xsl:with-param name="wyszczeg" select="'Zwiększenie środków obrotowych'"/>
						</xsl:call-template>
						<xsl:call-template name="Rb-31_danePozycjeD">
							<xsl:with-param name="kod" select="'T'"/>
							<xsl:with-param name="symbol" select="'130'"/>
							<xsl:with-param name="wyszczeg" select="'Dofinansowanie inwestycji'"/>
						</xsl:call-template>
						<xsl:call-template name="Rb-31_danePozycjeD">
							<xsl:with-param name="kod" select="'T'"/>
							<xsl:with-param name="symbol" select="'140'"/>
							<xsl:with-param name="wyszczeg" select="'Inne cele'"/>
						</xsl:call-template>
						<xsl:call-template name="Rb-31_danePozycjeD">
							<xsl:with-param name="kod" select="'T'"/>
							<xsl:with-param name="symbol" select="'210'"/>
							<xsl:with-param name="wyszczeg" select="'Zmniejszenie środków obrotowych na pokrycie ujemnego wyniku finansowego'"/>
						</xsl:call-template>
					</tbody>
				</table>
				<table cellpadding="0" cellspacing="0">
					<tbody>
						<tr>
							<td style="width: 450px">
								<div style="font-size: 10pt; font-weight: bold; margin-left: 5px">E.</div>
							</td>
						</tr>
					</tbody>
				</table>
				<table cellpadding="0" cellspacing="0" class="all-bold" style="margin-bottom: 10px">
					<tbody>
						<tr>
							<td class="bottom-right-mixed" style="font-size: 10pt; text-align: center; width: 80px">Kod pozycji</td>
							<td class="bottom-right-mixed" style="font-size: 10pt; text-align: center; width: 90px">Symbol</td>
							<td class="bottom-right-mixed" style="font-size: 10pt; text-align: center; width: 360px; min-width: 320px">Wyszczególnienie</td>
							<td class="bottom-right-mixed" style="font-size: 10pt; text-align: center; width: 260px; min-width: 220px">Stan na początek okresu sprawozdawczego</td>
							<td class="bottom-bold" style="font-size: 10pt; text-align: center; width: 260px; min-width: 220px">Stan na koniec okresu sprawozdawczego</td>
						</tr>
						<tr>
							<td class="bottom-right-mixed" style="text-align:center; font-size: 8pt">
								<xsl:value-of select="11"/>
							</td>
							<td class="bottom-right-mixed" style="text-align:center; font-size: 8pt">
								<xsl:value-of select="12"/>
							</td>
							<td class="bottom-right-mixed" style="text-align: center; font-size: 8pt">
								<xsl:value-of select="$nbsp"/>
							</td>
							<td class="bottom-right-mixed" style="text-align:center; font-size: 8pt">
								<xsl:value-of select="13"/>
							</td>
							<td class="bottom-bold" style="text-align:center; font-size: 8pt">
								<xsl:value-of select="14"/>
							</td>
						</tr>
						<xsl:call-template name="Rb-31_danePozycjeE">
							<xsl:with-param name="kod" select="'W'"/>
							<xsl:with-param name="symbol" select="'010'"/>
							<xsl:with-param name="wyszczeg" select="'Środki pieniężne (w tym środki w kasie)'"/>
						</xsl:call-template>
						<xsl:call-template name="Rb-31_danePozycjeE">
							<xsl:with-param name="kod" select="'W'"/>
							<xsl:with-param name="symbol" select="'020'"/>
							<xsl:with-param name="wyszczeg" select="'Należności netto 1)'"/>
						</xsl:call-template>
						<xsl:call-template name="Rb-31_danePozycjeE">
							<xsl:with-param name="kod" select="'W'"/>
							<xsl:with-param name="symbol" select="'021'"/>
							<xsl:with-param name="wyszczeg" select="'Kwota odpisu aktualizującego należności'"/>
						</xsl:call-template>
						<xsl:call-template name="Rb-31_danePozycjeE">
							<xsl:with-param name="kod" select="'W'"/>
							<xsl:with-param name="symbol" select="'022'"/>
							<xsl:with-param name="wyszczeg" select="'Kwota odsetek od należności niezapłaconych w terminie'"/>
						</xsl:call-template>
						<xsl:call-template name="Rb-31_danePozycjeE">
							<xsl:with-param name="kod" select="'W'"/>
							<xsl:with-param name="symbol" select="'030'"/>
							<xsl:with-param name="wyszczeg" select="'Pozostałe środki obrotowe'"/>
						</xsl:call-template>
						<xsl:call-template name="Rb-31_danePozycjeE">
							<xsl:with-param name="kod" select="'W'"/>
							<xsl:with-param name="symbol" select="'040'"/>
							<xsl:with-param name="wyszczeg" select="'Zobowiązania'"/>
						</xsl:call-template>
						<tr>
							<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
								<xsl:value-of select="'W'"/>
							</td>
							<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
								<xsl:value-of select="'070'"/>
							</td>
							<td class="bottom-right-normal" style="text-align: center; font-size: 9pt; font-weight: bold">
								<xsl:value-of select="'Stan środków obrotowych netto (W010+W020+W030-W040)'"/>
							</td>
							<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; padding: 3px">
								<xsl:choose>
									<xsl:when test="Stan/Pozycja[child::Kod = 'W' and child::Symbol = '070']/P">
										<xsl:value-of select="format-number(Stan/Pozycja[child::Kod = 'W' and child::Symbol = '070']/P, '#&#160;##0,00')"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="'0,00'"/>
									</xsl:otherwise>
								</xsl:choose>
							</td>
							<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; padding: 3px">
								<xsl:choose>
									<xsl:when test="Stan/Pozycja[child::Kod = 'W' and child::Symbol = '070']/O">
										<xsl:value-of select="format-number(Stan/Pozycja[child::Kod = 'W' and child::Symbol = '070']/O, '#&#160;##0,00')"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="'0,00'"/>
									</xsl:otherwise>
								</xsl:choose>
							</td>
						</tr>
						<tr>
							<td class="bottom-right-normal" style="text-align: center; font-size: 8pt"/>
							<td class="bottom-right-normal" style="text-align: center; font-size: 8pt"/>
							<td class="bottom-right-normal" style="text-align: center; font-size: 8pt; font-weight: bold">
								<xsl:value-of select="'Dane uzupełniające dot. należności i zobowiązań'"/>
							</td>
							<td class="bottom-right-normal" style="text-align: center; font-size: 9pt">X</td>
							<td class="bottom-right-normal" style="text-align: center; font-size: 9pt">X</td>
						</tr>
						<xsl:call-template name="Rb-31_danePozycjeE">
							<xsl:with-param name="kod" select="'W'"/>
							<xsl:with-param name="symbol" select="'080'"/>
							<xsl:with-param name="wyszczeg" select="'Należności od pracowników'"/>
						</xsl:call-template>
						<xsl:call-template name="Rb-31_danePozycjeE">
							<xsl:with-param name="kod" select="'W'"/>
							<xsl:with-param name="symbol" select="'081'"/>
							<xsl:with-param name="wyszczeg" select="'Należności z tytułu sprzedaży dóbr i usług'"/>
						</xsl:call-template>
						<xsl:call-template name="Rb-31_danePozycjeE">
							<xsl:with-param name="kod" select="'W'"/>
							<xsl:with-param name="symbol" select="'090'"/>
							<xsl:with-param name="wyszczeg" select="'Zobowiązania z tytułu wynagrodzeń'"/>
						</xsl:call-template>
						<xsl:call-template name="Rb-31_danePozycjeE">
							<xsl:with-param name="kod" select="'W'"/>
							<xsl:with-param name="symbol" select="'091'"/>
							<xsl:with-param name="wyszczeg" select="'Zobowiązania z tytułu składek na ubezpieczenia społeczne'"/>
						</xsl:call-template>
						<tr>
							<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
								<xsl:value-of select="'W'"/>
							</td>
							<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
								<xsl:value-of select="'092'"/>
							</td>
							<td class="bottom-right-normal" style="text-align: left; font-size: 8pt; padding: 3px">
								<div style="margin: 0">w tym z tytułu:</div>
								<div style="margin: 0 0 0 15px">składek na FUS</div>
							</td>
							<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; padding: 3px">
								<xsl:choose>
									<xsl:when test="Stan/Pozycja[child::Kod = 'W' and child::Symbol = '092']/P">
										<xsl:value-of select="format-number(Stan/Pozycja[child::Kod = 'W' and child::Symbol = '092']/P, '#&#160;##0,00')"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="'0,00'"/>
									</xsl:otherwise>
								</xsl:choose>
							</td>
							<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; padding: 3px">
								<xsl:choose>
									<xsl:when test="Stan/Pozycja[child::Kod = 'W' and child::Symbol = '092']/O">
										<xsl:value-of select="format-number(Stan/Pozycja[child::Kod = 'W' and child::Symbol = '092']/O, '#&#160;##0,00')"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="'0,00'"/>
									</xsl:otherwise>
								</xsl:choose>
							</td>
						</tr>
						<tr>
							<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
								<xsl:value-of select="'W'"/>
							</td>
							<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
								<xsl:value-of select="'093'"/>
							</td>
							<td class="bottom-right-normal" style="text-align: left; font-size: 8pt; padding: 3px">
								<div style="margin: 0 0 0 15px">składek na Fundusz Pracy</div>
							</td>
							<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; padding: 3px">
								<xsl:choose>
									<xsl:when test="Stan/Pozycja[child::Kod = 'W' and child::Symbol = '093']/P">
										<xsl:value-of select="format-number(Stan/Pozycja[child::Kod = 'W' and child::Symbol = '093']/P, '#&#160;##0,00')"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="'0,00'"/>
									</xsl:otherwise>
								</xsl:choose>
							</td>
							<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; padding: 3px">
								<xsl:choose>
									<xsl:when test="Stan/Pozycja[child::Kod = 'W' and child::Symbol = '093']/O">
										<xsl:value-of select="format-number(Stan/Pozycja[child::Kod = 'W' and child::Symbol = '093']/O, '#&#160;##0,00')"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="'0,00'"/>
									</xsl:otherwise>
								</xsl:choose>
							</td>
						</tr>
						<xsl:call-template name="Rb-31_danePozycjeE">
							<xsl:with-param name="kod" select="'W'"/>
							<xsl:with-param name="symbol" select="'094'"/>
							<xsl:with-param name="wyszczeg" select="'Zobowiązania z tytułu zakupu dóbr i usług'"/>
						</xsl:call-template>
					</tbody>
				</table>
				<div style="margin-bottom: 20px">
					<div style="display: block; font-size: 7pt;margin-bottom:0">
						<sup>1)</sup> kwota należności pomniejszona o odpis aktualizujący należności oraz odsetki od należności niezapłaconych w terminie
          </div>
				</div>
				<table cellpadding="0" cellspacing="0">
					<tbody>
						<tr>
							<td style="width: 450px">
								<div style="font-size: 10pt; font-weight: bold; margin-left: 5px; margin-bottom: 5px">F. DANE UZUPEŁNIAJĄCE</div>
							</td>
						</tr>
						<tr>
							<td>
								<div style="font-size: 9pt; font-weight: bold; margin-left: 5px">Informacja o rozliczeniu kasowym z budżetem - w okresie od dnia 1 stycznia do końca okresu sprawozdawczego</div>
							</td>
						</tr>
					</tbody>
				</table>
				<table cellpadding="0" cellspacing="0" class="all-bold" style="margin-bottom: 60px">
					<tbody>
						<tr>
							<td class="bottom-right-mixed" style="font-size: 10pt; text-align: center; width: 80px">Kod pozycji</td>
							<td class="bottom-right-mixed" style="font-size: 10pt; text-align: center; width: 90px">Symbol</td>
							<td class="bottom-right-mixed" style="font-size: 10pt; text-align: center; width: 360px; min-width: 320px">Wyszczególnienie</td>
							<td class="bottom-right-mixed" style="font-size: 10pt; text-align: center; width: 260px">Za poprzedni rok budżetowy</td>
							<td class="bottom-bold" style="font-size: 10pt; text-align: center; width: 260px">Za okres sprawozdawczy</td>
						</tr>
						<tr>
							<td class="bottom-right-mixed" style="text-align:center; font-size: 8pt">
								<xsl:value-of select="11"/>
							</td>
							<td class="bottom-right-mixed" style="text-align:center; font-size: 8pt">
								<xsl:value-of select="12"/>
							</td>
							<td class="bottom-right-mixed" style="text-align: center; font-size: 8pt">
								<xsl:value-of select="$nbsp"/>
							</td>
							<td class="bottom-right-mixed" style="text-align:center; font-size: 8pt">
								<xsl:value-of select="13"/>
							</td>
							<td class="bottom-bold" style="text-align:center; font-size: 8pt">
								<xsl:value-of select="14"/>
							</td>
						</tr>
						<xsl:call-template name="Rb-31_danePozycjeF">
							<xsl:with-param name="kod" select="'Z'"/>
							<xsl:with-param name="symbol" select="'100'"/>
							<xsl:with-param name="wyszczeg" select="'Podatek dochodowy od osób prawnych'"/>
						</xsl:call-template>
						<xsl:call-template name="Rb-31_danePozycjeF">
							<xsl:with-param name="kod" select="'Z'"/>
							<xsl:with-param name="symbol" select="'101'"/>
							<xsl:with-param name="wyszczeg" select="'Wpłata nadwyżki środków obrotowych'"/>
						</xsl:call-template>
						<xsl:call-template name="Rb-31_danePozycjeF">
							<xsl:with-param name="kod" select="'Z'"/>
							<xsl:with-param name="symbol" select="'102'"/>
							<xsl:with-param name="wyszczeg" select="'Podatek VAT od otrzymanych dotacji przedmiotowych'"/>
							<xsl:with-param name="ostWiersz" select="true()"/>
						</xsl:call-template>
					</tbody>
				</table>
				<table cellpadding="0" cellspacing="0" class="all-bold" style="margin-bottom: 20px; width: 100%">
					<tbody>
						<tr style="height: 30px" valign="top">
							<td style="font-size: 9pt; font-weight: bold; text-align:left; padding: 3px 10px; margin-left: 5px; margin-bottom: 25px">Wyjaśnienia do sprawozdania Rb-31</td>
						</tr>
						<tr style="min-height: 50px; height: 70px" valign="top">
							<td style="text-align: left; font-size: 8pt; padding: 3px 10px; border-width: 4px 0 0 0; border-style: solid; border-color: black">
								<xsl:value-of select="Naglowek/Uwagi"/>
							</td>
						</tr>
					</tbody>
				</table>
				<!-- ewentualne uwagi z pozycji -->
				<xsl:if test="PrzychodyPozycje/Pozycja[child::Uwagi] or PrzychodyPodsumowanie/Pozycja[child::Uwagi]">
					<table cellpadding="0" cellspacing="0" class="all-bold" style="margin-bottom: 20px; width: 100%">
						<tbody>
							<tr>
								<td colspan="4" style="text-align: center; font-size: 9pt; font-weight: bold; padding: 3px 10px">
									<div>Uwagi do części: "Przychody"</div>
								</td>
							</tr>
							<tr>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 4px 4px 0; width: 6%">Kod pozycji</td>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 4px 4px 0; width: 24%">Paragraf</td>
								<td colspan="2" style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 0 4px 0">Uwaga</td>
							</tr>
							<xsl:for-each select="PrzychodyPozycje/Pozycja[child::Uwagi]">
								<xsl:sort select="Paragraf"/>
								<tr>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="'G'"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="concat(Paragraf, P4)"/>
									</td>
									<td colspan="2" class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:value-of select="Uwagi"/>
									</td>
								</tr>
							</xsl:for-each>
							<xsl:if test="PrzychodyPodsumowanie/Pozycja[child::Kod = 'I' and child::Symbol = '110' and child::Uwagi]">
								<tr>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="PrzychodyPodsumowanie/Pozycja[child::Kod = 'I' and child::Symbol = '110']/Kod"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="'110 (Pokrycie amortyzacji)'"/>
									</td>
									<td colspan="2" class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:value-of select="PrzychodyPodsumowanie/Pozycja[child::Kod = 'I' and child::Symbol = '110']/Uwagi"/>
									</td>
								</tr>
							</xsl:if>
							<xsl:if test="PrzychodyPodsumowanie/Pozycja[child::Kod = 'K' and child::Symbol = '100' and child::Uwagi]">
								<tr>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="PrzychodyPodsumowanie/Pozycja[child::Kod = 'K' and child::Symbol = '100']/Kod"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="'100 (Inne zwiększenia)'"/>
									</td>
									<td colspan="2" class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:value-of select="PrzychodyPodsumowanie/Pozycja[child::Kod = 'K' and child::Symbol = '100']/Uwagi"/>
									</td>
								</tr>
							</xsl:if>
							<xsl:if test="PrzychodyPodsumowanie/Pozycja[child::Kod = 'H' and child::Uwagi]">
								<tr>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="PrzychodyPodsumowanie/Pozycja[child::Kod = 'H']/Kod"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="'Razem'"/>
									</td>
									<td colspan="2" class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:value-of select="PrzychodyPodsumowanie/Pozycja[child::Kod = 'H']/Uwagi"/>
									</td>
								</tr>
							</xsl:if>
						</tbody>
					</table>
				</xsl:if>
				<xsl:if test="KosztyPozycje/Pozycja[child::Uwagi] or KosztyPodsumowanie/Pozycja[child::Uwagi]">
					<table cellpadding="0" cellspacing="0" class="all-bold" style="margin-bottom: 20px; width: 100%">
						<tbody>
							<tr>
								<td colspan="4" style="text-align: center; font-size: 9pt; font-weight: bold; padding: 3px 10px">
									<div>Uwagi do części: "Koszty"</div>
								</td>
							</tr>
							<tr>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 4px 4px 0; width: 6%">Kod pozycji</td>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 4px 4px 0; width: 24%">Paragraf</td>
								<td colspan="2" style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 0 4px 0">Uwaga</td>
							</tr>
							<xsl:for-each select="KosztyPozycje/Pozycja[child::Uwagi]">
								<xsl:sort select="Paragraf"/>
								<tr>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="'M'"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="concat(Paragraf, P4)"/>
									</td>
									<td colspan="2" class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:value-of select="Uwagi"/>
									</td>
								</tr>
							</xsl:for-each>
							<xsl:if test="KosztyPodsumowanie/Pozycja[child::Kod = 'I' and child::Symbol = '100' and child::Uwagi]">
								<tr>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="KosztyPodsumowanie/Pozycja[child::Kod = 'I' and child::Symbol = '100']/Kod"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="'100 (Odpisy amortyzacji)'"/>
									</td>
									<td colspan="2" class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:value-of select="KosztyPodsumowanie/Pozycja[child::Kod = 'I' and child::Symbol = '100']/Uwagi"/>
									</td>
								</tr>
							</xsl:if>
							<xsl:if test="KosztyPodsumowanie/Pozycja[child::Kod = 'P' and child::Symbol = '100' and child::Uwagi]">
								<tr>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="KosztyPodsumowanie/Pozycja[child::Kod = 'P' and child::Symbol = '100']/Kod"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="'100 (Inne zmniejszenia)'"/>
									</td>
									<td colspan="2" class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:value-of select="KosztyPodsumowanie/Pozycja[child::Kod = 'P' and child::Symbol = '100']/Uwagi"/>
									</td>
								</tr>
							</xsl:if>
							<xsl:if test="KosztyPodsumowanie/Pozycja[child::Kod = 'N' and child::Uwagi]">
								<tr>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="KosztyPodsumowanie/Pozycja[child::Kod = 'N']/Kod"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="'Razem'"/>
									</td>
									<td colspan="2" class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:value-of select="KosztyPodsumowanie/Pozycja[child::Kod = 'N']/Uwagi"/>
									</td>
								</tr>
							</xsl:if>
						</tbody>
					</table>
				</xsl:if>
				<xsl:if test="RozliczenieWyniku/Pozycja[child::Uwagi]">
					<table cellpadding="0" cellspacing="0" class="all-bold" style="margin-bottom: 20px; width: 100%">
						<tbody>
							<tr>
								<td colspan="4" style="text-align: center; font-size: 9pt; font-weight: bold; padding: 3px 10px">
									<div>Uwagi do części: "Rozliczenie wyniku"</div>
								</td>
							</tr>
							<tr>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 4px 4px 0; width: 4%">Kod</td>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 4px 4px 0; width: 6%">Symbol</td>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 4px 4px 0; width: 30%">Wyszczególnienie</td>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 0 4px 0">Uwaga</td>
							</tr>
							<xsl:if test="RozliczenieWyniku/Pozycja[child::Kod = 'S' and child::Symbol = '100' and child::Uwagi]">
								<tr>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="RozliczenieWyniku/Pozycja[child::Kod = 'S' and child::Symbol = '100']/Kod"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="RozliczenieWyniku/Pozycja[child::Kod = 'S' and child::Symbol = '100']/Symbol"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:value-of select="'Wynik finansowy brutto (H-N)'"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:value-of select="RozliczenieWyniku/Pozycja[child::Kod = 'S' and child::Symbol = '100']/Uwagi"/>
									</td>
								</tr>
							</xsl:if>
							<xsl:if test="RozliczenieWyniku/Pozycja[child::Kod = 'Q' and child::Symbol = '110' and child::Uwagi]">
								<tr>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="RozliczenieWyniku/Pozycja[child::Kod = 'Q' and child::Symbol = '110']/Kod"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="RozliczenieWyniku/Pozycja[child::Kod = 'Q' and child::Symbol = '110']/Symbol"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:value-of select="'Podatek osobowy od osób prawnych (ustalony), w tym:'"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:value-of select="RozliczenieWyniku/Pozycja[child::Kod = 'Q' and child::Symbol = '110']/Uwagi"/>
									</td>
								</tr>
							</xsl:if>
							<xsl:if test="RozliczenieWyniku/Pozycja[child::Kod = 'Q' and child::Symbol = '111' and child::Uwagi]">
								<tr>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="RozliczenieWyniku/Pozycja[child::Kod = 'Q' and child::Symbol = '111']/Kod"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="RozliczenieWyniku/Pozycja[child::Kod = 'Q' and child::Symbol = '111']/Symbol"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:value-of select="'kwota zwolnienia od podatku dochodowego'"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:value-of select="RozliczenieWyniku/Pozycja[child::Kod = 'Q' and child::Symbol = '111']/Uwagi"/>
									</td>
								</tr>
							</xsl:if>
							<xsl:if test="RozliczenieWyniku/Pozycja[child::Kod = 'Q' and child::Symbol = '120' and child::Uwagi]">
								<tr>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="RozliczenieWyniku/Pozycja[child::Kod = 'Q' and child::Symbol = '120']/Kod"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="RozliczenieWyniku/Pozycja[child::Kod = 'Q' and child::Symbol = '120']/Symbol"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:value-of select="'Inne obciążenia wyniku finansowego'"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:value-of select="RozliczenieWyniku/Pozycja[child::Kod = 'Q' and child::Symbol = '120']/Uwagi"/>
									</td>
								</tr>
							</xsl:if>
							<xsl:if test="RozliczenieWyniku/Pozycja[child::Kod = 'R' and child::Symbol = '200' and child::Uwagi]">
								<tr>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="RozliczenieWyniku/Pozycja[child::Kod = 'R' and child::Symbol = '200']/Kod"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="RozliczenieWyniku/Pozycja[child::Kod = 'R' and child::Symbol = '200']/Symbol"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:value-of select="'Zysk do podziału (S100-Q110-Q120), z tego:'"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:value-of select="RozliczenieWyniku/Pozycja[child::Kod = 'R' and child::Symbol = '200']/Uwagi"/>
									</td>
								</tr>
							</xsl:if>
							<xsl:if test="RozliczenieWyniku/Pozycja[child::Kod = 'R' and child::Symbol = '210' and child::Uwagi]">
								<tr>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="RozliczenieWyniku/Pozycja[child::Kod = 'R' and child::Symbol = '210']/Kod"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="RozliczenieWyniku/Pozycja[child::Kod = 'R' and child::Symbol = '210']/Symbol"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:value-of select="'wpłata do budżetu'"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:value-of select="RozliczenieWyniku/Pozycja[child::Kod = 'R' and child::Symbol = '210']/Uwagi"/>
									</td>
								</tr>
							</xsl:if>
							<xsl:if test="RozliczenieWyniku/Pozycja[child::Kod = 'R' and child::Symbol = '110' and child::Uwagi]">
								<tr>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="RozliczenieWyniku/Pozycja[child::Kod = 'R' and child::Symbol = '110']/Kod"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="RozliczenieWyniku/Pozycja[child::Kod = 'R' and child::Symbol = '110']/Symbol"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:value-of select="'zysk pozostający w gospodarstwie pomocniczym'"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:value-of select="RozliczenieWyniku/Pozycja[child::Kod = 'R' and child::Symbol = '110']/Uwagi"/>
									</td>
								</tr>
							</xsl:if>
							<xsl:if test="RozliczenieWyniku/Pozycja[child::Kod = 'R' and child::Symbol = '100' and child::Uwagi]">
								<tr>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="RozliczenieWyniku/Pozycja[child::Kod = 'R' and child::Symbol = '100']/Kod"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="RozliczenieWyniku/Pozycja[child::Kod = 'R' and child::Symbol = '100']/Symbol"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:value-of select="'Strata - ze znakiem minus'"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:value-of select="RozliczenieWyniku/Pozycja[child::Kod = 'R' and child::Symbol = '100']/Uwagi"/>
									</td>
								</tr>
							</xsl:if>
						</tbody>
					</table>
				</xsl:if>
				<xsl:if test="PodzialZysku/Pozycja[child::Uwagi]">
					<table cellpadding="0" cellspacing="0" class="all-bold" style="margin-bottom: 20px; width: 100%">
						<tbody>
							<tr>
								<td colspan="4" style="text-align: center; font-size: 9pt; font-weight: bold; padding: 3px 10px">
									<div>Uwagi do części: "Podział zysku"</div>
								</td>
							</tr>
							<tr>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 4px 4px 0; width: 4%">Kod</td>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 4px 4px 0; width: 6%">Symbol</td>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 4px 4px 0; width: 30%">Wyszczególnienie</td>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 0 4px 0">Uwaga</td>
							</tr>
							<xsl:if test="PodzialZysku/Pozycja[child::Kod = 'T' and child::Symbol = '100' and child::Uwagi]">
								<tr>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="PodzialZysku/Pozycja[child::Kod = 'T' and child::Symbol = '100']/Kod"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="PodzialZysku/Pozycja[child::Kod = 'T' and child::Symbol = '100']/Symbol"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:value-of select="'- Zysk'"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:value-of select="PodzialZysku/Pozycja[child::Kod = 'T' and child::Symbol = '100']/Uwagi"/>
									</td>
								</tr>
							</xsl:if>
							<xsl:if test="PodzialZysku/Pozycja[child::Kod = 'T' and child::Symbol = '200' and child::Uwagi]">
								<tr>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="PodzialZysku/Pozycja[child::Kod = 'T' and child::Symbol = '200']/Kod"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="PodzialZysku/Pozycja[child::Kod = 'T' and child::Symbol = '200']/Symbol"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:value-of select="'- Strata (ze znakiem minus)'"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:value-of select="PodzialZysku/Pozycja[child::Kod = 'T' and child::Symbol = '200']/Uwagi"/>
									</td>
								</tr>
							</xsl:if>
							<xsl:if test="PodzialZysku/Pozycja[child::Kod = 'T' and child::Symbol = '120' and child::Uwagi]">
								<tr>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="PodzialZysku/Pozycja[child::Kod = 'T' and child::Symbol = '120']/Kod"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="PodzialZysku/Pozycja[child::Kod = 'T' and child::Symbol = '120']/Symbol"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:value-of select="'Zwiększenie środków obrotowych'"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:value-of select="PodzialZysku/Pozycja[child::Kod = 'T' and child::Symbol = '120']/Uwagi"/>
									</td>
								</tr>
							</xsl:if>
							<xsl:if test="PodzialZysku/Pozycja[child::Kod = 'T' and child::Symbol = '130' and child::Uwagi]">
								<tr>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="PodzialZysku/Pozycja[child::Kod = 'T' and child::Symbol = '130']/Kod"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="PodzialZysku/Pozycja[child::Kod = 'T' and child::Symbol = '130']/Symbol"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:value-of select="'Dofinansowanie inwestycji'"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:value-of select="PodzialZysku/Pozycja[child::Kod = 'T' and child::Symbol = '130']/Uwagi"/>
									</td>
								</tr>
							</xsl:if>
							<xsl:if test="PodzialZysku/Pozycja[child::Kod = 'T' and child::Symbol = '140' and child::Uwagi]">
								<tr>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="PodzialZysku/Pozycja[child::Kod = 'T' and child::Symbol = '140']/Kod"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="PodzialZysku/Pozycja[child::Kod = 'T' and child::Symbol = '140']/Symbol"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:value-of select="'Inne cele'"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:value-of select="PodzialZysku/Pozycja[child::Kod = 'T' and child::Symbol = '140']/Uwagi"/>
									</td>
								</tr>
							</xsl:if>
							<xsl:if test="PodzialZysku/Pozycja[child::Kod = 'T' and child::Symbol = '210' and child::Uwagi]">
								<tr>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="PodzialZysku/Pozycja[child::Kod = 'T' and child::Symbol = '210']/Kod"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="PodzialZysku/Pozycja[child::Kod = 'T' and child::Symbol = '210']/Symbol"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:value-of select="'Zmniejszenie środków obrotowych na pokrycie ujemnego wyniku finansowego'"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:value-of select="PodzialZysku/Pozycja[child::Kod = 'T' and child::Symbol = '210']/Uwagi"/>
									</td>
								</tr>
							</xsl:if>
						</tbody>
					</table>
				</xsl:if>
				<xsl:if test="Stan/Pozycja[child::Uwagi]">
					<table cellpadding="0" cellspacing="0" class="all-bold" style="margin-bottom: 20px; width: 100%">
						<tbody>
							<tr>
								<td colspan="4" style="text-align: center; font-size: 9pt; font-weight: bold; padding: 3px 10px">
									<div>Uwagi do części: "Stan"</div>
								</td>
							</tr>
							<tr>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 4px 4px 0; width: 4%">Kod</td>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 4px 4px 0; width: 6%">Symbol</td>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 4px 4px 0; width: 30%">Wyszczególnienie</td>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 0 4px 0">Uwaga</td>
							</tr>
							<xsl:for-each select="Stan/Pozycja[child::Uwagi]">
								<xsl:sort select="Kod"/>
								<xsl:sort select="Symbol"/>
								<tr>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="Kod"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="Symbol"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:choose>
											<xsl:when test="Symbol = '010'">Środki pieniężne (w tym środki w kasie)</xsl:when>
											<xsl:when test="Symbol = '020'">Należności netto</xsl:when>
											<xsl:when test="Symbol = '021'">Kwota odpisu aktualizującego należności</xsl:when>
											<xsl:when test="Symbol = '022'">Kwota odsetek od należności niezapłaconych w terminie</xsl:when>
											<xsl:when test="Symbol = '030'">Pozostałe środki obrotowe</xsl:when>
											<xsl:when test="Symbol = '040'">Zobowiązania</xsl:when>
											<xsl:when test="Symbol = '070'">Stan środków obrotowych netto (W010+W020+W030-W040)</xsl:when>
											<xsl:when test="Symbol = '080'">Należności od pracowników</xsl:when>
											<xsl:when test="Symbol = '081'">Należności z tytułu sprzedaży dóbr i usług</xsl:when>
											<xsl:when test="Symbol = '090'">Zobowiązania z tytułu wynagrodzeń</xsl:when>
											<xsl:when test="Symbol = '091'">Zobowiązania z tytułu składek na ubezpieczenia społeczne</xsl:when>
											<xsl:when test="Symbol = '092'">w tym z tytułu: składek na FUS</xsl:when>
											<xsl:when test="Symbol = '093'">składek na Fundusz Pracy</xsl:when>
											<xsl:when test="Symbol = '094'">Zobowiązania z tytułu zakupu dóbr i usług</xsl:when>
										</xsl:choose>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:value-of select="Uwagi"/>
									</td>
								</tr>
							</xsl:for-each>
						</tbody>
					</table>
				</xsl:if>
				<xsl:if test="RozliczenieKasowe/Pozycja[child::Uwagi]">
					<table cellpadding="0" cellspacing="0" class="all-bold" style="margin-bottom: 20px; width: 100%">
						<tbody>
							<tr>
								<td colspan="4" style="text-align: center; font-size: 9pt; font-weight: bold; padding: 3px 10px">
									<div>Uwagi do części: "Rozliczenie"</div>
								</td>
							</tr>
							<tr>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 4px 4px 0; width: 4%">Kod</td>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 4px 4px 0; width: 6%">Symbol</td>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 4px 4px 0; width: 30%">Wyszczególnienie</td>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 0 4px 0">Uwaga</td>
							</tr>
							<xsl:for-each select="RozliczenieKasowe/Pozycja[child::Uwagi]">
								<xsl:sort select="Kod"/>
								<xsl:sort select="Symbol"/>
								<tr>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="Kod"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="Symbol"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:choose>
											<xsl:when test="Symbol = '100'">Podatek dochodowy od osób prawnych</xsl:when>
											<xsl:when test="Symbol = '101'">Wpłata z zysku do budżetu</xsl:when>
											<xsl:when test="Symbol = '102'">Podatek VAT od otrzymanych dotacji przedmiotowych</xsl:when>
										</xsl:choose>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:value-of select="Uwagi"/>
									</td>
								</tr>
							</xsl:for-each>
						</tbody>
					</table>
				</xsl:if>
				<table cellpadding="0" cellspacing="0" style="margin-bottom: 0px; margin-top: 80px; width: 100%">
					<tbody>
						<tr>
							<td style="text-align:center; font-size: 8pt;" valign="bottom">
								<hr style="width: 80%"/>
								<div>Główny księgowy / Skarbnik</div>
							</td>
							<td style="text-align:center; font-size: 8pt;" valign="bottom">
								<hr style="width: 80%"/>
								<div>telefon</div>
							</td>
							<td style="text-align:center; font-size: 8pt;" valign="bottom">
								<div>
									<xsl:value-of select="Naglowek/DataSprawozdania"/>
								</div>
								<hr style="width: 80%"/>
								<div>rok m-c dzień</div>
							</td>
							<td style="text-align:center; font-size: 8pt;" valign="bottom">
								<hr style="width: 80%"/>
								<div>Kierownik jednostki / Przewodniczący Zarządu</div>
							</td>
						</tr>
					</tbody>
				</table>
			</div>
			<xsl:element name="a">
				<xsl:attribute name="href"><xsl:value-of select="concat('#Jed', $jedIndex)"/></xsl:attribute>
				<xsl:element name="style">
					<xsl:value-of select="'font-family: Verdana'"/>
				</xsl:element>
				<xsl:value-of select="'Powrót do listy sprawozdań jednostki'"/>
			</xsl:element>
		</xsl:element>
	</xsl:template>
	<!-- Rb-31 szablony pomocnicze -->
	<xsl:template match="Rb-31/PrzychodyPodsumowanie">
		<xsl:param name="SymPoz"/>
		<xsl:param name="Dzial"/>
		<xsl:param name="Rozdzial"/>
		<xsl:variable name="Paragrafy" select="parent::*/PrzychodyPozycje/Pozycja/Paragraf"/>
		<xsl:variable name="P4" select="parent::*/PrzychodyPozycje/Pozycja/P4"/>
		<tr>
			<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
				<xsl:value-of select="'I'"/>
			</td>
			<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
				<xsl:value-of select="'110 (Pokrycie amortyzacji)'"/>
			</td>
			<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; padding: 3px">
				<xsl:choose>
					<xsl:when test="Pozycja[child::Kod = 'I' and child::Symbol = '110']/P">
						<xsl:value-of select="format-number(Pozycja[child::Kod = 'I' and child::Symbol = '110']/P, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
			<td class="bottom-normal" style="text-align: right; font-size: 8pt; padding: 3px">
				<xsl:choose>
					<xsl:when test="Pozycja[child::Kod = 'I' and child::Symbol = '110']/W">
						<xsl:value-of select="format-number(Pozycja[child::Kod = 'I' and child::Symbol = '110']/W, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
		</tr>
		<tr>
			<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
				<xsl:value-of select="'K'"/>
			</td>
			<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
				<xsl:value-of select="'100 (Inne zwiększenia)'"/>
			</td>
			<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; padding: 3px">
				<xsl:choose>
					<xsl:when test="Pozycja[child::Kod = 'K' and child::Symbol = '100']/P">
						<xsl:value-of select="format-number(Pozycja[child::Kod = 'K' and child::Symbol = '100']/P, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
			<td class="bottom-normal" style="text-align: right; font-size: 8pt; padding: 3px">
				<xsl:choose>
					<xsl:when test="Pozycja[child::Kod = 'K' and child::Symbol = '100']/W">
						<xsl:value-of select="format-number(Pozycja[child::Kod = 'K' and child::Symbol = '100']/W, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
		</tr>
		<tr>
			<td class="bottom-right-normal" style="text-align: center; font-size: 8pt; font-weight: bold">
				<xsl:value-of select="'H'"/>
			</td>
			<td class="bottom-right-normal" style="text-align: center; font-size: 9pt; font-weight: bold">
				<xsl:value-of select="'RAZEM '"/>
				<xsl:call-template name="Rb-3x_SumaKontr">
					<xsl:with-param name="Paragrafy" select="$Paragrafy"/>
					<xsl:with-param name="P4" select="$P4"/>
					<xsl:with-param name="Licznosc" select="count(parent::*/PrzychodyPozycje/Pozycja)"/>
					<xsl:with-param name="Licznik" select="1"/>
					<xsl:with-param name="Wartosc" select="0"/>
					<xsl:with-param name="SymPoz" select="$SymPoz"/>
					<xsl:with-param name="Dzial" select="$Dzial"/>
					<xsl:with-param name="Rozdzial" select="$Rozdzial"/>
				</xsl:call-template>
			</td>
			<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; font-weight: bold; padding: 3px">
				<xsl:choose>
					<xsl:when test="Pozycja[child::Kod = 'H']/P">
						<xsl:value-of select="format-number(Pozycja[child::Kod = 'H']/P, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
			<td class="bottom-right" style="text-align: right; font-size: 8pt; font-weight: bold; padding: 3px">
				<xsl:choose>
					<xsl:when test="Pozycja[child::Kod = 'H']/W">
						<xsl:value-of select="format-number(Pozycja[child::Kod = 'H']/W, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
		</tr>
	</xsl:template>
	<xsl:template match="Rb-31/KosztyPodsumowanie">
		<xsl:param name="SymPoz"/>
		<xsl:param name="Dzial"/>
		<xsl:param name="Rozdzial"/>
		<xsl:variable name="Paragrafy" select="parent::*/KosztyPozycje/Pozycja/Paragraf"/>
		<xsl:variable name="P4" select="parent::*/KosztyPozycje/Pozycja/P4"/>
		<tr>
			<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
				<xsl:value-of select="'I'"/>
			</td>
			<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
				<xsl:value-of select="'100 (Odpisy amortyzacji)'"/>
			</td>
			<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; padding: 3px">
				<xsl:choose>
					<xsl:when test="Pozycja[child::Kod = 'I' and child::Symbol = '100']/P">
						<xsl:value-of select="format-number(Pozycja[child::Kod = 'I' and child::Symbol = '100']/P, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
			<td class="bottom-normal" style="text-align: right; font-size: 8pt; padding: 3px">
				<xsl:choose>
					<xsl:when test="Pozycja[child::Kod = 'I' and child::Symbol = '100']/W">
						<xsl:value-of select="format-number(Pozycja[child::Kod = 'I' and child::Symbol = '100']/W, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
		</tr>
		<tr>
			<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
				<xsl:value-of select="'P'"/>
			</td>
			<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
				<xsl:value-of select="'100 (Inne zmniejszenia)'"/>
			</td>
			<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; padding: 3px">
				<xsl:choose>
					<xsl:when test="Pozycja[child::Kod = 'P' and child::Symbol = '100']/P">
						<xsl:value-of select="format-number(Pozycja[child::Kod = 'P' and child::Symbol = '100']/P, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
			<td class="bottom-normal" style="text-align: right; font-size: 8pt; padding: 3px">
				<xsl:choose>
					<xsl:when test="Pozycja[child::Kod = 'P' and child::Symbol = '100']/W">
						<xsl:value-of select="format-number(Pozycja[child::Kod = 'P' and child::Symbol = '100']/W, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
		</tr>
		<tr>
			<td class="bottom-right-normal" style="text-align: center; font-size: 8pt; font-weight: bold">
				<xsl:value-of select="'N'"/>
			</td>
			<td class="bottom-right-normal" style="text-align: center; font-size: 9pt; font-weight: bold">
				<xsl:value-of select="'RAZEM '"/>
				<xsl:call-template name="Rb-3x_SumaKontr">
					<xsl:with-param name="Paragrafy" select="$Paragrafy"/>
					<xsl:with-param name="P4" select="$P4"/>
					<xsl:with-param name="Licznosc" select="count(parent::*/KosztyPozycje/Pozycja)"/>
					<xsl:with-param name="Licznik" select="1"/>
					<xsl:with-param name="Wartosc" select="0"/>
					<xsl:with-param name="SymPoz" select="$SymPoz"/>
					<xsl:with-param name="Dzial" select="$Dzial"/>
					<xsl:with-param name="Rozdzial" select="$Rozdzial"/>
				</xsl:call-template>
			</td>
			<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; font-weight: bold; padding: 3px">
				<xsl:choose>
					<xsl:when test="Pozycja[child::Kod = 'N']/P">
						<xsl:value-of select="format-number(Pozycja[child::Kod = 'N']/P, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
			<td class="bottom-normal" style="text-align: right; font-size: 8pt; font-weight: bold; padding: 3px">
				<xsl:choose>
					<xsl:when test="Pozycja[child::Kod = 'N']/W">
						<xsl:value-of select="format-number(Pozycja[child::Kod = 'N']/W, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
		</tr>
	</xsl:template>
	<xsl:template name="Rb-31_danePozycjeC">
		<xsl:param name="kod"/>
		<xsl:param name="symbol"/>
		<xsl:param name="wyszczeg"/>
		<xsl:param name="ostWiersz" select="false()"/>
		<tr>
			<xsl:element name="td">
				<xsl:attribute name="style"><xsl:value-of select="'text-align: center; font-size: 8pt'"/></xsl:attribute>
				<xsl:attribute name="class"><xsl:choose><xsl:when test="$ostWiersz = false()"><xsl:value-of select="'bottom-right-normal'"/></xsl:when><xsl:otherwise><xsl:value-of select="'right-normal'"/></xsl:otherwise></xsl:choose></xsl:attribute>
				<xsl:value-of select="$kod"/>
			</xsl:element>
			<xsl:element name="td">
				<xsl:attribute name="style"><xsl:value-of select="'text-align: center; font-size: 8pt'"/></xsl:attribute>
				<xsl:attribute name="class"><xsl:choose><xsl:when test="$ostWiersz = false()"><xsl:value-of select="'bottom-right-normal'"/></xsl:when><xsl:otherwise><xsl:value-of select="'right-normal'"/></xsl:otherwise></xsl:choose></xsl:attribute>
				<xsl:value-of select="$symbol"/>
			</xsl:element>
			<xsl:element name="td">
				<xsl:attribute name="style"><xsl:value-of select="'text-align: left; font-size: 8pt; padding: 3px'"/></xsl:attribute>
				<xsl:attribute name="class"><xsl:choose><xsl:when test="$ostWiersz = false()"><xsl:value-of select="'bottom-right-normal'"/></xsl:when><xsl:otherwise><xsl:value-of select="'right-normal'"/></xsl:otherwise></xsl:choose></xsl:attribute>
				<xsl:value-of select="$wyszczeg"/>
			</xsl:element>
			<xsl:element name="td">
				<xsl:attribute name="style"><xsl:value-of select="'text-align: right; font-size: 8pt; padding: 3px'"/></xsl:attribute>
				<xsl:attribute name="class"><xsl:choose><xsl:when test="$ostWiersz = false()"><xsl:value-of select="'bottom-right-normal'"/></xsl:when><xsl:otherwise><xsl:value-of select="'right-normal'"/></xsl:otherwise></xsl:choose></xsl:attribute>
				<xsl:choose>
					<xsl:when test="RozliczenieWyniku/Pozycja[child::Kod = $kod and child::Symbol = $symbol]/P">
						<xsl:value-of select="format-number(RozliczenieWyniku/Pozycja[child::Kod = $kod and child::Symbol = $symbol]/P, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:element>
			<xsl:element name="td">
				<xsl:attribute name="style"><xsl:value-of select="'text-align: right; font-size: 8pt; padding: 3px'"/></xsl:attribute>
				<xsl:if test="$ostWiersz = false()">
					<xsl:attribute name="class"><xsl:value-of select="'bottom-normal'"/></xsl:attribute>
				</xsl:if>
				<xsl:choose>
					<xsl:when test="RozliczenieWyniku/Pozycja[child::Kod = $kod and child::Symbol = $symbol]/W">
						<xsl:value-of select="format-number(RozliczenieWyniku/Pozycja[child::Kod = $kod and child::Symbol = $symbol]/W, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:element>
		</tr>
	</xsl:template>
	<xsl:template name="Rb-31_danePozycjeD">
		<xsl:param name="kod"/>
		<xsl:param name="symbol"/>
		<xsl:param name="wyszczeg"/>
		<xsl:param name="ostWiersz" select="false()"/>
		<tr>
			<xsl:element name="td">
				<xsl:attribute name="style"><xsl:value-of select="'text-align: center; font-size: 8pt'"/></xsl:attribute>
				<xsl:attribute name="class"><xsl:choose><xsl:when test="$ostWiersz = false()"><xsl:value-of select="'bottom-right-normal'"/></xsl:when><xsl:otherwise><xsl:value-of select="'right-normal'"/></xsl:otherwise></xsl:choose></xsl:attribute>
				<xsl:value-of select="$kod"/>
			</xsl:element>
			<xsl:element name="td">
				<xsl:attribute name="style"><xsl:value-of select="'text-align: center; font-size: 8pt'"/></xsl:attribute>
				<xsl:attribute name="class"><xsl:choose><xsl:when test="$ostWiersz = false()"><xsl:value-of select="'bottom-right-normal'"/></xsl:when><xsl:otherwise><xsl:value-of select="'right-normal'"/></xsl:otherwise></xsl:choose></xsl:attribute>
				<xsl:value-of select="$symbol"/>
			</xsl:element>
			<xsl:element name="td">
				<xsl:attribute name="style"><xsl:value-of select="'text-align: left; font-size: 8pt; padding: 3px'"/></xsl:attribute>
				<xsl:attribute name="class"><xsl:choose><xsl:when test="$ostWiersz = false()"><xsl:value-of select="'bottom-right-normal'"/></xsl:when><xsl:otherwise><xsl:value-of select="'right-normal'"/></xsl:otherwise></xsl:choose></xsl:attribute>
				<xsl:value-of select="$wyszczeg"/>
			</xsl:element>
			<xsl:element name="td">
				<xsl:attribute name="style"><xsl:value-of select="'text-align: right; font-size: 8pt; padding: 3px'"/></xsl:attribute>
				<xsl:attribute name="class"><xsl:choose><xsl:when test="$ostWiersz = false()"><xsl:value-of select="'bottom-right-normal'"/></xsl:when><xsl:otherwise><xsl:value-of select="'right-normal'"/></xsl:otherwise></xsl:choose></xsl:attribute>
				<xsl:choose>
					<xsl:when test="PodzialZysku/Pozycja[child::Kod = $kod and child::Symbol = $symbol]/P">
						<xsl:value-of select="format-number(PodzialZysku/Pozycja[child::Kod = $kod and child::Symbol = $symbol]/P, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:element>
			<xsl:element name="td">
				<xsl:attribute name="style"><xsl:value-of select="'text-align: right; font-size: 8pt; padding: 3px'"/></xsl:attribute>
				<xsl:if test="$ostWiersz = false()">
					<xsl:attribute name="class"><xsl:value-of select="'bottom-normal'"/></xsl:attribute>
				</xsl:if>
				<xsl:choose>
					<xsl:when test="PodzialZysku/Pozycja[child::Kod = $kod and child::Symbol = $symbol]/W">
						<xsl:value-of select="format-number(PodzialZysku/Pozycja[child::Kod = $kod and child::Symbol = $symbol]/W, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:element>
		</tr>
	</xsl:template>
	<xsl:template name="Rb-31_danePozycjeE">
		<xsl:param name="kod"/>
		<xsl:param name="symbol"/>
		<xsl:param name="wyszczeg"/>
		<xsl:param name="ostWiersz" select="false()"/>
		<tr>
			<xsl:element name="td">
				<xsl:attribute name="style"><xsl:value-of select="'text-align: center; font-size: 8pt'"/></xsl:attribute>
				<xsl:attribute name="class"><xsl:choose><xsl:when test="$ostWiersz = false()"><xsl:value-of select="'bottom-right-normal'"/></xsl:when><xsl:otherwise><xsl:value-of select="'right-normal'"/></xsl:otherwise></xsl:choose></xsl:attribute>
				<xsl:value-of select="$kod"/>
			</xsl:element>
			<xsl:element name="td">
				<xsl:attribute name="style"><xsl:value-of select="'text-align: center; font-size: 8pt'"/></xsl:attribute>
				<xsl:attribute name="class"><xsl:choose><xsl:when test="$ostWiersz = false()"><xsl:value-of select="'bottom-right-normal'"/></xsl:when><xsl:otherwise><xsl:value-of select="'right-normal'"/></xsl:otherwise></xsl:choose></xsl:attribute>
				<xsl:value-of select="$symbol"/>
			</xsl:element>
			<xsl:element name="td">
				<xsl:attribute name="style"><xsl:value-of select="'text-align: left; font-size: 8pt; padding: 3px'"/></xsl:attribute>
				<xsl:attribute name="class"><xsl:choose><xsl:when test="$ostWiersz = false()"><xsl:value-of select="'bottom-right-normal'"/></xsl:when><xsl:otherwise><xsl:value-of select="'right-normal'"/></xsl:otherwise></xsl:choose></xsl:attribute>
				<xsl:value-of select="$wyszczeg"/>
			</xsl:element>
			<xsl:element name="td">
				<xsl:attribute name="style"><xsl:value-of select="'text-align: right; font-size: 8pt; padding: 3px'"/></xsl:attribute>
				<xsl:attribute name="class"><xsl:choose><xsl:when test="$ostWiersz = false()"><xsl:value-of select="'bottom-right-normal'"/></xsl:when><xsl:otherwise><xsl:value-of select="'right-normal'"/></xsl:otherwise></xsl:choose></xsl:attribute>
				<xsl:choose>
					<xsl:when test="Stan/Pozycja[child::Kod = $kod and child::Symbol = $symbol]/P">
						<xsl:value-of select="format-number(Stan/Pozycja[child::Kod = $kod and child::Symbol = $symbol]/P, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:element>
			<xsl:element name="td">
				<xsl:attribute name="style"><xsl:value-of select="'text-align: right; font-size: 8pt; padding: 3px'"/></xsl:attribute>
				<xsl:if test="$ostWiersz = false()">
					<xsl:attribute name="class"><xsl:value-of select="'bottom-normal'"/></xsl:attribute>
				</xsl:if>
				<xsl:choose>
					<xsl:when test="Stan/Pozycja[child::Kod = $kod and child::Symbol = $symbol]/O">
						<xsl:value-of select="format-number(Stan/Pozycja[child::Kod = $kod and child::Symbol = $symbol]/O, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:element>
		</tr>
	</xsl:template>
	<xsl:template name="Rb-31_danePozycjeF">
		<xsl:param name="kod"/>
		<xsl:param name="symbol"/>
		<xsl:param name="wyszczeg"/>
		<xsl:param name="ostWiersz" select="false()"/>
		<tr>
			<xsl:element name="td">
				<xsl:attribute name="style"><xsl:value-of select="'text-align: center; font-size: 8pt'"/></xsl:attribute>
				<xsl:attribute name="class"><xsl:choose><xsl:when test="$ostWiersz = false()"><xsl:value-of select="'bottom-right-normal'"/></xsl:when><xsl:otherwise><xsl:value-of select="'right-normal'"/></xsl:otherwise></xsl:choose></xsl:attribute>
				<xsl:value-of select="$kod"/>
			</xsl:element>
			<xsl:element name="td">
				<xsl:attribute name="style"><xsl:value-of select="'text-align: center; font-size: 8pt'"/></xsl:attribute>
				<xsl:attribute name="class"><xsl:choose><xsl:when test="$ostWiersz = false()"><xsl:value-of select="'bottom-right-normal'"/></xsl:when><xsl:otherwise><xsl:value-of select="'right-normal'"/></xsl:otherwise></xsl:choose></xsl:attribute>
				<xsl:value-of select="$symbol"/>
			</xsl:element>
			<xsl:element name="td">
				<xsl:attribute name="style"><xsl:value-of select="'text-align: left; font-size: 8pt; padding: 3px'"/></xsl:attribute>
				<xsl:attribute name="class"><xsl:choose><xsl:when test="$ostWiersz = false()"><xsl:value-of select="'bottom-right-normal'"/></xsl:when><xsl:otherwise><xsl:value-of select="'right-normal'"/></xsl:otherwise></xsl:choose></xsl:attribute>
				<xsl:value-of select="$wyszczeg"/>
			</xsl:element>
			<xsl:element name="td">
				<xsl:attribute name="style"><xsl:value-of select="'text-align: right; font-size: 8pt; padding: 3px'"/></xsl:attribute>
				<xsl:attribute name="class"><xsl:choose><xsl:when test="$ostWiersz = false()"><xsl:value-of select="'bottom-right-normal'"/></xsl:when><xsl:otherwise><xsl:value-of select="'right-normal'"/></xsl:otherwise></xsl:choose></xsl:attribute>
				<xsl:choose>
					<xsl:when test="RozliczenieKasowe/Pozycja[child::Kod = $kod and child::Symbol = $symbol]/P">
						<xsl:value-of select="format-number(RozliczenieKasowe/Pozycja[child::Kod = $kod and child::Symbol = $symbol]/P, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:element>
			<xsl:element name="td">
				<xsl:attribute name="style"><xsl:value-of select="'text-align: right; font-size: 8pt; padding: 3px'"/></xsl:attribute>
				<xsl:if test="$ostWiersz = false()">
					<xsl:attribute name="class"><xsl:value-of select="'bottom-normal'"/></xsl:attribute>
				</xsl:if>
				<xsl:choose>
					<xsl:when test="RozliczenieKasowe/Pozycja[child::Kod = $kod and child::Symbol = $symbol]/O">
						<xsl:value-of select="format-number(RozliczenieKasowe/Pozycja[child::Kod = $kod and child::Symbol = $symbol]/O, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:element>
		</tr>
	</xsl:template>
	<!-- Rb-33 -->
	<xsl:template match="Rb-33">
		<xsl:param name="jedIndex"/>
		<xsl:param name="sprIndex"/>
		<xsl:element name="div">
			<xsl:attribute name="Id"><xsl:value-of select="concat('Jed', $jedIndex, 'Wer', $sprIndex)"/></xsl:attribute>
			<xsl:attribute name="style"><xsl:value-of select="'display: block; margin-bottom: 40px'"/></xsl:attribute>
			<div style="font-size: 12pt; font-weight: bold; margin-left: 5px; margin-bottom: 10px">
        Sprawozdanie Rb-33:
        <xsl:choose>
					<xsl:when test="Naglowek/Wersja = 0">
						<xsl:value-of select="'wersja pierwotna'"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="concat('korekta nr ', Naglowek/Wersja)"/>
					</xsl:otherwise>
				</xsl:choose>
				<xsl:call-template name="SprNaglowekInfo"/>
			</div>
			<table cellpadding="0" cellspacing="0" class="all-bold" style="margin-bottom: 30px">
				<tbody>
					<tr style="height: 18px">
						<td colspan="10" class="bottom-bold" style="font-size: 10pt;">MINISTERSTWO FINANSÓW, ul. Świętokrzyska 12, 00-916 Warszawa</td>
					</tr>
					<tr style="height: 127px">
						<td colspan="4" class="bottom-bold" style="width:300px">
							<table cellpadding="0" cellspacing="0" style="border-collapse: collapse; height" width="100%">
								<tbody>
									<tr style="height: 80px">
										<td style="text-align: left; font-size: 9pt; margin:1px 1px 0 0; padding:0" valign="top">
                      Nazwa i adres jednostki sprawozdawczej
                    </td>
									</tr>
									<tr>
										<td class="bottom-normal" style="text-align: center; font-size: 9pt" valign="bottom">
											<!-- popr. nr I.8 -->
											<div style="display: block;margin: 0 20px">
												<xsl:choose>
													<xsl:when test="Jednostka/Nazwa">
														<xsl:value-of select="Jednostka/Nazwa"/>
													</xsl:when>
													<xsl:otherwise>
														<xsl:value-of select="../../Nazwa"/>
													</xsl:otherwise>
												</xsl:choose>
											</div>
										</td>
									</tr>
									<tr style="height: 23px">
										<td style="text-align: left; font-size: 9pt; margin:1px 1px 0 0; padding:0;" valign="top">
                      Numer identyfikacyjny REGON
                    </td>
									</tr>
									<tr>
										<td style="text-align: center; font-size: 9pt; font-weight: bold; margin:1px 1px 0 0; padding:0" valign="baseline">
											<xsl:choose>
												<xsl:when test="Jednostka/Regon">
													<xsl:value-of select="Jednostka/Regon"/>
												</xsl:when>
												<xsl:otherwise>
													<xsl:value-of select="../../Regon"/>
												</xsl:otherwise>
											</xsl:choose>
										</td>
									</tr>
								</tbody>
							</table>
						</td>
						<td colspan="3" class="notop-bold" valign="top" style="width: 400px">
							<div style="font-weight: bold; text-align: center; font-size: 11pt; margin-bottom: 5px">Rb-33 półroczne / roczne sprawozdanie z wykonania planów finansowych funduszy celowych nie posiadających osobowości prawnej</div>
							<div style="vertical-align: bottom; text-align: center; font-size: 9pt; margin-top: 50px">
								<xsl:call-template name="NaglowekSprOkres"/>
							</div>
						</td>
						<td colspan="3" class="bottom-bold" style="text-align: left; font-size: 9pt; margin:1px 1px 0 0; padding:0; width: 300px" valign="top">
							<div style="margin-bottom:5px">Adresat:</div>
							<!-- popr. nr I.9 -->
							<div style="text-align:center; margin-bottom: 15px;">
								<!-- <xsl:value-of select="'Regionalna Izba Obrachunkowa w Katowicach'"/> -->
							</div>
							<div style="text-align:center;">
								<!-- <xsl:value-of select="'wersja robocza'"/> -->
							</div>
						</td>
					</tr>
					<tr style="height: 54px">
						<td rowspan="2" colspan="7" class="bottom-right-bold" style="font-size: 9pt">
							<!-- popr. nr I.10 -->
							<div style="margin-bottom: 1px">
								<xsl:value-of select="'Nazwa województwa '"/>
								<sup>1) 2)</sup>
								<!-- <xsl:if test="../../Typ = 'W'">
									<span style="margin-left: 10px">
										<b>
											<xsl:value-of select="../../Nazwa"/>
										</b>
									</span>
								</xsl:if> -->
							</div>
							<div style="margin-bottom: 1px">
								<xsl:value-of select="'Nazwa powiatu / związku '"/>
								<sup>1) 2)</sup>
								<!-- <xsl:if test="../../Typ = 'P'">
									<span style="margin-left: 10px">
										<b>
											<xsl:value-of select="../../Nazwa"/>
										</b>
									</span>
								</xsl:if> -->
							</div>
							<div>
								<xsl:value-of select="'Nazwa gminy / związku '"/>
								<sup>1) 2)</sup>
								<!-- <xsl:if test="../../Typ = 'G'">
									<span style="margin-left: 10px">
										<b>
											<xsl:value-of select="../../Nazwa"/>
										</b>
									</span>
								</xsl:if> -->
							</div>
						</td>
						<td colspan="3" class="bottom-bold" style="font-size:9pt; text-align:center">Przed wypełnieniem przeczytać instrukcję</td>
					</tr>
					<tr>
						<td colspan="3" class="bottom-bold" style="font-size:9pt; text-align:center">Wysyłać bez pisma przewodniego</td>
					</tr>
					<tr>
						<td colspan="7" class="right-bottom-mixed" style="font-size:10pt; text-align:center">Symbole</td>
						<td colspan="3" class="bottom-normal" style="font-size:10pt; text-align:center">Klasyfikacja budżetowa</td>
					</tr>
					<tr>
						<td class="bottom-right-normal" style="font-size:9pt; text-align:center">woj.</td>
						<td class="bottom-right-normal" style="font-size:9pt; text-align:center">powiat</td>
						<td class="bottom-right-normal" style="font-size:9pt; text-align:center">gmina</td>
						<td class="bottom-right-normal" style="font-size:9pt; text-align:center">typ gm.</td>
						<td class="bottom-right-normal" style="font-size:9pt; text-align:center">związek jst</td>
						<td class="bottom-right-normal" style="font-size:9pt; text-align:center">typ zw.</td>
						<td class="right-bottom-mixed" style="font-size:9pt; text-align:center">funduszu celowego</td>
						<td class="bottom-right-normal" style="font-size:9pt; text-align:center">
              część <sup>1)</sup>
						</td>
						<td class="bottom-right-normal" style="font-size:9pt; text-align:center">dział</td>
						<td class="bottom-normal" style="font-size:9pt; text-align:center">rozdział</td>
					</tr>
					<tr>
						<td class="bottom-right-normal" style="text-align:center; font-size: 8pt">
							<xsl:value-of select="1"/>
						</td>
						<td class="bottom-right-normal" style="text-align:center; font-size: 8pt">
							<xsl:value-of select="2"/>
						</td>
						<td class="bottom-right-normal" style="text-align:center; font-size: 8pt">
							<xsl:value-of select="3"/>
						</td>
						<td class="bottom-right-normal" style="text-align:center; font-size: 8pt">
							<xsl:value-of select="4"/>
						</td>
						<td class="bottom-right-normal" style="text-align:center; font-size: 8pt">
							<xsl:value-of select="5"/>
						</td>
						<td class="bottom-right-normal" style="text-align:center; font-size: 8pt">
							<xsl:value-of select="6"/>
						</td>
						<td class="right-bottom-mixed" style="text-align:center; font-size: 8pt">
							<xsl:value-of select="7"/>
						</td>
						<td class="bottom-right-normal" style="text-align:center; font-size: 8pt">
							<xsl:value-of select="8"/>
						</td>
						<td class="bottom-right-normal" style="text-align:center; font-size: 8pt">
							<xsl:value-of select="9"/>
						</td>
						<td class="bottom-normal" style="text-align:center; font-size: 8pt">
							<xsl:value-of select="10"/>
						</td>
					</tr>
					<tr>
						<td class="right-normal" style="font-size:10pt; text-align:center">
							<xsl:choose>
								<xsl:when test="Jednostka/WK">
									<xsl:value-of select="Jednostka/WK"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="../../WK"/>
								</xsl:otherwise>
							</xsl:choose>
						</td>
						<td class="right-normal" style="font-size:10pt; text-align:center">
							<xsl:choose>
								<xsl:when test="Jednostka/PK">
									<xsl:value-of select="Jednostka/PK"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="../../PK"/>
								</xsl:otherwise>
							</xsl:choose>
						</td>
						<td class="right-normal" style="font-size:10pt; text-align:center">
							<xsl:choose>
								<xsl:when test="Jednostka/GK">
									<xsl:value-of select="Jednostka/GK"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="../../GK"/>
								</xsl:otherwise>
							</xsl:choose>
						</td>
						<td class="right-normal" style="font-size:10pt; text-align:center">
							<xsl:choose>
								<xsl:when test="Jednostka/GT">
									<xsl:value-of select="Jednostka/GT"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="../../GT"/>
								</xsl:otherwise>
							</xsl:choose>
						</td>
						<td style="font-size:10pt; text-align:center; border-right: 1px solid black">
							<xsl:choose>
								<xsl:when test="Jednostka/KodMSWiA">
									<xsl:value-of select="Jednostka/KodMSWiA"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:choose>
										<xsl:when test="../../KodMSWiA">
											<xsl:value-of select="../../KodMSWiA"/>
										</xsl:when>
										<xsl:otherwise>
											<xsl:value-of select="$nbsp"/>
										</xsl:otherwise>
									</xsl:choose>
								</xsl:otherwise>
							</xsl:choose>
						</td>
						<td style="font-size:10pt; text-align:center; border-right: 1px solid black">
							<xsl:value-of select="$nbsp"/>
						</td>
						<td style="font-size:10pt; text-align:center; border-right: 4px solid black">
							<xsl:choose>
								<xsl:when test="Naglowek/SymbolPozabudzetowy">
									<xsl:value-of select="Naglowek/SymbolPozabudzetowy"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="$nbsp"/>
								</xsl:otherwise>
							</xsl:choose>
						</td>
						<td style="font-size:10pt; text-align:center; border-right: 1px solid black">
							<xsl:value-of select="$nbsp"/>
						</td>
						<td style="font-size:10pt; text-align:center; border-right: 1px solid black">
							<xsl:value-of select="Naglowek/Dzial"/>
						</td>
						<td style="font-size:10pt; text-align:center">
							<xsl:value-of select="Naglowek/Rozdzial"/>
						</td>
					</tr>
				</tbody>
			</table>
			<div style="display: block; margin-bottom: 40px">
				<table cellpadding="0" cellspacing="0">
					<tbody>
						<tr>
							<td style="width: 450px">
								<div style="font-size: 10pt; font-weight: bold; margin-left: 5px">A.</div>
							</td>
							<td style="width: 120px">
								<!-- <div style="font-size: 9pt">strona 1</div> -->
							</td>
							<td style="width: 350px">
								<!-- <div style="font-size: 9pt">sprawozdania Rb-33, Dział <xsl:value-of select="Naglowek/Dzial"/>, Rozdział <xsl:value-of select="Naglowek/Rozdzial"/>, <xsl:value-of select="../../Nazwa"/>
												</div> -->
							</td>
						</tr>
					</tbody>
				</table>
				<table cellpadding="0" cellspacing="0" class="all-bold" style="margin-bottom: 10px">
					<tbody>
						<tr>
							<td rowspan="2" class="bottom-right-mixed" style="font-size: 10pt; text-align: center; width: 80px">Kod pozycji</td>
							<td rowspan="2" class="bottom-right-mixed" style="font-size: 10pt; text-align: center; width: 360px; min-width: 320px">Paragraf</td>
							<td colspan="2" class="bottom-normal" style="font-size: 10pt; text-align: center">Przychody</td>
						</tr>
						<tr>
							<td class="bottom-right-mixed" style="font-size: 10pt; text-align: center; width: 260px; min-width: 220px">plan</td>
							<td class="bottom-bold" style="font-size: 10pt; text-align: center; width: 260px; min-width: 220px">wykonanie</td>
						</tr>
						<tr>
							<td class="bottom-right-mixed" style="text-align:center; font-size: 8pt">
								<xsl:value-of select="11"/>
							</td>
							<td class="bottom-right-mixed" style="text-align:center; font-size: 8pt">
								<xsl:value-of select="12"/>
							</td>
							<td class="bottom-right-mixed" style="text-align:center; font-size: 8pt">
								<xsl:value-of select="13"/>
							</td>
							<td class="bottom-bold" style="text-align:center; font-size: 8pt">
								<xsl:value-of select="14"/>
							</td>
						</tr>
						<xsl:for-each select="PrzychodyPozycje/Pozycja">
							<tr>
								<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
									<xsl:value-of select="'G'"/>
								</td>
								<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
									<xsl:value-of select="concat(Paragraf, P4)"/>
								</td>
								<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; padding: 3px">
									<xsl:choose>
										<xsl:when test="P">
											<xsl:value-of select="format-number(P, '#&#160;##0,00')"/>
										</xsl:when>
										<xsl:otherwise>
											<xsl:value-of select="'0,00'"/>
										</xsl:otherwise>
									</xsl:choose>
								</td>
								<td class="bottom-normal" style="text-align: right; font-size: 8pt; padding: 3px">
									<xsl:choose>
										<xsl:when test="W">
											<xsl:value-of select="format-number(W, '#&#160;##0,00')"/>
										</xsl:when>
										<xsl:otherwise>
											<xsl:value-of select="'0,00'"/>
										</xsl:otherwise>
									</xsl:choose>
								</td>
							</tr>
						</xsl:for-each>
						<xsl:apply-templates select="PrzychodyPodsumowanie">
							<xsl:with-param name="SymPoz" select="Naglowek/SymbolPozabudzetowy"/>
							<xsl:with-param name="Dzial" select="Naglowek/Dzial"/>
							<xsl:with-param name="Rozdzial" select="Naglowek/Rozdzial"/>
						</xsl:apply-templates>
					</tbody>
				</table>
				<div style="margin-bottom: 20px">
					<div style="display: block; font-size: 7pt;margin-bottom:0">
						<sup>1)</sup> niepotrzebne skreślić
          </div>
					<div style="display: block; font-size: 7pt;margin-bottom:0">
						<sup>2)</sup> dotyczy jednostek samorządu terytorialnego i ich związków
          </div>
					<div style="display: block; font-size: 7pt">
						<sup>3)</sup> dotyczy państwowych funduszy celowych bez osobowości prawnej
          </div>
				</div>
				<table cellpadding="0" cellspacing="0">
					<tbody>
						<tr>
							<td style="width: 450px">
								<div style="font-size: 10pt; font-weight: bold; margin-left: 5px">B.</div>
							</td>
							<td style="width: 120px">
								<!-- <div style="font-size: 9pt">strona 2</div> -->
							</td>
							<td style="width: 350px">
								<!-- <div style="font-size: 9pt">sprawozdania Rb-33, Dział <xsl:value-of select="Naglowek/Dzial"/>, Rozdział <xsl:value-of select="Naglowek/Rozdzial"/>, <xsl:value-of select="../../Nazwa"/>
												</div> -->
							</td>
						</tr>
					</tbody>
				</table>
				<table cellpadding="0" cellspacing="0" class="all-bold" style="margin-bottom: 30px">
					<tbody>
						<tr>
							<td rowspan="2" class="bottom-right-mixed" style="font-size: 10pt; text-align: center; width: 80px">Kod pozycji</td>
							<td rowspan="2" class="bottom-right-mixed" style="font-size: 10pt; text-align: center; width: 360px; min-width: 320px">Paragraf</td>
							<td colspan="2" class="bottom-normal" style="font-size: 10pt; text-align: center">Koszty i inne obciążenia</td>
						</tr>
						<tr>
							<td class="bottom-right-mixed" style="font-size: 10pt; text-align: center; width: 260px; min-width: 220px">plan</td>
							<td class="bottom-bold" style="font-size: 10pt; text-align: center; width: 260px; min-width: 220px">wykonanie</td>
						</tr>
						<tr>
							<td class="bottom-right-mixed" style="text-align:center; font-size: 8pt">
								<xsl:value-of select="11"/>
							</td>
							<td class="bottom-right-mixed" style="text-align:center; font-size: 8pt">
								<xsl:value-of select="12"/>
							</td>
							<td class="bottom-right-mixed" style="text-align:center; font-size: 8pt">
								<xsl:value-of select="13"/>
							</td>
							<td class="bottom-bold" style="text-align:center; font-size: 8pt">
								<xsl:value-of select="14"/>
							</td>
						</tr>
						<xsl:for-each select="KosztyPozycje/Pozycja">
							<tr>
								<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
									<xsl:value-of select="'M'"/>
								</td>
								<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
									<xsl:value-of select="concat(Paragraf, P4)"/>
								</td>
								<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; padding: 3px">
									<xsl:choose>
										<xsl:when test="P">
											<xsl:value-of select="format-number(P, '#&#160;##0,00')"/>
										</xsl:when>
										<xsl:otherwise>
											<xsl:value-of select="'0,00'"/>
										</xsl:otherwise>
									</xsl:choose>
								</td>
								<td class="bottom-normal" style="text-align: right; font-size: 8pt; padding: 3px">
									<xsl:choose>
										<xsl:when test="W">
											<xsl:value-of select="format-number(W, '#&#160;##0,00')"/>
										</xsl:when>
										<xsl:otherwise>
											<xsl:value-of select="'0,00'"/>
										</xsl:otherwise>
									</xsl:choose>
								</td>
							</tr>
						</xsl:for-each>
						<xsl:apply-templates select="KosztyPodsumowanie">
							<xsl:with-param name="SymPoz" select="Naglowek/SymbolPozabudzetowy"/>
							<xsl:with-param name="Dzial" select="Naglowek/Dzial"/>
							<xsl:with-param name="Rozdzial" select="Naglowek/Rozdzial"/>
						</xsl:apply-templates>
					</tbody>
				</table>
				<table cellpadding="0" cellspacing="0">
					<tbody>
						<tr>
							<td style="width: 450px">
								<div style="font-size: 10pt; font-weight: bold; margin-left: 5px">C.</div>
							</td>
							<td style="width: 120px">
								<!-- <div style="font-size: 9pt">strona 3</div> -->
							</td>
							<td style="width: 350px">
								<!-- <div style="font-size: 9pt">sprawozdania Rb-33, Dział <xsl:value-of select="Naglowek/Dzial"/>, Rozdział <xsl:value-of select="Naglowek/Rozdzial"/>, <xsl:value-of select="../../Nazwa"/>
												</div> -->
							</td>
						</tr>
					</tbody>
				</table>
				<table cellpadding="0" cellspacing="0" class="all-bold" style="margin-bottom: 10px">
					<tbody>
						<tr>
							<td rowspan="2" class="bottom-right-mixed" style="font-size: 10pt; text-align: center; width: 80px">Kod pozycji</td>
							<td rowspan="2" class="bottom-right-mixed" style="font-size: 10pt; text-align: center; width: 90px">Symbol</td>
							<td rowspan="2" class="bottom-right-mixed" style="font-size: 10pt; text-align: center; width: 360px; min-width: 320px">Wyszczególnienie</td>
							<td colspan="2" class="bottom-normal" style="font-size: 10pt; text-align: center">Rozliczenie wyniku</td>
						</tr>
						<tr>
							<td class="bottom-right-mixed" style="font-size: 10pt; text-align: center; width: 260px; min-width: 220px">Stan na początek okresu sprawozdawczego</td>
							<td class="bottom-bold" style="font-size: 10pt; text-align: center; width: 260px; min-width: 220px">Stan na koniec okresu sprawozdawczego</td>
						</tr>
						<tr>
							<td class="bottom-right-mixed" style="text-align:center; font-size: 8pt">
								<xsl:value-of select="11"/>
							</td>
							<td class="bottom-right-mixed" style="text-align:center; font-size: 8pt">
								<xsl:value-of select="12"/>
							</td>
							<td class="bottom-right-mixed" style="text-align: center; font-size: 8pt">
								<xsl:value-of select="$nbsp"/>
							</td>
							<td class="bottom-right-mixed" style="text-align:center; font-size: 8pt">
								<xsl:value-of select="13"/>
							</td>
							<td class="bottom-bold" style="text-align:center; font-size: 8pt">
								<xsl:value-of select="14"/>
							</td>
						</tr>
						<xsl:call-template name="Rb-33_danePozycjeC">
							<xsl:with-param name="kod" select="'W'"/>
							<xsl:with-param name="symbol" select="'010'"/>
							<xsl:with-param name="wyszczeg" select="'Środki pieniężne (w tym środki w kasie)'"/>
						</xsl:call-template>
						<xsl:call-template name="Rb-33_danePozycjeC">
							<xsl:with-param name="kod" select="'W'"/>
							<xsl:with-param name="symbol" select="'020'"/>
							<xsl:with-param name="wyszczeg" select="'Należności netto 1)'"/>
						</xsl:call-template>
						<xsl:call-template name="Rb-33_danePozycjeC">
							<xsl:with-param name="kod" select="'W'"/>
							<xsl:with-param name="symbol" select="'021'"/>
							<xsl:with-param name="wyszczeg" select="'Kwota odpisu aktualizującego należności'"/>
						</xsl:call-template>
						<xsl:call-template name="Rb-33_danePozycjeC">
							<xsl:with-param name="kod" select="'W'"/>
							<xsl:with-param name="symbol" select="'022'"/>
							<xsl:with-param name="wyszczeg" select="'Kwota odsetek od należności niezapłaconych w terminie'"/>
						</xsl:call-template>
						<xsl:call-template name="Rb-33_danePozycjeC">
							<xsl:with-param name="kod" select="'W'"/>
							<xsl:with-param name="symbol" select="'030'"/>
							<xsl:with-param name="wyszczeg" select="'Pozostałe środki obrotowe'"/>
						</xsl:call-template>
						<xsl:call-template name="Rb-33_danePozycjeC">
							<xsl:with-param name="kod" select="'W'"/>
							<xsl:with-param name="symbol" select="'040'"/>
							<xsl:with-param name="wyszczeg" select="'Zobowiązania'"/>
						</xsl:call-template>
						<tr>
							<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
								<xsl:value-of select="'W'"/>
							</td>
							<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
								<xsl:value-of select="'070'"/>
							</td>
							<td class="bottom-right-normal" style="text-align: center; font-size: 9pt; font-weight: bold">
								<xsl:value-of select="'Stan środków obrotowych netto (W010+W020+W030-W040)'"/>
							</td>
							<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; padding: 3px">
								<xsl:choose>
									<xsl:when test="Stan/Pozycja[child::Kod = 'W' and child::Symbol = '070']/P">
										<xsl:value-of select="format-number(Stan/Pozycja[child::Kod = 'W' and child::Symbol = '070']/P, '#&#160;##0,00')"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="'0,00'"/>
									</xsl:otherwise>
								</xsl:choose>
							</td>
							<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; padding: 3px">
								<xsl:choose>
									<xsl:when test="Stan/Pozycja[child::Kod = 'W' and child::Symbol = '070']/K">
										<xsl:value-of select="format-number(Stan/Pozycja[child::Kod = 'W' and child::Symbol = '070']/K, '#&#160;##0,00')"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="'0,00'"/>
									</xsl:otherwise>
								</xsl:choose>
							</td>
						</tr>
					</tbody>
				</table>
				<div style="margin-bottom: 20px">
					<div style="display: block; font-size: 7pt">
						<sup>1)</sup> Kwota należności pomniejszona o odpis aktualizujący należności oraz odsetki od należności niezapłaconych w terminie
          </div>
				</div>
				<table cellpadding="0" cellspacing="0">
					<tbody>
						<tr>
							<td style="width: 450px">
								<div style="font-size: 10pt; font-weight: bold; margin-left: 5px; margin-bottom: 5px">D.</div>
							</td>
							<td style="width: 120px">
								<!-- <div style="font-size: 9pt">strona 4</div> -->
							</td>
							<td style="width: 350px">
								<!-- <div style="font-size: 9pt">sprawozdania Rb-33, Dział <xsl:value-of select="Naglowek/Dzial"/>, Rozdział <xsl:value-of select="Naglowek/Rozdzial"/>, <xsl:value-of select="../../Nazwa"/>
												</div> -->
							</td>
						</tr>
						<tr>
							<td>
								<div style="font-size: 9pt; font-weight: bold; margin-left: 5px">1. Należności</div>
							</td>
						</tr>
					</tbody>
				</table>
				<table cellpadding="0" cellspacing="0" class="all-bold" style="margin-bottom: 20px">
					<tbody>
						<tr>
							<td class="bottom-right-mixed" style="font-size: 10pt; text-align: center; width: 80px">Kod pozycji</td>
							<td class="bottom-right-mixed" style="font-size: 10pt; text-align: center; width: 300px; min-width: 300px">Paragraf</td>
							<td class="bottom-right-mixed" style="font-size: 10pt; text-align: center; width: 300px; min-width: 300px">Stan na początek okresu sprawozdawczego</td>
							<td class="bottom-bold" style="font-size: 10pt; text-align: center; width: 300px; min-width: 300px">Stan na koniec okresu sprawozdawczego</td>
						</tr>
						<tr>
							<td class="bottom-right-mixed" style="text-align:center; font-size: 8pt">
								<xsl:value-of select="11"/>
							</td>
							<td class="bottom-right-mixed" style="text-align:center; font-size: 8pt">
								<xsl:value-of select="12"/>
							</td>
							<td class="bottom-right-mixed" style="text-align:center; font-size: 8pt">
								<xsl:value-of select="13"/>
							</td>
							<td class="bottom-bold" style="text-align:center; font-size: 8pt">
								<xsl:value-of select="14"/>
							</td>
						</tr>
						<xsl:for-each select="NaleznosciPozycje/Pozycja">
							<tr>
								<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
									<xsl:value-of select="'X'"/>
								</td>
								<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
									<xsl:value-of select="concat(Paragraf, P4)"/>
								</td>
								<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; padding: 3px">
									<xsl:choose>
										<xsl:when test="P">
											<xsl:value-of select="format-number(P, '#&#160;##0,00')"/>
										</xsl:when>
										<xsl:otherwise>
											<xsl:value-of select="'0,00'"/>
										</xsl:otherwise>
									</xsl:choose>
								</td>
								<td class="bottom-normal" style="text-align: right; font-size: 8pt; padding: 3px">
									<xsl:choose>
										<xsl:when test="K">
											<xsl:value-of select="format-number(K, '#&#160;##0,00')"/>
										</xsl:when>
										<xsl:otherwise>
											<xsl:value-of select="'0,00'"/>
										</xsl:otherwise>
									</xsl:choose>
								</td>
							</tr>
						</xsl:for-each>
						<xsl:apply-templates select="NaleznosciPodsumowanie">
							<xsl:with-param name="SymPoz" select="Naglowek/SymbolPozabudzetowy"/>
							<xsl:with-param name="Dzial" select="Naglowek/Dzial"/>
							<xsl:with-param name="Rozdzial" select="Naglowek/Rozdzial"/>
						</xsl:apply-templates>
					</tbody>
				</table>
				<table cellpadding="0" cellspacing="0">
					<tbody>
						<tr>
							<td style="width: 450px">
								<div style="font-size: 9pt; font-weight: bold; margin-left: 5px">2. Zobowiązania</div>
							</td>
						</tr>
					</tbody>
				</table>
				<table cellpadding="0" cellspacing="0" class="all-bold" style="margin-bottom: 60px">
					<tbody>
						<tr>
							<td class="bottom-right-mixed" style="font-size: 10pt; text-align: center; width: 80px">Kod pozycji</td>
							<td class="bottom-right-mixed" style="font-size: 10pt; text-align: center; width: 300px; min-width: 300px">Paragraf</td>
							<td class="bottom-right-mixed" style="font-size: 10pt; text-align: center; width: 300px; min-width: 300px">Stan na początek okresu sprawozdawczego</td>
							<td class="bottom-bold" style="font-size: 10pt; text-align: center; width: 300px; min-width: 300px">Stan na koniec okresu sprawozdawczego</td>
						</tr>
						<tr>
							<td class="bottom-right-mixed" style="text-align:center; font-size: 8pt">
								<xsl:value-of select="11"/>
							</td>
							<td class="bottom-right-mixed" style="text-align:center; font-size: 8pt">
								<xsl:value-of select="12"/>
							</td>
							<td class="bottom-right-mixed" style="text-align:center; font-size: 8pt">
								<xsl:value-of select="13"/>
							</td>
							<td class="bottom-bold" style="text-align:center; font-size: 8pt">
								<xsl:value-of select="14"/>
							</td>
						</tr>
						<xsl:for-each select="ZobowiazaniaPozycje/Pozycja">
							<tr>
								<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
									<xsl:value-of select="'Y'"/>
								</td>
								<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
									<xsl:value-of select="concat(Paragraf, P4)"/>
								</td>
								<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; padding: 3px">
									<xsl:choose>
										<xsl:when test="P">
											<xsl:value-of select="format-number(P, '#&#160;##0,00')"/>
										</xsl:when>
										<xsl:otherwise>
											<xsl:value-of select="'0,00'"/>
										</xsl:otherwise>
									</xsl:choose>
								</td>
								<td class="bottom-normal" style="text-align: right; font-size: 8pt; padding: 3px">
									<xsl:choose>
										<xsl:when test="K">
											<xsl:value-of select="format-number(K, '#&#160;##0,00')"/>
										</xsl:when>
										<xsl:otherwise>
											<xsl:value-of select="'0,00'"/>
										</xsl:otherwise>
									</xsl:choose>
								</td>
							</tr>
						</xsl:for-each>
						<xsl:apply-templates select="ZobowiazaniaPodsumowanie">
							<xsl:with-param name="SymPoz" select="Naglowek/SymbolPozabudzetowy"/>
							<xsl:with-param name="Dzial" select="Naglowek/Dzial"/>
							<xsl:with-param name="Rozdzial" select="Naglowek/Rozdzial"/>
						</xsl:apply-templates>
					</tbody>
				</table>
				<table cellpadding="0" cellspacing="0" class="all-bold" style="margin-bottom: 20px; width: 100%">
					<tbody>
						<tr style="height: 30px" valign="top">
							<td style="font-size: 9pt; font-weight: bold; text-align:left; padding: 3px 10px; margin-left: 5px; margin-bottom: 25px">Wyjaśnienia do sprawozdania Rb-33</td>
						</tr>
						<tr style="min-height: 50px; height: 70px" valign="top">
							<td style="text-align: left; font-size: 8pt; padding: 3px 10px; border-width: 4px 0 0 0; border-style: solid; border-color: black">
								<xsl:value-of select="Naglowek/Uwagi"/>
							</td>
						</tr>
					</tbody>
				</table>
				<!-- ewentualne uwagi z pozycji -->
				<xsl:if test="PrzychodyPozycje/Pozycja[child::Uwagi] or PrzychodyPodsumowanie/Pozycja[child::Uwagi]">
					<table cellpadding="0" cellspacing="0" class="all-bold" style="margin-bottom: 20px; width: 100%">
						<tbody>
							<tr>
								<td colspan="4" style="text-align: center; font-size: 9pt; font-weight: bold; padding: 3px 10px">
									<div>Uwagi do części: "Przychody"</div>
								</td>
							</tr>
							<tr>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 4px 4px 0; width: 6%">Kod pozycji</td>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 4px 4px 0; width: 24%">Paragraf</td>
								<td colspan="2" style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 0 4px 0">Uwaga</td>
							</tr>
							<xsl:for-each select="PrzychodyPozycje/Pozycja[child::Uwagi]">
								<xsl:sort select="Paragraf"/>
								<tr>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="'G'"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="concat(Paragraf, P4)"/>
									</td>
									<td colspan="2" class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:value-of select="Uwagi"/>
									</td>
								</tr>
							</xsl:for-each>
							<xsl:if test="PrzychodyPodsumowanie/Pozycja[child::Kod = 'I' and child::Symbol = '110' and child::Uwagi]">
								<tr>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="PrzychodyPodsumowanie/Pozycja[child::Kod = 'I' and child::Symbol = '110']/Kod"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="'110 (Pokrycie amortyzacji)'"/>
									</td>
									<td colspan="2" class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:value-of select="PrzychodyPodsumowanie/Pozycja[child::Kod = 'I' and child::Symbol = '110']/Uwagi"/>
									</td>
								</tr>
							</xsl:if>
							<xsl:if test="PrzychodyPodsumowanie/Pozycja[child::Kod = 'K' and child::Symbol = '100' and child::Uwagi]">
								<tr>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="PrzychodyPodsumowanie/Pozycja[child::Kod = 'K' and child::Symbol = '100']/Kod"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="'100 (Inne zwiększenia)'"/>
									</td>
									<td colspan="2" class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:value-of select="PrzychodyPodsumowanie/Pozycja[child::Kod = 'K' and child::Symbol = '100']/Uwagi"/>
									</td>
								</tr>
							</xsl:if>
							<xsl:if test="PrzychodyPodsumowanie/Pozycja[child::Kod = 'H' and child::Uwagi]">
								<tr>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="PrzychodyPodsumowanie/Pozycja[child::Kod = 'H']/Kod"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="'Razem'"/>
									</td>
									<td colspan="2" class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:value-of select="PrzychodyPodsumowanie/Pozycja[child::Kod = 'H']/Uwagi"/>
									</td>
								</tr>
							</xsl:if>
							<xsl:if test="PrzychodyPodsumowanie/Pozycja[child::Kod = 'K' and child::Symbol = '110' and child::Uwagi]">
								<tr>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="PrzychodyPodsumowanie/Pozycja[child::Kod = 'K' and child::Symbol = '110']/Kod"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="'110 (Stan środków obrotowych netto na początku okresu sprawozdawczego)'"/>
									</td>
									<td colspan="2" class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:value-of select="PrzychodyPodsumowanie/Pozycja[child::Kod = 'K' and child::Symbol = '110']/Uwagi"/>
									</td>
								</tr>
							</xsl:if>
							<xsl:if test="PrzychodyPodsumowanie/Pozycja[child::Kod = 'L' and child::Symbol = '190' and child::Uwagi]">
								<tr>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="PrzychodyPodsumowanie/Pozycja[child::Kod = 'L' and child::Symbol = '190']/Kod"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="'190 Ogółem (H+K110)'"/>
									</td>
									<td colspan="2" class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:value-of select="PrzychodyPodsumowanie/Pozycja[child::Kod = 'L' and child::Symbol = '190']/Uwagi"/>
									</td>
								</tr>
							</xsl:if>
						</tbody>
					</table>
				</xsl:if>
				<xsl:if test="KosztyPozycje/Pozycja[child::Uwagi] or KosztyPodsumowanie/Pozycja[child::Uwagi]">
					<table cellpadding="0" cellspacing="0" class="all-bold" style="margin-bottom: 20px; width: 100%">
						<tbody>
							<tr>
								<td colspan="4" style="text-align: center; font-size: 9pt; font-weight: bold; padding: 3px 10px">
									<div>Uwagi do części: "Koszty"</div>
								</td>
							</tr>
							<tr>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 4px 4px 0; width: 6%">Kod pozycji</td>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 4px 4px 0; width: 24%">Paragraf</td>
								<td colspan="2" style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 0 4px 0">Uwaga</td>
							</tr>
							<xsl:for-each select="KosztyPozycje/Pozycja[child::Uwagi]">
								<xsl:sort select="Paragraf"/>
								<tr>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="'M'"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="concat(Paragraf, P4)"/>
									</td>
									<td colspan="2" class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:value-of select="Uwagi"/>
									</td>
								</tr>
							</xsl:for-each>
							<xsl:if test="KosztyPodsumowanie/Pozycja[child::Kod = 'I' and child::Symbol = '100' and child::Uwagi]">
								<tr>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="KosztyPodsumowanie/Pozycja[child::Kod = 'I' and child::Symbol = '100']/Kod"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="'100 (Odpisy amortyzacji)'"/>
									</td>
									<td colspan="2" class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:value-of select="KosztyPodsumowanie/Pozycja[child::Kod = 'I' and child::Symbol = '100']/Uwagi"/>
									</td>
								</tr>
							</xsl:if>
							<xsl:if test="KosztyPodsumowanie/Pozycja[child::Kod = 'P' and child::Symbol = '100' and child::Uwagi]">
								<tr>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="KosztyPodsumowanie/Pozycja[child::Kod = 'P' and child::Symbol = '100']/Kod"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="'100 (Inne zmniejszenia)'"/>
									</td>
									<td colspan="2" class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:value-of select="KosztyPodsumowanie/Pozycja[child::Kod = 'P' and child::Symbol = '100']/Uwagi"/>
									</td>
								</tr>
							</xsl:if>
							<xsl:if test="KosztyPodsumowanie/Pozycja[child::Kod = 'N' and child::Uwagi]">
								<tr>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="KosztyPodsumowanie/Pozycja[child::Kod = 'N']/Kod"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="'Razem'"/>
									</td>
									<td colspan="2" class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:value-of select="KosztyPodsumowanie/Pozycja[child::Kod = 'N']/Uwagi"/>
									</td>
								</tr>
							</xsl:if>
							<xsl:if test="KosztyPodsumowanie/Pozycja[child::Kod = 'P' and child::Symbol = '130' and child::Uwagi]">
								<tr>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="KosztyPodsumowanie/Pozycja[child::Kod = 'P' and child::Symbol = '130']/Kod"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="'130 (Stan środków obrotowych netto na koniec okresu sprawozdawczego)'"/>
									</td>
									<td colspan="2" class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:value-of select="KosztyPodsumowanie/Pozycja[child::Kod = 'P' and child::Symbol = '130']/Uwagi"/>
									</td>
								</tr>
							</xsl:if>
							<xsl:if test="KosztyPodsumowanie/Pozycja[child::Kod = 'S' and child::Symbol = '190' and child::Uwagi]">
								<tr>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="KosztyPodsumowanie/Pozycja[child::Kod = 'S' and child::Symbol = '190']/Kod"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="'190 Ogółem (N+P130)'"/>
									</td>
									<td colspan="2" class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:value-of select="KosztyPodsumowanie/Pozycja[child::Kod = 'S' and child::Symbol = '190']/Uwagi"/>
									</td>
								</tr>
							</xsl:if>
						</tbody>
					</table>
				</xsl:if>
				<xsl:if test="Stan/Pozycja[child::Uwagi]">
					<table cellpadding="0" cellspacing="0" class="all-bold" style="margin-bottom: 20px; width: 100%">
						<tbody>
							<tr>
								<td colspan="4" style="text-align: center; font-size: 9pt; font-weight: bold; padding: 3px 10px">
									<div>Uwagi do części: "Stan"</div>
								</td>
							</tr>
							<tr>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 4px 4px 0; width: 4%">Kod</td>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 4px 4px 0; width: 6%">Symbol</td>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 4px 4px 0; width: 30%">Wyszczególnienie</td>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 0 4px 0">Uwaga</td>
							</tr>
							<xsl:for-each select="Stan/Pozycja[child::Uwagi]">
								<xsl:sort select="Symbol"/>
								<tr>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="Kod"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="Symbol"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:choose>
											<xsl:when test="Symbol = '010'">Środki pieniężne (w tym środki w kasie)</xsl:when>
											<xsl:when test="Symbol = '020'">Należności netto</xsl:when>
											<xsl:when test="Symbol = '021'">Kwota odpisu aktualizującego należności</xsl:when>
											<xsl:when test="Symbol = '022'">Kwota odsetek od należności niezapłaconych w terminie</xsl:when>
											<xsl:when test="Symbol = '030'">Pozostałe środki obrotowe</xsl:when>
											<xsl:when test="Symbol = '040'">Zobowiązania</xsl:when>
											<xsl:when test="Symbol = '070'">Stan środków obrotowych netto (W010+W020+W030-W040)</xsl:when>
										</xsl:choose>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:value-of select="Uwagi"/>
									</td>
								</tr>
							</xsl:for-each>
						</tbody>
					</table>
				</xsl:if>
				<xsl:if test="NaleznosciPozycje/Pozycja[child::Uwagi] or NaleznosciPodsumowanie/Pozycja[child::Uwagi]">
					<table cellpadding="0" cellspacing="0" class="all-bold" style="margin-bottom: 20px; width: 100%">
						<tbody>
							<tr>
								<td colspan="4" style="text-align: center; font-size: 9pt; font-weight: bold; padding: 3px 10px">
									<div>Uwagi do części: "Należności"</div>
								</td>
							</tr>
							<tr>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 4px 4px 0; width: 6%">Kod</td>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 4px 4px 0; width: 24%">Paragraf</td>
								<td colspan="2" style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 0 4px 0">Uwaga</td>
							</tr>
							<xsl:for-each select="NaleznosciPozycje/Pozycja[child::Uwagi]">
								<xsl:sort select="Paragraf"/>
								<tr>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="'X'"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="concat(Paragraf, P4)"/>
									</td>
									<td colspan="2" class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:value-of select="Uwagi"/>
									</td>
								</tr>
							</xsl:for-each>
							<xsl:if test="NaleznosciPodsumowanie/Pozycja[child::Kod = 'X' and child::Symbol = '100' and child::Uwagi]">
								<tr>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="NaleznosciPodsumowanie/Pozycja[child::Kod = 'X' and child::Symbol = '100']/Kod"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="'100 (Inne)'"/>
									</td>
									<td colspan="2" class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:value-of select="NaleznosciPodsumowanie/Pozycja[child::Kod = 'X' and child::Symbol = '100']/Uwagi"/>
									</td>
								</tr>
							</xsl:if>
							<xsl:if test="NaleznosciPodsumowanie/Pozycja[child::Kod = 'X' and child::Symbol = '' and child::Uwagi]">
								<tr>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="NaleznosciPodsumowanie/Pozycja[child::Kod = 'X' and child::Symbol = '']/Kod"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="'Razem'"/>
									</td>
									<td colspan="2" class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:value-of select="NaleznosciPodsumowanie/Pozycja[child::Kod = 'X' and child::Symbol = '']/Uwagi"/>
									</td>
								</tr>
							</xsl:if>
						</tbody>
					</table>
				</xsl:if>
				<xsl:if test="ZobowiazaniaPozycje/Pozycja[child::Uwagi] or ZobowiazaniaPodsumowanie/Pozycja[child::Uwagi]">
					<table cellpadding="0" cellspacing="0" class="all-bold" style="margin-bottom: 20px; width: 100%">
						<tbody>
							<tr>
								<td colspan="4" style="text-align: center; font-size: 9pt; font-weight: bold; padding: 3px 10px">
									<div>Uwagi do części: "Zobowiązania"</div>
								</td>
							</tr>
							<tr>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 4px 4px 0; width: 6%">Kod</td>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 4px 4px 0; width: 24%">Paragraf</td>
								<td colspan="2" style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 0 4px 0">Uwaga</td>
							</tr>
							<xsl:for-each select="ZobowiazaniaPozycje/Pozycja[child::Uwagi]">
								<xsl:sort select="Paragraf"/>
								<tr>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="'Y'"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="concat(Paragraf, P4)"/>
									</td>
									<td colspan="2" class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:value-of select="Uwagi"/>
									</td>
								</tr>
							</xsl:for-each>
							<xsl:if test="ZobowiazaniaPodsumowanie/Pozycja[child::Kod = 'Y' and child::Symbol = '100' and child::Uwagi]">
								<tr>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="ZobowiazaniaPodsumowanie/Pozycja[child::Kod = 'Y' and child::Symbol = '100']/Kod"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="'100 (Inne)'"/>
									</td>
									<td colspan="2" class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:value-of select="ZobowiazaniaPodsumowanie/Pozycja[child::Kod = 'Y' and child::Symbol = '100']/Uwagi"/>
									</td>
								</tr>
							</xsl:if>
							<xsl:if test="ZobowiazaniaPodsumowanie/Pozycja[child::Kod = 'Y' and child::Symbol = '' and child::Uwagi]">
								<tr>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="ZobowiazaniaPodsumowanie/Pozycja[child::Kod = 'Y' and child::Symbol = '']/Kod"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="'Razem'"/>
									</td>
									<td colspan="2" class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:value-of select="ZobowiazaniaPodsumowanie/Pozycja[child::Kod = 'Y' and child::Symbol = '']/Uwagi"/>
									</td>
								</tr>
							</xsl:if>
						</tbody>
					</table>
				</xsl:if>
				<table cellpadding="0" cellspacing="0" style="margin-bottom: 0px; margin-top: 80px; width: 100%">
					<tbody>
						<tr>
							<td style="text-align:center; font-size: 8pt;" valign="bottom">
								<hr style="width: 80%"/>
								<div>Główny księgowy / Skarbnik</div>
							</td>
							<td style="text-align:center; font-size: 8pt;" valign="bottom">
								<hr style="width: 80%"/>
								<div>telefon</div>
							</td>
							<td style="text-align:center; font-size: 8pt;" valign="bottom">
								<div>
									<xsl:value-of select="Naglowek/DataSprawozdania"/>
								</div>
								<hr style="width: 80%"/>
								<div>rok m-c dzień</div>
							</td>
							<td style="text-align:center; font-size: 8pt;" valign="bottom">
								<hr style="width: 80%"/>
								<div>Kierownik jednostki / Przewodniczący Zarządu</div>
							</td>
						</tr>
					</tbody>
				</table>
			</div>
			<xsl:element name="a">
				<xsl:attribute name="href"><xsl:value-of select="concat('#Jed', $jedIndex)"/></xsl:attribute>
				<xsl:element name="style">
					<xsl:value-of select="'font-family: Verdana'"/>
				</xsl:element>
				<xsl:value-of select="'Powrót do listy sprawozdań jednostki'"/>
			</xsl:element>
		</xsl:element>
	</xsl:template>
	<!-- Rb-33 szablony pomocnicze -->
	<xsl:template match="Rb-33/PrzychodyPodsumowanie">
		<xsl:param name="SymPoz"/>
		<xsl:param name="Dzial"/>
		<xsl:param name="Rozdzial"/>
		<xsl:variable name="Paragrafy" select="parent::*/PrzychodyPozycje/Pozycja/Paragraf"/>
		<xsl:variable name="P4" select="parent::*/PrzychodyPozycje/Pozycja/P4"/>
		<tr>
			<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
				<xsl:value-of select="'I'"/>
			</td>
			<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
				<xsl:value-of select="'110 (Pokrycie amortyzacji)'"/>
			</td>
			<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; padding: 3px">
				<xsl:choose>
					<xsl:when test="Pozycja[child::Kod = 'I']/P">
						<xsl:value-of select="format-number(Pozycja[child::Kod = 'I']/P, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
			<td class="bottom-normal" style="text-align: right; font-size: 8pt; padding: 3px">
				<xsl:choose>
					<xsl:when test="Pozycja[child::Kod = 'I']/W">
						<xsl:value-of select="format-number(Pozycja[child::Kod = 'I']/W, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
		</tr>
		<tr>
			<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
				<xsl:value-of select="'K'"/>
			</td>
			<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
				<xsl:value-of select="'100 (Inne zwiększenia)'"/>
			</td>
			<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; padding: 3px">
				<xsl:choose>
					<xsl:when test="Pozycja[child::Kod = 'K' and child::Symbol='100']/P">
						<xsl:value-of select="format-number(Pozycja[child::Kod = 'K' and child::Symbol='100']/P, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
			<td class="bottom-normal" style="text-align: right; font-size: 8pt; padding: 3px">
				<xsl:choose>
					<xsl:when test="Pozycja[child::Kod = 'K' and child::Symbol='100']/W">
						<xsl:value-of select="format-number(Pozycja[child::Kod = 'K' and child::Symbol='100']/W, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
		</tr>
		<tr>
			<td class="bottom-right-normal" style="text-align: center; font-size: 8pt; font-weight: bold">
				<xsl:value-of select="'H'"/>
			</td>
			<td class="bottom-right-normal" style="text-align: center; font-size: 9pt; font-weight: bold">
				<xsl:value-of select="'RAZEM '"/>
				<xsl:call-template name="Rb-3x_SumaKontr">
					<xsl:with-param name="Paragrafy" select="$Paragrafy"/>
					<xsl:with-param name="P4" select="$P4"/>
					<xsl:with-param name="Licznosc" select="count(parent::*/PrzychodyPozycje/Pozycja)"/>
					<xsl:with-param name="Licznik" select="1"/>
					<xsl:with-param name="Wartosc" select="0"/>
					<xsl:with-param name="SymPoz" select="$SymPoz"/>
					<xsl:with-param name="Dzial" select="$Dzial"/>
					<xsl:with-param name="Rozdzial" select="$Rozdzial"/>
				</xsl:call-template>
			</td>
			<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; font-weight: bold; padding: 3px">
				<xsl:choose>
					<xsl:when test="Pozycja[child::Kod = 'H']/P">
						<xsl:value-of select="format-number(Pozycja[child::Kod = 'H']/P, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
			<td class="bottom-normal" style="text-align: right; font-size: 8pt; font-weight: bold; padding: 3px">
				<xsl:choose>
					<xsl:when test="Pozycja[child::Kod = 'H']/W">
						<xsl:value-of select="format-number(Pozycja[child::Kod = 'H']/W, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
		</tr>
		<tr>
			<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
				<xsl:value-of select="'K'"/>
			</td>
			<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
				<xsl:value-of select="'110 (Stan środków obrotowych netto na początku okresu sprawozdawczego)'"/>
			</td>
			<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; padding: 3px">
				<xsl:choose>
					<xsl:when test="Pozycja[child::Kod = 'K' and child::Symbol='110']/P">
						<xsl:value-of select="format-number(Pozycja[child::Kod = 'K' and child::Symbol='110']/P, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
			<td class="bottom-normal" style="text-align: right; font-size: 8pt; padding: 3px">
				<xsl:choose>
					<xsl:when test="Pozycja[child::Kod = 'K' and child::Symbol='110']/W">
						<xsl:value-of select="format-number(Pozycja[child::Kod = 'K' and child::Symbol='110']/W, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
		</tr>
		<tr>
			<td class="bottom-right-normal" style="text-align: center; font-size: 8pt; font-weight: bold">
				<xsl:value-of select="'L'"/>
			</td>
			<td class="bottom-right-normal" style="text-align: center; font-size: 8pt; font-weight: bold">
				<xsl:value-of select="'190 Ogółem (H+K110)'"/>
			</td>
			<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; font-weight: bold; padding: 3px">
				<xsl:choose>
					<xsl:when test="Pozycja[child::Kod = 'L']/P">
						<xsl:value-of select="format-number(Pozycja[child::Kod = 'L']/P, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
			<td class="bottom-normal" style="text-align: right; font-size: 8pt; font-weight: bold; padding: 3px">
				<xsl:choose>
					<xsl:when test="Pozycja[child::Kod = 'L']/W">
						<xsl:value-of select="format-number(Pozycja[child::Kod = 'L']/W, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
		</tr>
	</xsl:template>
	<xsl:template match="Rb-33/KosztyPodsumowanie">
		<xsl:param name="SymPoz"/>
		<xsl:param name="Dzial"/>
		<xsl:param name="Rozdzial"/>
		<xsl:variable name="Paragrafy" select="parent::*/KosztyPozycje/Pozycja/Paragraf"/>
		<xsl:variable name="P4" select="parent::*/KosztyPozycje/Pozycja/P4"/>
		<tr>
			<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
				<xsl:value-of select="'I'"/>
			</td>
			<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
				<xsl:value-of select="'100 (Odpisy amortyzacji)'"/>
			</td>
			<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; padding: 3px">
				<xsl:choose>
					<xsl:when test="Pozycja[child::Kod = 'I']/P">
						<xsl:value-of select="format-number(Pozycja[child::Kod = 'I']/P, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
			<td class="bottom-normal" style="text-align: right; font-size: 8pt; padding: 3px">
				<xsl:choose>
					<xsl:when test="Pozycja[child::Kod = 'I']/W">
						<xsl:value-of select="format-number(Pozycja[child::Kod = 'I']/W, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
		</tr>
		<tr>
			<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
				<xsl:value-of select="'P'"/>
			</td>
			<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
				<xsl:value-of select="'100 (Inne zmniejszenia)'"/>
			</td>
			<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; padding: 3px">
				<xsl:choose>
					<xsl:when test="Pozycja[child::Kod = 'P' and child::Symbol='100']/P">
						<xsl:value-of select="format-number(Pozycja[child::Kod = 'P' and child::Symbol='100']/P, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
			<td class="bottom-normal" style="text-align: right; font-size: 8pt; padding: 3px">
				<xsl:choose>
					<xsl:when test="Pozycja[child::Kod = 'P' and child::Symbol='100']/W">
						<xsl:value-of select="format-number(Pozycja[child::Kod = 'P' and child::Symbol='100']/W, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
		</tr>
		<tr>
			<td class="bottom-right-normal" style="text-align: center; font-size: 8pt; font-weight: bold">
				<xsl:value-of select="'N'"/>
			</td>
			<td class="bottom-right-normal" style="text-align: center; font-size: 9pt; font-weight: bold">
				<xsl:value-of select="'RAZEM '"/>
				<xsl:call-template name="Rb-3x_SumaKontr">
					<xsl:with-param name="Paragrafy" select="$Paragrafy"/>
					<xsl:with-param name="P4" select="$P4"/>
					<xsl:with-param name="Licznosc" select="count(parent::*/KosztyPozycje/Pozycja)"/>
					<xsl:with-param name="Licznik" select="1"/>
					<xsl:with-param name="Wartosc" select="0"/>
					<xsl:with-param name="SymPoz" select="$SymPoz"/>
					<xsl:with-param name="Dzial" select="$Dzial"/>
					<xsl:with-param name="Rozdzial" select="$Rozdzial"/>
				</xsl:call-template>
			</td>
			<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; font-weight: bold; padding: 3px">
				<xsl:choose>
					<xsl:when test="Pozycja[child::Kod = 'N']/P">
						<xsl:value-of select="format-number(Pozycja[child::Kod = 'N']/P, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
			<td class="bottom-normal" style="text-align: right; font-size: 8pt; font-weight: bold; padding: 3px">
				<xsl:choose>
					<xsl:when test="Pozycja[child::Kod = 'N']/W">
						<xsl:value-of select="format-number(Pozycja[child::Kod = 'N']/W, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
		</tr>
		<tr>
			<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
				<xsl:value-of select="'P'"/>
			</td>
			<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
				<xsl:value-of select="'130 Stan środków obrotowych netto na koniec okresu sprawozdawczego'"/>
			</td>
			<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; padding: 3px">
				<xsl:choose>
					<xsl:when test="Pozycja[child::Kod = 'P' and child::Symbol='130']/P">
						<xsl:value-of select="format-number(Pozycja[child::Kod = 'P' and child::Symbol='130']/P, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
			<td class="bottom-normal" style="text-align: right; font-size: 8pt; padding: 3px">
				<xsl:choose>
					<xsl:when test="Pozycja[child::Kod = 'P' and child::Symbol='130']/W">
						<xsl:value-of select="format-number(Pozycja[child::Kod = 'P' and child::Symbol='130']/W, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
		</tr>
		<tr>
			<td class="bottom-right-normal" style="text-align: center; font-size: 8pt; font-weight: bold">
				<xsl:value-of select="'S'"/>
			</td>
			<td class="bottom-right-normal" style="text-align: center; font-size: 8pt; font-weight: bold">
				<xsl:value-of select="'190 Ogółem (N+P130)'"/>
			</td>
			<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; font-weight: bold; padding: 3px">
				<xsl:choose>
					<xsl:when test="Pozycja[child::Kod = 'S']/P">
						<xsl:value-of select="format-number(Pozycja[child::Kod = 'S']/P, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
			<td class="bottom-normal" style="text-align: right; font-size: 8pt; font-weight: bold; padding: 3px">
				<xsl:choose>
					<xsl:when test="Pozycja[child::Kod = 'S']/W">
						<xsl:value-of select="format-number(Pozycja[child::Kod = 'S']/W, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
		</tr>
	</xsl:template>
	<xsl:template match="Rb-33/NaleznosciPodsumowanie">
		<xsl:param name="SymPoz"/>
		<xsl:param name="Dzial"/>
		<xsl:param name="Rozdzial"/>
		<xsl:variable name="Paragrafy" select="parent::*/NaleznosciPozycje/Pozycja/Paragraf"/>
		<xsl:variable name="P4" select="parent::*/NaleznosciPozycje/Pozycja/P4"/>
		<tr>
			<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
				<xsl:value-of select="'X'"/>
			</td>
			<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
				<xsl:value-of select="'100 (Inne)'"/>
			</td>
			<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; padding: 3px">
				<xsl:choose>
					<xsl:when test="Pozycja[child::Kod = 'X' and child::Symbol = '100']/P">
						<xsl:value-of select="format-number(Pozycja[child::Kod = 'X' and child::Symbol = '100']/P, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
			<td class="bottom-normal" style="text-align: right; font-size: 8pt; padding: 3px">
				<xsl:choose>
					<xsl:when test="Pozycja[child::Kod = 'X' and child::Symbol = '100']/K">
						<xsl:value-of select="format-number(Pozycja[child::Kod = 'X' and child::Symbol = '100']/K, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
		</tr>
		<tr>
			<td class="bottom-right-normal" style="text-align: center; font-size: 8pt; font-weight: bold">
				<xsl:value-of select="'X'"/>
			</td>
			<td class="bottom-right-normal" style="text-align: center; font-size: 9pt; font-weight: bold">
				<xsl:value-of select="'RAZEM '"/>
				<xsl:call-template name="Rb-3x_SumaKontr">
					<xsl:with-param name="Paragrafy" select="$Paragrafy"/>
					<xsl:with-param name="P4" select="$P4"/>
					<xsl:with-param name="Licznosc" select="count(parent::*/NaleznosciPozycje/Pozycja)"/>
					<xsl:with-param name="Licznik" select="1"/>
					<xsl:with-param name="Wartosc" select="0"/>
					<xsl:with-param name="SymPoz" select="$SymPoz"/>
					<xsl:with-param name="Dzial" select="$Dzial"/>
					<xsl:with-param name="Rozdzial" select="$Rozdzial"/>
				</xsl:call-template>
			</td>
			<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; font-weight: bold; padding: 3px">
				<xsl:choose>
					<xsl:when test="Pozycja[child::Kod = 'X' and child::Symbol = '']/P">
						<xsl:value-of select="format-number(Pozycja[child::Kod = 'X' and child::Symbol = '']/P, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
			<td class="bottom-normal" style="text-align: right; font-size: 8pt; font-weight: bold; padding: 3px">
				<xsl:choose>
					<xsl:when test="Pozycja[child::Kod = 'X' and child::Symbol = '']/K">
						<xsl:value-of select="format-number(Pozycja[child::Kod = 'X' and child::Symbol = '']/K, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
		</tr>
	</xsl:template>
	<xsl:template match="Rb-33/ZobowiazaniaPodsumowanie">
		<xsl:param name="SymPoz"/>
		<xsl:param name="Dzial"/>
		<xsl:param name="Rozdzial"/>
		<xsl:variable name="Paragrafy" select="parent::*/ZobowiazaniaPozycje/Pozycja/Paragraf"/>
		<xsl:variable name="P4" select="parent::*/ZobowiazaniaPozycje/Pozycja/P4"/>
		<tr>
			<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
				<xsl:value-of select="'Y'"/>
			</td>
			<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
				<xsl:value-of select="'100 (Inne)'"/>
			</td>
			<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; padding: 3px">
				<xsl:choose>
					<xsl:when test="Pozycja[child::Kod = 'Y' and child::Symbol = '100']/P">
						<xsl:value-of select="format-number(Pozycja[child::Kod = 'Y' and child::Symbol = '100']/P, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
			<td class="bottom-normal" style="text-align: right; font-size: 8pt; padding: 3px">
				<xsl:choose>
					<xsl:when test="Pozycja[child::Kod = 'Y' and child::Symbol = '100']/K">
						<xsl:value-of select="format-number(Pozycja[child::Kod = 'Y' and child::Symbol = '100']/K, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
		</tr>
		<tr>
			<td class="bottom-right-normal" style="text-align: center; font-size: 8pt; font-weight: bold">
				<xsl:value-of select="'Y'"/>
			</td>
			<td class="bottom-right-normal" style="text-align: center; font-size: 9pt; font-weight: bold">
				<xsl:value-of select="'RAZEM '"/>
				<xsl:call-template name="Rb-3x_SumaKontr">
					<xsl:with-param name="Paragrafy" select="$Paragrafy"/>
					<xsl:with-param name="P4" select="$P4"/>
					<xsl:with-param name="Licznosc" select="count(parent::*/ZobowiazaniaPozycje/Pozycja)"/>
					<xsl:with-param name="Licznik" select="1"/>
					<xsl:with-param name="Wartosc" select="0"/>
					<xsl:with-param name="SymPoz" select="$SymPoz"/>
					<xsl:with-param name="Dzial" select="$Dzial"/>
					<xsl:with-param name="Rozdzial" select="$Rozdzial"/>
				</xsl:call-template>
			</td>
			<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; font-weight: bold; padding: 3px">
				<xsl:choose>
					<xsl:when test="Pozycja[child::Kod = 'Y' and child::Symbol = '']/P">
						<xsl:value-of select="format-number(Pozycja[child::Kod = 'Y' and child::Symbol = '']/P, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
			<td class="bottom-normal" style="text-align: right; font-size: 8pt; font-weight: bold; padding: 3px">
				<xsl:choose>
					<xsl:when test="Pozycja[child::Kod = 'Y' and child::Symbol = '']/K">
						<xsl:value-of select="format-number(Pozycja[child::Kod = 'Y' and child::Symbol = '']/K, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
		</tr>
	</xsl:template>
	<xsl:template name="Rb-33_danePozycjeC">
		<xsl:param name="kod"/>
		<xsl:param name="symbol"/>
		<xsl:param name="wyszczeg"/>
		<xsl:param name="ostWiersz" select="false()"/>
		<tr>
			<xsl:element name="td">
				<xsl:attribute name="style"><xsl:value-of select="'text-align: center; font-size: 8pt'"/></xsl:attribute>
				<xsl:attribute name="class"><xsl:choose><xsl:when test="$ostWiersz = false()"><xsl:value-of select="'bottom-right-normal'"/></xsl:when><xsl:otherwise><xsl:value-of select="'right-normal'"/></xsl:otherwise></xsl:choose></xsl:attribute>
				<xsl:value-of select="$kod"/>
			</xsl:element>
			<xsl:element name="td">
				<xsl:attribute name="style"><xsl:value-of select="'text-align: center; font-size: 8pt'"/></xsl:attribute>
				<xsl:attribute name="class"><xsl:choose><xsl:when test="$ostWiersz = false()"><xsl:value-of select="'bottom-right-normal'"/></xsl:when><xsl:otherwise><xsl:value-of select="'right-normal'"/></xsl:otherwise></xsl:choose></xsl:attribute>
				<xsl:value-of select="$symbol"/>
			</xsl:element>
			<xsl:element name="td">
				<xsl:attribute name="style"><xsl:value-of select="'text-align: left; font-size: 8pt; padding: 3px'"/></xsl:attribute>
				<xsl:attribute name="class"><xsl:choose><xsl:when test="$ostWiersz = false()"><xsl:value-of select="'bottom-right-normal'"/></xsl:when><xsl:otherwise><xsl:value-of select="'right-normal'"/></xsl:otherwise></xsl:choose></xsl:attribute>
				<xsl:value-of select="$wyszczeg"/>
			</xsl:element>
			<xsl:element name="td">
				<xsl:attribute name="style"><xsl:value-of select="'text-align: right; font-size: 8pt; padding: 3px'"/></xsl:attribute>
				<xsl:attribute name="class"><xsl:choose><xsl:when test="$ostWiersz = false()"><xsl:value-of select="'bottom-right-normal'"/></xsl:when><xsl:otherwise><xsl:value-of select="'right-normal'"/></xsl:otherwise></xsl:choose></xsl:attribute>
				<xsl:choose>
					<xsl:when test="Stan/Pozycja[child::Kod = $kod and child::Symbol = $symbol]/P">
						<xsl:value-of select="format-number(Stan/Pozycja[child::Kod = $kod and child::Symbol = $symbol]/P, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:element>
			<xsl:element name="td">
				<xsl:attribute name="style"><xsl:value-of select="'text-align: right; font-size: 8pt; padding: 3px'"/></xsl:attribute>
				<xsl:if test="$ostWiersz = false()">
					<xsl:attribute name="class"><xsl:value-of select="'bottom-normal'"/></xsl:attribute>
				</xsl:if>
				<xsl:choose>
					<xsl:when test="Stan/Pozycja[child::Kod = $kod and child::Symbol = $symbol]/K">
						<xsl:value-of select="format-number(Stan/Pozycja[child::Kod = $kod and child::Symbol = $symbol]/K, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:element>
		</tr>
	</xsl:template>
	<!-- Rb-34 -->
	<xsl:template match="Rb-34">
		<xsl:param name="jedIndex"/>
		<xsl:param name="sprIndex"/>
		<xsl:element name="div">
			<xsl:attribute name="Id"><xsl:value-of select="concat('Jed', $jedIndex, 'Wer', $sprIndex)"/></xsl:attribute>
			<xsl:attribute name="style"><xsl:value-of select="'display: block; margin-bottom: 40px'"/></xsl:attribute>
			<div style="font-size: 12pt; font-weight: bold; margin-left: 5px; margin-bottom: 10px">
        Sprawozdanie Rb-34:
        <xsl:choose>
					<xsl:when test="Naglowek/Wersja = 0">
						<xsl:value-of select="'wersja pierwotna'"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="concat('korekta nr ', Naglowek/Wersja)"/>
					</xsl:otherwise>
				</xsl:choose>
				<xsl:call-template name="SprNaglowekInfo"/>
			</div>
			<table cellpadding="0" cellspacing="0" class="all-bold" style="margin-bottom: 30px">
				<tbody>
					<tr style="height: 18px">
						<td colspan="8" class="bottom-bold" style="font-size: 10pt;">MINISTERSTWO FINANSÓW, ul. Świętokrzyska 12, 00-916 Warszawa</td>
					</tr>
					<tr style="height: 127px">
						<td colspan="4" class="bottom-bold" style="width:300px">
							<table cellpadding="0" cellspacing="0" style="border-collapse: collapse; height" width="100%">
								<tbody>
									<tr style="height: 80px">
										<td style="text-align: left; font-size: 9pt; margin:1px 1px 0 0; padding:0" valign="top">
                      Nazwa i adres jednostki sprawozdawczej
                    </td>
									</tr>
									<tr>
										<td class="bottom-normal" style="text-align: center; font-size: 9pt" valign="bottom">
											<!-- popr. nr I.8 -->
											<div style="display: block;margin: 0 20px">
												<xsl:choose>
													<xsl:when test="Jednostka/Nazwa">
														<xsl:value-of select="Jednostka/Nazwa"/>
													</xsl:when>
													<xsl:otherwise>
														<xsl:value-of select="../../Nazwa"/>
													</xsl:otherwise>
												</xsl:choose>
											</div>
										</td>
									</tr>
									<tr style="height: 23px">
										<td style="text-align: left; font-size: 9pt; margin:1px 1px 0 0; padding:0;" valign="top">
                      Numer identyfikacyjny REGON
                    </td>
									</tr>
									<tr>
										<td style="text-align: center; font-size: 9pt; font-weight: bold; margin:1px 1px 0 0; padding:0" valign="baseline">
											<xsl:choose>
												<xsl:when test="Jednostka/Regon">
													<xsl:value-of select="Jednostka/Regon"/>
												</xsl:when>
												<xsl:otherwise>
													<xsl:value-of select="../../Regon"/>
												</xsl:otherwise>
											</xsl:choose>
										</td>
									</tr>
								</tbody>
							</table>
						</td>
						<td colspan="3" class="notop-bold" valign="top" style="width: 400px">
							<div style="font-weight: bold; text-align: center; font-size: 11pt; margin-bottom: 5px">Rb-34 kwartalne sprawozdanie z wykonania planów finansowych dochodów własnych jednostek budżetowych i wydatków nimi sfinansowanych</div>
							<div style="vertical-align: bottom; text-align: center; font-size: 9pt; margin-top: 80px">
								<xsl:call-template name="NaglowekSprOkres"/>
							</div>
						</td>
						<td class="bottom-bold" style="text-align: left; font-size: 9pt; margin:1px 1px 0 0; padding:0; width: 300px" valign="top">
							<div style="margin-bottom:5px">Adresat:</div>
							<!-- popr. nr I.9 -->
							<div style="text-align:center; margin-bottom: 15px;">
								<!-- <xsl:value-of select="'Regionalna Izba Obrachunkowa w Katowicach'"/> -->
							</div>
							<div style="text-align:center;">
								<!-- <xsl:value-of select="'wersja robocza'"/> -->
							</div>
						</td>
					</tr>
					<tr style="height: 54px">
						<td rowspan="2" colspan="7" class="bottom-right-bold" style="font-size: 9pt">
							<!-- popr. nr I.10 -->
							<div style="margin-bottom: 1px">
								<xsl:value-of select="'Nazwa województwa '"/>
								<sup>1) 2)</sup>
								<!-- <xsl:if test="../../Typ = 'W'">
									<span style="margin-left: 10px">
										<b>
											<xsl:value-of select="../../Nazwa"/>
										</b>
									</span>
								</xsl:if> -->
							</div>
							<div style="margin-bottom: 1px">
								<xsl:value-of select="'Nazwa powiatu / związku '"/>
								<sup>1) 2)</sup>
								<!-- <xsl:if test="../../Typ = 'P'">
									<span style="margin-left: 10px">
										<b>
											<xsl:value-of select="../../Nazwa"/>
										</b>
									</span>
								</xsl:if> -->
							</div>
							<div>
								<xsl:value-of select="'Nazwa gminy / związku '"/>
								<sup>1) 2)</sup>
								<!-- <xsl:if test="../../Typ = 'G'">
									<span style="margin-left: 10px">
										<b>
											<xsl:value-of select="../../Nazwa"/>
										</b>
									</span>
								</xsl:if> -->
							</div>
						</td>
						<td class="bottom-bold" style="font-size:9pt; text-align:center">Przed wypełnieniem przeczytać instrukcję</td>
					</tr>
					<tr>
						<td class="bottom-bold" style="font-size:9pt; text-align:center">Wysyłać bez pisma przewodniego</td>
					</tr>
					<tr>
						<td colspan="8" class="bottom-normal" style="font-size:10pt; text-align:center">Symbole</td>
					</tr>
					<tr>
						<td class="bottom-right-normal" style="font-size:9pt; text-align:center">woj.</td>
						<td class="bottom-right-normal" style="font-size:9pt; text-align:center">powiat</td>
						<td class="bottom-right-normal" style="font-size:9pt; text-align:center">gmina</td>
						<td class="bottom-right-normal" style="font-size:9pt; text-align:center">typ gm.</td>
						<td class="bottom-right-normal" style="font-size:9pt; text-align:center">związek jst</td>
						<td class="bottom-right-normal" style="font-size:9pt; text-align:center">typ zw.</td>
						<td class="bottom-right-normal" style="font-size:9pt; text-align:center">
              część <sup>3)</sup>
						</td>
						<td class="bottom-normal" style="font-size:9pt; text-align:center">
              symbol identyfikujący źródło powstania dochodów <sup>4)</sup>
						</td>
					</tr>
					<tr>
						<td class="bottom-right-normal" style="text-align:center; font-size: 8pt">
							<xsl:value-of select="1"/>
						</td>
						<td class="bottom-right-normal" style="text-align:center; font-size: 8pt">
							<xsl:value-of select="2"/>
						</td>
						<td class="bottom-right-normal" style="text-align:center; font-size: 8pt">
							<xsl:value-of select="3"/>
						</td>
						<td class="bottom-right-normal" style="text-align:center; font-size: 8pt">
							<xsl:value-of select="4"/>
						</td>
						<td class="bottom-right-normal" style="text-align:center; font-size: 8pt">
							<xsl:value-of select="5"/>
						</td>
						<td class="bottom-right-normal" style="text-align:center; font-size: 8pt">
							<xsl:value-of select="6"/>
						</td>
						<td class="bottom-right-normal" style="text-align:center; font-size: 8pt">
							<xsl:value-of select="7"/>
						</td>
						<td class="bottom-normal" style="text-align:center; font-size: 8pt">
							<xsl:value-of select="8"/>
						</td>
					</tr>
					<tr>
						<td class="right-normal" style="font-size:10pt; text-align:center">
							<xsl:choose>
								<xsl:when test="Jednostka/WK">
									<xsl:value-of select="Jednostka/WK"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="../../WK"/>
								</xsl:otherwise>
							</xsl:choose>
						</td>
						<td class="right-normal" style="font-size:10pt; text-align:center">
							<xsl:choose>
								<xsl:when test="Jednostka/PK">
									<xsl:value-of select="Jednostka/PK"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="../../PK"/>
								</xsl:otherwise>
							</xsl:choose>
						</td>
						<td class="right-normal" style="font-size:10pt; text-align:center">
							<xsl:choose>
								<xsl:when test="Jednostka/GK">
									<xsl:value-of select="Jednostka/GK"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="../../GK"/>
								</xsl:otherwise>
							</xsl:choose>
						</td>
						<td class="right-normal" style="font-size:10pt; text-align:center">
							<xsl:choose>
								<xsl:when test="Jednostka/GT">
									<xsl:value-of select="Jednostka/GT"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="../../GT"/>
								</xsl:otherwise>
							</xsl:choose>
						</td>
						<td style="font-size:10pt; text-align:center; border-right: 1px solid black">
							<xsl:choose>
								<xsl:when test="Jednostka/KodMSWiA">
									<xsl:value-of select="Jednostka/KodMSWiA"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:choose>
										<xsl:when test="../../KodMSWiA">
											<xsl:value-of select="../../KodMSWiA"/>
										</xsl:when>
										<xsl:otherwise>
											<xsl:value-of select="$nbsp"/>
										</xsl:otherwise>
									</xsl:choose>
								</xsl:otherwise>
							</xsl:choose>
						</td>
						<td style="font-size:10pt; text-align:center; border-right: 1px solid black">
							<xsl:value-of select="$nbsp"/>
						</td>
						<td style="font-size:10pt; text-align:center; border-right: 1px solid black">
							<xsl:value-of select="$nbsp"/>
						</td>
						<td style="font-size:10pt; text-align:center">
							<xsl:value-of select="$nbsp"/>
						</td>
					</tr>
				</tbody>
			</table>
			<div style="display: block; margin-bottom: 40px">
				<table cellpadding="0" cellspacing="0">
					<tbody>
						<tr>
							<td style="width: 450px">
								<div style="font-size: 10pt; font-weight: bold; margin-left: 5px">A.</div>
							</td>
							<td style="width: 120px">
								<!-- <div style="font-size: 9pt">strona 1</div> -->
							</td>
							<td style="width: 350px">
								<!-- <div style="font-size: 9pt">sprawozdania Rb-34, Dział <xsl:value-of select="Naglowek/Dzial"/>, Rozdział <xsl:value-of select="Naglowek/Rozdzial"/>, <xsl:value-of select="../../Nazwa"/>
								</div> -->
							</td>
						</tr>
					</tbody>
				</table>
				<table cellpadding="0" cellspacing="0" class="all-bold" style="margin-bottom: 10px">
					<tbody>
						<tr>
							<td rowspan="2" class="bottom-right-mixed" style="font-size: 10pt; text-align: center; width: 80px">Kod pozycji</td>
							<td rowspan="2" class="bottom-right-mixed" style="font-size: 10pt; text-align: center; width: 120px">Dział</td>
							<td rowspan="2" class="bottom-right-mixed" style="font-size: 10pt; text-align: center; width: 120px">Rozdział</td>
							<td rowspan="2" class="bottom-right-mixed" style="font-size: 10pt; text-align: center; width: 120px">Paragraf</td>
							<td colspan="2" class="bottom-normal" style="font-size: 10pt; text-align: center">Dochody</td>
						</tr>
						<tr>
							<td class="bottom-right-mixed" style="font-size: 10pt; text-align: center; width: 260px; min-width: 220px">plan</td>
							<td class="bottom-bold" style="font-size: 10pt; text-align: center; width: 260px; min-width: 220px">wykonanie</td>
						</tr>
						<tr>
							<td class="bottom-right-mixed" style="text-align:center; font-size: 8pt">
								<xsl:value-of select="9"/>
							</td>
							<td class="bottom-right-mixed" style="text-align:center; font-size: 8pt">
								<xsl:value-of select="10"/>
							</td>
							<td class="bottom-right-mixed" style="text-align:center; font-size: 8pt">
								<xsl:value-of select="11"/>
							</td>
							<td class="bottom-right-mixed" style="text-align:center; font-size: 8pt">
								<xsl:value-of select="12"/>
							</td>
							<td class="bottom-right-mixed" style="text-align:center; font-size: 8pt">
								<xsl:value-of select="13"/>
							</td>
							<td class="bottom-bold" style="text-align:center; font-size: 8pt">
								<xsl:value-of select="14"/>
							</td>
						</tr>
						<xsl:for-each select="PrzychodyPozycje/Pozycja">
							<tr>
								<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
									<xsl:value-of select="'G'"/>
								</td>
								<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
									<xsl:value-of select="../.././Naglowek/Dzial"/>
								</td>
								<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
									<xsl:value-of select="../.././Naglowek/Rozdzial"/>
								</td>
								<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
									<xsl:value-of select="concat(Paragraf, P4)"/>
								</td>
								<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; padding: 3px">
									<xsl:choose>
										<xsl:when test="P">
											<xsl:value-of select="format-number(P, '#&#160;##0,00')"/>
										</xsl:when>
										<xsl:otherwise>
											<xsl:value-of select="'0,00'"/>
										</xsl:otherwise>
									</xsl:choose>
								</td>
								<td class="bottom-normal" style="text-align: right; font-size: 8pt; padding: 3px">
									<xsl:choose>
										<xsl:when test="W">
											<xsl:value-of select="format-number(W, '#&#160;##0,00')"/>
										</xsl:when>
										<xsl:otherwise>
											<xsl:value-of select="'0,00'"/>
										</xsl:otherwise>
									</xsl:choose>
								</td>
							</tr>
						</xsl:for-each>
						<xsl:apply-templates select="PrzychodyPodsumowanie">
							<xsl:with-param name="Dzial" select="Naglowek/Dzial"/>
							<xsl:with-param name="Rozdzial" select="Naglowek/Rozdzial"/>
						</xsl:apply-templates>
					</tbody>
				</table>
				<div style="margin-bottom: 20px">
					<div style="display: block; font-size: 7pt;margin-bottom:0">
						<sup>1)</sup> niepotrzebne skreślić
          </div>
					<div style="display: block; font-size: 7pt;margin-bottom:0">
						<sup>2)</sup> dotyczy jednostek samorządu terytorialnego i ich związków
          </div>
					<div style="display: block; font-size: 7pt;margin-bottom:0">
						<sup>3)</sup> dotyczy państwowych jednostek budżetowych
          </div>
					<div style="display: block; font-size: 7pt">
						<sup>4)</sup> nie dotyczy jednostek samorządu terytorialnego
          </div>
				</div>
				<table cellpadding="0" cellspacing="0">
					<tbody>
						<tr>
							<td style="width: 450px">
								<div style="font-size: 10pt; font-weight: bold; margin-left: 5px">B.</div>
							</td>
							<td style="width: 120px">
								<!-- <div style="font-size: 9pt">strona 2</div> -->
							</td>
							<td style="width: 350px">
								<!-- <div style="font-size: 9pt">sprawozdania Rb-34, Dział <xsl:value-of select="Naglowek/Dzial"/>, Rozdział <xsl:value-of select="Naglowek/Rozdzial"/>, <xsl:value-of select="../../Nazwa"/>
								</div> -->
							</td>
						</tr>
					</tbody>
				</table>
				<table cellpadding="0" cellspacing="0" class="all-bold" style="margin-bottom: 30px">
					<tbody>
						<tr>
							<td rowspan="2" class="bottom-right-mixed" style="font-size: 10pt; text-align: center; width: 80px">Kod pozycji</td>
							<td rowspan="2" class="bottom-right-mixed" style="font-size: 10pt; text-align: center; width: 120px">Dział</td>
							<td rowspan="2" class="bottom-right-mixed" style="font-size: 10pt; text-align: center; width: 120px">Rozdział</td>
							<td rowspan="2" class="bottom-right-mixed" style="font-size: 10pt; text-align: center; width: 120px">Paragraf</td>
							<td colspan="2" class="bottom-normal" style="font-size: 10pt; text-align: center">Wydatki</td>
						</tr>
						<tr>
							<td class="bottom-right-mixed" style="font-size: 10pt; text-align: center; width: 260px; min-width: 220px">plan</td>
							<td class="bottom-bold" style="font-size: 10pt; text-align: center; width: 260px; min-width: 220px">wykonanie</td>
						</tr>
						<tr>
							<td class="bottom-right-mixed" style="text-align:center; font-size: 8pt">
								<xsl:value-of select="9"/>
							</td>
							<td class="bottom-right-mixed" style="text-align:center; font-size: 8pt">
								<xsl:value-of select="10"/>
							</td>
							<td class="bottom-right-mixed" style="text-align:center; font-size: 8pt">
								<xsl:value-of select="11"/>
							</td>
							<td class="bottom-right-mixed" style="text-align:center; font-size: 8pt">
								<xsl:value-of select="12"/>
							</td>
							<td class="bottom-right-mixed" style="text-align:center; font-size: 8pt">
								<xsl:value-of select="13"/>
							</td>
							<td class="bottom-bold" style="text-align:center; font-size: 8pt">
								<xsl:value-of select="14"/>
							</td>
						</tr>
						<xsl:for-each select="KosztyPozycje/Pozycja">
							<tr>
								<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
									<xsl:value-of select="'M'"/>
								</td>
								<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
									<xsl:value-of select="../.././Naglowek/Dzial"/>
								</td>
								<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
									<xsl:value-of select="../.././Naglowek/Rozdzial"/>
								</td>
								<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
									<xsl:value-of select="concat(Paragraf, P4)"/>
								</td>
								<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; padding: 3px">
									<xsl:choose>
										<xsl:when test="P">
											<xsl:value-of select="format-number(P, '#&#160;##0,00')"/>
										</xsl:when>
										<xsl:otherwise>
											<xsl:value-of select="'0,00'"/>
										</xsl:otherwise>
									</xsl:choose>
								</td>
								<td class="bottom-normal" style="text-align: right; font-size: 8pt; padding: 3px">
									<xsl:choose>
										<xsl:when test="W">
											<xsl:value-of select="format-number(W, '#&#160;##0,00')"/>
										</xsl:when>
										<xsl:otherwise>
											<xsl:value-of select="'0,00'"/>
										</xsl:otherwise>
									</xsl:choose>
								</td>
							</tr>
						</xsl:for-each>
						<xsl:apply-templates select="KosztyPodsumowanie">
							<xsl:with-param name="Dzial" select="Naglowek/Dzial"/>
							<xsl:with-param name="Rozdzial" select="Naglowek/Rozdzial"/>
						</xsl:apply-templates>
					</tbody>
				</table>
				<table cellpadding="0" cellspacing="0">
					<tbody>
						<tr>
							<td style="width: 450px">
								<div style="font-size: 10pt; font-weight: bold; margin-left: 5px">C.</div>
							</td>
							<td style="width: 120px">
								<!-- <div style="font-size: 9pt">strona 3</div> -->
							</td>
							<td style="width: 350px">
								<!-- <div style="font-size: 9pt">sprawozdania Rb-34, Dział <xsl:value-of select="Naglowek/Dzial"/>, Rozdział <xsl:value-of select="Naglowek/Rozdzial"/>, <xsl:value-of select="../../Nazwa"/>
								</div> -->
							</td>
						</tr>
					</tbody>
				</table>
				<table cellpadding="0" cellspacing="0" class="all-bold" style="margin-bottom: 10px">
					<tbody>
						<tr>
							<td class="bottom-right-mixed" style="font-size: 10pt; text-align: center; width: 80px">Kod pozycji</td>
							<td class="bottom-right-mixed" style="font-size: 10pt; text-align: center; width: 90px">Symbol</td>
							<td class="bottom-right-mixed" style="font-size: 10pt; text-align: center; width: 360px; min-width: 320px">Wyszczególnienie</td>
							<td class="bottom-right-mixed" style="font-size: 10pt; text-align: center; width: 260px; min-width: 220px">Stan na początek okresu sprawozdawczego</td>
							<td class="bottom-bold" style="font-size: 10pt; text-align: center; width: 260px; min-width: 220px">Stan na koniec okresu sprawozdawczego</td>
						</tr>
						<tr>
							<td class="bottom-right-mixed" style="text-align:center; font-size: 8pt">
								<xsl:value-of select="11"/>
							</td>
							<td class="bottom-right-mixed" style="text-align:center; font-size: 8pt">
								<xsl:value-of select="12"/>
							</td>
							<td class="bottom-right-mixed" style="text-align: center; font-size: 8pt">
								<xsl:value-of select="$nbsp"/>
							</td>
							<td class="bottom-right-mixed" style="text-align:center; font-size: 8pt">
								<xsl:value-of select="13"/>
							</td>
							<td class="bottom-bold" style="text-align:center; font-size: 8pt">
								<xsl:value-of select="14"/>
							</td>
						</tr>
						<xsl:call-template name="Rb-34_danePozycjeC">
							<xsl:with-param name="kod" select="'W'"/>
							<xsl:with-param name="symbol" select="'020'"/>
							<xsl:with-param name="wyszczeg" select="'Należności netto 1)'"/>
						</xsl:call-template>
						<xsl:call-template name="Rb-34_danePozycjeC">
							<xsl:with-param name="kod" select="'W'"/>
							<xsl:with-param name="symbol" select="'021'"/>
							<xsl:with-param name="wyszczeg" select="'Kwota odpisu aktualizującego należności'"/>
						</xsl:call-template>
						<xsl:call-template name="Rb-34_danePozycjeC">
							<xsl:with-param name="kod" select="'W'"/>
							<xsl:with-param name="symbol" select="'022'"/>
							<xsl:with-param name="wyszczeg" select="'Kwota odsetek od należności niezapłaconych w terminie'"/>
						</xsl:call-template>
						<xsl:call-template name="Rb-34_danePozycjeC">
							<xsl:with-param name="kod" select="'W'"/>
							<xsl:with-param name="symbol" select="'040'"/>
							<xsl:with-param name="wyszczeg" select="'Zobowiązania'"/>
							<xsl:with-param name="ostWiersz" select="true()"/>
						</xsl:call-template>
					</tbody>
				</table>
				<div style="margin-bottom: 60px">
					<div style="display: block; font-size: 7pt">
						<sup>1)</sup> Kwota należności pomniejszona o odpis aktualizujący należności oraz odsetki od należności niezapłaconych w terminie
          </div>
				</div>
				<table cellpadding="0" cellspacing="0" class="all-bold" style="margin-bottom: 20px; width: 100%">
					<tbody>
						<tr style="height: 30px" valign="top">
							<td colspan="5" style="font-size: 9pt; font-weight: bold; text-align:left; padding: 3px 10px; margin-left: 5px; margin-bottom: 25px">Wyjaśnienia do sprawozdania Rb-34</td>
						</tr>
						<tr style="min-height: 50px; height: 70px" valign="top">
							<td colspan="5" style="text-align: left; font-size: 8pt; padding: 3px 10px; border-width: 4px 0 0 0; border-style: solid; border-color: black">
								<xsl:value-of select="Naglowek/Uwagi"/>
							</td>
						</tr>
					</tbody>
				</table>
				<!-- ewentualne uwagi z pozycji -->
				<xsl:if test="PrzychodyPozycje/Pozycja[child::Uwagi] or PrzychodyPodsumowanie/Pozycja[child::Uwagi]">
					<table cellpadding="0" cellspacing="0" class="all-bold" style="margin-bottom: 20px; width: 100%">
						<tbody>
							<tr>
								<td colspan="5" style="text-align: center; font-size: 9pt; font-weight: bold; padding: 3px 10px">
									<div>Uwagi do części: "Przychody"</div>
								</td>
							</tr>
							<tr>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 4px 4px 0; width: 5%">Kod pozycji</td>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 4px 4px 0; width: 6%">Dział</td>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 4px 4px 0; width: 6%">Rozdział</td>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 4px 4px 0; width: 6%">Paragraf</td>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 0 4px 0">Uwaga</td>
							</tr>
							<xsl:for-each select="PrzychodyPozycje/Pozycja[child::Uwagi]">
								<xsl:sort select="Paragraf"/>
								<tr>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="'G'"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="../../Naglowek/Dzial"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="../../Naglowek/Rozdzial"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="concat(Paragraf, P4)"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:value-of select="Uwagi"/>
									</td>
								</tr>
							</xsl:for-each>
							<xsl:if test="PrzychodyPodsumowanie/Pozycja[child::Kod = 'H' and child::Uwagi]">
								<tr>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="PrzychodyPodsumowanie/Pozycja[child::Kod = 'H']/Kod"/>
									</td>
									<td colspan="3" class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="'Razem'"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:value-of select="PrzychodyPodsumowanie/Pozycja[child::Kod = 'H']/Uwagi"/>
									</td>
								</tr>
							</xsl:if>
							<xsl:if test="PrzychodyPodsumowanie/Pozycja[child::Kod = 'K' and child::Symbol = '150' and child::Uwagi]">
								<tr>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="PrzychodyPodsumowanie/Pozycja[child::Kod = 'K' and child::Symbol = '150']/Kod"/>
									</td>
									<td colspan="3" class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="'150 (Stan środków pieniężnych na początek okresu sprawozdawczego)'"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:value-of select="PrzychodyPodsumowanie/Pozycja[child::Kod = 'K' and child::Symbol = '150']/Uwagi"/>
									</td>
								</tr>
							</xsl:if>
							<xsl:if test="PrzychodyPodsumowanie/Pozycja[child::Kod = 'L' and child::Symbol = '190' and child::Uwagi]">
								<tr>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="PrzychodyPodsumowanie/Pozycja[child::Kod = 'L' and child::Symbol = '190']/Kod"/>
									</td>
									<td colspan="3" class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="'190 Ogółem (H+K150)'"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:value-of select="PrzychodyPodsumowanie/Pozycja[child::Kod = 'L' and child::Symbol = '190']/Uwagi"/>
									</td>
								</tr>
							</xsl:if>
						</tbody>
					</table>
				</xsl:if>
				<xsl:if test="KosztyPozycje/Pozycja[child::Uwagi] or KosztyPodsumowanie/Pozycja[child::Uwagi]">
					<table cellpadding="0" cellspacing="0" class="all-bold" style="margin-bottom: 20px; width: 100%">
						<tbody>
							<tr>
								<td colspan="5" style="text-align: center; font-size: 9pt; font-weight: bold; padding: 3px 10px">
									<div>Uwagi do części: "Koszty"</div>
								</td>
							</tr>
							<tr>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 4px 4px 0; width: 5%">Kod pozycji</td>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 4px 4px 0; width: 5%">Dział</td>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 4px 4px 0; width: 5%">Rozdział</td>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 4px 4px 0; width: 5%">Paragraf</td>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 0 4px 0">Uwaga</td>
							</tr>
							<xsl:for-each select="KosztyPozycje/Pozycja[child::Uwagi]">
								<xsl:sort select="Paragraf"/>
								<tr>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="'M'"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="../../Naglowek/Dzial"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="../../Naglowek/Rozdzial"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="concat(Paragraf, P4)"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:value-of select="Uwagi"/>
									</td>
								</tr>
							</xsl:for-each>
							<xsl:if test="KosztyPodsumowanie/Pozycja[child::Kod = 'N' and child::Uwagi]">
								<tr>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="KosztyPodsumowanie/Pozycja[child::Kod = 'N']/Kod"/>
									</td>
									<td colspan="3" class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="'Razem'"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:value-of select="KosztyPodsumowanie/Pozycja[child::Kod = 'N']/Uwagi"/>
									</td>
								</tr>
							</xsl:if>
							<xsl:if test="KosztyPodsumowanie/Pozycja[child::Kod = 'P' and child::Symbol = '150' and child::Uwagi]">
								<tr>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="KosztyPodsumowanie/Pozycja[child::Kod = 'P' and child::Symbol = '150']/Kod"/>
									</td>
									<td colspan="3" class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="'150 (Stan środków pieniężnych na koniec okresu sprawozdawczego)'"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:value-of select="KosztyPodsumowanie/Pozycja[child::Kod = 'P' and child::Symbol = '150']/Uwagi"/>
									</td>
								</tr>
							</xsl:if>
							<xsl:if test="KosztyPodsumowanie/Pozycja[child::Kod = 'S' and child::Symbol = '190' and child::Uwagi]">
								<tr>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="KosztyPodsumowanie/Pozycja[child::Kod = 'S' and child::Symbol = '190']/Kod"/>
									</td>
									<td colspan="3" class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="'190 Ogółem (N+P150)'"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:value-of select="KosztyPodsumowanie/Pozycja[child::Kod = 'S' and child::Symbol = '190']/Uwagi"/>
									</td>
								</tr>
							</xsl:if>
						</tbody>
					</table>
				</xsl:if>
				<xsl:if test="Stan/Pozycja[child::Uwagi]">
					<table cellpadding="0" cellspacing="0" class="all-bold" style="margin-bottom: 20px; width: 100%">
						<tbody>
							<tr>
								<td colspan="4" style="text-align: center; font-size: 9pt; font-weight: bold; padding: 3px 10px">
									<div>Uwagi do części: "Stan"</div>
								</td>
							</tr>
							<tr>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 4px 4px 0; width: 4%">Kod</td>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 4px 4px 0; width: 6%">Symbol</td>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 4px 4px 0; width: 30%">Wyszczególnienie</td>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 0 4px 0">Uwaga</td>
							</tr>
							<xsl:for-each select="Stan/Pozycja[child::Uwagi]">
								<xsl:sort select="Symbol"/>
								<tr>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="Kod"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="Symbol"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:choose>
											<xsl:when test="Symbol = '020'">Należności netto</xsl:when>
											<xsl:when test="Symbol = '021'">Kwota odpisu aktualizującego należności</xsl:when>
											<xsl:when test="Symbol = '022'">Kwota odsetek od należności niezapłaconych w terminie</xsl:when>
											<xsl:when test="Symbol = '040'">Zobowiązania</xsl:when>
										</xsl:choose>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:value-of select="Uwagi"/>
									</td>
								</tr>
							</xsl:for-each>
						</tbody>
					</table>
				</xsl:if>
				<table cellpadding="0" cellspacing="0" style="margin-bottom: 0px; margin-top: 80px; width: 100%">
					<tbody>
						<tr>
							<td style="text-align:center; font-size: 8pt;" valign="bottom">
								<hr style="width: 80%"/>
								<div>Główny księgowy / Skarbnik</div>
							</td>
							<td style="text-align:center; font-size: 8pt;" valign="bottom">
								<hr style="width: 80%"/>
								<div>telefon</div>
							</td>
							<td style="text-align:center; font-size: 8pt;" valign="bottom">
								<div>
									<xsl:value-of select="Naglowek/DataSprawozdania"/>
								</div>
								<hr style="width: 80%"/>
								<div>rok m-c dzień</div>
							</td>
							<td style="text-align:center; font-size: 8pt;" valign="bottom">
								<hr style="width: 80%"/>
								<div>Kierownik jednostki / Przewodniczący zarządu</div>
							</td>
						</tr>
					</tbody>
				</table>
			</div>
			<xsl:element name="a">
				<xsl:attribute name="href"><xsl:value-of select="concat('#Jed', $jedIndex)"/></xsl:attribute>
				<xsl:element name="style">
					<xsl:value-of select="'font-family: Verdana'"/>
				</xsl:element>
				<xsl:value-of select="'Powrót do listy sprawozdań jednostki'"/>
			</xsl:element>
		</xsl:element>
	</xsl:template>
	<!-- Rb-34 szablony pomocnicze -->
	<xsl:template match="Rb-34/PrzychodyPodsumowanie">
		<xsl:param name="Dzial"/>
		<xsl:param name="Rozdzial"/>
		<xsl:variable name="Paragrafy" select="parent::*/PrzychodyPozycje/Pozycja/Paragraf"/>
		<xsl:variable name="P4" select="parent::*/PrzychodyPozycje/Pozycja/P4"/>
		<tr>
			<td class="bottom-right-normal" style="text-align: center; font-size: 8pt; font-weight: bold">
				<xsl:value-of select="'H'"/>
			</td>
			<td colspan="3" class="bottom-right-normal" style="text-align: center; font-size: 9pt; font-weight: bold">
				<xsl:value-of select="'RAZEM '"/>
				<xsl:call-template name="Rb-34_SumaKontr">
					<xsl:with-param name="Paragrafy" select="$Paragrafy"/>
					<xsl:with-param name="P4" select="$P4"/>
					<xsl:with-param name="Licznosc" select="count(parent::*/PrzychodyPozycje/Pozycja)"/>
					<xsl:with-param name="Licznik" select="1"/>
					<xsl:with-param name="Wartosc" select="0"/>
					<xsl:with-param name="Dzial" select="$Dzial"/>
					<xsl:with-param name="Rozdzial" select="$Rozdzial"/>
				</xsl:call-template>
			</td>
			<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; font-weight: bold; padding: 3px">
				<xsl:choose>
					<xsl:when test="Pozycja[child::Kod = 'H']/P">
						<xsl:value-of select="format-number(Pozycja[child::Kod = 'H']/P, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
			<td class="bottom-normal" style="text-align: right; font-size: 8pt; font-weight: bold; padding: 3px">
				<xsl:choose>
					<xsl:when test="Pozycja[child::Kod = 'H']/W">
						<xsl:value-of select="format-number(Pozycja[child::Kod = 'H']/W, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
		</tr>
		<tr>
			<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
				<xsl:value-of select="'K'"/>
			</td>
			<td colspan="3" class="bottom-right-normal" style="text-align: center; font-size: 8pt">
				<xsl:value-of select="'150 (Stan środków pieniężnych na początek okresu sprawozdawczego)'"/>
			</td>
			<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; padding: 3px">
				<xsl:choose>
					<xsl:when test="Pozycja[child::Kod = 'K' and child::Symbol='150']/P">
						<xsl:value-of select="format-number(Pozycja[child::Kod = 'K' and child::Symbol='150']/P, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
			<td class="bottom-normal" style="text-align: right; font-size: 8pt; padding: 3px">
				<xsl:choose>
					<xsl:when test="Pozycja[child::Kod = 'K' and child::Symbol='150']/W">
						<xsl:value-of select="format-number(Pozycja[child::Kod = 'K' and child::Symbol='150']/W, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
		</tr>
		<tr>
			<td class="bottom-right-normal" style="text-align: center; font-size: 8pt; font-weight: bold">
				<xsl:value-of select="'L'"/>
			</td>
			<td colspan="3" class="bottom-right-normal" style="text-align: center; font-size: 8pt; font-weight: bold">
				<xsl:value-of select="'190 Ogółem (H+K150)'"/>
			</td>
			<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; font-weight: bold; padding: 3px">
				<xsl:choose>
					<xsl:when test="Pozycja[child::Kod = 'L' and child::Symbol = '190']/P">
						<xsl:value-of select="format-number(Pozycja[child::Kod = 'L' and child::Symbol = '190']/P, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
			<td class="bottom-normal" style="text-align: right; font-size: 8pt; font-weight: bold; padding: 3px">
				<xsl:choose>
					<xsl:when test="Pozycja[child::Kod = 'L' and child::Symbol = '190']/W">
						<xsl:value-of select="format-number(Pozycja[child::Kod = 'L' and child::Symbol = '190']/W, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
		</tr>
	</xsl:template>
	<xsl:template match="Rb-34/KosztyPodsumowanie">
		<xsl:param name="Dzial"/>
		<xsl:param name="Rozdzial"/>
		<xsl:variable name="Paragrafy" select="parent::*/KosztyPozycje/Pozycja/Paragraf"/>
		<xsl:variable name="P4" select="parent::*/KosztyPozycje/Pozycja/P4"/>
		<tr>
			<td class="bottom-right-normal" style="text-align: center; font-size: 8pt; font-weight: bold">
				<xsl:value-of select="'N'"/>
			</td>
			<td colspan="3" class="bottom-right-normal" style="text-align: center; font-size: 9pt; font-weight: bold">
				<xsl:value-of select="'RAZEM '"/>
				<xsl:call-template name="Rb-34_SumaKontr">
					<xsl:with-param name="Paragrafy" select="$Paragrafy"/>
					<xsl:with-param name="P4" select="$P4"/>
					<xsl:with-param name="Licznosc" select="count(parent::*/KosztyPozycje/Pozycja)"/>
					<xsl:with-param name="Licznik" select="1"/>
					<xsl:with-param name="Wartosc" select="0"/>
					<xsl:with-param name="Dzial" select="$Dzial"/>
					<xsl:with-param name="Rozdzial" select="$Rozdzial"/>
				</xsl:call-template>
			</td>
			<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; font-weight: bold; padding: 3px">
				<xsl:choose>
					<xsl:when test="Pozycja[child::Kod = 'N']/P">
						<xsl:value-of select="format-number(Pozycja[child::Kod = 'N']/P, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
			<td class="bottom-normal" style="text-align: right; font-size: 8pt; font-weight: bold; padding: 3px">
				<xsl:choose>
					<xsl:when test="Pozycja[child::Kod = 'N']/W">
						<xsl:value-of select="format-number(Pozycja[child::Kod = 'N']/W, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
		</tr>
		<tr>
			<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
				<xsl:value-of select="'P'"/>
			</td>
			<td colspan="3" class="bottom-right-normal" style="text-align: center; font-size: 8pt">
				<xsl:value-of select="'150 (Stan środków pieniężnych na koniec okresu sprawozdawczego)'"/>
			</td>
			<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; padding: 3px">
				<xsl:choose>
					<xsl:when test="Pozycja[child::Kod = 'P' and child::Symbol='150']/P">
						<xsl:value-of select="format-number(Pozycja[child::Kod = 'P' and child::Symbol='150']/P, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
			<td class="bottom-normal" style="text-align: right; font-size: 8pt; padding: 3px">
				<xsl:choose>
					<xsl:when test="Pozycja[child::Kod = 'P' and child::Symbol='150']/W">
						<xsl:value-of select="format-number(Pozycja[child::Kod = 'P' and child::Symbol='150']/W, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
		</tr>
		<tr>
			<td class="bottom-right-normal" style="text-align: center; font-size: 8pt; font-weight: bold">
				<xsl:value-of select="'S'"/>
			</td>
			<td colspan="3" class="bottom-right-normal" style="text-align: center; font-size: 8pt; font-weight: bold">
				<xsl:value-of select="'190 Ogółem (N+P150)'"/>
			</td>
			<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; font-weight: bold; padding: 3px">
				<xsl:choose>
					<xsl:when test="Pozycja[child::Kod = 'S' and child::Symbol='190']/P">
						<xsl:value-of select="format-number(Pozycja[child::Kod = 'S' and child::Symbol='190']/P, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
			<td class="bottom-normal" style="text-align: right; font-size: 8pt; font-weight: bold; padding: 3px">
				<xsl:choose>
					<xsl:when test="Pozycja[child::Kod = 'S' and child::Symbol='190']/W">
						<xsl:value-of select="format-number(Pozycja[child::Kod = 'S' and child::Symbol='190']/W, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
		</tr>
	</xsl:template>
	<xsl:template name="Rb-34_SumaKontr">
		<xsl:param name="Paragrafy"/>
		<xsl:param name="P4"/>
		<xsl:param name="Licznosc"/>
		<xsl:param name="Licznik"/>
		<xsl:param name="Wartosc"/>
		<xsl:param name="Dzial"/>
		<xsl:param name="Rozdzial"/>
		<xsl:choose>
			<xsl:when test="$Licznosc = 0">
				<xsl:value-of select="$Wartosc + number($Dzial) + number($Rozdzial)"/>
			</xsl:when>
			<xsl:when test="$Licznosc = $Licznik">
				<xsl:value-of select="$Wartosc + number(concat($Paragrafy[$Licznik], $P4[$Licznik])) + number($Dzial) + number($Rozdzial)"/>
			</xsl:when>
			<xsl:when test="$Licznosc &gt; $Licznik">
				<xsl:call-template name="Rb-34_SumaKontr">
					<xsl:with-param name="Paragrafy" select="$Paragrafy"/>
					<xsl:with-param name="P4" select="$P4"/>
					<xsl:with-param name="Licznosc" select="$Licznosc"/>
					<xsl:with-param name="Licznik" select="$Licznik + 1"/>
					<xsl:with-param name="Wartosc" select="$Wartosc + number(concat($Paragrafy[$Licznik], $P4[$Licznik]))"/>
					<xsl:with-param name="Dzial" select="$Dzial"/>
					<xsl:with-param name="Rozdzial" select="$Rozdzial"/>
				</xsl:call-template>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="Rb-34_danePozycjeC">
		<xsl:param name="kod"/>
		<xsl:param name="symbol"/>
		<xsl:param name="wyszczeg"/>
		<xsl:param name="ostWiersz" select="false()"/>
		<tr>
			<xsl:element name="td">
				<xsl:attribute name="style"><xsl:value-of select="'text-align: center; font-size: 8pt'"/></xsl:attribute>
				<xsl:attribute name="class"><xsl:choose><xsl:when test="$ostWiersz = false()"><xsl:value-of select="'bottom-right-normal'"/></xsl:when><xsl:otherwise><xsl:value-of select="'right-normal'"/></xsl:otherwise></xsl:choose></xsl:attribute>
				<xsl:value-of select="$kod"/>
			</xsl:element>
			<xsl:element name="td">
				<xsl:attribute name="style"><xsl:value-of select="'text-align: center; font-size: 8pt'"/></xsl:attribute>
				<xsl:attribute name="class"><xsl:choose><xsl:when test="$ostWiersz = false()"><xsl:value-of select="'bottom-right-normal'"/></xsl:when><xsl:otherwise><xsl:value-of select="'right-normal'"/></xsl:otherwise></xsl:choose></xsl:attribute>
				<xsl:value-of select="$symbol"/>
			</xsl:element>
			<xsl:element name="td">
				<xsl:attribute name="style"><xsl:value-of select="'text-align: left; font-size: 8pt; padding: 3px'"/></xsl:attribute>
				<xsl:attribute name="class"><xsl:choose><xsl:when test="$ostWiersz = false()"><xsl:value-of select="'bottom-right-normal'"/></xsl:when><xsl:otherwise><xsl:value-of select="'right-normal'"/></xsl:otherwise></xsl:choose></xsl:attribute>
				<xsl:value-of select="$wyszczeg"/>
			</xsl:element>
			<xsl:element name="td">
				<xsl:attribute name="style"><xsl:value-of select="'text-align: right; font-size: 8pt; padding: 3px'"/></xsl:attribute>
				<xsl:attribute name="class"><xsl:choose><xsl:when test="$ostWiersz = false()"><xsl:value-of select="'bottom-right-normal'"/></xsl:when><xsl:otherwise><xsl:value-of select="'right-normal'"/></xsl:otherwise></xsl:choose></xsl:attribute>
				<xsl:choose>
					<xsl:when test="Stan/Pozycja[child::Kod = $kod and child::Symbol = $symbol]/P">
						<xsl:value-of select="format-number(Stan/Pozycja[child::Kod = $kod and child::Symbol = $symbol]/P, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:element>
			<xsl:element name="td">
				<xsl:attribute name="style"><xsl:value-of select="'text-align: right; font-size: 8pt; padding: 3px'"/></xsl:attribute>
				<xsl:if test="$ostWiersz = false()">
					<xsl:attribute name="class"><xsl:value-of select="'bottom-normal'"/></xsl:attribute>
				</xsl:if>
				<xsl:choose>
					<xsl:when test="Stan/Pozycja[child::Kod = $kod and child::Symbol = $symbol]/K">
						<xsl:value-of select="format-number(Stan/Pozycja[child::Kod = $kod and child::Symbol = $symbol]/K, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:element>
		</tr>
	</xsl:template>
	<!-- Rb-34s-->
	<xsl:template match="Rb-34s">
		<xsl:param name="jedIndex"/>
		<xsl:param name="sprIndex"/>
		<xsl:element name="div">
			<xsl:attribute name="Id"><xsl:value-of select="concat('Jed', $jedIndex, 'Wer', $sprIndex)"/></xsl:attribute>
			<xsl:attribute name="style"><xsl:value-of select="'display: block; margin-bottom: 40px'"/></xsl:attribute>
			<div style="font-size: 12pt; font-weight: bold; margin-left: 5px; margin-bottom: 10px">
        Sprawozdanie Rb-34s:
        <xsl:choose>
					<xsl:when test="Naglowek/Wersja = 0">
						<xsl:value-of select="'wersja pierwotna'"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="concat('korekta nr ', Naglowek/Wersja)"/>
					</xsl:otherwise>
				</xsl:choose>
				<xsl:call-template name="SprNaglowekInfo"/>
			</div>
			<table cellpadding="0" cellspacing="0" class="all-bold" style="margin-bottom: 30px">
				<tbody>
					<tr style="height: 18px">
						<td colspan="13" class="bottom-bold" style="font-size: 10pt;">MINISTERSTWO FINANSÓW, ul. Świętokrzyska 12, 00-916 Warszawa</td>
					</tr>
					<tr style="height: 127px">
						<td colspan="6" class="bottom-bold" style="width:300px">
							<table cellpadding="0" cellspacing="0" style="border-collapse: collapse; height" width="100%">
								<tbody>
									<tr style="height: 80px">
										<td style="text-align: left; font-size: 9pt; margin:1px 1px 0 0; padding:0" valign="top">
                      Nazwa i adres jednostki sprawozdawczej
                    </td>
									</tr>
									<tr>
										<td class="bottom-normal" style="text-align: center; font-size: 9pt" valign="bottom">
											<!-- popr. nr I.8 -->
											<div style="display: block;margin: 0 20px">
												<xsl:choose>
													<xsl:when test="Jednostka/Nazwa">
														<xsl:value-of select="Jednostka/Nazwa"/>
													</xsl:when>
													<xsl:otherwise>
														<xsl:value-of select="../../Nazwa"/>
													</xsl:otherwise>
												</xsl:choose>
											</div>
										</td>
									</tr>
									<tr style="height: 23px">
										<td style="text-align: left; font-size: 9pt; margin:1px 1px 0 0; padding:0;" valign="top">
                      Numer identyfikacyjny REGON
                    </td>
									</tr>
									<tr>
										<td style="text-align: center; font-size: 9pt; font-weight: bold; margin:1px 1px 0 0; padding:0" valign="baseline">
											<xsl:choose>
												<xsl:when test="Jednostka/Regon">
													<xsl:value-of select="Jednostka/Regon"/>
												</xsl:when>
												<xsl:otherwise>
													<xsl:value-of select="../../Regon"/>
												</xsl:otherwise>
											</xsl:choose>
										</td>
									</tr>
								</tbody>
							</table>
						</td>
						<td colspan="6" class="notop-bold" valign="top" style="width: 400px">
							<div style="font-weight: bold; text-align: center; font-size: 11pt; margin-bottom: 5px">Rb-34s</div>
							<div style="font-weight: bold; text-align: center; font-size: 11pt; margin-bottom: 5px">
                sprawozdanie z wykonania
                dochodów i wydatków na rachunku,
                o którym mowa w art. 223 ust. 1
                ustawy o finansach publicznych
              </div>
							<div style="font-weight: bold; text-align: center; font-size: 11pt; margin-bottom: 5px; margin-top: 20px">okres sprawozdawczy:</div>
							<div style="vertical-align: bottom; text-align: center; font-size: 9pt; margin-top: 20px">
								<xsl:call-template name="NaglowekSprOkresRb34S"/>
							</div>
						</td>
						<td class="bottom-bold" style="text-align: left; font-size: 9pt; margin:1px 1px 0 0; padding:0; width: 300px" valign="top">
							<div style="margin-bottom:5px">Adresat:</div>
							<!-- popr. nr I.9 -->
							<div style="text-align:center; margin-bottom: 15px;">
								<!-- <xsl:value-of select="'Regionalna Izba Obrachunkowa w Katowicach'"/> -->
							</div>
							<div style="text-align:center;">
								<!-- <xsl:value-of select="'wersja robocza'"/> -->
							</div>
							<div style="margin-top:120px;border-top: 4px solid black">Przed wypełnieniem przeczytać instrukcję:</div>
						</td>
					</tr>
					<tr style="height: 1px">
						<td rowspan="6" colspan="7" class="bottom-right-bold" style="font-size: 9pt">
							<!-- popr. nr I.10 -->
							<div style="margin-bottom: 1px">
								<xsl:value-of select="'Nazwa województwa '"/>
								<sup>1)</sup>
								<!-- <xsl:if test="../../Typ = 'W'">
									<span style="margin-left: 10px">
										<b>
											<xsl:value-of select="../../Nazwa"/>
										</b>
									</span>
								</xsl:if> -->
							</div>
							<div style="margin-bottom: 1px">
								<xsl:value-of select="'Nazwa powiatu / związku '"/>
								<sup>1)</sup>
								<!-- <xsl:if test="../../Typ = 'P'">
									<span style="margin-left: 10px">
										<b>
											<xsl:value-of select="../../Nazwa"/>
										</b>
									</span>
								</xsl:if> -->
							</div>
							<div>
								<xsl:value-of select="'Nazwa gminy / związku '"/>
								<sup>1)</sup>
								<!-- <xsl:if test="../../Typ = 'G'">
									<span style="margin-left: 10px">
										<b>
											<xsl:value-of select="../../Nazwa"/>
										</b>
									</span>
								</xsl:if> -->
							</div>
						</td>
					</tr>
					<tr>
						<td colspan="6" class="bottom-normal" style="font-size:10pt; text-align:center">Symbole</td>
					</tr>
					<tr>
						<td class="bottom-right-normal" style="font-size:9pt; text-align:center">woj.</td>
						<td class="bottom-right-normal" style="font-size:9pt; text-align:center">powiat</td>
						<td class="bottom-right-normal" style="font-size:9pt; text-align:center">gmina</td>
						<td class="bottom-right-normal" style="font-size:9pt; text-align:center">typ gm.</td>
						<td class="bottom-right-normal" style="font-size:9pt; text-align:center">związek jst</td>
						<td class="bottom-right-normal" style="font-size:9pt; text-align:center">typ zw.</td>
					</tr>
					<tr>
						<td class="bottom-right-normal" style="text-align:center; font-size: 8pt">
							<xsl:value-of select="1"/>
						</td>
						<td class="bottom-right-normal" style="text-align:center; font-size: 8pt">
							<xsl:value-of select="2"/>
						</td>
						<td class="bottom-right-normal" style="text-align:center; font-size: 8pt">
							<xsl:value-of select="3"/>
						</td>
						<td class="bottom-right-normal" style="text-align:center; font-size: 8pt">
							<xsl:value-of select="4"/>
						</td>
						<td class="bottom-right-normal" style="text-align:center; font-size: 8pt">
							<xsl:value-of select="5"/>
						</td>
						<td class="bottom-right-normal" style="text-align:center; font-size: 8pt">
							<xsl:value-of select="6"/>
						</td>
					</tr>
					<tr>
						<td class="right-normal" style="font-size:10pt; text-align:center">
							<xsl:choose>
								<xsl:when test="Jednostka/WK">
									<xsl:value-of select="Jednostka/WK"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="../../WK"/>
								</xsl:otherwise>
							</xsl:choose>
						</td>
						<td class="right-normal" style="font-size:10pt; text-align:center">
							<xsl:choose>
								<xsl:when test="Jednostka/PK">
									<xsl:value-of select="Jednostka/PK"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="../../PK"/>
								</xsl:otherwise>
							</xsl:choose>
						</td>
						<td class="right-normal" style="font-size:10pt; text-align:center">
							<xsl:choose>
								<xsl:when test="Jednostka/GK">
									<xsl:value-of select="Jednostka/GK"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="../../GK"/>
								</xsl:otherwise>
							</xsl:choose>
						</td>
						<td class="right-normal" style="font-size:10pt; text-align:center">
							<xsl:choose>
								<xsl:when test="Jednostka/GT">
									<xsl:value-of select="Jednostka/GT"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="../../GT"/>
								</xsl:otherwise>
							</xsl:choose>
						</td>
						<td style="font-size:10pt; text-align:center; border-right: 1px solid black">
							<xsl:choose>
								<xsl:when test="Jednostka/KodMSWiA">
									<xsl:value-of select="Jednostka/KodMSWiA"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:choose>
										<xsl:when test="../../KodMSWiA">
											<xsl:value-of select="../../KodMSWiA"/>
										</xsl:when>
										<xsl:otherwise>
											<xsl:value-of select="$nbsp"/>
										</xsl:otherwise>
									</xsl:choose>
								</xsl:otherwise>
							</xsl:choose>
						</td>
						<td style="font-size:10pt; text-align:center; border-right: 1px solid black">
							<xsl:value-of select="$nbsp"/>
						</td>
					</tr>
				</tbody>
			</table>
			<div style="display: block; margin-bottom: 40px">
				<table cellpadding="0" cellspacing="0">
					<tbody>
						<tr>
							<td style="width: 450px">
								<div style="font-size: 10pt; font-weight: bold; margin-left: 5px">A.</div>
							</td>
							<td style="width: 120px">
								<!-- <div style="font-size: 9pt">strona 1</div> -->
							</td>
							<td style="width: 350px">
								<!-- <div style="font-size: 9pt">sprawozdania Rb-34s, Dział <xsl:value-of select="Naglowek/Dzial"/>, Rozdział <xsl:value-of select="Naglowek/Rozdzial"/>, <xsl:value-of select="../../Nazwa"/>
								</div> -->
							</td>
						</tr>
					</tbody>
				</table>
				<table cellpadding="0" cellspacing="0" class="all-bold" style="margin-bottom: 10px">
					<tbody>
						<tr>
							<td rowspan="2" class="bottom-right-mixed" style="font-size: 10pt; text-align: center; width: 80px">Kod pozycji</td>
							<td rowspan="2" class="bottom-right-mixed" style="font-size: 10pt; text-align: center; width: 120px">Dział</td>
							<td rowspan="2" class="bottom-right-mixed" style="font-size: 10pt; text-align: center; width: 120px">Rozdział</td>
							<td rowspan="2" class="bottom-right-mixed" style="font-size: 10pt; text-align: center; width: 120px">Paragraf</td>
							<td colspan="2" class="bottom-normal" style="font-size: 10pt; text-align: center">Dochody</td>
						</tr>
						<tr>
							<td class="bottom-right-mixed" style="font-size: 10pt; text-align: center; width: 260px; min-width: 220px">plan</td>
							<td class="bottom-bold" style="font-size: 10pt; text-align: center; width: 260px; min-width: 220px">wykonanie</td>
						</tr>
						<tr>
							<td class="bottom-right-mixed" style="text-align:center; font-size: 8pt">
								<xsl:value-of select="1"/>
							</td>
							<td class="bottom-right-mixed" style="text-align:center; font-size: 8pt">
								<xsl:value-of select="2"/>
							</td>
							<td class="bottom-right-mixed" style="text-align:center; font-size: 8pt">
								<xsl:value-of select="3"/>
							</td>
							<td class="bottom-right-mixed" style="text-align:center; font-size: 8pt">
								<xsl:value-of select="4"/>
							</td>
							<td class="bottom-right-mixed" style="text-align:center; font-size: 8pt">
								<xsl:value-of select="5"/>
							</td>
							<td class="bottom-bold" style="text-align:center; font-size: 8pt">
								<xsl:value-of select="6"/>
							</td>
						</tr>
						<xsl:for-each select="DochodyPozycje/Pozycja">
							<xsl:sort select="Dzial"/>
							<xsl:sort select="Rozdzial"/>
							<xsl:sort select="Paragraf"/>
							<tr>
								<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
									<xsl:value-of select="'G'"/>
								</td>
								<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
									<xsl:value-of select="Dzial"/>
								</td>
								<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
									<xsl:value-of select="Rozdzial"/>
								</td>
								<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
									<xsl:value-of select="concat(Paragraf, P4)"/>
								</td>
								<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; padding: 3px">
									<xsl:choose>
										<xsl:when test="P">
											<xsl:value-of select="format-number(P, '#&#160;##0,00')"/>
										</xsl:when>
										<xsl:otherwise>
											<xsl:value-of select="'0,00'"/>
										</xsl:otherwise>
									</xsl:choose>
								</td>
								<td class="bottom-normal" style="text-align: right; font-size: 8pt; padding: 3px">
									<xsl:choose>
										<xsl:when test="W">
											<xsl:value-of select="format-number(W, '#&#160;##0,00')"/>
										</xsl:when>
										<xsl:otherwise>
											<xsl:value-of select="'0,00'"/>
										</xsl:otherwise>
									</xsl:choose>
								</td>
							</tr>
						</xsl:for-each>
						<xsl:apply-templates select="DochodyPodsumowanie">
							<xsl:with-param name="Dzial" select="Naglowek/Dzial"/>
							<xsl:with-param name="Rozdzial" select="Naglowek/Rozdzial"/>
						</xsl:apply-templates>
					</tbody>
				</table>
				<div style="margin-bottom: 20px">
					<div style="display: block; font-size: 7pt;margin-bottom:0">
						<sup>1)</sup> dotyczy jednostek samorządu terytorialnego i ich związków
          </div>
				</div>
				<table cellpadding="0" cellspacing="0">
					<tbody>
						<tr>
							<td style="width: 450px">
								<div style="font-size: 10pt; font-weight: bold; margin-left: 5px">B.</div>
							</td>
							<td style="width: 120px">
								<!-- <div style="font-size: 9pt">strona 2</div> -->
							</td>
							<td style="width: 350px">
								<!-- <div style="font-size: 9pt">sprawozdania Rb-34s, Dział <xsl:value-of select="Naglowek/Dzial"/>, Rozdział <xsl:value-of select="Naglowek/Rozdzial"/>, <xsl:value-of select="../../Nazwa"/>
								</div> -->
							</td>
						</tr>
					</tbody>
				</table>
				<table cellpadding="0" cellspacing="0" class="all-bold" style="margin-bottom: 10px">
					<tbody>
						<tr>
							<td rowspan="2" class="bottom-right-mixed" style="font-size: 10pt; text-align: center; width: 80px">Kod pozycji</td>
							<td rowspan="2" class="bottom-right-mixed" style="font-size: 10pt; text-align: center; width: 120px">Dział</td>
							<td rowspan="2" class="bottom-right-mixed" style="font-size: 10pt; text-align: center; width: 120px">Rozdział</td>
							<td rowspan="2" class="bottom-right-mixed" style="font-size: 10pt; text-align: center; width: 120px">Grupa paragrafów <sup>2)</sup>
							</td>
							<td rowspan="2" class="bottom-right-mixed" style="font-size: 10pt; text-align: center; width: 120px">Paragraf</td>
							<td colspan="2" class="bottom-normal" style="font-size: 10pt; text-align: center">Wydatki</td>
						</tr>
						<tr>
							<td class="bottom-right-mixed" style="font-size: 10pt; text-align: center; width: 260px; min-width: 220px">plan</td>
							<td class="bottom-bold" style="font-size: 10pt; text-align: center; width: 260px; min-width: 220px">wykonanie</td>
						</tr>
						<tr>
							<td class="bottom-right-mixed" style="text-align:center; font-size: 8pt">
								<xsl:value-of select="1"/>
							</td>
							<td class="bottom-right-mixed" style="text-align:center; font-size: 8pt">
								<xsl:value-of select="2"/>
							</td>
							<td class="bottom-right-mixed" style="text-align:center; font-size: 8pt">
								<xsl:value-of select="3"/>
							</td>
							<td class="bottom-right-mixed" style="text-align:center; font-size: 8pt">
								<xsl:value-of select="4"/>
							</td>
							<td class="bottom-right-mixed" style="text-align:center; font-size: 8pt">
								<xsl:value-of select="5"/>
							</td>
							<td class="bottom-right-mixed" style="text-align:center; font-size: 8pt">
								<xsl:value-of select="6"/>
							</td>
							<td class="bottom-bold" style="text-align:center; font-size: 8pt">
								<xsl:value-of select="7"/>
							</td>
						</tr>
						<!--<td class="bottom-right-normal" style="text-align:center;font-size:8pt;">-->
						<xsl:choose>
							<xsl:when test="translate(string(Naglowek/DostepneGrupyParagrafow), 'TRUE', 'true' ) = 'true'">
								<xsl:for-each select="WydatkiPozycje/Pozycja">
									<xsl:sort select="Rozdzial"/>
									<xsl:sort select="Grupa"/>
									<xsl:sort select="Paragraf"/>
									<xsl:sort select="P4"/>
									<xsl:call-template name="Rb-34S_pozycjeWydatkowe"/>
								</xsl:for-each>
							</xsl:when>
							<xsl:otherwise>
								<xsl:for-each select="WydatkiPozycje/Pozycja">
									<xsl:sort select="Rozdzial"/>
									<xsl:sort select="Paragraf"/>
									<xsl:sort select="P4"/>
									<xsl:call-template name="Rb-34S_pozycjeWydatkowe"/>
								</xsl:for-each>
							</xsl:otherwise>
						</xsl:choose>
						<xsl:apply-templates select="WydatkiPodsumowanie">
							<xsl:with-param name="Dzial" select="Naglowek/Dzial"/>
							<xsl:with-param name="Rozdzial" select="Naglowek/Rozdzial"/>
						</xsl:apply-templates>
					</tbody>
				</table>
				<div style="margin-bottom: 20px">
					<div style="display: block; font-size: 7pt;margin-bottom:0">
						<sup>2)</sup> wypełniają te jednostki, które kwoty wydatków planują w grupach paragrafów
          </div>
				</div>
				<table cellpadding="0" cellspacing="0">
					<tbody>
						<tr>
							<td style="width: 450px">
								<div style="font-size: 10pt; font-weight: bold; margin-left: 5px">C.</div>
							</td>
							<td style="width: 120px">
								<!-- <div style="font-size: 9pt">strona 3</div> -->
							</td>
							<td style="width: 350px">
								<!-- <div style="font-size: 9pt">sprawozdania Rb-34s, Dział <xsl:value-of select="Naglowek/Dzial"/>, Rozdział <xsl:value-of select="Naglowek/Rozdzial"/>, <xsl:value-of select="../../Nazwa"/>
								</div> -->
							</td>
						</tr>
					</tbody>
				</table>
				<table cellpadding="0" cellspacing="0" class="all-bold" style="margin-bottom: 10px">
					<tbody>
						<tr>
							<td class="bottom-right-mixed" style="font-size: 10pt; text-align: center; width: 80px">Kod pozycji</td>
							<td class="bottom-right-mixed" style="font-size: 10pt; text-align: center; width: 90px">Symbol</td>
							<td class="bottom-right-mixed" style="font-size: 10pt; text-align: center; width: 360px; min-width: 320px">Wyszczególnienie</td>
							<td class="bottom-right-mixed" style="font-size: 10pt; text-align: center; width: 260px; min-width: 220px">Stan na początek okresu sprawozdawczego</td>
							<td class="bottom-bold" style="font-size: 10pt; text-align: center; width: 260px; min-width: 220px">Stan na koniec okresu sprawozdawczego</td>
						</tr>
						<tr>
							<td class="bottom-right-mixed" style="text-align:center; font-size: 8pt">
								<xsl:value-of select="1"/>
							</td>
							<td class="bottom-right-mixed" style="text-align:center; font-size: 8pt">
								<xsl:value-of select="2"/>
							</td>
							<td class="bottom-right-mixed" style="text-align: center; font-size: 8pt">
								<xsl:value-of select="$nbsp"/>
							</td>
							<td class="bottom-right-mixed" style="text-align:center; font-size: 8pt">
								<xsl:value-of select="3"/>
							</td>
							<td class="bottom-bold" style="text-align:center; font-size: 8pt">
								<xsl:value-of select="4"/>
							</td>
						</tr>
						<xsl:call-template name="Rb-34s_danePozycjeC">
							<xsl:with-param name="kod" select="'W'"/>
							<xsl:with-param name="symbol" select="'020'"/>
							<xsl:with-param name="wyszczeg" select="'Należności netto'"/>
							<xsl:with-param name="annotation" select="'3'"/>
						</xsl:call-template>
						<xsl:call-template name="Rb-34s_danePozycjeC">
							<xsl:with-param name="kod" select="'W'"/>
							<xsl:with-param name="symbol" select="'021'"/>
							<xsl:with-param name="wyszczeg" select="'Kwota odpisu aktualizującego należności'"/>
						</xsl:call-template>
						<xsl:call-template name="Rb-34s_danePozycjeC">
							<xsl:with-param name="kod" select="'W'"/>
							<xsl:with-param name="symbol" select="'022'"/>
							<xsl:with-param name="wyszczeg" select="'Odsetki od należności niezapłaconych w terminie (nieobjęte odpisem aktualizującym)'"/>
						</xsl:call-template>
						<xsl:call-template name="Rb-34s_danePozycjeC">
							<xsl:with-param name="kod" select="'W'"/>
							<xsl:with-param name="symbol" select="'040'"/>
							<xsl:with-param name="wyszczeg" select="'Zobowiązania'"/>
							<xsl:with-param name="ostWiersz" select="true()"/>
						</xsl:call-template>
					</tbody>
				</table>
				<div style="margin-bottom: 60px">
					<div style="display: block; font-size: 7pt">
						<sup>3)</sup> Kwota należności pomniejszona o odpis aktualizujący należności
          </div>
				</div>
				<table cellpadding="0" cellspacing="0" class="all-bold" style="margin-bottom: 20px; width: 58%">
					<tbody>
						<tr style="height: 30px" valign="top">
							<td colspan="5" style="font-size: 9pt; font-weight: bold; text-align:left; padding: 3px 10px; margin-left: 5px; margin-bottom: 25px">Wyjaśnienia do sprawozdania Rb-34s</td>
						</tr>
						<tr style="min-height: 50px; height: 70px" valign="top">
							<td colspan="5" style="text-align: left; font-size: 8pt; padding: 3px 10px; border-width: 4px 0 0 0; border-style: solid; border-color: black">
								<xsl:value-of select="Naglowek/Uwagi"/>
							</td>
						</tr>
					</tbody>
				</table>
				<!-- ewentualne uwagi z pozycji -->
				<xsl:if test="DochodyPozycje/Pozycja[child::Uwagi] or DochodyPodsumowanie/Pozycja[child::Uwagi]">
					<table cellpadding="0" cellspacing="0" class="all-bold" style="margin-bottom: 20px; width: 58%">
						<tbody>
							<tr>
								<td colspan="5" style="text-align: center; font-size: 9pt; font-weight: bold; padding: 3px 10px">
									<div>Uwagi do części: "Dochody"</div>
								</td>
							</tr>
							<tr>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 4px 4px 0; width: 5%">Kod pozycji</td>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 4px 4px 0; width: 6%">Dział</td>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 4px 4px 0; width: 6%">Rozdział</td>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 4px 4px 0; width: 6%">Paragraf</td>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 0 4px 0">Uwaga</td>
							</tr>
							<xsl:for-each select="DochodyPozycje/Pozycja[child::Uwagi]">
								<xsl:sort select="Dzial"/>
								<xsl:sort select="Rozdzial"/>
								<xsl:sort select="Paragraf"/>
								<tr>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="'G'"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="Dzial"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="Rozdzial"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="concat(Paragraf, P4)"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:value-of select="Uwagi"/>
									</td>
								</tr>
							</xsl:for-each>
							<xsl:if test="DochodyPodsumowanie/Pozycja[child::Kod = 'H' and child::Uwagi]">
								<tr>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="DochodyPodsumowanie/Pozycja[child::Kod = 'H']/Kod"/>
									</td>
									<td colspan="3" class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="'Razem'"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:value-of select="DochodyPodsumowanie/Pozycja[child::Kod = 'H']/Uwagi"/>
									</td>
								</tr>
							</xsl:if>
							<xsl:if test="DochodyPodsumowanie/Pozycja[child::Kod = 'K' and child::Symbol = '150' and child::Uwagi]">
								<tr>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="DochodyPodsumowanie/Pozycja[child::Kod = 'K' and child::Symbol = '150']/Kod"/>
									</td>
									<td colspan="3" class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="'150 (Stan środków pieniężnych na początek okresu sprawozdawczego)'"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:value-of select="DochodyPodsumowanie/Pozycja[child::Kod = 'K' and child::Symbol = '150']/Uwagi"/>
									</td>
								</tr>
							</xsl:if>
							<xsl:if test="DochodyPodsumowanie/Pozycja[child::Kod = 'L' and child::Symbol = '190' and child::Uwagi]">
								<tr>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="DochodyPodsumowanie/Pozycja[child::Kod = 'L' and child::Symbol = '190']/Kod"/>
									</td>
									<td colspan="3" class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="'190 Ogółem (H+K150)'"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:value-of select="DochodyPodsumowanie/Pozycja[child::Kod = 'L' and child::Symbol = '190']/Uwagi"/>
									</td>
								</tr>
							</xsl:if>
						</tbody>
					</table>
				</xsl:if>
				<xsl:if test="WydatkiPozycje/Pozycja[child::Uwagi] or WydatkiPodsumowanie/Pozycja[child::Uwagi]">
					<table cellpadding="0" cellspacing="0" class="all-bold" style="margin-bottom: 20px; width: 58%">
						<tbody>
							<tr>
								<td colspan="5" style="text-align: center; font-size: 9pt; font-weight: bold; padding: 3px 10px">
									<div>Uwagi do części: "Wydatki"</div>
								</td>
							</tr>
							<tr>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 4px 4px 0; width: 5%">Kod pozycji</td>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 4px 4px 0; width: 5%">Dział</td>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 4px 4px 0; width: 5%">Rozdział</td>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 4px 4px 0; width: 5%">Paragraf</td>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 0 4px 0">Uwaga</td>
							</tr>
							<xsl:for-each select="WydatkiPozycje/Pozycja[child::Uwagi]">
								<xsl:sort select="Dzial"/>
								<xsl:sort select="Rozdzial"/>
								<xsl:sort select="Paragraf"/>
								<tr>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="'M'"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="Dzial"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="Rozdzial"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="concat(Paragraf, P4)"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:value-of select="Uwagi"/>
									</td>
								</tr>
							</xsl:for-each>
							<xsl:if test="WydatkiPodsumowanie/Pozycja[child::Kod = 'N' and child::Uwagi]">
								<tr>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="WydatkiPodsumowanie/Pozycja[child::Kod = 'N']/Kod"/>
									</td>
									<td colspan="3" class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="'Razem'"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:value-of select="WydatkiPodsumowanie/Pozycja[child::Kod = 'N']/Uwagi"/>
									</td>
								</tr>
							</xsl:if>
							<xsl:if test="WydatkiPodsumowanie/Pozycja[child::Kod = 'P' and child::Symbol = '150' and child::Uwagi]">
								<tr>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="WydatkiPodsumowanie/Pozycja[child::Kod = 'P' and child::Symbol = '150']/Kod"/>
									</td>
									<td colspan="3" class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="'150 (Stan środków pieniężnych na koniec okresu sprawozdawczego)'"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:value-of select="WydatkiPodsumowanie/Pozycja[child::Kod = 'P' and child::Symbol = '150']/Uwagi"/>
									</td>
								</tr>
							</xsl:if>
							<xsl:if test="WydatkiPodsumowanie/Pozycja[child::Kod = 'S' and child::Symbol = '190' and child::Uwagi]">
								<tr>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="WydatkiPodsumowanie/Pozycja[child::Kod = 'S' and child::Symbol = '190']/Kod"/>
									</td>
									<td colspan="3" class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="'190 Ogółem (N+P150)'"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:value-of select="WydatkiPodsumowanie/Pozycja[child::Kod = 'S' and child::Symbol = '190']/Uwagi"/>
									</td>
								</tr>
							</xsl:if>
						</tbody>
					</table>
				</xsl:if>
				<xsl:if test="Stan/Pozycja[child::Uwagi]">
					<table cellpadding="0" cellspacing="0" class="all-bold" style="margin-bottom: 20px; width: 58%">
						<tbody>
							<tr>
								<td colspan="4" style="text-align: center; font-size: 9pt; font-weight: bold; padding: 3px 10px">
									<div>Uwagi do części: "Stan"</div>
								</td>
							</tr>
							<tr>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 4px 4px 0; width: 4%">Kod</td>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 4px 4px 0; width: 6%">Symbol</td>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 4px 4px 0; width: 30%">Wyszczególnienie</td>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 0 4px 0">Uwaga</td>
							</tr>
							<xsl:for-each select="Stan/Pozycja[child::Uwagi]">
								<xsl:sort select="Symbol"/>
								<tr>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="Kod"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:center; padding: 3px 10px">
										<xsl:value-of select="Symbol"/>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:choose>
											<xsl:when test="Symbol = '020'">Należności netto</xsl:when>
											<xsl:when test="Symbol = '021'">Kwota odpisu aktualizującego należności</xsl:when>
											<xsl:when test="Symbol = '022'">Kwota odsetek od należności niezapłaconych w terminie</xsl:when>
											<xsl:when test="Symbol = '040'">Zobowiązania</xsl:when>
										</xsl:choose>
									</td>
									<td class="bottom-right-normal" style="font-size:8pt;text-align:left; padding: 3px 10px">
										<xsl:value-of select="Uwagi"/>
									</td>
								</tr>
							</xsl:for-each>
						</tbody>
					</table>
				</xsl:if>
				<table cellpadding="0" cellspacing="0" style="margin-bottom: 0px; margin-top: 80px; width: 70%">
					<tbody>
						<tr>
							<td style="text-align:left; font-size: 8pt;" valign="bottom">
								<hr style="width: 55%; text-align:left"/>
								<div style="margin-left:10px">Główny księgowy albo Skarbnik</div>
								<div style="margin-left:80px;margin-top:10px">data</div>
							</td>
							<td style="text-align:right; font-size: 8pt;" valign="bottom">
								<hr style="width: 50%;margin-left: 330px"/>
								<div>Kierownik jednostki albo Przewodniczący zarządu</div>
								<div style="margin-top:10px; margin-right:110px">data</div>
							</td>
						</tr>
					</tbody>
				</table>
			</div>
			<xsl:element name="a">
				<xsl:attribute name="href"><xsl:value-of select="concat('#Jed', $jedIndex)"/></xsl:attribute>
				<xsl:element name="style">
					<xsl:value-of select="'font-family: Verdana'"/>
				</xsl:element>
				<xsl:value-of select="'Powrót do listy sprawozdań jednostki'"/>
			</xsl:element>
		</xsl:element>
	</xsl:template>
	<!-- Rb-34s szablony pomocnicze -->
	<xsl:template match="Rb-34s/DochodyPodsumowanie">
		<xsl:variable name="Dzialy" select="parent::*/DochodyPozycje/Pozycja/Dzial"/>
		<xsl:variable name="Rozdzialy" select="parent::*/DochodyPozycje/Pozycja/Rozdzial"/>
		<xsl:variable name="Paragrafy" select="parent::*/DochodyPozycje/Pozycja/Paragraf"/>
		<xsl:variable name="P4" select="parent::*/DochodyPozycje/Pozycja/P4"/>
		<tr>
			<td class="bottom-right-normal" style="text-align: center; font-size: 8pt; font-weight: bold">
				<xsl:value-of select="'H'"/>
			</td>
			<td colspan="3" class="bottom-right-normal" style="text-align: center; font-size: 9pt; font-weight: bold">
				<xsl:value-of select="'RAZEM '"/>
			</td>
			<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; font-weight: bold; padding: 3px">
				<xsl:choose>
					<xsl:when test="Pozycja[child::Kod = 'H']/P">
						<xsl:value-of select="format-number(Pozycja[child::Kod = 'H']/P, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
			<td class="bottom-normal" style="text-align: right; font-size: 8pt; font-weight: bold; padding: 3px">
				<xsl:choose>
					<xsl:when test="Pozycja[child::Kod = 'H']/W">
						<xsl:value-of select="format-number(Pozycja[child::Kod = 'H']/W, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
		</tr>
		<tr>
			<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
				<xsl:value-of select="'K'"/>
			</td>
			<td colspan="3" class="bottom-right-normal" style="text-align: center; font-size: 8pt">
				<xsl:value-of select="'150 (Stan środków pieniężnych na początek okresu sprawozdawczego)'"/>
			</td>
			<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; padding: 3px">
				<xsl:choose>
					<xsl:when test="Pozycja[child::Kod = 'K' and child::Symbol='150']/P">
						<xsl:value-of select="format-number(Pozycja[child::Kod = 'K' and child::Symbol='150']/P, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
			<td class="bottom-normal" style="text-align: right; font-size: 8pt; padding: 3px">
				<xsl:choose>
					<xsl:when test="Pozycja[child::Kod = 'K' and child::Symbol='150']/W">
						<xsl:value-of select="format-number(Pozycja[child::Kod = 'K' and child::Symbol='150']/W, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
		</tr>
		<tr>
			<td class="bottom-right-normal" style="text-align: center; font-size: 8pt; font-weight: bold">
				<xsl:value-of select="'L'"/>
			</td>
			<td colspan="3" class="bottom-right-normal" style="text-align: center; font-size: 8pt; font-weight: bold">
				<xsl:value-of select="'190 Ogółem (H+K150)'"/>
			</td>
			<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; font-weight: bold; padding: 3px">
				<xsl:choose>
					<xsl:when test="Pozycja[child::Kod = 'L' and child::Symbol = '190']/P">
						<xsl:value-of select="format-number(Pozycja[child::Kod = 'L' and child::Symbol = '190']/P, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
			<td class="bottom-normal" style="text-align: right; font-size: 8pt; font-weight: bold; padding: 3px">
				<xsl:choose>
					<xsl:when test="Pozycja[child::Kod = 'L' and child::Symbol = '190']/W">
						<xsl:value-of select="format-number(Pozycja[child::Kod = 'L' and child::Symbol = '190']/W, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
		</tr>
	</xsl:template>
	<xsl:template match="Rb-34s/WydatkiPodsumowanie">
		<xsl:variable name="Dzialy" select="parent::*/WydatkiPozycje/Pozycja/Dzial"/>
		<xsl:variable name="Rozdzialy" select="parent::*/WydatkiPozycje/Pozycja/Rozdzial"/>
		<xsl:variable name="Paragrafy" select="parent::*/WydatkiPozycje/Pozycja/Paragraf"/>
		<xsl:variable name="P4" select="parent::*/WydatkiPozycje/Pozycja/P4"/>
		<tr>
			<td class="bottom-right-normal" style="text-align: center; font-size: 8pt; font-weight: bold">
				<xsl:value-of select="'N'"/>
			</td>
			<td colspan="4" class="bottom-right-normal" style="text-align: center; font-size: 9pt; font-weight: bold">
				<xsl:value-of select="'RAZEM '"/>
			</td>
			<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; font-weight: bold; padding: 3px">
				<xsl:choose>
					<xsl:when test="Pozycja[child::Kod = 'N']/P">
						<xsl:value-of select="format-number(Pozycja[child::Kod = 'N']/P, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
			<td class="bottom-normal" style="text-align: right; font-size: 8pt; font-weight: bold; padding: 3px">
				<xsl:choose>
					<xsl:when test="Pozycja[child::Kod = 'N']/W">
						<xsl:value-of select="format-number(Pozycja[child::Kod = 'N']/W, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
		</tr>
		<tr>
			<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
				<xsl:value-of select="'P'"/>
			</td>
			<td colspan="4" class="bottom-right-normal" style="text-align: center; font-size: 8pt">
				<xsl:value-of select="'150 (Stan środków pieniężnych na koniec okresu sprawozdawczego)'"/>
			</td>
			<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; padding: 3px">
				<xsl:choose>
					<xsl:when test="Pozycja[child::Kod = 'P' and child::Symbol='150']/P">
						<xsl:value-of select="format-number(Pozycja[child::Kod = 'P' and child::Symbol='150']/P, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
			<td class="bottom-normal" style="text-align: right; font-size: 8pt; padding: 3px">
				<xsl:choose>
					<xsl:when test="Pozycja[child::Kod = 'P' and child::Symbol='150']/W">
						<xsl:value-of select="format-number(Pozycja[child::Kod = 'P' and child::Symbol='150']/W, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
		</tr>
		<tr>
			<td class="bottom-right-normal" style="text-align: center; font-size: 8pt; font-weight: bold">
				<xsl:value-of select="'S'"/>
			</td>
			<td colspan="4" class="bottom-right-normal" style="text-align: center; font-size: 8pt; font-weight: bold">
				<xsl:value-of select="'190 Ogółem (N+P150)'"/>
			</td>
			<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; font-weight: bold; padding: 3px">
				<xsl:choose>
					<xsl:when test="Pozycja[child::Kod = 'S' and child::Symbol='190']/P">
						<xsl:value-of select="format-number(Pozycja[child::Kod = 'S' and child::Symbol='190']/P, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
			<td class="bottom-normal" style="text-align: right; font-size: 8pt; font-weight: bold; padding: 3px">
				<xsl:choose>
					<xsl:when test="Pozycja[child::Kod = 'S' and child::Symbol='190']/W">
						<xsl:value-of select="format-number(Pozycja[child::Kod = 'S' and child::Symbol='190']/W, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
		</tr>
	</xsl:template>
	<xsl:template name="Rb-34S_pozycjeWydatkowe">
		<tr>
			<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
				<xsl:value-of select="'M'"/>
			</td>
			<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
				<xsl:value-of select="Dzial"/>
			</td>
			<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
				<xsl:value-of select="Rozdzial"/>
			</td>
			<td class="bottom-right-normal" style="text-align:center;font-size:8pt;">
				<xsl:choose>
					<xsl:when test="translate(string(../../Naglowek/DostepneGrupyParagrafow), 'TRUE', 'true' ) = 'true'">
						<xsl:value-of select="Grupa"/>
					</xsl:when>
				</xsl:choose>
			</td>
			<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
				<xsl:value-of select="concat(Paragraf, P4)"/>
			</td>
			<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; padding: 3px">
				<xsl:choose>
					<xsl:when test="P">
						<xsl:value-of select="format-number(P, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
			<td class="bottom-normal" style="text-align: right; font-size: 8pt; padding: 3px">
				<xsl:choose>
					<xsl:when test="W">
						<xsl:value-of select="format-number(W, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
		</tr>
	</xsl:template>
	<xsl:template name="Rb-34s_danePozycjeC">
		<xsl:param name="kod"/>
		<xsl:param name="symbol"/>
		<xsl:param name="wyszczeg"/>
		<xsl:param name="annotation"/>
		<xsl:param name="ostWiersz" select="false()"/>
		<tr>
			<xsl:element name="td">
				<xsl:attribute name="style"><xsl:value-of select="'text-align: center; font-size: 8pt'"/></xsl:attribute>
				<xsl:attribute name="class"><xsl:choose><xsl:when test="$ostWiersz = false()"><xsl:value-of select="'bottom-right-normal'"/></xsl:when><xsl:otherwise><xsl:value-of select="'right-normal'"/></xsl:otherwise></xsl:choose></xsl:attribute>
				<xsl:value-of select="$kod"/>
			</xsl:element>
			<xsl:element name="td">
				<xsl:attribute name="style"><xsl:value-of select="'text-align: center; font-size: 8pt'"/></xsl:attribute>
				<xsl:attribute name="class"><xsl:choose><xsl:when test="$ostWiersz = false()"><xsl:value-of select="'bottom-right-normal'"/></xsl:when><xsl:otherwise><xsl:value-of select="'right-normal'"/></xsl:otherwise></xsl:choose></xsl:attribute>
				<xsl:value-of select="$symbol"/>
			</xsl:element>
			<xsl:element name="td">
				<xsl:attribute name="style"><xsl:value-of select="'text-align: left; font-size: 8pt; padding: 3px'"/></xsl:attribute>
				<xsl:attribute name="class"><xsl:choose><xsl:when test="$ostWiersz = false()"><xsl:value-of select="'bottom-right-normal'"/></xsl:when><xsl:otherwise><xsl:value-of select="'right-normal'"/></xsl:otherwise></xsl:choose></xsl:attribute>
				<xsl:value-of select="$wyszczeg"/>
				<xsl:if test="$annotation">
					<sup>
						<xsl:value-of select="number($annotation)"/>)
				</sup>
				</xsl:if>
			</xsl:element>
			<xsl:element name="td">
				<xsl:attribute name="style"><xsl:value-of select="'text-align: right; font-size: 8pt; padding: 3px'"/></xsl:attribute>
				<xsl:attribute name="class"><xsl:choose><xsl:when test="$ostWiersz = false()"><xsl:value-of select="'bottom-right-normal'"/></xsl:when><xsl:otherwise><xsl:value-of select="'right-normal'"/></xsl:otherwise></xsl:choose></xsl:attribute>
				<xsl:choose>
					<xsl:when test="Stan/Pozycja[child::Kod = $kod and child::Symbol = $symbol]/P">
						<xsl:value-of select="format-number(Stan/Pozycja[child::Kod = $kod and child::Symbol = $symbol]/P, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:element>
			<xsl:element name="td">
				<xsl:attribute name="style"><xsl:value-of select="'text-align: right; font-size: 8pt; padding: 3px'"/></xsl:attribute>
				<xsl:if test="$ostWiersz = false()">
					<xsl:attribute name="class"><xsl:value-of select="'bottom-normal'"/></xsl:attribute>
				</xsl:if>
				<xsl:choose>
					<xsl:when test="Stan/Pozycja[child::Kod = $kod and child::Symbol = $symbol]/K">
						<xsl:value-of select="format-number(Stan/Pozycja[child::Kod = $kod and child::Symbol = $symbol]/K, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:element>
		</tr>
	</xsl:template>
	<!-- Rb-27ZZ -->
	<xsl:template match="Rb-27ZZ">
		<xsl:param name="jedIndex"/>
		<xsl:param name="sprIndex"/>
		<xsl:param name="polIndex"/>
		<xsl:element name="div">
			<xsl:attribute name="Id"><xsl:value-of select="concat('Jed', $jedIndex, 'Wer', $sprIndex)"/></xsl:attribute>
			<xsl:attribute name="style"><xsl:value-of select="'display: block; margin-bottom: 40px'"/></xsl:attribute>
			<div style="font-size: 12pt; font-weight: bold; margin-left: 5px; margin-bottom: 10px">
        Sprawozdanie Rb-27ZZ:
        <xsl:choose>
					<xsl:when test="Naglowek/Wersja = 0">
						<xsl:value-of select="'wersja pierwotna'"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="concat('korekta nr ', Naglowek/Wersja)"/>
					</xsl:otherwise>
				</xsl:choose>
				<xsl:call-template name="SprNaglowekInfo"/>
			</div>
			<table cellpadding="0" cellspacing="0" class="all-bold" style="margin-bottom: 30px">
				<tbody>
					<tr style="height: 18px">
						<td colspan="9" class="bottom-bold" style="font-size: 10pt;">MINISTERSTWO FINANSÓW, ul. Świętokrzyska 12, 00-916 Warszawa</td>
					</tr>
					<tr style="height: 127px; width: 300px">
						<td class="bottom-bold" style="width: 300px">
							<table cellpadding="0" cellspacing="0" style="border-collapse: collapse; height" width="100%">
								<tbody>
									<tr style="height: 80px">
										<div style="font-size: 9pt"> Nazwa i adres jednostki sprawozdawczej: </div>
									</tr>
									<tr>
										<td class="bottom-normal" style="text-align: center; font-size: 9pt" valign="bottom">
											<!-- popr. nr I.8 -->
											<div style="display: block;margin: 0 20px">
												<xsl:choose>
													<xsl:when test="Jednostka/Nazwa">
														<xsl:value-of select="Jednostka/Nazwa"/>
													</xsl:when>
													<xsl:otherwise>
														<xsl:value-of select="../../Nazwa"/>
													</xsl:otherwise>
												</xsl:choose>
											</div>
										</td>
									</tr>
									<tr style="height: 23px">
										<td style="text-align: left; font-size: 9pt; margin:1px 1px 0 0; padding:0;" valign="top">
                      Numer identyfikacyjny REGON:
                    </td>
									</tr>
									<tr>
										<td style="text-align: center; font-size: 9pt; font-weight: bold; margin:1px 1px 0 0; padding:0" valign="baseline">
											<xsl:choose>
												<xsl:when test="Jednostka/Regon">
													<xsl:value-of select="Jednostka/Regon"/>
												</xsl:when>
												<xsl:otherwise>
													<xsl:value-of select="../../Regon"/>
												</xsl:otherwise>
											</xsl:choose>
										</td>
									</tr>
								</tbody>
							</table>
						</td>
						<td colspan="7" class="notop-bold" valign="top" style="width: 491px">
							<div style="font-weight: bold; text-align: center; font-size: 11pt; margin-bottom: 5px">Rb-27ZZ</div>
							<div style="font-weight: bold; text-align: center; font-size: 11pt; margin-bottom: 5px">sprawozdanie z wykonania planu dochodów związanych z realizacją zadań z zakresu administracji rządowej oraz innych zadań zleconych jednostkom samorządu terytorialnego ustawami</div>
							<div style="font-weight: bold; text-align: center; font-size: 11pt; margin-bottom: 5px">
								<br/>okres sprawozdawczy:
              </div>
							<div style="vertical-align: bottom; text-align: center; font-size: 9pt; margin-top: 20px">
								<xsl:call-template name="NaglowekSprOkresRb27zz"/>
							</div>
						</td>
						<td style="text-align: left; font-size: 9pt; margin:1px 1px 0 0; padding:0; width: 265px" valign="top">
							<div style="margin-bottom:5px">Adresat:</div>
							<!-- popr. nr I.9 -->
							<div style="text-align:center; margin-bottom: 15px;">
								<!-- <xsl:value-of select="'Regionalna Izba Obrachunkowa w Katowicach'"/> -->
							</div>
							<div style="text-align:center;">
								<!-- <xsl:value-of select="'wersja robocza'"/> -->
							</div>
						</td>
					</tr>
					<tr style="height: 54px">
						<td rowspan="3" class="right-normal" style="font-size: 9pt">
							<!-- popr. nr I.10 -->
							<div style="margin-bottom: 1px">
								<xsl:value-of select="'Nazwa województwa '"/>
								<sup>1)</sup>
								<!-- <xsl:if test="../../Typ = 'W'">
									<span style="margin-left: 10px">
										<b>
											<xsl:value-of select="../../Nazwa"/>
										</b>
									</span>
								</xsl:if> -->
							</div>
							<div style="margin-bottom: 1px">
								<xsl:value-of select="'Nazwa powiatu / związku '"/>
								<sup>1)</sup>
								<!-- <xsl:if test="../../Typ = 'P'">
									<span style="margin-left: 10px">
										<b>
											<xsl:value-of select="../../Nazwa"/>
										</b>
									</span>
								</xsl:if> -->
							</div>
							<div>
								<xsl:value-of select="'Nazwa gminy / związku '"/>
								<sup>1)</sup>
								<!-- <xsl:if test="../../Typ = 'G'">
									<span style="margin-left: 10px">
										<b>
											<xsl:value-of select="../../Nazwa"/>
										</b>
									</span>
								</xsl:if> -->
							</div>
						</td>
						<td colspan="7" class="bottom-right-normal" style="font-size:10pt; text-align:center">SYMBOLE</td>
						<td rowspan="3" style="font-size:9pt; text-align:right">
							<div style="margin-right: 15px;margin-top:70px; border-style: solid; border-width: 1 0px 0px 0; border-color: black;">Przed wypełnieniem przeczytać instrukcję</div>
						</td>
					</tr>
					<tr>
						<td class="bottom-right-normal" style="font-size:10pt; text-align:center">WOJ.</td>
						<td class="bottom-right-normal" style="font-size:10pt; text-align:center">POWIAT</td>
						<td class="bottom-right-normal" style="font-size:10pt; text-align:center">GMINA</td>
						<td class="bottom-right-normal" style="font-size:10pt; text-align:center">TYP GM.</td>
						<td class="bottom-right-normal" style="font-size:10pt; text-align:center">ZWIĄZEK JST</td>
						<td class="bottom-right-normal" style="font-size:10pt; text-align:center">TYP ZW.</td>
						<td class="bottom-right-normal" style="font-size:10pt; text-align:center">CZĘŚĆ</td>
					</tr>
					<tr>
						<td class="right-normal" style="font-size:10pt; text-align:center">
							<xsl:choose>
								<xsl:when test="Jednostka/WK">
									<xsl:value-of select="Jednostka/WK"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="../../WK"/>
								</xsl:otherwise>
							</xsl:choose>
						</td>
						<td class="right-normal" style="font-size:10pt; text-align:center">
							<xsl:choose>
								<xsl:when test="Jednostka/PK">
									<xsl:value-of select="Jednostka/PK"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="../../PK"/>
								</xsl:otherwise>
							</xsl:choose>
						</td>
						<td class="right-normal" style="font-size:10pt; text-align:center">
							<xsl:choose>
								<xsl:when test="Jednostka/GK">
									<xsl:value-of select="Jednostka/GK"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="../../GK"/>
								</xsl:otherwise>
							</xsl:choose>
						</td>
						<td class="right-normal" style="font-size:10pt; text-align:center">
							<xsl:choose>
								<xsl:when test="Jednostka/GT">
									<xsl:value-of select="Jednostka/GT"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="../../GT"/>
								</xsl:otherwise>
							</xsl:choose>
						</td>
						<td class="right-normal" style="font-size:10pt; text-align:center">
							<xsl:choose>
								<xsl:when test="Jednostka/KodMSWiA">
									<xsl:value-of select="Jednostka/KodMSWiA"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:choose>
										<xsl:when test="../../KodMSWiA">
											<xsl:value-of select="../../KodMSWiA"/>
										</xsl:when>
										<xsl:otherwise>
											<xsl:value-of select="$nbsp"/>
										</xsl:otherwise>
									</xsl:choose>
								</xsl:otherwise>
							</xsl:choose>
						</td>
						<td class="right-normal" style="font-size:10pt; text-align:center">
							<xsl:value-of select="$nbsp"/>
						</td>
						<td class="right-normal" style="font-size:10pt; text-align:center">
							<xsl:value-of select="Naglowek/DysponentDotacji"/>
						</td>
					</tr>
				</tbody>
			</table>
			<div style="display: block; margin-bottom: 40px">
				<table cellpadding="0" cellspacing="0" class="all-bold">
					<tbody>
						<tr>
							<td colspan="3" style="font-size: 9pt; text-align: center" class="bottom-bold">Klasyfikacja budżetowa</td>
							<td rowspan="4" style="font-size: 9pt; width: 95px; text-align: center" class="notop-bold">Plan</td>
							<td rowspan="4" style="font-size: 9pt; width: 95px; text-align: center" class="bottom-right-mixed">
								<div style="margin-bottom: 5px">Należności</div>
								<div style="font-size: 7pt">(saldo początkowe plus przypisy minus odpisy)</div>
							</td>
							<td colspan="2" style="font-size: 9pt; text-align: center" class="bottom-right-normal">Dochody wykonane</td>
							<td rowspan="4" style="font-size: 9pt; width: 105px; text-align: center" class="bottom-right-mixed">Dochody przekazane</td>
							<td colspan="3" style="font-size: 9pt; border-style: solid; border-width: 0 4px 1px 0; border-color: black; text-align: center">Saldo końcowe</td>
						</tr>
						<tr>
							<td rowspan="3" style="font-size:9pt" class="bottom-right-mixed">dział</td>
							<td rowspan="3" style="font-size:9pt" class="bottom-right-mixed">rozdział</td>
							<td rowspan="3" style="font-size:9pt" class="bottom-right-bold">paragraf</td>
							<td rowspan="3" style="font-size:8pt; text-align: center; width: 140px" class="bottom-bold">ogółem</td>
							<td style="font-size:8pt; width: 120px; max-width: 140px" class="right-normal">w tym:</td>
							<td colspan="2" style="font-size:8pt; text-align: center" class="bottom-right-normal">należności pozostałe do zapłaty</td>
							<td rowspan="3" style="font-size:8pt; text-align: center; width: 100px" class="bottom-bold">nadpłaty</td>
						</tr>
						<tr>
							<td rowspan="2" style="text-align: center; font-size:8pt; border-width: 1px 1px 4px 1px" class="all-normal">potrącone na rzecz jednostek samorządu terytorialnego</td>
							<td rowspan="2" style="text-align: center; font-size:8pt; width: 90px; min-width: 80px" class="bottom-bold">ogółem</td>
							<td style="font-size:8pt; width: 90px; min-width: 80px" class="right-normal">w tym:</td>
						</tr>
						<tr>
							<td style="font-size:8pt; text-align: center; border-width: 1px 1px 4px 1px" class="all-normal">zaległości</td>
						</tr>
						<tr>
							<td class="bottom-right-bold" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="1"/>
							</td>
							<td class="bottom-right-bold" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="2"/>
							</td>
							<td class="bottom-right-bold" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="3"/>
							</td>
							<td class="bottom-right-bold" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="4"/>
							</td>
							<td class="bottom-right-bold" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="5"/>
							</td>
							<td class="bottom-right-bold" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="6"/>
							</td>
							<td class="bottom-right-bold" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="7"/>
							</td>
							<td class="bottom-right-bold" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="8"/>
							</td>
							<td class="bottom-right-bold" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="9"/>
							</td>
							<td class="bottom-right-bold" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="10"/>
							</td>
							<td class="bottom-bold" style="text-align:center; font-size: 9pt">
								<xsl:value-of select="11"/>
							</td>
						</tr>
						<xsl:call-template name="Rb-27ZZ_Pozycje">
							<xsl:with-param name="jedIndex" select="$jedIndex"/>
							<xsl:with-param name="sprIndex" select="$sprIndex"/>
							<xsl:with-param name="polIndex" select="$polIndex"/>
						</xsl:call-template>
						<xsl:for-each select="Pozycje/Pozycja[generate-id(.) = generate-id(key('kluczRb27ZZDzial', concat(count(ancestor::Jednostka/preceding-sibling::Jednostka), count(ancestor::Rb-27ZZ/preceding-sibling::Rb-27ZZ), Dzial))[1])]">
							<xsl:sort select="Dzial" order="ascending"/>
							<xsl:variable name="obecDzial" select="Dzial"/>
							<xsl:variable name="WezlyDzial" select="/PaczkaSprawozdan/Jednostki/Jednostka[position()=$jedIndex]/Sprawozdania/child::*[position() = $polIndex]/Pozycje/Pozycja[child::Dzial = $obecDzial]"/>
							<tr>
								<td colspan="2" class="bottom-right-normal" style="text-align:center; font-size: 8pt">zbiorczo dla działu</td>
								<td class="bottom-right-normal" style="text-align:center;font-size:8pt;">
									<xsl:value-of select="Dzial"/>
								</td>
								<td class="bottom-right-normal" style="text-align:right;font-size:8pt;padding: 3px">
									<xsl:value-of select="format-number(sum($WezlyDzial[string(number(child::PL)) != 'NaN']/PL), '#&#160;##0,00')"/>
								</td>
								<td class="bottom-right-normal" style="text-align:right;font-size:8pt;padding: 3px">
									<xsl:value-of select="format-number(sum($WezlyDzial[string(number(child::NA)) != 'NaN']/NA), '#&#160;##0,00')"/>
								</td>
								<td class="bottom-right-normal" style="text-align:right;font-size:8pt;padding: 3px">
									<xsl:value-of select="format-number(sum($WezlyDzial[string(number(child::DW)) != 'NaN']/DW), '#&#160;##0,00')"/>
								</td>
								<td class="bottom-right-normal" style="text-align:right;font-size:8pt;padding: 3px">
									<xsl:value-of select="format-number(sum($WezlyDzial[string(number(child::DJ)) != 'NaN']/DJ), '#&#160;##0,00')"/>
								</td>
								<td class="bottom-right-normal" style="text-align:right;font-size:8pt;padding: 3px">
									<xsl:value-of select="format-number(sum($WezlyDzial[string(number(child::DP)) != 'NaN']/DP), '#&#160;##0,00')"/>
								</td>
								<td class="bottom-right-normal" style="text-align:right;font-size:8pt;padding: 3px">
									<xsl:value-of select="format-number(sum($WezlyDzial[string(number(child::NO)) != 'NaN']/NO), '#&#160;##0,00')"/>
								</td>
								<td class="bottom-right-normal" style="text-align:right;font-size:8pt;padding: 3px">
									<xsl:value-of select="format-number(sum($WezlyDzial[string(number(child::NZ)) != 'NaN']/NZ), '#&#160;##0,00')"/>
								</td>
								<td class="bottom-normal" style="text-align:right;font-size:8pt;padding: 3px">
									<xsl:value-of select="format-number(sum($WezlyDzial[string(number(child::NP)) != 'NaN']/NP), '#&#160;##0,00')"/>
								</td>
							</tr>
						</xsl:for-each>
						<tr>
							<td colspan="3" class="right-normal" style="text-align:center; font-size: 8pt">zbiorczo dla wszystkich działów</td>
							<td class="right-normal" style="text-align:right;font-size:8pt;padding: 3px">
								<xsl:value-of select="format-number(sum(Pozycje/Pozycja[string(number(child::PL)) != 'NaN']/PL), '#&#160;##0,00')"/>
							</td>
							<td class="right-normal" style="text-align:right;font-size:8pt;padding: 3px">
								<xsl:value-of select="format-number(sum(Pozycje/Pozycja[string(number(child::NA)) != 'NaN']/NA), '#&#160;##0,00')"/>
							</td>
							<td class="right-normal" style="text-align:right;font-size:8pt;padding: 3px">
								<xsl:value-of select="format-number(sum(Pozycje/Pozycja[string(number(child::DW)) != 'NaN']/DW), '#&#160;##0,00')"/>
							</td>
							<td class="right-normal" style="text-align:right;font-size:8pt;padding: 3px">
								<xsl:value-of select="format-number(sum(Pozycje/Pozycja[string(number(child::DJ)) != 'NaN']/DJ), '#&#160;##0,00')"/>
							</td>
							<td class="right-normal" style="text-align:right;font-size:8pt;padding: 3px">
								<xsl:value-of select="format-number(sum(Pozycje/Pozycja[string(number(child::DP)) != 'NaN']/DP), '#&#160;##0,00')"/>
							</td>
							<td class="right-normal" style="text-align:right;font-size:8pt;padding: 3px">
								<xsl:value-of select="format-number(sum(Pozycje/Pozycja[string(number(child::NO)) != 'NaN']/NO), '#&#160;##0,00')"/>
							</td>
							<td class="right-normal" style="text-align:right;font-size:8pt;padding: 3px">
								<xsl:value-of select="format-number(sum(Pozycje/Pozycja[string(number(child::NZ)) != 'NaN']/NZ), '#&#160;##0,00')"/>
							</td>
							<td style="text-align:right;font-size:8pt;padding: 3px">
								<xsl:value-of select="format-number(sum(Pozycje/Pozycja[string(number(child::NP)) != 'NaN']/NP), '#&#160;##0,00')"/>
							</td>
						</tr>
					</tbody>
				</table>
				<div style="margin-bottom: 30px">
					<div style="display: block; font-size: 7pt">
						<sup>1)</sup> niepotrzebne skreślić
          </div>
				</div>
				<div style="text-align:left; font-size: 9pt; font-weight: bold; margin-bottom: 15px;margin-left:400px">DANE UZUPEŁNIAJĄCE DO SPRAWOZDANIA RB-27ZZ</div>
				<div style="text-align:left; font-size: 8pt; margin-left: 2px; margin-bottom: 15px">A. Należności z tytułu dochodów związanych z realizacją zadań z zakresu administracji rządowej oraz innych zadań zleconych jednostkom samorządu terytorialnego ustawami w części należnej budżetowi państwa.</div>
				<table cellpadding="0" cellspacing="0" class="all-bold" style="margin-bottom: 15px">
					<tbody>
						<tr>
							<td class="bottom-right-bold" style="text-align: center; font-size: 8pt; width: 245px">
								<div>Rozdział</div>
								<div style="margin-top: 20px">(wg klasyfikacji budżetowej)</div>
							</td>
							<td class="bottom-right-mixed" style="text-align: center; font-size: 8pt; width: 245px">
								<div>Należności</div>
								<div style="margin-top: 20px">(z kol. 5 Rb-27ZZ w części dot. budżetu państwa)</div>
							</td>
							<td class="bottom-right-mixed" style="text-align: center; font-size: 8pt; width: 245px">
								<div>zaległości</div>
								<div style="margin-top: 20px">(z kol. 10 Rb-27ZZ w części dot. budżetu państwa)</div>
							</td>
							<td class="bottom-bold" style="text-align: center; font-size: 8pt; width: 245px">
								<div>nadpłaty</div>
								<div style="margin-top: 20px">(z kol. 11 Rb-27ZZ w części dot. budżetu państwa)</div>
							</td>
						</tr>
						<tr>
							<td class="bottom-right-bold" style="text-align:center; font-size: 8pt; padding: 3px">
								<xsl:value-of select="1"/>
							</td>
							<td class="bottom-right-mixed" style="text-align:center; font-size: 8pt; padding: 3px">
								<xsl:value-of select="2"/>
							</td>
							<td class="bottom-right-mixed" style="text-align:center; font-size: 8pt; padding: 3px">
								<xsl:value-of select="3"/>
							</td>
							<td class="bottom-bold" style="text-align:center; font-size: 8pt; padding: 3px">
								<xsl:value-of select="4"/>
							</td>
						</tr>
						<xsl:for-each select="NaleznosciA/Pozycja">
							<tr>
								<td class="right-bottom-mixed" style="text-align: center; font-size: 8pt">
									<xsl:value-of select="Rozdzial"/>
								</td>
								<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; padding: 3px">
									<xsl:choose>
										<xsl:when test="NA">
											<xsl:value-of select="format-number(NA, '#&#160;##0,00')"/>
										</xsl:when>
										<xsl:otherwise>
											<xsl:value-of select="'0,00'"/>
										</xsl:otherwise>
									</xsl:choose>
								</td>
								<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; padding: 3px">
									<xsl:choose>
										<xsl:when test="NZ">
											<xsl:value-of select="format-number(NZ, '#&#160;##0,00')"/>
										</xsl:when>
										<xsl:otherwise>
											<xsl:value-of select="'0,00'"/>
										</xsl:otherwise>
									</xsl:choose>
								</td>
								<td class="bottom-normal" style="text-align: right; font-size: 8pt; padding: 3px">
									<xsl:choose>
										<xsl:when test="NP">
											<xsl:value-of select="format-number(NP, '#&#160;##0,00')"/>
										</xsl:when>
										<xsl:otherwise>
											<xsl:value-of select="'0,00'"/>
										</xsl:otherwise>
									</xsl:choose>
								</td>
							</tr>
						</xsl:for-each>
						<tr>
							<td class="right-bold" style="text-align: right; font-size: 8pt; font-weight: bold; padding: 3px">Razem</td>
							<td class="right-normal" style="text-align: right; font-size: 8pt; padding: 3px">
								<xsl:value-of select="format-number(sum(NaleznosciA/Pozycja[string(number(NA)) != 'NaN']/NA), '#&#160;##0,00')"/>
							</td>
							<td class="right-normal" style="text-align: right; font-size: 8pt; padding: 3px">
								<xsl:value-of select="format-number(sum(NaleznosciA/Pozycja[string(number(NZ)) != 'NaN']/NZ), '#&#160;##0,00')"/>
							</td>
							<td style="text-align: right; font-size: 8pt; padding: 3px">
								<xsl:value-of select="format-number(sum(NaleznosciA/Pozycja[string(number(NP)) != 'NaN']/NP), '#&#160;##0,00')"/>
							</td>
						</tr>
					</tbody>
				</table>
				<div style="text-align:left; font-size: 8pt; margin-left: 2px; margin-bottom: 15px">B. Należności z tytułu dochodów związanych z realizacją zadań z zakresu administracji rządowej oraz innych zadań zleconych jednostkom samorządu terytorialnego ustawami w części należnej jednostkom samorządu terytorialnego na mocy odrębnych przepisów.</div>
				<table cellpadding="0" cellspacing="0" class="all-bold" style="margin-bottom: 60px">
					<tbody>
						<tr>
							<td class="bottom-right-bold" style="text-align: center; font-size: 8pt; width: 245px">
								<div>Rozdział</div>
								<div style="margin-top: 20px">(wg klasyfikacji budżetowej)</div>
							</td>
							<td class="bottom-right-mixed" style="text-align: center; font-size: 8pt; width: 245px">
								<div>Należności</div>
								<div style="margin-top: 20px">(z kol. 5 Rb-27ZZ w części dot. budżetu jst.)</div>
							</td>
							<td class="bottom-right-mixed" style="text-align: center; font-size: 8pt; width: 245px">
								<div>zaległości</div>
								<div style="margin-top: 20px">(z kol. 10 Rb-27ZZ w części dot. budżetu jst.)</div>
							</td>
							<td class="bottom-bold" style="text-align: center; font-size: 8pt; width: 245px">
								<div>nadpłaty</div>
								<div style="margin-top: 20px">(z kol. 11 Rb-27ZZ w części dot. budżetu jst.)</div>
							</td>
						</tr>
						<tr>
							<td class="bottom-right-bold" style="text-align:center; font-size: 8pt; padding: 3px">
								<xsl:value-of select="1"/>
							</td>
							<td class="bottom-right-mixed" style="text-align:center; font-size: 8pt; padding: 3px">
								<xsl:value-of select="2"/>
							</td>
							<td class="bottom-right-mixed" style="text-align:center; font-size: 8pt; padding: 3px">
								<xsl:value-of select="3"/>
							</td>
							<td class="bottom-bold" style="text-align:center; font-size: 8pt; padding: 3px">
								<xsl:value-of select="4"/>
							</td>
						</tr>
						<xsl:for-each select="NaleznosciB/Pozycja">
							<tr>
								<td class="right-bottom-mixed" style="text-align: center; font-size: 8pt">
									<xsl:value-of select="Rozdzial"/>
								</td>
								<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; padding: 3px">
									<xsl:choose>
										<xsl:when test="NA">
											<xsl:value-of select="format-number(NA, '#&#160;##0,00')"/>
										</xsl:when>
										<xsl:otherwise>
											<xsl:value-of select="'0,00'"/>
										</xsl:otherwise>
									</xsl:choose>
								</td>
								<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; padding: 3px">
									<xsl:choose>
										<xsl:when test="NZ">
											<xsl:value-of select="format-number(NZ, '#&#160;##0,00')"/>
										</xsl:when>
										<xsl:otherwise>
											<xsl:value-of select="'0,00'"/>
										</xsl:otherwise>
									</xsl:choose>
								</td>
								<td class="bottom-normal" style="text-align: right; font-size: 8pt; padding: 3px">
									<xsl:choose>
										<xsl:when test="NP">
											<xsl:value-of select="format-number(NP, '#&#160;##0,00')"/>
										</xsl:when>
										<xsl:otherwise>
											<xsl:value-of select="'0,00'"/>
										</xsl:otherwise>
									</xsl:choose>
								</td>
							</tr>
						</xsl:for-each>
						<tr>
							<td class="right-bold" style="text-align: right; font-size: 8pt; font-weight: bold; padding: 3px">Razem</td>
							<td class="right-normal" style="text-align: right; font-size: 8pt; padding: 3px">
								<xsl:value-of select="format-number(sum(NaleznosciB/Pozycja[string(number(NA)) != 'NaN']/NA), '#&#160;##0,00')"/>
							</td>
							<td class="right-normal" style="text-align: right; font-size: 8pt; padding: 3px">
								<xsl:value-of select="format-number(sum(NaleznosciB/Pozycja[string(number(NZ)) != 'NaN']/NZ), '#&#160;##0,00')"/>
							</td>
							<td style="text-align: right; font-size: 8pt; padding: 3px">
								<xsl:value-of select="format-number(sum(NaleznosciB/Pozycja[string(number(NP)) != 'NaN']/NP), '#&#160;##0,00')"/>
							</td>
						</tr>
					</tbody>
				</table>
				<table cellpadding="0" cellspacing="0" class="all-bold" style="margin-bottom: 20px; width: 70%">
					<tbody>
						<tr style="height: 30px" valign="top">
							<td style="font-size: 9pt; font-weight: bold; text-align:left; padding: 3px 10px; margin-left: 5px; margin-bottom: 25px">Wyjaśnienia do sprawozdania Rb-27ZZ</td>
						</tr>
						<tr style="min-height: 50px; height: 70px" valign="top">
							<td style="text-align: left; font-size: 8pt; padding: 3px 10px; border-width: 4px 0 0 0; border-style: solid; border-color: black">
								<xsl:value-of select="Naglowek/Uwagi"/>
							</td>
						</tr>
					</tbody>
				</table>
				<!-- ewentualne uwagi z pozycji -->
				<xsl:if test="Pozycje/Pozycja[child::Uwagi]">
					<table cellpadding="0" cellspacing="0" class="all-bold" style="margin-bottom: 20px; width: 100%">
						<tbody>
							<tr>
								<td colspan="4" style="text-align: center; font-size: 9pt; font-weight: bold; padding: 3px 10px">
									<div>Uwagi do pozycji</div>
								</td>
							</tr>
							<tr>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 4px 4px 0; width: 6%">Dział</td>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 4px 4px 0; width: 6%">Rozdział</td>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 4px 4px 0; width: 6%">Paragraf</td>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 0 4px 0">Uwaga</td>
							</tr>
							<xsl:for-each select="Pozycje/Pozycja[child::Uwagi]">
								<xsl:sort select="Dzial"/>
								<xsl:sort select="Rozdział"/>
								<xsl:sort select="Paragraf"/>
								<tr>
									<xsl:choose>
										<xsl:when test="position() != last()">
											<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
												<xsl:value-of select="Dzial"/>
											</td>
											<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
												<xsl:value-of select="Rozdzial"/>
											</td>
											<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
												<xsl:value-of select="concat(Paragraf, P4)"/>
											</td>
											<td class="bottom-normal" style="text-align: left; font-size: 8pt; padding: 3px">
												<xsl:value-of select="Uwagi"/>
											</td>
										</xsl:when>
										<xsl:otherwise>
											<td class="right-normal" style="text-align: center; font-size: 8pt">
												<xsl:value-of select="Dzial"/>
											</td>
											<td class="right-normal" style="text-align: center; font-size: 8pt">
												<xsl:value-of select="Rozdzial"/>
											</td>
											<td class="right-normal" style="text-align: center; font-size: 8pt">
												<xsl:value-of select="concat(Paragraf, P4)"/>
											</td>
											<td style="text-align: left; font-size: 8pt; padding: 3px">
												<xsl:value-of select="Uwagi"/>
											</td>
										</xsl:otherwise>
									</xsl:choose>
								</tr>
							</xsl:for-each>
						</tbody>
					</table>
				</xsl:if>
				<xsl:if test="NaleznosciA/Pozycja[child::Uwagi]">
					<table cellpadding="0" cellspacing="0" class="all-bold" style="margin-bottom: 20px; width: 100%">
						<tbody>
							<tr>
								<td colspan="4" style="text-align: center; font-size: 9pt; font-weight: bold; padding: 3px 10px">
									<div>Uwagi do pozycji uzupełniających danych części A</div>
								</td>
							</tr>
							<tr>
								<td colspan="3" style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 4px 4px 0; width: 10%">Rozdział</td>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 0 4px 0">Uwaga</td>
							</tr>
							<xsl:for-each select="NaleznosciA/Pozycja[child::Uwagi]">
								<xsl:sort select="Dzial"/>
								<xsl:sort select="Rozdział"/>
								<xsl:sort select="Paragraf"/>
								<tr>
									<xsl:choose>
										<xsl:when test="position() != last()">
											<td colspan="3" class="bottom-right-normal" style="text-align: center; font-size: 8pt">
												<xsl:value-of select="Rozdzial"/>
											</td>
											<td class="bottom-normal" style="text-align: left; font-size: 8pt; padding: 3px">
												<xsl:value-of select="Uwagi"/>
											</td>
										</xsl:when>
										<xsl:otherwise>
											<td colspan="3" class="right-normal" style="text-align: center; font-size: 8pt">
												<xsl:value-of select="Rozdzial"/>
											</td>
											<td style="text-align: left; font-size: 8pt; padding: 3px">
												<xsl:value-of select="Uwagi"/>
											</td>
										</xsl:otherwise>
									</xsl:choose>
								</tr>
							</xsl:for-each>
						</tbody>
					</table>
				</xsl:if>
				<xsl:if test="NaleznosciB/Pozycja[child::Uwagi]">
					<table cellpadding="0" cellspacing="0" class="all-bold" style="margin-bottom: 20px; width: 100%">
						<tbody>
							<tr>
								<td colspan="4" style="text-align: center; font-size: 9pt; font-weight: bold; padding: 3px 10px">
									<div>Uwagi do pozycji uzupełniających danych części B</div>
								</td>
							</tr>
							<tr>
								<td colspan="3" style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 4px 4px 0; width: 10%">Rozdział</td>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 0 4px 0">Uwaga</td>
							</tr>
							<xsl:for-each select="NaleznosciB/Pozycja[child::Uwagi]">
								<xsl:sort select="Dzial"/>
								<xsl:sort select="Rozdział"/>
								<xsl:sort select="Paragraf"/>
								<tr>
									<xsl:choose>
										<xsl:when test="position() != last()">
											<td colspan="3" class="bottom-right-normal" style="text-align: center; font-size: 8pt">
												<xsl:value-of select="Rozdzial"/>
											</td>
											<td class="bottom-normal" style="text-align: left; font-size: 8pt; padding: 3px">
												<xsl:value-of select="Uwagi"/>
											</td>
										</xsl:when>
										<xsl:otherwise>
											<td colspan="3" class="right-normal" style="text-align: center; font-size: 8pt">
												<xsl:value-of select="Rozdzial"/>
											</td>
											<td style="text-align: left; font-size: 8pt; padding: 3px">
												<xsl:value-of select="Uwagi"/>
											</td>
										</xsl:otherwise>
									</xsl:choose>
								</tr>
							</xsl:for-each>
						</tbody>
					</table>
				</xsl:if>
				<table cellpadding="0" cellspacing="0" style="margin-bottom: 50px; margin-top: 80px; width: 80%">
					<tbody>
						<tr>
							<td style="text-align:center; font-size: 8pt;" valign="bottom" width="25%">
								<hr style="width: 90%;text-align:center; "/>
								<div style="text-align:center;">Główny księgowy albo Skarbnik</div>
							</td>
							<td/>
							<td style="text-align:center; font-size: 8pt;" valign="bottom" width="25%">
								<hr style="width: 90%;text-align:center"/>
								<div style="text-align:center;">Kierownik jednostki albo Przewodniczący zarządu</div>
							</td>
						</tr>
						<tr>
							<td style="text-align:center; font-size: 8pt;">
								<div>
									<xsl:for-each select="../../Podpisy/*[name() = 'ds:Signature']">
										<xsl:if test="contains(@Id, 'Rb27ZZ')">
											<xsl:if test="contains(translate(*[name() = 'ds:Object']/*[name() = 'xades:QualifyingProperties']/*[name() = 'xades:SignedProperties']/*[name() = 'xades:SignedSignatureProperties']/*[name() = 'xades:SignerRole']/*[name() = 'xades:ClaimedRoles']/*[name() = 'xades:ClaimedRole']/*[name() = 'Role'], 'S','s'),'skarbnik')">
												<xsl:value-of select="substring(*[name() = 'ds:Object']/*[name() = 'xades:QualifyingProperties']/*[name() = 'xades:SignedProperties']/*[name() = 'xades:SignedSignatureProperties']/*[name() = 'xades:SigningTime'], 1, 10)"/>
											</xsl:if>
										</xsl:if>
									</xsl:for-each>
								</div>
							</td>
							<td/>
							<td style="text-align:center; font-size: 8pt;">
								<div>
									<xsl:for-each select="../../Podpisy/*[name() = 'ds:Signature']">
										<xsl:if test="contains(@Id, 'Rb27ZZ')">
											<xsl:if test="contains(translate(*[name() = 'ds:Object']/*[name() = 'xades:QualifyingProperties']/*[name() = 'xades:SignedProperties']/*[name() = 'xades:SignedSignatureProperties']/*[name() = 'xades:SignerRole']/*[name() = 'xades:ClaimedRoles']/*[name() = 'xades:ClaimedRole']/*[name() = 'Role'], 'K','k'),'kierownik')">
												<xsl:value-of select="substring(*[name() = 'ds:Object']/*[name() = 'xades:QualifyingProperties']/*[name() = 'xades:SignedProperties']/*[name() = 'xades:SignedSignatureProperties']/*[name() = 'xades:SigningTime'], 1,10)"/>
											</xsl:if>
										</xsl:if>
									</xsl:for-each>
								</div>
							</td>
						</tr>
					</tbody>
				</table>
			</div>
			<xsl:element name="a">
				<xsl:attribute name="href"><xsl:value-of select="concat('#Jed', $jedIndex)"/></xsl:attribute>
				<xsl:element name="style">
					<xsl:value-of select="'font-family: Verdana'"/>
				</xsl:element>
				<xsl:value-of select="'Powrót do listy sprawozdań jednostki'"/>
			</xsl:element>
		</xsl:element>
	</xsl:template>
	<!-- Rb-27ZZ sprawozdania pomocnicze -->
	<xsl:template name="Rb-27ZZ_Pozycje">
		<xsl:param name="jedIndex"/>
		<xsl:param name="sprIndex"/>
		<xsl:param name="polIndex"/>
		<xsl:for-each select="Pozycje/Pozycja[generate-id(.) = generate-id(key('kluczRb27ZZDzial', concat(count(ancestor::Jednostka/preceding-sibling::Jednostka), count(ancestor::Rb-27ZZ/preceding-sibling::Rb-27ZZ), Dzial))[1])]">
			<xsl:sort select="Dzial" order="ascending"/>
			<xsl:variable name="obecDzial" select="Dzial"/>
			<xsl:variable name="WezlyDzial" select="/PaczkaSprawozdan/Jednostki/Jednostka[position()=$jedIndex]/Sprawozdania/child::*[position() = $polIndex]/Pozycje/Pozycja[child::Dzial = $obecDzial]"/>
			<xsl:for-each select="$WezlyDzial[generate-id(.) = generate-id(key('kluczRb27ZZRozdzial', concat(count(ancestor::Jednostka/preceding-sibling::Jednostka), count(ancestor::Rb-27ZZ/preceding-sibling::Rb-27ZZ), Rozdzial))[1])]">
				<xsl:sort select="Rozdzial" order="ascending"/>
				<xsl:variable name="obecRozdzial" select="Rozdzial"/>
				<xsl:variable name="WezlyRozdzial" select="/PaczkaSprawozdan/Jednostki/Jednostka[position()=$jedIndex]/Sprawozdania/child::*[position() = $polIndex]/Pozycje/Pozycja[child::Dzial = $obecDzial and child::Rozdzial = $obecRozdzial]"/>
				<xsl:variable name="Paragrafy" select="$WezlyRozdzial/Paragraf"/>
				<xsl:variable name="P4" select="$WezlyRozdzial/P4"/>
				<xsl:variable name="Licznosc" select="count($WezlyRozdzial)"/>
				<xsl:for-each select="$WezlyRozdzial">
					<tr>
						<td class="bottom-right-normal" style="text-align:center;font-size:8pt">
							<xsl:value-of select="Dzial"/>
						</td>
						<td class="bottom-right-normal" style="text-align:center;font-size:8pt">
							<xsl:value-of select="Rozdzial"/>
						</td>
						<td class="bottom-right-normal" style="text-align:center;font-size:8pt;">
							<xsl:value-of select="concat(Paragraf, P4)"/>
						</td>
						<td class="bottom-right-normal" style="text-align:right;font-size:8pt;padding: 3px">
							<xsl:choose>
								<xsl:when test="PL">
									<xsl:value-of select="format-number(PL, '#&#160;##0,00')"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="'0,00'"/>
								</xsl:otherwise>
							</xsl:choose>
						</td>
						<td class="bottom-right-normal" style="text-align:right;font-size:8pt;padding: 3px">
							<xsl:choose>
								<xsl:when test="NA">
									<xsl:value-of select="format-number(NA, '#&#160;##0,00')"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="'0,00'"/>
								</xsl:otherwise>
							</xsl:choose>
						</td>
						<td class="bottom-right-normal" style="text-align:right;font-size:8pt;padding: 3px">
							<xsl:choose>
								<xsl:when test="DW">
									<xsl:value-of select="format-number(DW, '#&#160;##0,00')"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="'0,00'"/>
								</xsl:otherwise>
							</xsl:choose>
						</td>
						<td class="bottom-right-normal" style="text-align:right;font-size:8pt;padding: 3px">
							<xsl:choose>
								<xsl:when test="DJ">
									<xsl:value-of select="format-number(DJ, '#&#160;##0,00')"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="'0,00'"/>
								</xsl:otherwise>
							</xsl:choose>
						</td>
						<td class="bottom-right-normal" style="text-align:right;font-size:8pt;padding: 3px">
							<xsl:choose>
								<xsl:when test="DP">
									<xsl:value-of select="format-number(DP, '#&#160;##0,00')"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="'0,00'"/>
								</xsl:otherwise>
							</xsl:choose>
						</td>
						<td class="bottom-right-normal" style="text-align:right;font-size:8pt;padding: 3px">
							<xsl:choose>
								<xsl:when test="NO">
									<xsl:value-of select="format-number(NO, '#&#160;##0,00')"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="'0,00'"/>
								</xsl:otherwise>
							</xsl:choose>
						</td>
						<td class="bottom-right-normal" style="text-align:right;font-size:8pt;padding: 3px">
							<xsl:choose>
								<xsl:when test="NZ">
									<xsl:value-of select="format-number(NZ, '#&#160;##0,00')"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="'0,00'"/>
								</xsl:otherwise>
							</xsl:choose>
						</td>
						<td class="bottom-normal" style="text-align:right;font-size:8pt;padding: 3px">
							<xsl:choose>
								<xsl:when test="NP">
									<xsl:value-of select="format-number(NP, '#&#160;##0,00')"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="'0,00'"/>
								</xsl:otherwise>
							</xsl:choose>
						</td>
					</tr>
				</xsl:for-each>
				<tr>
					<td class="bottom-right-mixed" style="text-align:center;font-size:8pt;font-weight:bold">
						<xsl:value-of select="Dzial"/>
					</td>
					<td class="bottom-right-mixed" style="text-align:center;font-size:8pt;font-weight:bold">
						<xsl:value-of select="Rozdzial"/>
					</td>
					<td class="bottom-right-mixed" style="text-align:center;font-size:8pt;">
						<xsl:call-template name="Rb-27ZZ_SumaKontr">
							<xsl:with-param name="Paragrafy" select="$Paragrafy"/>
							<xsl:with-param name="P4" select="$P4"/>
							<xsl:with-param name="Licznosc" select="count($WezlyRozdzial)"/>
							<xsl:with-param name="Licznik" select="1"/>
							<xsl:with-param name="Wartosc" select="0"/>
						</xsl:call-template>
					</td>
					<td class="bottom-right-mixed" style="text-align:right;font-size:8pt;padding: 3px">
						<xsl:value-of select="format-number(sum($WezlyRozdzial[string(number(child::PL)) != 'NaN']/PL), '#&#160;##0,00')"/>
					</td>
					<td class="bottom-right-mixed" style="text-align:right;font-size:8pt;padding: 3px">
						<xsl:value-of select="format-number(sum($WezlyRozdzial[string(number(child::NA)) != 'NaN']/NA), '#&#160;##0,00')"/>
					</td>
					<td class="bottom-right-mixed" style="text-align:right;font-size:8pt;padding: 3px">
						<xsl:value-of select="format-number(sum($WezlyRozdzial[string(number(child::DW)) != 'NaN']/DW), '#&#160;##0,00')"/>
					</td>
					<td class="bottom-right-mixed" style="text-align:right;font-size:8pt;padding: 3px">
						<xsl:value-of select="format-number(sum($WezlyRozdzial[string(number(child::DJ)) != 'NaN']/DJ), '#&#160;##0,00')"/>
					</td>
					<td class="bottom-right-mixed" style="text-align:right;font-size:8pt;padding: 3px">
						<xsl:value-of select="format-number(sum($WezlyRozdzial[string(number(child::DP)) != 'NaN']/DP), '#&#160;##0,00')"/>
					</td>
					<td class="bottom-right-mixed" style="text-align:right;font-size:8pt;padding: 3px">
						<xsl:value-of select="format-number(sum($WezlyRozdzial[string(number(child::NO)) != 'NaN']/NO), '#&#160;##0,00')"/>
					</td>
					<td class="bottom-right-mixed" style="text-align:right;font-size:8pt;padding: 3px">
						<xsl:value-of select="format-number(sum($WezlyRozdzial[string(number(child::NZ)) != 'NaN']/NZ), '#&#160;##0,00')"/>
					</td>
					<td class="bottom-bold" style="text-align:right;font-size:8pt;padding: 3px">
						<xsl:value-of select="format-number(sum($WezlyRozdzial[string(number(child::NP)) != 'NaN']/NP), '#&#160;##0,00')"/>
					</td>
				</tr>
				<tr>
					<td colspan="11" class="bottom-bold" style="height:20px"/>
				</tr>
			</xsl:for-each>
		</xsl:for-each>
	</xsl:template>
	<xsl:template name="Rb-27ZZ_SumaKontr">
		<xsl:param name="Paragrafy"/>
		<xsl:param name="P4"/>
		<xsl:param name="Licznosc"/>
		<xsl:param name="Licznik"/>
		<xsl:param name="Wartosc"/>
		<xsl:choose>
			<xsl:when test="$Licznosc = 0">
				<xsl:value-of select="$Wartosc + number(Dzial) + number(Rozdzial)"/>
			</xsl:when>
			<xsl:when test="$Licznosc = $Licznik">
				<xsl:value-of select="$Wartosc + number(concat($Paragrafy[$Licznik], $P4[$Licznik])) + number(Dzial) + number(Rozdzial)"/>
			</xsl:when>
			<xsl:when test="$Licznosc &gt; $Licznik">
				<xsl:call-template name="Rb-27ZZ_SumaKontr">
					<xsl:with-param name="Paragrafy" select="$Paragrafy"/>
					<xsl:with-param name="P4" select="$P4"/>
					<xsl:with-param name="Licznosc" select="$Licznosc"/>
					<xsl:with-param name="Licznik" select="$Licznik + 1"/>
					<xsl:with-param name="Wartosc" select="$Wartosc + number(concat($Paragrafy[$Licznik], $P4[$Licznik]))"/>
				</xsl:call-template>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<!-- Rb-50D -->
	<xsl:template match="Rb-50D">
		<xsl:param name="jedIndex"/>
		<xsl:param name="sprIndex"/>
		<xsl:param name="polIndex"/>
		<xsl:element name="div">
			<xsl:attribute name="Id"><xsl:value-of select="concat('Jed', $jedIndex, 'Wer', $sprIndex)"/></xsl:attribute>
			<xsl:attribute name="style"><xsl:value-of select="'display: block; margin-bottom: 40px'"/></xsl:attribute>
			<div style="font-size: 12pt; font-weight: bold; margin-left: 5px; margin-bottom: 10px">
        Sprawozdanie Rb-50D:
        <xsl:choose>
					<xsl:when test="Naglowek/Wersja = 0">
						<xsl:value-of select="'wersja pierwotna'"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="concat('korekta nr ', Naglowek/Wersja)"/>
					</xsl:otherwise>
				</xsl:choose>
				<xsl:call-template name="SprNaglowekInfo"/>
			</div>
			<table cellpadding="0" cellspacing="0" class="all-bold" style="margin-bottom: 5px">
				<tbody>
					<tr style="height: 18px">
						<td colspan="8" class="bottom-bold" style="font-size: 10pt;">MINISTERSTWO FINANSÓW, ul. Świętokrzyska 12, 00-916 Warszawa</td>
					</tr>
					<tr style="height: 127px; width: 260px">
						<td class="bottom-bold" style="width: 260px">
							<table cellpadding="0" cellspacing="0" style="border-collapse: collapse; height" width="100%">
								<tbody>
									<tr style="height: 80px">
										<td style="text-align: left; font-size: 9pt; margin:1px 1px 0 0; padding:0" valign="top">
                      Nazwa i adres jednostki sprawozdawczej
                    </td>
									</tr>
									<tr>
										<td class="bottom-normal" style="text-align: center; font-size: 9pt" valign="bottom">
											<!-- popr. nr I.8 -->
											<div style="display: block;margin: 0 20px">
												<xsl:choose>
													<xsl:when test="Jednostka/Nazwa">
														<xsl:value-of select="Jednostka/Nazwa"/>
													</xsl:when>
													<xsl:otherwise>
														<xsl:value-of select="../../Nazwa"/>
													</xsl:otherwise>
												</xsl:choose>
											</div>
										</td>
									</tr>
									<tr style="height: 23px">
										<td style="text-align: left; font-size: 9pt; margin:1px 1px 0 0; padding:0;" valign="top">
                      Numer identyfikacyjny REGON
                    </td>
									</tr>
									<tr>
										<td style="text-align: center; font-size: 9pt; font-weight: bold; margin:1px 1px 0 0; padding:0" valign="baseline">
											<xsl:choose>
												<xsl:when test="Jednostka/Regon">
													<xsl:value-of select="Jednostka/Regon"/>
												</xsl:when>
												<xsl:otherwise>
													<xsl:value-of select="../../Regon"/>
												</xsl:otherwise>
											</xsl:choose>
										</td>
									</tr>
								</tbody>
							</table>
						</td>
						<td colspan="4" class="notop-bold" valign="top" style="width: 460px">
							<div style="font-weight: bold; text-align: center; font-size: 11pt; margin-bottom: 5px">Rb-50</div>
							<div style="font-weight: bold; text-align: center; font-size: 11pt; margin-bottom: 5px">sprawozdanie o dotacjach związanych z wykonywaniem zadań z zakresu administracji rządowej oraz innych zadań zleconych jednostkom samorządu terytorialnego ustawami</div>
							<div style="font-weight: bold; vertical-align: bottom; text-align: center; font-size: 9pt; margin-top: 20px"> okres sprawozdawczy: </div>
							<div style="vertical-align: bottom; text-align: center; font-size: 9pt; margin-top: 30px">
								<xsl:call-template name="NaglowekSprOkresRb50dRb50w"/>
							</div>
						</td>
						<td colspan="3" class="bottom-bold" style="text-align: left; font-size: 9pt; margin:1px 1px 0 0; padding:0; width: 265px" valign="top">
							<table cellpadding="0" cellspacing="0" style="weight: 100%; height: 100%">
								<tbody>
									<tr>
										<td class="bottom-bold">
											<div style="margin-bottom:100px">Adresat:</div>
											<!-- popr. nr I.9 -->
											<div style="text-align:center; margin-bottom: 15px;">
												<!-- <xsl:value-of select="'Regionalna Izba Obrachunkowa w Katowicach'"/> -->
											</div>
											<div style="text-align:center;">
												<!-- <xsl:value-of select="'wersja robocza'"/> -->
											</div>
										</td>
									</tr>
									<tr>
										<td class="bottom-bold" style="text-align: center; font-size: 9pt; padding: 10px">Przed wypełnieniem przeczytać instrukcję</td>
									</tr>
								</tbody>
							</table>
						</td>
					</tr>
					<tr>
						<td rowspan="3" class="bottom-right-bold" style="font-size: 9pt">
							<!-- popr. nr I.10 -->
							<div style="margin-bottom: 1px">
								<xsl:value-of select="'Nazwa województwa '"/>
								<sup>1)</sup>
								<!-- <xsl:if test="../../Typ = 'W'">
									<span style="margin-left: 10px">
										<b>
											<xsl:value-of select="../../Nazwa"/>
										</b>
									</span>
								</xsl:if> -->
							</div>
							<div style="margin-bottom: 1px">
								<xsl:value-of select="'Nazwa powiatu / związku '"/>
								<sup>1)</sup>
								<!-- <xsl:if test="../../Typ = 'P'">
									<span style="margin-left: 10px">
										<b>
											<xsl:value-of select="../../Nazwa"/>
										</b>
									</span>
								</xsl:if> -->
							</div>
							<div>
								<xsl:value-of select="'Nazwa gminy / związku '"/>
								<sup>1)</sup>
								<!-- <xsl:if test="../../Typ = 'G'">
									<span style="margin-left: 10px">
										<b>
											<xsl:value-of select="../../Nazwa"/>
										</b>
									</span>
								</xsl:if> -->
							</div>
						</td>
						<td colspan="7" class="bottom-bold" style="font-size:10pt; text-align:center">Symbole</td>
					</tr>
					<tr>
						<td class="bottom-right-bold" style="font-size:10pt; text-align:center">woj.</td>
						<td class="bottom-right-bold" style="font-size:10pt; text-align:center">powiat</td>
						<td class="bottom-right-bold" style="font-size:10pt; text-align:center">gmina</td>
						<td class="bottom-right-bold" style="font-size:10pt; text-align:center">typ gm.</td>
						<td class="bottom-right-bold" style="font-size:10pt; text-align:center">związek jst</td>
						<td class="bottom-right-bold" style="font-size:10pt; text-align:center">typ zw.</td>
						<td class="bottom-bold" style="font-size:10pt; text-align:center">część</td>
					</tr>
					<tr>
						<td class="bottom-right-bold" style="font-size:10pt; text-align:center">
							<xsl:choose>
								<xsl:when test="Jednostka/WK">
									<xsl:value-of select="Jednostka/WK"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="../../WK"/>
								</xsl:otherwise>
							</xsl:choose>
						</td>
						<td class="bottom-right-bold" style="font-size:10pt; text-align:center">
							<xsl:choose>
								<xsl:when test="Jednostka/PK">
									<xsl:value-of select="Jednostka/PK"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="../../PK"/>
								</xsl:otherwise>
							</xsl:choose>
						</td>
						<td class="bottom-right-bold" style="font-size:10pt; text-align:center">
							<xsl:choose>
								<xsl:when test="Jednostka/GK">
									<xsl:value-of select="Jednostka/GK"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="../../GK"/>
								</xsl:otherwise>
							</xsl:choose>
						</td>
						<td class="bottom-right-bold" style="font-size:10pt; text-align:center">
							<xsl:choose>
								<xsl:when test="Jednostka/GT">
									<xsl:value-of select="Jednostka/GT"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="../../GT"/>
								</xsl:otherwise>
							</xsl:choose>
						</td>
						<td class="bottom-right-bold" style="font-size:10pt; text-align:center">
							<xsl:choose>
								<xsl:when test="Jednostka/KodMSWiA">
									<xsl:value-of select="Jednostka/KodMSWiA"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:choose>
										<xsl:when test="../../KodMSWiA">
											<xsl:value-of select="../../KodMSWiA"/>
										</xsl:when>
										<xsl:otherwise>
											<xsl:value-of select="$nbsp"/>
										</xsl:otherwise>
									</xsl:choose>
								</xsl:otherwise>
							</xsl:choose>
						</td>
						<td class="bottom-right-bold" style="font-size:10pt; text-align:center">
							<xsl:value-of select="$nbsp"/>
						</td>
						<td class="bottom-bold" style="font-size:10pt; text-align:center">
							<xsl:value-of select="Naglowek/DysponentDotacji"/>
						</td>
					</tr>
					<tr>
						<td class="right-bold" style="text-align:center; font-size: 9pt">
							<xsl:value-of select="1"/>
						</td>
						<td class="right-bold" style="text-align:center; font-size: 9pt">
							<xsl:value-of select="2"/>
						</td>
						<td class="right-bold" style="text-align:center; font-size: 9pt">
							<xsl:value-of select="3"/>
						</td>
						<td class="right-bold" style="text-align:center; font-size: 9pt">
							<xsl:value-of select="4"/>
						</td>
						<td class="right-bold" style="text-align:center; font-size: 9pt">
							<xsl:value-of select="5"/>
						</td>
						<td class="right-bold" style="text-align:center; font-size: 9pt">
							<xsl:value-of select="6"/>
						</td>
						<td class="right-bold" style="text-align:center; font-size: 9pt">
							<xsl:value-of select="7"/>
						</td>
						<td style="text-align:center; font-size: 9pt">
							<xsl:value-of select="8"/>
						</td>
					</tr>
				</tbody>
			</table>
			<div style="display: block; margin-bottom: 60px;margin-top:40px">
				<table cellpadding="0" cellspacing="0" class="all-bold" style="margin-bottom: 10px">
					<tbody>
						<tr>
							<td colspan="3" style="font-size: 9pt; text-align: center" class="bottom-right-bold">Klasyfikacja budżetowa</td>
							<td rowspan="2" class="bottom-right-bold" style="font-size: 9pt; width: 327px; text-align: center">Plan (po zmianach)</td>
							<td rowspan="2" class="bottom-bold" style="font-size: 9pt; width: 315px; text-align: center">Wykonanie</td>
						</tr>
						<tr>
							<td class="bottom-right-mixed" style="font-size: 9pt; width: 109px; text-align: center">dział</td>
							<td class="bottom-right-mixed" style="font-size: 9pt; width: 109px; text-align: center">rozdział</td>
							<td class="bottom-right-bold" style="font-size: 9pt; width: 109px; text-align: center">paragraf</td>
						</tr>
						<tr>
							<td class="bottom-right-bold" style="text-align:center; font-size: 8pt; padding: 3px">
								<xsl:value-of select="9"/>
							</td>
							<td class="bottom-right-bold" style="text-align:center; font-size: 8pt; padding: 3px">
								<xsl:value-of select="10"/>
							</td>
							<td class="bottom-right-bold" style="text-align:center; font-size: 8pt; padding: 3px">
								<xsl:value-of select="11"/>
							</td>
							<td class="bottom-right-bold" style="text-align:center; font-size: 8pt; padding: 3px">
								<xsl:value-of select="12"/>
							</td>
							<td class="bottom-bold" style="text-align:center; font-size: 8pt; padding: 3px">
								<xsl:value-of select="13"/>
							</td>
						</tr>
						<xsl:apply-templates select="Pozycje">
							<xsl:with-param name="jedIndex" select="$jedIndex"/>
							<xsl:with-param name="sprIndex" select="$sprIndex"/>
							<xsl:with-param name="polIndex" select="$polIndex"/>
						</xsl:apply-templates>
						<xsl:for-each select="Pozycje/Pozycja[generate-id(.) = generate-id(key('kluczRb50DDzial', concat(count(ancestor::Jednostka/preceding-sibling::Jednostka), count(ancestor::Rb-50D/preceding-sibling::Rb-50D), Dzial))[1])]">
							<xsl:sort select="Dzial" order="ascending"/>
							<xsl:variable name="obecDzial" select="Dzial"/>
							<xsl:variable name="WezlyDzial" select="/PaczkaSprawozdan/Jednostki/Jednostka[position()=$jedIndex]/Sprawozdania/child::*[position() = $polIndex]/Pozycje/Pozycja[child::Dzial = $obecDzial]"/>
							<tr>
								<td colspan="2" class="right-bottom-mixed" style="text-align:center; font-size: 8pt">zbiorczo dla działu</td>
								<td class="right-bottom-mixed" style="text-align:center;font-size:8pt;">
									<xsl:value-of select="Dzial"/>
								</td>
								<td class="right-bottom-mixed" style="text-align:right;font-size: 8pt;padding: 3px">
									<xsl:value-of select="format-number(sum($WezlyDzial[string(number(child::P)) != 'NaN']/P), '#&#160;##0,00')"/>
								</td>
								<td class="bottom-normal" style="text-align:right;font-size: 8pt;padding: 3px">
									<xsl:value-of select="format-number(sum($WezlyDzial[string(number(child::W)) != 'NaN']/W), '#&#160;##0,00')"/>
								</td>
							</tr>
						</xsl:for-each>
						<tr>
							<td colspan="3" class="right-bold" style="text-align:center; font-size: 8pt">zbiorczo dla wszystkich działów</td>
							<td class="right-bold" style="text-align:right;font-size: 8pt;padding: 3px">
								<xsl:value-of select="format-number(sum(Pozycje/Pozycja[string(number(child::P)) != 'NaN']/P), '#&#160;##0,00')"/>
							</td>
							<td style="text-align:right;font-size: 8pt;padding: 3px">
								<xsl:value-of select="format-number(sum(Pozycje/Pozycja[string(number(child::W)) != 'NaN']/W), '#&#160;##0,00')"/>
							</td>
						</tr>
					</tbody>
				</table>
				<div style="margin-bottom: 30px">
					<div style="display: block; font-size: 7pt; margin-left: 2px">
						<sup>1)</sup> niepotrzebne skreślić
          </div>
				</div>
				<table cellpadding="0" cellspacing="0" class="all-bold" style="margin-bottom: 20px; width: 55%">
					<tbody>
						<tr style="height: 30px" valign="top">
							<td style="font-size: 9pt; font-weight: bold; text-align:left; padding: 3px 10px; margin-left: 5px; margin-bottom: 25px">Wyjaśnienia do sprawozdania Rb-50D</td>
						</tr>
						<tr style="min-height: 50px; height: 70px" valign="top">
							<td style="text-align: left; font-size: 8pt; padding: 3px 10px; border-width: 4px 0 0 0; border-style: solid; border-color: black">
								<xsl:value-of select="Naglowek/Uwagi"/>
							</td>
						</tr>
					</tbody>
				</table>
				<!-- ewentualne uwagi z pozycji -->
				<xsl:if test="Pozycje/Pozycja[child::Uwagi]">
					<table cellpadding="0" cellspacing="0" class="all-bold" style="margin-bottom: 20px; width: 100%">
						<tbody>
							<tr>
								<td colspan="4" style="text-align: center; font-size: 9pt; font-weight: bold; padding: 3px 10px">
									<div>Uwagi do pozycji</div>
								</td>
							</tr>
							<tr>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 4px 4px 0; width: 6%">Dział</td>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 4px 4px 0; width: 6%">Rozdział</td>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 4px 4px 0; width: 6%">Paragraf</td>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 0 4px 0">Uwaga</td>
							</tr>
							<xsl:for-each select="Pozycje/Pozycja[child::Uwagi]">
								<xsl:sort select="Dzial"/>
								<xsl:sort select="Rozdział"/>
								<xsl:sort select="Paragraf"/>
								<tr>
									<xsl:choose>
										<xsl:when test="position() != last()">
											<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
												<xsl:value-of select="Dzial"/>
											</td>
											<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
												<xsl:value-of select="Rozdzial"/>
											</td>
											<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
												<xsl:value-of select="concat(Paragraf, P4)"/>
											</td>
											<td class="bottom-normal" style="text-align: left; font-size: 8pt; padding: 3px">
												<xsl:value-of select="Uwagi"/>
											</td>
										</xsl:when>
										<xsl:otherwise>
											<td class="right-normal" style="text-align: center; font-size: 8pt">
												<xsl:value-of select="Dzial"/>
											</td>
											<td class="right-normal" style="text-align: center; font-size: 8pt">
												<xsl:value-of select="Rozdzial"/>
											</td>
											<td class="right-normal" style="text-align: center; font-size: 8pt">
												<xsl:value-of select="concat(Paragraf, P4)"/>
											</td>
											<td style="text-align: left; font-size: 8pt; padding: 3px">
												<xsl:value-of select="Uwagi"/>
											</td>
										</xsl:otherwise>
									</xsl:choose>
								</tr>
							</xsl:for-each>
						</tbody>
					</table>
				</xsl:if>
				<table cellpadding="0" cellspacing="0" style="margin-bottom: 50px; margin-top: 80px; width: 80%">
					<tbody>
						<tr>
							<td style="text-align:center; font-size: 8pt;" valign="bottom" width="25%">
								<hr style="width: 90%;text-align:center; "/>
								<div style="text-align:center;">Główny księgowy albo Skarbnik</div>
							</td>
							<td/>
							<td style="text-align:center; font-size: 8pt;" valign="bottom" width="25%">
								<hr style="width: 90%;text-align:center"/>
								<div style="text-align:center;">Kierownik jednostki albo Przewodniczący zarządu</div>
							</td>
						</tr>
						<tr>
							<td style="text-align:center; font-size: 8pt;">
								<div>
									<xsl:for-each select="../../Podpisy/*[name() = 'ds:Signature']">
										<xsl:if test="contains(@Id, 'Rb50D')">
											<xsl:if test="contains(translate(*[name() = 'ds:Object']/*[name() = 'xades:QualifyingProperties']/*[name() = 'xades:SignedProperties']/*[name() = 'xades:SignedSignatureProperties']/*[name() = 'xades:SignerRole']/*[name() = 'xades:ClaimedRoles']/*[name() = 'xades:ClaimedRole']/*[name() = 'Role'], 'S','s'),'skarbnik')">
												<xsl:value-of select="substring(*[name() = 'ds:Object']/*[name() = 'xades:QualifyingProperties']/*[name() = 'xades:SignedProperties']/*[name() = 'xades:SignedSignatureProperties']/*[name() = 'xades:SigningTime'], 1, 10)"/>
											</xsl:if>
										</xsl:if>
									</xsl:for-each>
								</div>
							</td>
							<td/>
							<td style="text-align:center; font-size: 8pt;">
								<div>
									<xsl:for-each select="../../Podpisy/*[name() = 'ds:Signature']">
										<xsl:if test="contains(@Id, 'Rb50D')">
											<xsl:if test="contains(translate(*[name() = 'ds:Object']/*[name() = 'xades:QualifyingProperties']/*[name() = 'xades:SignedProperties']/*[name() = 'xades:SignedSignatureProperties']/*[name() = 'xades:SignerRole']/*[name() = 'xades:ClaimedRoles']/*[name() = 'xades:ClaimedRole']/*[name() = 'Role'], 'K','k'),'kierownik')">
												<xsl:value-of select="substring(*[name() = 'ds:Object']/*[name() = 'xades:QualifyingProperties']/*[name() = 'xades:SignedProperties']/*[name() = 'xades:SignedSignatureProperties']/*[name() = 'xades:SigningTime'], 1,10)"/>
											</xsl:if>
										</xsl:if>
									</xsl:for-each>
								</div>
							</td>
						</tr>
					</tbody>
				</table>
			</div>
			<xsl:element name="a">
				<xsl:attribute name="href"><xsl:value-of select="concat('#Jed', $jedIndex)"/></xsl:attribute>
				<xsl:element name="style">
					<xsl:value-of select="'font-family: Verdana'"/>
				</xsl:element>
				<xsl:value-of select="'Powrót do listy sprawozdań jednostki'"/>
			</xsl:element>
		</xsl:element>
	</xsl:template>
	<!-- Rb-50D szablony pomocnicze -->
	<xsl:template match="Rb-50D/Pozycje">
		<xsl:param name="jedIndex"/>
		<xsl:param name="sprIndex"/>
		<xsl:param name="polIndex"/>
		<xsl:for-each select="Pozycja[generate-id(.) = generate-id(key('kluczRb50DDzial', concat(count(ancestor::Jednostka/preceding-sibling::Jednostka), count(ancestor::Rb-50D/preceding-sibling::Rb-50D), Dzial))[1])]">
			<xsl:sort select="Dzial" order="ascending"/>
			<xsl:variable name="obecDzial" select="Dzial"/>
			<xsl:variable name="WezlyDzial" select="/PaczkaSprawozdan/Jednostki/Jednostka[position()=$jedIndex]/Sprawozdania/child::*[position() = $polIndex]/Pozycje/Pozycja[child::Dzial = $obecDzial]"/>
			<xsl:for-each select="$WezlyDzial[generate-id(.) = generate-id(key('kluczRb50DRozdzial', concat(count(ancestor::Jednostka/preceding-sibling::Jednostka), count(ancestor::Rb-50D/preceding-sibling::Rb-50D), Rozdzial))[1])]">
				<xsl:sort select="Rozdzial" order="ascending"/>
				<xsl:variable name="obecRozdzial" select="Rozdzial"/>
				<xsl:variable name="WezlyRozdzial" select="/PaczkaSprawozdan/Jednostki/Jednostka[position()=$jedIndex]/Sprawozdania/child::*[position() = $polIndex]/Pozycje/Pozycja[child::Dzial = $obecDzial and child::Rozdzial = $obecRozdzial]"/>
				<xsl:variable name="Paragrafy" select="$WezlyRozdzial/Paragraf"/>
				<xsl:variable name="P4" select="$WezlyRozdzial/P4"/>
				<xsl:variable name="Licznosc" select="count($WezlyRozdzial)"/>
				<xsl:for-each select="$WezlyRozdzial">
					<tr>
						<td class="bottom-right-normal" style="text-align:center;font-size:8pt">
							<xsl:value-of select="Dzial"/>
						</td>
						<td class="bottom-right-normal" style="text-align:center;font-size:8pt">
							<xsl:value-of select="Rozdzial"/>
						</td>
						<td class="bottom-right-normal" style="text-align:center;font-size:8pt;">
							<xsl:value-of select="concat(Paragraf, P4)"/>
						</td>
						<td class="bottom-right-normal" style="text-align:right;font-size: 8pt;padding: 3px">
							<xsl:choose>
								<xsl:when test="P">
									<xsl:value-of select="format-number(P, '#&#160;##0,00')"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="'0,00'"/>
								</xsl:otherwise>
							</xsl:choose>
						</td>
						<td class="bottom-right-normal" style="text-align:right;font-size: 8pt;padding: 3px">
							<xsl:choose>
								<xsl:when test="W">
									<xsl:value-of select="format-number(W, '#&#160;##0,00')"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="'0,00'"/>
								</xsl:otherwise>
							</xsl:choose>
						</td>
					</tr>
				</xsl:for-each>
				<tr>
					<td class="bottom-right-mixed" style="text-align:center;font-size:8pt;font-weight:bold">
						<xsl:value-of select="Dzial"/>
					</td>
					<td class="bottom-right-mixed" style="text-align:center;font-size:8pt;font-weight:bold">
						<xsl:value-of select="Rozdzial"/>
					</td>
					<td class="bottom-right-mixed" style="text-align:center;font-size:8pt;">
						<xsl:call-template name="Rb-50D_SumaKontr">
							<xsl:with-param name="Paragrafy" select="$Paragrafy"/>
							<xsl:with-param name="P4" select="$P4"/>
							<xsl:with-param name="Licznosc" select="count($WezlyRozdzial)"/>
							<xsl:with-param name="Licznik" select="1"/>
							<xsl:with-param name="Wartosc" select="0"/>
						</xsl:call-template>
					</td>
					<td class="bottom-right-mixed" style="text-align:right;font-size: 8pt;padding: 3px">
						<xsl:value-of select="format-number(sum($WezlyRozdzial[string(number(child::P)) != 'NaN']/P), '#&#160;##0,00')"/>
					</td>
					<td class="bottom-right-mixed" style="text-align:right;font-size: 8pt;padding: 3px">
						<xsl:value-of select="format-number(sum($WezlyRozdzial[string(number(child::W)) != 'NaN']/W), '#&#160;##0,00')"/>
					</td>
				</tr>
				<tr>
					<td colspan="11" class="bottom-bold" style="height:20px"/>
				</tr>
			</xsl:for-each>
		</xsl:for-each>
	</xsl:template>
	<xsl:template name="Rb-50D_SumaKontr">
		<xsl:param name="Paragrafy"/>
		<xsl:param name="P4"/>
		<xsl:param name="Licznosc"/>
		<xsl:param name="Licznik"/>
		<xsl:param name="Wartosc"/>
		<xsl:choose>
			<xsl:when test="$Licznosc = 0">
				<xsl:value-of select="$Wartosc + number(Dzial) + number(Rozdzial)"/>
			</xsl:when>
			<xsl:when test="$Licznosc = $Licznik">
				<xsl:value-of select="$Wartosc + number(concat($Paragrafy[$Licznik], $P4[$Licznik])) + number(Dzial) + number(Rozdzial)"/>
			</xsl:when>
			<xsl:when test="$Licznosc &gt; $Licznik">
				<xsl:call-template name="Rb-50D_SumaKontr">
					<xsl:with-param name="Paragrafy" select="$Paragrafy"/>
					<xsl:with-param name="P4" select="$P4"/>
					<xsl:with-param name="Licznosc" select="$Licznosc"/>
					<xsl:with-param name="Licznik" select="$Licznik + 1"/>
					<xsl:with-param name="Wartosc" select="$Wartosc + number(concat($Paragrafy[$Licznik], $P4[$Licznik]))"/>
				</xsl:call-template>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<!-- Rb-50W -->
	<xsl:template match="Rb-50W">
		<xsl:param name="jedIndex"/>
		<xsl:param name="sprIndex"/>
		<xsl:param name="polIndex"/>
		<xsl:element name="div">
			<xsl:attribute name="Id"><xsl:value-of select="concat('Jed', $jedIndex, 'Wer', $sprIndex)"/></xsl:attribute>
			<xsl:attribute name="style"><xsl:value-of select="'display: block; margin-bottom: 40px'"/></xsl:attribute>
			<div style="font-size: 12pt; font-weight: bold; margin-left: 5px; margin-bottom: 10px">
        Sprawozdanie Rb-50W:
        <xsl:choose>
					<xsl:when test="Naglowek/Wersja = 0">
						<xsl:value-of select="'wersja pierwotna'"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="concat('korekta nr ', Naglowek/Wersja)"/>
					</xsl:otherwise>
				</xsl:choose>
				<xsl:call-template name="SprNaglowekInfo"/>
			</div>
			<table cellpadding="0" cellspacing="0" class="all-bold" style="margin-bottom: 40px">
				<tbody>
					<tr style="height: 18px">
						<td colspan="8" class="bottom-bold" style="font-size: 10pt;">MINISTERSTWO FINANSÓW, ul. Świętokrzyska 12, 00-916 Warszawa</td>
					</tr>
					<tr style="height: 127px; width: 260px">
						<td class="bottom-bold" style="width: 260px">
							<table cellpadding="0" cellspacing="0" style="border-collapse: collapse; height" width="100%">
								<tbody>
									<tr style="height: 80px">
										<td style="text-align: left; font-size: 9pt; margin:1px 1px 0 0; padding:0" valign="top">
                      Nazwa i adres jednostki sprawozdawczej:
                    </td>
									</tr>
									<tr>
										<td class="bottom-normal" style="text-align: center; font-size: 9pt" valign="bottom">
											<!-- popr. nr I.8 -->
											<div style="display: block;margin: 0 20px">
												<xsl:choose>
													<xsl:when test="Jednostka/Nazwa">
														<xsl:value-of select="Jednostka/Nazwa"/>
													</xsl:when>
													<xsl:otherwise>
														<xsl:value-of select="../../Nazwa"/>
													</xsl:otherwise>
												</xsl:choose>
											</div>
										</td>
									</tr>
									<tr style="height: 23px">
										<td style="text-align: left; font-size: 9pt; margin:1px 1px 0 0; padding:0;" valign="top">
                      Numer identyfikacyjny REGON:
                    </td>
									</tr>
									<tr>
										<td style="text-align: center; font-size: 9pt; font-weight: bold; margin:1px 1px 0 0; padding:0" valign="baseline">
											<xsl:choose>
												<xsl:when test="Jednostka/Regon">
													<xsl:value-of select="Jednostka/Regon"/>
												</xsl:when>
												<xsl:otherwise>
													<xsl:value-of select="../../Regon"/>
												</xsl:otherwise>
											</xsl:choose>
										</td>
									</tr>
								</tbody>
							</table>
						</td>
						<td colspan="4" class="notop-bold" valign="top" style="width: 460px">
							<div style="font-weight: bold; text-align: center; font-size: 11pt; margin-bottom: 5px">Rb-50</div>
							<div style="font-weight: bold; text-align: center; font-size: 11pt; margin-bottom: 5px">sprawozdanie o wydatkach związanych z wykonywaniem zadań z zakresu administracji rządowej oraz innych zadań zleconych jednostkom samorządu terytorialnego ustawami</div>
							<div style="font-weight: bold; vertical-align: bottom; text-align: center; font-size: 9pt; margin-top: 20px"> okres sprawozdawczy: </div>
							<div style="vertical-align: bottom; text-align: center; font-size: 9pt; margin-top: 30px">
								<xsl:call-template name="NaglowekSprOkresRb50dRb50w"/>
							</div>
						</td>
						<td colspan="3" class="bottom-bold" style="text-align: left; font-size: 9pt; margin:1px 1px 0 0; padding:0; width: 265px" valign="top">
							<table cellpadding="0" cellspacing="0" style="weight: 100%; height: 100%">
								<tbody>
									<tr>
										<td class="bottom-bold">
											<div style="margin-bottom:100px">Adresat:</div>
											<!-- popr. nr I.9 -->
											<div style="text-align:center; margin-bottom: 15px;">
												<!-- <xsl:value-of select="'Regionalna Izba Obrachunkowa w Katowicach'"/> -->
											</div>
											<div style="text-align:center;">
												<!-- <xsl:value-of select="'wersja robocza'"/> -->
											</div>
										</td>
									</tr>
									<tr>
										<td class="bottom-bold" style="text-align: center; font-size: 9pt; padding: 10px">Przed wypełnieniem przeczytać instrukcję</td>
									</tr>
								</tbody>
							</table>
						</td>
					</tr>
					<tr>
						<td rowspan="3" class="bottom-right-bold" style="font-size: 9pt">
							<!-- popr. nr I.10 -->
							<div style="margin-bottom: 1px">
								<xsl:value-of select="'Nazwa województwa '"/>
								<sup>1)</sup>
								<!-- <xsl:if test="../../Typ = 'W'">
									<span style="margin-left: 10px">
										<b>
											<xsl:value-of select="../../Nazwa"/>
										</b>
									</span>
								</xsl:if> -->
							</div>
							<div style="margin-bottom: 1px">
								<xsl:value-of select="'Nazwa powiatu / związku '"/>
								<sup>1)</sup>
								<!-- <xsl:if test="../../Typ = 'P'">
									<span style="margin-left: 10px">
										<b>
											<xsl:value-of select="../../Nazwa"/>
										</b>
									</span>
								</xsl:if> -->
							</div>
							<div>
								<xsl:value-of select="'Nazwa gminy / związku '"/>
								<sup>1)</sup>
								<!-- <xsl:if test="../../Typ = 'G'">
									<span style="margin-left: 10px">
										<b>
											<xsl:value-of select="../../Nazwa"/>
										</b>
									</span>
								</xsl:if> -->
							</div>
						</td>
						<td colspan="7" class="bottom-bold" style="font-size:10pt; text-align:center">Symbole</td>
					</tr>
					<tr>
						<td class="bottom-right-bold" style="font-size:10pt; text-align:center">woj.</td>
						<td class="bottom-right-bold" style="font-size:10pt; text-align:center">powiat</td>
						<td class="bottom-right-bold" style="font-size:10pt; text-align:center">gmina</td>
						<td class="bottom-right-bold" style="font-size:10pt; text-align:center">typ gm.</td>
						<td class="bottom-right-bold" style="font-size:10pt; text-align:center">związek jst</td>
						<td class="bottom-right-bold" style="font-size:10pt; text-align:center">typ zw.</td>
						<td class="bottom-bold" style="font-size:10pt; text-align:center">część</td>
					</tr>
					<tr>
						<td class="bottom-right-bold" style="font-size:10pt; text-align:center">
							<xsl:choose>
								<xsl:when test="Jednostka/WK">
									<xsl:value-of select="Jednostka/WK"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="../../WK"/>
								</xsl:otherwise>
							</xsl:choose>
						</td>
						<td class="bottom-right-bold" style="font-size:10pt; text-align:center">
							<xsl:choose>
								<xsl:when test="Jednostka/PK">
									<xsl:value-of select="Jednostka/PK"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="../../PK"/>
								</xsl:otherwise>
							</xsl:choose>
						</td>
						<td class="bottom-right-bold" style="font-size:10pt; text-align:center">
							<xsl:choose>
								<xsl:when test="Jednostka/GK">
									<xsl:value-of select="Jednostka/GK"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="../../GK"/>
								</xsl:otherwise>
							</xsl:choose>
						</td>
						<td class="bottom-right-bold" style="font-size:10pt; text-align:center">
							<xsl:choose>
								<xsl:when test="Jednostka/GT">
									<xsl:value-of select="Jednostka/GT"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="../../GT"/>
								</xsl:otherwise>
							</xsl:choose>
						</td>
						<td class="bottom-right-bold" style="font-size:10pt; text-align:center">
							<xsl:choose>
								<xsl:when test="Jednostka/KodMSWiA">
									<xsl:value-of select="Jednostka/KodMSWiA"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:choose>
										<xsl:when test="../../KodMSWiA">
											<xsl:value-of select="../../KodMSWiA"/>
										</xsl:when>
										<xsl:otherwise>
											<xsl:value-of select="$nbsp"/>
										</xsl:otherwise>
									</xsl:choose>
								</xsl:otherwise>
							</xsl:choose>
						</td>
						<td class="bottom-right-bold" style="font-size:10pt; text-align:center">
							<xsl:value-of select="$nbsp"/>
						</td>
						<td class="bottom-bold" style="font-size:10pt; text-align:center">
							<xsl:value-of select="Naglowek/DysponentDotacji"/>
						</td>
					</tr>
					<tr>
						<td class="right-bold" style="text-align:center; font-size: 9pt">
							<xsl:value-of select="1"/>
						</td>
						<td class="right-bold" style="text-align:center; font-size: 9pt">
							<xsl:value-of select="2"/>
						</td>
						<td class="right-bold" style="text-align:center; font-size: 9pt">
							<xsl:value-of select="3"/>
						</td>
						<td class="right-bold" style="text-align:center; font-size: 9pt">
							<xsl:value-of select="4"/>
						</td>
						<td class="right-bold" style="text-align:center; font-size: 9pt">
							<xsl:value-of select="5"/>
						</td>
						<td class="right-bold" style="text-align:center; font-size: 9pt">
							<xsl:value-of select="6"/>
						</td>
						<td class="right-bold" style="text-align:center; font-size: 9pt">
							<xsl:value-of select="7"/>
						</td>
						<td style="text-align:center; font-size: 9pt">
							<xsl:value-of select="8"/>
						</td>
					</tr>
				</tbody>
			</table>
			<div style="display: block; margin-bottom: 40px">
				<table cellpadding="0" cellspacing="0" class="all-bold" style="margin-bottom: 5px">
					<tbody>
						<tr>
							<td colspan="3" style="font-size: 9pt; text-align: center" class="bottom-right-bold">Klasyfikacja budżetowa</td>
							<td rowspan="2" class="bottom-right-bold" style="font-size: 9pt; width: 327px; text-align: center">Plan (po zmianach)</td>
							<td rowspan="2" class="bottom-bold" style="font-size: 9pt; width: 327px; text-align: center">Wykonanie</td>
						</tr>
						<tr>
							<td class="bottom-right-mixed" style="font-size: 9pt; width: 109px; text-align: center">dział</td>
							<td class="bottom-right-mixed" style="font-size: 9pt; width: 109px; text-align: center">rozdział</td>
							<td class="bottom-right-bold" style="font-size: 9pt; width: 109px; text-align: center">paragraf</td>
						</tr>
						<tr>
							<td class="bottom-right-bold" style="text-align:center; font-size: 8pt; padding: 3px">
								<xsl:value-of select="9"/>
							</td>
							<td class="bottom-right-bold" style="text-align:center; font-size: 8pt; padding: 3px">
								<xsl:value-of select="10"/>
							</td>
							<td class="bottom-right-bold" style="text-align:center; font-size: 8pt; padding: 3px">
								<xsl:value-of select="11"/>
							</td>
							<td class="bottom-right-bold" style="text-align:center; font-size: 8pt; padding: 3px">
								<xsl:value-of select="12"/>
							</td>
							<td class="bottom-bold" style="text-align:center; font-size: 8pt; padding: 3px">
								<xsl:value-of select="13"/>
							</td>
						</tr>
						<xsl:apply-templates select="Pozycje">
							<xsl:with-param name="jedIndex" select="$jedIndex"/>
							<xsl:with-param name="sprIndex" select="$sprIndex"/>
							<xsl:with-param name="polIndex" select="$polIndex"/>
						</xsl:apply-templates>
						<xsl:for-each select="Pozycje/Pozycja[generate-id(.) = generate-id(key('kluczRb50WDzial', concat(count(ancestor::Jednostka/preceding-sibling::Jednostka), count(ancestor::Rb-50W/preceding-sibling::Rb-50W), Dzial))[1])]">
							<xsl:sort select="Dzial" order="ascending"/>
							<xsl:variable name="obecDzial" select="Dzial"/>
							<xsl:variable name="WezlyDzial" select="/PaczkaSprawozdan/Jednostki/Jednostka[position()=$jedIndex]/Sprawozdania/child::*[position() = $polIndex]/Pozycje/Pozycja[child::Dzial = $obecDzial]"/>
							<tr>
								<td colspan="2" class="right-bottom-mixed" style="text-align:center; font-size: 8pt">zbiorczo dla działu</td>
								<td class="right-bottom-mixed" style="text-align:center;font-size:8pt;">
									<xsl:value-of select="Dzial"/>
								</td>
								<td class="right-bottom-mixed" style="text-align:right;font-size: 8pt;padding: 3px">
									<xsl:value-of select="format-number(sum($WezlyDzial[string(number(child::P)) != 'NaN']/P), '#&#160;##0,00')"/>
								</td>
								<td class="bottom-normal" style="text-align:right;font-size: 8pt;padding: 3px">
									<xsl:value-of select="format-number(sum($WezlyDzial[string(number(child::W)) != 'NaN']/W), '#&#160;##0,00')"/>
								</td>
							</tr>
						</xsl:for-each>
						<tr>
							<td colspan="3" class="right-bold" style="text-align:center; font-size: 8pt">zbiorczo dla wszystkich działów</td>
							<td class="right-bold" style="text-align:right;font-size:8pt;padding: 3px">
								<xsl:value-of select="format-number(sum(Pozycje/Pozycja[string(number(P)) != 'NaN']/P), '#&#160;##0,00')"/>
							</td>
							<td style="text-align:right;font-size:8pt;padding: 3px">
								<xsl:value-of select="format-number(sum(Pozycje/Pozycja[string(number(W)) != 'NaN']/W), '#&#160;##0,00')"/>
							</td>
						</tr>
					</tbody>
				</table>
				<div style="display: block; font-size: 7pt; margin-left: 2px;margin-bottom:30px">
					<sup>1)</sup> niepotrzebne skreślić
        </div>
				<div style="display: block; font-size:9pt; font-weight: bold; margin-left: 10px; margin-bottom: 5px">A. Wydatki poniesione w roku bieżącym ze środków własnych jst,
a niezwrócone w tym roku przez dysponenta środków budżetu państwa</div>
				<table cellpadding="0" cellspacing="0" class="all-bold" style="margin-bottom: 5px">
					<tbody>
						<tr>
							<td rowspan="2" class="bottom-right-bold" style="font-size: 9pt; width: 80px; text-align: center">Kod</td>
							<td colspan="3" style="font-size: 9pt; text-align: center" class="bottom-right-bold">Klasyfikacja budżetowa</td>
							<td rowspan="2" class="bottom-bold" style="font-size: 9pt; width: 574px; text-align: center">Wykonanie *)</td>
						</tr>
						<tr>
							<td class="bottom-right-mixed" style="font-size: 9pt; width: 109px; text-align: center">dział</td>
							<td class="bottom-right-mixed" style="font-size: 9pt; width: 109px; text-align: center">rozdział</td>
							<td class="bottom-right-bold" style="font-size: 9pt; width: 109px; text-align: center">paragraf</td>
						</tr>
						<tr>
							<td class="bottom-right-bold" style="text-align:center; font-size: 8pt; padding: 3px">
								<xsl:value-of select="1"/>
							</td>
							<td class="bottom-right-bold" style="text-align:center; font-size: 8pt; padding: 3px">
								<xsl:value-of select="2"/>
							</td>
							<td class="bottom-right-bold" style="text-align:center; font-size: 8pt; padding: 3px">
								<xsl:value-of select="3"/>
							</td>
							<td class="bottom-right-bold" style="text-align:center; font-size: 8pt; padding: 3px">
								<xsl:value-of select="4"/>
							</td>
							<td class="bottom-bold" style="text-align:center; font-size: 8pt; padding: 3px">
								<xsl:value-of select="5"/>
							</td>
						</tr>
						<xsl:apply-templates select="WydatkiA">
							<xsl:with-param name="jedIndex" select="$jedIndex"/>
							<xsl:with-param name="sprIndex" select="$sprIndex"/>
							<xsl:with-param name="polIndex" select="$polIndex"/>
						</xsl:apply-templates>
						<xsl:for-each select="WydatkiA/Pozycja[generate-id(.) = generate-id(key('kluczRb50WwydADzial', concat(count(ancestor::Jednostka/preceding-sibling::Jednostka), count(ancestor::Rb-50W/preceding-sibling::Rb-50W), Dzial))[1])]">
							<xsl:sort select="Dzial" order="ascending"/>
							<xsl:variable name="obecDzial" select="Dzial"/>
							<xsl:variable name="WezlyDzial" select="/PaczkaSprawozdan/Jednostki/Jednostka[position()=$jedIndex]/Sprawozdania/child::*[position() = $polIndex]/WydatkiA/Pozycja[child::Dzial = $obecDzial]"/>
							<tr>
								<td colspan="3" class="right-bottom-mixed" style="text-align:center; font-size: 8pt">zbiorczo dla działu</td>
								<td class="right-bottom-mixed" style="text-align:center;font-size:8pt;">
									<xsl:value-of select="Dzial"/>
								</td>
								<td class="bottom-normal" style="text-align:right;font-size:8pt;padding: 3px">
									<xsl:value-of select="format-number(sum($WezlyDzial[string(number(child::W)) != 'NaN']/W), '#&#160;##0,00')"/>
								</td>
							</tr>
						</xsl:for-each>
						<tr>
							<td colspan="4" class="right-bold" style="text-align:center; font-size: 8pt">zbiorczo dla wszystkich działów</td>
							<td style="text-align:right;font-size:8pt;padding: 3px">
								<xsl:value-of select="format-number(sum(WydatkiA/Pozycja[string(number(W)) != 'NaN']/W), '#&#160;##0,00')"/>
							</td>
						</tr>
					</tbody>
				</table>
				<div style="margin-bottom: 60px">
					<div style="display: block; font-size: 10pt; margin-left: 2px">
						<sup>*) dotyczy tylko tych zadań, na które jst otrzymują dotacje na zwrot poniesionych przez nie wydatków</sup>
					</div>
				</div>
				<div style="display: block; font-size:9pt; font-weight: bold; margin-left: 10px; margin-bottom: 5px">B. Wydatki poniesione przez jst ze środków własnych w poprzednim roku budżetowym a zwrócone z dotacji otrzymanej w danym roku budżetowym</div>
				<table cellpadding="0" cellspacing="0" class="all-bold" style="margin-bottom: 5px">
					<tbody>
						<tr>
							<td rowspan="2" class="bottom-right-bold" style="font-size: 9pt; width: 80px; text-align: center">Kod</td>
							<td colspan="3" style="font-size: 9pt; text-align: center" class="bottom-right-bold">Klasyfikacja budżetowa</td>
							<td rowspan="2" class="bottom-bold" style="font-size: 9pt; width: 574px; text-align: center">Wykonanie *)</td>
						</tr>
						<tr>
							<td class="bottom-right-mixed" style="font-size: 9pt; width: 109px; text-align: center">dział</td>
							<td class="bottom-right-mixed" style="font-size: 9pt; width: 109px; text-align: center">rozdział</td>
							<td class="bottom-right-bold" style="font-size: 9pt; width: 109px; text-align: center">paragraf</td>
						</tr>
						<tr>
							<td class="bottom-right-bold" style="text-align:center; font-size: 8pt; padding: 3px">
								<xsl:value-of select="1"/>
							</td>
							<td class="bottom-right-bold" style="text-align:center; font-size: 8pt; padding: 3px">
								<xsl:value-of select="2"/>
							</td>
							<td class="bottom-right-bold" style="text-align:center; font-size: 8pt; padding: 3px">
								<xsl:value-of select="3"/>
							</td>
							<td class="bottom-right-bold" style="text-align:center; font-size: 8pt; padding: 3px">
								<xsl:value-of select="4"/>
							</td>
							<td class="bottom-bold" style="text-align:center; font-size: 8pt; padding: 3px">
								<xsl:value-of select="5"/>
							</td>
						</tr>
						<xsl:apply-templates select="WydatkiB">
							<xsl:with-param name="jedIndex" select="$jedIndex"/>
							<xsl:with-param name="sprIndex" select="$sprIndex"/>
							<xsl:with-param name="polIndex" select="$polIndex"/>
						</xsl:apply-templates>
						<xsl:for-each select="WydatkiB/Pozycja[generate-id(.) = generate-id(key('kluczRb50WwydBDzial', concat(count(ancestor::Jednostka/preceding-sibling::Jednostka), count(ancestor::Rb-50W/preceding-sibling::Rb-50W), Dzial))[1])]">
							<xsl:sort select="Dzial" order="ascending"/>
							<xsl:variable name="obecDzial" select="Dzial"/>
							<xsl:variable name="WezlyDzial" select="/PaczkaSprawozdan/Jednostki/Jednostka[position()=$jedIndex]/Sprawozdania/child::*[position() = $polIndex]/WydatkiB/Pozycja[child::Dzial = $obecDzial]"/>
							<tr>
								<td colspan="3" class="right-bottom-mixed" style="text-align:center; font-size: 8pt">zbiorczo dla działu</td>
								<td class="right-bottom-mixed" style="text-align:center;font-size:8pt;">
									<xsl:value-of select="Dzial"/>
								</td>
								<td class="bottom-normal" style="text-align:right;font-size:8pt;padding: 3px">
									<xsl:value-of select="format-number(sum($WezlyDzial[string(number(child::W)) != 'NaN']/W), '#&#160;##0,00')"/>
								</td>
							</tr>
						</xsl:for-each>
						<tr>
							<td colspan="4" class="right-bold" style="text-align:center; font-size: 8pt">zbiorczo dla wszystkich działów</td>
							<td style="text-align:right;font-size:8pt;padding: 3px">
								<xsl:value-of select="format-number(sum(WydatkiB/Pozycja[string(number(W)) != 'NaN']/W), '#&#160;##0,00')"/>
							</td>
						</tr>
					</tbody>
				</table>
				<div style="margin-bottom: 60px">
					<div style="display: block; font-size: 10pt; margin-left: 2px">
						<sup>*) dotyczy tylko tych zadań, na które jst otrzymują dotacje na zwrot poniesionych przez nie wydatków</sup>
					</div>
				</div>
				<table cellpadding="0" cellspacing="0" class="all-bold" style="margin-bottom: 20px; width: 55%">
					<tbody>
						<tr style="height: 30px" valign="top">
							<td style="font-size: 9pt; font-weight: bold; text-align:left; padding: 3px 10px; margin-left: 5px; margin-bottom: 25px">Wyjaśnienia do sprawozdania Rb-50W</td>
						</tr>
						<tr style="min-height: 50px; height: 70px" valign="top">
							<td style="text-align: left; font-size: 8pt; padding: 3px 10px; border-width: 4px 0 0 0; border-style: solid; border-color: black">
								<xsl:value-of select="Naglowek/Uwagi"/>
							</td>
						</tr>
					</tbody>
				</table>
				<!-- ewentualne uwagi z pozycji -->
				<xsl:if test="Pozycje/Pozycja[child::Uwagi]">
					<table cellpadding="0" cellspacing="0" class="all-bold" style="margin-bottom: 20px; width: 100%">
						<tbody>
							<tr>
								<td colspan="4" style="text-align: center; font-size: 9pt; font-weight: bold; padding: 3px 10px">
									<div>Uwagi do pozycji</div>
								</td>
							</tr>
							<tr>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 4px 4px 0; width: 6%">Dział</td>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 4px 4px 0; width: 6%">Rozdział</td>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 4px 4px 0; width: 6%">Paragraf</td>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 0 4px 0">Uwaga</td>
							</tr>
							<xsl:for-each select="Pozycje/Pozycja[child::Uwagi]">
								<xsl:sort select="Dzial"/>
								<xsl:sort select="Rozdział"/>
								<xsl:sort select="Paragraf"/>
								<tr>
									<xsl:choose>
										<xsl:when test="position() != last()">
											<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
												<xsl:value-of select="Dzial"/>
											</td>
											<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
												<xsl:value-of select="Rozdzial"/>
											</td>
											<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
												<xsl:value-of select="concat(Paragraf, P4)"/>
											</td>
											<td class="bottom-normal" style="text-align: left; font-size: 8pt; padding: 3px">
												<xsl:value-of select="Uwagi"/>
											</td>
										</xsl:when>
										<xsl:otherwise>
											<td class="right-normal" style="text-align: center; font-size: 8pt">
												<xsl:value-of select="Dzial"/>
											</td>
											<td class="right-normal" style="text-align: center; font-size: 8pt">
												<xsl:value-of select="Rozdzial"/>
											</td>
											<td class="right-normal" style="text-align: center; font-size: 8pt">
												<xsl:value-of select="concat(Paragraf, P4)"/>
											</td>
											<td style="text-align: left; font-size: 8pt; padding: 3px">
												<xsl:value-of select="Uwagi"/>
											</td>
										</xsl:otherwise>
									</xsl:choose>
								</tr>
							</xsl:for-each>
						</tbody>
					</table>
				</xsl:if>
				<xsl:if test="WydatkiA/Pozycja[child::Uwagi]">
					<table cellpadding="0" cellspacing="0" class="all-bold" style="margin-bottom: 20px; width: 100%">
						<tbody>
							<tr>
								<td colspan="4" style="text-align: center; font-size: 9pt; font-weight: bold; padding: 3px 10px">
									<div>Uwagi do pozycji uzupełniających danych części A</div>
								</td>
							</tr>
							<tr>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 4px 4px 0; width: 6%">Dział</td>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 4px 4px 0; width: 6%">Rozdział</td>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 4px 4px 0; width: 6%">Paragraf</td>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 0 4px 0">Uwaga</td>
							</tr>
							<xsl:for-each select="WydatkiA/Pozycja[child::Uwagi]">
								<xsl:sort select="Dzial"/>
								<xsl:sort select="Rozdział"/>
								<xsl:sort select="Paragraf"/>
								<tr>
									<xsl:choose>
										<xsl:when test="position() != last()">
											<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
												<xsl:value-of select="Dzial"/>
											</td>
											<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
												<xsl:value-of select="Rozdzial"/>
											</td>
											<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
												<xsl:value-of select="concat(Paragraf, P4)"/>
											</td>
											<td class="bottom-normal" style="text-align: left; font-size: 8pt; padding: 3px">
												<xsl:value-of select="Uwagi"/>
											</td>
										</xsl:when>
										<xsl:otherwise>
											<td class="right-normal" style="text-align: center; font-size: 8pt">
												<xsl:value-of select="Dzial"/>
											</td>
											<td class="right-normal" style="text-align: center; font-size: 8pt">
												<xsl:value-of select="Rozdzial"/>
											</td>
											<td class="right-normal" style="text-align: center; font-size: 8pt">
												<xsl:value-of select="concat(Paragraf, P4)"/>
											</td>
											<td style="text-align: left; font-size: 8pt; padding: 3px">
												<xsl:value-of select="Uwagi"/>
											</td>
										</xsl:otherwise>
									</xsl:choose>
								</tr>
							</xsl:for-each>
						</tbody>
					</table>
				</xsl:if>
				<xsl:if test="WydatkiB/Pozycja[child::Uwagi]">
					<table cellpadding="0" cellspacing="0" class="all-bold" style="margin-bottom: 20px; width: 100%">
						<tbody>
							<tr>
								<td colspan="4" style="text-align: center; font-size: 9pt; font-weight: bold; padding: 3px 10px">
									<div>Uwagi do pozycji uzupełniających danych części B</div>
								</td>
							</tr>
							<tr>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 4px 4px 0; width: 6%">Dział</td>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 4px 4px 0; width: 6%">Rozdział</td>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 4px 4px 0; width: 6%">Paragraf</td>
								<td style="text-align: center; font-size: 8pt; font-weight: bold; border-style: solid; border-color: black; border-width: 4px 0 4px 0">Uwaga</td>
							</tr>
							<xsl:for-each select="WydatkiB/Pozycja[child::Uwagi]">
								<xsl:sort select="Dzial"/>
								<xsl:sort select="Rozdział"/>
								<xsl:sort select="Paragraf"/>
								<tr>
									<xsl:choose>
										<xsl:when test="position() != last()">
											<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
												<xsl:value-of select="Dzial"/>
											</td>
											<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
												<xsl:value-of select="Rozdzial"/>
											</td>
											<td class="bottom-right-normal" style="text-align: center; font-size: 8pt">
												<xsl:value-of select="concat(Paragraf, P4)"/>
											</td>
											<td class="bottom-normal" style="text-align: left; font-size: 8pt; padding: 3px">
												<xsl:value-of select="Uwagi"/>
											</td>
										</xsl:when>
										<xsl:otherwise>
											<td class="right-normal" style="text-align: center; font-size: 8pt">
												<xsl:value-of select="Dzial"/>
											</td>
											<td class="right-normal" style="text-align: center; font-size: 8pt">
												<xsl:value-of select="Rozdzial"/>
											</td>
											<td class="right-normal" style="text-align: center; font-size: 8pt">
												<xsl:value-of select="concat(Paragraf, P4)"/>
											</td>
											<td style="text-align: left; font-size: 8pt; padding: 3px">
												<xsl:value-of select="Uwagi"/>
											</td>
										</xsl:otherwise>
									</xsl:choose>
								</tr>
							</xsl:for-each>
						</tbody>
					</table>
				</xsl:if>
				<table cellpadding="0" cellspacing="0" style="margin-bottom: 50px; margin-top: 80px; width: 80%">
					<tbody>
						<tr>
							<td style="text-align:center; font-size: 8pt;" valign="bottom" width="25%">
								<hr style="width: 90%;text-align:center; "/>
								<div style="text-align:center;">Główny księgowy albo Skarbnik</div>
							</td>
							<td/>
							<td style="text-align:center; font-size: 8pt;" valign="bottom" width="25%">
								<hr style="width: 90%;text-align:center"/>
								<div style="text-align:center;">Kierownik jednostki albo Przewodniczący zarządu</div>
							</td>
						</tr>
						<tr>
							<td style="text-align:center; font-size: 8pt;">
								<div>
									<xsl:for-each select="../../Podpisy/*[name() = 'ds:Signature']">
										<xsl:if test="contains(@Id, 'Rb50W')">
											<xsl:if test="contains(translate(*[name() = 'ds:Object']/*[name() = 'xades:QualifyingProperties']/*[name() = 'xades:SignedProperties']/*[name() = 'xades:SignedSignatureProperties']/*[name() = 'xades:SignerRole']/*[name() = 'xades:ClaimedRoles']/*[name() = 'xades:ClaimedRole']/*[name() = 'Role'], 'S','s'),'skarbnik')">
												<xsl:value-of select="substring(*[name() = 'ds:Object']/*[name() = 'xades:QualifyingProperties']/*[name() = 'xades:SignedProperties']/*[name() = 'xades:SignedSignatureProperties']/*[name() = 'xades:SigningTime'], 1, 10)"/>
											</xsl:if>
										</xsl:if>
									</xsl:for-each>
								</div>
							</td>
							<td/>
							<td style="text-align:center; font-size: 8pt;">
								<div>
									<xsl:for-each select="../../Podpisy/*[name() = 'ds:Signature']">
										<xsl:if test="contains(@Id, 'Rb50W')">
											<xsl:if test="contains(translate(*[name() = 'ds:Object']/*[name() = 'xades:QualifyingProperties']/*[name() = 'xades:SignedProperties']/*[name() = 'xades:SignedSignatureProperties']/*[name() = 'xades:SignerRole']/*[name() = 'xades:ClaimedRoles']/*[name() = 'xades:ClaimedRole']/*[name() = 'Role'], 'K','k'),'kierownik')">
												<xsl:value-of select="substring(*[name() = 'ds:Object']/*[name() = 'xades:QualifyingProperties']/*[name() = 'xades:SignedProperties']/*[name() = 'xades:SignedSignatureProperties']/*[name() = 'xades:SigningTime'], 1,10)"/>
											</xsl:if>
										</xsl:if>
									</xsl:for-each>
								</div>
							</td>
						</tr>
					</tbody>
				</table>
			</div>
			<xsl:element name="a">
				<xsl:attribute name="href"><xsl:value-of select="concat('#Jed', $jedIndex)"/></xsl:attribute>
				<xsl:element name="style">
					<xsl:value-of select="'font-family: Verdana'"/>
				</xsl:element>
				<xsl:value-of select="'Powrót do listy sprawozdań jednostki'"/>
			</xsl:element>
		</xsl:element>
	</xsl:template>
	<!-- Rb-50W szablony pomocnicze -->
	<xsl:template match="Rb-50W/Pozycje">
		<xsl:param name="jedIndex"/>
		<xsl:param name="sprIndex"/>
		<xsl:param name="polIndex"/>
		<xsl:for-each select="Pozycja[generate-id(.) = generate-id(key('kluczRb50WDzial', concat(count(ancestor::Jednostka/preceding-sibling::Jednostka), count(ancestor::Rb-50W/preceding-sibling::Rb-50W), Dzial))[1])]">
			<xsl:sort select="Dzial" order="ascending"/>
			<xsl:variable name="obecDzial" select="Dzial"/>
			<xsl:variable name="WezlyDzial" select="/PaczkaSprawozdan/Jednostki/Jednostka[position()=$jedIndex]/Sprawozdania/child::*[position() = $polIndex]/Pozycje/Pozycja[child::Dzial = $obecDzial]"/>
			<xsl:for-each select="$WezlyDzial[generate-id(.) = generate-id(key('kluczRb50WRozdzial', concat(count(ancestor::Jednostka/preceding-sibling::Jednostka), count(ancestor::Rb-50W/preceding-sibling::Rb-50W), Rozdzial))[1])]">
				<xsl:sort select="Rozdzial" order="ascending"/>
				<xsl:variable name="obecRozdzial" select="Rozdzial"/>
				<xsl:variable name="WezlyRozdzial" select="/PaczkaSprawozdan/Jednostki/Jednostka[position()=$jedIndex]/Sprawozdania/child::*[position() = $polIndex]/Pozycje/Pozycja[child::Dzial = $obecDzial and child::Rozdzial = $obecRozdzial]"/>
				<xsl:choose>
					<xsl:when test="translate(string(../../Naglowek/DostepneGrupyParagrafow), 'TRUE', 'true' ) = 'true'">
						<xsl:for-each select="$WezlyRozdzial">
							<xsl:sort select="Rozdzial"/>
							<xsl:sort select="Grupa"/>
							<xsl:sort select="Paragraf"/>
							<xsl:sort select="P4"/>
							<xsl:call-template name="Rb-50W_Pozycje"/>
						</xsl:for-each>
					</xsl:when>
					<xsl:otherwise>
						<xsl:for-each select="$WezlyRozdzial">
							<xsl:sort select="Rozdzial"/>
							<xsl:sort select="Paragraf"/>
							<xsl:sort select="P4"/>
							<xsl:call-template name="Rb-50W_Pozycje"/>
						</xsl:for-each>
					</xsl:otherwise>
				</xsl:choose>
				<tr>
					<td class="bottom-right-mixed" style="text-align:center;font-size:8pt;font-weight:bold">
						<xsl:value-of select="Dzial"/>
					</td>
					<td class="bottom-right-mixed" style="text-align:center;font-size:8pt;font-weight:bold">
						<xsl:value-of select="Rozdzial"/>
					</td>
					<td class="bottom-right-mixed" style="text-align:center;font-size:8pt;"/>
					<td class="bottom-right-mixed" style="text-align:right;font-size: 8pt;padding: 3px">
						<xsl:value-of select="format-number(sum($WezlyRozdzial[string(number(child::P)) != 'NaN']/P), '#&#160;##0,00')"/>
					</td>
					<td class="bottom-right-mixed" style="text-align:right;font-size: 8pt;padding: 3px">
						<xsl:value-of select="format-number(sum($WezlyRozdzial[string(number(child::W)) != 'NaN']/W), '#&#160;##0,00')"/>
					</td>
				</tr>
				<tr>
					<td colspan="11" class="bottom-bold" style="height:20px"/>
				</tr>
			</xsl:for-each>
		</xsl:for-each>
	</xsl:template>
	<xsl:template name="Rb-50W_Pozycje">
		<tr>
			<td class="bottom-right-normal" style="text-align:center;font-size:8pt">
				<xsl:value-of select="Dzial"/>
			</td>
			<td class="bottom-right-normal" style="text-align:center;font-size:8pt">
				<xsl:value-of select="Rozdzial"/>
			</td>
			<td class="bottom-right-normal" style="text-align:center;font-size:8pt;">
				<xsl:choose>
					<xsl:when test="translate(string(../../Naglowek/DostepneGrupyParagrafow), 'TRUE', 'true' ) = 'true'">
						<xsl:choose>
							<xsl:when test="Paragraf">
								<xsl:value-of select="concat(Paragraf, P4)"/>
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="Grupa"/>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="concat(Paragraf, P4)"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
			<td class="bottom-right-normal" style="text-align:right;font-size:8pt;padding: 3px">
				<xsl:choose>
					<xsl:when test="P">
						<xsl:value-of select="format-number(P, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
			<td class="bottom-right-normal" style="text-align:right;font-size:8pt;padding: 3px">
				<xsl:choose>
					<xsl:when test="W">
						<xsl:value-of select="format-number(W, '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
		</tr>
	</xsl:template>
	<xsl:template match="Rb-50W/WydatkiA">
		<xsl:param name="jedIndex"/>
		<xsl:param name="sprIndex"/>
		<xsl:param name="polIndex"/>
		<xsl:for-each select="Pozycja[generate-id(.) = generate-id(key('kluczRb50WwydADzial', concat(count(ancestor::Jednostka/preceding-sibling::Jednostka), count(ancestor::Rb-50W/preceding-sibling::Rb-50W), Dzial))[1])]">
			<xsl:sort select="Dzial" order="ascending"/>
			<xsl:variable name="obecDzial" select="Dzial"/>
			<xsl:variable name="WezlyDzial" select="/PaczkaSprawozdan/Jednostki/Jednostka[position()=$jedIndex]/Sprawozdania/child::*[position() = $polIndex]/WydatkiA/Pozycja[child::Dzial = $obecDzial]"/>
			<xsl:for-each select="$WezlyDzial[generate-id(.) = generate-id(key('kluczRb50WwydARozdzial', concat(count(ancestor::Jednostka/preceding-sibling::Jednostka), count(ancestor::Rb-50W/preceding-sibling::Rb-50W), Rozdzial))[1])]">
				<xsl:sort select="Rozdzial" order="ascending"/>
				<xsl:variable name="obecRozdzial" select="Rozdzial"/>
				<xsl:variable name="WezlyRozdzial" select="/PaczkaSprawozdan/Jednostki/Jednostka[position()=$jedIndex]/Sprawozdania/child::*[position() = $polIndex]/WydatkiA/Pozycja[child::Dzial = $obecDzial and child::Rozdzial = $obecRozdzial]"/>
				<xsl:variable name="Paragrafy" select="$WezlyRozdzial/Paragraf"/>
				<xsl:variable name="P4" select="$WezlyRozdzial/P4"/>
				<xsl:variable name="Licznosc" select="count($WezlyRozdzial)"/>
				<xsl:for-each select="$WezlyRozdzial">
					<tr>
						<td class="bottom-right-normal" style="text-align:center;font-size:8pt">
							<xsl:value-of select="$nbsp"/>
						</td>
						<td class="bottom-right-normal" style="text-align:center;font-size:8pt">
							<xsl:value-of select="Dzial"/>
						</td>
						<td class="bottom-right-normal" style="text-align:center;font-size:8pt">
							<xsl:value-of select="Rozdzial"/>
						</td>
						<td class="bottom-right-normal" style="text-align:center;font-size:8pt;">
							<xsl:value-of select="concat(Paragraf, P4)"/>
						</td>
						<td class="bottom-right-normal" style="text-align:right;font-size:8pt;padding: 3px">
							<xsl:choose>
								<xsl:when test="W">
									<xsl:value-of select="format-number(W, '#&#160;##0,00')"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="'0,00'"/>
								</xsl:otherwise>
							</xsl:choose>
						</td>
					</tr>
				</xsl:for-each>
				<tr>
					<td class="bottom-right-mixed" style="text-align:center;font-size:8pt">
						<xsl:value-of select="$nbsp"/>
					</td>
					<td class="bottom-right-mixed" style="text-align:center;font-size:8pt;font-weight:bold">
						<xsl:value-of select="Dzial"/>
					</td>
					<td class="bottom-right-mixed" style="text-align:center;font-size:8pt;font-weight:bold">
						<xsl:value-of select="Rozdzial"/>
					</td>
					<td class="bottom-right-mixed" style="text-align:center;font-size:8pt;"/>
					<td class="bottom-right-mixed" style="text-align:right;font-size:8pt;padding: 3px">
						<xsl:value-of select="format-number(sum($WezlyRozdzial[string(number(child::W)) != 'NaN']/W), '#&#160;##0,00')"/>
					</td>
				</tr>
				<tr>
					<td colspan="11" class="bottom-bold" style="height:20px"/>
				</tr>
			</xsl:for-each>
		</xsl:for-each>
	</xsl:template>
	<xsl:template match="Rb-50W/WydatkiB">
		<xsl:param name="jedIndex"/>
		<xsl:param name="sprIndex"/>
		<xsl:param name="polIndex"/>
		<xsl:for-each select="Pozycja[generate-id(.) = generate-id(key('kluczRb50WwydBDzial', concat(count(ancestor::Jednostka/preceding-sibling::Jednostka), count(ancestor::Rb-50W/preceding-sibling::Rb-50W), Dzial))[1])]">
			<xsl:sort select="Dzial" order="ascending"/>
			<xsl:variable name="obecDzial" select="Dzial"/>
			<xsl:variable name="WezlyDzial" select="/PaczkaSprawozdan/Jednostki/Jednostka[position()=$jedIndex]/Sprawozdania/child::*[position() = $polIndex]/WydatkiB/Pozycja[child::Dzial = $obecDzial]"/>
			<xsl:for-each select="$WezlyDzial[generate-id(.) = generate-id(key('kluczRb50WwydBRozdzial', concat(count(ancestor::Jednostka/preceding-sibling::Jednostka), count(ancestor::Rb-50W/preceding-sibling::Rb-50W), Rozdzial))[1])]">
				<xsl:sort select="Rozdzial" order="ascending"/>
				<xsl:variable name="obecRozdzial" select="Rozdzial"/>
				<xsl:variable name="WezlyRozdzial" select="/PaczkaSprawozdan/Jednostki/Jednostka[position()=$jedIndex]/Sprawozdania/child::*[position() = $polIndex]/WydatkiB/Pozycja[child::Dzial = $obecDzial and child::Rozdzial = $obecRozdzial]"/>
				<xsl:variable name="Paragrafy" select="$WezlyRozdzial/Paragraf"/>
				<xsl:variable name="P4" select="$WezlyRozdzial/P4"/>
				<xsl:variable name="Licznosc" select="count($WezlyRozdzial)"/>
				<xsl:for-each select="$WezlyRozdzial">
					<tr>
						<td class="bottom-right-normal" style="text-align:center;font-size:8pt">
							<xsl:value-of select="$nbsp"/>
						</td>
						<td class="bottom-right-normal" style="text-align:center;font-size:8pt">
							<xsl:value-of select="Dzial"/>
						</td>
						<td class="bottom-right-normal" style="text-align:center;font-size:8pt">
							<xsl:value-of select="Rozdzial"/>
						</td>
						<td class="bottom-right-normal" style="text-align:center;font-size:8pt;">
							<xsl:value-of select="concat(Paragraf, P4)"/>
						</td>
						<td class="bottom-right-normal" style="text-align:right;font-size:8pt;padding: 3px">
							<xsl:choose>
								<xsl:when test="W">
									<xsl:value-of select="format-number(W, '#&#160;##0,00')"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="'0,00'"/>
								</xsl:otherwise>
							</xsl:choose>
						</td>
					</tr>
				</xsl:for-each>
				<tr>
					<td class="bottom-right-mixed" style="text-align:center;font-size:8pt">
						<xsl:value-of select="$nbsp"/>
					</td>
					<td class="bottom-right-mixed" style="text-align:center;font-size:8pt;font-weight:bold">
						<xsl:value-of select="Dzial"/>
					</td>
					<td class="bottom-right-mixed" style="text-align:center;font-size:8pt;font-weight:bold">
						<xsl:value-of select="Rozdzial"/>
					</td>
					<td class="bottom-right-mixed" style="text-align:center;font-size:8pt;"/>
					<td class="bottom-right-mixed" style="text-align:right;font-size:8pt;padding: 3px">
						<xsl:value-of select="format-number(sum($WezlyRozdzial[string(number(child::W)) != 'NaN']/W), '#&#160;##0,00')"/>
					</td>
				</tr>
				<tr>
					<td colspan="11" class="bottom-bold" style="height:20px"/>
				</tr>
			</xsl:for-each>
		</xsl:for-each>
	</xsl:template>
	<!-- B-Wyk -->
	<xsl:template match="B-Wyk">
		<xsl:param name="jedIndex"/>
		<xsl:param name="sprIndex"/>
		<xsl:element name="div">
			<xsl:attribute name="Id"><xsl:value-of select="concat('Jed', $jedIndex, 'Wer', $sprIndex)"/></xsl:attribute>
			<xsl:attribute name="style"><xsl:value-of select="'display: block; margin-bottom: 40px'"/></xsl:attribute>
			<div style="font-size: 12pt; font-weight: bold; margin-left: 5px; margin-bottom: 10px">
        Sprawozdanie B-Wyk:
        <xsl:choose>
					<xsl:when test="Naglowek/Wersja = 0">
						<xsl:value-of select="'wersja pierwotna'"/>
						<xsl:value-of select="Id"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="concat('korekta nr ', Naglowek/Wersja)"/>
					</xsl:otherwise>
				</xsl:choose>
				<xsl:call-template name="SprNaglowekInfo"/>
			</div>
			<table cellpadding="0" cellspacing="0" class="all-bold" style="margin-bottom: 30px">
				<thead>
					<th style="width:333px"/>
					<th style="width: 56px"/>
					<th style="width: 365px"/>
					<th style="width: 37px"/>
					<th style="width: 265px"/>
				</thead>
				<tbody>
					<tr style="height: 127px">
						<td class="bottom-bold" style="width:333px">
							<table cellpadding="0" cellspacing="0" style="border-collapse: collapse; height" width="100%">
								<tbody>
									<tr style="height: 80px">
										<td style="text-align: left; font-size: 9pt; margin:1px 1px 0 0; padding:0" valign="top">
                      Nazwa i adres jednostki sprawozdawczej
                    </td>
									</tr>
									<tr>
										<td class="bottom-normal" style="text-align: center; font-size: 9pt" valign="bottom">
											<div style="display: block;margin: 0 20px">
												<xsl:choose>
													<xsl:when test="Jednostka/Nazwa">
														<xsl:value-of select="Jednostka/Nazwa"/>
													</xsl:when>
													<xsl:otherwise>
														<xsl:value-of select="../../Nazwa"/>
													</xsl:otherwise>
												</xsl:choose>
											</div>
										</td>
									</tr>
									<tr style="height: 23px">
										<td style="text-align: left; font-size: 9pt; margin:1px 1px 0 0; padding:0;" valign="top">
                      Numer identyfikacyjny REGON
                    </td>
									</tr>
									<tr>
										<td style="text-align: center; font-size: 9pt; font-weight: bold; margin:1px 1px 0 0; padding:0" valign="baseline">
											<xsl:choose>
												<xsl:when test="Jednostka/Regon">
													<xsl:value-of select="Jednostka/Regon"/>
												</xsl:when>
												<xsl:otherwise>
													<xsl:value-of select="../../Regon"/>
												</xsl:otherwise>
											</xsl:choose>
										</td>
									</tr>
								</tbody>
							</table>
						</td>
						<td colspan="3" class="notop-bold" valign="top" style="width: 458px">
							<div style="font-weight: bold; text-align: center; font-size: 11pt">BILANS</div>
							<div style="font-weight: bold; text-align: center; font-size: 11pt">z wykonania budżetu państwa, jednostki samorządu terytorialnego</div>
							<!--<div style="font-weight: bold; text-align: center; font-size: 11pt; margin-bottom: 5px">
								<xsl:choose>
									<xsl:when test="Naglowek/BilansLacznyDla = 'JB'">
										<xsl:value-of select="'jednostki budżetowej'"/>
									</xsl:when>
									<xsl:when test="Naglowek/BilansLacznyDla = 'ZB'">
										<xsl:value-of select="'zakładu budżetowego'"/>
									</xsl:when>
									<xsl:when test="Naglowek/BilansLacznyDla = 'GP'">
										<xsl:value-of select="'gospodarstwa pomocniczego'"/>
									</xsl:when>
									<xsl:otherwise>
									</xsl:otherwise>
								</xsl:choose>
							</div>-->
							<div style="vertical-align: bottom; text-align: center; font-weight: bold; font-size: 9pt; margin-top: 65px">
								<xsl:value-of select="'sporządzony na dzień'"/>
							</div>
							<div style="vertical-align: bottom; text-align: center; font-weight: bold; font-size: 9pt; margin-top: 5px">
								<xsl:value-of select="concat('31-12-', ../../../../Okres/Rok)"/>
							</div>
						</td>
						<td class="bottom-bold" style="text-align: left; font-size: 9pt; margin:2px 2px 0 0; padding:0; width: 265px" valign="top">
							<table cellpadding="0" cellspacing="0" style="border-collapse: collapse; height" width="100%">
								<tbody>
									<tr style="height: 80px">
										<td class="bottom-normal" style="text-align: left; font-size: 9pt; margin:2px 2px 0 0; padding:0" valign="top">
											<div style="margin-bottom:5px">Adresat:</div>
											<!-- popr. nr I.9 -->
											<div style="text-align:center; margin-bottom: 15px;">
												<!-- <xsl:value-of select="'Regionalna Izba Obrachunkowa w Katowicach'"/> -->
											</div>
										</td>
									</tr>
									<tr style="height: 23px">
										<td style="text-align: left; font-size: 9pt; margin:2px 2px 0 0; padding:0;" valign="top">
											<div style="margin-bottom:5px">Wysłać bez pisma przewodniego</div>
											<div style="text-align:center;">
												<!-- <xsl:value-of select="'wersja robocza'"/> -->
											</div>
										</td>
									</tr>
								</tbody>
							</table>
						</td>
					</tr>
					<tr style="height: 20px">
						<td class="bottom-right-bold"/>
						<td colspan="3" class="bottom-right-bold"/>
						<td class="bottom-right-bold"/>
					</tr>
				</tbody>
			</table>
			<div style="display: block; margin-bottom: 40px">
				<table cellpadding="0" cellspacing="0" class="all-bold" style="margin-bottom: 20px">
					<tbody>
						<tr>
							<td style="font-size: 8pt; font-weight: bold; width: 170px; text-align: center" class="bottom-right-mixed">AKTYWA</td>
							<td style="font-size: 8pt; font-weight: bold; width: 170px; text-align: center" class="bottom-right-mixed">Stan na początek roku</td>
							<td style="font-size: 8pt; font-weight: bold; width: 170px; text-align: center" class="bottom-right-bold">Stan na koniec roku</td>
							<td style="font-size: 8pt; font-weight: bold; width: 170px; text-align: center" class="bottom-right-mixed">PASYWA</td>
							<td style="font-size: 8pt; font-weight: bold; width: 170px; text-align: center" class="bottom-right-mixed">Stan na początek roku</td>
							<td style="font-size: 8pt; font-weight: bold; width: 170px; text-align: center" class="bottom-bold">Stan na koniec roku</td>
						</tr>
						<xsl:call-template name="daneAktywaPasywa">
							<xsl:with-param name="symbolAkt" select="'I'"/>
							<xsl:with-param name="wyszczegAkt" select="'Środki pieniężne'"/>
							<xsl:with-param name="symbolPas" select="'I'"/>
							<xsl:with-param name="wyszczegPas" select="'Zobowiązania'"/>
						</xsl:call-template>
						<xsl:call-template name="daneAktywaPasywa">
							<xsl:with-param name="symbolAkt" select="'I.1'"/>
							<xsl:with-param name="wyszczegAkt" select="'Środki pieniężne'"/>
							<xsl:with-param name="symbolPas" select="'I.1'"/>
							<xsl:with-param name="wyszczegPas" select="'Zobowiązania finansowe'"/>
						</xsl:call-template>
						<xsl:call-template name="daneAktywaPasywa">
							<xsl:with-param name="symbolAkt" select="'I.1.1'"/>
							<xsl:with-param name="wyszczegAkt" select="'Środki pieniężne budżetu'"/>
							<xsl:with-param name="symbolPas" select="'I.1.1'"/>
							<xsl:with-param name="wyszczegPas" select="'Krótkoterminowe (do 12 miesięcy)'"/>
						</xsl:call-template>
						<xsl:call-template name="daneAktywaPasywa">
							<xsl:with-param name="symbolAkt" select="'I.1.2'"/>
							<xsl:with-param name="wyszczegAkt" select="'Pozostałe środki pieniężne'"/>
							<xsl:with-param name="symbolPas" select="'I.1.2'"/>
							<xsl:with-param name="wyszczegPas" select="'Długoterminowe (powyżej 12 miesięcy)'"/>
						</xsl:call-template>
						<xsl:call-template name="daneAktywaPasywa">
							<xsl:with-param name="symbolAkt" select="'II'"/>
							<xsl:with-param name="wyszczegAkt" select="'Należności i rozliczenia'"/>
							<xsl:with-param name="symbolPas" select="'I.2'"/>
							<xsl:with-param name="wyszczegPas" select="'Zobowiązania wobec budżetów'"/>
						</xsl:call-template>
						<xsl:call-template name="daneAktywaPasywa">
							<xsl:with-param name="symbolAkt" select="'II.1'"/>
							<xsl:with-param name="wyszczegAkt" select="'Należności finansowe'"/>
							<xsl:with-param name="symbolPas" select="'I.3'"/>
							<xsl:with-param name="wyszczegPas" select="'Pozostałe zobowiązania'"/>
						</xsl:call-template>
						<xsl:call-template name="daneAktywaPasywa">
							<xsl:with-param name="symbolAkt" select="'II.1.1'"/>
							<xsl:with-param name="wyszczegAkt" select="'Krótkoterminowe (do 12 miesięcy)'"/>
							<xsl:with-param name="symbolPas" select="'II'"/>
							<xsl:with-param name="wyszczegPas" select="'Aktywa netto budżetu'"/>
						</xsl:call-template>
						<xsl:call-template name="daneAktywaPasywa">
							<xsl:with-param name="symbolAkt" select="'II.1.2'"/>
							<xsl:with-param name="wyszczegAkt" select="'Długoterminowe (powyżej 12 miesięcy)'"/>
							<xsl:with-param name="symbolPas" select="'II.1'"/>
							<xsl:with-param name="wyszczegPas" select="'Wynik wykonania budżetu (+,-)'"/>
						</xsl:call-template>
						<xsl:call-template name="daneAktywaPasywa">
							<xsl:with-param name="symbolAkt" select="'II.2'"/>
							<xsl:with-param name="wyszczegAkt" select="'Należności od budżetów'"/>
							<xsl:with-param name="symbolPas" select="'II.1.1'"/>
							<xsl:with-param name="wyszczegPas" select="'Nadwyżka budżetu (+)'"/>
						</xsl:call-template>
						<xsl:call-template name="daneAktywaPasywa">
							<xsl:with-param name="symbolAkt" select="'II.3'"/>
							<xsl:with-param name="wyszczegAkt" select="'Pozostałe należności i rozliczenia'"/>
							<xsl:with-param name="symbolPas" select="'II.1.2'"/>
							<xsl:with-param name="wyszczegPas" select="'Deficyt budżetu (-)'"/>
						</xsl:call-template>
						<xsl:call-template name="daneAktywaPasywa">
							<xsl:with-param name="symbolAkt" select="'III'"/>
							<xsl:with-param name="wyszczegAkt" select="'Rozliczenia międzyokresowe'"/>
							<xsl:with-param name="symbolPas" select="'II.1.3'"/>
							<xsl:with-param name="wyszczegPas" select="'Niewykonane wydatki (-)'"/>
						</xsl:call-template>
						<xsl:call-template name="daneAktywaPasywa">
							<xsl:with-param name="symbolPas" select="'II.2'"/>
							<xsl:with-param name="wyszczegPas" select="'Wynik na operacjach niekasowych (+,-)'"/>
						</xsl:call-template>
						<xsl:call-template name="daneAktywaPasywa">
							<xsl:with-param name="symbolPas" select="'II.3'"/>
							<xsl:with-param name="wyszczegPas" select="'Rezerwa na niewygasające wydatki'"/>
						</xsl:call-template>
						<xsl:call-template name="daneAktywaPasywa">
							<xsl:with-param name="symbolPas" select="'II.4'"/>
							<xsl:with-param name="wyszczegPas" select="'Środki z prywatyzacji'"/>
						</xsl:call-template>
						<xsl:call-template name="daneAktywaPasywa">
							<xsl:with-param name="symbolPas" select="'II.5'"/>
							<xsl:with-param name="wyszczegPas" select="'Skumulowany wynik budżetu (+,-)'"/>
						</xsl:call-template>
						<xsl:call-template name="daneAktywaPasywa">
							<xsl:with-param name="symbolPas" select="'III'"/>
							<xsl:with-param name="wyszczegPas" select="'Rozliczenia międzyokresowe'"/>
						</xsl:call-template>
						<tr>
							<td class="bottom-right-mixed"/>
							<td class="bottom-right-mixed"/>
							<td class="bottom-right-bold"/>
							<td class="bottom-right-mixed"/>
							<td class="bottom-right-mixed"/>
							<td class="bottom-bold"/>
						</tr>
						<tr>
							<td class="right-normal" style="text-align: left; padding: 5px; font-size: 10pt; font-weight: bold">Suma aktywów</td>
							<td class="right-normal" style="text-align: right; padding: 5px; font-size: 9pt; font-weight: bold">
								<!--<xsl:value-of select="format-number(sum(Aktywa/Pozycja[string-length(child::Symbol) = 0 and child::Symbol != ' ' and string(number(child::P)) != 'NaN']/P), '#&#160;##0,00')"/>-->
								<!--<xsl:value-of select="format-number(Aktywa/Pozycja"-->
								<xsl:choose>
									<xsl:when test="Aktywa/Pozycja/P">
										<xsl:value-of select="format-number(Aktywa/Pozycja[(string-length(child::Symbol) = 0 or child::Symbol = ' ') and string(number(child::P)) != 'NaN']/P, '#&#160;##0,00')"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="'0,00'"/>
									</xsl:otherwise>
								</xsl:choose>
							</td>
							<td class="right-bold" style="text-align: right; padding: 5px; font-size: 9pt; font-weight: bold">
								<!--<xsl:value-of select="format-number(sum(Aktywa/Pozycja[string-length(child::Symbol) = 0 and child::Symbol != ' ' and string(number(child::K)) != 'NaN']/K), '#&#160;##0,00')"/>-->
								<xsl:value-of select="format-number(Aktywa/Pozycja[(string-length(child::Symbol) = 0 or child::Symbol = ' ') and string(number(child::K)) != 'NaN']/K, '#&#160;##0,00')"/>
							</td>
							<td class="right-normal" style="text-align: left; padding: 5px; font-size: 10pt; font-weight: bold">Suma pasywów</td>
							<td class="right-normal" style="text-align: right; padding: 5px; font-size: 9pt; font-weight: bold">
								<!--<xsl:value-of select="format-number(sum(Pasywa/Pozycja[string-length(child::Symbol) = 0 and child::Symbol != ' ' and string(number(child::P)) != 'NaN']/P), '#&#160;##0,00')"/>-->
								<xsl:value-of select="format-number(Pasywa/Pozycja[(string-length(child::Symbol) = 0 or child::Symbol = ' ') and string(number(child::P)) != 'NaN']/P, '#&#160;##0,00')"/>
							</td>
							<td style="text-align: right; padding: 5px; font-size: 9pt; font-weight: bold">
								<!--<xsl:value-of select="format-number(sum(Pasywa/Pozycja[string-length(child::Symbol) = 0 and child::Symbol != ' ' and string(number(child::K)) != 'NaN']/K), '#&#160;##0,00')"/>-->
								<xsl:value-of select="format-number(Pasywa/Pozycja[(string-length(child::Symbol) = 0 or child::Symbol = ' ') and string(number(child::K)) != 'NaN']/K, '#&#160;##0,00')"/>
							</td>
						</tr>
					</tbody>
				</table>
			</div>
			<!-- <xsl:call-template name="B-Wyk_daneUzupelnienieTabela"/> -->
			<table cellpadding="0" cellspacing="0" class="all-bold" style="margin-bottom: 20px; width: 100%">
				<tbody>
					<tr style="height: 30px" valign="top">
						<td colspan="4" class="bottom-bold" style="font-size: 9pt; font-weight: bold; text-align:left; padding: 3px 10px; margin-left: 5px; margin-bottom: 25px">Wyjaśnienia do sprawozdania B-Wyk</td>
					</tr>
					<tr style="min-height: 50px; height: 70px" valign="top">
						<td colspan="4" style="text-align: left; font-size: 8pt; padding: 3px 10px">
							<xsl:value-of select="Naglowek/Uwagi"/>
						</td>
					</tr>
				</tbody>
			</table>
			<xsl:if test="Aktywa/Pozycja[Uwagi]">
				<table cellpadding="0" cellspacing="0" class="all-bold" style="margin-bottom: 20px; width: 100%">
					<tbody>
						<tr>
							<td colspan="3" class="bottom-right-bold" style="font-size: 9pt; font-weight: bold; text-align: center">Uwagi do pozycji "Aktywa"</td>
						</tr>
						<tr>
							<td style="font-size: 8pt; font-weight: bold; width: 70px; text-align: center" class="bottom-right-bold">Symbol</td>
							<td style="font-size: 8pt; font-weight: bold; width: 220px; text-align: center" class="bottom-right-bold">Wyszczególnienie</td>
							<td style="font-size: 8pt; font-weight: bold; width: 800px; text-align: center" class="bottom-bold">Uwaga</td>
						</tr>
						<xsl:for-each select="Aktywa/Pozycja[Uwagi]">
							<xsl:sort select="Symbol"/>
							<tr>
								<xsl:choose>
									<xsl:when test="position() != last()">
										<td class="bottom-right-normal" style="text-align: center; font-size: 8pt; padding: 3px">
											<xsl:value-of select="Symbol"/>
										</td>
										<td class="bottom-right-normal" style="text-align: left; font-size: 8pt; padding: 3px">
											<xsl:choose>
												<xsl:when test="Opis">
													<xsl:value-of select="Opis"/>
												</xsl:when>
												<xsl:otherwise>
													<xsl:call-template name="B-Wyk_Symbol_Opis_Aktywa">
														<xsl:with-param name="symbol" select="Symbol"/>
													</xsl:call-template>
												</xsl:otherwise>
											</xsl:choose>
										</td>
										<td class="bottom-normal" style="text-align: left; font-size: 8pt; padding: 3px">
											<xsl:value-of select="Uwagi"/>
										</td>
									</xsl:when>
									<xsl:otherwise>
										<td class="right-normal" style="text-align: center; font-size: 8pt; padding: 3px">
											<xsl:value-of select="Symbol"/>
										</td>
										<td class="right-normal" style="text-align: left; font-size: 8pt; padding: 3px">
											<xsl:choose>
												<xsl:when test="Opis">
													<xsl:value-of select="Opis"/>
												</xsl:when>
												<xsl:otherwise>
													<xsl:call-template name="B-Wyk_Symbol_Opis_Aktywa">
														<xsl:with-param name="symbol" select="Symbol"/>
													</xsl:call-template>
												</xsl:otherwise>
											</xsl:choose>
										</td>
										<td class="right-normal" style="text-align: left; font-size: 8pt; padding: 3px">
											<xsl:value-of select="Uwagi"/>
										</td>
									</xsl:otherwise>
								</xsl:choose>
							</tr>
						</xsl:for-each>
					</tbody>
				</table>
			</xsl:if>
			<xsl:if test="Pasywa/Pozycja[Uwagi]">
				<table cellpadding="0" cellspacing="0" class="all-bold" style="margin-bottom: 30px; width: 100%">
					<tbody>
						<tr>
							<td colspan="3" class="bottom-right-bold" style="font-size: 9pt; font-weight: bold; text-align: center">Uwagi do pozycji "Pasywa"</td>
						</tr>
						<tr>
							<td style="font-size: 8pt; font-weight: bold; width: 70px; text-align: center" class="bottom-right-bold">Symbol</td>
							<td style="font-size: 8pt; font-weight: bold; width: 220px; text-align: center" class="bottom-right-bold">Wyszczególnienie</td>
							<td style="font-size: 8pt; font-weight: bold; width: 800px; text-align: center" class="bottom-bold">Uwaga</td>
						</tr>
						<xsl:for-each select="Pasywa/Pozycja[Uwagi]">
							<xsl:sort select="Symbol"/>
							<tr>
								<xsl:choose>
									<xsl:when test="position() != last()">
										<td class="bottom-right-normal" style="text-align: center; font-size: 8pt; padding: 3px">
											<xsl:value-of select="Symbol"/>
										</td>
										<td class="bottom-right-normal" style="text-align: left; font-size: 8pt; padding: 3px">
											<xsl:choose>
												<xsl:when test="Opis">
													<xsl:value-of select="Opis"/>
												</xsl:when>
												<xsl:otherwise>
													<xsl:call-template name="B-Wyk_Symbol_Opis_Pasywa">
														<xsl:with-param name="symbol" select="Symbol"/>
													</xsl:call-template>
												</xsl:otherwise>
											</xsl:choose>
										</td>
										<td class="bottom-normal" style="text-align: left; font-size: 8pt; padding: 3px">
											<xsl:value-of select="Uwagi"/>
										</td>
									</xsl:when>
									<xsl:otherwise>
										<td class="right-normal" style="text-align: center; font-size: 8pt; padding: 3px">
											<xsl:value-of select="Symbol"/>
										</td>
										<td class="right-normal" style="text-align: left; font-size: 8pt; padding: 3px">
											<xsl:choose>
												<xsl:when test="Opis">
													<xsl:value-of select="Opis"/>
												</xsl:when>
												<xsl:otherwise>
													<xsl:call-template name="B-Wyk_Symbol_Opis_Pasywa">
														<xsl:with-param name="symbol" select="Symbol"/>
													</xsl:call-template>
												</xsl:otherwise>
											</xsl:choose>
										</td>
										<td class="right-normal" style="text-align: left; font-size: 8pt; padding: 3px">
											<xsl:value-of select="Uwagi"/>
										</td>
									</xsl:otherwise>
								</xsl:choose>
							</tr>
						</xsl:for-each>
					</tbody>
				</table>
			</xsl:if>
			<table cellpadding="0" cellspacing="0" style="margin-bottom: 50px; margin-top: 80px; width: 100%">
				<tbody>
					<tr>
						<td style="text-align:center; font-size: 8pt;" valign="bottom">
							<hr style="width: 80%"/>
							<div style="margin-left:10px">główny księgowy</div>
						</td>
						<td style="text-align:center; font-size: 8pt;" valign="bottom">
							<div>
								<xsl:value-of select="Naglowek/DataSprawozdania"/>
							</div>
							<hr style="width: 80%"/>
							<div>(rok m-c dzień)</div>
						</td>
						<td style="text-align:center; font-size: 8pt;" valign="bottom">
							<hr style="width: 80%"/>
							<div>kierownik jednostki</div>
						</td>
					</tr>
				</tbody>
			</table>
			<xsl:element name="a">
				<xsl:attribute name="href"><xsl:value-of select="concat('#Jed', $jedIndex)"/></xsl:attribute>
				<xsl:element name="style">
					<xsl:value-of select="'font-family: Verdana'"/>
				</xsl:element>
				<xsl:value-of select="'Powrót do listy sprawozdań jednostki'"/>
			</xsl:element>
		</xsl:element>
	</xsl:template>
	<!-- B-Wyk szablony pomocnicze -->
	<!-- Template wywoływany w "B-Wyk_daneUzupelnienieTabela" -->
	<xsl:template name="B-Wyk_daneUzupelnienieStale">
		<xsl:param name="symbolUzupelnieniaStalego"/>
		<xsl:param name="opisUzupelnieniaStalego"/>
		<tr>
			<td class="bottom-right-normal" style="text-align: left; font-size: 8pt; padding: 3px">
				<xsl:value-of select="$symbolUzupelnieniaStalego"/>
			</td>
			<td class="bottom-right-normal" style="text-align: left; font-size: 8pt; padding: 3px">
				<xsl:value-of select="$opisUzupelnieniaStalego"/>
			</td>
			<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; padding: 3px">
				<xsl:choose>
					<xsl:when test="UzupelnienieStale/Pozycja[child::Symbol = $symbolUzupelnieniaStalego]/Wartosc">
						<xsl:value-of select="format-number(UzupelnienieStale/Pozycja[child::Symbol = $symbolUzupelnieniaStalego]/Wartosc,  '#&#160;##0,00')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'0,00'"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
		</tr>
	</xsl:template>
	<xsl:template name="B-Wyk_daneUzupelnienieTabela">
		<div style="margin-bottom: 5px; font-weight: bold; font-size: 12px">Informacje uzupełniające:</div>
		<table cellpadding="0" cellspacing="0" class="all-bold" style="margin-bottom: 60px">
			<thead>
				<tr>
					<td style="font-size: 8pt; font-weight: bold; width: 80px; text-align: center" class="bottom-right-bold">Symbol</td>
					<td style="font-size: 8pt; font-weight: bold; width: 800px; text-align: center" class="bottom-right-bold">Opis</td>
					<td style="font-size: 8pt; font-weight: bold; width: 160px; text-align: center" class="bottom-bold">Wartość</td>
				</tr>
			</thead>
			<tbody>
				<xsl:call-template name="B-Wyk_daneUzupelnienieStale">
					<xsl:with-param name="symbolUzupelnieniaStalego" select="'1'"/>
					<xsl:with-param name="opisUzupelnieniaStalego" select="'Udzielone gwarancje i poręczenia'"/>
				</xsl:call-template>
				<xsl:call-template name="B-Wyk_daneUzupelnienieStale">
					<xsl:with-param name="symbolUzupelnieniaStalego" select="'2'"/>
					<xsl:with-param name="opisUzupelnieniaStalego" select="'Otrzymane gwarancje i poręczenia'"/>
				</xsl:call-template>
				<xsl:call-template name="B-Wyk_daneUzupelnienieStale">
					<xsl:with-param name="symbolUzupelnieniaStalego" select="'3'"/>
					<xsl:with-param name="opisUzupelnieniaStalego" select="'Inne informacje istotne dla rzetelności i przejrzystości budżetu'"/>
				</xsl:call-template>
				<xsl:for-each select="Uzupelnienie/Pozycja">
					<tr>
						<td class="bottom-right-normal" style="text-align: left; font-size: 8pt; padding: 3px">
							<div>
								<xsl:value-of select="Symbol"/>
							</div>
						</td>
						<td class="bottom-right-normal" style="text-align: left; font-size: 8pt; padding: 3px">
							<div>
								<xsl:value-of select="Opis"/>
							</div>
						</td>
						<td class="bottom-right-normal" style="text-align: right; font-size: 8pt; padding: 3px">
							<div>
								<xsl:choose>
									<xsl:when test="Wartosc">
										<xsl:value-of select="format-number(Wartosc, '#&#160;##0,00')"/>
									</xsl:whe